var app = getApp()
Page({
    data:{
        order:[],
		orderinfo:[],
        paySuccessUrl:'',
		orderid:'',
		module_name:'',
		title:'',
		userInfo:'',
		nodatapic_close:true,
    },
	onPullDownRefresh: function (){
		var the=this;
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
    onLoad:function(options){
		//console.log('options');console.log(options);
        var that = this
		var fee = options.fee;
        var orderid = parseInt(options.id);
		var module_name = options.plugin;
		var title = options.title;
		var e = options;
		var paySuccessUrl =options.paySuccessUrl;
		if(!paySuccessUrl){
			paySuccessUrl = '/pages/index/index';
		}
		that.orderinfo(orderid);
		that.setData({
				paySuccessUrl:paySuccessUrl,
				orderid:orderid,
				module_name:module_name,
				title:title
		});
    },
	orderinfo:function(orderid){
		var that = this
		app.util.request({
		  'data': {
				'plugin':'core',
				'action':'pay',
				'op':'pay',
				'id':orderid,
			},
		  'cachetime': '30',
		  success(res) {
			   //console.log('res222');console.log(res);
				if (res.errno != 1) {
					 that.setData({
						orderinfo: res
					});
				}else{
					wx.showModal({
							title: res.message,
							content : title,
							showCancel : false,
							complete : function() {
								
							}
					})
				}
		  },
		  error: function (err) {
                console.log(err);
          }
		});
	},
	credit: function(e) {
		var the = this
		wx.showModal({
		  content: "确认要支付吗？",
		  confirmText: "确定",
		  cancelText: "取消",
		  success : function() {
			 the.creditup(e);
		  }
		})
	},
	creditup: function(e) {
		var the = this
		var orderid = the.data.orderid
		app.util.post({
			'paoq':'core/pay/credit',
			'data':{'id':orderid},
			'callback':function(res){
				//console.log('res');console.log(res);
				if (res.message == 'success'){
					 wx.showToast({
							title: '付款成功！',
							icon: 'success',
							duration: 500,
							mask: true,
							success : function() {
									wx.redirectTo({
										 'url': the.data.paySuccessUrl
									});
							}
					})
				}else{
					wx.showModal({
						title: '付款失败！',
						content: res.message,
						icon: 'error',
						duration: 500,
						mask: true
					 })
				}
			}
		});
	},
	wechat: function(e) {
		var the = this
		var orderid = the.data.orderid
		the.pay(orderid);
	},
	pay:function(orderid){
		var that = this
		var title = that.data.title;
		var openid = wx.getStorageSync('openid');
		console.log(orderid);
		console.log(openid);
		app.util.request({
		  'data': {
				'plugin':'core',
				'action':'pay',
				'op':'wxapp_pay',
				'module_name':that.data.module_name,
				'orderid': orderid,
				'openid': openid,
				'direct':true,
				'title': title
			},
		  'cachetime': '30',
		  success(res) {
			if (!res.errno) {
				 that.setData({
					info: res
				});
				that.pay_result();
			}else{
				wx.showModal({
						title: res.message,
						content : title,
						showCancel : false,
						complete : function() {
							
						}
				})
			  }
		  },
		  error: function (err) {
                console.log(err);
          }
		});
	},
	pay_result:function(){
		var that = this
		var orderid = that.data.orderid
		var openid = wx.getStorageSync('openid');
		console.log('info');console.log(that.data.info);
		if(that.data.info.message){
				wx.showModal({
					title: '支付失败！',
					content: that.data.info.message,
					showCancel : false,
					complete : function() {	
					}
				})
		}
		var options = {};
			options = {
				'plugin':'core',
				'action':'pay',
				'op':'wxapp_result',
				'module_name':that.data.module_name,
				'orderid': orderid,
				'openid': openid,
				'direct':true,
				'type':'wechat',
			};
		if (orderid && that.data.info) {
			if(that.data.info.type == 'error'){
				wx.showModal({
					title: '支付失败！',
					content: that.data.info.message,
					showCancel : false,
					complete : function() {	
					}
				})
			}else{
				if(that.data.info.wechat.success){
					wx.requestPayment({
						  'timeStamp': that.data.info.wechat.payinfo.timeStamp,
						  'nonceStr': that.data.info.wechat.payinfo.nonceStr,
						  'package': that.data.info.wechat.payinfo.package,
						  'signType': that.data.info.wechat.payinfo.signType,
						  'paySign': that.data.info.wechat.payinfo.paySign,
						  'success': function (data) {
							app.util.request({
								'data': options,
								'cachetime': '0',
								'success': function (res) {
									console.log('支付成功');
									console.log(res);
									if(true){
										wx.redirectTo({
										  'url': the.data.paySuccessUrl
										});
									}else{
										wx.showModal({
											title: res.message,
											showCancel : false,
											complete : function() {
													
											}
										})
									}
								}
							});
						  },
						  'fail': function (res) {
							wx.showModal({
								title: res.err_desc,
								showCancel : false,
								complete : function() {
									
								}
							})
						  }
					})
				}else{
					wx.showModal({
							title: that.data.info.wechat.payinfo.message,
							showCancel : false,
							complete : function() {
									
							}
					})
				}
			}
		}
    },
})