var app = getApp()
Page({
    data:{
        order:[],
		info:[],
        paySuccessUrl:'',
		orderid:'',
		module_name:'',
		title:'',
		userInfo:'',
		nodatapic_close:true,
    },
	onPullDownRefresh: function (){
		var the=this;
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
    onLoad:function(options){
        var that = this
		console.log('options');console.log(options);
        var orderid = parseInt(options.orderid);
		var module_name = options.module_name;
		var title = options.title;
		var e = options;
		var paySuccessUrl =options.paySuccessUrl;
		if(!paySuccessUrl){
			paySuccessUrl = '/pages/index/index';
		}
		that.pay(options);
		that.setData({
				paySuccessUrl:paySuccessUrl,
				orderid:orderid,
				module_name:module_name,
				p_url:options.p_url,
				r_url:options.r_url,
				m_type:options.m_type,
				title:title
		});
    },
	pay:function(options){
		var that = this
		var orderid = parseInt(options.orderid);
		var module_name = options.module_name;
		var title = options.title;
		var openid = wx.getStorageSync('openid');
		console.log(orderid);
		console.log(openid);
		if(options.m_type){
			options = {
				'module_name':options.module_name,
				'orderid': orderid,
				'openid':openid,
				'title': title,
				'direct':true,
				'p_url':options.p_url,
				'm_type':options.m_type,
			};
		}else{
			options = {
				'plugin':'core',
				'action':'pay',
				'op':'wxapp_pay',
				'module_name':options.module_name,
				'orderid': orderid,
				'openid': openid,
				'direct':true,
				'title': title
			};
		}
		app.util.request({
		  'url':app.setting.index_url,
		  'data': options,
		  'cachetime': '30',
		  success(res) {
					if (res.type !='error') {
				 that.setData({
							info: res.message
				});
				that.pay_result();
			}else{
				wx.showModal({
								title: '付款失败！',
								content : res.message,
								showCancel : false,
								complete : function() {
									
								}
						})
					}
		  },
		  error: function (err) {
                console.log(err);
          }
		});
	},
	pay_result:function(e){
		var that = this
		var orderid = that.data.orderid
		var openid = wx.getStorageSync('openid');
		console.log('info');console.log(that.data.info);
		if(that.data.info.type == 'error'){
				wx.showModal({
					title: '支付失败！',
					content: that.data.info.message,
					showCancel : false,
					complete : function() {	
					}
				})
		}
		var options = {};
		if(that.data.m_type){
			options = {
				'module_name':that.data.module_name,
				'orderid': orderid,
				'openid':openid,
				'direct':true,
				'r_url':that.data.r_url,
				'type':'wechat',
				'm_type':that.data.m_type,
			};
		}else{
			options = {
				'plugin':'core',
				'action':'pay',
				'op':'wxapp_result',
				'module_name':that.data.module_name,
				'orderid': orderid,
				'openid': openid,
				'direct':true,
				'type':'wechat',
			};
		}
		if (orderid && that.data.info) {
			if(that.data.info.type == 'error'){
				wx.showModal({
					title: '支付失败！',
					content: that.data.info.message,
					showCancel : false,
					complete : function() {	
					}
				})
			}else{
				if(that.data.info.wechat.success){
					wx.requestPayment({
						  'timeStamp': that.data.info.wechat.payinfo.timeStamp,
						  'nonceStr': that.data.info.wechat.payinfo.nonceStr,
						  'package': that.data.info.wechat.payinfo.package,
						  'signType': that.data.info.wechat.payinfo.signType,
						  'paySign': that.data.info.wechat.payinfo.paySign,
						  'success': function (data) {
							app.util.request({
								'url':app.setting.index_url,
								'data': options,
								'cachetime': '0',
								'success': function (res) {
									console.log('支付成功');
									console.log(res);
									if(true){
										wx.redirectTo({
										  'url': the.data.paySuccessUrl
										});
									}else{
										wx.showModal({
											title: res.message,
											showCancel : false,
											complete : function() {
													
											}
										})
									}
								}
							});
						  },
						  'fail': function (res) {
							wx.showModal({
								title: res.err_desc,
								showCancel : false,
								complete : function() {
									
								}
							})
						  }
					})
				}else{
					wx.showModal({
							title: that.data.info.wechat.payinfo.message,
							showCancel : false,
							complete : function() {
									
							}
					})
				}
			}
		}
    },
})