//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		syscolor:app.setting.syscolor,
		isnodata:false,
		account:app.setting.account,
		show_coupon:true,
		page:1,
		countDown:[],
		numbers:[],
		pagetitle:'活动页面' + '-' + app.setting.title,
		
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var page=this;
		var diydata='';
		var footer='';
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		var route=page.route;
		page.setData({
			route:route,
		});
		if(opt.isgoshare){
				page.setData({
					ShowGoshare:true,
				});
			}
		if(!app.plugin_name){
			var path=route.slice(0,-6).split('/');
			app.plugin_name=path.shift();
		}
		//首页必须指定路径
		app.access.plugin=app.plugin_name;
		app.access.action='activity';
		app.access.op='';
		if(opt.fromuser){
			app.access.query =app.util.made_query(opt);
		}
		app.util.get(app.access,function(pagedata){
			//console.log('index');console.log(pagedata);
			pagedata.params=pagedata.params?pagedata.params:{'order':'ishot'}
			pagedata.issocketmsg=false;
			page.setData({
				pluginnav:app.session.menus,
				pagedata:pagedata,
				action:'jy_weishop/activity/',
				diydata:diydata,
				footer:footer,
				root:''
			});
			//获取弹幕
			page.gettanmus();
			setTimeout(()=>{page.get_list();},500);
		});
	},
	get_list:function(e){
		var the=this;
		var page = the.data.page
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		if(e){
			if(e.currentTarget){
				var data=e.currentTarget.dataset;
				if(data.type=='price'){
					pagedata.params.order='price';
					pagedata.params.order_type=pagedata.params.order_type?0:1;
				}else if(data.type=='sales'){
					pagedata.params.order='sales';
				}else if(data.type=='ishot'){
					pagedata.params.order='ishot';
				}else{
					pagedata.params.order='default';
				}
				if(data.pid){
					pagedata.params.pcate=data.pid
					pagedata.params.pid=data.pid
				}
			}
			page = 1;
			pagedata.list=[];
			isnodata=false;
		}else{
			if(isnodata){
				return false;
			}
		}
		var query='page='+page;
		var more_query=app.util.made_query(pagedata.params);
		if(more_query){
			query+='&'+more_query;
		}
		app.util.get('jy_weishop/goods.index/getlist/'+query,function(res){
			//console.log('query');console.log(pagedata.params);
			if(res=='none'){
				the.setData({
					isnodata:true,
					'pagedata.params':pagedata.params,
					'pagedata.list':pagedata.list,
				});
			}else{
				pagedata.list = pagedata.list.concat(res)
				page++
				the.setData({
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
					page:page,
					isnodata:isnodata,
					loading:false,
				});
				for(var i=0;i<pagedata.list.length;i++){
					if(pagedata.list[i].active.rest_time2){
						the.endDown(pagedata.list[i].active.rest_time2,i);
					}
				}
			}
		});
	},
	//翻页
	onReachBottom: function () {
		var the=this;
		var isnodata=the.data.isnodata
		var loading=the.data.loading
		if(!isnodata && !loading){
			the.get_list()
		}
	},
	scanCode: function(){
		wx.scanCode({
		  success (res) {
			 wx.navigateTo({'url':res.path});
		  }
		})
	},
	bindclosed:function(){
		this.setData({
			closed:1
		});
	},
	closed_coupon:function(){
		this.setData({
			show_coupon:false
		});
	},
	addtocart:function(e){
		var data=e.currentTarget.dataset;
		app.util.post('jy_weishop/goods.detail/addtocart/',data);
	},
	closedsales:function(evt){
		var the=this;
		var pagedata=the.data.pagedata
		pagedata.closedsales=pagedata.closedsales!=1?1:0;
		the.setData({
			'pagedata.closedsales':pagedata.closedsales
		})
	},
	gettanmus:function() {
		var the=this;
		var pagedata=the.data.pagedata
		if(!pagedata.issocketmsg){
				app.util.get('jy_weishop/get_data/gettanmus/page='+pagedata.tanmuspage,function(res){
							pagedata.tanmus=res.list
							if(pagedata.tanmus.length>0){
								pagedata.tanmuspage++;
								pagedata.nowmsgid=0;
								the.setData({
									'pagedata.issocketmsg':pagedata.issocketmsg,
									'pagedata.tanmus':pagedata.tanmus,
									'pagedata.nowmsgid':pagedata.nowmsgid
								})
								the.up_oldtanmu();
							}
				});
		}
	},
	up_oldtanmu:function() {
		var the=this;
		var pagedata=the.data.pagedata
		var i=pagedata.nowmsgid;
		if(i<pagedata.tanmus.length){
				the.set_tanmu(pagedata.tanmus[i].nickname,pagedata.tanmus[i].avatar,pagedata.tanmus[i].time);
		}else{
				the.gettanmus();
		}
	},
	set_tanmu:function(nickname,avatar,time) {
		var the=this;
		var pagedata=the.data.pagedata
		pagedata.nowmsgid++
		the.setData({
				showtanmus:true,
		})
		setTimeout(function(){
			the.setData({
				transition:true,
			})	
		},300);
		setTimeout(function(){
			the.setData({
				showtanmus:false,
			})	
		},2000);
		setTimeout(function(){
			//等待5秒，如果没有新的订单消息，就弹储备订单消息
			pagedata.issocketmsg=pagedata.issocketmsg?pagedata.issocketmsg:false;
			the.setData({
				'pagedata.issocketmsg':pagedata.issocketmsg,
				'pagedata.nowmsgid':pagedata.nowmsgid,
				transition:false
			})
			if(!pagedata.issocketmsg){
				the.up_oldtanmu();
			}
		},4000);
	},
	num:function(num) {
		return num < 10 ? `0${num}` : `${num}`;
	},
	endDown:function(rest_time,index) {
		var the=this;
		var pagedata = the.data.pagedata
		var sys_second = rest_time;
		var countDown = the.data.countDown
		var numbers=the.data.numbers
		for(var i=0;i<numbers.length;i++){
			clearInterval(numbers[i].id);
		}	
		the.data.countInterval = setInterval(function(res){
			sys_second -= 1;
			if (sys_second <= 0) {
				clearInterval(the.data.countInterval);
				the.getactive();
			}
			
			let day = 0;
			let hour = 0;
			let minute = 0;
			let second = 0;

			const DMS = 24 * 60 * 60;
			day = the.num(Math.floor(sys_second / DMS));
			//console.log('day');console.log(day);
			const h1 = sys_second / 3600;
			const h2 = day * 24;
			hour = the.num(Math.floor(h1 - h2));

			const m1 = sys_second / 60;
			const m2 = day * 24 * 60;
			const m3 = hour * 60;
			minute = the.num(Math.floor(m1 - m2 - m3));

			const s1 = day * 24 * 3600;
			const s2 = hour * 3600;
			const s3 = minute * 60;
			second = the.num(Math.floor(sys_second - s1 - s2 - s3));
			  
			countDown[index] = {}
			countDown[index].hour = hour
			countDown[index].minute = minute
			countDown[index].second = second
			numbers = numbers.concat({'id':the.data.countInterval})
			the.setData({
				countDown : countDown,
				numbers:numbers
			});
			if (sys_second < 0) {
				clearInterval(the.data.countInterval);
				countDown[index].day = '00'
				countDown[index].hour = '00'
				countDown[index].minute = '00'
				countDown[index].second = '00'
				the.setData({
				  countInterval:null,
				  countDown: countDown
				});
			}
		}, 1000);
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	formSubmit:function(event){
		var data=event.detail.value;
		app.util.post('post',data);
	},
	click_tab:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util.tab(data.params);
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});