/**
 * 会员中心
 */
var app = getApp()
Page({
	data: {
		root:app.setting.att_url,
		pagedata:[],
		action: '',
		pagetitle:'优惠券详情' + '-' + app.setting.title,
		bannerHeight: Math.ceil(290.0 / 750.0 * getApp().screenWidth)
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var the = this;
		wx.setNavigationBarTitle({'title':the.data.pagetitle});
		var route=the.route;
		the.setData({
			route:route,
		});
		if(opt.isgoshare){
				the.setData({
					ShowGoshare:true,
				});
			}
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		app.util.get(app.access,function(pagedata){
			console.log(pagedata);
			the.setData({
				pagedata:pagedata,
				loading:false
			});
		});
	},
	set: function (e) {
		var data = e.currentTarget.dataset;
		app.util.post('tx',data);
	},
	addwxcard: function (e) {
		var data = e.currentTarget.dataset;
		wx.addCard({
			cardList: [
				{
				  cardId: data.card_id,
				  cardExt: data.cardExt
				},
			],
			success(res) {
				app.util.message('添加成功!');
			}
		})
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	  post:function(){
		var page = this
		var pagedata = page.data.pagedata
		app.util.post('getcoupon', { id: pagedata.coupon.id })
	  },
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
})