/**
 * 会员中心
 */
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		syscolor:app.setting.syscolor,
		isnodata:false,
		account:app.setting.account,
		pagetitle:'优惠券' + '-' + app.setting.title,
		countDown:[],
		bannerHeight: Math.ceil(290.0 / 750.0 * getApp().screenWidth)
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var the = this;
		wx.setNavigationBarTitle({'title':the.data.pagetitle});
		var route=the.route;
		the.setData({
			route:route,
		});
		if(opt.isgoshare){
				the.setData({
					ShowGoshare:true,
				});
			}
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		app.util.get(app.access,function(pagedata){
			console.log(pagedata);
			for(var i=0;i<pagedata.list.length;i++){
				if(pagedata.list[i].issendtime && pagedata.list[i].issend !=2){
					the.endDown(pagedata.list[i].id,pagedata.list[i].etime,pagedata.ntime);
				}
			}
			pagedata.iscouponindex=1;
			the.setData({
				pagedata:pagedata,
				loading:false
			});
		});
	},
	set: function (e) {
		var data = e.currentTarget.dataset;
		app.util.post('jy_weishop/coupon.index/tx/',data);
	},
	coupon:function(e){
		var the=this
		var data = e.currentTarget.dataset;
		app.util.get('/coupon.index/main/coupontype='+data.coupontype,function(res){
			res.iscouponindex=1;
			the.setData({
				pagedata:res,
				loading:false
			});
		});
	},
	addwxcard: function (e) {
		var data = e.currentTarget.dataset;
		wx.addCard({
			cardList: [
				{
				  cardId: data.card_id,
				  cardExt: data.cardExt
				},
			],
			success(res) {
				app.util.message('添加成功!');
			}
		})
	},
	num:function(num) {
		return num < 10 ? `0${num}` : `${num}`;
	},
	endDown:function(id,etime, ntime) {
		var the=this;
		var pagedata = the.data.pagedata
		var now_time = ntime * 1000;
		var end_time = etime * 1000;
		var native_time = new Date().getTime();
		var now_cha = now_time - native_time;       //服务器和本地时间差
		var native_end_time = end_time - now_cha;   //本地结束时间
		var sys_second = 0;
		var countDown = the.data.countDown
		the.data.countInterval = setInterval(() => {
			sys_second = (native_end_time - new Date().getTime()) / 1000; //本地结束剩余时间
			sys_second -= 1;
			if (sys_second <= 0 || !the.data.pagedata.iscouponindex) {
				clearInterval(the.data.countInterval);
			}
			
			let day = 0;
			let hour = 0;
			let minute = 0;
			let second = 0;

			const DMS = 24 * 60 * 60;
			day = the.num(Math.floor(sys_second / DMS));
			//console.log('day');console.log(day);
			const h1 = sys_second / 3600;
			const h2 = day * 24;
			hour = the.num(Math.floor(h1 - h2));

			const m1 = sys_second / 60;
			const m2 = day * 24 * 60;
			const m3 = hour * 60;
			minute = the.num(Math.floor(m1 - m2 - m3));

			const s1 = day * 24 * 3600;
			const s2 = hour * 3600;
			const s3 = minute * 60;
			second = the.num(Math.floor(sys_second - s1 - s2 - s3));
			  
			countDown[id] = {}
			countDown[id].day = day
			countDown[id].hour = hour
			countDown[id].minute = minute
			countDown[id].second = second
			the.setData({
				countDown : countDown
			});


			if (sys_second < 0) {
				clearInterval(the.data.countInterval);
				countDown[id].day = '00'
				countDown[id].hour = '00'
				countDown[id].minute = '00'
				countDown[id].second = '00'				
				the.setData({
				  countInterval:null,
				  countDown: countDown
				});
			}
		}, 1000);
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
})