//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		account:app.setting.account,
		loading:true,
		isnodata:false,
		page:1,
		showfilter:false,
		pagedata:[],
		showgotop:true,
		pagetitle:'商品列表' + '-' + app.setting.title,
		
	},
	onReady: function (){
		//this.showfilterMD = this.selectComponent("#showfilter");
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var page=this;
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		var route=page.route;
		page.setData({
			route:route,
		});
		if(opt.isgoshare){
				page.setData({
					ShowGoshare:true,
				});
			}
		if(opt.fromuser || opt.keyword || opt.pid || opt.cid){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		//console.log('app.access');console.log(app.access);
		app.util.get(app.access,function(pagedata){	
			//console.log('goodsindex');console.log(pagedata);
			page.setData({
				pluginnav:app.session.menus,
				pagedata:pagedata,
				nodatapic_close:true,
				action:app.access.plugin+'/'+app.access.action+'/',
			});
			setTimeout(()=>{page.get_list(1);},100);
		});
		
	},
	//翻页
	onReachBottom: function () {
		var isnodata=this.data.isnodata
		var loading=this.data.loading
		if(!isnodata && !loading){
			this.get_list()
		}
	},
	filter:function(){
		var page=this
		var showfilter = page.data.showfilter
		page.setData({
				showfilter:!showfilter
		});
	},
	setparams:function(e){
		var page=this
		var data=e.currentTarget.dataset;
		var pagedata=page.data.pagedata;
		if(data.type=='isrecommand'){
			pagedata.params.isrecommand=pagedata.params.isrecommand?0:1;
		}
		if(data.type=='isnew'){
			pagedata.params.isnew=pagedata.params.isnew?0:1;
		}
		if(data.type=='ishot'){
			pagedata.params.ishot=pagedata.params.ishot?0:1;
		}
		if(data.type=='isdiscount'){
			pagedata.params.isdiscount=pagedata.params.isdiscount?0:1;
		}
		if(data.type=='issendfree'){
			pagedata.params.issendfree=pagedata.params.issendfree?0:1;
		}
		if(data.type=='istime'){
			pagedata.params.istime=pagedata.params.istime?0:1;
		}
		console.log(pagedata.params);
		page.setData({
			'pagedata.params':pagedata.params
		});
	},
	paramspid:function(e){
		var page=this
		var data=e.currentTarget.dataset;
		var pagedata=page.data.pagedata;
		if(data.pid){
			pagedata.image=data.image;
			pagedata.params.pid=data.pid;
			pagedata.childs = data.childs
		}
		page.setData({
				'pagedata.params':pagedata.params,
				'pagedata.childs':pagedata.childs
		});
	},
	paramscid:function(e){
		var page=this
		var data=e.currentTarget.dataset;
		var pagedata=page.data.pagedata;
		if(data.cid && pagedata.params.pid==0 && data.parentid==0){
			pagedata.params.pcate=data.cid
			pagedata.params.cid=0
		}else{
			pagedata.image=data.image;
			pagedata.params.cid=data.cid;
			pagedata.params.pcate=0
		}
		page.setData({
				'pagedata.params':pagedata.params
		});
	},
	paramscongzhi:function(){
		var page=this
		page.setData({
				'pagedata.params':{}
		});
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	click_tab:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util.tab(data.params);
	},
	get_list:function(e){
		var the=this;
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		the.closesearch();
		if(e){
			if(e.currentTarget){
				var data=e.currentTarget.dataset;
				if(data.type=='price'){
					pagedata.params.order='price';
					pagedata.params.order_type=pagedata.params.order_type==1?2:1;
				}else if(data.type=='sales'){
					pagedata.params.order='sales';
				}else if(data.type=='new'){
					pagedata.params.order='new';
				}else if(data.type=='canle'){
					pagedata.params={};
				}else{
					pagedata.params.order=data.type;
				}
				if(data.juli){
					pagedata.params.juli=data.juli;
				}
				if(data.keyword){
					pagedata.params.keyword=data.keyword;
				}
			}
			pagedata.params.page = 1;
			pagedata.list=[];
			isnodata=false;
		}else{
			if(isnodata){
				return false;
			}
		}
		var query=app.util.made_query(pagedata.params);
		//console.log('query');console.log(query);
		app.util.get('/goods.index/getlist/'+query,function(res){
			//console.log('goods');console.log(res);
			if(res=='none'){
				the.setData({
					isnodata:true,
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
					loading:false,
				});
			}else{
				pagedata.list = pagedata.list.concat(res)
				//console.log('goods');console.log(pagedata.list);
				pagedata.params.page++
				the.setData({
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
					isnodata:isnodata,
					loading:false,
				});
			}
			//console.log('pagedata.params2');console.log(pagedata.params);
		});
	},
	formSubmit:function(event){
		var data=event.detail.value;
		app.util.post('post',data);
	},
	goTop:function(){
		wx.pageScrollTo({
		  scrollTop: 0,
		  duration: 300
		})
	},
	showsearch:function(e){
		var the = this
		var data=e.currentTarget.dataset;
		the.setData({
			'pagedata.paramstype':data.paramstype,
			isshowsearch:true
		});
	},
	closesearch:function(){
		var the = this
		the.setData({
			isshowsearch:false
		});
	},
	setstar:function(e){
		var the = this
		var data=e.currentTarget.dataset;
		the.setData({
			'pagedata.params.star':data.star,
		});
	},
	setorder:function(e){
		var the = this
		var data=e.currentTarget.dataset;
		the.setData({
			'pagedata.params.order':data.order,
		});
	},
	canleparams:function(){
		var the = this
		the.setData({
			'pagedata.params':{},
		});
	},
	// 搜索框文本内容的显示
	keyword: function (e) {
		var the = this
		the.setData({
		  'pagedata.params.keyword': e.detail.value
		})
	},
	sethotword: function (e) {
		var the = this
		var data=e.currentTarget.dataset;
		the.setData({
		  'pagedata.params.keyword': data.keyword
		})
	},
	  //搜索执行按钮
	query: function (e) {
		var the = this;
		var data=e.currentTarget.dataset;
		the.get_list(1);
		if(!data.type){
			the.filter();
		}
		the.setData({
		  'pagedata.op': 'main'
		})
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});