//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		account:app.setting.account,
		page:1,
		selectedall:false,
		loading:true,
		ShowAuthM:false,
		pagetitle:'我的购物车' + '-' + app.setting.title,
		
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (){
		var page=this;
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		var ShowAuthM=page.data.ShowAuthM;
		app.util.get(app.access,function(pagedata){
			//console.log('cart');console.log(pagedata);
			if((!pagedata.item.nickname || !pagedata.item.avatar) && !app.isgetUserInfo){
					ShowAuthM=!ShowAuthM
			}
			page.setData({
				pagedata:pagedata,
				ShowAuthM:ShowAuthM,
				pluginnav:app.session.menus,
				action:app.access.plugin+'/'+app.access.action+'/'
			});
			setTimeout(()=>{page.get_list(1);},500);
		});
		
		
	},
	goback: function() {
		var pages=getCurrentPages()
		if(pages.length>1){
			wx.navigateBack({
				'delta':1,
				'fail':function(){
					//console.log('333');
					app.util['access'](app.plugin_name+'/index/');
				},
			})
		}else{
			app.util['access'](app.plugin_name+'/index/');
		}
    },
	get_list:function(e){
		var the=this;
		var page = the.data.page
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		if(e){
			page = 1;
			isnodata=false;
		}else{
			if(isnodata){
				return false;
			}
		}
		var query='page='+page;
		app.util.get('/member.cart/getlist/'+query,function(res){
			//console.log('cart');console.log(res);
			if(res.list.length<1){
				the.setData({
					'pagedata.list':pagedata.list,
					isnodata:true,
					loading:false,
				});
			}else{
				pagedata.list = pagedata.list.concat(res.list);
				the.refresh(pagedata.list);
				page++
				the.setData({
					'pagedata.list':pagedata.list,
					page:page,
					loading:false,
				});
			}
		});
	},
	//翻页
	onReachBottom: function () {
		var isnodata=this.data.isnodata
		var loading=this.data.loading
		if(!isnodata && !loading){
			this.get_list()
		}
	},
	minus:function(e){
		var the=this
		var data=e.currentTarget.dataset;
		var pagedata = the.data.pagedata
		app.util.showLoading('减少中...');
		if(pagedata.list[data.index].total <=1){
			app.util.post('jy_weishop/member.cart/minus/',{'id':data.id,'wxapp':1},function(res){
				app.util.hideLoading();
				console.log('minus');console.log(res);
				if(res=='success'){
					pagedata.list.splice(data.index,1);
					the.setData({
						'pagedata.list':pagedata.list,
					});
					//console.log(app.session.menus);
					if(app.session.menus && app.session.menus.length>0){	
						for(var i=0;i<app.session.menus.length;i++){
							if(app.session.menus[i].action=='jy_weishop/member.cart/'){
								app.session.menus[i].badge--
								the.setData({
									pluginnav:app.session.menus,
								})
							}
						}
					}
					the.refresh(pagedata.list);
				}
			});
			
		}else{
			var cart=pagedata.list[data.index];
			if(cart.outtype==1 && parseInt(pagedata.list[data.index].total) + parseInt(cart.order_goodscount)<=parseInt(cart.usermaxbuy)){
					pagedata.list[data.index].outtype=false;
			}
			if(cart.outtype==2 && parseInt(pagedata.list[data.index].total)<=cart.kucun){
					pagedata.list[data.index].outtype=false;
			}
			if(cart.outtype==4 && parseInt(pagedata.list[data.index].total)<=cart.maxbuy){
					pagedata.list[data.index].outtype=false;
			}
			if(cart.outtype==5 && parseInt(pagedata.list[data.index].total)<=cart.active.maxnum){
					pagedata.list[data.index].outtype=false;
			}
			if(parseInt(pagedata.list[data.index].total)<cart.minbuynum){
				pagedata.list[data.index].outtype=3;
				pagedata.list[data.index].outnumtitle='单次最低购买'+cart.minbuynum+'件';
			}			
			app.util.post('jy_weishop/member.cart/minus/',{'id':data.id},function(res){
				//console.log('minus2');console.log(res);
				app.util.hideLoading();
				if(res=='success'){
					pagedata.list[data.index].total--;
					the.setData({
						'pagedata.list':pagedata.list,
					});
					if(app.session.menus && app.session.menus.length>0){	
						for(var i=0;i<app.session.menus.length;i++){
							if(app.session.menus[i].action=='jy_weishop/member.cart/'){
								app.session.menus[i].badge--
								the.setData({
									pluginnav:app.session.menus,
								})
							}
						}
					}
					//console.log(pagedata.list);
					the.refresh(pagedata.list);
				}
			});
		}
	},
	plus:function(e){
		var the=this
		var data=e.currentTarget.dataset;
		var pagedata = the.data.pagedata
		var cart=pagedata.list[data.index];
		if(parseInt(cart.kucun)<=parseInt(cart.total)){
			app.util.msg('超库存，不能再加了！');
			return false;
		}
		app.util.showLoading('加入中...');
		if(cart.outtype==3 && parseInt(pagedata.list[data.index].total)>=cart.minbuynum){
			pagedata.list[data.index].outtype=false;
		}		
		app.util.post('jy_weishop/member.cart/plus/',{'id':data.id},function(res){
			app.util.hideLoading();
			//console.log('success');console.log(res);
			if(res=='success'){
					pagedata.list[data.index].total++;
					the.setData({
						'pagedata.list':pagedata.list,
					});
					if(app.session.menus && app.session.menus.length>0){	
						for(var i=0;i<app.session.menus.length;i++){
							if(app.session.menus[i].action=='jy_weishop/member.cart/'){
								app.session.menus[i].badge++
								the.setData({
									pluginnav:app.session.menus,
								})
							}
						}
					}
					the.refresh(pagedata.list);
			}
		});
	},
	toogle_select:function(e){
		var the=this
		var data=e.currentTarget.dataset;
		var pagedata = the.data.pagedata
		var selected = pagedata.list[data.index].selected==1 ? 0 :1;
		pagedata.list[data.index].selected =selected
		the.setData({
			'pagedata.list':pagedata.list,
		});
		the.refresh(pagedata.list);
		app.util.post('jy_weishop/member.cart/select/',{'id':data.id,'selected':selected},function(res){
			//app.util.msg('选择成功！')
		});
	},
	selectedall:function(){
		var page=this
		var pagedata=page.data.pagedata
		var selectedall = page.data.selectedall
		for (var i=0; i<pagedata.list.length; i++){
			if(!pagedata.list[i].outtype){
				pagedata.list[i].selected=selectedall?0:1;
				app.util.post('jy_weishop/member.cart/select/',{'id':pagedata.list[i].id,'selected':pagedata.list[i].selected},function(res){
					//app.util.msg('选择成功！')
				});
			}
		}
		page.setData({
				'pagedata.list':pagedata.list,
				selectedall:!selectedall,
		});
		page.refresh(pagedata.list);
	},
	refresh:function(res){
		var the=this
		var pagedata=the.data.pagedata
		var total=0,
		totalprice=0.00;
		for (var i=0; i<res.length; i++){
			if(res[i].selected==1){
				total+=parseInt(res[i].total);
				totalprice+=res[i].total*res[i].price;
				//console.log(res[i].total);
			}
		}
		pagedata.total =total
		pagedata.totalprice =app.util.price(totalprice);
		the.setData({
				'pagedata.total':pagedata.total,
				'pagedata.totalprice':pagedata.totalprice,
		});
	},
	check_buy:function(){
		var pagedata=this.data.pagedata
		app.util.get('jy_weishop/member.cart/check_buy/');
	},
	like:function(){
		var pagedata = this.data.pagedata
		app.util.post('like',{'del':pagedata.del})
	},
	del:function(){
		var pagedata = this.data.pagedata
		app.util.post('jy_weishop/member.cart/del/',{'del':pagedata.del})
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	click_tab:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util.tab(data.params);
	},
	closegoodsdetail:function(){
		var the=this;
		the.setData({
			showgoodsdetail:false
		})
	},
	getgoodsdetail:function(e){
		var the=this
		var goodsid=e.currentTarget.dataset.id;
		var pagedata=the.data.pagedata
		the.setData({
			showgoodsdetail:true,
			loading:true,
			'pagedata.goods':{},
			'pagedata.goodsitem':{}
			
		})
		app.util.get('jy_weishop/goods.detail//id='+goodsid,function(res){
				//console.log(res)
				res.goods.content=res.goods.content.replace(/\<img/gi, '<img style="max-width:100%"' );
				pagedata.goodsitem=res;
				pagedata.showtype='0';
				pagedata.comments_type=pagedata.goodsitem.comments_type;
				pagedata.goods=res.goods;
				pagedata.comments=res.comments;
				pagedata.shopset=res.shopset;
				pagedata.commentsnum=res.commentsnum
				pagedata.commentsfen=res.commentsfen
				pagedata.goods.id=pagedata.goodsitem.goods.id;
				the.setData({
					'pagedata.goodsitem':pagedata.goodsitem,
					'pagedata.comments_type':pagedata.comments_type,
					'pagedata.goods':pagedata.goods,
					'pagedata.comments':pagedata.comments,
					'pagedata.shopset':pagedata.shopset,
					'pagedata.commentsnum':pagedata.commentsnum,
					'pagedata.commentsfen':pagedata.commentsfen,
					showtype:0,
					loading:false
				})
				the.getcomments(1);
			});
	},
	setlike:function(){
		var the=this
		var pagedata = the.data.pagedata
		pagedata.islike = !pagedata.islike;		
		the.setData({
				'pagedata.islike':pagedata.islike
		});
		app.util.get('jy_weishop/goods.detail/like/',function(){
			if(pagedata.islike){
				app.util.msg('关注成功');
			}else{
				app.util.msg('关注失败');
			}
		});
	},
	setvideo:function(e){
		var page=this
		var type = e.currentTarget.dataset.type;
		page.setData({
				'pagedata.goods.isvideo':type
		});
	},
	showtype:function(e){
		var page=this
		var pagedata = this.data.pagedata
		page.setData({
				showtype:e.currentTarget.dataset.showtype
		});
	},
	getcomments:function(e){
		var the=this;
		var page = the.data.page
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		pagedata.commentsparams = pagedata.commentsparams?pagedata.commentsparams:{}
		if(e){
			if(e.currentTarget){
				var data=e.currentTarget.dataset;
				if(data.type){
					pagedata.commentsparams.type=data.type;
					pagedata.comments_type=data.type;
					the.setData({
						'pagedata.comments_type':data.type
					});
				}
			}
			page = 1;
			pagedata.comments=[];
			isnodata=false;
		}else{
			if(isnodata){
				return false;
			}
		}
		var query='page='+page;
		var more_query=app.util.made_query(pagedata.commentsparams);
		if(more_query){
			query+='&'+more_query;
		}
		//console.log('query');console.log(query);
		app.util.get('jy_weishop/goods.detail/getcomments/'+query,function(res){
			//console.log('getcomments');console.log(res);
			if(res=='none'){
				the.setData({
					isnodata:true,
					'pagedata.comments':pagedata.comments,
					loading:false,
				});
			}else{
				pagedata.comments = pagedata.comments.concat(res.list)
				page++
				the.setData({
					'pagedata.comments':pagedata.comments,
					page:page,
					isnodata:isnodata,
					loading:false,
				});
			}
			
		});
	},
	del: function (e) {
		var the=this
		var data = e.currentTarget.dataset;
		var pagedata=the.data.pagedata;		
		app.util.get('jy_weishop/member.cart/del/id='+data.id,function(res){
			app.util.msg('删除成功')
			pagedata.list.splice(data.index,1);
			the.setData({
				'pagedata.list':pagedata.list
			});
		});
	},
	commentsshowtype:function(){
		var the=this
		the.setData({
				showtype:3
		});
	},
	show_bigimage:function(e){
		var the=this
		var img=e.currentTarget.dataset.img;
		the.setData({
			'pagedata.show_bigimage':!the.data.pagedata.show_bigimage,
			'pagedata.showimage':img
		});
	},
	info_login:function(e){
		//根据openid为用户登陆，此处尝试获取用户信息
		var the=this;
		app.util.getUserInfo(e,function(res){
			the.onLoad();
		});
		app.isgetUserInfo=true
		the.setData({
			ShowAuthM:false,
		})
	},
	closeAuthM:function(){
		var the=this;
		the.setData({
			ShowAuthM:false
		})
	},
	formSubmit:function(event){
		var data=event.detail.value;
		app.util.post('jy_weishop/member.cart/post/',data);
	}
});