//index.js
//获取应用实例
var app = getApp()
var QQMapWX = require('../../../resource/js/qqmap-wx-jssdk.min.js');
var qqmapsdk;
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		action:'',
		account:app.setting.account,
		pagetitle:'下单页面' + '-' + app.setting.title,
		pcd: ['广东省', '广州市', '海珠区'],
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (){
		var page=this;
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		app.util.get(app.access,function(pagedata){
			//console.log('create');console.log(pagedata);
			pagedata.post.total_price=app.util.price(pagedata.order.total_price);
			pagedata.post.endprice=app.util.price(pagedata.post.endprice);
			pagedata.post.no_dispatch_price=app.util.price(pagedata.post.no_dispatch_price);
			pagedata.post.dispatchprice=app.util.price(pagedata.order.dispatchprice);
			pagedata.post.olddispatchprice=app.util.price(pagedata.order.olddispatchprice);
			page.setData({
				pagedata:pagedata,
				nodatapic_close:true,
			});
		});
	},
	showdelivery:function(){
		var page=this
		var showdelivery = page.data.showdelivery
		page.setData({
			showdelivery:!showdelivery
		});
	},
	showfapiao:function(){
		var page=this
		var showfapiao = page.data.showfapiao
		page.setData({
			showfapiao:!showfapiao
		});
	},
	showcoupon:function(){
		var page=this
		var showcoupon = page.data.showcoupon
		page.setData({
			showcoupon:!showcoupon
		});
	},
	setaddress: function (e) {
		var the=this
		var data = e.currentTarget.dataset;
		var pagedata=the.data.pagedata
		app.util.get('core/member.address/set/id='+data.id+'&get=1',function(res){
			for(var i in pagedata.address_list){
				pagedata.address_list[i].isdefault=0
			}
			pagedata.address_list[data.index].isdefault=1
			pagedata.post.addressid=data.id
			the.setData({
				'pagedata.address_list':pagedata.address_list,
				'pagedata.post':pagedata.post,
				modal_address:false,
				'pagedata.item.address':pagedata.address_list[data.index]
			});
			app.util.msg('设置成功');
		});
	},
	edit_address:function(e){
		var the =this
		var data = e.currentTarget.dataset;
		var pagedata = the.data.pagedata
		the.setData({
			modal_address:false,
			edit_address:true,
			'pagedata.isaddaddress':data.isadd?1:0
		})
		//获取区域城市
		qqmapsdk = new QQMapWX({
            key: 'SN2BZ-MKT32-22SU7-COVX6-ZYXAQ-OEF6D'
        });
		app.util.location(function(res){
			qqmapsdk.reverseGeocoder({
					location:{latitude:res.latitude,longitude:res.longitude},
					success:function(res){
						var pcd =the.data.pcd
						if(res.result.address_component.province){
							 pcd[0] = res.result.address_component.province
						}
						if(res.result.address_component.city){
							pcd[1] = res.result.address_component.city
						}
						if(res.result.address_component.district){
							pcd[2] = res.result.address_component.district
						}
						the.setData({
							pcd:pcd,
						})
					}
			});
		});
		pagedata.address_item=data.id?pagedata.address_list[data.index]:{};
		the.setData({
			'pagedata.address_item':pagedata.address_item,
		});
	},
	close_address:function(){
		var the =this
		the.setData({
			edit_address:false,
			modal_address:false
		})
	},
	bindRegionChange: function (e) {
		//console.log('picker发送选择改变，携带值为', e.detail.value)
		this.setData({
		  pcd: e.detail.value
		})
	},
	del_address:function(e){
		var the =this
		var data = e.currentTarget.dataset;
		var pagedata = the.data.pagedata
		app.util.get('core/member.address/del/id='+data.id+'&get=1',function(res){
			pagedata.address_list.splice(data.index,1);
			the.setData({
				'pagedata.address_list':pagedata.address_list
			});
			app.util.msg('删除成功');
		});
	},
	post_address:function(e){
		var the =this
		var data=e.detail.value;
		var pagedata=the.data.pagedata
		data.pcd={}
		data.pcd.province=the.data.pcd[0]
		data.pcd.city=the.data.pcd[1]
		data.pcd.district=the.data.pcd[2]
		data.id=pagedata.address_item.id?pagedata.address_item.id:'';
		data.get=1
		app.util.post('core/member.address/post/',data,function(res){
			if(res){
				pagedata.post.addressid=data.id?data.id:res;
				if(!data.id){
					pagedata.address_list=pagedata.address_list.concat(data)
				}
				the.setData({
					'pagedata.address_list':pagedata.address_list,
					'pagedata.post':pagedata.post,
					'pagedata.item.address':data
				});
				app.util.msg('保存成功');
				app.util.get('jy_weishop/order.create/get_freight/showbaoyou=1&addressid='+pagedata.post.addressid,function(freight){
					pagedata.post.endprice=parseFloat(pagedata.post.endprice)-parseFloat(pagedata.order.dispatchprice)+parseFloat(freight.fee);
					pagedata.post.endprice=pagedata.post.endprice>0?app.util.price(pagedata.post.endprice):0;
					pagedata.order.dispatchprice=freight.fee;
					pagedata.post.dispatchprice=freight.fee;
					pagedata.order.addbaoyoufee=freight.addbaoyoufee;
					pagedata.order.isonebaoyou=freight.isonebaoyou;
					pagedata.order.outarea=freight.outarea;
					pagedata.order.no_out_price=freight.no_out_price?freight.no_out_price:0;
					pagedata.order.baoyou_man=freight.baoyou_man?freight.baoyou_man:0;
					pagedata.order.peisong_juli=freight.juli?freight.juli:pagedata.order.peisong_juli;
					the.setData({
						'pagedata.order':pagedata.order,
						'pagedata.post':pagedata.post,
					})
				});
			}else{
				app.util.msg('保存失败');	
			}
			the.close_address();
		});
	},
	modal_address:function(){
		var page=this
		var pagedata = page.data.pagedata
		var modal_address = page.data.modal_address
		app.util.get('core/member.address/',function(res){
			page.setData({
				'pagedata.address_list':res.list
			})
		})
		page.setData({
			modal_address:!modal_address,
			edit_address:false,
		});
	},
	showremark:function(){
		var page=this
		var showremark = page.data.showremark
		page.setData({
				showremark:!showremark
		});
	},
	post:function(e){
		var the = this
		var pagedata = the.data.pagedata
		pagedata.post.peerpay=true
		app.util.post('post',pagedata.post)
	},
	showgiftpicker:function(){
		var page=this
		var showgiftpicker = page.data.showgiftpicker
		page.setData({
				showgiftpicker:!showgiftpicker
		});
	},
	giveUp:function(){
		var page=this
		var giveUp = page.data.giveUp
		if(giveUp){
			this.giveUpMD.hide();
		}else{
			this.giveUpMD.show();
		}
		page.setData({
				giveUp:!giveUp
		});
	},
	change_address:function(e){
		var the = this
		var pagedata = the.data.pagedata
		var value = e.currentTarget.dataset
		pagedata.item.address = value.item
		pagedata.post.addressid=value.item.id;
		app.util.get('jy_weishop/order.create/get_freight/showbaoyou=1&addressid='+pagedata.item.address.id,function(freight){
			pagedata.post.endprice=parseFloat(scope.pagedata.post.endprice)-parseFloat(scope.pagedata.order.dispatchprice)+parseFloat(freight.fee);
			pagedata.post.endprice=pagedata.post.endprice>0?app.util.price(pagedata.post.endprice):0;
			pagedata.order.dispatchprice=freight.fee;
			pagedata.post.dispatchprice=freight.fee;
			pagedata.order.addbaoyoufee=freight.addbaoyoufee;
			pagedata.order.isonebaoyou=freight.isonebaoyou;
			pagedata.order.outarea=freight.outarea;
			pagedata.order.no_out_price=freight.no_out_price?freight.no_out_price:0;
			pagedata.order.baoyou_man=freight.baoyou_man?freight.baoyou_man:0;
			pagedata.order.peisong_juli=freight.juli?freight.juli:pagedata.order.peisong_juli;
			the.setData({
				'pagedata.order':pagedata.order,
				'pagedata.post':pagedata.post,
			})
		});
		the.close_address();
	},
	sendtype:function(e){
		var page=this
		var data = e.currentTarget.dataset;
		var pagedata= page.data.pagedata
		pagedata.post.sendtype=data.type;
		page.setData({
				'pagedata.post':pagedata.post
		});
	},
	make_type:function(e){
		var page=this
		var data = e.currentTarget.dataset;
		var pagedata= page.data.pagedata
		pagedata.post.make_type=data.type;
		page.setData({
				'pagedata.post':pagedata.post
		});
	},
	invoicetype:function(e){
		var page=this
		var data = e.currentTarget.dataset;
		var pagedata= page.data.pagedata
		pagedata.post.invoicetype=data.type;
		page.setData({
				'pagedata.post':pagedata.post
		});
	},
	fapiaotype2:function(e){
		var page=this
		var data = e.currentTarget.dataset;
		var pagedata= page.data.pagedata
		pagedata.post.fapiaotype2=data.type;
		pagedata.post.invoicename=pagedata.item.address.name;
		page.setData({
				'pagedata.post':pagedata.post
		});
	},
	invoicegoodstype:function(e){
		var page=this
		var data = e.currentTarget.dataset;
		var pagedata= page.data.pagedata
		pagedata.post.invoicegoodstype=data.type;
		page.setData({
				'pagedata.post':pagedata.post
		});
	},
	upremark:function(e){
		var the =this
		var data=e.detail.value;
		var pagedata= the.data.pagedata
		pagedata.post.remark=data.remark;
		the.setData({
				'pagedata.post':pagedata.post,
				showremark:false
		});
	},
	showstores:function(){
		var the =this
		the.setData({
				carrier_list:true
		});
	},
	checkcoupon:function(e){
		var the =this
		var data=e.currentTarget.dataset;
		var pagedata=the.data.pagedata
		if(data.type==1){
			if(pagedata.post.backtype!=1){
				pagedata.post.no_dispatch_price = parseFloat(pagedata.order.no_dispatch_price) - pagedata.post.deduct
				pagedata.post.endprice = parseFloat(pagedata.order.endprice) - pagedata.post.deduct
			}else{
				pagedata.post.no_dispatch_price = parseFloat(pagedata.order.no_dispatch_price) * pagedata.post.discount / 10;
				pagedata.post.endprice = pagedata.order.endprice * pagedata.post.discount/10		
			}
		}else{
			pagedata.post.couponid=0;
			if(pagedata.post.backtype!=1){
				pagedata.post.no_dispatch_price = pagedata.order.no_dispatch_price
				pagedata.post.endprice = pagedata.order.endprice
			}else{
				pagedata.post.no_dispatch_price = pagedata.order.no_dispatch_price;
				pagedata.post.endprice = pagedata.order.endprice		
			}
		}
		pagedata.post.total_price=app.util.price(pagedata.post.total_price);
		pagedata.post.endprice=pagedata.post.endprice>0?app.util.price(pagedata.post.endprice):0;
		pagedata.post.no_dispatch_price=app.util.price(pagedata.post.no_dispatch_price);
		the.setData({
				'pagedata.post':pagedata.post,
		});
		the.showcoupon();
	},
	selectcoupon:function(e){
		var the =this
		var data=e.currentTarget.dataset;
		var pagedata=the.data.pagedata
		if(data.type){
			pagedata.post.couponid=pagedata.wxcards[data.index].id
			pagedata.post.backtype=pagedata.wxcards[data.index].coupon.backtype;
			pagedata.post.discount=pagedata.wxcards[data.index].discount;
			pagedata.post.deduct=pagedata.wxcards[data.index].deduct;
			pagedata.post.title5=pagedata.wxcards[data.index].coupon.title5
		}else{
			pagedata.post.couponid=pagedata.coupons[data.index].id
			pagedata.post.backtype=pagedata.coupons[data.index].coupon.backtype;
			pagedata.post.discount=pagedata.coupons[data.index].discount;
			pagedata.post.deduct=pagedata.coupons[data.index].deduct;
			pagedata.post.title5=pagedata.coupons[data.index].coupon.title5
		}
		the.setData({
				'pagedata.post':pagedata.post,
		});
	},
	selectstore:function(e){
		var the=this
		var pagedata=the.data.pagedata
		var data=e.currentTarget.dataset;
		pagedata.selectstore=pagedata.carrier_list[data.index]
		pagedata.post.storeid = pagedata.carrier_list[data.index].id;
		the.setData({
				'pagedata.selectstore':pagedata.selectstore,
				'pagedata.post':pagedata.post,
				carrier_list:false
		});
	},
	dayid:function(e){
		var data=e.currentTarget.dataset;
		var the=this;
		var pagedata=the.data.pagedata;
		pagedata.post.dayid=data.index
		the.setData({
			'pagedata.post':pagedata.post
		})
	},
	out_time:function(e){
		var the=this
		var pagedata=the.data.pagedata
		var data=e.currentTarget.dataset;
		pagedata.post.out_time=data.time
		the.setData({
				'pagedata.post':pagedata.post,
				selecttime:false
		});
	},
	closetime:function(){
		var the=this;
		the.setData({
				selecttime:false
		})
	},
	selecttime:function(){
		var the=this;
		var pagedata=the.data.pagedata;
		var store_id=pagedata.post.id
		app.util.get('jy_weishop/store.index/out_time/store_id='+store_id,function(res){
			the.setData({
				'pagedata.out_time':res.out_time,
				'pagedata.predict_time':res.predict_time,
				'pagedata.timestamp':res.timestamp,
				selecttime:true
			})
		});
	},
	openAddress: function () {
		var the=this
		var pagedata=the.data.pagedata
		var pcd=[];
		wx.chooseAddress({
			success (res) {
				pagedata.address_item={}
				pagedata.address_item.name = res.userName; // 收货人姓名
				pcd[0] = res.provinceName; // 国标收货地址第一级地址（省）
				pcd[1] = res.cityName; // 国标收货地址第二级地址（市）
				pcd[2] = res.countyName; // 国标收货地址第三级地址（国家）
				pagedata.address_item.address = res.detailInfo; // 详细收货地址信息
				pagedata.address_item.mobile = res.telNumber; // 收货人手机号码
				the.setData({
				  'pagedata.address_item': pagedata.address_item,
				  'pcd':pcd
				})
			},fail (res) {
				console.log('fail');console.log(res)
			}
		})
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	//订阅消息
	SubscribeMessage: function (orderid) {
		var the=this
		var pagedata=the.data.pagedata
		the.setData({
				ShowSubMsg:false,
		});
		wx.requestSubscribeMessage({
			'tmplIds':pagedata.tmplIds,
			success:function (res) {
				console.log('SubscribeMessage success');console.log(res);
				if(res[pagedata.tmplIds[0]]=='accept' && orderid){
					app.util.get('jy_weishop/order.list/sendsubmsg/id='+orderid,function(res){
						app.util.msg('下单成功！','','jy_weishop/order.list/');
					});
				}
			},
			fail:function (res) {
				console.log('SubscribeMessage fail');console.log(res);
			},
		})
	},
	//唤醒订阅授权
	sendsubmsg: function (orderid) {
			var page=this
			var pagedata=page.data.pagedata
			if(pagedata.tmplIds && pagedata.tmplIds[0]){
				app.util.getsubmsgSet(pagedata.tmplIds,function(ShowSubMsg){
					if(ShowSubMsg){
						page.SubscribeMessage(orderid);
					}
				});
			}
	},
	closepaymodal:function(){
		var page=this
		page.setData({
				showpaymodal:false
		});
	},
	pay_credit:function(e){
		var page=this
		var pagedata=page.data.pagedata
		var data=e.currentTarget.dataset;
		app.util.pay_credit(data.id,function(res){
				page.setData({
						showpaymodal:false,
				});
				if(res.type=='success'){
					page.sendsubmsg(pagedata.order_id);
					//app.util.msg(res.message,'','jy_weishop/order.list/');
				}else{
					app.util.msg(res.message,'','jy_weishop/order.list/');
				}
		})
	},
	pay_wechat:function(e){
		var page=this
		var pagedata=page.data.pagedata
		var data=e.currentTarget.dataset;
		app.util.pay_wechat(data.id,function(res){
				page.setData({
						showpaymodal:false,
				});
				if(res.type=='success'){
					page.sendsubmsg(pagedata.order_id);
					//app.util.msg(res.message,'','jy_weishop/order.list/');
				}else{
					app.util.msg(res.message,'','jy_weishop/order.list/');
				}
		})
	},
	pay_alipay:function(e){
		var page=this
		var pagedata=page.data.pagedata
		var data=e.currentTarget.dataset;
		app.util.pay_alipay(data.id,function(res){
				page.setData({
						showpaymodal:false,
				});
				if(res.type=='success'){
					page.sendsubmsg(pagedata.order_id);
					//app.util.msg(res.message,'','jy_weishop/order.list/');
				}else{
					app.util.msg(res.message,'','jy_weishop/order.list/');
				}
		})
	},
	pay_hdfk:function(e){
		var page=this
		var pagedata=page.data.pagedata
		var data=e.currentTarget.dataset;
		app.util.pay_hdfk(data.id,function(res){
				page.setData({
						showpaymodal:false,
				});
				if(res.type=='success'){
					page.sendsubmsg(pagedata.order_id);
					//app.util.msg(res.message,'','jy_weishop/order.list/');
				}else{
					app.util.msg(res.message,'','jy_weishop/order.list/');
				}
		})
	},
	formSubmit:function(){
		var page=this
		var pagedata=page.data.pagedata
		if(pagedata.order_id){
			app.util.msg('你已下单！','','jy_weishop/order.list/');
			return;
		}
		app.util.post('jy_weishop/order.create/post/',pagedata.post,function(res){
			page.setData({
				'pagedata.order_id':res.order_id
			});
			pagedata.order_id=res.order_id
			app.util.pay(res.pay_id,function(res){		
				if(res.type=='more'){
					page.setData({
						showpaymodal:true,
						'pagedata.paymodal':res
					});
				}else if(res.type=='success'){
					page.sendsubmsg(pagedata.order_id);
					//app.util.msg(res.message,'','jy_weishop/order.list/');
				}else{
					app.util.msg(res.message);
				}
			});
		});
	}
});