//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		loading:true,
		showtopnav:false,
		showtotop:false,
		page:0,
		main:{'syscolor':'var(--syscolor)'},
		action:'index',
		pagetitle:'直播首页' + '-' + app.setting.title,
		
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var the=this;
		wx.setNavigationBarTitle({'title':the.data.pagetitle});
		var route=the.route;
		the.setData({
			route:route,
		});
		if(opt.isgoshare){
				the.setData({
					ShowGoshare:true,
				});
			}
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		the.getpagedata();
	},
	getpagedata: function (){
		var the=this;
		app.util.get(app.access,function(res){
			console.log('liveindex');console.log(res);
			the.setData({
				pagedata:res,
				pluginnav:app.session.menus,
				action:app.access.plugin+'/'+app.access.action+'/',
			});
			the.get_list(1);
		});
	},
	get_list:function(e){
		var the=this;
		var page = the.data.page
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		the.setData({
			loading:true
		});
		wx.showLoading({
		  title: '加载中...',
		})
		if(e){
			if(e.currentTarget){
				var data=e.currentTarget.dataset;
				if(data.type=='price'){
					pagedata.params.order='price';
					pagedata.params.order_type=pagedata.params.order_type?0:1;
				}else if(data.type=='sales'){
					pagedata.params.order='sales';
				}else if(data.type=='ishot'){
					pagedata.params.order='ishot';
				}else{
					pagedata.params.order='default';
				}
				if(data.pid){
					pagedata.params.pid=data.pid
				}
			}
			page = 1;
			pagedata.list=[];
			isnodata=false;
		}else{
			if(isnodata){
				the.setData({
						loading:false
				});
				return false;
			}
		}
		var query='page='+page+'&num=8';
		var more_query=app.util.made_query(pagedata.params);
		if(more_query){
			query+='&'+more_query;
		}
		app.util.get('jy_weishop/sale.live_index/getlist/'+query,function(res){
			console.log('res');console.log(res);
			wx.hideLoading()
			if(res.list.length==0){
				the.setData({
					isnodata:true,
					'pagedata.params':pagedata.params,
					loading:false,
				});
			}else{
				pagedata.list = pagedata.list.concat(res.list)
				page++
				the.setData({
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
					page:page,
					isnodata:isnodata,
					loading:false,
				});
			}
			
		});
	},
	onPageScroll:function (e) { // 获取滚动条当前位置
		var showtopnav=this.data.showtopnav
		var showtotop=this.data.showtotop
      if (e.scrollTop > 50 && !showtopnav) {
        this.setData({
          showtopnav: true,
        })
      }
	  if(e.scrollTop < 50 && showtopnav){
		this.setData({
          showtopnav: false
        })  
	  }
	},
	goback: function() {
		var pages=getCurrentPages()
		if(pages.length>1){
			wx.navigateBack({
				'delta':1,
				'fail':function(){
					//console.log('333');
					app.util['access'](app.plugin_name+'/index/');
				},
			})
		}else{
			app.util['access'](app.plugin_name+'/index/');
		}
    },
	//翻页
	onReachBottom: function () {
		var the=this;
		var isnodata=the.data.isnodata
		var loading=the.data.loading
		if(!isnodata && !loading){
			the.get_list()
		}
	},
	// 搜索框文本内容的显示
	keyword: function (e) {
		var the = this
		the.setData({
		  'pagedata.params.keyword': e.detail.value
		})
	},
	//获取关注
	setfollow: function (e) {
		var page = this
		var pagedata = page.data.pagedata
		var data=e.currentTarget.dataset;
		var id=pagedata.list[data.index].id
		pagedata.list[data.index].islike = pagedata.list[data.index].islike ? 0 : 1;
		app.util.post("jy_weishopapplive/room/like/id="+id, '', function (res) {
			app.util.msg(res);
			page.setData({
					'pagedata.list': pagedata.list
			});
		})
	},
	gorooms:function(e){
		var data=e.currentTarget.dataset;
		var customParams = encodeURIComponent(JSON.stringify({ 'path': 'jy_weishop/sale/live_index/index', 'fromroomid': data.roomsid}));
		wx.navigateTo({
			url: 'plugin-private://'+app.live_appid+'/pages/live-player-plugin?room_id='+data.roomsid+'&open_share_ticket=1'+'&custom_params='+customParams
		})
	},
	goback: function() {
		var pages=getCurrentPages()
		if(pages.length>1){
			wx.navigateBack({
				'delta':1,
				'fail':function(){
					console.log('333');
					app.util['access'](app.plugin_name+'/index/');
				},
			})
		}else{
			app.util['access'](app.plugin_name+'/index/');
		}
    },
	info_login:function(e){
		//根据openid为用户登陆，此处尝试获取用户信息
		var the=this;
		app.util.getUserInfo(e,function(res){
			the.getpagedata();
		});
		the.setData({
			ShowAuthM:false
		})
	},
  	click:function(e){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=e.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	formSubmit:function(e){
		var data=e.detail.value;
		app.util.post('post',data);
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});