//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		account:app.setting.account,
		pagetitle:'分类' + '-' + app.setting.title,
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var page=this;
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		var route=page.route;
		page.setData({
			route:route,
		});
		if(opt.isgoshare){
				page.setData({
					ShowGoshare:true,
				});
			}
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		app.util.get(app.access,function(pagedata){
			//console.log('pagedata');console.log(pagedata);
			pagedata.groupset.adimg = pagedata.groupset.adimg?app.setting.att_url + pagedata.groupset.adimg:app.setting.siteroot+'/core/resource/images/nopic.jpg'
			pagedata.params=pagedata.params?pagedata.params:{};
			pagedata.list=pagedata.list?pagedata.list:[];
			page.setData({
				pluginnav:app.session.menus,
				pagedata:pagedata,
				action:app.access.plugin+'/'+app.access.action+'/',
				nodatapic_close:true,
			});
		});
	},
	//翻页
	onReachBottom: function () {
		var isnodata=this.data.isnodata
		var loading=this.data.loading
		if(!isnodata && !loading){
			this.get_list()
		}
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	click_tab:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util.tab(data.params);
	},
	selectpid:function(e){
		var the=this;
		var data=e.currentTarget.dataset;
		var index=data.index;
		var pagedata=this.data.pagedata
		if(index){
			pagedata.childs=pagedata.category[index].childs
			pagedata.image=pagedata.category[index].advimg
			pagedata.image=pagedata.category[index].advurl
			pagedata.pid=pagedata.category[index].id
		}else{
			pagedata.pid=0;
			pagedata.childs=pagedata.recommend;
			pagedata.image=''
		}
		if(!pagedata.childs || pagedata.childs.length<1){
			the.get_list(pagedata.pid);
		}
		this.setData({
				'pagedata.childs':pagedata.childs,
				'pagedata.image':pagedata.image,
				'pagedata.advurl':pagedata.advurl,
				'pagedata.pid':pagedata.pid,
		});
	},
	selectkeyword:function(e){
		var the=this;
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		if(e){
			if(e.currentTarget){
				var data=e.currentTarget.dataset;
				if(data.type=='price'){
					pagedata.params.order='price';
					pagedata.params.order_type=pagedata.params.order_type==1?2:1;
				}else if(data.type=='sales'){
					pagedata.params.order='sales';
				}else if(data.type=='new'){
					pagedata.params.order='new';
				}else if(data.type=='canle'){
					pagedata.params={};
				}else{
					pagedata.params.order=data.type;
				}
				if(data.juli){
					pagedata.params.juli=data.juli;
				}
				if(data.keyword){
					pagedata.params.keyword=data.keyword;
				}
			}
			pagedata.params.page = 1;
			pagedata.list=[];
			isnodata=false;
			the.setData({
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
					isnodata:isnodata,
					'pagedata.childs':[]
			});
			the.get_list();
		}
	},
	get_list:function(pcate){
		var the=this;
		var pagedata=the.data.pagedata
		var isnodata = the.data.isnodata
		if(pcate){
			pagedata.params.pcate = pcate;
			pagedata.params.page = 1;
			pagedata.list=[];
			isnodata=false;
		}else{
			if(isnodata){
				return false;
			}
		}
		var query=app.util.made_query(pagedata.params);
		//console.log('query');console.log(query);
		app.util.get('/goods.index/getlist/'+query,function(res){
			if(res=='none'){
				the.setData({
					isnodata:true,
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
				});
			}else{
				pagedata.list = pagedata.list.concat(res)
				pagedata.params.page++
				the.setData({
					'pagedata.list':pagedata.list,
					'pagedata.params':pagedata.params,
					isnodata:isnodata,
					loading:false,
				});
			}
			
		});
	},
	// 搜索框文本内容的显示
	keyword: function (e) {
		var the = this
		the.setData({
		  'pagedata.params.keyword': e.detail.value
		})
	},
	paramscid:function(e){
		var page=this
		var data=e.currentTarget.dataset;
		var pagedata=page.data.pagedata;
		if(data.cid && pagedata.pid==0 && data.parentid==0){
			 wx.navigateTo({'url':'/jy_weishop/goods/index/index?pid='+data.cid});
		}else{
			 wx.navigateTo({'url':'/jy_weishop/goods/index/index?cid='+data.cid});
		}
	},
	formSubmit:function(event){
		var data=event.detail.value;
		app.util.post('post',data);
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});