//index.js
//获取应用实例
var app = getApp()
var QQMapWX = require('../../../resource/js/qqmap-wx-jssdk.min.js');
var qqmapsdk;
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		account:app.setting.account,
		pagetitle:'门店' + '-' + app.setting.title,
		
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var page=this;
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		var route=page.route;
		page.setData({
			route:route,
		});
		if(opt.isgoshare){
				page.setData({
					ShowGoshare:true,
				});
			}
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		qqmapsdk = new QQMapWX({
            key: 'SN2BZ-MKT32-22SU7-COVX6-ZYXAQ-OEF6D'
        });	
		app.util.get(app.access,function(pagedata){
			//console.log('pagedata');console.log(pagedata);
			app.util.location(function(res){
				//console.log('获取地址res');console.log(res);
				qqmapsdk.reverseGeocoder({
					location:{latitude:res.latitude,longitude:res.longitude},
					success:function(res){
						//console.log('res');console.log(res);
						if(res.status!=0){
							console.log('解析地址失败！');
							return;
						}
						var start={
							address:res.result.address,
							city:res.result.address_component.city,
							location:res.result.ad_info.location,
							title:res.result.formatted_addresses.rough,
						};
						page.setData({
							start:start,
							pluginnav:app.session.menus,
							action:app.access.plugin+'/'+app.access.action+'/'
						});
					},
					fail:function(res){
						console.log('解析地址失败！收到的数据：');console.log(res);
					}
				});
				
			},'gcj02');
			page.setData({
				pagedata:pagedata
			});
		});
	},
	call:function(e){
		var phoneNumber = e.currentTarget.dataset.phone;
		wx.makePhoneCall({
		  phoneNumber: phoneNumber
		})
	},
	openLocation:function(e){
		var the = this
		var pagedata = the.data.pagedata
		wx.openLocation({
			latitude: pagedata.item.latitude, // 纬度，浮点数，范围为90 ~ -90
			longitude: pagedata.item.longitude, // 经度，浮点数，范围为180 ~ -180。
			name: pagedata.item.province+pagedata.item.city+pagedata.item.district, // 位置名
			address: pagedata.item.address, // 地址详情说明
			scale: 20, // 地图缩放级别,整形值,范围从1~28。默认为最大
			infoUrl: '', // 在查看位置界面底部显示的超链接,可点击跳转
			success:function(){
				//alert(1111);
			}
		});
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	formSubmit:function(event){
		var data=event.detail.value;
		app.util.post('post',data);
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});