//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		att_url:app.setting.att_url,
		pagetitle:'门店设置' + '-' + app.setting.title,
		
	},
	onReady: function (){
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (){
		var page=this;
		wx.setNavigationBarTitle({'title':page.data.pagetitle});
		app.util.get(app.access,function(pagedata){
			//console.log('pagedata');console.log(pagedata);
			wx.getLocation({
				type:"gcj02",
				success:function(res){
					var lat_lng = {'lat':res.latitude,'lng':res.longitude}
					pagedata.item.lat_lng=pagedata.item.lat_lng?pagedata.item.lat_lng:res.lat_lng
					pagedata.item.address = res.address
				}
			})
			page.setData({
				pagedata:pagedata,
				action:app.access.action
			});
		});
	},
	info_login:function(e){
		//根据openid为用户登陆，此处尝试获取用户信息
		app.util.getUserInfo(e);
		this.ShowAuthM.hide();
	},
  	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util[data.func](data.params);
	},
	click_tab:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		app.util.tab(data.params);
	},
	formSubmit:function(event){
		var the = this
		var pagedata = the.data.pagedata
		var value=event.detail.value;
		pagedata.item.title = value.title
		pagedata.item.logo = value.logo
		pagedata.item.desc = value.desc
		pagedata.item.realname = value.realname
		pagedata.item.tel = value.tel
		pagedata.item.address = value.address
		pagedata.item.lat_lng.lng = value.lng
		pagedata.item.lat_lng.lat = value.lat
		app.util.post('post',pagedata.item);
	},
	choose_file:function(e){
		var the =this
		var modaldata=the.data.modaldata?the.data.modaldata:{}
		if(modaldata.params){
			var title= modaldata.params.title?modaldata.params.title:'';
		}else{
			var title='';
		}
		modaldata.type=modaldata.type?modaldata.type:'one';
		modaldata.source_type=modaldata.source_type?modaldata.source_type:'image';
		if(e && e.currentTarget && e.currentTarget.dataset){
			var data=e.currentTarget.dataset;
			var op=data.op?data.op:'';
			var page=data.page?data.page:1;
			var group_id=data.group_id?data.group_id:'';
			if(!group_id && modaldata.params && modaldata.params.group_id){
				group_id=modaldata.params.group_id;
			}
			if(data.file){
				modaldata.filename=data.file;
			}
			if(data.tovalue){
				modaldata.tovalue=data.tovalue;
			}
			if(data.thumb){
				modaldata.thumbname=data.thumb;
			}
			modaldata.type=data.type?data.type:'one';
			modaldata.source_type=data.source_type?data.source_type:modaldata.source_type;
		}else{
			var op=modaldata.op?modaldata.op:'list';
			var group_id=modaldata.params.group_id?modaldata.params.group_id:-2;
			var page=1;
		}
		var action='core/tools.choose_file//type='+modaldata.type+'&op='+op+'&source_type='+modaldata.source_type+'&group_id='+group_id+'&title='+title+'&page='+page
		app.util.get(action,function(res){
			modaldata.file_list=modaldata.file_list?modaldata.file_list:[];
			modaldata=Object.assign(modaldata,res);
			the.setData({
				modaldata: modaldata,
				showchoosefile:true,
			})
		});
	},
	choose_file_tabop:function(e){
		var the =this
		var modaldata =the.data.modaldata
		var data=e.currentTarget.dataset;
		the.setData({
			'modaldata.op': data.op,
		})
	},
	choose_file_splice:function(e){
		var the =this
		var modaldata =the.data.modaldata
		var data=e.currentTarget.dataset;
		modaldata.file_list.splice(data.index,1);
		the.setData({
			'modaldata.file_list': modaldata.file_list,
		})
	},
	choose_file_keyword: function (e) {
		var the = this
		the.setData({
		  'modaldata.params.title': e.detail.value
		})
	},
	choose_file_image: function (e) {
		var the = this
		var modaldata =the.data.modaldata
		var pagedata =the.data.pagedata
		var att_url=the.data.att_url
		var file=modaldata.file;
		var thumb=modaldata.thumb?modaldata.thumb:'';
		if(e && e.currentTarget && e.currentTarget.dataset && e.currentTarget.dataset.index>=0){
			var data=e.currentTarget.dataset;
			var file=modaldata.list[data.index].attachment;
			var thumb=modaldata.list[data.index].thumb;
			thumb=thumb?thumb:'';
		}
		if(modaldata.type=='more'){
			if(modaldata.tovalue){
						pagedata[modaldata.tovalue][modaldata.filename].push(file);
			}else{
						pagedata[modaldata.filename].push(file);
			}
			the.setData({
					  pagedata: pagedata,
			})
		}else{
			if(file && modaldata.filename){
				    if(modaldata.tovalue){
						pagedata[modaldata.tovalue][modaldata.filename]=file
					}else{
						pagedata[modaldata.filename]=file
					}					
					if(modaldata.thumbname){
						if(modaldata.tovalue){
							pagedata[modaldata.tovalue][modaldata.thumbname]=thumb
						}else{
							pagedata[modaldata.thumbname]=thumb
						}
					}
					the.setData({
					  pagedata: pagedata,
					})
			}
		}
		the.setData({
				   showchoosefile:false,
		})		
	},
	choose_file_images:function(){
		var the = this
		var modaldata =the.data.modaldata
		var res=';'+modaldata.file_list.join(';')+';';
		the.setData({
			'file_list': res,
		})
	},
	up_file:function(){
		var the =this
		var modaldata =the.data.modaldata	
		app.util.up_file(modaldata.source_type,function(res,thumb){
			modaldata.file=res
			if(thumb){
				modaldata.thumb=thumb
			}
			the.setData({
				modaldata: modaldata,
			})	
		});
	},
	choose_location:function(){
		var the = this
		var pagedata = the.data.pagedata
		wx.chooseLocation({
			success (res) {
				const latitude = res.latitude
				const longitude = res.longitude
				pagedata.item.address = res.address
				pagedata.item.lat_lng = {'lat':latitude,'lng':longitude}
				the.setData({
					'pagedata.item':pagedata.item
				})
			}
		})
	}
});