var util={};
var nossid = 0;
util.base64=require('base64.js');
util.socket=require('jinyun_socket.js');
util.get=function(url,callback,direct){
	var post={url:url,callback:callback};
	if(direct){
		post.direct=direct;
	}
	util.post_json(post);
}
util.post=function(url,data,callback){
	var app=getApp();
	/*if(!callback){
		callback=function(res){
			util.message(res);
			util.access(app.access);
		}
	}*/
	var post={url:url,data:data,callback:callback};
	util.post_json(post);
}
util.post_json=function(post){
	var url=post.url;
	if(typeof(url)!='object'){
		url=util.links(url);
	}
	var option={
		data:{}
	};
	option.data.plugin=url.plugin;
	option.data.action=url.action;
	if(url.op){
		option.data.op=url.op;
	}
	if(url.query){
		option.query=url.query;
	}
	if(post.direct){
		option.direct=true;
	}
	if(post.data){
		if(post.data.direct){
			option.direct=true;
		}
		var app=getApp();
		post.data=JSON.stringify(post.data);
		post.data=util.base64.encode(post.data,app.base_key_str);
		option.data.postdata=post.data;
	}
	if(post.callback){
		option.success=post.callback;
	}
	util.request(option);
}
//访问一个页面
util.access=function(url){
	if(!url){
		return;
	}
	if(url=='goback'){
		util.goback();
		return;
	}
	//if(!util.historys){
		//	util.historys=[];
	//}
	var app = getApp();
	//util.historys.push(app.access);
	if(typeof(url)=='string'){
		url=util.links(url);
	}
	app.access=url;
	//如果访问的是DIY页面
	if(app.access.plugin=='core' && app.access.action=='welcome'){
		var query_array = app.util.array_query(app.access.query);
		if(query_array.query.pageid){
			var page='/core/diy/page_'+query_array.query.pageid;
			wx.navigateTo({'url':page,fail:function(){
				wx.navigateTo({'url':'/core/html/html'});
			}});
		}else{
				wx.navigateTo({'url':'/core/html/html'});
		}
	}
	var page='/'+app.access.plugin+'/'+util.replace('.','/',app.access.action)+'/index';
	wx.navigateTo({'url':page,fail:function(){
		if(page.slice(0,6)=='/pages'){
			  wx.navigateTo({'url':'/core/welcome/index'});
		}else{
			  wx.navigateTo({'url':'/core/html/html'});
		}
	}});
}
util.tab=function(url){
	if(!url){
		return;
	}
	var app = getApp();
	if(typeof(url)=='string'){
		url=util.links(url);
	}
	app.access=url;
	var page='/'+app.access.plugin+'/'+util.replace('.','/',app.access.action)+'/index';
	wx.reLaunch({'url':page,fail:function(){
		if(page.slice(0,6)=='/pages'){
			  wx.navigateTo({'url':'/core/welcome/index'});
		}else{
			  wx.navigateTo({'url':'/core/html/html'});
		}
	}});
}
util.goback=function(){
	//var access=util.historys.pop();
	//var page='/'+access.plugin+'/'+util.replace('.','/',access.action)+'/index';
	wx.navigateBack({'delta':1});
};
util.tomedia=function(url){
	if(!url || typeof(url)!='string'){
		return false;
	}
	if(url.slice(0,4)=='http'){
		return url;
	}else{
		var app=getApp();
		return app.setting.att_url+url;
	}
}
util.message=function(message,type,url){
	if(!message){
		if(url){
			util.access(url);
		}
		return;
	}
	if(type=='error'){
		type='fail';
	}else{
		type='success';
	}
	var params={
		'title':'系统提示',
		'content':message,
		//'type':'success',
		'showCancel':false,
		'success':function(res){
			if(res.confirm){
				if(url){
					util.access(url);
				}
			}
			
		}
	};
	wx.showModal(params);
	if(type=='fail'){
		return false;
	}
}
util.msg=function(message,type,url){
	if(!type){
		type='none'
	}
	wx.showToast({
			title: message,
			icon:type,
			duration: 1500
	});
	if(url){
		setTimeout(function(){	
				util.access(url);
		},1300);
	}
	return;
}
util.replace=function(search,replace,str){
		if(!str){
			return '';
		}
		if(search==replace){
			return str;
		}
		var res=str.replace(search,replace);
		if(res!=str){
			res=util.replace(search,replace,res);
		}
		return res;
}
util.request=function(option){
	//访问后台获取数据
	if(!option){
		return false;
	}
	var the=getApp();
	if(option.cache){
		//支持缓存
		var cid=JSON.stringify(option);
		var md5 = require('md5.js');
		cid=md5(cid);
		message=wx.getStorageSync(cid);
		if(message){
			if(option.success && typeof option.success == 'function'){
				option.success(message);
				return true;
			}else{
				return false;
			}
		}
	}
	wx.showNavigationBarLoading();
	if(!option.data){
		option.data={};
	}
	//不是来自LOGIN的请求
	if(!option.issession){
		//小程序端缓存过期
		if(!the.ssid || !the.token){
			the.after_login.push(function(){
				util.request(option);
			});
			if(!the.upsession_num || the.upsession_num<20){
				console.log('get.session');
				util.session();
			}
			return;
		}
		option.data.ssid=the.ssid;
		option.data.token=the.token;
	}
	if(!option.data.m_type){
		option.data.os=the.setting.apptype?the.setting.apptype:'wxapp';
	}
	option.data.fromapp=the.setting.apptype?the.setting.apptype:'wxapp';
	var url=the.setting.api_url_new?the.setting.api_url_new:the.setting.api_url;
	if(option.query){
		url+='&'+option.query;
	}
	if(option.url){
		url=option.url;
	}
	/*if(option.data.p_url){
		var p_url = decodeURIComponent(option.data.p_url);
		url = url + p_url;
	}
	if(option.data.r_url){
		var r_url = decodeURIComponent(option.data.r_url);
		url = url + r_url;
	}*/
	wx.request({
		'url': url,
		'data': option.data,
		'method': option.method ? option.method : 'POST',
		'dataType':'json',
		'header': {
			'content-type': 'application/x-www-form-urlencoded'
		},
		'success': function (res){
			//请求成功，处理成功数据
			//console.log('请求结果');console.log(res);
			    util.hideLoading();
			var result=res.data;
			if(option.direct || option.data.direct){
				option.success(result);
				return;
			}
			if(!result || typeof(result)!='object'){
				console.log('页面出错，原始数据为：');console.log(res);
				//util.message('服务器没有返回数据！','error');
				return;
			}
			//服务器端会话过期（同时不能是来自LOGIN的请求）
			if(result.type=='error' && result.upssid && !option.issession){
				console.log('会话过期，请重新进入！')
				the.ssid='';the.token='';the.upsession_num='';
				the.after_login.push(function(){
					util.request(option);
				});
				util.session();
				return;
			}
			if(result.more && result.more.title){
				wx.setNavigationBarTitle({'title':result.more.title});
			}
			if(result.action || result.type!='success'){
				util.message(result.message,result.type,result.action);
				return;
			}
			//成功
			if(option.success && typeof option.success == 'function'){
				//判断是否支持缓存
				if(cid){
					wx.setStorageSync(cid,result.message);
				}
				option.success(result.message);
			}else{
				util.message(result.message);
			}
		},
		'fail': function (response) {
			//如果请求失败，返回失败数据
			console.log('请求失败，收到的数据：');console.log(response);
			    util.hideLoading();
			if (option.fail && typeof option.fail == 'function'){
				option.fail(response);
			}
		},
		'complete': function (response) {
			wx.hideNavigationBarLoading();
		}
	});
}
util.session=function(callback){
	//获取会话，只获取openid不获取粉丝详细信息
	wx.login({
		'success':function(res){
			var params={};
			//判断来自获取session的请求！
			params.issession=true;
			var the=getApp();
			params.url=the.setting.index_url_new?the.setting.index_url_new:the.setting.index_url;
			//图片绝对路径
			params.url +='&is_tomedia=1';
			params.data={};
			if(res.code){
				params.data.code=res.code;
			}
			//console.log('session');console.log(params);
			params.success=function(result){
				console.log('sessionresult');console.log(result);
				wx.setStorageSync('ssid',result.ssid);
				wx.setStorageSync('openid',result.openid);
				the.ssid=result.ssid;
				the.token=result.token;
				the.openid=result.openid;
				the.session={'menus':result.menus};
				the.base_key_str=result.base_key_str;
				//获取登录后要执行的动作！并删除
				var func;
				while(the.after_login.length>0){
					func=the.after_login.shift();
					if(typeof(func)=='function'){
						func();
					}
				}
				if(typeof(callback)=='function'){
					callback(result.ssid);
				}
				console.log('openid');console.log(the.openid);
			}
			util.request(params);
		},
		'complete':function(res){
			var the=getApp();
			setTimeout(function(){
				the.issession=false;
				the.upsession_num +=1
			},300);
		}
	});
	//获取授权信息;
	util.getSetting();
}
/*
* 获取/同步用户信息
*/
util.getUserInfo = function (e,callback){
	var app=getApp();
	if(app.setting.apptype && app.setting.apptype!='wxapp'){
		if(app.setting.apptype=='aliapp'){
			my.getOpenUserInfo({
						  success(res) {
							var getdata = {};
							getdata.userInfo = JSON.parse(res.response).response // 以下方的报文格式解析两层 response
							console.log('res.userInfo');console.log(getdata);
							if(getdata.userInfo.code!=10000){
								util.message('错误代码：'+getdata.userInfo.code+',内容：'+getdata.userInfo.subMsg);
							}
							util.post('core/member.login/wxapp_login/return_info=1',getdata,function(){
								my.setStorageSync('userInfo',getdata.userInfo);
								if(typeof(callback)=='function'){
									callback(getdata.userInfo);
								}
							});
						  },
						  fail(res) {
							console.log('getUserInfo调用失败');
						  }
			});
		}else{
			wx.authorize({
				scope:'scope.userInfo',
				success:function(){
					wx.getUserInfo({
						  success(res) {
							console.log(res.userInfo);
							util.post('core/member.login/wxapp_login/return_info=1',res,function(){
								wx.setStorageSync('userInfo',res.userInfo);
								if(typeof(callback)=='function'){
									callback(res.userInfo);
								}
							});
						  },
						  fail(res) {
							console.log('getUserInfo调用失败');
						  }
					});
				}
			});
		}
	}else{	
		util.post('core/member.login/wxapp_login/return_info=1',e.detail,function(res){
			wx.setStorageSync('userInfo',res);
			if(typeof(callback)=='function'){
				callback(res);
			}
		});
	}
}
util.location=function(callback,type){
	//console.log('util.location');
	if(typeof(callback)!='function'){
		return false;
	}
	if(!type){
		type='wgs84';
	}
	wx.authorize({
		scope:'scope.userLocation',
		success:function(){
			wx.getLocation({
				type:type,
				success:function(res){
					callback(res);
				},
				fail: function(res){
					res.latitude=22.757597;
					res.longitude=118.068529;
					callback(res);
					util.msg('定位失败！');
				},
			});
		},
		fail:function(){
			wx.showModal({
			  title: '定位失败',
			  content: '请设置->位置信息->选择[仅在使用小程序期间].',
			  success (res) {
				if (res.confirm) {
				  wx.openSetting({
					  success (res) {
						  console.log(res.authSetting);
					  }
				  });
				} else if (res.cancel) {
				  util.message('不允许获取位置信息，将无法获取您的具体位置，无法正常使用本平台服务！');
				}
			  }
			});
		}
	});
}
/*
* 判断是否获取到用户信息
*/
util.checkUserInfo = function (callback) {
	var userInfo = wx.getStorageSync('userInfo');
	var cancelAuthSetting = wx.getStorageSync('cancelAuthSetting');
	wx.getSetting({
		success: function (res) {
			//console.log(res.authSetting['scope.userInfo']);
			if(!userInfo && !res.authSetting['scope.userInfo'] && !cancelAuthSetting){
				wx.setStorageSync('onShowAuthSetting',true);
				if(typeof(callback)=='function'){
							callback(true);
				}
				var onShowAuthSetting = wx.getStorageSync('onShowAuthSetting');
				//console.log('onShowAuthSetting1');console.log(onShowAuthSetting);
			}else{
				console.log('onShowAuthSetting=false');
				util.getUserInfo();
			}
		}
	});
}
//打开授权设置
util.openSetting=function(){
		wx.openSetting();
},
//拒绝授权设置
util.cancelAuthSetting=function(){
		wx.setStorageSync('cancelAuthSetting',true);
},
//获取用户的当前设置
util.getSetting=function(){
	wx.getSetting({
		success: function (res) {
				//console.log('getSetting');console.log(res);
				wx.setStorageSync('authSetting',res.authSetting);
		}
	});
},

//封装微信等待提示，防止ajax过多时，show多次
util.showLoading = function(msg) {
	var isShowLoading = wx.getStorageSync('isShowLoading');
	if (isShowLoading) {
		wx.hideLoading();
		wx.setStorageSync('isShowLoading', false);
		return true;
	}
	msg=msg?msg:'加载中';
	wx.showLoading({
		title : msg,
		complete : function() {
			wx.setStorageSync('isShowLoading', true);
		},
		fail : function() {
			wx.setStorageSync('isShowLoading', false);
		}
	});
}
//封装微信等待提示，防止ajax过多时，show多次
util.hideLoading = function() {
	var isShowLoading = wx.getStorageSync('isShowLoading');
	if (isShowLoading) {
		wx.hideLoading();
		wx.setStorageSync('isShowLoading', false);
	}
	return true;
}
util.showImage = function(event) {
	var url = event ? event.currentTarget.dataset.preview : '';
	if (!url) {
		return false;
	}
	wx.previewImage({
		urls: [url]
	});
}

/**
 * 转换内容中的emoji表情为 unicode 码点，在Php中使用utf8_bytes来转换输出
*/
util.parseContent = function(string) {
	if (!string) {
		return string;
	}

	var ranges = [
			'\ud83c[\udf00-\udfff]', // U+1F300 to U+1F3FF
			'\ud83d[\udc00-\ude4f]', // U+1F400 to U+1F64F
			'\ud83d[\ude80-\udeff]'  // U+1F680 to U+1F6FF
		];
	var emoji = string.match(
		new RegExp(ranges.join('|'), 'g'));

	if (emoji) {
		for (var i in emoji) {
			string = string.replace(emoji[i], '[U+' + emoji[i].codePointAt(0).toString(16).toUpperCase() + ']');
		}
	}
	return string;
}
//微信api

// 亮度
util.get_ScreenBrightness=function(callback){
	wx.getScreenBrightness({
		'success': function (res) {
			callback(res.value);
		}
	})
}
// 获取当前地址坐标
util.get_getLocation=function(callback,type){
	wx.getLocation({
		'type':type?type:'wgs84',
		'success': function (res) {
			callback(res);
		}
	})
}
util.made_query=function(params,delop){
		var query='';var key;
		for(key in params){
			if(!delop || key!='op'){
				query+=key+'='+params[key]+'&';
			}
		}
		
		return query;
}
//进云函数，分割参数
util.array_query=function(query){
		query=query.split('&');
		var params={};
		query.forEach(function(p){
			p=p.split('=');
			if(p[0] && p[1]){
				if(p[0]=='plugin'){
					params.plugin=p[1];
				}else if(p[0]=='action'){
					params.action=p[1];
				}else if(p[0]=='op'){
					params.op=p[1];
				}else{
					if(!params.query){
						params.query={};
					}
					params.query[p[0]]=p[1];
				}
			}
		});
	return params;
}
//进云函数，将标准URL转为完整的标准URL数组
util.links=function(paop,query,no){
//console.log('util.links');
	var params={};
	if(paop.slice(0,4)=='http' || paop.slice(0,11)=='./index.php'){
		paop=paop.split('?');
		paop=paop[1];
		if(!paop){
			return {};
		}
		paop=paop.split('&');
		
		paop.forEach(function(p){
			p=p.split('=');
			if(p[0] && p[1]){
				if(p[0]=='plugin'){
					params.plugin=p[1];
				}else if(p[0]=='action'){
					params.action=p[1];
				}else if(p[0]=='op'){
					params.op=p[1];
				}else{
					if(!params.query){
						params.query={};
					}
					params.query[p[0]]=p[1];
				}
			}
		});
		if(params.query){
			params.query=util.made_query(params.query);
		}
	}else{
		paop=paop.split('/');
		var num=paop.length;
		switch(num){
			case 4:
				params={'plugin':paop['0']?paop['0']:'','action':paop['1']?paop['1']:'','op':paop['2']?paop['2']:'','query':paop['3']?paop['3']:''};
				break;
			case 3:
				params={'plugin':paop['0']?paop['0']:'','action':paop['1']?paop['1']:'','op':paop['2']?paop['2']:''};
				break;
			case 2:
				params={'action':paop['0']?paop['0']:'','op':paop['1']?paop['1']:''};
				break;
			case 1:
				params={'op':paop['0']?paop['0']:''};
				break;
			default:
				params={};
		}
	}
	
	if(query){
		if(params.query){
			params.query=params.query+'&'+query;
		}else{
			params.query=query;
		}
	}
	//结合当前访问URL补足参数
	if(!no){
		var app=getApp();
		params.plugin=params.plugin || app.access.plugin;
		params.action=params.action || app.access.action;
	}
	return params;
}
util.h5url=function(h5url){
	var h5array=h5url.split('#!#%2Fpage%2F');
	if(h5array[1]){
				var index=h5url.indexOf('?');
				var h5urltop=h5url.substring(0,index+1);
				h5url=h5urltop+h5array[1];
	}
	return h5url;
}
//订阅消息授权状态
util.getsubmsgSet=function(tmplIds,callback){
	wx.getSetting({
			withSubscriptions:true,
			success:function(res){
				var ShowSubMsg=false;
				for(var i=0;i<tmplIds.length;i++){
					if(res.subscriptionsSetting[tmplIds[i]]!='accept'){
						ShowSubMsg=true;
						break;
					}
				}
				callback(ShowSubMsg);
			}
	})
}
//系统支付接口
util.pay=function(id,callback,iswechat,isalipay){
	if(typeof(callback)!='function'){
		console.log('发起支付失败，回调函数错误！');
		return;
	}
	var app=getApp();
	util.get('core/member.pay/pay/id='+id,function(res){
		//console.log('util.pay');console.log(res);
		if(res.pay_type=='hdfk'){
			util.pay_hdfk(id,function(pay_result){
				callback(pay_result);
			});
			return;
		}else if(res.pay_type=='credit'){
			util.pay_credit(id,function(pay_result){
				callback(pay_result);
			});
			return;
		}else if(res.pay_type=='wechat' || iswechat){
			util.pay_wechat(id,function(pay_result){
				callback(pay_result);
			});
			return;
		}else if(res.pay_type=='alipay' || isalipay){
			util.pay_alipay(id,function(pay_result){
				callback(pay_result);
			});
			return;
		}
		res.type='more';
		res.pay_types=res.pay_types?res.pay_types:[];
		for(var i=0;i<res.pay_types.length;i++){
			if(res.pay_types[i]=='hdfk'){
				res.pay_hdfk=true;
			}else if(res.pay_types[i]=='credit'){
				res.pay_credit=true;
			}else if(res.pay_types[i]=='wechat' && app.setting.apptype!='aliapp'){
				res.pay_wechat=true;
			}else if(app.setting.apptype=='aliapp'){
				res.pay_alipay=true;
			}
		}
		callback(res);
	});
}
util.pay_wechat=function(id,callback){
	if(typeof(callback)!='function'){
		console.log('发起支付失败，回调函数错误！');
		return;
	}
	util.post('core/member.pay/wxapp_pay/id='+id,{},function(data){
				//发起微信支付
				data.success=function(res){
					var pay_result={
							'type':'success',
							'message':'支付成功！',
							'success_url':data.success_url?data.success_url:''
						};
					callback(pay_result);
				}
				data.fail=function(res){
					console.log('支付失败！收到的结果为：');console.log(res);
					var pay_result={
							'type':'error',
							'message':'支付失败！',
							'error_url':data.error_url?data.error_url:''
						};
					callback(pay_result);
				}
				wx.requestPayment(data);
	});
}
util.pay_alipay=function(id,callback){
	if(typeof(callback)!='function'){
		console.log('发起支付失败，回调函数错误！');
		return;
	}
	util.post('core/member.pay/aliapp_pay/id='+id,{},function(data){
				//发起支付宝支付
				data.success=function(res){
					var pay_result={
							'type':'success',
							'message':'支付成功！',
							'success_url':data.success_url?data.success_url:''
						};
					callback(pay_result);
				}
				data.fail=function(res){
					console.log('支付失败！收到的结果为：');console.log(res);
					var pay_result={
							'type':'error',
							'message':'支付失败！',
							'error_url':data.error_url?data.error_url:''
						};
					callback(pay_result);
				}
				my.tradePay({
						tradeNO: data.trade_no,  
						success: function(res) {            
						  
						},
						fail: function(res) {
							res= JSON.stringify(res)
							console.log(res);
							//util.msg('支付失败：'+res)
					   },
				});
	});
}
util.pay_credit=function(id,callback){
	if(typeof(callback)!='function'){
		console.log('发起支付失败，回调函数错误！');
		return;
	}
	wx.showModal({
		  title: "系统提示",
		  content: "确认要支付吗？",
		  confirmText: "确定",
		  cancelText: "取消",
		  success : function(res) {
			   if (res.confirm) {
					util.post('core/member.pay/credit/id='+id,{},function(data){
						//发起余额支付
						if(data=='success'){
							var pay_result={
									'type':'success',
									'message':'支付成功！',
									'success_url':data.success_url?data.success_url:''
								};
							callback(pay_result);
						}else{
							var pay_result={
									'type':'error',
									'message':'支付失败！',
									'error_url':data.error_url?data.error_url:''
								};
							callback(pay_result);
						}
					});
			   }
		  }
	});
}
util.pay_hdfk=function(id,callback){
	if(typeof(callback)!='function'){
		console.log('发起下单失败，回调函数错误！');
		return;
	}
	wx.showModal({
		  title: "系统提示",
		  content: "确认要货到付款吗？",
		  confirmText: "确定",
		  cancelText: "取消",
		  success : function(res) {
			  if (res.confirm) {
					util.post('core/member.pay/hdfk/id='+id,{},function(data){
							//发起货到付款
							if(data=='success'){
								var pay_result={
										'type':'success',
										'message':'下单成功！',
										'success_url':data.success_url?data.success_url:''
									};
								callback(pay_result);
							}else{
								console.log('支付失败！收到的结果为：');console.log(res);
								var pay_result={
										'type':'error',
										'message':'下单失败！',
										'error_url':data.error_url?data.error_url:''
									};
								callback(pay_result);
							}
					});
			  }
		  }
	});
}
util.date=function(time,nosec){
		if(!time || time==0){
			return '';
		}
		var myDate=new Date();
		myDate.setTime(time*1000);
		var year=myDate.getFullYear();
		var month=myDate.getMonth();
		month+=1;
		if(month<10){
			month='0'+month;
		}
		var day=myDate.getDate();
		if(day<10){
			day='0'+day;
		}
		var hour=myDate.getHours();
		if(hour<10){
			hour='0'+hour;
		}
		var min=myDate.getMinutes();
		if(min<10){
			min='0'+min;
		}
		var sec=myDate.getSeconds();
		if(sec<10){
			sec='0'+sec;
		}
		if(nosec){
			return year+'-'+month+'-'+day+' '+hour+':'+min;
		}
		return year+'/'+month+'/'+day+' '+hour+':'+min+':'+sec;
}
util.up_file=function(type,callback){
		if(type=='images'){
			util.images(function(res){
				callback(res);
			});
		}else if(type=='video'){
			util.video(function(res,thumb){
				callback(res,thumb);
			});
		}else{
			util.image(function(res){
				callback(res);
			});
		}
}
util.image=function(callback){
	var choose={
		'count':1,
	};
	choose.success=function(res){
		//console.log('收到图片选择结果！');console.log(res);
		if(res.tempFilePaths){
			var app=getApp();
			wx.uploadFile({
				'url':app.setting.api_url_new?app.setting.api_url_new:app.setting.api_url,
				'filePath':res.tempFilePaths[0],
				'name':'up_file[0]',
				'formData':{'ssid':app.ssid,'token':app.token,'plugin':'core','action':'tools.file_upload','op':'local_file','type':'image'},
				'success':function(ress){
					if(ress.data){
						//console.log('收到上传结果！');console.log(ress);
						var result=JSON.parse(ress.data);
						if(result.type=='success'){
							callback(result.message[0]);
						}
					}
				}
			});
		}
	}
	wx.chooseImage(choose);
}
util.images=function(callback){
	var choose={
		'count':9,
	};
	choose.success=function(res){
		//console.log('收到图片选择结果！');console.log(res);
		if(res.tempFilePaths){
			util.upload_image(res.tempFilePaths,callback);
		}
	}
	wx.chooseImage(choose);
}
util.upload_image=function(tempFilePaths,callback,result_list){
		if(!result_list){
			result_list=[];
		}
		if(tempFilePaths.length<=0){
			callback(result_list);
			return;
		}
		var filePath=tempFilePaths.pop();
		var app=getApp();
		wx.uploadFile({
				'url':app.setting.api_url_new?app.setting.api_url_new:app.setting.api_url,
				'filePath':filePath,
				'name':'up_file[0]',
				'formData':{'ssid':app.ssid,'token':app.token,'plugin':'core','action':'tools.file_upload','op':'local_file','type':'image'},
				'success':function(ress){
					if(ress.data){
						//console.log('收到上传结果！');console.log(ress);
						var result=JSON.parse(ress.data);
						if(result.type=='success'){
							//callback(result.message[0]);
							result_list.push(result.message[0]);
							util.upload_image(tempFilePaths,callback,result_list);
						}
					}
				}
		});
}
util.video=function(callback){
	var choose={
		sourceType: ['album', 'camera'],
		maxDuration: 60,
		camera: 'back',
	};
	choose.success=function(res){
		console.log('收到视频选择结果！');console.log(res);
		if(res.tempFilePath){
			var app=getApp();
			wx.uploadFile({
				'url':app.setting.api_url_new?app.setting.api_url_new:app.setting.api_url,
				'filePath':res.tempFilePath,
				'name':'up_file[0]',
				'formData':{'ssid':app.ssid,'token':app.token,'os':'wxapp','plugin':'core','action':'tools.file_upload','op':'local_file','type':'video'},
				'success':function(ress){
					console.log('收到上传结果！');console.log(ress);
					if(ress.data){
						var result=JSON.parse(ress.data);
						if(result.type=='success'){
							callback(result.message[0],result.message[1]);
						}
					}
				},
				'fail':function(res){
					console.log('收到上传失败结果！');console.log(res);
				}
			});
		}
	}
	wx.chooseVideo(choose);
}
util.price=function(fee){
	 fee=fee?fee:0;
	 //console.log(fee);
	 var fee=Math.round(parseFloat(fee)*100)/100;
	 var xsd=fee.toString().split(".");
	 if(xsd.length==1){
		 fee=fee.toString()+".00";
	 }
	 if(xsd.length>1){
		 if(xsd[1].length<2){
			 fee=fee.toString()+"0";
		 }
	 }
	 return fee;
}
util.duoxuans=function(value,to,callback){
	if(to==undefined || to==''){
		to=';';
	}
	if(to.indexOf(';'+value+';')<0){
		to=to+value+';';
	}else{
		to=to.replace(';'+value+';',';');
		if(to==';'){
			to='';
		}
	}
	callback(to);
}
module.exports = util;