<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
//公众号列表。需要展现的数据：公众号名称，所属用户，公众号logo，用户有效期（如果有）
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();

if($_RQ['op']=='list'){
	$params=array('type'=>3);
	if(!empty($_RQ['name'])){
		$params['name like']='%'.trim($_RQ['name']).'%';
		$return['params']['name']=$_RQ['name'];
	}
	if(!empty($_RQ['nickname'])){
		$params['nickname like']='%'.trim($_RQ['nickname']).'%';
		$return['params']['nickname']=$_RQ['nickname'];
	}
	if($_RQ['status']){
		$params['status']=intval($_RQ['status']);
		$return['params']['status']=$_RQ['status'];
	}
	$orderby='star desc,id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$fields=array(
		'uniacid',
		'name',
		'status',
		'nickname',
		'avatar',
		'star',
		array(
			'table'=>'core_accounts',
			'join'=>array('uniacid','uniacid'),
			'fields'=>array('groupid','title','logo','endtime','stop','credit1','credit2','agent_id')
		)
	);
	$total='';
	$list=pdo_getslice('core_users',$params,array($pindex,$psize),$total,$fields,'',$orderby);
	$admin=pdo_get('core_users',array('id'=>1),$fields);
	array_unshift($list,$admin);
	foreach($list as &$item){
		$item['status2']=$item['status']?0:1;
		$item['nickname']=$item['nickname']?:'无';
		$item['endtime_show']=$item['endtime']?date('Y/m/d H:i:s',$item['endtime']):'长期有效';
		$item['agent_name']=$item['agent_id']?pdo_getcolumn('core_users',array('id'=>$item['agent_id']),'name'):'无';
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['statuss']=array(
		'0'=>'正常',
		'1'=>'待审核',
		'2'=>'已禁止',
	);
	$return['stops']=array(
		'0'=>'正常',
		'1'=>'被禁止',
	);
	$return['groups']=pdo_getall('core_account_group',array(),array('id','title'),'id');
	$htmls=array(
		'type'=>'list',
		'list'=>array('data'=>'list','psize'=>$psize,'total'=>$total,'key'=>'uniacid','edit'=>false,'del_one'=>false,'tip'=>'每个用户拥有一个主账号，在该帐号下，系统可以添加多个公众号和小程序，公众号和小程序的运营数据和会员数据统一在该主账号下，方便用户管理...','list'=>array(
			array('name'=>'uniacid','title'=>'站点编号','type'=>'string'),
			array('name'=>'logo','title'=>'站点logo','type'=>'image'),
			array('name'=>'star','title'=>'星数','type'=>'star','set'=>'star'),
			array('name'=>'stop','title'=>'站点状态','type'=>'radio','options'=>'stops'),
			array('title'=>'账号_username','type'=>'img_string','img'=>'avatar',
			'data'=>array(
				array('title'=>'账号：','name'=>'name'),
				array('title'=>'昵称：','name'=>'nickname')
				)
			),
			array('name'=>'status2','title'=>'用户状态','type'=>'switch','set'=>'set'),
			array('name'=>'agent_name','title'=>'推荐人','type'=>'string'),
			array('name'=>'endtime_show','title'=>'有效期/到期时间','type'=>'string'),
			array('name'=>'groupid','title'=>'账户套餐','type'=>'select','options'=>'groups'),
			//array('name'=>'credit1','title'=>'账户积分','type'=>'string'),
			array('name'=>'credit2','title'=>'账户余额','type'=>'string'),
		),'action'=>array(
			array('op'=>'guanli','title'=>'管理','type'=>'href'),
			array('op'=>'perm','title'=>'套餐设置','type'=>'href','show'=>array('uniacid >'=>1)),
			array('op'=>'credit','title'=>'充值','type'=>'modal','show'=>array('uniacid >'=>1)),
			array('op'=>'password','title'=>'重置密码','type'=>'modal','show'=>array('uniacid >'=>1)),
			array('op'=>'stop','show'=>array('stop'=>0,'uniacid >'=>1),'title'=>'禁止','type'=>'post','message'=>'禁止后，该站点下的所有账号均无法登陆后台！但是站点页面依然可以访问！确认禁止吗？'),
			array('op'=>'unstop','show'=>array('stop',1),'title'=>'解除禁止','type'=>'post','message'=>'解除禁止后，该站点下的所有账号可再次登陆后台进行管理操作！确认恢复吗？'),
			array('op'=>'del','title'=>'删除','type'=>'post','show'=>array('uniacid >'=>1,'endtime <'=>TIMESTAMP,'endtime >'=>0),'message'=>'删除后该用户及所属站点将全部不可用！确定删除吗？'),
		)),
		'search'=>array(
			array('type'=>'string','width'=>'15','name'=>'name','title'=>'用户名'),
			array('type'=>'string','width'=>'15','name'=>'nickname','title'=>'昵称','help'=>''),
			array('type'=>'radio','width'=>'15','name'=>'status','title'=>'状态','options'=>'statuss'),
			//array('type'=>'select','width'=>'15','name'=>'groupid','title'=>'套餐','options'=>'groups'),
		),
	);
	$return['htmls']=$htmls;
	$tabs=array(
		array('op'=>'list','title'=>'用户列表'),
		array('op'=>'add','title'=>'添加用户'),
	);
	set_html('tabs',$tabs);
	exi($return);
}
if($_RQ['op']=='guanli'){
	$uniacid=intval($_RQ['uniacid']);
	if($uniacid){
		$_SESSION['uniacid']=$uniacid;
		$account=pdo_get('core_accounts',array('uniacid'=>$_SESSION['uniacid']),array('groupid','title','logo'));
		$_SESSION['account']=$account;
		set_html('account',$account);
		$url='/account.siteinfo/';
		if($account['groupid']){			
			$group=pdo_get('core_account_group',array('id'=>$account['groupid']),array('plugin_name','index_url'));
			if($group['index_url']){
				$url=$group['index_url'];
			}
			if($group['plugin_name']){
				$_SESSION['current_plugin']=$group['plugin_name'];
			}
		}
		exi('管理成功！','',manage_url($url,true));
	}
	exi('管理公众号失败，请联系站点管理员！');
}
if($_RQ['op']=='edit'){
	$uniacid=intval($_RQ['uniacid']);
	if($uniacid){
		$_SESSION['uniacid']=$uniacid;
		$account=pdo_get('core_accounts',array('uniacid'=>$_SESSION['uniacid']),array('title','logo'));
		set_html('account',$account);
		exi('','','/setting.site/');
	}
	exi('管理公众号失败，请联系站点管理员！');
}
if($_RQ['op']=='stop'){
	//禁止站点。使站点下的账号无法访问后台进行管理，但站点页面依然可以访问！
	
	$uniacid=intval($_RQ['uniacid']);
	if(!$uniacid){
		exi('请先选择要禁止的公众号！','error');
	}
	if($uniacid==1){
		exi('创始人账户不支持禁止！','error');
	}
	pdo_update('core_accounts',array('stop'=>1),array('uniacid'=>$uniacid));
	exi('禁止成功！');
}
if($_RQ['op']=='unstop'){
	//恢复站点，使站点下的账号可以访问后台
	$uniacid=intval($_RQ['uniacid']);
	if(!$uniacid){
		exi('请先选择要恢复的公众号！','error');
	}
	pdo_update('core_accounts',array('stop'=>0),array('uniacid'=>$uniacid));
	exi('恢复成功！');
}
if($_RQ['op']=='perm'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$update=array(
			'groupid'=>intval($post['groupid']),
			'attachment'=>intval($post['attachment']),
			'endtime'=>strtotime($post['endtime']),
		);
		$uniacid=intval($post['uniacid']);
		pdo_update('core_accounts',$update,array('uniacid'=>$uniacid));
		exi('设置成功！','','list');
	}else{
		$uniacid=intval($_RQ['uniacid']);
		if(!$uniacid){
			exi('请先选择要管理的公众号！','error');
		}
		$item=pdo_get('core_accounts',array('uniacid'=>$uniacid),array('uniacid','title','groupid','endtime','credit1','credit2','attachment'));
		$item['endtime']=date('20y-m-d H:i',$item['endtime']);
		$return['item']=$item;
		$return['htmls']=array(
			'type'=>'edit',
			'desc'=>'管理站点信息',
			'edit'=>array(
				array('type'=>'string','name'=>'title','title'=>'站点名称','read'=>true),
				array('type'=>'string','name'=>'credit1','title'=>'账户积分','read'=>true),
				array('type'=>'string','name'=>'credit2','title'=>'账户余额','read'=>true),
				array('type'=>'select','name'=>'groupid','title'=>'站点套餐','options'=>'groups'),
				array('type'=>'string','name'=>'attachment','title'=>'账户容量'),
				array('type'=>'time','name'=>'endtime','title'=>'有效期'),
				
			),
		);
		$return['groups']=pdo_getall('core_account_group',array(),array('id','title'));
		exi($return);
	}
	
}
if($_RQ['op']=='add'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$user=array(
			'name'=>trim($post['name']),
			'password'=>trim($post['password']),
			'groupid'=>intval($post['groupid']),
			'endtime'=>strtotime($post['endtime']),
			'credit1'=>intval($post['credit1']),
			'credit2'=>intval($post['credit2']),
		);
		$check=pdo_getcolumn('core_users',array('name'=>$user['name']),'id');
		if($check){
			exi('用户名已存在，请更换！','error');
		}
		cfc('user')->create_user($user);
		exi('创建成功！','','list');
	}else{
		
		$return['item']=array();
		$return['htmls']=array(
			'type'=>'edit',
			'desc'=>'管理站点信息',
			'edit'=>array(
				array('type'=>'string','name'=>'name','title'=>'用户账号'),
				array('type'=>'string','name'=>'password','title'=>'用户密码'),
				array('type'=>'select','name'=>'groupid','title'=>'套餐','options'=>'groups'),
				array('type'=>'time','name'=>'endtime','title'=>'有效期'),
				array('type'=>'string','name'=>'credit1','title'=>'账户积分'),
				array('type'=>'string','name'=>'credit2','title'=>'账户余额'),
			),
		);
		$return['groups']=pdo_getall('core_account_group',array(),array('id','title'));
		exi($return);
	}
	
}
if($_RQ['op']=='del'){
	//删除公众号，先导出所有公众号数据保存，然后删除公众号数据
	//检索所有的表，如果表里面有字段uniacid，则删除相关数据
	$dels=array();
	if($_RQ['del']){
		$dels=str_array($_RQ['del']);
	}
	$uniacid=intval($_RQ['uniacid']);
	if($uniacid){
		$dels[]=$uniacid;
	}
	if(!$dels){
		exi('没有选择公众号','error');
	}
	foreach($dels as $uniacid){
		if($uniacid==1){
			exi('创始人账户不支持删除！','error');
		}
		$account=pdo_get('core_accounts',array('uniacid'=>$uniacid),array('title'));
		if(!$account){
			exi('要删除的站点不存在！','error');
		}
		$ignores=array('core_settings','core_cache','core_session','core_plugins','core_user_failed_login');
		$tables=pdo_fetchall("SHOW TABLES LIKE '".TABLE_PRE."core_%'");
		$data=array();
		$del=array();
		foreach($tables as $table){
			$tablename=reset($table);
			$name=explode('_',$tablename,2);
			$name=$name['1'];
			if(pdo_fieldexists($name,'uniacid')){
				$data[$name]=pdo_getall($name,array('uniacid'=>$uniacid));
				if($data[$name]){
					$del[]=$name;
				}
			}
		}
		$data=serialize($data);
		$filename=cfc('files')->source_save($data,'account_bak','bak','删除站点“'.$account['title'].'”后的备份数据');
		$bak=array('title'=>$account['title'],'uniacid'=>$uniacid,'reason'=>'管理员'.$_SESSION['user']['name'].'手动删除','file'=>$filename,'createtime'=>TIMESTAMP);
		pdo_insert('core_account_recycle',$bak);
		foreach($del as $name){
			pdo_delete($name,array('uniacid'=>$uniacid));
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='credit'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$credit=array(
			'type'=>intval($post['type']),
			'is_add'=>intval($post['is_add']),
			'fee'=>intval($post['fee']),
			'remark'=>"管理员{$_SESSION['user']['name']}【{$_SESSION['uid']}】手动操作：{$post['remark']}",
		);
		$uniacid=intval($post['uniacid']);
		model('core/web',$uniacid)->account_credit($credit);
		exi('操作成功！','','list');
	}else{
		$uniacid=intval($_RQ['uniacid']);
		if(!$uniacid){
			exi('请先选择要充值的用户！','error');
		}
		$item=pdo_get('core_accounts',array('uniacid'=>$uniacid),array('uniacid','title','credit1','credit2'));
		$item['name']=pdo_getcolumn('core_users',array('id'=>$uniacid),'name');
		$return['item']=$item;
		$return['htmls']=array(
			'type'=>'edit',
			'edits'=>array(
				array('title'=>'用户信息','list'=>array(
					array('type'=>'string','name'=>'title','title'=>'站点名称','read'=>true),
					array('type'=>'string','name'=>'name','title'=>'主账户','read'=>true),
					array('type'=>'string','name'=>'credit1','title'=>'账户当前积分','read'=>true),
					array('type'=>'string','name'=>'credit2','title'=>'账户当前余额','read'=>true),
				)),
				array('title'=>'充值设置','list'=>array(
					array('type'=>'radio','name'=>'type','title'=>'积分类型','options'=>'types'),
					array('type'=>'radio','name'=>'is_add','title'=>'修改方式','options'=>'is_adds'),
					array('type'=>'string','name'=>'fee','title'=>'修改金额'),
					array('type'=>'text','name'=>'remark','title'=>'备注'),
				)),
			),
		);
		$return['types']=array('1'=>'积分','2'=>'余额');
		$return['is_adds']=array('0'=>'减少','1'=>'增加');
		exi($return);
	}
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['uniacid']);
	if(!$id){
		exi('参数错误！','error');
	}
	if($id==1){
		exi('创始人账户不支持设置！','error');
	}
	$update=array();
	$post=get_postdata();
	if(isset($post['status2'])){
		$update['status']=$post['status2']?0:1;
	}
	if($update){
		pdo_update('core_users',$update,array('id'=>$id));
	}
	exi('操作成功！');
}
if($_RQ['op']=='star'){
	$id=intval($_RQ['uniacid']);
	if(!$id){
		exi('参数错误！','error');
	}
	$update=array();
	$post=get_postdata();
	if(isset($post['star'])){
		$update['star']=$post['star'];
	}
	if($update){
		pdo_update('core_users',$update,array('id'=>$id));
	}
	exi('操作成功！');
}
if($_RQ['op']=='password'){
	//重置密码
	if($_RQ['postdata']){
		$post=get_postdata();
		if($post['passwd1']!=$post['passwd2']){
			exi('两次输入密码不一致！','error');
		}
		$update=array('salt'=>random(8));
		$update['password']=get_password($post['passwd1'],$update['salt']);
		pdo_update('core_users',$update,array('id'=>intval($post['id'])));
		
		exi('操作成功！');
	}else{
		$uniacid=intval($_RQ['uniacid']);
		if(!$uniacid){
			exi('请先选择用户！','error');
		}
		$item=pdo_get('core_users',array('id'=>$uniacid),array('id','name'));
		$return['item']=$item;
		$return['htmls']=array(
			'type'=>'edit',
			'desc'=>'重置用户密码',
			'edit'=>array(
				array('type'=>'string','name'=>'name','title'=>'用户账号','read'=>true),
				array('type'=>'password','name'=>'passwd1','title'=>'输入密码'),
				array('type'=>'password','name'=>'passwd2','title'=>'再次输入密码'),
			),
		);
		exi($return);
	}
}
?>