<?php
/*
	账户支付
	支付成功后如何通知支付发起者？访问发起者回调页面。如何通知支付结果？通过session通知。
*/

defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'main';
$setting=core_setting('pay');
$return=array();
if($_RQ['op']=='main'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('发起支付失败！','error','goback');
	}
	$pay=pdo_get('core_account_pay_log',array('id'=>$id));
	if(!$pay){
		exi('找不到要支付的订单！','','goback');
	}
	if($pay['status']){
		exi('订单已支付！','','goback');
	}
	$pay_types=get_pay_types();
	foreach($pay_types as $key=>$value){
		if(!$setting[$key]){
			unset($pay_types[$key]);
		}
	}
	if($pay['no_type']){
		$pay['no_type']=json_decode($pay['no_type'],true);
		foreach($pay['no_type'] as $row){
			if($pay_types[$row]){
				unset($pay_types[$row]);
			}
		}
	}
	$return['pay_types']=$pay_types;
	$return['item']=array_fields(array('id','title','ordersn','pay_type','fee'),$pay);
	$return['htmls']=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'确认订单',
		'edit'=>array(
			array('type'=>'string','name'=>'ordersn','title'=>'订单号','read'=>true),
			array('type'=>'string','name'=>'title','title'=>'订单名称','read'=>true),
			array('type'=>'string','name'=>'fee','title'=>'订单金额','read'=>true),
			array('type'=>'radio','name'=>'pay_type','title'=>'支付方式','options'=>'pay_types'),
		),
	);
	exi($return);
}
if($_RQ['op']=='post'){
	$post=get_postdata();
	$id=intval($post['id']);
	$pay_type=trim($post['pay_type']);
	if(!$id){
		exi('请先选择要支付的订单！','error');
	}
	$pay_log=pdo_get('core_account_pay_log',array('id'=>$id));
	if(!$pay_log){
		exi('指定订单不存在！','error');
	}
	if($pay_log['status']){
		exi('订单已支付，请勿重复支付！','error');
	}
	if(!$pay_type){
		exi('请先选择支付方式！','error');
	}
	if($pay_type=='credit'){
		//余额支付
		$credit2=pdo_getcolumn('core_accounts',array('uniacid'=>$_SESSION['uniacid']),'credit2');
		if($pay_log['fee']>$credit2){
			exi('余额不足！','error');
		}
		$credit2=$credit2-$pay_log['fee'];
		pdo_update('core_accounts',array('credit2'=>$credit2),array('uniacid'=>$_SESSION['uniacid']));
		
		$log=array(
			'uniacid'=>$_SESSION['uniacid'],
			'type'=>2,
			'is_add'=>0,
			'fee'=>$pay_log['fee'],
			'remark'=>'支付订单【'.$pay_log['ordersn'].'】：'.$pay_log['title'],
			'createtime'=>TIMESTAMP
		);
		pdo_insert('core_account_credit_log',$log);
		$log_id=pdo_insertid();
		payresult(array('id'=>$pay_log['id'],'fee'=>$pay_log['fee'],'transaction_id'=>$log_id,'pay_type'=>'credit'));
	}
	if($pay_type=='wechat'){
		//微信支付
		if(!$setting['appid'] || !$setting['mch_id'] || !$setting['api_key']){
			exi('微信支付参数未配置，请联系管理员或者选择其他支付方式！','error');
		}
		$url='https://api.mch.weixin.qq.com/pay/unifiedorder';
		$post=array(
			'appid'=>trim($setting['appid']),
			'mch_id'=>trim($setting['mch_id']),
			'device_info'=>'WEB',//设备名称
			'nonce_str'=>random(32),//随机字符串
			'body'=>$pay_log['title'],//浏览器打开的网站主页title名 -商品概述
			'out_trade_no'=>$pay_log['ordersn'],//订单号
			'total_fee'=>$pay_log['fee']*100,//单位分
			'attach'=>$_SESSION['uniacid'],//自定义参数
			'spbill_create_ip'=>$_SERVER['REMOTE_ADDR'],//当前客户端ip
			'notify_url'=>SITEROOT.'manage/payresult/wechat.php',//回调域名
			'trade_type'=>'NATIVE',//扫码支付为原生
			'product_id'=>$pay_log['id'],//产品编号
		);
		ksort($post);
		$str='';
		foreach($post as $key=>$value){
			$str.=$key.'='.$value.'&';
		}
		$stringSignTemp=$str.'key='.trim($setting['api_key']);
		$sign=strtoupper(md5($stringSignTemp));
		$post['sign']=$sign;
		$return=cfc('http')->ihttp_request($url,array2xml($post));
		$code=xml2array($return['content']);
		$codeurl=$code['code_url'];
		if(!$codeurl){
			exi('生成支付二维码失败,请联系开发者检查微信支付参数！','error');
		}
		$_SESSION['pay_url']=$codeurl;
		exi('','success','core/account.pay/pay_wechat/id='.$pay_log['id']);
	}
	if($pay_type=='alipay'){
		//支付宝支付
		exi('请在新打开的页面中完成支付！','','',download_url('core/account.pay/pay_alipay/id='.$id));
	}
	if($pay_type=='yinlian'){
		exi('银联支付开发中！请选择其他支付方式！','error');
	}
}
if($_RQ['op']=='pay_wechat'){
	$id=intval($_RQ['id']);
	$pay_log=pdo_get('core_account_pay_log',array('id'=>$id));
	if(!$pay_log){
		exi('指定订单不存在！','error');
	}
	if($pay_log['status']){
		exi('订单已支付，请勿重复支付！','error');
	}
	if(!$_SESSION['pay_url']){
		exi('支付失败，支付二维码生成失败！','error');
	}
	$return['item']=array(
		'id'=>$id,
		'title'=>$pay_log['title'],
		'url'=>$_SESSION['pay_url'],
	);
	unset($_SESSION['pay_url']);
	$return['htmls']=array(
		'type'=>'look',
		'desc'=>'请用微信扫描下面的二维码完成支付',
		'tabs'=>array(
			array('op'=>'list','action'=>'account.pay_log','title'=>'支付日志'),
		),
		'look'=>array(
			array('type'=>'string','name'=>'title','title'=>'订单名称'),
			array('type'=>'ewm','name'=>'url','title'=>'支付二维码','help'=>'请扫描上面的二维码完成支付'),
		),
	);
	exi($return);
}
if($_RQ['op']=='pay_alipay'){
	//支付宝支付
	$id=intval($_RQ['id']);
	if(!$id){
		exit('支付出错：请先选择要支付的订单！');
	}
	$order=pdo_get('core_account_pay_log',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	if(!$order){
		exit('支付出错：要支付的订单不存在！');
	}
	
	$data=array(
		'subject'=>$order['title'],
		'total_fee'=>$order['fee'],
		'return_url'=>manage_url('core/account.pay/pay_alipay_result',true),
		'notify_url'=>SITEROOT.'manage/payresult/alipay.php',
		'out_trade_no'=>$order['ordersn'],
	);
	$html=cfc('core')->getalipay($data);
	exit($html);
}
if($_RQ['op']=='pay_alipay_result'){
	 require_once(ROOT_D.'/core/library/alipay/lib/alipay_notify.class.php');
	unset($_GET['token']);
	unset($_GET['this']);
	unset($_GET['plugin']);
	unset($_GET['action']);
	unset($_GET['op']);
	unset($_GET['is_access']);
	unset($_GET['nosession']);
	$config=core_setting('pay');
	$alipay_config=array(
		'sign_type'=>'MD5',
		'input_charset'=>'utf-8',
		'cacert'=>ROOT_D.'/core/library/alipay/cacert.pem',
		'transport'=>'http',
		'partner'=>$config['alipay_partner'],
		'seller_email'=>$config['alipay_seller_email'],
		'key'=>$config['alipay_key'],
	);
    $alipayNotify = new AlipayNotify($alipay_config);
    $verify_result = $alipayNotify->verifyReturn();
    if($verify_result) {//验证成功
		//商户订单号
		payresult(array('ordersn'=>$_GET['out_trade_no'],'fee'=>$_GET['total_fee'],'transaction_id'=>$_GET['trade_no'],'pay_type'=>'alipay'));
	}else {
		exi('支付失败！回调验证失败！','error','core/account.pay_log/list');
	}
}
