<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	微站列表
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
if($_RQ['op']=='list'){
	$params=array();
	$params=array('uniacid'=>$_SESSION['uniacid']);
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$list=pdo_getslice('core_account_store',$params,array($pindex,$psize),$total,array('id','storename','logo','group_id','address','tel','status'),'',$orderby);
	if($list){
		foreach($list as &$row){
			$row['group_id']=pdo_getcolumn('core_account_store_group',array('id'=>$row['group_id']),'title');
		}
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'门店列表'),
			array('op'=>'edit','title'=>'添加门店'),
			array('op'=>'update','title'=>'同步微信门店'),
		),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'logo','title'=>'logo','type'=>'image'),
			array('name'=>'storename','title'=>'门店名称','type'=>'string'),
			array('name'=>'group_id','title'=>'门店分类','type'=>'string'),
			array('name'=>'address','title'=>'门店地址','type'=>'string'),
			array('name'=>'tel','title'=>'门店电话','type'=>'string'),
			array('name'=>'status','title'=>'启用/关闭','type'=>'switch','set'=>'set'),
		)),
		'search_one'=>array('name'=>'storename','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='edit'){
	$return=array();
	$return['groups']=pdo_getall('core_account_store_group',array(),array('id','title'));
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_account_store',array('id'=>$id));
		if($item['naddress']){
			$item['naddress']=json_decode($item['naddress'],true);
		}
	}else{
		$item=array();
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'门店信息',
		'tabs'=>array(
			array('op'=>'list','title'=>'门店列表'),
			array('op'=>'edit','title'=>'添加门店'),
		),
		'edit'=>array(
			array('type'=>'string','title'=>'门店名称','name'=>'storename' ),
			array('type'=>'image','title'=>'logo','name'=>'logo' ),
			array('type'=>'switch','title'=>'是否开启','name'=>'status' ),
			array('type'=>'select','title'=>'门店分类','name'=>'group_id', 'options'=>'groups'),
			array('type'=>'string','title'=>'门店电话','name'=>'tel' ),
			array('type'=>'string','title'=>'手机号码','name'=>'mobile' ),
			array('type'=>'text','title'=>'门店介绍','name'=>'desc' ),
			array('type'=>'string','title'=>'门店地址','name'=>'address' ),
			array('type'=>'lat_lng','title'=>'地理位置','name'=>'naddress' ),
		)
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post'){
	$post=get_postdata();
	$data=array(
		'storename'=>trim($post['storename']),
		'logo'=>trim($post['logo']),
		'status'=>intval($post['status']),
		'group_id'=>intval($post['group_id']),
		'tel'=>trim($post['tel']),
		'mobile'=>trim($post['mobile']),
		'desc'=>trim($post['desc']),
		'address'=>trim($post['address']),
		'lat_lng'=>ijson_encode($post['lat_lng']),
		'branch_name'=>trim($post['branch_name']),
		'province'=>$post['pcd']['province'],
		'city'=>$post['pcd']['city'],
		'district'=>$post['pcd']['district'],
		'offset_type'=>3,
		'longitude'=>$post['lat_lng']['lng'],
		'latitude'=>$post['lat_lng']['lat'],
		'photo_list'=>ijson_encode($post['photo_list']),
		'recommend'=>trim($post['recommend']),
		'special'=>trim($post['special']),
		'open_time'=>trim($post['open_time']),
		'avg_price'=>trim($post['avg_price']),
	);
	$wxdata=array(
		'business_name'=>trim($post['storename']),
		'introduction'=>trim($post['desc']),
		'telephone'=>trim($post['telephone']),
		'address'=>trim($post['address']),
		'branch_name'=>trim($post['branch_name']),
		'province'=>$post['pcd']['province'],
		'city'=>$post['pcd']['city'],
		'district'=>$post['pcd']['district'],
		'offset_type'=>3,
		'longitude'=>$post['lat_lng']['lng'],
		'latitude'=>$post['lat_lng']['lat'],
		'photo_list'=>ijson_encode($post['photo_list']),
		'recommend'=>trim($post['recommend']),
		'special'=>trim($post['special']),
		'open_time'=>trim($post['open_time']),
		'avg_price'=>trim($post['avg_price']),
	);
	$id=intval($post['id']);
	if($id){
		pdo_update('core_account_store',$data,array('id'=>$id));
	}else{
		$data['createtime']=TIMESTAMP;
		$data['uniacid']=$_SESSION['uniacid'];
		pdo_insert('core_account_store',$data);
	}
	exi('保存成功！','','list');
}
if($_RQ['op']=='del'){
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_account_store',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			if(intval($id)){
				pdo_delete('core_account_store',array('id'=>intval($id)));
			}
		}
	}
	exi('删除成功！');
}