<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
 套餐价格机制调整说明：
	套餐默认价格采用年费制，如需设置更详细的价格，可在套餐规格中设置！
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();

if($_RQ['op']=='list'){
	//搜索
	$params=array();
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=trim($_RQ['title']);
	}

	$fields=array('id','title','isdefault','price','days','resource');
	$pindex = max(1, intval($_RQ['page']));
	$psize = 15;
	$total='';
	$list=pdo_getslice('core_account_group',$params,array($pindex,$psize),$total,$fields,'','isdefault desc,id desc');
	foreach($list as &$item){
		$item['accountsnum']=pdo_count('core_accounts',array('groupid'=>$item['id']));
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'服务套餐列表'),
			array('op'=>'edit','title'=>'添加服务套餐'),
			array('op'=>'update','title'=>'一键同步场景体套餐'),
			array('action'=>'/system.store_set/list/type=1','title'=>'功能价格设置'),
		),
		'list'=>array('data'=>'list','no_del'=>false,'del_message'=>'确认删除吗？','del_op'=>'del','html_to'=>'list_html','list'=>array(
			array('name'=>'title','title'=>'套餐名称','type'=>'string'),
			array('name'=>'isdefault','title'=>'默认套餐？','type'=>'radio','options'=>'isdefault'),
			array('name'=>'price','title'=>'套餐年费','type'=>'string'),
			array('name'=>'accountsnum','title'=>'站点数','type'=>'string'),
			array('name'=>'access','title'=>'访问频率（次/秒）','type'=>'string'),
			array('name'=>'resource','title'=>'附件容量(/M)','type'=>'string'),
		)),
		'search_one'=>array('name'=>'title'),

	);
	$return['isdefault']=array('否','是');
	$return['htmls']=$htmls;
	exi($return);
}

if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_account_group',array('id'=>$id));
		$item['options']=$item['options']?json_decode($item['options'],true):array();
		$item['diy_legao']=json_decode($item['diy_legao'],true);
	}else{
		$item=array('plugin_name'=>'');
	}
	$return['item']=$item;
	$return['sys_actions']=pdo_getall('core_permissions',array('price >'=>0,'type between'=>array(1,3)),array('id','title'),'id');
	foreach($return['sys_actions'] as &$action){
		$action=$action['title'];
	}
	$return['plugin_actions']=pdo_getall('core_plugins',array('price >'=>0),array('id','title'),'id');
	foreach($return['plugin_actions'] as &$plugin){
		$plugin=$plugin['title'];
	}
	$plugins=pdo_getall('core_plugins',array('hide'=>0,'is_legao'=>1),array('name','title'));
	$return['plugins']=$plugins;
	
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'套餐信息',
		'tabs'=>array(
			array('op'=>'list','title'=>'服务套餐列表'),
			array('op'=>'edit','title'=>'添加服务套餐'),
			array('action'=>'/system.store_set/list/type=1','title'=>'功能价格设置'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array('title'=>'基本信息','list'=>array(
				array('type'=>'string','title'=>'套餐名称','name'=>'title', 'help'=>'' ),
				//array('type'=>'string','title'=>'套餐腾讯云应用市场产品ID','name'=>'tc_product_id', 'help'=>'用于关联腾讯云市场发布产品，实现saas交付'),
				array('type'=>'string','title'=>'套餐年费','name'=>'price', 'help'=>'' ),
				//array('type'=>'radio','title'=>'收费周期','name'=>'time_type','help'=>'','options'=>'types'),
				array('type'=>'array_simple','title'=>'套餐规格','name'=>'options','fields'=>array(
					//array('type'=>'string','title'=>'规格名称','name'=>'title'),
					array('type'=>'string','title'=>'规格价格','name'=>'price'),
					array('type'=>'string','title'=>'规格时长','name'=>'num'),
					array('type'=>'radio','title'=>'时间单位','name'=>'time_type','options'=>'types'),
				)),
				//array('type'=>'string','title'=>'套餐有效期','name'=>'days', 'help'=>'设置套餐有效期。单位：天。例如设置为100，则表示该套餐有效期为100天，一百天后需要续费。'),
				array('type'=>'select','title'=>'绑定场景插件','name'=>'plugin_name', 'help'=>'不想指定某行业，只使用<em>大众的小程序，公众号这些功能</em>，这里可以不用设置；绑定场景插件后，套餐用户的权限跟随场景插件走','options'=>'plugins','option_value'=>'name'),
				array('type'=>'string','title'=>'公众号数量','name'=>'wechat_num', 'help'=>'允许添加公众号的个数'),
				array('type'=>'string','title'=>'小程序数量','name'=>'wxapp_num', 'help'=>'允许添加小程序的个数（包含支付宝/百度/头条等小程序个数）'),
				array('type'=>'string','title'=>'diy官网数量','name'=>'mobile_num', 'help'=>'允许添加微官网的个数（微官网和pc站是一起的，不另作区分，一个diy官网包含微官网和pc站）'),
				array('type'=>'string','title'=>'APP个数','name'=>'app_num', 'help'=>'允许添加APP的个数'),
				//array('type'=>'string','title'=>'支付宝小程序个数','name'=>'aliapp_num', 'help'=>'允许添加支付宝小程序的个数'),
				//array('type'=>'string','title'=>'百度小程序个数','name'=>'baiduapp_num', 'help'=>'允许添加百度小程序的个数'),
				//array('type'=>'string','title'=>'头条小程序个数','name'=>'ttapp_num', 'help'=>'允许添加头条小程序的个数'),
				array('name'=>'access','title'=>'访问频率','type'=>'string','help'=>'设置该套餐用户的站点每秒最高访问次数，不填或为零表示不限制。该功能需要在系统设置中开启“站点访问频率限制”功能方能生效。'),
				array('name'=>'resource','title'=>'附件容量','type'=>'string','help'=>'设置该套餐用户的站点所允许上传的最大附件容量，例如设置为100M，则当站点所有附件资源文件加起来超过100M时，将不再允许站点上传附件，以免过多占用系统资源'),
				array('type'=>'switch','title'=>'默认套餐','name'=>'isdefault', 'help'=>'设置是否作为默认套餐。用户注册后公众号套餐为默认套餐。用户套餐过期后，如果未禁止套餐过期用户登陆，系统将自动把用户套餐调整为默认套餐' ),
				array('type'=>'switch','title'=>'是否禁止续费','name'=>'no_renew', 'help'=>'禁止后，套餐过期后将只能更换套餐，而不能续费。适用免费体验套餐场景！' ),
				array('type'=>'switch','title'=>'禁止上传小程序？','name'=>'no_upwxapp', 'help'=>'禁止后，套餐将不允许上传发布版本！。适用免费体验套餐场景！' ),
				array('type'=>'checkbox_buy','title'=>'开启DIY平台','name'=>'opendiys','options'=>'diys', 'help'=>'温馨提示，未开启的服务，客户需要自己购买才行。具体价格，移步《系统管理——服务套餐——开启DIY功能价格设置，中设置价格》'),
				array('type'=>'checkbox','title'=>'套餐系统功能权限','name'=>'sys_actions','options'=>'sys_actions', 'help'=>'温馨提示，此处仅显示不免费的系统功能。所有系统功能默认都是免费的，如需设置收费，请前往系统管理——服务套餐——功能价格设置中设置价格。'),
				array('type'=>'checkbox','title'=>'套餐插件功能权限','name'=>'plugin_actions','options'=>'plugin_actions', 'help'=>'温馨提示，<red>如果绑定了场景体，组成本场景的插件会默认选中，就算取消也没用！保存后依然会被勾选！</red>此处仅显示不免费的插件功能。所有插件功能默认都是免费的，如需设置收费，请前往系统管理——服务套餐——功能价格设置中设置价格。'),
				array('type'=>'string','title'=>'套餐用户登录后访问页面','name'=>'index_url', 'help'=>'','show'=>array('plugin_name'=>'')),
				array('name'=>'diy_legao','type'=>'choose_many','title'=>'套餐应用设置','action'=>'/basic.get_plugins/many/','choose_title'=>'选择功能插件','help'=>'<red>此处添加的功能插件，会出现在本套餐下的《套餐应用》页面中！</red>'),
			)),
			array('title'=>'套餐介绍','list'=>array(
				array('type'=>'image','title'=>'套餐logo','name'=>'logo', 'help'=>'' ),
				array('type'=>'text','title'=>'套餐简介','name'=>'desc', 'help'=>'' ),
				array('type'=>'richtext','title'=>'套餐介绍','name'=>'content', 'help'=>'' ),
			))
		),
	);
	$return['htmls']=$htmls;
	$return['types']=array(
		'1'=>'天',
		'2'=>'月',
		'3'=>'年',
	);
	$app_prices=core_setting('app_price');
	$return['diys']=array(
		array('id'=>'wxapp','title'=>'微信小程序','icon'=>'fa-weixin','color'=>'#63BE72','price'=>$app_prices['wxapp']),
		array('id'=>'ttapp','title'=>'头条/抖音小程序','icon'=>'fa-pinterest','color'=>'#FF547B','price'=>$app_prices['ttapp']),
		array('id'=>'aliapp','title'=>'支付宝小程序','icon'=>'fa-facebook-square','color'=>'#4491F1','price'=>$app_prices['aliapp']),
		array('id'=>'baiduapp','title'=>'百度小程序','icon'=>'fa-behance-square','color'=>'#7783EA','price'=>$app_prices['baiduapp']),
		array('id'=>'qqapp','title'=>'QQ小程序','icon'=>'fa-qq','color'=>'#FF4444','price'=>$app_prices['qqapp']),
		array('id'=>'pc','title'=>'PC官网建站','icon'=>'fa-windows','color'=>'#FCC600','price'=>$app_prices['pc']),
		array('id'=>'xiu','title'=>'微场景','icon'=>'fa-dropbox','color'=>'#C3A769','price'=>$app_prices['xiu']),
		array('id'=>'h5game','title'=>'互动营销','icon'=>'fa-google-plus','color'=>'#FF547B','price'=>$app_prices['h5game']),
	);
	//$cs=var_export($return['plugin_actions'],true);
	//exi($cs,'error');
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	$data=array(
		'title'=>trim($postdata['title']),
		'price'=>intval($postdata['price']),
		'no_renew'=>intval($postdata['no_renew']),
		'days'=>intval($postdata['days']),
		'access'=>intval($postdata['access']),
		'wechat_num'=>intval($postdata['wechat_num']),
		'wxapp_num'=>intval($postdata['wxapp_num']),
		'mobile_num'=>intval($postdata['mobile_num']),
		'app_num'=>intval($postdata['app_num']),
		'aliapp_num'=>intval($postdata['aliapp_num']),
		'baiduapp_num'=>intval($postdata['baiduapp_num']),
		'ttapp_num'=>intval($postdata['ttapp_num']),
		'resource'=>intval($postdata['resource']),
		'sys_actions'=>trim($postdata['sys_actions']),
		'plugin_actions'=>trim($postdata['plugin_actions']),
		'isdefault'=>intval($postdata['isdefault']),
		'tc_product_id'=>intval($postdata['tc_product_id']),
		'plugin_name'=>trim($postdata['plugin_name']),
		'index_url'=>trim($postdata['index_url']),
		'time_type'=>intval($postdata['time_type']),
		'options'=>$postdata['options']?ijson_encode($postdata['options']):'',
		'logo'=>trim($postdata['logo']),
		'desc'=>trim($postdata['desc']),
		'content'=>trim($postdata['content']),
		'opendiys'=>trim($postdata['opendiys']),
		'diy_legao'=>ijson_encode($postdata['diy_legao']),
		'no_upwxapp'=>intval($postdata['no_upwxapp']),
	);
	if($data['isdefault']){
		if($data['plugin_name']){
			exi('默认套餐，不建议绑定场景体！','error');
		}else{
			pdo_update('core_account_group',array('isdefault'=>0),array('isdefault'=>1));
		}
	}
	if($data['plugin_name']){
		/*$data['wechat_num']=1;
		$data['mobile_num']=1;
		$data['app_num']=1;
		$data['aliapp_num']=1;
		$data['baiduapp_num']=1;
		$data['ttapp_num']=1;*/
		$data['index_url']=$data['plugin_name'].'/index/';
		/*
			接下来整理套餐权限，通过遍历插件菜单，找到插件需要使用的页面，并给予权限
			如果是系统页面，根据action找到权限ID；如果是插件页面，直接根据插件标识找到权限ID
		*/
		
		$urls=array();
		$menu=plugin($data['plugin_name'])->menu();
		foreach($menu as $menu1){
			if($menu1['url']){
				$urls[]=$menu1['url'];
			}
			if(!$menu1['child']){
				continue;
			}
			foreach($menu1['child'] as $menu2){
				if(!$menu2['child']){
					continue;
				}
				foreach($menu2['child'] as $menu3){
					if($menu3['url']){
						$urls[]=$menu3['url'];
					}
				}
			}
		}
		$plugin_actions=explode(';',$postdata['plugin_actions']);
		$sys_actions=explode(';',$postdata['sys_actions']);
		foreach($urls as $url){
			$url=links($url);
			if($url['plugin']=='core'){
				//系统页面权限
				$permission_id=pdo_getcolumn('core_permissions',array('action'=>$url['action'],'op'=>''),'id');
				if($permission_id){
					$sys_actions[]=$permission_id;
				}
			}else{
				//插件页面权限
				$permission_id=pdo_getcolumn('core_plugins',array('name'=>$url['plugin']),'id');
				if($permission_id && !in_array($permission_id,$plugin_actions)){
					$plugin_actions[]=$permission_id;
				}
			}
		}
		if($sys_actions){
			$data['sys_actions']=';'.implode(';',$sys_actions).';';
		}
		$cloud_id=pdo_getcolumn('core_plugins',array('name'=>$data['plugin_name']),'cloud_id');
		if($cloud_id){
			$diy_legao=cloud_request('update.plugin.pre_install',array('cloud_id'=>$cloud_id));
		}
		if($diy_legao){
			foreach($diy_legao as $legao){
				$permission_id=pdo_getcolumn('core_plugins',array('name'=>$legao['name']),'id');
				if($permission_id && !in_array($permission_id,$plugin_actions)){
					$plugin_actions[]=$permission_id;
				}
			}
		}
		if($plugin_actions){
			$data['plugin_actions']=';'.implode(';',$plugin_actions).';';
		}
	}
	$id=intval($postdata['id']);
	if($id){
		pdo_update('core_account_group',$data,array('id'=>$id));
		exi('公众号服务套餐修改成功！','','list');
	}else{
		$data['createtime']=TIMESTAMP;
		pdo_insert('core_account_group',$data);
		exi('公众号服务套餐增加成功！','','list');
	}
}
if($_RQ['op']=='update'){
	$plugins=pdo_getall('core_plugins',array('hide'=>0,'is_legao'=>1),array('name','title','image','description'));
	foreach($plugins as &$item){
		$isup=pdo_getcolumn('core_account_group',array('plugin_name'=>$item['name']),'id');
		if(!$isup){
			$data=array(
				'title'=>trim($item['title']).'场景套餐',
				'price'=>288,
				'days'=>365,
				'access'=>50,
				'resource'=>200,
				'wechat_num'=>1,
				'wxapp_num'=>1,
				'mobile_num'=>1,
				'app_num'=>1,
				'aliapp_num'=>1,
				'baiduapp_num'=>1,
				'plugin_name'=>$item['name'],
				'index_url'=>$item['name'].'/index/',
				'logo'=>$item['image'],
				'desc'=>$item['description'],
			);
			/*
				接下来整理套餐权限，通过遍历插件菜单，找到插件需要使用的页面，并给予权限
				如果是系统页面，根据action找到权限ID；如果是插件页面，直接根据插件标识找到权限ID
			*/
			
			$urls=array();
			$menu=plugin($item['name'])->menu();
			foreach($menu as $menu1){
				if($menu1['url']){
					$urls[]=$menu1['url'];
				}
				if(!$menu1['child']){
					continue;
				}
				foreach($menu1['child'] as $menu2){
					if(!$menu2['child']){
						continue;
					}
					foreach($menu2['child'] as $menu3){
						if($menu3['url']){
							$urls[]=$menu3['url'];
						}
					}
				}
			}
			$sys_actions=$plugin_actions=array();
			foreach($urls as $url){
				$url=links($url);
				if($url['plugin']=='core'){
					//系统页面权限
					$permission_id=pdo_getcolumn('core_permissions',array('action'=>$url['action'],'op'=>''),'id');
					if($permission_id){
						$sys_actions[]=$permission_id;
					}
				}else{
					//插件页面权限
					$permission_id=pdo_getcolumn('core_plugins',array('name'=>$url['plugin']),'id');
					if($permission_id && !in_array($permission_id,$plugin_actions)){
						$plugin_actions[]=$permission_id;
					}
				}
			}
			if($sys_actions){
				$data['sys_actions']=';'.implode(';',$sys_actions).';';
			}
			if($plugin_actions){
				$data['plugin_actions']=';'.implode(';',$plugin_actions).';';
			}
			$data['createtime']=TIMESTAMP;
			pdo_insert('core_account_group',$data);
		}
	}
	exi('同步套餐成功！','','list');
}
if($_RQ['op'] == 'del'){
	$id=intval($_RQ['id']);
	if($id){
		$title=pdo_getcolumn('core_account_group',array('id'=>intval($id)),'title');
		$isaccount=pdo_getcolumn('core_accounts',array('groupid'=>intval($id)),'groupid');
		if($isaccount){
			exi('《'.$title.'》下面存在站点，不允许删除！','error');
		}
		pdo_delete('core_account_group',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			if(intval($id)){
				$title=pdo_getcolumn('core_account_group',array('id'=>intval($id)),'title');
				$isaccount=pdo_getcolumn('core_accounts',array('groupid'=>intval($id)),'groupid');
				if($isaccount){
					exi('《'.$title.'》下面存在用户，不允许删除！','error');
				}
				pdo_delete('core_account_group',array('id'=>intval($id)));
			}
		}
	}
	exi('删除成功！');
}

?>