<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	插件小程序（小程序市场）
	直接从小程序市场选购，然后安装发布
	业务流程：先从小程序市场选购——选购成功后自动创建小程序，然后自动发起小程序授权——再通过开放平台提交代码，申请审核——审核通过后发布
	是否添加一个小程序列表管理所有小程序——对于插件小程序来说需要一个列表
	那么微官网小程序和diy小程序是否也一起放到这个列表里面呢。微官网小程序和diy小程序特点是直接扫码上传。一起放到小程序列表
	本页面执行功能：
	选购小程序，选购之后检查是否存在小程序ID，如果存在则直接更新，否则新建小程序然后自动发起授权。
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
if($_RQ['op']=='list'){
	//应用
	$aliapp_id=intval($_RQ['id']);
	$params=array();
	if($_RQ['title']){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=trim($_RQ['title']);
	}
	$pindex = max(1, $_RQ['page']);
	$psize = 15;
	$total='';
	$list = pdo_getall('core_plugins',array('hide'=>0,'type <'=>8),array('id','name','title','version'),'name');
	if (!empty($list)) {
		foreach ($list as &$item) {
			if(is_file(ROOT_D.'/addons/' . $item['name'] . '/icon.jpg')){
				$item['icon']='../addons/' . $item['name'] . '/icon.jpg';
			}
		}
	}else{
		$list=array();
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['groups']=get_plugin_styles();
	unset($return['groups'][8],$return['groups'][9]);
	//$all=array('id'=>0,'title'=>'全部');
	//array_unshift($return['groups'],$all);
	//print_r($return['list']);exit;
	exi($return);
}
if($_RQ['op']=='dabao'){
	if($_SESSION['account']['groupid']){
			$limit=pdo_getcolumn('core_account_group',array('id'=>$_SESSION['account']['groupid']),'aliapp_num');
			$num=pdo_count('core_account_aliapp',array('uniacid'=>$_SESSION['uniacid']));
			if($num>=$limit){
				exi('您所添加的小程序已达到最大值，如需创建更多，请联系管理员提升权限或者升级套餐！','error');
			}
		}
	$title=intval($_RQ['title']);
	if($_RQ['postdata']){
		$post=get_postdata();
		$insert=array(
			'uniacid'=>$_SESSION['uniacid'],
			'type'=>7,
			'title'=>$post['title'],
			'appid'=>$post['appid'],
			'appsecret'=>$post['appsecret'],
			'oldid'=>$post['oldid'],
			'url'=>$post['url'],
			'createtime'=>TIMESTAMP
		);
		pdo_insert('core_account_aliapp',$insert);
		$id=pdo_insertid();
		exi('添加成功！','',array('op'=>'list'));
	}else{
		$return['item']=array();
		$return['htmls']=array(
			'type'=>'edit',
			'desc'=>'设置小程序类型',
			'tabs'=>array(
				array('op'=>'list','title'=>'返回应用列表'),
			),
			'edit'=>array(
				array('type'=>'string','name'=>'title','title'=>'小程序名称'),
				array('type'=>'string','title'=>'appid','name'=>'appid','help'=>'填写小程序appid' ),
				array('type'=>'string','title'=>'appsecret','name'=>'appsecret','help'=>'填写小程序 appsecret' ),
				array('type'=>'string','title'=>'原始ID','name'=>'oldid','help'=>'填写小程序原始ID' ),
				array('type'=>'string','name'=>'url','title'=>$title.'的微信端链接','help'=>'例如：https://www.xxxx.com/app/./index.php?i=888&c=entry&eid=1'),
			),
		);
		exi($return);
	}
	
}
if($_RQ['op']=='use'){
	//使用模版。说明：请求参数中的aliapp_id指小程序的ID，id指小程序模版的ID。入库时，aliapp_id字段保存的是小程序模版id
	//如果是更换小程序模版，直接更新小程序模版id即可。如果是新增小程序，新增成功后自动进入小程序授权页
	$aliapp_id=intval($_RQ['aliapp_id']);
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择小程序模版！','error');
	}
	$data=array(
		'aliapp_id'=>$id,
		'status'=>0,
	);
	if($aliapp_id){
		pdo_update('core_account_aliapp',$data,array('id'=>$aliapp_id));
		exi('更换小程序模版成功！','','aliapp.list');
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		$data['createtime']=TIMESTAMP;
		pdo_insert('core_account_aliapp',$data);
		$aliapp_id=pdo_insertid();
		//新增小程序，此处发起小程序授权。
		$url=cfc('open')->get_sq_url(2,$aliapp_id);
		exi('添加小程序成功！准备进入授权页面！','','',$url);
	}
}