<?php
/*
	手机站页面组件管理
*/
defined('BY_JYA') or exit('error');
global $_RQ;
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
$return['supports']=array(
	'0'=>'全部支持',
	'1'=>'仅支持手机端',
	'2'=>'仅支持小程序端',
);
$return['basictypes']=array(
	'0'=>'展示组件',
	'1'=>'辅助组件',
);
$return['types']=array(
	'0'=>'官网组件',
	'1'=>'应用组件',
);
$return['plugins']=pdo_getall('core_plugins',array('is_my'=>1),array('name','title'),'name');
$core_plugin=array('name'=>'core','title'=>'系统');
$return['plugins']['core']=$core_plugin;
if($_RQ['op']=='list'){
	//容器列表
	$params=array('madehtml <>'=>'');
	if($_RQ['type']){
		$params['type']=intval($_RQ['type']);
		$return['params']['type']=$_RQ['type'];
	}
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$fields=array('id','support','plugin_id','title','release');
	$total='';
	$list=pdo_getslice('core_mobile_blocks',$params,array($pindex,$psize),$total,$fields,'',$orderby);
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['htmls']=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'组件列表'),
		),
		'search_one'=>array('name'=>'title'),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'title','title'=>'组件名称','type'=>'string'),
			array('name'=>'support','title'=>'支持界面','type'=>'radio','options'=>'supports'),
			array('name'=>'plugin_id','title'=>'所属插件','type'=>'select','options'=>'plugins'),
			array('name'=>'release','title'=>'上次编辑时间','type'=>'time'),
		)),
	);
	exi($return);
}

if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_mobile_blocks',array('id'=>$id),array('id','support','plugin_id','title','icon','showhtml','edithtml','madehtml','madewxapp','madewxapp_new','madealiapp','madebaiduapp','default','basictype','type'));
		$item['showhtml']=$item['showhtml']?cfc('files')->source_read($item['showhtml']):'';
		$item['edithtml']=$item['edithtml']?cfc('files')->source_read($item['edithtml']):'';
		$item['madehtml']=$item['madehtml']?cfc('files')->source_read($item['madehtml']):'';
		$item['madewxapp']=$item['madewxapp']?cfc('files')->source_read($item['madewxapp']):'';
		$item['madewxapp_new']=$item['madewxapp_new']?cfc('files')->source_read($item['madewxapp_new']):'';
		$item['madealiapp']=$item['madealiapp']?cfc('files')->source_read($item['madealiapp']):'';
		$item['madebaiduapp']=$item['madebaiduapp']?cfc('files')->source_read($item['madebaiduapp']):'';
	}else{
		$item=array(
			'showhtml'=>'',
			'edithtml'=>'',
			'madehtml'=>'',
			'madewxapp'=>'',
			'madewxapp_new'=>'',
			'madealiapp'=>'',
			'madebaiduapp'=>'',
			'default'=>''
		);
	}
	$return['item']=$item;
	
	$return['htmls']=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'页面组件信息',
		'tabs'=>$tabs,
		'edit'=>array(
			array('type'=>'string','title'=>'名称','name'=>'title'),
			array('type'=>'radio','title'=>'展示界面','name'=>'support','options'=>'supports'),
			array('type'=>'radio','title'=>'组件类型','name'=>'type','options'=>'types'),
			array('type'=>'radio','title'=>'基本类型','name'=>'basictype','options'=>'basictypes','show'=>array('type'=>0)),
			array('type'=>'string','title'=>'组件ICON','name'=>'icon','help'=>'填写组件ICON，例如：icon-all，查看获取：http://s.jinyunweb.com/jinyunui/jinyunicon.html'),
			array('type'=>'select','title'=>'所属插件','name'=>'plugin_id','option_value'=>'name','options'=>'plugins','show'=>array('type'=>1)),
			array('type'=>'edit_code','title'=>'展示代码','name'=>'showhtml','code'=>'html'),
			array('type'=>'edit_code','title'=>'编辑代码','name'=>'edithtml','code'=>'html'),
			array('type'=>'edit_code','title'=>'生成代码','name'=>'madehtml','code'=>'html','show'=>array('support !='=>2)),
			array('type'=>'edit_code','title'=>'小程序生成代码','name'=>'madewxapp','code'=>'html','show'=>array('support !='=>1)),
			array('type'=>'edit_code','title'=>'新版小程序生成代码','name'=>'madewxapp_new','code'=>'html','show'=>array('support !='=>1)),
			array('type'=>'edit_code','title'=>'支付宝小程序生成代码','name'=>'madealiapp','code'=>'html','show'=>array('support !='=>1)),
			array('type'=>'edit_code','title'=>'百度小程序生成代码','name'=>'madebaiduapp','code'=>'html','show'=>array('support !='=>1)),
			array('type'=>'edit_code','title'=>'默认参数','name'=>'default','code'=>'javascript'),
			array('type'=>'switch','title'=>'是否发布新版本','name'=>'release'),
			array('type'=>'switch','title'=>'是否自增版本号','name'=>'diy_version','show'=>array('release'=>1)),
			array('type'=>'string','title'=>'自定义版本号','name'=>'version','show'=>array('release'=>1,'diy_version !='=>'1')),
			array('type'=>'text','title'=>'版本说明','name'=>'description','show'=>array('release'=>1)),
		),
	);
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	$id=intval($postdata['id']);
	if($id){
		$old=pdo_get('core_mobile_blocks',array('id'=>$id),array('showhtml','edithtml','madehtml','madewxapp','madewxapp_new','madealiapp','madebaiduapp'));
	}else{
		$old=array();
	}
	$data=array_fields(array('icon','title','basictype','support','plugin_id','showhtml','edithtml','madehtml','madewxapp','madewxapp_new','madealiapp','madebaiduapp','default','type'),$postdata);
	$data['support']=intval($data['support']);
	if($data['support']!=2 && !$data['madehtml']){
		//不是专属小程序的，检查手机端页面组件生成代码
		exi('请先设置生成代码！','error');
	}
	if($data['support']!=1 && !$data['madewxapp']){
		//不是专属手机端的，检查小程序页面组件生成代码
		exi('请先设置小程序生成代码！','error');
	}
	$data['madehtml']=cfc('files')->source_save($data['madehtml'],'data','data','',$old['madehtml']);
	$data['edithtml']=cfc('files')->source_save($data['edithtml'],'page','html','',$old['edithtml']);
	$data['showhtml']=cfc('files')->source_save($data['showhtml'],'page','html','',$old['showhtml']);
	$data['madewxapp']=cfc('files')->source_save($data['madewxapp'],'data','data','',$old['madewxapp']);
	$data['madewxapp_new']=cfc('files')->source_save($data['madewxapp_new'],'data','data','',$old['madewxapp_new']);
	$data['madealiapp']=cfc('files')->source_save($data['madealiapp'],'data','data','',$old['madealiapp']);
	$data['madebaiduapp']=cfc('files')->source_save($data['madebaiduapp'],'data','data','',$old['madebaiduapp']);
	$data['release']=TIMESTAMP;
	if($id){
		pdo_update('core_mobile_blocks',$data,array('id'=>$id));
	}else{
		$is_new=true;
		pdo_insert('core_mobile_blocks',$data);
		$id=pdo_insertid();
	}
	if($postdata['release']){
		//发布新版本
		if($is_new){
			//如果没有ID，表示为初次发布。此处先发布组件，下面再发布版本
			$post=array_fields(array('title','support','plugin_id','icon','type','basictype'),$postdata);
			$res=cloud_request('release.mobile_blocks.add',$post);
			$cloud_id=intval($res);
			if(!$cloud_id){
				exi('发布组件失败！云平台返回结果：'.$res,'error');
			}
			pdo_update('core_mobile_blocks',array('cloud_id'=>$cloud_id),array('id'=>$id));
		}
		$params=array_fields(array('icon','basictype','type','title','support','plugin_id','showhtml','edithtml','madehtml','madewxapp','madewxapp_new','madealiapp','madebaiduapp','default','version','diy_version','description'),$postdata);
		if($cloud_id){
			$params['block_id']=$cloud_id;
		}else{
			$params['block_id']=pdo_getcolumn('core_mobile_blocks',array('id'=>$id),'cloud_id');
		}
		cloud_request('release.mobile_blocks.v_post',$params);
	}
	exi('保存成功！','','list');
}
if($_RQ['op'] == 'del'){
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_mobile_blocks',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_mobile_blocks',array('id'=>$id));
			}
		}
	}
	exi('删除成功！');
}
?>