<?php
/*
	pc端页面组件设计、发布、管理。
	自己设计的pc端页面组件可以直接使用。
	pc端页面组件具体流程是否可以参考插件设计？（先由开发工具开发并安装在本地，然后再统一发布云平台）
		不可因为在使用组件时，需要对接云平台。因此要求该插件必须在云平台有数据。
		另外，组件有一个生成代码字段，而本地没有该字段，只能存在于云平台。
	如果直接设计保存到云平台，那么就存在另一个问题：本地是否安装？发布如何发布。更新如何更新。为了云平台的稳定。还是要将开发版和正式版分开。
	那么，如果参考插件设计，设计调试好再发布云平台。就需要本地增加一个madehtml字段。当连接云平台生成代码时，同时将本地生成代码上传云平台。
		关键有一个问题不好处理，在使用组件时，如果是本地组件，没有唯一的标识来标识该组件，就无法在云平台调取生成代码。
		！是否以本地ID作为唯一标识来标识该组件，然后云平台将ID转换为cloudid，如果转换不成，就从上传上来的生成代码中找相应代码。
		
	另外插件也有类似严重问题：插件开发工具中创建插件时，申请了一个标识，但是发布时，标识可能仍会冲突。
	暂时可以这样处理：创建插件时，同时对比正式插件表和新插件表两个表的标识，以免出现标识重复。
		为何？因为其他开发者在你创建后发布前可能也会申请同一个标识 。此时，在真正发布的时候就会出现标识冲突的问题。
			插件ID化依然后很大的必要。此种情况下，插件只需在发布的时候申请一个标识即可
	
	最终调整：两类组件都需要做出相应调整。
	插件ID化依然后很大的必要。
	组件创建只在本地，本地创建好后，申请发布，再发布到云平台。
	还有一个问题：如何判断一个组件是云安装的还是自行开发的？
		通过字段madehtml如果值为空，则表示云安装。是否通过cloud_id判断，组件发布后也会保存一个cloud_id。
		暂时通过madehtml字段判断
		
	发布：组件该如何发布？是否像插件那样，通过版本控制来发布。如果通过版本控制来发布，则流程较为复杂。
	但是如果不通过版本控制来发布，则难以实现完善的审核发布机制。
	暂决定：通过版本控制来审核发布。
	是否所有应用发布都通过版本控制来发布：功能插件、插件小程序、pc端页面组件、手机端页面组件
	模版类应用均采用一次性发布方式，发布后不用更新，也无需审核？是的。暂定如此！
*/
defined('BY_JYA') or exit('error');
global $_RQ;
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
$return['types']=array(
	'1'=>'容器',
	'2'=>'头部组件',
	'3'=>'底部组件',
	'4'=>'内容组件',
);
if($_RQ['op']=='list'){
	//组件列表
	$params=array('madehtml <>'=>'');
	if($_RQ['type']){
		$params['type']=intval($_RQ['type']);
		$return['params']['type']=$_RQ['type'];
	}
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$fields=array('id','type','title','release');
	$total='';
	$list=pdo_getslice('core_pc_blocks',$params,array($pindex,$psize),$total,$fields,'',$orderby);
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['htmls']=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'组件列表'),
		),
		'search_one'=>array('name'=>'title'),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'title','title'=>'组件名称','type'=>'string'),
			array('name'=>'type','title'=>'组件类型','type'=>'radio','options'=>'types'),
			array('name'=>'release','title'=>'上次编辑时间','type'=>'time'),
		)),
	);
	exi($return);
}

if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_pc_blocks',array('id'=>$id),array('id','title','image','type','showhtml','edithtml','madehtml','default'));
		$item['showhtml']=$item['showhtml']?cfc('files')->source_read($item['showhtml']):'';
		$item['edithtml']=$item['edithtml']?cfc('files')->source_read($item['edithtml']):'';
		$item['madehtml']=$item['madehtml']?cfc('files')->source_read($item['madehtml']):'';
		$item['default']=$item['default']?$item['default']:'';
	}else{
		$item=array(
			'showhtml'=>'',
			'edithtml'=>'',
			'madehtml'=>'',
			'default'=>''
		);
	}
	//print_r($item);exit;
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'页面组件信息',
		'tabs'=>$tabs,
		'edit'=>array(
			array('type'=>'string','title'=>'名称','name'=>'title'),
			array('type'=>'image','title'=>'LOGO','name'=>'image'),
			array('type'=>'radio','title'=>'类型','name'=>'type','options'=>'types'),
			array('type'=>'edit_code','title'=>'展示代码','name'=>'showhtml','code'=>'html'),
			array('type'=>'edit_code','title'=>'编辑代码','name'=>'edithtml','code'=>'html'),
			array('type'=>'edit_code','title'=>'生成代码','name'=>'madehtml','code'=>'html'),
			array('type'=>'edit_code','title'=>'默认参数','name'=>'default','code'=>'javascript'),
			array('type'=>'switch','title'=>'是否发布新版本','name'=>'release','help'=>'<red>只有提交发布了（不一定要审核，发布了就行），设计页面才会显示组件！</red>'),
			array('type'=>'switch','title'=>'是否自增版本号','name'=>'diy_version','show'=>array('release'=>1)),
			array('type'=>'string','title'=>'自定义版本号','name'=>'version','show'=>array('release'=>1,'diy_version !='=>'1')),
			array('type'=>'text','title'=>'版本说明','name'=>'description','show'=>array('release'=>1)),
		),
	);
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	$id=intval($postdata['id']);
	if($id){
		$old=pdo_get('core_pc_blocks',array('id'=>$id),array('showhtml','edithtml','madehtml'));
	}else{
		$old=array();
	}
	$data=array_fields(array('title','type','showhtml','edithtml','madehtml','default'),$postdata);
	$data['type']=intval($data['type']);
	foreach($data as $row){
		if(!$row){
			exi('请先完善组件内容！','error');
		}
	}
	$data['image']=tomedia($postdata['image']);
	$data['madehtml']=cfc('files')->source_save($data['madehtml'],'data','data','',$old['madehtml']);
	$data['edithtml']=cfc('files')->source_save($data['edithtml'],'page','html','',$old['edithtml']);
	$data['showhtml']=cfc('files')->source_save($data['showhtml'],'page','html','',$old['showhtml']);
	$data['release']=TIMESTAMP;
	if($id){
		pdo_update('core_pc_blocks',$data,array('id'=>$id));
	}else{
		$is_new=true;
		pdo_insert('core_pc_blocks',$data);
		$id=pdo_insertid();
	}
	if($postdata['release']){
		//发布新版本
		if($is_new){
			//如果没有ID，表示为初次发布。此处先发布组件，下面再发布版本
			$post=array_fields(array('title','type'),$postdata);
			$res=cloud_request('release.pc_blocks.add',$post);
			$cloud_id=intval($res);
			if(!$cloud_id){
				exi('发布组件失败！云平台返回结果：'.$res,'error');
			}
			pdo_update('core_pc_blocks',array('cloud_id'=>$cloud_id),array('id'=>$id));
		}
		$params=array_fields(array('image','title','showhtml','edithtml','madehtml','default','version','diy_version','description'),$postdata);
		if($cloud_id){
			$params['block_id']=$cloud_id;
		}else{
			$params['block_id']=pdo_getcolumn('core_pc_blocks',array('id'=>$id),'cloud_id');
		}
		if(!$params['block_id']){
			$post=array_fields(array('title','type'),$postdata);
			$res=cloud_request('release.pc_blocks.add',$post);
			$cloud_id=intval($res);
			if(!$cloud_id){
				exi('发布组件失败！云平台返回结果：'.$res,'error');
			}
			pdo_update('core_pc_blocks',array('cloud_id'=>$cloud_id),array('id'=>$id));
		}
		cloud_request('release.pc_blocks.v_post',$params);
	}
	exi('保存成功！');
}
if($_RQ['op'] == 'del'){
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_pc_blocks',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_pc_blocks',array('id'=>$id));
			}
		}
	}
	exi('删除成功！');
}
?>