<?php
/*
	兼容插件开发
	
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
$return['styles']=array(
		'1'=>'行业应用',
		'2'=>'促销应用',
		'3'=>'互动营销',
		'4'=>'游戏营销',
		'5'=>'辅助应用',
		'6'=>'云接口',
);
if($_RQ['op']=='list'){
	//搜索
	$return['params']=$params=array();
	$params['is_my']=1;
	$params['type']=4;
	if($_RQ['title']){
		$params['title like']='%'.$_RQ['title'].'%';
	}
	$pindex = max(1, intval($_RQ['page']));
	$psize = 20;
	$total='';
	$fields=array('id','title','name','image','hide');
	$list=pdo_getslice('core_plugins',$params,array($pindex,$psize),$total,$fields,'','id desc');
	foreach($list as &$item){
		$item['config']=array('op'=>'config','query'=>'plugin_name='.$item['name'],'title'=>'生成配置文件');
		$item['down']=array('op'=>'down','query'=>'plugin_name='.$item['name'],'title'=>'打包下载');
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	//页面显示设置
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			'0'=>array('op'=>'list','title'=>'插件列表'),
		),
		'list'=>array('data'=>'list','tip'=>'此处用于管理兼容插件，如需删除插件，请到系统管理——插件管理中卸载！','delall'=>false,'del_one'=>false,'list'=>array(
			array('name'=>'image','title'=>'插件logo','type'=>'image'),
			array('name'=>'name','title'=>'插件标识','type'=>'string'),
			array('name'=>'title','title'=>'插件名称','type'=>'string'),
			array('name'=>'hide','title'=>'是否上线','type'=>'switch','open_value'=>'0','close_value'=>'1','set'=>'set'),
		),'action'=>array(
			array('type'=>'post','name'=>'config','title'=>'生成配置文件'),
			array('type'=>'post','name'=>'down','title'=>'打包下载'),
		)),
		'search_one'=>array('name'=>'title'),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='config'){
	//生成配置文件
	$name=trim($_RQ['plugin_name']);
	$manifestxml=model('core/module')->int_manifest($name);
	file_put_contents(ROOT_PLUGIN.$name.'/manifest.xml',$manifestxml);
	exi('成功生成配置文件！可在插件根目录下查看！');
}
if($_RQ['op']=='down'){
	$url=download_url('core/app_develop.old_plugin/down_load/plugin_name='.$_RQ['plugin_name']);
	exi('','',$url);
}
if($_RQ['op']=='down_load'){
	//生成配置文件
	$name=trim($_RQ['plugin_name']);
	if(!$name || preg_match('/\W/',$name)){
		exit('下载出错！');
	}
	$dir=ROOT_PLUGIN.$name;
	if(!is_dir($dir)){
		exit('插件不存在！');
	}
	do{
		$zip=ROOT_AT.random(10).'.temp';
	}while(is_file($zip));
	cfc('files')->zip($dir,$zip);
	header('content-type: application/zip');
	header('content-disposition: attachment; filename="' . $name . '.zip"');
	readfile($zip);
	@unlink($zip);
	exit();
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择插件！','error');
	}
	$post=get_postdata();
	if(!isset($post['hide'])){
		exi('请先选择是否上线！','error');
	}
	pdo_update('core_plugins',array('hide'=>intval($post['hide'])),array('id'=>$id));
	exi('操作成功！');
}
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_plugins',array('id'=>$id));
		$old=pdo_get('core_old_plugins',array('name'=>$item['name']));
		$item=array_merge($old,$item);
		if($item['covers']){
			$item['covers']=json_decode($item['covers'],true);
		}
		if($item['menus']){
			$item['menus']=json_decode($item['menus'],true);
		}
		
	}else{
		$item=array();
	}
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'desc'=>'设置插件信息。注意，此处用于导入插件到系统，插件文件请先行放到系统插件目录，插件数据表也请先行导入。',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回插件列表'),
		),
		'edit'=>array(
			array('name'=>'name','type'=>'string','title'=>'插件标识'),
			array('name'=>'title','type'=>'string','title'=>'插件名称'),
			array('name'=>'image','type'=>'image','title'=>'插件logo'),
			array('name'=>'style','title'=>'插件类型','type'=>'radio','options'=>'styles'),
			array('name'=>'need_menu','type'=>'switch','title'=>'是否需要系统菜单','help'=>'如果插件页面是完整页面，例如人人商城等则无需系统菜单；如果插件相对简单，如智慧预约等，需要系统菜单充实页面'),
			array('name'=>'setting','type'=>'switch','title'=>'是否含有参数设置页','help'=>'根据插件具体情况设置'),
			array('name'=>'ability','type'=>'string','title'=>'插件简介'),
			array(
				'type'=>'array',
				'name'=>'covers',
				'show_detail'=>true,
				'title'=>'功能入口设置',
				'add_tip'=>'添加一个入口',
				'list'=>array(
					array('type'=>'string','name'=>'name','title'=>'入口页面action'),
					array('type'=>'string','name'=>'title','title'=>'入口名称'),
				),'details'=>array(
					array('type'=>'string','name'=>'name','title'=>'页面action'),
					array('type'=>'string','name'=>'title','title'=>'页面名称'),
				)
			),
			array(
				'type'=>'array',
				'name'=>'menus',
				'show_detail'=>true,
				'title'=>'功能菜单设置',
				'add_tip'=>'添加一个菜单',
				'list'=>array(
					array('type'=>'string','name'=>'name','title'=>'页面action'),
					array('type'=>'string','name'=>'title','title'=>'页面名称'),
				),'details'=>array(
					array('type'=>'string','name'=>'name','title'=>'页面action'),
					array('type'=>'string','name'=>'title','title'=>'页面名称'),
				)
			),
		),
	);
	exi($return);
}
if($_RQ['op']=='post'){
	$post=get_postdata();
	$data=array(
		'name'=>$post['name'],
		'title'=>$post['title'],
		'image'=>$post['image'],
		'covers'=>ijson_encode($post['covers']),
		'menus'=>ijson_encode($post['menus']),
		'description'=>$post['description'],
		'style'=>intval($post['style']),
	);
	$old=array(
		'need_menu'=>intval($post['need_menu']),
		'setting'=>intval($post['setting']),
		'name'=>$post['name'],
	);
	$id=intval($post['id']);
	if($id){
		
		pdo_update('core_plugins',$data,array('id'=>$id));
		pdo_update('core_old_plugins',$old,array('name'=>$post['name']));
	}else{
		$data['is_my']=1;
		$data['type']=4;
		$data['hide']=1;
		pdo_insert('core_plugins',$data);
		pdo_insert('core_old_plugins',$old);
	}
	exi('操作成功！','','list');
}