<?php
/*
	模版发布
	模版如何测试？
	如何发布？
	是否把模版设计和发布合并到一起。
	添加模版，在数据库添加一条数据，从而可以在系统设置中选择应用。
	从添加的模版中选择发布，发布时打包模版目录下所有文件。
	更新
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('title'=>'模版列表','op'=>'list'),
	array('title'=>'新增/编辑模版','op'=>'edit'),
	array('title'=>'已发布的模版','op'=>'relist'),
);
set_html('tabs',$tabs);
if($_RQ['op']=='list'){
	$list=pdo_getall('core_addons_temp_pc',array('is_my'=>1));
	$cloud_list=cloud_request('release.addons_temp_pc.list',array('type'=>'key'));
	if(!$cloud_list){
		$cloud_list=array();
	}
	foreach($list as &$item){
			if(in_array($item['name'],$cloud_list)){
				$item['type']=1;
			}else{
				$item['type']=0;
			}
	}
	$return['list']=$list;
	$return['htmls']=array(
		'type'=>'list',
		'list'=>array('data'=>'list','tip'=>'[开发教程]:http://s.jinyunweb.com/manage/index.php?p=core&action=article.show&nosession=1&id=383','delall'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'id','title'=>'id','type'=>'string'),
			array('name'=>'title','title'=>'模版名称','type'=>'string'),
			array('name'=>'name','title'=>'模版标识','type'=>'string'),
			array('name'=>'type','title'=>'模版状态','type'=>'radio','options'=>'types'),
		),'action'=>array(
			array('type'=>'href','op'=>'add','title'=>'发布到云平台','show'=>array('type'=>0)),
		)),
	);
	$return['types']=array(
		'0'=>'待发布',
		'1'=>'已发布到云平台',
	);
	exi($return);
}
if($_RQ['op']=='edit'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$id=intval($post['id']);
		$plugin_name=trim($post['plugin_name']);
		$data=array(
			'title'=>trim($post['title']),
			'version'=>trim($post['version']),
			'plugin_name'=>$plugin_name,
			'diy_form'=>ijson_encode($post['diy_form']),
		);
		if($id){
			pdo_update('core_addons_temp_pc',$data,array('id'=>$id));
			exi('设置成功！','','list');
		}else{
			$name=trim($post['name']);
			if(!$name){
				exi('请设置模版标识！','error');
			}
			$check=cloud_request('release.addons_temp_pc.check',array('name'=>$name));
			if($check=='has'){
				exi('标识已存在，请更换！','error');
			}
			$insert=array(
				'name'=>$name,
				'plugin_name'=>$plugin_name,
				'is_my'=>1,
				'createtime'=>TIMESTAMP,
			);
			$insert=array_merge($data,$insert);
			pdo_insert('core_addons_temp_pc',$insert);
			exi('新建模版成功！','','list');
		}
	}
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_addons_temp_pc',array('id'=>$id));
		$item['diy_form']=$item['diy_form']?json_decode($item['diy_form'],true):array();
	}else{
		$item=array('title'=>'');
	}
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'edit'=>array(
			array('type'=>'choose','action'=>'core/tools.get_data/get_plugins/','title'=>'关联应用的标识','name'=>'plugin_name','help'=>'选择要关联的应用,留空表示系统模板' ),
			array('type'=>'string','name'=>'name','title'=>'模版标识','read'=>$id?true:false),
			array('type'=>'string','name'=>'title','title'=>'模版名称'),
			array('type'=>'string','name'=>'version','title'=>'模版版本'),
			array('type'=>'array_simple','name'=>'diy_form','title'=>'自定义表单数据','fields'=>array(
				array('type'=>'string','name'=>'type','title'=>'表单类型'),
				array('type'=>'string','name'=>'name','title'=>'字段标识'),
				array('type'=>'string','name'=>'title','title'=>'字段名称'),
			)),
		),
	);
	exi($return);
}
if($_RQ['op']=='add'){
	//发布新版本
	if($_RQ['postdata']){
		$post=get_postdata();
		$name=trim($post['name']);
		if(!$name){
			exi('模版标识错误！','error');
		}
		$check=cloud_request('release.addons_temp_pc.check',array('name'=>$name));
		if($check=='has'){
			exi('模版已存在，请勿重复发布！','error');
		}
		$template=pdo_get('core_addons_temp_pc',array('id'=>intval($post['id'])),array('name','title','diy_form'));
		$params=array_fields(array('image','name','plugin_name','version','price','price1','content','show'),$post);
		$params=array_merge($params,$template);
		if($params['image']){
			$params['image']=tomedia($params['image']);
		}
		$dir=ROOT_D.'/addons/temp/pc/'.$name;
		if(!is_dir($dir)){
			exi('模版文件不存在！发布失败！','error');
		}
		$temp='/'.random(30).'.zip';
		cfc('files')->zip($dir,ROOT_AT.$temp);
		$params['zipfile']=SITEROOT.RESOURCE.$temp;
		$res=cloud_request('release.addons_temp_pc.add',$params);
		exi('发布成功，请等待管理员审核！','','list');
	}
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择模版！','error');
	}
	$item=pdo_get('core_addons_temp_pc',array('id'=>$id),array('id','name','title','plugin_name'));
	$item['version']='1.0';
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'edit'=>array(
			array('type'=>'string','name'=>'name','title'=>'模版标识','read'=>true),
			array('type'=>'string','name'=>'title','title'=>'模版名称','read'=>true),
			array('type'=>'image','name'=>'image','title'=>'模版图片'),
			array('type'=>'string','name'=>'version','title'=>'模版版本'),
			array('type'=>'string','name'=>'price','title'=>'模版价格'),
			array('type'=>'string','name'=>'price1','title'=>'商业会员特价'),
			array('type'=>'text','name'=>'content','title'=>'模版介绍'),
			array('type'=>'switch','name'=>'show','title'=>'是否上架'),
		),
	);
	exi($return);
}
/*
	已发布的模版列表
*/
if($_RQ['op']=='relist'){
	$cloud_list=cloud_request('release.addons_temp_pc.list',array('type'=>'data'));
	if(!$cloud_list){
		exi('你还没有发布模版！','error');
	}
	$return['list']=$cloud_list;
	$return['htmls']=array(
		'type'=>'list',
		'list'=>array('data'=>'list','key'=>'name','delall'=>false,'del_one'=>false,'edit'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'id','title'=>'id','type'=>'string'),
			array('name'=>'title','title'=>'模版名称','type'=>'string'),
			array('name'=>'name','title'=>'模版标识','type'=>'string'),
			array('name'=>'status','title'=>'模版状态','type'=>'radio','options'=>'status'),
			array('name'=>'show','title'=>'是否上架','type'=>'switch','set'=>'set'),
		),'action'=>array(
			array('type'=>'href','op'=>'add_version','title'=>'发布新版本'),
			array('type'=>'href','op'=>'version_list','title'=>'版本列表'),
			array('type'=>'href','op'=>'cloud_edit','title'=>'编辑'),
		)),
	);
	$return['status']=array(
		'0'=>'待审核',
		'1'=>'审核通过',
		'2'=>'审核不通过',
	);
	exi($return);
}
if($_RQ['op']=='cloud_edit'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$data=array_fields(array('id','name','plugin_name','title','image','slide','version','price','content'),$post);
		if($data['image']){
			$data['image']=tomedia($data['image']);
		}
		if($data['slide']){
			foreach($data['slide'] as &$slide){
				$slide=tomedia($slide);
			}
		}
		cloud_request('release.addons_temp_pc.edit_post',$data);
		exi('设置成功！','','goback');
	}
	$name=trim($_RQ['name']);
	if(!$name){
		exi('请先选择模版！','error');
	}
	$params=array('name'=>$name);
	$item=cloud_request('release.addons_temp_pc.edit',$params);
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'edit'=>array(
			array('type'=>'string','title'=>'模版名称','name'=>'title','help'=>''),
			array('type'=>'choose','action'=>'core/tools.get_data/get_plugins/','title'=>'关联应用的标识','name'=>'plugin_name','help'=>'选择要关联的应用,留空表示系统模板' ),
			array('type'=>'string','name'=>'name','title'=>'模版标识','read'=>$name?true:false),
			array('type'=>'image','title'=>'模版图片','name'=>'image','help'=>''),
			array('type'=>'images','title'=>'展示图片','name'=>'slide','help'=>''),
			array('type'=>'string','title'=>'当前版本','name'=>'version','help'=>'','read'=>true),
			array('type'=>'string','title'=>'模版价格','name'=>'price','help'=>''),
			array('type'=>'text','title'=>'组件简介','name'=>'content','help'=>''),
		),
	);
	exi($return);
}
//修改插件状态
if($_RQ['op']=='set'){
	$id=trim($_RQ['name']);
	if(!$id){
		exi('请先选择模版！','error');
	}
	$postdata=get_postdata();
	if(!isset($postdata['show'])){
		exi('请先设置插件状态！','error');
	}
	$show=intval($postdata['show']);
	$params=array(
		'id'=>$id,
		'show'=>$show,
	);
	cloud_request('release.addons_temp_pc.set',$params);
	$message=$show?'上架成功！':'下架成功！';
	exi($message);

}
if($_RQ['op']=='version_list'){
	//版本列表
	$params=array(
		'name'=>$_RQ['name'],
		'page'=>intval($_RQ['page']),
	);
	$result=cloud_request('release.addons_temp_pc.version_list',$params);
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回插件列表'),
			
		),
		'list'=>array('data'=>'list','delall'=>false,'edit'=>false,'del_op'=>'version_del','list'=>array(
			array('name'=>'version','title'=>'版本号','type'=>'string'),
			array('name'=>'status','title'=>'版本状态','type'=>'radio','options'=>'statuss'),
			array('name'=>'release','title'=>'创建时间','type'=>'time'),
		)),
	);
	$result['htmls']=$htmls;
	exi($result);
}
if($_RQ['op']=='version_del'){
	
}
if($_RQ['op']=='add_version'){
	//新增版本，是否需要进行对比更新？是
	
	if($_RQ['postdata']){
		$post=get_postdata();
		$template_dir=ROOT_D.'/addons/temp/pc/'.$post['name'];
		$template=pdo_get('core_addons_temp_pc',array('is_my'=>1,'name'=>$post['name']));
		if(!$template){
			exi('指定模版不存在或不属于你！发布版本失败！','error');
		}
		$params=array(
			'name'=>trim($post['name']),
			'more_files'=>$post['more_files'],
			'diy_version'=>$post['diy_version'],
			'version'=>$post['version'],
			'content'=>$post['content'],
			'diy_form'=>$template['diy_form'],
		);
		$upfiles=str_array($post['upfiles']);
		if($upfiles){
			foreach($upfiles as $file){
				$zip = new ZipArchive();
				$temp=random(15).'.zip';
				$zip->open(ROOT_AT.$temp, ZipArchive::CREATE);
				$update=false;
				foreach($upfiles as $file){
					$zip->addFile($template_dir.$file,$file);
				}
				$zip->close();
				$params['zipfile']=SITEROOT.RESOURCE.'/'.$temp;
			}
		}
		
		$res=cloud_request('release.addons_temp_pc.add_version',$params);
		exi('发布成功！','','goback');
	}
	$name=trim($_RQ['name']);
	
	$template_dir=ROOT_D.'//addons/temp/pc/'.$name;
	$cloud_files=cloud_request('release.addons_temp_pc.files',array('name'=>$name));
	
	if(!$template_dir){
		exi('模版文件不存在！','error');
	}
	$local_files=cfc('files')->file_tree($template_dir);
	foreach($local_files as $file){
		if(!$cloud_files[$file]){
			//云端不存在存在该文件，或者和本地文件不一致，则打包该文件
			$upfiles[$file]=$file.'(new)';
		}else{
			if(md5_file($template_dir.$file)!=$cloud_files[$file]){
				$upfiles[$file]=$file.'(change)';
			}
			unset($cloud_files[$file]);
		}
	}
	$more_files=array();
	if($cloud_files){
		foreach($cloud_files as $key=>$value){
			$more_files[$key]=$key;
		}
	}
	$return['item']=array('name'=>$name,'version'=>'');
	$return['upfiles']=$upfiles;
	$return['more_files']=$more_files;
	$return['htmls']=array(
		'type'=>'edit',
		'tabs'=>array(
			array('op'=>'v_list','title'=>'返回版本列表'),
		),
		'edit'=>array(
			array('type'=>'checkbox','name'=>'upfiles','title'=>'待更新文件列表','options'=>'upfiles','choose_all'=>true,'help'=>'勾选需要更新的文件，未勾选的系统自动忽略'),
			array('type'=>'checkbox','name'=>'more_files','title'=>'多余文件列表','options'=>'more_files','choose_all'=>true,'help'=>'勾选需要删除的多余文件，未勾选的系统自动忽略'),
			//array('type'=>'switch','name'=>'is_ignore','title'=>'是否保存忽略的文件和数据表','help'=>'保存后，下次检测时，被忽略的文件和数据表将不再纳入检测'),
			//array('type'=>'string','name'=>'price','title'=>'版本费用'),
			array('type'=>'switch','title'=>'是否自增版本号','name'=>'diy_version',),
			array('type'=>'string','name'=>'version','title'=>'版本号','help'=>'填写版本号','show'=>array('diy_version !='=>1)),
			array('type'=>'text','name'=>'content','title'=>'更新说明','help'=>'填写更新说明'),
		),
	);
	exi($return);
}