<?php
/*
	pc端页面组件 发布、管理。
	采用版本控制的方法实现发布、审核
	主体功能对接云端实现
	
*/
defined('BY_JYA') or exit('error');
global $_RQ,$_AR;
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$types=array(
	'1'=>'容器',
	'2'=>'头部组件',
	'3'=>'底部组件',
	'4'=>'内容组件',
);
if($_RQ['op']=='list'){
	//搜索
	$params=array();
	if($_RQ['title']){
		$params['title']=$_RQ['title'];
	}
	if($_RQ['page']){
		$params['page']=$_RQ['page'];
	}
	if($_RQ['type']){
		$params['type']=$_RQ['type'];
	}
	
	$result=cloud_request('release.pc_blocks.list',$params);
	if($result['list']){
		foreach($result['list'] as &$item){
			$item['v_list']=array('op'=>'v_list','query'=>'block_id='.$item['id']);
		}
	}
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'组件列表'),
			array('op'=>'add','title'=>'发布组件'),
		),
		'list'=>array('data'=>'list','delall'=>false,'list'=>array(
			array('name'=>'title','title'=>'组件名称','type'=>'string'),
			array('name'=>'version','title'=>'组件版本','type'=>'string'),
			array('name'=>'type','title'=>'组件类型','type'=>'radio','options'=>'types'),
			array('name'=>'status','title'=>'审核状态','type'=>'radio','options'=>'statuss'),
			array('name'=>'show','title'=>'是否上架','type'=>'switch','set'=>'set'),
			array('name'=>'v_list','title'=>'版本管理','type'=>'href'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$result['htmls']=$htmls;
	$result['types']=$types;
	exi($result);
}
if($_RQ['op']=='del'){
	//删除组件
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要删除的组件！');
	}
	cloud_request('release.pc_blocks.del',array('id'=>$id));
	pdo_update('core_pc_blocks',array('cloud_id'=>0),array('cloud_id'=>$id));
	exi('删除成功！');
}
//修改组件状态
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择组件！','error');
	}
	$postdata=get_postdata();
	$show=intval($postdata['show']);
	$params=array(
		'id'=>$id,
		'show'=>$show,
	);
	
	$result=cloud_request('release.pc_blocks.set',$params);
	exi($result);
}
if($_RQ['op']=='add'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$post=array_fields(array('id','version','description','price'),$post);
		foreach($post as $row){
			if(!isset($row)){
				exi('请先设置好组件参数','error');
			}
		}
		$post['price']=intval($post['price']);
		$post['image']=tomedia($post['image']);
		$id=intval($post['id']);
		$block=pdo_get('core_pc_blocks',array('id'=>$id),array('title','type'));
		$post['title']=$block['title'];
		$post['type']=$block['type'];
		$res=cloud_request('release.pc_blocks.add',$post);
		$cloud_id=intval($res);
		if(!$cloud_id){
			exi('发布组件失败！云平台返回结果：'.$res,'error');
		}
		pdo_update('core_pc_blocks',array('cloud_id'=>$cloud_id),array('id'=>$id));
		exi('发布成功！','','list');
	}else{
		$blocks=pdo_getall('core_pc_blocks',array('cloud_id'=>0),array('id','title'));
		$result['blocks']=$blocks;
		$result['item']=array();
		$htmls=array(
			'type'=>'edit',
			'tabs'=>array(
				array('op'=>'list','title'=>'返回组件列表'),
			),
			'desc'=>'设置组件信息',
			'edit'=>array(
				array('type'=>'select','title'=>'选择组件','name'=>'id','help'=>'选择要发布的组件','options'=>'blocks'),
				array('type'=>'string','title'=>'组件价格','name'=>'price','help'=>''),
				array('type'=>'string','title'=>'组件版本','name'=>'version','help'=>''),
				array('type'=>'switch','title'=>'是否上架','name'=>'show','help'=>'设置为上架时，组件审核通过后会显示在应用市场'),
				array('type'=>'string','title'=>'组件简介','name'=>'description','help'=>''),
				array('type'=>'image','title'=>'展示图片','name'=>'image','help'=>'上传组件图片展示组件功能'),
			)
		);
		$result['htmls']=$htmls;
		exi($result);
	}
}
if($_RQ['op']=='edit'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$post['image']=tomedia($post['image']);
		pdo_update('core_pc_blocks',array('title'=>$post['title'],'type'=>$post['type'],'icon'=>$post['icon'],'image'=>$post['image']),array('cloud_id'=>$post['id']));
		cloud_request('release.pc_blocks.post',$post);
		exi('编辑成功！');
	}else{
		$params=array('id'=>intval($_RQ['id']));
		if(!$params['id']){
			exi('请先选择要编辑的组件！','error','list');
		}
		$result=cloud_request('release.pc_blocks.edit',$params);
		//编辑组件
		$htmls=array(
			'type'=>'edit',
			'tabs'=>array(
				array('op'=>'list','title'=>'返回组件列表'),
			),
			'desc'=>'设置组件信息',
			'edit'=>array(
				array('type'=>'string','title'=>'组件名称','name'=>'title','help'=>''),
				array('type'=>'radio','title'=>'组件类型','name'=>'type','help'=>'','options'=>'types'),
				array('type'=>'string','title'=>'当前版本','name'=>'version','help'=>'','read'=>true),
				array('type'=>'string','title'=>'组件价格','name'=>'price','help'=>''),
				array('type'=>'icon','title'=>'组件icon','name'=>'icon','from'=>'jinyunicon','help'=>''),
				array('type'=>'image','title'=>'LOGO','name'=>'image','help'=>''),
				array('type'=>'string','title'=>'组件简介','name'=>'description','help'=>''),
			)
		);
		$result['types']=$types;
		$result['htmls']=$htmls;
		exi($result);
	}
	
}

//组件版本管理
if($_RQ['block_id']){
	$_SESSION['app_release']['block_id']=intval($_RQ['block_id']);
}
if(!$_SESSION['app_release']['block_id']){
	exi('请先选择组件！','error');
}
if($_RQ['op']=='v_list'){
	//搜索
	$params=array('block_id'=>$_SESSION['app_release']['block_id']);
	if($_RQ['page']){
		$params['page']=$_RQ['page'];
	}
	$result=cloud_request('release.pc_blocks.v_list',$params);
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回组件列表'),
			array('op'=>'v_list','title'=>'版本列表'),
			array('op'=>'v_edit','title'=>'添加组件版本'),
		),
		'list'=>array('data'=>'list','delall'=>false,'del_one'=>false,'edit_op'=>'v_edit','list'=>array(
			array('name'=>'version','title'=>'版本号','type'=>'string'),
			array('name'=>'status','title'=>'版本状态','type'=>'radio','options'=>'statuss'),
			array('name'=>'release','title'=>'创建时间','type'=>'time'),
		)),
	);
	$result['htmls']=$htmls;
	exi($result);
}
if($_RQ['op']=='v_edit'){
	$params=array('id'=>intval($_RQ['id']),'block_id'=>$_SESSION['app_release']['block_id']);
	$result=cloud_request('release.pc_blocks.v_edit',$params);
	$htmls=array(
		'type'=>'edit',
		'post'=>'v_post',
		'desc'=>'设置版本信息',
		'edit'=>array(
			array('type'=>'string','title'=>'版本号','name'=>'version','help'=>'版本号'),
			array('type'=>'text','title'=>'更新说明','name'=>'description','help'=>'更新说明'),
		)
	);
	$result['htmls']=$htmls;
	exi($result);
}
if($_RQ['op']=='v_post'){
	$postdata=get_postdata();
	$post=array('description'=>$postdata['description']);
	//新增版本时，同时提交版本文件和配置参数
	if(!$postdata['id']){
		//新增版本
		$block=pdo_get('core_pc_blocks',array('cloud_id'=>$_SESSION['app_release']['block_id']),array('showhtml','edithtml','madehtml','default','image','release'));
		$block['showhtml']=cfc('files')->source_read($block['showhtml']);
		$block['edithtml']=cfc('files')->source_read($block['edithtml']);
		$block['madehtml']=cfc('files')->source_read($block['madehtml']);
		$block['image']=tomedia($block['image']);
		$post['version']=trim($postdata['version']);
		$post=array_merge($post,$block);
		$post['block_id']=$_SESSION['app_release']['block_id'];
	}else{
		//修改版本说明
		$post['id']=intval($postdata['id']);
	}
	$result=cloud_request('release.pc_blocks.v_post',$post);
	exi($result,'','v_list');
}

?>