<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	微站模版管理
		已安装模版
		待安装模版
		发布模版
	安装微站模版有一个问题：
		页面组件里面的edit_html 和show_html需要修改
		是否直接取消保存这两项参数，否则不利于模版通行于各个站点
		如果取消，则需要调整模版设计页面
		
	安装微站模版还有一个问题：微站模版涉及的图片、音乐等素材该当如何处理
		发布模版时，通过正则搜索查找页面用到的附件资源并上传云服务器；
		安装模版时，根据资源参数数组下载资源，并替换组件数据中的资源路径
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'installed';
$return=array();
$tabs=array(
	array('op'=>'installed','title'=>'已安装模版'),
	array('op'=>'updates','title'=>'待更新模版'),
	array('op'=>'prepared','title'=>'待安装模版'),
);
if($_RQ['op'] == 'installed') {
	//已安装微站模版列表 uniacid=0 表示模版不是站内用户自定义模版
	$params=array('uniacid'=>0);
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','title','image');
	$list=pdo_getslice('core_pc_template',$params,array($pindex,$psize),$total,$fields,'id',$orderby);
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'此处只显示从云平台安装的微站模版，不显示站内用户自定义模版','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'list'=>array(
			array('name'=>'image','title'=>'模版图片','type'=>'image'),
			array('name'=>'title','title'=>'模版名称','type'=>'string'),
			array('name'=>'type','title'=>'模版分类','type'=>'select','options'=>'groups'),
			array('name'=>'version','title'=>'模版版本','type'=>'string'),
		),'action'=>array(
			array('type'=>'href','op'=>'template_set','title'=>'设置模版信息'),
			array('type'=>'post','op'=>'uninstall','title'=>'卸载'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if ($_RQ['op'] == 'uninstall') {
	//卸载模版。卸载模版时，服务套餐中有包含该模版的，公众号有购买该模版的，是否同时将相关数据删除？暂不删除！
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择模版！','error');
	}
	pdo_delete('core_pc_template',array('id'=>$id));
	exi('卸载成功！');
}
if($_RQ['op'] == 'updates'){
	$params=array();
	$fields=array('id','cloud_id','title','version','release','image');
	$list=pdo_getall('core_pc_template',$params,$fields,'cloud_id');
	if($list){
		$cloud_ids=array_keys($list);
		$cloud_ids=implode(';',$cloud_ids);
		$post=array('cloud_ids'=>$cloud_ids);
		$versions=cloud_request('update.pc_template.getup',$post);
		foreach($versions as $name=>$version){
			if($version['release']==$list[$name]['release']){
				//去掉无需更新的模版
				unset($list[$name]);
			}else{
				$list[$name]['new_version']=$version['version'];
			}
		}
	}
	$return['list']=$list;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'更新存在新版本的模版','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'image','title'=>'模版logo','type'=>'image'),
			array('name'=>'title','title'=>'模版名称','type'=>'string'),
			array('name'=>'version','title'=>'当前版本','type'=>'string'),
			array('name'=>'new_version','title'=>'最新版本','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','op'=>'update','title'=>'更新'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op'] == 'update'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要更新的模版！','error');
	}
	$template=pdo_get('core_pc_template',array('id'=>$id),array('id','cloud_id'));
	if(!$template){
		exi('指定模版不存在！','error');
	}
	$result=cloud_request('update.pc_template.update',array('id'=>$template['cloud_id']));
	$resource=json_decode($result['resource'],true);
	if($resource){
		foreach($resource as $key=>$url){
			$temp=file_get_contents($url);
			$ext=substr(strrchr($key,'.'),1);
			$type=substr($key,1,5);
			$file=cfc('files')->source_save($temp,$type,$ext,'微站模版资源');
			$result['pc_items']=str_replace('"'.$key.'"','"'.$file.'"',$result['pc_items']);
		}
	}
	$update=array(
		'pc_items'=>$result['pc_items'],
		'release'=>$result['release'],
		'title'=>$result['title'],
		'type'=>$result['type'],
		'pageaction'=>$result['pageaction'],
	);
	pdo_update('core_pc_template',$update,array('id'=>$id));
	exi('更新成功！','','goback');
}
if($_RQ['op'] == 'prepared'){
	
	$installed = pdo_getall('core_pc_template',array('uniacid'=>0),array('cloud_id'),'cloud_id');
	$installed=array_keys($installed);
	$installed=implode(';',$installed);
	$list=cloud_request('update.pc_template.getbuyed',array('installed'=>$installed));
	$return['list']=$list;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'此处显示已购买但尚未安装的微站模版，可在此页安装已购买的微站模版','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'image','title'=>'模版图片','type'=>'image'),
			array('name'=>'title','title'=>'模版名称','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','op'=>'install','title'=>'安装'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}

if($_RQ['op'] == 'install') {
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要安装的模版！','error');
	}
	$check=pdo_getcolumn('core_pc_template',array('cloud_id'=>$id),'id');
	if ($check) {
		exi('该模版已安装无需重复安装！','error');
	}
	$result=cloud_request('update.pc_template.install',array('id'=>$id));
	//下载模版中用到的资源
	$resource=json_decode($result['resource'],true);
	if($resource){
		foreach($resource as $key=>$url){
			$temp=file_get_contents($url);
			$ext=substr(strrchr($key,'.'),1);
			$type=substr($key,1,5);
			$file=cfc('files')->source_save($temp,$type,$ext,'微站模版资源');
			$result['pc_items']=str_replace('"'.$key.'"','"'.$file.'"',$result['pc_items']);
		}
	}
	$insert=array(
		'pc_items'=>$result['pc_items'],
		'cloud_id'=>$result['id'],
		'title'=>$result['title'],
		'release'=>$result['release'],
		'type'=>$result['type'],
		'pageaction'=>$result['pageaction'],
	);
	if($result['image']){
		$image=file_get_contents($result['image']);
		$ext=substr(strrchr($result['image'],'.'),1);
		$insert['image']=cfc('files')->source_save($image,'image',$ext,'微站模版图片');
	}
	pdo_insert('core_pc_template',$insert);
	$id=pdo_insertid();
	$action=array(
		'op'=>'template_set',
		'query'=>'id='.$id
	);
	exi('安装成功！请设置模版详细信息！','',$action);
}
if ($_RQ['op'] == 'template_set') {
	if($_RQ['postdata']){
		$post=get_postdata();
		$id=intval($post['id']);
		$update=array(
			'title'=>$post['title'],
			'group_id'=>intval($post['group_id']),
			'price'=>intval($post['price']),
			'days'=>intval($post['days']),
			'image'=>$post['image'],
		);
		pdo_update('core_pc_template',$update,array('id'=>$id));
		exi('设置成功！','','installed');
	}else{
		$id=intval($_RQ['id']);
		if(!$id){
			exi('请先选择要设置的模版！','error');
		}
		$return['item']=pdo_get('core_pc_template',array('id'=>$id),array('id','title','price','days','group_id','image'));
		$return['groups']=pdo_getall('core_template_group',array(),array('id','title'));
		$return['htmls']=array(
			'type'=>'edit',
			'desc'=>'设置模版信息',
			'edit'=>array(
				array('title'=>'模版标题','name'=>'title','type'=>'string'),
				array('title'=>'模版价格','name'=>'price','type'=>'string','help'=>'单位（元）'),
				array('title'=>'模版有效期','name'=>'days','type'=>'string','help'=>'单位（天）。举例：模版价格设置为10，有效期设置为7，表示花十元可以购买7天的使用期限'),
				array('title'=>'模版图片','name'=>'image','type'=>'image'),
				array('title'=>'模版类型','name'=>'group_id','type'=>'select','options'=>'groups'),
			),
		);
		exi($return);
	}
}


