<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2018-02-25 15:57:35 apple $
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('op'=>'list','title'=>'计划任务列表'),
	array('op'=>'log','title'=>'计划任务执行日志'),
	array('op'=>'edit','title'=>'创建计划任务'),
);
if($_RQ['op']=='list'){
	//计划任务列表
	$params=array();
	//计划任务类型
	if($_RQ['type']){
		$params['type']=intval($_RQ['type']);
	}
	//计划任务名称
	if($_RQ['title']){
		$params['title']=trim($_RQ['title']);
	}
	//页码
	if($_RQ['page']){
		$params['page']=intval($_RQ['page']);
	}
	$result=cloud_request('cloud.plan.list',$params);
	$result['htmls']=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'search_one'=>array('name'=>'title','select_name'=>'type','select_title'=>'全部','is_radio'=>true,'options'=>'types'),
		'list'=>array('data'=>'list','delall'=>false,'list'=>array(
			array('name'=>'title','title'=>'任务名称','type'=>'string'),
			array('name'=>'type','title'=>'任务类型','type'=>'radio','options'=>'types'),
			array('name'=>'status','title'=>'是否开启','type'=>'switch'),
			array('name'=>'complete','title'=>'任务状态','type'=>'radio','options'=>'completes'),
			array('name'=>'num','title'=>'已执行次数','type'=>'string'),
			array('name'=>'time','title'=>'下次执行时间','type'=>'time'),
			array('name'=>'createtime','title'=>'创建时间','type'=>'time'),
		)),
	);
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$result['totalpage'] =$totalpage;
	$result['params']['page'] =$pindex;
	exi($result);
}
if($_RQ['op']=='edit'){
	//新增、编辑计划任务
	$gaps=array(
		1=>'半小时',
		2=>'1小时',
		3=>'一天',
		4=>'一周',
		5=>'一个月（三十天）',
		0=>'自定义'
	);
	if($_RQ['postdata']){
		//处理表单
		$post=get_postdata();
		$params=array(
			'title'=>trim($post['title']),
			'type'=>intval($post['type']),
			//'urltype'=>intval($post['urltype']),
			'url'=>trim($post['url']),
			'time'=>strtotime($post['time']),
			'status'=>intval($post['status']),
		);
		foreach($params as $row){
			if(!$row){
				exi('请先完善任务设置！','error');
			}
		}
		if($post['id']){
			$params['id']=intval($post['id']);
		}
		if($params['type']==2){
			//循环任务
			$gap=intval($post['gap']);
			switch($gap){
				case 1:
					$params['gap']=1800;
					break;
				case 2:
					$params['gap']=3600;
					break;
				case 3:
					$params['gap']=86400;
					break;
				case 4:
					$params['gap']=86400*7;
					break;
				case 5:
					$params['gap']=86400*30;
					break;
				case 0:
					$params['gap']=intval($post['diygap']);
					break;
				default:
					exi('表单参数错误，任务执行间隔不合法','error');
			}
		}
		$res=set_plan($params);
		if(intval($res)){
			exi('操作成功！','','list');
		}
	}else{
		$params=array('id'=>intval($_RQ['id']));
		$result=cloud_request('cloud.plan.edit',$params);
		if($result['item']['gap'] && $result['item']['gap']<1800){
			$result['item']['diygap']=$result['item']['gap'];
			$result['item']['gap']=0;
		}
		$result['gaps']=$gaps;
		$result['htmls']=array(
			'type'=>'edit',
			'desc'=>'任务详情',
			'tabs'=>$tabs,
			'edit'=>array(
				array('type'=>'string','title'=>'任务名称','name'=>'title'),
				array('type'=>'radio','title'=>'任务类型','name'=>'type','options'=>'types'),
				array('type'=>'switch','title'=>'是否开启','name'=>'status'),
				array('type'=>'string','title'=>'任务URL','name'=>'url','help'=>'路径格式：例如：core/plan/,或者插件的：jy_cms/plan/'),
				array('type'=>'time','title'=>'下一次任务执行时间','name'=>'time','show'=>array('type',2)),
				array('type'=>'time','title'=>'任务执行时间','name'=>'time','show'=>array('type',1)),
				array('type'=>'radio','title'=>'任务执行间隔','name'=>'gap','show'=>array('type',2),'options'=>'gaps'),
				array('type'=>'string','title'=>'自定义执行间隔','name'=>'diygap','show'=>array('type'=>2,'gap'=>0),'help'=>'单位：秒'),
			),
		);
		exi($result);
	}
	
}
if($_RQ['op']=='del'){
	//删除计划任务
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要删除的任务！','error');
	}
	$result=cloud_request('cloud.plan.del',array('id'=>$id));
	exi($result);
}
if($_RQ['op']=='log'){
	//查看计划任务执行日志
	//计划任务列表
	$params=array();
	//计划任务类型
	if($_RQ['type']){
		$params['type']=intval($_RQ['type']);
	}
	//计划任务名称
	if($_RQ['title']){
		$params['title']=trim($_RQ['title']);
	}
	//页码
	if($_RQ['page']){
		$params['page']=intval($_RQ['page']);
	}
	$result=cloud_request('cloud.plan.log',$params);
	$result['htmls']=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'search_one'=>array('name'=>'title','add'=>false),
		'list'=>array('data'=>'list','edit'=>false,'delall'=>false,'del_one'=>false,'list'=>array(
			array('name'=>'title','title'=>'任务名称','type'=>'string'),
			array('name'=>'createtime','title'=>'执行时刻','type'=>'time'),
			array('name'=>'status','title'=>'请求状态','type'=>'string'),
			array('name'=>'res','title'=>'请求结果','type'=>'string'),
		)),
	);
	exi($result);
}