<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'info';
$return=array();
$tabs=array(
	array('op'=>'info','title'=>'系统信息'),
	array('op'=>'update','title'=>'检查更新'),
	array('op'=>'bak','title'=>'回滚备份'),
	array('op'=>'ignore','title'=>'忽略(文件/数据)更新'),
	array('op'=>'menu','title'=>'同步系统菜单'),
	array('op'=>'permission','title'=>'同步系统权限数据'),
	array('op'=>'del_up_cache','title'=>'删除更新缓存'),
	array('op'=>'buy','title'=>'自动购买免费应用'),
);
if ($_RQ['op'] == 'buy'){
	//购买官方免费应用
	$res=cloud_request('update.system.buy');
	if($res=='success'){
		exi('购买免费应用成功！您可以到云服务相应的应用管理界面安装应用！','','goback');
	}else{
		exi('购买免费应用失败！','','goback');
	}
}
if ($_RQ['op'] == 'info'){
	//显示系统当前版本信息
	$version=core_setting('version');
	$version['release']=date('20y/m/d H:i:s',$version['release']);
	$return['item']=$version?$version:array();
	$dat = cloud_request('update.system.versions');
	$return['versions']=$dat['versions'];
	if($return['versions']){
		foreach($return['versions'] as &$item){
			$item['description'] = cfc('tools')->substr($item['description'],0,81);
			$item['re_time'] = date('20ymd',$item['re_time']);
			$item['title'] = '[进云'.$item['version'].'-'.$item['re_time'].'更新]-'.$item['description'];
		}
	}
	$return['htmls'][]=array(
		'type'=>'look',
		'tabs'=>$tabs,
		'desc'=>'系统信息',
		'look'=>array(
			array('type'=>'tip','title'=>'[<red>温馨提示</red>]：如果长时间没有反应，更新异常，更新失败等；请移步：<a href="http://s.jinyunweb.com/manage/index.php?p=core&action=article.show&nosession=1&id=412" target="_blank">更新异常排查教程</a>'),
			array('type'=>'string','name'=>'version','title'=>'系统当前版本'),
			array('type'=>'string','name'=>'release','title'=>'版本更新日期'),
		),
	);
	$return['htmls'][]=array(
		'type'=>'notice',
		'desc'=>'更新日志',
		'list'=>'versions',
	);
	exi($return);
}
if ($_RQ['op'] == 'del_up_cache'){
	//删除更新缓存
	cache_write('dat','');
	exi('成功删除更新数据缓存！您可以重新检查更新了！更新数据缓存将在更新成功时自动清除，如果更新失败，可在此手动清除！','','info');
}
if ($_RQ['op'] == 'bak'){
	$return=array('item'=>array());
	$return['htmls']=array(
		'type'=>'edit',
		'post'=>'bak_post',
		'desc'=>'本回滚功能用于回滚系统更新时自动进行的备份。自行修改的文件无法在此处回滚！',
		'tabs'=>$tabs,
		'edit'=>array(
			array('type'=>'time','name'=>'time','title'=>'回滚时刻','help'=>'设置回滚到哪一时刻'),
		),
	);
	exi($return);
}
if ($_RQ['op'] == 'bak_post'){
	$mdir=ROOT_AT .'system_baks';
	$post=get_postdata();
	$time=strtotime($post['time']);
	$baks=array();
	foreach(scandir($mdir) as $temp){
		if($temp=='.'||$temp=='..'){
			continue;
		} 
		if((int)$temp>$time){
			$baks[]=$temp;
		}
	}
	arsort($baks,SORT_NUMERIC);
	foreach($baks as $bak){
		$zip = new ZipArchive();
		$zip->open($mdir.'/'.$bak);
		$zip->extractTo(ROOT_D);
		$zip->close();
		@unlink($mdir.'/'.$bak);
	}
	exi('成功将系统回滚至指定时刻！','','info');
}
if ($_RQ['op'] == 'menu') {
	//同步系统菜单
	if($_AR['system']['noup_menus']==1){
		exi('系统设置已经关闭菜单同步！请开启后，再同步菜单！','error');
	}
	$menu=cloud_request('update.data.menu');
	core_setting('menu',$menu);
	exi('同步成功！如菜单未更新请刷新页面！','success','info');
}
if($_RQ['op'] == 'permission') {
	//同步系统权限数据
	$permissions=cloud_request('update.data.permission');
	foreach($permissions as $row){
		$id=pdo_getcolumn('core_permissions',array('action'=>$row['action'],'op'=>$row['op']),'id');
		if($id){
			unset($row['id'],$row['action'],$row['op']);
			pdo_update('core_permissions',$row,array('id'=>$id));
		}else{
			unset($row['id']);
			pdo_insert('core_permissions',$row);
		}
	}
	exi('同步成功！','success','info');
}
if ($_RQ['op'] == 'ignore') {
	//更新忽略数据管理
	$pindex = max(1, intval($_RQ['page']));
	$psize = 15;
	$return['types']=array(
		'1'=>'数据表',
		'2'=>'文件'
	);
	$params=array('plugin_id'=>0);
	//忽略类型
	if(!empty($_RQ['type'])){
		$params['type']=intval($_RQ['type']);
		$return['params']['type']=$params['type'];
	}
	//忽略项目名称
	if(!empty($_RQ['name'])){
		$params['name like']='%'.trim($_RQ['name']).'%';
		$return['params']['name']=$_RQ['name'];
	}
	$list=pdo_getslice('core_ignores',$params,array($pindex,$psize),$total);
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['htmls']=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('data'=>'list','tip'=>'【开启忽略】-系统设置-<red>开启忽略模式</red>，要清空缓存后才有效！！注意，处于忽略列表中的文件和数据表更新时将不再被检测，请谨慎设置，以免出现不可预知的错误！一般情况下，如系统没有进行二次开发，则无需设置忽略项！','edit_op'=>'ignore_edit','del_op'=>'ignore_del','list'=>array(
			array('type'=>'string','name'=>'name','title'=>'忽略内容'),
			array('type'=>'radio','name'=>'type','title'=>'忽略类型','options'=>'types'),
			array('type'=>'time','name'=>'createtime','title'=>'创建时间'),
		)),
		'search_one'=>array('name'=>'name','select'=>true,'select_name'=>'type','is_radio'=>true,'options'=>'types','select_title'=>'忽略类型','add_op'=>'ignore_edit'),
	);
	exi($return);
}
if($_RQ['op']=='ignore_edit'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$data=array(
			'name'=>$post['name'],
			'type'=>intval($post['type']),
		);
		$id=intval($post['id']);
		if($id){
			pdo_update('core_ignores',$data,array('id'=>$id));
		}else{
			$data['plugin_id']=0;
			$data['createtime']=TIMESTAMP;
			pdo_insert('core_ignores',$data);
		}
		exi('操作成功！');
	}
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_ignores',array('id'=>$id));
	}else{
		$item=array();
	}
	$return['item']=$item;
	$return['types']=array(
		'1'=>'数据表',
		'2'=>'文件'
	);
	$return['htmls']=array(
		'type'=>'edit',
		'desc'=>'编辑忽略内容',
		'tabs'=>$tabs,
		'edit'=>array(
			array('type'=>'radio','name'=>'type','title'=>'忽略类型','options'=>'types'),
			array('type'=>'string','name'=>'name','title'=>'忽略内容'),
		),
	);
	exi($return);
}
if ($_RQ['op'] == 'ignore_del') {
	//删除忽略设置
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_ignores',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_ignores',array('id'=>$id));
			}
		}
	}
	exi('删除成功！');
}
$dat=cache_read('dat');
if(!$dat){
	$tables=pdo_fetchall("SHOW TABLES LIKE '".TABLE_PRE."core_%'");
	$sqls=array();
	foreach($tables as $table){
		$tablename=array_shift($table);
		$sql=pdo_fetch('show create table '.$tablename);
		$name=explode('_',$tablename,2);
		$name=$name['1'];
		$sqls[$name]=$sql['Create Table'];
	}
	//添加额外表
	$more_tables=array('qrcode_stat','account_wechats','mc_mapping_fans','rule','rule_keyword','cover_reply','mc_credits_record','core_pay_log','uni_account_users');
	foreach($more_tables as $tablename){
		$sql=pdo_fetch('show create table '.TABLE_PRE.$tablename);
		$sqls[$tablename]=$sql['Create Table'];
	}
    $pars=array('oldsqls'=>$sqls);
	if($_AR['system']['open_ignore']){
		//如果启用忽略，则从数据库中读取忽略列表
		$ignore_tables=pdo_getall('core_ignores',array('plugin_id'=>0,'type'=>1),array('name'),'name');
		if($ignore_tables){
			$ignore_tables=array_keys($ignore_tables);
		}else{
			$ignore_tables=array();
		}
		$ignore_files=pdo_getall('core_ignores',array('plugin_id'=>0,'type'=>2),array('name'),'name');
		if($ignore_files){
			$ignore_files=array_keys($ignore_files);
		}
	}else{
		$ignore_files=$ignore_tables=array();
	}
	$pars['release']=core_setting('version');
	$pars['release']=$pars['release']?$pars['release']['release']:0;
	$pars['ignore_tables']=$ignore_tables;
	//读取当前插件、pc页面组件、手机端页面组件数据
	$pars['plugins']=pdo_getall('core_plugins',array(),array('cloud_id','release'));
	$pars['mobile_blocks']=pdo_getall('core_mobile_blocks',array(),array('cloud_id','release'));
	$pars['pc_blocks']=pdo_getall('core_pc_blocks',array(),array('cloud_id','release'));
	$pars['api_version']='2.0';
    $dat = cloud_request('update.system.build', $pars);
	foreach($dat['files'] as $file=>$checksum){
		if($ignore_files && in_array($file,$ignore_files)){
			//处于忽略列表中，忽略对比
			continue;
		}
		if(!is_file(ROOT_D .$file) || md5_file(ROOT_D .$file)!=$checksum){
			$dat['upfiles'][]=$file;
		}
	}
	$dat['time']=TIMESTAMP;
    cache_write('dat',base64_encode(serialize($dat)),'core','系统在线更新对比数据缓存');
}else{
	$dat=@unserialize(base64_decode($dat));
}
if(!$dat){
	cache_write('dat','','core','系统在线更新对比数据缓存');
	exi('更新出错，系统已修复这个问题，请重新点击更新！','error','info');
}
if($_RQ['op'] == 'update_post'){
	if(!$_SESSION['download'] || !is_file(ROOT_AT.'system.update_data')){
		$postdata=get_postdata();
		//同步系统菜单
		if($postdata['menu'] && $_AR['system']['noup_menus']!=1){
			$menu=cloud_request('update.data.menu');
			core_setting('menu',$menu);
		}
		//更新数据库
		if($postdata['uptables']){
			$postdata['uptables']=trim($postdata['uptables'],';');
			$postdata['uptables']=explode(';',$postdata['uptables']);
		}
		if(!empty($postdata['uptables'])){
			$sql_data="<?php
";
			foreach($postdata['uptables'] as $table){
				$sql_data.=$dat['upsqls'][$table];
			}
			file_put_contents(ROOT_AT.'update.php',$sql_data);
			require(ROOT_AT.'update.php');
			@unlink(ROOT_AT.'update.php');
		}
		//同步系统权限数据
		if($postdata['permission']){
			$permissions=cloud_request('update.data.permission');
			foreach($permissions as $row){
				$id=pdo_getcolumn('core_permissions',array('action'=>$row['action'],'op'=>$row['op']),'id');
				if($id){
					unset($row['id'],$row['action'],$row['op']);
					pdo_update('core_permissions',$row,array('id'=>$id));
				}else{
					unset($row['id']);
					pdo_insert('core_permissions',$row);
				}
			}
		}
		$core_types=cloud_request('update.data.core_types');
		if($core_types){
			foreach($core_types as $core_type){
				$core_type['data']=cfc('tools')->base64_encode(serialize($core_type['data']));
				pdo_insert('core_types',$core_type,true);
			}
		}
		
		//更新文件
		if($postdata['upfiles']){
			$postdata['upfiles']=trim($postdata['upfiles'],';');
			$postdata['upfiles']=explode(';',$postdata['upfiles']);
		}
		//检查文件权限
		if(!empty($postdata['upfiles'])){
			$error=array();
			foreach($postdata['upfiles'] as $f){
			$path = ROOT_D.$f;
				if(file_exists($path)){
					if(!is_writable($path)){
					 $error[]=$f.'文件没有写入的权限';
					}
				}else{
					$path=get_dirname($path);
					if(!is_writable($path)){
					$error[]=$path.'文件夹没有写入的权限';
					}
				}
			}
		}
		if($error){
			$error=implode(';',$error);
			exi($error,'error');
		}
		
		if(!empty($postdata['upfiles'])){
			if(!is_dir(ROOT_AT .'system_baks')){
				@mkdir(ROOT_AT .'system_baks');
			}
			$bak=ROOT_AT .'system_baks/'.time();
			$zip= new ZipArchive();
			$zip->open($bak, ZipArchive::CREATE);
			
			foreach($postdata['upfiles'] as $file){
				if(is_file(ROOT_D .$file)){
					$zip->addFile(ROOT_D .$file,$file);
				}
			}
			$zip->close();
			$pars = array();
			$pars['files']=$postdata['upfiles'];
			$pars['new']=1;
			$files = cloud_request('update.system.get', $pars);
			$_SESSION['download']=array(
				'id'=>$files['id'],
				'parts'=>$files['parts'],
				'to'=>'system.update',
				'back'=>'core/cloud.update/update_post',
			);
			$postdata=serialize($postdata);file_put_contents(ROOT_AT.'system.update_data',$postdata);
			exi('准备下载更新文件！','success','core/cloud.download/');
		}
	}
	if(is_file(ROOT_AT.'system.update')){
		$zip = new ZipArchive();
		$zip->open(ROOT_AT.'system.update');
		$zip->extractTo(ROOT_D);
		$zip->close();
		@unlink(ROOT_AT.'system.update');
	}
	if($_SESSION['download']){
		unset($_SESSION['download']);
	}
	if(!$postdata){
		$postdata=file_get_contents(ROOT_AT.'system.update_data');
		if($postdata){
			$postdata=unserialize($postdata);
		}
		@unlink(ROOT_AT.'system.update_data');
	}
	if(!$postdata){
		exi('页面参数错误！','error');
	}
	//更新版本，执行版本更新脚本
	foreach($dat['versions'] as $version){
		if($version['update_file']){
			$update_file=ROOT_D.$version['update_file'];
			if(!is_file($update_file)){
				continue;
				//exi('版本更新脚本文件不存在！更新失败！'.$update_file,'error','info');
			}
			require($update_file);
			core_setting('version',array_fields(array('version','release'),$version));
		}
	}
	core_setting('version',$dat['version']);
	
	//更新页面缓存
	$update=array('urlargs'=>TIMESTAMP);
	core_setting('cache',$update);
	//将忽略文件存入数据库，以备下次忽略
	if($postdata['is_ignore']){
		if($dat['upfiles']){
			foreach($dat['upfiles'] as $file){
				if(!$postdata['upfiles'] || !in_array($file,$postdata['upfiles'])){
					$data=array(
						'type'=>2,
						'name'=>$file,
						'createtime'=>TIMESTAMP
					);
					pdo_insert('core_ignores',$data);
				}
			}
		}
		if($dat['uptables']){
			foreach($dat['uptables'] as $table){
				if(!$postdata['uptables'] || !in_array($table,$postdata['uptables'])){
					$data=array(
						'type'=>1,
						'name'=>$table,
						'createtime'=>TIMESTAMP
					);
					pdo_insert('core_ignores',$data);
				}
			}
		}
	}
	//检查是否更新成功
	if($postdata['upfiles']){
		$failedfiles=array();
		foreach($postdata['upfiles'] as $file) {
			$entry = ROOT_D . $file;
			if(!is_file($entry) || md5_file($entry) != $dat['files'][$file]) {
				
				$failedfiles[] = $file;
			}
		}
	}
	
	if(empty($failedfiles)){
		$_SESSION['more_update']=array();
		if($postdata['plugins']){
			//插件前往插件管理处更新
			//$_SESSION['more_update']['plugins']=$postdata['plugins'];
			
		}
		if($postdata['pc_blocks']){
			$_SESSION['more_update']['pc_blocks']=$postdata['pc_blocks'];
			
		}
		if($postdata['mobile_blocks']){
			$_SESSION['more_update']['mobile_blocks']=$postdata['mobile_blocks'];
			
		}
		if($_SESSION['more_update']){
			exi('框架更新成功，点击确定进入应用更新页面！','','app_update');
		}else{
			cache_write('dat','');
			exi('更新成功！','','info');
		}
		
	}else{
		$dat['upfiles']=$failedfiles;
		$dat['upsqls']=array();
		cache_write('dat',$dat);
		exi('部分文件更新失败！请检查服务器权限后尝试再次更新！','error');
	}
}
if($_RQ['op'] == 'app_update'){
	//更新官方应用
	$return=array();
	if($_SESSION['more_update']['plugins']){
		foreach($dat['plugins'] as $item){
			if(strexists($_SESSION['more_update']['plugins'],';'.$item['id'].';')){
				$item['id']=pdo_getcolumn('core_plugins',array('cloud_id'=>$item['id']),'id');
				$return['plugins'][]=$item;
			}
		}
	}
	if($_SESSION['more_update']['pc_blocks']){
		foreach($dat['pc_blocks'] as $item){
			if(strexists($_SESSION['more_update']['pc_blocks'],';'.$item['id'].';')){
				$item['id']=pdo_getcolumn('core_pc_blocks',array('cloud_id'=>$item['id']),'id');
				$return['pc_blocks'][]=$item;
			}
		}
	}
	if($_SESSION['more_update']['mobile_blocks']){
		foreach($dat['mobile_blocks'] as $item){
			if(strexists($_SESSION['more_update']['mobile_blocks'],';'.$item['id'].';')){
				$item['id']=pdo_getcolumn('core_mobile_blocks',array('cloud_id'=>$item['id']),'id');
				$return['mobile_blocks'][]=$item;
			}
		}
	}
	cache_write('dat','');
	unset($_SESSION['more_update']);
	exi($return);
}

if($_RQ['op'] == 'update'){
	$return=array();
	$return['item']=array();
	if($_AR['system']['open_ignore']){
		//启用忽略机制
		$return['upfiles']=array();
		if($dat['upfiles']){
			$return['item']['upfiles']=';';
			foreach($dat['upfiles'] as $file){
				$return['upfiles'][$file]=$file;
				$return['item']['upfiles'].=$file.';';
			}
		}
		$return['versions']=array();
		if($dat['versions']){
			$return['item']['versions']=';';
			foreach($dat['versions'] as $version){
				$return['versions'][$version['version']]=$version['version'].':'.$version['description'];
				$return['item']['versions'].=$version.';';
			}
		}
		$return['uptables']=array();
		if($dat['uptables']){
			$return['item']['uptables']=';';
			foreach($dat['uptables'] as $table){
				$return['uptables'][$table]=$table;
				$return['item']['uptables'].=$table.';';
			}
		}
		//检查是否存在待更新官方插件
		$return['plugins']=array();
		if($dat['plugins']){
			$return['item']['plugins']=';';
			foreach($dat['plugins'] as $row){
				$return['plugins'][$row['id']]=$row['title'].$row['version'];
				$return['item']['plugins'].=$row['id'].';';
			}
		}
		//检查是否存在待更新官方页面组件
		$return['mobile_blocks']=array();
		if($dat['mobile_blocks']){
			$return['item']['mobile_blocks']=';';
			foreach($dat['mobile_blocks'] as $row){
				$return['mobile_blocks'][$row['id']]=$row['title'].$row['version'];
				$return['item']['mobile_blocks'].=$row['id'].';';
			}
		}
		//检查是否存在待更新官方pc端组件
		$return['pc_blocks']=array();
		if($dat['pc_blocks']){
			$return['item']['pc_blocks']=';';
			foreach($dat['pc_blocks'] as $row){
				$return['pc_blocks'][$row['id']]=$row['title'].$row['version'];
				$return['item']['pc_blocks'].=$row['id'].';';
			}
		}
		$update=false;
		foreach($return as $row){
			if($row){
				$update=true;
				break;
			}
		}
		if(!$update){
			//无需更新
			cache_write('dat','');
			exi('恭喜！您的程序已是最新版本！','success','info');
		}
		$return['item']['menu']=1;
		$return['item']['permission']=1;
		$return['htmls']=array(
			'type'=>'edit',
			'post'=>'update_post',
			'tabs'=>$tabs,
			//'edit_tab'=>true,
			'edit'=>array(
				array('type'=>'tip','title'=>'[<red>温馨提示</red>]：如果长时间没有反应，更新异常，更新失败等；请移步：<a href="http://s.jinyunweb.com/manage/index.php?p=core&action=article.show&nosession=1&id=412" target="_blank">更新异常排查教程</a>'),
				array('type'=>'switch','name'=>'menu','title'=>'同步系统菜单','help'=>'选择更新的同时是否同步系统菜单。系统菜单可以在此处更新，也可点击上面的同步菜单按钮单独更新，或者自己diy设计！'),
				array('type'=>'switch','name'=>'permission','title'=>'同步系统权限数据','help'=>'选择更新的同时是否同步系统权限数据。系统权限数据可以在此处更新，也可点击上面的同步权限按钮单独更新，或者自己diy设计！'),
				array('type'=>'checkbox','name'=>'upfiles','title'=>'待更新文件列表','options'=>'upfiles','choose_all'=>true,'help'=>'勾选需要更新的文件，未勾选的系统自动忽略'),
				array('type'=>'checkbox','name'=>'uptables','title'=>'待更新数据表列表','options'=>'uptables','choose_all'=>true,'help'=>'勾选需要更新的数据表，未勾选的系统自动忽略'),
				array('type'=>'checkbox','name'=>'versions','title'=>'待更新版本列表','options'=>'versions','choose_all'=>true,'help'=>'版本自动更新到最新'),
				array('type'=>'checkbox','name'=>'plugins','title'=>'待更新官方插件','options'=>'plugins','choose_all'=>true,'help'=>'功能插件请前往云服务——插件管理处更新，此处不再一起更新！'),
				array('type'=>'checkbox','name'=>'mobile_blocks','title'=>'待更新官方手机页面组件','options'=>'mobile_blocks','choose_all'=>true,'help'=>'勾选需要更新的组件'),
				array('type'=>'checkbox','name'=>'pc_blocks','title'=>'待更新官方pc页面组件','options'=>'pc_blocks','choose_all'=>true,'help'=>'勾选需要更新的组件'),
				array('type'=>'switch','name'=>'is_ignore','title'=>'是否保存忽略的文件和数据表','help'=>'保存后，下次更新将不再检测被忽略的文件和数据表'),
			),
		);
	}else{
		//不启用忽略机制，仅显示更新项，不允许编辑
		$return['upfiles']=array();
		if($dat['upfiles']){
			$return['item']['upfiles']=';';
			foreach($dat['upfiles'] as $file){
				$return['upfiles'][]=array('file'=>$file);
				$return['item']['upfiles'].=$file.';';
			}
		}
		$return['versions']=array();
		if($dat['versions']){
			$return['item']['versions']=';';
			foreach($dat['versions'] as $version){
				$return['versions'][]=array('release'=>date('20ymd',$version['release']).'-','version'=>'V'.$version['version'],'description'=>$version['description']);
				$return['item']['versions'].=$version.';';
			}
		}
		$return['uptables']=array();
		if($dat['uptables']){
			$return['item']['uptables']=';';
			foreach($dat['uptables'] as $table){
				$return['uptables'][]=array('table'=>$table);
				$return['item']['uptables'].=$table.';';
			}
		}
		//检查是否存在待更新官方插件
		/*$return['plugins']=array();
		if($dat['plugins']){
			$return['item']['plugins']=';';
			foreach($dat['plugins'] as $row){
				$return['plugins'][$row['id']]=$row['title'].$row['version'];
				$return['item']['plugins'].=$row['id'].';';
			}
		}*/
		//检查是否存在待更新官方页面组件
		$return['mobile_blocks']=array();
		if($dat['mobile_blocks']){
			$return['item']['mobile_blocks']=';';
			foreach($dat['mobile_blocks'] as $row){
				$return['mobile_blocks'][]=array('title'=>$row['title'],'version'=>$row['version']);
				$return['item']['mobile_blocks'].=$row['id'].';';
			}
		}
		//检查是否存在待更新官方pc端组件
		$return['pc_blocks']=array();
		if($dat['pc_blocks']){
			$return['item']['pc_blocks']=';';
			foreach($dat['pc_blocks'] as $row){
				$return['pc_blocks'][]=array('title'=>$row['title'],'version'=>$row['version']);
				$return['item']['pc_blocks'].=$row['id'].';';
			}
		}
		$update=false;
		foreach($return as $row){
			if($row){
				$update=true;
				break;
			}
		}
		if(!$update){
			//无需更新
			cache_write('dat','');
			exi('恭喜！您的程序已是最新版本！','success','info');
		}
		$return['item']['menu']=1;
		$return['item']['permission']=1;
		$htmls=array();
		$htmls[]=array(
			'type'=>'itemlist',
			'data'=>'upfiles',
			'title'=>'待更新文件列表:',
			'list'=>array(
				array('type'=>'string','name'=>'file','title'=>'文件路径'),
			)
		);
		$htmls[]=array(
			'type'=>'itemlist',
			'data'=>'uptables',
			'title'=>'待更新数据表列表:',
			'list'=>array(
				array('type'=>'string','name'=>'table','title'=>'文件路径'),
			)
		);
		$htmls[]=array(
			'type'=>'itemlist',
			'data'=>'versions',
			'title'=>'待更新版本列表:',
			'list'=>array(
				array('type'=>'string','name'=>'release','title'=>'时间'),
				array('type'=>'string','name'=>'version','title'=>'版本号'),
				array('type'=>'string','name'=>'description','title'=>'更新说明'),
			)
		);
		$htmls[]=array(
			'type'=>'itemlist',
			'data'=>'mobile_blocks',
			'title'=>'待更新手机页面组件列表:',
			'list'=>array(
				array('type'=>'string','name'=>'title','title'=>'组件名称'),
				array('type'=>'string','name'=>'version','title'=>'组件版本'),
			)
		);
		$htmls[]=array(
			'type'=>'itemlist',
			'data'=>'pc_blocks',
			'title'=>'待更新PC页面组件列表:',
			'list'=>array(
				array('type'=>'string','name'=>'title','title'=>'组件名称'),
				array('type'=>'string','name'=>'version','title'=>'组件版本'),
			)
		);
		$htmls[]=array(
			'type'=>'edit',
			'post'=>'update_post',
			'desc'=>'其他更新项',
			'edit'=>array(
				array('type'=>'switch','name'=>'menu','title'=>'同步系统菜单','help'=>'选择更新的同时是否同步系统菜单。系统菜单可以在此处更新，也可点击上面的同步菜单按钮单独更新，或者自己diy设计！'),
				array('type'=>'switch','name'=>'permission','title'=>'同步系统权限数据','help'=>'选择更新的同时是否同步系统权限数据。系统权限数据可以在此处更新，也可点击上面的同步权限按钮单独更新，或者自己diy设计！'),
			),
		);
		$return['htmls']=$htmls;
	}
	
	exi($return);
}
function get_dirname($file){
	$dir=dirname($file);
	if(!is_dir($dir)){
		$dir=get_dirname($dir);
	}
	return $dir;
}
?>