<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	此处仅管理插件小程序，微官网小程序和diy小程序不在此处管理
	插件小程序不管是扫码发布还是一键发布，都是先上传到微信开放平台
	小程序管理，小程序的安装、管理、卸载
	小程序数据表：id、version、title、plugin、template_id、price、days、image、type（扫码发布，一键发布）
	小程序更新：根据小程序版本，判断更新。更新方法为，联系开发者协助上传新的小程序模版，然后设置新的模版id
	小程序发布新版本：小程序开发者直接发布新版本，设置更新说明，然后设置发布模式
	为方便客户使用，直接添加一个栏目：待更新小程序列表
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'installed';
$return=array();
$tabs=array(
			array('op'=>'installed','title'=>'已安装的小程序'),
			//array('op'=>'updates','title'=>'待更新的小程序'),
			array('op'=>'prepared','title'=>'已购买待安装的小程序'),
			array('op'=>'api_list','title'=>'源自第三方安装'),
			array('op'=>'api_prepared','title'=>'第三方待安装'),
);
if($_RQ['op'] == 'installed') {
	//已安装小程序列表，此处显示所有安装的小程序，但是不检测更新
	$params=array();
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','title','version','image','plugin');
	$list=pdo_getslice('core_wxapp',$params,array($pindex,$psize),$total,$fields,'id',$orderby);
	if($list){
		foreach($list as &$item){
			$item['plugin']=pdo_getcolumn('core_plugins',array('name'=>$item['plugin']),'title');
			$item['plugin']=$item['plugin']?$item['plugin']:'';
		}
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'管理已安装的小程序','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'list'=>array(
			array('name'=>'image','title'=>'小程序logo','type'=>'image'),
			array('name'=>'title','title'=>'小程序名称','type'=>'string'),
			array('name'=>'plugin','title'=>'关联插件','type'=>'string'),
			array('name'=>'version','title'=>'小程序版本','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','op'=>'uninstall','title'=>'卸载'),
			array('type'=>'href','op'=>'edit','title'=>'详情'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op'] == 'api_list') {
	//已安装小程序列表，此处显示所有安装的小程序，但是不检测更新
	$params=array('api_domain <>'=>'');
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','title','version','image','plugin','api_domain');
	$list=pdo_getslice('core_wxapp',$params,array($pindex,$psize),$total,$fields,'id',$orderby);
	if($list){
		foreach($list as &$item){
			$item['plugin']=pdo_getcolumn('core_plugins',array('name'=>$item['plugin']),'title');
			$item['plugin']=$item['plugin']?$item['plugin']:'';
		}
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'[<red>温馨提示</red>]</br>1、所谓第三方安装，即通过第三方的应用市场，安装的应用！</br>2、移步系统管理--云服务--第三方市场，创建一个第三方市场，然后在第三方市场列表页，点击前往应用市场。3、所有第三方应用，所有权归第三方解释，一切购买安装动作，都是在第三方独立操作！</br>3、如果已安装的应用，再第三方购买后，只能更新，且版本必须大于已安装的应用版本！','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'list'=>array(
			array('name'=>'image','title'=>'小程序logo','type'=>'image'),
			array('name'=>'title','title'=>'小程序名称','type'=>'string'),
			array('name'=>'plugin','title'=>'关联插件','type'=>'string'),
			array('name'=>'version','title'=>'小程序版本','type'=>'string'),
			array('name'=>'api_domain','title'=>'来源第三方域名','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','op'=>'uninstall','title'=>'卸载'),
			array('type'=>'href','op'=>'edit','title'=>'详情'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if ($_RQ['op'] == 'edit') {
	if($_RQ['postdata']){
		$post=get_postdata();
		$id=intval($post['id']);
		$update=array_fields(array('title','image'),$post);
		pdo_update('core_wxapp',$update,array('id'=>$id));
		exi('设置成功！','','goback');
	}
	$id=intval($_RQ['id']);
	$item=pdo_get('core_wxapp',array('id'=>$id),array('id','title','image'));
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'edit'=>array(
			array('type'=>'string','name'=>'title','title'=>'小程序名称'),
			array('type'=>'image','name'=>'image','title'=>'小程序logo'),
		),
	);
	exi($return);
}
if ($_RQ['op'] == 'uninstall') {
	//卸载模版。卸载模版时，服务套餐中有包含该模版的，公众号有购买该模版的，是否同时将相关数据删除？暂不删除！
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择小程序！','error');
	}
	pdo_delete('core_wxapp',array('id'=>$id));
	exi('卸载成功！');
}
if($_RQ['op'] == 'updates') {
	//待更新小程序列表，此处显示所有待更新的小程序
	$params=array();
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$fields=array('id','title','version','version1','image','cloud_id');
	$list=pdo_getall('core_wxapp',$params,$fields,'cloud_id');
	$cloud_ids=';';
	foreach($list as &$item){
		$cloud_ids.=$item['cloud_id'].';';
	}
	if($cloud_ids!=';'){
		$cloud=cloud_request('update.wxapp.check',array('ids'=>$cloud_ids));
		foreach($list as $key=>&$item){
			if($cloud[$key]['version1'] && $item['version1']<$cloud[$key]['version1']){
				$item['new_version']=$row['version'];
				$item['update']=array('op'=>'update','query'=>"id={$item['id']}&version={$item['new_version']}");
			}else{
				unset($list[$key]);
			}
		}
	}
	$return['list']=$list?$list:array();
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'管理已安装的小程序','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'image','title'=>'小程序logo','type'=>'image'),
			array('name'=>'title','title'=>'小程序名称','type'=>'string'),
			array('name'=>'version','title'=>'当前版本','type'=>'string'),
			array('name'=>'new_version','title'=>'待更新版本','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','name'=>'update','title'=>'更新'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op'] == 'update') {
	//更新小程序
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要更新的小程序！','error');
	}
	$new_version=trim($_RQ['new_version']);
	if(!$new_version){
		exi('页面参数错误！','error');
	}
	$item=pdo_get('core_wxapp',array('id'=>$id),array('id','title','image','version','cloud_id'));
	if(!$item){
		exi('指定的小程序不存在！','error');
	}
	pdo_update('core_wxapp',array('version'=>$new_version),array('id'=>$id));
	exi('更新成功！','','updates');
	/*$update=cloud_request('update.wxapp.update',array('id'=>$item['cloud_id']));
	if($update['type']==1){
		//联系开发者发布
		$item['new_version']=$new_version;
		$item['template_id']='';
		$item['type']=$update['type'];
		$item['author']=$update['author'];
		$item['code']=$update['code'];
		$return['item']=$item;
		$htmls=array(
			'type'=>'edit',
			'desc'=>'更新小程序',
			'post'=>'update_post',
			'edit'=>array(
				array('type'=>'string','name'=>'title','title'=>'小程序名称'),
				array('type'=>'image','name'=>'image','title'=>'小程序logo'),
				array('type'=>'string','name'=>'version','title'=>'当前小程序版本'),
				array('type'=>'string','name'=>'new_version','title'=>'待更新版本'),
				array('type'=>'string','name'=>'template_id','title'=>'新版本模版id','help'=>'请联系开发者协助上传小程序至微信开放平台模版库，然后登陆微信开放平台获取新上传的模版的id，填至此处。'),
				array('type'=>'string','name'=>'code','title'=>'购买码','read'=>true,'help'=>'将本购买码提交给开发者以验证身份'),
				array('type'=>'string','name'=>'author.name','title'=>'小程序开发者','read'=>true),
				array('type'=>'string','name'=>'author.qq','title'=>'开发者QQ','read'=>true),
				array('type'=>'string','name'=>'author.mobile','title'=>'开发者联系电话','read'=>true),
			),
		);
		$return['htmls']=$htmls;
		exi($return);
	}else{
		//通过对接云平台扫码上传。扫码上传，此处直接对接云平台获取二维码
		$item['new_version']=$new_version;
		$item['template_id']=0;
		$item['type']=$update['type'];
		$return['item']=$item;
		$return['post']='update_post';
		exi($return);
	}*/
}
if($_RQ['op'] == 'update_post'){
	$post=get_postdata();
	$id=intval($post['id']);
	if(!$id){
		exi('页面参数错误！','error');
	}
	$update=array(
		'version'=>$post['version'],
		'template_id'=>intval($post['template_id']),
		'version1'=>intval(str_replace('.','',$post['version'])),
		'type'=>intval($post['type'])
	);
	pdo_update('core_wxapp',$update,array('id'=>$id));
	exi('更新成功！');
}
if($_RQ['op'] == 'prepared'){
	//待安装小程序列表
	$installed = pdo_getall('core_wxapp',array(),array('cloud_id'),'cloud_id');
	$installed=array_keys($installed);
	$installed=implode(';',$installed);
	$result=cloud_request('update.wxapp.getbuyed',array('installed'=>$installed));
	$return['list']=$result;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'此处显示已购买但尚未安装的小程序','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'image','title'=>'小程序logo','type'=>'image'),
			array('name'=>'title','title'=>'小程序名称','type'=>'string'),
			array('name'=>'version','title'=>'小程序版本','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','op'=>'install','title'=>'安装'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op'] == 'api_prepared'){
	//第三方待安装小程序列表
	$installed = pdo_getall('core_wxapp',array(),array('cloud_id'),'cloud_id');
	$installed=array_keys($installed);
	$installed=implode(';',$installed);
	$api_shops=pdo_getall('core_api_shop',array(),array('id'));
	$list=array();
	if($api_shops){
		foreach($api_shops as $item){
			$result=api_request('api_shop.update.wxapp.getbuyed',$item['id'],array('installed'=>$installed));
			foreach($result as &$rv){
				$rv['domain']=$item['domain'];
				$rv['installurl']='core/cloud.wxapp/api_install/id='.$rv['id'].'&api_id='.$item['id'];
				$list[]=$rv;
			}
		}
	}
	$return['list']=$list;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'此处显示第三方已购买但尚未安装的小程序','data'=>'list','del_one'=>false,'delall'=>false,'edit'=>false,'pagelist'=>false,'list'=>array(
			array('name'=>'image','title'=>'小程序logo','type'=>'image'),
			array('name'=>'title','title'=>'小程序名称','type'=>'string'),
			array('name'=>'version','title'=>'小程序版本','type'=>'string'),
		),'action'=>array(
			array('type'=>'post_item','action'=>'installurl','title'=>'安装'),
		)),
		'search_one'=>array('name'=>'title','add'=>false),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op'] == 'install') {
	//安装小程序
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要安装的小程序！','error');
	}
	$item=cloud_request('update.wxapp.install',array('id'=>$id));	
	$image=cfc('files')->url_source_save($item['image'],'image');
	if(is_error($image)){
			$image='';
	}
	$update=array(
			'version'=>$item['version'],
			'type'=>intval($item['type']),
			'title'=>$item['title'],
			'cloud_id'=>intval($item['id']),
			'name'=>$item['name'],
			'plugin'=>$item['plugin'],
			'price'=>intval($item['price']),
			'ish5'=>intval($item['ish5']),
			'isdiy'=>intval($item['isdiy']),
			'image'=>$image
	);
	pdo_insert('core_wxapp',$update);
	exi('安装成功！');
}
if($_RQ['op'] == 'api_install') {
	//安装小程序
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要安装的小程序！','error');
	}
	$api_id=intval($_RQ['api_id']);
	if(!$api_id){
		exi('请先选择第三方！','error');
	}
	$item=api_request('api_shop.update.wxapp.install',$api_id,array('id'=>$id));	
	$image=cfc('files')->url_source_save($item['image'],'image');
	if(is_error($image)){
			$image='';
	}
	$update=array(
			'version'=>$item['version'],
			'type'=>intval($item['type']),
			'title'=>$item['title'],
			'cloud_id'=>intval($item['id']),
			'name'=>$item['name'],
			'plugin'=>$item['plugin'],
			'price'=>intval($item['price']),
			'ish5'=>intval($item['ish5']),
			'isdiy'=>intval($item['isdiy']),
			'image'=>$image
	);
	//第三方域名：
	if($api_id){
		$update['api_domain']=pdo_getcolumn('core_api_shop',array('id'=>$api_id),'domain');
	}
	pdo_insert('core_wxapp',$update);
	exi('安装成功！');
}
if($_RQ['op'] == 'install_post'){
	$post=get_postdata();
	$id=intval($post['id']);
	if(!$id){
		exi('页面参数错误！','error');
	}
	//$image=file_get_contents($post['image']);
	//$ext=substr(strrchr($post['image'],'.'),1);
	$image=cfc('files')->url_source_save($post['image'],'image');
	if(is_error($image)){
		$image='';
	}
	$update=array(
		'version'=>$post['version'],
		'template_id'=>intval($post['template_id']),
		'version1'=>intval(str_replace('.','',$post['version'])),
		'type'=>intval($post['type']),
		'title'=>$post['title'],
		'cloud_id'=>intval($post['id']),
		'plugin'=>$post['plugin'],
		'price'=>intval($post['price']),
		'days'=>intval($post['days']),
		'ish5'=>intval($post['ish5']),
		'image'=>$image
	);
	pdo_insert('core_wxapp',$update);
	exi('安装成功！');
}

