<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	卡券管理
	卡券的增删查改
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
$return['types']=array(
	'1'=>'折扣券',
	'2'=>'代金券',
	'3'=>'兑换券',
	'4'=>'团购券',
	'5'=>'优惠券'
);
if($_RQ['op']=='list'){
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$return['is_wechats']=array(
		'0'=>'系统卡券',
		'1'=>'微信卡券'
	);
	$params=array('uniacid'=>$_SESSION['uniacid']);
	$return['params']=array();
	//是否微信卡券
	if(!empty($_RQ['is_wechat'])){
		$params['is_wechat']=intval($_RQ['is_wechat']);
		$return['params']['is_wechat']=$params['is_wechat'];
	}
	//卡券类型
	if(!empty($_RQ['type'])){
		$params['type']=intval($_RQ['type']);
		$return['params']['type']=$params['type'];
	}
	//卡券名称
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	//时间范围

	if($_RQ['createtime']){
		$time_range=cfc('tools')->base64_decode($_RQ['createtime'],$_SESSION['base_key_str']);
		$time_range=json_decode($time_range,true);
		$return['params']['createtime']=$time_range;
		$params['createtime between']=array($time_range['tstart'],$time_range['tend']);
	}
	$list=pdo_getslice('core_card',$params,array($pindex,$psize),$total,array('id','is_wechat','type','num','title','createtime'),'','createtime');
	//$list=$this->get_list('core_card',$parameter,$total);
	if($list){
		foreach($list as &$log){
			//领取数量
			$log['receive']=pdo_count('core_card_log',array('card_id'=>$log['id'],'uniacid'=>$_SESSION['uniacid']));
			$log['createtime']=date('y/m/d H:i:s',$log['createtime']);
			$log['is_wechat']=$return['is_wechats'][$log['is_wechat']];
			$log['type']=$return['types'][$log['type']];
		}
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'卡券列表'),
			array('op'=>'wechat','title'=>'同步微信卡券'),
		),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'title','title'=>'卡券名称','type'=>'string'),
			array('name'=>'is_wechat','title'=>'卡券类型','type'=>'string'),
			array('name'=>'type','title'=>'卡券种类','type'=>'string'),
			array('name'=>'num','title'=>'卡券数量','type'=>'string'),
			array('name'=>'receive','title'=>'已领取','type'=>'string'),
			array('name'=>'createtime','title'=>'创建时间','type'=>'string'),
		)),
		'search'=>array(
			'0'=>array('type'=>'radio','title'=>'卡券类型','name'=>'is_wechat','options'=>'is_wechats'),
			'1'=>array('type'=>'radio','title'=>'卡券种类','name'=>'type','options'=>'types','help'=>''),
			'2'=>array('type'=>'string','title'=>'卡券名称','name'=>'title','options'=>'wechats','help'=>''),
			'3'=>array('type'=>'time_range','title'=>'创建时间','name'=>'createtime','help'=>''),
		),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_card',array('id'=>$id));
		if(!intval($item['limit_data'])){
			$item['limit_data']=json_decode($item['limit_data'],true);
		}
	}else{
		$item=array();
	}
	$return['item']=$item;
	$return['limits']=array(
		'1'=>'固定日期',
		'2'=>'领取后若干天有效'
	);
	$return['dates']=array('0'=>'当天');
	for($i=1;$i<91;$i++){
		$return['dates'][$i]=$i.'天';
	}
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'卡券',
		'tabs'=>array(
			array('op'=>'list','title'=>'卡券列表'),
			array('op'=>'edit','title'=>'编辑卡券'),
			array('op'=>'wechat','title'=>'同步微信卡券'),
		),
		'edit'=>array(
			'0'=>array('type'=>'radio','title'=>'卡券种类','name'=>'type', 'options'=>'types','help'=>'温馨提示，系统后台只能添加系统卡券，微信卡券请移步微信公众平台添加。此处选择折扣券还是代金券' ),
			'1'=>array('type'=>'string','title'=>'卡券名称','name'=>'title', 'help'=>'' ),
			'2'=>array('type'=>'string','title'=>'卡券数量','name'=>'num','help'=>'设置卡券数量，填写数字即可。' ),
			'3'=>array('type'=>'image','title'=>'卡券logo','name'=>'logo','help'=>'' ),
			'4'=>array('type'=>'color','title'=>'卡券颜色','name'=>'color' , 'help'=>''),
			'5'=>array('type'=>'string','title'=>'使用条件','name'=>'need'),
			'6'=>array('type'=>'string','title'=>'优惠内容','name'=>'data','help'=>'设置优惠内容，如果是折扣券，这里填写打折数值（例如8折填0.8,68折填0.68）。如果是代金券，这里填写抵扣金额（例如抵扣10元，填写10）'),
			'7'=>array('type'=>'radio','title'=>'有效期类型','name'=>'limit_type','options'=>'limits'),
			'8'=>array('type'=>'time_range','title'=>'有效期范围','name'=>'times','show'=>array('limit_type',1)),
			'9'=>array('type'=>'string','title'=>'领取后有效天数','name'=>'limit_data','show'=>array('limit_type',2)),
			'10'=>array('type'=>'string','title'=>'卡券说明','name'=>'content','options'=>'types'),
			'11'=>array('type'=>'string','title'=>'联系电话','name'=>'mobile','options'=>'types'),
		)
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post'){
	$post=get_postdata();
	$data=array(
		'type'=>intval($post['type']),
		'num'=>intval($post['num']),
		'logo'=>trim($post['logo']),
		'title'=>trim($post['title']),
		'title1'=>trim($post['title1']),
		'title2'=>trim($post['title2']),
		'color'=>trim($post['color']),
		'need'=>intval($post['need']),
		'data'=>price($post['data']),
		'limit_type'=>intval($post['limit_type']),
		'content'=>trim($post['content']),
		'mobile'=>trim($post['mobile'])
	);
	if($data['limit_type']==1){
		$data['limit_data']=ijson_encode($post['limit_data']);
	}else{
		$data['limit_data']=intval($post['limit_data']);
	}
	$id=intval($post['id']);
	if($id){
		pdo_update('core_card',$data,array('id'=>$id));
		exi('修改卡券成功！');
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		$data['createtime']=TIMESTAMP;
		pdo_insert('core_card',$data);
		exi('新增卡券成功！');
	}
	
}
if($_RQ['op']=='wechat'){
	//同步微信卡券
	exi('功能开发中！','error');
}
if($_RQ['op']=='del'){
	//删除卡券，同时删除卡券活动
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_card',array('id'=>$id));
		pdo_delete('core_card_activity',array('card_id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_card',array('id'=>$id));
				pdo_delete('core_card_activity',array('card_id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			}
		}
	}
	exi('删除成功！');
}