<?php
/*
	卡券活动管理
	卡券活动的增删查改
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
$return['types']=array(
	'1'=>'立即发放',
	'2'=>'点击进入发放页面发放',
);
$return['card']=pdo_getall('core_card',array('uniacid'=>$_SESSION['uniacid']),array('id','title'));
$return['groups']=pdo_getall('core_member_groups',array('uniacid'=>$_SESSION['uniacid']),array('id','title'));
if($_RQ['op']=='list'){
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$params=array('uniacid'=>$_SESSION['uniacid']);
	$return['params']=array();
	//卡券活动类型
	if(!empty($_RQ['type'])){
		$params['type']=intval($_RQ['type']);
		$return['params']['type']=$params['type'];
	}
	//活动名称
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	//时间范围
	if(!empty($_RQ['tstart']) && $_RQ['tstart'] !='1970-01-01 08:00'){
		$tstart=strtotime($_RQ['tstart']);
		$return['params']['tstart']=trim($_RQ['tstart']);
	}
	if(!empty($_RQ['tend']) && $_RQ['tend'] !='1970-01-01 08:00'){
		$tend=strtotime($_RQ['tend']);
		$return['params']['tend']=trim($_RQ['tend']);
	}
	if($tstart && $tend){
		$params['createtime between']=array($tstart,$tend);
	}elseif($tstart){
		$params['createtime >']=$tstart;
	}elseif($tend){
		$params['createtime <']=$tend;
	}
	$orderby='createtime';
	$list=pdo_getslice('core_card_activity',$params,array($pindex,$psize),$total,array('id','title','type','createtime'),'',$orderby);
	if($list){
		foreach($list as &$log){
			//领取数量
		if($log['type']=1){
		    $log['type']='立即发放';
		}else{
		     $log['type']='点击进入发放页面发放';
		}
			$log['receive']=pdo_count('core_card_log',array('card_id'=>$log['card_id'],'uniacid'=>$_SESSION['uniacid']));
			$log['createtime']=date('y/m/d H:i:s',$log['createtime']);
		}
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['htmls']=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'卡券活动列表'),
			array('op'=>'edit','title'=>'编辑活动'),
		),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'title','title'=>'卡券活动名称','type'=>'string'),
			array('name'=>'type','title'=>'卡券活动类型','type'=>'string'),
			array('name'=>'createtime','title'=>'创建时间','type'=>'string'),
		)),
		'search'=>array(
			'1'=>array('type'=>'radio','title'=>'卡券活动名称','name'=>'type','options'=>'types','help'=>''),
			'2'=>array('type'=>'string','title'=>'卡券活动名称','name'=>'title','help'=>''),
			'3'=>array('type'=>'time_range','title'=>'创建时间','name'=>'createtime','help'=>''),
		),
	    );
	exi($return);
}
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_card_activity',array('id'=>$id));
		$item['ac_time']=json_decode($item['ac_time'],true);
	}else{
		$item=array();
	}
	$return['item']=$item;
    $return['htmls']=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'卡券活动',
		'tabs'=>array(
			array('op'=>'list','title'=>'卡券活动列表'),
			array('op'=>'edit','title'=>'编辑活动'),
		),
		'edit'=>array(
		    '0'=>array('type'=>'select','title'=>'卡券名称','name'=>'card_id','options'=>'card'),
			'1'=>array('type'=>'radio','title'=>'卡券活动类型','name'=>'type', 'options'=>'types' ),
			'2'=>array('type'=>'string','title'=>'卡券活动名称','name'=>'title', 'help'=>'' ),
			'3'=>array('type'=>'string','title'=>'发放数量','name'=>'limit_num','help'=>'设置卡券数量，填写数字即可。' ),
			'4'=>array('type'=>'time_range','title'=>'有效期范围','name'=>'ac_time'),
			'5'=>array('type'=>'select','title'=>'指定会员组','name'=>'groupid','options'=>'groups' ),

		)
	);
	exi($return);
}
if($_RQ['op']=='post'){
	$post=get_postdata();
	$data=array(
		'type'=>intval($post['type']),
		'card_id'=>intval($post['card_id']),
		'limit_num'=>intval($post['limit_num']),
		'title'=>trim($post['title']),
		'groupid'=>intval($post['groupid']),
		'ac_time'=>ijson_encode($post['ac_time'])
	);
	$id=intval($post['id']);
	if($id){
		pdo_update('core_card_activity',$data,array('id'=>$id));
		exi('修改卡券活动成功！');
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		$data['createtime']=TIMESTAMP;
		if($data['type']==1){
			$members=pdo_getall('core_members',array('groupid'=>$data['groupid'],'uniacid'=>$_SESSION['uniacid']),array('id'));
			foreach($members as $member){
				$parameter=array('card_id'=>$data['card_id'],'mid'=>$member['id']);
				cfc('core')->send_card($parameter);
			}
			
		}
		pdo_insert('core_card_activity',$data);
		exi('新增卡券活动成功！');
	}
	
}
if($_RQ['op']=='del'){
	//删除卡券，同时删除卡券活动
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_card_activity',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_card_activity',array('id'=>$id));
			}
		}
	}
	exi('删除成功！');
}