<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	卡券管理
	签到奖品的增删查改
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
$return['types']=array(
	'1'=>'连续签到奖励',
	'2'=>'累计签到奖励'
);
if($_RQ['op']=='list'){
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$params=array('uniacid'=>$_SESSION['uniacid']);
	//奖品名称
	$return['params']=array();
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby='id desc';
	$list=pdo_getslice('core_reward',$params,array($pindex,$psize),$total,array('id','title','type','days','credit1','credit2'),'',$orderby);
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'奖品列表'),
		),
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'title','title'=>'奖品名称','type'=>'string'),
			array('name'=>'type','title'=>'奖品类型','type'=>'radio','options'=>'types'),
			array('name'=>'days','title'=>'所需天数','type'=>'string'),
			array('name'=>'credit1','title'=>'奖励积分','type'=>'string'),
			array('name'=>'credit2','title'=>'奖励余额','type'=>'string'),
		)),
		'search_one'=>array('name'=>'title'),

	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_reward',array('id'=>$id));
	}else{
		$item=array();
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'desc'=>'奖品',
		'tabs'=>array(
			array('op'=>'list','title'=>'奖品列表'),
			array('op'=>'edit','title'=>'编辑奖品'),
		),
		'edit'=>array(
			'0'=>array('type'=>'radio','title'=>'奖品类型','name'=>'type', 'options'=>'types','help'=>'' ),
			'1'=>array('type'=>'string','title'=>'奖品名称','name'=>'title', 'help'=>'' ),
			'5'=>array('type'=>'unitstring','unit'=>'天','title'=>'领奖条件','name'=>'days', 'help'=>'设置领取该奖品需要达到的（连续获累计）签到天数条件，填写数字即可'),
			'6'=>array('type'=>'string','title'=>'奖励积分','name'=>'credit1','help'=>''),
			'7'=>array('type'=>'string','title'=>'奖励余额','name'=>'credit2'),
		)
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post'){
	$post=get_postdata();
	$data=array(
		'type'=>intval($post['type']),
		'days'=>intval($post['days']),
		'credit1'=>intval($post['credit1']),
		'credit2'=>intval($post['credit2']),
		'title'=>trim($post['title']),
	);
	$id=intval($post['id']);
	if($id){
		pdo_update('core_reward',$data,array('id'=>$id));
		exi('修改奖品成功！','','list');
	}else{
		$data['uniacid']=$_SESSION['uniacid'];
		pdo_insert('core_reward',$data);
		exi('新增奖品成功！','','list');
	}
}
if($_RQ['op']=='del'){
	//删除奖品
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_reward',array('id'=>$id));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_reward',array('id'=>$id));
			}
		}
	}
	exi('删除成功！');
}