<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'get';
$return=array();
$tabs=array(
	array('op'=>'get','title'=>'主域名绑定设置'),
	array('op'=>'more','title'=>'其他页面域名智能绑定'),
	array('op'=>'edit','title'=>'添加域名智能绑定'),
);
$tip='[操作教程]</br>1、把新域名用cname的方式解析到'.SITEROOT;
if($_RQ['op']=='get'){
	$return['ip']=$_AR['system']['ip'];
	$return['item']=pdo_get('core_accounts',array('uniacid'=>$_SESSION['uniacid']),array('domain'));
	$htmls=array(
		'type'=>'edit',
		'post'=>'post1',
		'desc'=>'主域名',
		'tabs'=>$tabs,
		'edit'=>array(
			array('type'=>'tip','title'=>$tip),
			array('type'=>'string','title'=>'个人域名','name'=>'domain', 'help'=>'【温馨提示】：这个域名绑定的是个人官网（手机/PC），非本程序平台网站（<a href="javascript:;" ng-click="modal_json(\'core/setting.domain_set/help/\')" class="btn btn-primary" style="padding:2px 6px;font-size:12px;color:#fff">为什么独立域名要指向站点？</a>）。个人域名为空，则使用系统域名，填写域名后，需要将本域名用cname的方式解析到'.SITEROOT.'。' ),
		)
	);
	if(USER_DOMAIN){
		//开启分配独立域名
		$htmls['edit'][]=array('type'=>'copy','title'=>'系统分配访问域名','name'=>'domain_sys', 'help'=>'尚未设置自定义域名时，可以使用此域名访问网站！' );
		$return['item']['domain_sys']=$_SESSION['uniacid'].DOMAIN_PRE;
	}
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post1'){
	$postdata=get_postdata();
	$data=array('domain'=>trim($postdata['domain']));
	if($data['domain']==DOMAIN){
		exi('该域名为系统主域名，不能绑定为个性域名，请更换！','error');
	}
	//检测域名是否已被占用
	if($data['domain']){
		$preg = "/^http(s)?:\\/\\/.+/";
		if(preg_match($preg,$data['domain'])){
			exi('域名不能带有http://或https://。','error');	
		}
		if(!preg_match('/^(\w+[\.]+\w+)+$/',$data['domain'])){
			exi('该域名不合法!!','error');	
		}
		$check=pdo_get('core_accounts',array('domain'=>$data['domain']),'uniacid');
		if($check && $check!=$_SESSION['uniacid']){
			exi('该域名已被其他用户占用，无法绑定！','error');
		}
	}
	pdo_update('core_accounts',$data,array('uniacid'=>$_SESSION['uniacid']));
	exi('设置成功!');
}
if($_RQ['op']=='more'){
	//搜索
	$params=array('uniacid'=>$_SESSION['uniacid']);
	if($_RQ['domain']){
		$params['domain like']='%'.$_RQ['domain'].'%';
		$return['params']['domain']=$_RQ['domain'];
	}
	$fields=array('id','domain','url');
	$pindex = max(1, intval($_RQ['page']));
	$psize = 15;
	$total='';
	$list=pdo_getslice('core_domain',$params,array($pindex,$psize),$total,$fields);
	foreach($list as &$item){
		$preg = "/^http(s)?:\\/\\/.+/";
		if(preg_match($preg,$data['domain'])){
			$item['cnameurl']=$item['url'];
		}else{
			$item['cnameurl']=HTTP.$_SERVER['HTTP_HOST'].'/custom/index.php?'.$item['url'];
		}
	}
	$return['list']=$list?$list:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	//页面显示设置
	$tip .=';或者解析到，下面列表的：cname解析域名地址';
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('data'=>'list','tip'=>$tip,'list'=>array(
			array('name'=>'domain','title'=>'域名','type'=>'string'),
			array('name'=>'url','title'=>'绑定url','type'=>'string'),
			array('name'=>'cnameurl','title'=>'cname解析域名地址','type'=>'copy'),
		)),
		'search_one'=>array('name'=>'domain'),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='del'){
	//删除
	$dels=array();
	if($_RQ['id']){
		$dels[]=intval($_RQ['id']);
	}
	if($_RQ['del']){
		$del=trim($_RQ['del'],';');
		$del=explode(';',$del);
		foreach($del as $id){
			$dels[]=intval($id);
		}
	}
	if($dels){
		foreach($dels as $id){
			if($id){
				pdo_delete('core_domain',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			}
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_domain',array('uniacid'=>$_SESSION['uniacid'],'id'=>$id));
	}else{
		$item=array();
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post2',
		'desc'=>'域名绑定设置',
		'tabs'=>$tabs,
		'edit'=>array(
			array('type'=>'string','title'=>'待绑定的域名','name'=>'domain', 'help'=>'填写域名后，需要将本域名解析到{{pagedata.ip}}，然后联系系统管理员协助处理方能生效。' ),
			array('type'=>'link','title'=>'绑定页面','name'=>'url' ),
		)
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post2'){
	$postdata=get_postdata();
	$data=array(
			'domain'=>trim($postdata['domain']),
			'url'=>trim($postdata['url'])
	);
	$preg = "/^http(s)?:\\/\\/.+/";
	if(preg_match($preg,$postdata['domain'])){
		exi('域名不能带有http://或https://。','error');	
	}
	if(!preg_match('/^(\w+[\.]+\w+)+$/',$postdata['domain'])){
		exi('该域名不合法。','error');	
	}
	if($data['domain']==DOMAIN){
		exi('该域名为系统主域名，不能绑定为个性域名，请更换！','error');
	}
	$id=intval($postdata['id']);
	if($id){
		$check=pdo_get('core_domain',array('id <>'=>$id,'domain'=>$data['domain']),'id');
		if($check){
			exi('该域名已被使用，请更换！','error');
		}
		pdo_update('core_domain',$data,array('uniacid'=>$_SESSION['uniacid'],'id'=>$id));
		exi('域名绑定修改成功！','','more');
	}else{
		$check=pdo_get('core_domain',array('domain'=>$data['domain']),'id');
		if($check){
			exi('该域名已被使用，请更换！','error');
		}
		$data['uniacid']=$_SESSION['uniacid'];
		$data['createtime']=TIMESTAMP;
		pdo_insert('core_domain',$data);
		exi('域名绑定增加成功！','','more');
	}
}
if($_RQ['op']=='help'){
	$return['item']['image1']='../core/resource/images/help-sys-web.jpg';
	$return['htmls']=array(
			'type'=>'look',
			'desc'=>'独立域名解释',
			'look'=>array(
				array('type'=>'tip','title'=>'【温馨提示】：这个独立域名绑定的是个人站点的官网（手机/PC），非本程序平台网站。个人域名为空，则使用系统域名，填写域名后，需要将本域名解析到{{pagedata.ip ||"xxx.xxx.xxx.xxx"}}，然后联系系统管理员协助处理方能生效。'),
				array('type'=>'help','title'=>'一、什么叫个人站点的官网：','help'=>'
					1、比如我在某建站运营商平台的注册了一个用户账号；</br>
					2、我登录上面“建站运营商平台”后台，进入站点管理系统，搭建了一个站点的官网--苹果网；</br>
					3、然后在这个站点管理系统，我添加一些内容（比如：新闻，网站名称，商城等），来丰富我的《苹果网》；</br>
					4、最后，我绑定一个独立域名，这个独立域名解析指向的就是《苹果网》；</br>
					5、我只需分享这个绑定的域名给我的客户，客户就能直接访问我的《苹果网》。</br>
					6、你绑定的独立域名，是面向访问《苹果网》的，只有《苹果网》注册的用户（比如：微信粉丝）才能正常登录。</br>
					7、【注意】：这个独立域名，是不能用做：《建站运营商平台》的注册的账号来登录的，否则肯定找不到用户。</br>
				'),
				array('type'=>'help','title'=>'二、什么叫本程序平台：','help'=>'
					1、本程序平台，其实就是上面这个“建站运营商平台”；</br>
					2、您在本程序平台，注册一个账号，就等于拥有一个《网站》；</br>
					3、如果你要登录您上面注册的账号，管理你的《苹果网》，你只能用我们平台的域名登录才行；</br>
				'),
				array('type'=>'help','title'=>'三、如果这个域名我只想访问平台，不想访问个人站点：','help'=>'
					1、很简单，只要不添加独立域名就行！（不添加独立域名的，默认访问的是平台，一旦添加了独立域名，访问的就是站点）；</br>
				'),
				array('type'=>'help','title'=>'四、平台-站点关系图如下：','help'=>'
				'),
				array('type'=>'image','title'=>'','name'=>'image1')
			),
	);
	exi($return);
}