<?php
/*
	数据库备份还原
	备份方法：
		分批导出数据，生成插入sql，将相应代码存入sql
		每个文件保存数据最多10M，超出则导入下一个文件
		逐表获取数据，每次获取500条数据
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$back_dir=ROOT_AT.'backup/';
if(!is_dir($back_dir)){
	mkdir($back_dir);
}
if(!function_exists('scandir')){
	exi('请开启scandir函数支持！','error','goback');
}
$tabs=array(
	array('op'=>'list','title'=>'数据库备份列表'),
	array('op'=>'add','title'=>'创建数据库备份'),
	array('op'=>'repair','title'=>'优化数据表'),
	array('op'=>'rundb','title'=>'运行数据库'),
);
set_html('tabs',$tabs);
if($_RQ['op']=='list'){
	$backs=scandir($back_dir);
	$list=array();
	foreach($backs as $key=>$value){
		if($value=='.' || $value=='..'){
			continue;
		}
		$suns=scandir($back_dir.$value);
		
		$list[]=array(
			'time'=>$value,
			'name'=>$value,
			'volume'=>count($suns)-2,
		);
		
	}
	paixu($list,'name','desc');
	$return['list']=$list;
	$return['htmls']=array(
		'type'=>'list',
		'list'=>array('data'=>'list','delall'=>false,'del_one'=>false,'edit'=>false,'key'=>'name','list'=>array(
			array('type'=>'string','title'=>'备份名称','name'=>'name'),
			array('type'=>'time','title'=>'备份时间','name'=>'time'),
			array('type'=>'string','title'=>'分卷数量','name'=>'volume'),
			
		),'action'=>array(
			array('type'=>'post','op'=>'down','title'=>'下载此备份'),
			array('type'=>'post','op'=>'back','message'=>'确定还原此备份？还原后将覆盖当前所有数据，请谨慎操作！','title'=>'还原此备份'),
			array('type'=>'post','op'=>'del','message'=>'确定删除此备份？删除后将无法找回！','title'=>'删除此备份'),
		)),
	);
	exi($return);
}
if($_RQ['op']=='down'){
	$url=download_url('core/system.db/download/name='.$_RQ['name']);
	exi('','',$url);
}
if($_RQ['op']=='download'){
	//下载备份
	$name=trim($_RQ['name']);
	if(!$name){
		exi('请先选择要下载的备份','error');
	}
	$dir=$back_dir.$name;
	if(!is_dir($dir)){
		exi('指定备份不存在或已被下载！','error');
	}
	do{
		$zip=ROOT_AT.random(10).'.temp';
	}while(is_file($zip));
	cfc('files')->zip($dir,$zip);
	header('content-type: application/zip');
	header('content-disposition: attachment; filename="' . $name . '.zip"');
	readfile($zip);
	@unlink($zip);
	exit();
}
if($_RQ['op']=='back'){
	exi('备份恢复功能优化中！','error');
	//恢复备份，逐个获取备份sql执行之
	set_time_limit(0);
	$name=trim($_RQ['name']);
	if(!$name){
		exi('请先选择要恢复的备份','error');
	}
	if(!is_dir($back_dir.$name)){
		exi('指定备份不存在！','error');
	}
	$part=0;
	do{
		$back_file=$back_dir.$name.'/volume-'.$part.'.sql';
		if(!is_file($back_file)){
			break;
		}
		$sql=file_get_contents($back_file);
		$sql=explode("\n\n\n\n\n",$sql);
		foreach($sql as $row){
			pdo_query($row);
		}
		$part++;
	}while(true);
	exi('备份恢复成功！');
}
if($_RQ['op']=='del'){
	$name=trim($_RQ['name']);
	if(!$name){
		exi('请先选择要删除的备份','error');
	}
	if(!is_dir($back_dir.$name)){
		exi('指定备份不存在或已被删除！','error');
	}
	cfc('files')->rmdirs($back_dir.$name);
	exi('删除成功！');
}
if($_RQ['op']=='add'){
	//创建备份
	$tables=pdo_fetchall("SHOW TABLES LIKE '".TABLE_PRE."%'");
	$list=array();
	foreach($tables as $table){
		$tablename=array_shift($table);
		$name=explode('_',$tablename,2);
		$list[]=$name['1'];
	}
	$return['list']=$list;
	$return['total']=count($list);
	$return['backed']=0;
	$return['part']=0;
	$return['back']=TIMESTAMP;
	exi($return);
}
if($_RQ['op']=='add_table'){
	$post=get_postdata();
	$name=trim($post['name']);
	if(!$name){
		exi('error tablename','error');
	}
	if(intval($post['key'])==0){
		mkdir($back_dir.$post['back']);
		$system=core_setting('system');
		$system['backsqldata']=$post['back'];
		core_setting('system',$system);
	}
	$part=intval($post['part']);
	$back=trim($post['back']);
	$back_file=$back_dir.$back.'/volume-'.$part.'.sql';
	$max_size=10*1024*1024;//每个分卷最大限制为10M
	if($name=='core_access_log'){
		//访问日志表内容过多，此处不做处理
		exi($part);
	}
	$tablename=TABLE_PRE.$name;
	$sql="--\n-- 表的结构 `{$tablename}`\n--\n\n";
	$sql.="DROP TABLE IF EXISTS `{$tablename}`;\n";
	$create_sql=pdo_fetch('show create table '.$tablename);
	$create_sql=$create_sql['Create Table'];
	$sql.=$create_sql.";\n";
	file_put_contents($back_file,$sql,FILE_APPEND);
	$total=pdo_count($name);
	$psize=500;
	
	$pages=ceil($total/$psize);
	for($i=1;$i<=$pages;$i++){
		//检查当前分卷内容是否超出
		clearstatcache();
		$size=filesize($back_file);
		if($size>=$max_size){
			$part++;
			$back_file=$back_dir.$back.'/volume-'.$part.'.sql';
		}
		$sql="--\n-- 表的数据 `{$tablename}`\n--\n\n";
		$params=array(
			'limit'=>array($i,$psize),
		);
		$data=pdo_getlist($name,$params);
		if($data){
			$sql.="INSERT INTO {$tablename} VALUES \n";
			foreach($data as &$value){
				$value=array_values($value);
				foreach($value as &$v){
					$v=str_replace(array( "\0", "\n", "\r", "'","\x1a"), array( '\\0', '\\n', '\\r', "\\'", '\\Z'), $v);
				}
				$value="('".implode("','",$value)."')";
			}
			$sql.=implode(",\n",$data).";\n\n\n\n\n";
		}
		file_put_contents($back_file,$sql,FILE_APPEND);
	}
	exi($part);
}
if($_RQ['op']=='repair'){
	$repair_table = array();
	$sql = "SHOW TABLE STATUS LIKE '".TABLE_PRE."%'";
	$tablelist = pdo_fetchall($sql);
	if($tablelist){
			foreach ($tablelist as $tableinfo) {
				if ($tableinfo['Engine'] == 'InnoDB') {
					continue;
				}
				if($tableinfo['Name']=='ims_core_session' && $tableinfo['Engine'] != 'InnoDB'){
					$updb = "ALTER TABLE ims_core_session ENGINE=InnoDB";
					pdo_fetch($updb);
				}
				if (!empty($tableinfo) && !empty($tableinfo['Data_free'])) {
					$row = array(
						'id' => $tableinfo['Name'],
						'type' => $tableinfo['Engine'],
						'rows' => $tableinfo['Rows'],
						'size' => fun_size($tableinfo['Data_length']),
						'index' => fun_size($tableinfo['Index_length']),
						'free' => fun_size($tableinfo['Data_free'])
					);
					$repair_table[$row['id']] = $row;
				}
			}
	}
	$return['list']=$repair_table;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('data'=>'list','edit'=>false,'del_one'=>false,'delall'=>false,'list'=>array(
			array('name'=>'id','title'=>'表名','type'=>'string'),
			array('name'=>'size','title'=>'大小','type'=>'string'),
			array('name'=>'type','title'=>'类型','type'=>'string'),
		),'action'=>array(
			array('type'=>'post','op'=>'post_repair','title'=>'修复'),
		),'batch'=>array(
			array('type'=>'post','url'=>'post_repair','title'=>'一键修复'),
		)
		),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='post_repair'){
	if($_RQ['ids']){
		$table=str_array($_RQ['ids']);
	}else{
		$table=array();
	}
	if($_RQ['id']){
		$table[]=$_RQ['id'];
	}
	if(!$table){
		exi('请先选择要修复的表！','error');
	}
	foreach ($table as $tablename) {
			$sql = "OPTIMIZE TABLE {$tablename}";
			pdo_fetch($sql);
	}
	exi('修复成功！');
}
if ($_RQ['op'] == 'rundb') {
	if (DEVELOP!=1) {
		exi('请先开启开发模式后再使用此功能','error');
	}
	if($_RQ['postdata']){
		$post=get_postdata();
		$sql = $post['sql'];
		pdo_run($sql);
		exi('查询执行成功.', 'success');
	}
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'desc'=>'运行数据库语句',
		'edit'=>array(
			array('type'=>'text','name'=>'sql','title'=>'数据库语句','help'=>'通过此功能可以直接在数据库中执行特定语句, 或用于调试错误；注意, 这里运行的语句不会有任何返回结果。</br>注意: 此功能可能造成数据破坏, 请谨慎使用. 如果你不清楚他的功能, 请不要使用!'),
		),
	);
	exi($return);
}