<?php
/*
	头条系小程序
	两种小程序
		打包小程序	1
		应用小程序	2
		点击上传代码时，即对接云平台整理小程序文件提供下载
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('op'=>'list','title'=>'小程序列表'),
	array('op'=>'add','title'=>'创建小程序'),
);
set_html('tabs',$tabs);
if($_RQ['op']=='list'){
	//小程序列表，此处显示除多页小程序以外的小程序
	$type=intval($_RQ['type']);
	if($type){
		$_SESSION['ttapp_type']=$type;
	}
	$params=array('uniacid'=>$_SESSION['uniacid'],'type'=>$_SESSION['ttapp_type']);
	if($_RQ['title']){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=trim($_RQ['title']);
	}
	$fields=array();
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$list=pdo_getslice('core_account_ttapp',$params,array($pindex,$psize),$total,$fields,'','id desc');
	$return['list']=$list?:array();
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'list'=>array('psize'=>$psize,'total'=>$total,'data'=>'list','list'=>array(
			array('type'=>'string','title'=>'小程序id','name'=>'id'),
			array('type'=>'string','title'=>'小程序名称','name'=>'title'),
			//array('type'=>'modal','title'=>'支付设置','op'=>'pay'),
			array('type'=>'href','op'=>'style','title'=>'样式设置'),
			array('type'=>'href','op'=>'version_list','title'=>'版本列表'),
		),'action'=>array(
			array('type'=>'href','op'=>'add_version','title'=>'生成新版本'),
		)),
		'search'=>array(
			array('type'=>'string','title'=>'小程序名称','name'=>'title','width'=>'50'),
		),
	);
	$return['htmls']=$htmls;
	set_html('title','头条系小程序');
	exi($return);
}
if($_RQ['op']=='edit'){
	//编辑
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择小程序！','error');
	}
	$item=pdo_get('core_account_ttapp',array('id'=>$id));
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'post'=>'post',
		'edit'=>array(
			array('type'=>'string','name'=>'title','title'=>'小程序名称'),
			array('type'=>'string','name'=>'appid','title'=>'小程序appid'),
			array('type'=>'string','name'=>'appsecret','title'=>'小程序APPsecret'),
			array('type'=>'link','show'=>array('type'=>1),'name'=>'url','title'=>'打包URL','help'=>'可以手写，也可选择；注意，URL中的域名需在小程序后台授权（业务域名授权）'),
			array('type'=>'select','show'=>array('type'=>2),'name'=>'ttapp_id','title'=>'选择小程序','options'=>'ttapp_list','help'=>'需要安装了相应的头条/抖音小程序'),
		),
	);
	exi($return);
}
if($_RQ['op']=='add'){
	//添加
	$item=array('type'=>$_SESSION['ttapp_type']);
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'post'=>'post',
		'edit'=>array(
			array('type'=>'string','name'=>'title','title'=>'小程序名称'),
			array('type'=>'string','name'=>'appid','title'=>'小程序appid'),
			array('type'=>'string','name'=>'appsecret','title'=>'小程序APPsecret'),
			array('type'=>'link','show'=>array('type'=>1),'name'=>'url','title'=>'打包URL','help'=>'可以手写，也可选择；注意，URL中的域名需在小程序后台授权（业务域名授权）'),
			array('type'=>'select','show'=>array('type'=>2),'name'=>'ttapp_id','title'=>'选择小程序','options'=>'ttapp_list','help'=>'需要安装了相应的头条/抖音小程序'),
		),
	);
	$return['ttapp_list']=array();
	exi($return);
}
if($_RQ['op']=='post'){
	//提交数据
	$post=get_postdata();
	$id=intval($post['id']);
	$data=array(
		'title'=>trim($post['title']),
		'appid'=>trim($post['appid']),
		'appsecret'=>trim($post['appsecret']),
		'url'=>trim($post['url']),
		'ttapp_id'=>intval($post['ttapp_id']),
	);
	if($id){
		pdo_update('core_account_ttapp',$data,array('id'=>$id));
	}else{
		$insert=array(
			'uniacid'=>$_SESSION['uniacid'],
			'type'=>intval($post['type']),
			'createtime'=>TIMESAMP,
		);
		$data=array_merge($insert,$data);
		pdo_insert('core_account_ttapp',$data);
	}
	exi('操作成功！','','goback');
}
if($_RQ['op']=='style'){
	//样式设置
	if($_RQ['postdata']){
		$post=get_postdata();
		$data=array_fields(array('logo','sharetitle','sharedesc','shareimg'),$post);
		$data['window']=$post['window']?ijson_encode($post['window']):'';
		$appid=intval($post['appid']);
		$check=pdo_getcolumn('core_account_ttapp_style',array('appid'=>$appid),'id');
		if($check){
			pdo_update('core_account_ttapp_style',$data,array('appid'=>$appid));
		}else{
			$data['appid']=$appid;
			$data['uniacid']=$_SESSION['uniacid'];
			pdo_insert('core_account_ttapp_style',$data);
		}
		
		exi('设置成功！','','goback');
	}
	$appid=intval($_RQ['id']);
	if(!$appid){
		exi('请先选择小程序！','error');
	}
	$item=pdo_get('core_account_ttapp_style',array('appid'=>$appid));
	$item['appid']=$item['appid']?:$appid;
	$item['window']=$item['window']?json_decode($item['window'],true):array();
	$return['item']=$item;
	$return['htmls']=array(
			'type'=>'edit',
			'edit_tab'=>true,
			'edits'=>array(
					array(
					'title'=>'基本信息','list'=>array(
						array('type'=>'image','name'=>'logo','title'=>'小程序LOGO','help'=>'小程序LOGO'),
						array('type'=>'string','name'=>'sharetitle','title'=>'小程序分享标题','help'=>'小程序分享标题'),
						array('type'=>'string','name'=>'sharedesc','title'=>'小程序分享描述','help'=>'小程序首页分享描述'),
						array('type'=>'image','name'=>'shareimg','title'=>'小程序分享图片','help'=>'小程序首页分享图片自定义，留空则默认截屏分享！'),
					),),
					array(
						'title'=>'顶部导航设置',
						'tovalue'=>'window',
						'list'=>array(
							array('type'=>'radio','name'=>'navigationStyle','title'=>'是否关闭顶部导航','options'=>'navigationStyles','option_value'=>'dtitle','help'=>'导航栏样式，仅支持以下值：default 默认样式custom 自定义导航栏，只保留右上角胶囊按钮'),
							array('type'=>'color','name'=>'navigationBarBackgroundColor','title'=>'导航栏背景色','help'=>'小程序顶部背景色'),
							array('type'=>'radio','name'=>'navigationBarTextStyle','title'=>'导航栏标题颜色','options'=>'navigationBarTextStyles','option_value'=>'dtitle'),
							array('type'=>'string','name'=>'navigationBarTitleText','title'=>'导航栏标题','help'=>'导航栏标题文字内容！留空这使用小程序名称'),
						),
					),
					/*array(
						'title'=>'底部导航设置','list'=>array(
							array('type'=>'color','name'=>'setting.footer.color','title'=>'文字默认颜色','help'=>'默认黑色'),
							array('type'=>'color','name'=>'setting.footer.selectedColor','title'=>'选中时的颜色','help'=>'默认绿色'),
							array('type'=>'color','name'=>'setting.footer.backgroundColor','title'=>'导航的背景色','help'=>'默认白色'),
							array('type'=>'radio','name'=>'setting.footer.borderStyle','title'=>'边框的颜色','options'=>'borderStyles','option_value'=>'dtitle','help'=>'tabbar上边框的颜色， 仅支持 black / white'),
							array('type'=>'radio','name'=>'setting.footer.position','title'=>'TabBar的位置','options'=>'positions','option_value'=>'dtitle','help'=>'选择top的话，底部就不显示图片了，tabBar的位置，仅支持 bottom / top'),
							array(
								'type'=>'array',
								'name'=>'menus',
								'tovalue'=>'pagedata.item.setting.footer',
								//'show'=>array('istabbar'=>1),
								'add_tip'=>'添加一个底部导航',
									'list'=>array(
												array('type'=>'string','name'=>'title','title'=>'菜单名称'),
												array('type'=>'icon','name'=>'icon','title'=>'默认图标'),
												array('type'=>'string','name'=>'url','title'=>'菜单链接'),
									),
									'details'=>array(
												array('type'=>'string','name'=>'title','title'=>'菜单名称'),
												array('type'=>'icon','name'=>'icon','title'=>'默认图标'),
												array('type'=>'link','name'=>'url','title'=>'菜单链接'),
												
									)
							),
						),
					),*/
					array(
						'title'=>'窗口样式设置','tovalue'=>'window','list'=>array(
							array('type'=>'color','name'=>'backgroundColor','title'=>'窗口的背景色','help'=>'默认白色，大部分不用填写！'),
							array('type'=>'radio','name'=>'backgroundTextStyle','title'=>'窗口的背景色','options'=>'backgroundTextStyles','option_value'=>'dtitle'),
							array('type'=>'color','name'=>'backgroundColorTop','title'=>'顶部窗口的背景色','help'=>'顶部窗口的背景色，仅 iOS 支持,微信版本 6.5.16'),
							array('type'=>'color','name'=>'backgroundColorBottom','title'=>'底部窗口的背景色','help'=>'顶部窗口的背景色，仅 iOS 支持,微信版本 6.5.16'),
						),
					),
				)
		);
	$return['navigationBarTextStyles'] =array('white'=>'white','black'=>'black');
	$return['backgroundTextStyles'] =array('dark'=>'dark','light'=>'light');
	$return['borderStyles'] =array('white'=>'white','black'=>'black');
	$return['positions'] =array('bottom'=>'bottom','top'=>'top');
	$return['navigationStyles'] =array('default'=>'default','custom'=>'custom');
	exi($return);
}
if($_RQ['op']=='add_version'){
	//添加版本
	//判断上传权限
	$no_upwxapp=pdo_getcolumn('core_account_group',array('id'=>$_SESSION['account']['groupid']),'no_upwxapp');
	if($no_upwxapp){
		exi('您当前的会员套餐，不允许发布小程序！','','goback');	
	}
	$app_id=intval($_RQ['id']);
		$item=pdo_get('core_account_ttapp',array('id'=>$app_id));
		if(!$item){
			exi('指定小程序不存在！','error');
		}
		$item_style=pdo_get('core_account_ttapp_style',array('appid'=>$app_id));
		$params=array(
			'appid'=>$item['appid'],
			'type'=>$item['type'],
			'title'=>$item['title'],
			'logo'=>tomedia($item_style['logo']),
			'textcolor'=>$item_style['textcolor'],
			'bgcolor'=>$item_style['bgcolor'],
			'siteroot'=>get_account_url(),
			'uniacid'=>$_SESSION['uniacid'],
			'app_id'=>$item['id'],
			'att_url'=>ATTACHMENT_URL,
			'items'=>$item['items'],
			'setting'=>$item['setting'],
			'url'=>$item['url'],
			'version'=>$post['version'],
			'remark'=>$post['remark'],
		);

		/*$local_blocks=pdo_getall('core_mobile_blocks',array('madebaiduapp <>'=>''),array('cloud_id','default','madebaiduapp'),'cloud_id');
		if($local_blocks){
			foreach($local_blocks as &$row){
				$row['madebaiduapp']=cfc('files')->source_read($row['madebaiduapp']);
				$row['default']=$row['default']?json_decode($row['default'],true):array();
			}
		}*/
		$post=array('params'=>base64_encode(ijson_encode($params)));
		$res=cloud_request('wxapp.tt_release.new',$post);
		exi('打包成功,请下载发布！','','/ttapp.list/version_list/id='.$app_id);
}
if($_RQ['op']=='version_list'){
	//版本列表，显示指定小程序的版本
	$app_id=intval($_RQ['id']);
	$params=array(
		'app_id'=>$app_id,
	);
	if($_RQ['page']){
		$params['page']=intval($_RQ['page']);
	}
	$return=cloud_request('wxapp.ttapp_up.list',$params);
	$return['htmls']=array(
		'type'=>'list',
		'list'=>array('tip'=>'下载小程序，然后用小程序发布工具，上传发布小程序即可！','delall'=>false,'del_one'=>false,'edit'=>false,'pagelist'=>false,'data'=>'list','list'=>array(
			array('type'=>'string','title'=>'生成任务ID','name'=>'id'),
			array('type'=>'string','title'=>'小程序名称','name'=>'title'),
			array('type'=>'time','title'=>'版本生成时间','name'=>'createtime'),
		),'action'=>array(
			array('type'=>'open','url'=>'zipfile','title'=>'下载'),
		)),
	);
	exi($return);
}
if($_RQ['op']=='del'){
	//删除小程序
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_account_ttapp',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_account_ttapp',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			}
		}
	}
	exi('删除成功！');
}