<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	二维码管理（对接公众平台生成的带参数二维码）
	
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
if($_RQ['op']=='list'){
	$return['params']=$params=array();
	$params['uniacid']=$_SESSION['uniacid'];
	if(!empty($_RQ['plugin_name'])){
		$params['plugin']=trim($_RQ['plugin_name']);
		$return['params']['plugin_name']=$_RQ['plugin_name'];
	}
	if($_RQ['title']){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	$orderby=array();
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','linkurl','url','type','qrtype','num','plugin','title','file','expire','createtime');
	$list=pdo_getslice('core_qr',$params,array($pindex,$psize),$total,$fields,'','id desc');
	foreach($list as &$item){
		$item['ewmurl']=$item['qrtype']==1?$item['linkurl']:$item['url'];
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$return['types']=get_qr_types();
	$return['plugins']=pdo_getall('core_plugins',array(),array('name','title'),'name');
	$htmls=array(
		'type'=>'list',
		'tabs'=>array(
			array('op'=>'list','title'=>'二维码列表'),
			array('op'=>'edit','title'=>'创建二维码'),
		),
		'list'=>array('data'=>'list','tip'=>'二维码总数：'.$total,'list'=>array(
			array('name'=>'title','title'=>'二维码名称','type'=>'string'),
			array('name'=>'qrtype','title'=>'二维码类型','type'=>'radio','options'=>'qrtypes'),
			array('name'=>'plugin','title'=>'所属插件','type'=>'select','options'=>'plugins'),
			array('name'=>'num','title'=>'被扫描次数','type'=>'string'),
			array('name'=>'ewmurl','title'=>'二维码','type'=>'ewm'),
			array('name'=>'createtime','title'=>'生成时间','type'=>'time'),
			array('name'=>'expire','title'=>'有效期至','type'=>'time'),
		),'action'=>array(
			//array('type'=>'href','op'=>'look','title'=>'查看'),
		)),
		'search_one'=>array('name'=>'title','add'=>false,'select'=>true,'select_name'=>'plugin_name','select_title'=>'请选择所属插件','options'=>'plugins'),
	);
	$return['qrtypes']=array('微信二维码','普通二维码');
	$return['htmls']=$htmls;
	//$cs=var_export($return['params'],true);
	//exi($cs,'error');
	exi($return);
}
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('core_qr',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}else{
		$item=array('qrtype'=>'1','type'=>'0');
	}
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'desc'=>'添加二维码',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'回到二维码列表'),
		),
		'edit'=>array(
			array('name'=>'title','title'=>'二维码名称','type'=>'string'),
			array('name'=>'qrtype','title'=>'生成二维码方法','type'=>'radio','options'=>'qrtypes','help'=>'1、普通二维码：就是链接转二维码；2、微信二维码：适用于扫码事件触发，比如：关注事件，扫码自动回复，扫码进入客服等等'),
			array('name'=>'linkurl','title'=>'二维码URL','type'=>'string','show'=>array('qrtype'=>1),'help'=>'输入http或https开头的完整url'),
			array('name'=>'linkurl','title'=>'链接二维码','type'=>'ewm','show'=>array('qrtype'=>1),'help'=>'保存后，才生成，可见！'),
			array('name'=>'shorturl','title'=>'短链接','type'=>'copy','show'=>array('qrtype'=>1),'help'=>'保存后，才生成，可见！<red>[温馨提示]：如果短链接没生成，有可能微信公众号不支持（比如：公众号参数错误，公众号不是认证服务号）</red>'),
			array('name'=>'type','title'=>'二维码类型','type'=>'radio','options'=>'types','show'=>array('qrtype'=>0),'help'=>'临时二维码，微信那边会过期失效！'),
			array('name'=>'eventtype','title'=>'微信扫码事件','type'=>'radio','options'=>'eventtypes','show'=>array('qrtype'=>0),'help'=>'选择不同的二维码触发事件！'),
			array('type'=>'choose','title'=>'选择回复事件','name'=>'backid','action'=>'core/wechat.back/get_back/','show'=>array('eventtype'=>2),'choose_title'=>'选择'),
			array('name'=>'url','title'=>'微信二维码','type'=>'ewm','show'=>array('qrtype'=>0),'help'=>'保存后，才生成，可见！'),
			array('name'=>'plugin','title'=>'所属插件','type'=>'select','options'=>'plugins','option_value'=>'name'),
			//array('name'=>'expire','title'=>'有效期至','type'=>'time','show'=>array('type'=>'1')),
		),
	);
	$return['types']=get_qr_types();
	$return['qrtypes']=array('微信二维码','普通二维码');
	$return['eventtypes']=array('1'=>'扫码关注','2'=>'触发关键词','3'=>'进入客服');
	$return['plugins']=pdo_getall('core_plugins',array(),array('name','title'),'name');
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	$preg = "/^http(s)?:\\/\\/.+/";
	if($postdata['qrtype']==1 && !(preg_match($preg,$postdata['linkurl']))){
		exi('二维码URL:必须是https://或http://开头。','error');	
	}
	if($postdata['qrtype']==0 && !$postdata['type']){
		exi('请选择二维码类型','error');
	}
	if($postdata['eventtype']==2 && !$postdata['backid']){
		exi('请选择回复事件','error');
	}
	$id=intval($postdata['id']);
	$data=array(
		'title'=>trim($postdata['title']),
		'linkurl'=>trim($postdata['linkurl']),
		'qrtype'=>intval($postdata['qrtype']),
		'type'=>intval($postdata['type']),
		'eventtype'=>intval($postdata['eventtype']),
		'plugin'=>trim($postdata['plugin']),
		'backid'=>intval($postdata['backid']),
	);
	//微信二维码
	if($data['qrtype']!=1){
		if($data['eventtype']==1){
			$getqrdata=array(
					'scantype'=>'follow',
			);
		}elseif($data['eventtype']==2){
			$getqrdata=array(
					'scantype'=>'back',
			);
		}elseif($data['eventtype']==3){
			$getqrdata=array(
					'scantype'=>'kefu',
			);
		}
		$getqrdata = ijson_encode($getqrdata);
		$res=model('core/account')->get_qr($data['type'],$data['plugin'],$getqrdata,$data['title'],'','',$id);
		if(!$res['id']){
			exi('创建微信二维码失败！请检测微信公众号参数','error');
		}else{
			$update=array(
				'qrtype'=>$data['qrtype'],
				'eventtype'=>$data['eventtype'],
				'backid'=>$data['backid'],
			);
			pdo_update('core_qr',$update,array('id'=>$res['id']));
		}
	}else{
		//shorturl
		$data['shorturl']=model('core/account')->url_short($data['linkurl'],true);
		if($id){
			pdo_update('core_qr',$data,array('id'=>$id));
		}else{
			$data['uniacid']=$_SESSION['uniacid'];
			$data['createtime']=TIMESTAMP;
			pdo_insert('core_qr',$data);
		}
	}
	exi('操作成功！','','core/wechat.qr/list/');
}
if($_RQ['op']=='look'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要查看的二维码','error');
	}
	$item=pdo_get('core_qr',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']),array('title','file'));
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'look',
		'desc'=>'查看二维码',
		'tabs'=>array(
			array('op'=>'list','title'=>'回到二维码列表'),
		),
		'look'=>array(
			array('type'=>'string','name'=>'title','title'=>'二维码名称'),
			array('type'=>'image','name'=>'file','title'=>'二维码'),
		),
	);
	exi($return);
}
if($_RQ['op']=='del'){
	$id=intval($_RQ['id']);
	if($id){
		pdo_delete('core_qr',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
		foreach($del as $id){
			$id=intval($id);
			if($id){
				pdo_delete('core_qr',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			}
		}
	}
	exi('删除成功！');
}