<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 *公告管理
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$tabs=array(
	array('op'=>'list','title'=>'门店列表'),
	array('op'=>'add','title'=>'添加门店'),
	array('op'=>'upwechat','title'=>'同步微信门店'),	
);
$install = check_permission('jy_weishop');
if(!$install){
	exi('还未安装商城系插件！无法使用门店！','error');
}
if($_RQ['op']=='list'){
	$params=array();
	$params['uniacid']=$_SESSION['uniacid'];
	if(!empty($_RQ['title'])){
		$params['title like']='%'.trim($_RQ['title']).'%';
		$return['params']['title']=$_RQ['title'];
	}
	
	$pindex = max(1, intval($_RQ['page']));
	$psize = 10;
	$total='';
	$fields=array('id','uniacid','title','address','status','tel','pcd','logo');
	$list=pdo_getslice('jy_weishop_store',$params,array($pindex,$psize),$total,$fields,'','id desc');
	if($list){
		foreach($list as &$item){
				$item['pcd']=json_decode($item['pcd'],true);
				$item['url']=custom_url('jy_weishop/store.detail//id='.$item['id'],true);
				$item['address']=$item['pcd']['province'].' '.$item['pcd']['city'].' '.$item['pcd']['district'].' '.$item['pcd']['street'].' '.$item['address'];
			}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'tabs'=>$tabs,
		'list'=>array('tip'=>'温馨提示：开启核销或者设置-->商品详情设置-->开启门店显示，商品详情页才会显示门店，默认显示最近的一个！','data'=>'list','edit'=>true,'list'=>array(
			array('name'=>'title','title'=>'门店名称','type'=>'string'),
			array('name'=>'logo','title'=>'门店logo','type'=>'image'),
			array('name'=>'url','title'=>'门店二维码','type'=>'ewm'),
			array('name'=>'url','title'=>'门店链接','type'=>'copy'),
			array('name'=>'tel','title'=>'电话','type'=>'string'),
			array('name'=>'address','title'=>'地址','type'=>'string'),
			array('name'=>'status','title'=>'状态','type'=>'switch','set'=>'set'),
			array('type'=>'href','action'=>'/coupon.wxcard//id=','title'=>'微信卡券列表'),
			array('type'=>'modal','op'=>'wifi','title'=>'WIFI列表'),
			array('type'=>'href','action'=>'store.cards/','title'=>'投放卡券列表'),
		),'action'=>array(
			array('type'=>'modal','op'=>'addwifi','title'=>'添加WIFI'),
		)),
		'search_one'=>array('name'=>'title'),
	);
	$return['htmls']=$htmls;
	
	exi($return);
}
if($_RQ['op']=='add'){
	$return=array();
	$item=array();
	$item['out_juli']=$item['out_juli']?:3;
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回门店列表'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array(
				'title'=>'基本信息',
				'list'=>array(
					array('name'=>'title','title'=>'门店名称','type'=>'string','must'=>true),
					array('name'=>'logo','title'=>'logo','type'=>'image'),
					array('name'=>'pcd','title'=>'地区','type'=>'pcd'),
					array('name'=>'lat_lng','title'=>'坐标','type'=>'lat_lng','must'=>true),
					array('name'=>'address','title'=>'地址','type'=>'string'),
					array('name'=>'tel','title'=>'电话','type'=>'string'),
					array('name'=>'type','title'=>'是否支持自提','type'=>'switch'),
					array('name'=>'realname','title'=>'自提联系人','type'=>'string'),
					array('name'=>'mobile','title'=>'自提联系电话','type'=>'string'),
					array('name'=>'onlinetime','title'=>'营业时间','type'=>'time_hour'),
					array('name'=>'recommend','title'=>'推荐品','type'=>'text','help'=>'餐厅可为推荐菜；酒店为推荐套房；景点为推荐游玩景点等，针对自己行业的推荐内容 200字以内'),
					array('name'=>'special','title'=>'特色服务','type'=>'string','help'=>'如免费wifi，免费停车，送货上门等商户能提供的特色功能或服务'),
					array('name'=>'avg_price','title'=>'人均价格','type'=>'string'),
					array('name'=>'out_pay','title'=>'跑腿费用','type'=>'string','help'=>'非快递，周边直接配送的费用！'),
					array('name'=>'out_juli','title'=>'跑腿范围','unit'=>'公里','type'=>'unitstring','help'=>'按收货地址为准，非快递，配送的范围！(单位公里)'),
					array('name'=>'businessimg','title'=>'营业执照','type'=>'image'),
					array('name'=>'licenseimg','title'=>'许可证','type'=>'image'),
					array('type'=>'array','title'=>'门店照片','name'=>'hdps','add_tip'=>'添加一个幻灯片',
						'list'=>array(
							array('type'=>'image','name'=>'image','title'=>'幻灯片'),	
							array('type'=>'string','name'=>'url','title'=>'幻灯片url'),	
						),
						'details'=>array(
							array('type'=>'image','name'=>'image','title'=>'幻灯片'),	
							array('type'=>'link','from'=>'action','name'=>'url','title'=>'幻灯片url'),
						)
					),
					array('name'=>'desc','title'=>'门店简介','type'=>'text'),
					array('name'=>'paixu','title'=>'排序','type'=>'string'),
					array('name'=>'status','title'=>'状态','type'=>'radio','options'=>'status'),
				)
			),
		)
	);
	$return['status']=array('0'=>'关闭','1'=>'开启');
	$return['htmls']=$htmls;
	
	exi($return);
}
if($_RQ['op']=='edit'){
	$return=array();
	$id=intval($_RQ['id']);
	if($id){
		$item=pdo_get('jy_weishop_store',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		$item['pcd']=json_decode($item['pcd'],true);
		$item['onlinetime']=json_decode($item['onlinetime'],true);
		$item['hdps']=json_decode($item['hdps'],true);
		$item['lat_lng']=json_decode($item['lat_lng'],true);
	}else{
		$item=array();
		$item['out_juli']=$item['out_juli']?:3;
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>'post',
		'tabs'=>array(
			array('op'=>'list','title'=>'返回门店列表'),
		),
		'edit_tab'=>true,
		'edits'=>array(
			array(
				'title'=>'基本信息',
				'list'=>array(
					array('name'=>'title','title'=>'门店名称','type'=>'string','must'=>true),
					array('name'=>'logo','title'=>'logo','type'=>'image'),
					array('name'=>'pcd','title'=>'地区','type'=>'pcd'),
					array('name'=>'lat_lng','title'=>'坐标','type'=>'lat_lng','must'=>true),
					array('name'=>'address','title'=>'地址','type'=>'string'),
					array('name'=>'tel','title'=>'电话','type'=>'string'),
					array('name'=>'type','title'=>'是否支持自提','type'=>'switch'),
					array('name'=>'realname','title'=>'自提联系人','type'=>'string'),
					array('name'=>'mobile','title'=>'自提联系电话','type'=>'string'),
					array('name'=>'onlinetime','title'=>'营业时间','type'=>'time_hour'),
					array('name'=>'recommend','title'=>'推荐品','type'=>'text','help'=>'餐厅可为推荐菜；酒店为推荐套房；景点为推荐游玩景点等，针对自己行业的推荐内容 200字以内'),
					array('name'=>'special','title'=>'特色服务','type'=>'string','help'=>'如免费wifi，免费停车，送货上门等商户能提供的特色功能或服务'),
					array('name'=>'avg_price','title'=>'人均价格','type'=>'string'),
					array('name'=>'out_pay','title'=>'跑腿费用','type'=>'string','help'=>'非快递，周边直接配送的费用！'),
					array('name'=>'out_juli','title'=>'跑腿范围','unit'=>'公里','type'=>'unitstring','help'=>'按收货地址为准，非快递，配送的范围！(单位公里)'),
					array('name'=>'businessimg','title'=>'营业执照','type'=>'image'),
					array('name'=>'licenseimg','title'=>'许可证','type'=>'image'),
					array('type'=>'array','title'=>'门店照片','name'=>'hdps','add_tip'=>'添加一个幻灯片',
						'list'=>array(
							array('type'=>'image','name'=>'image','title'=>'幻灯片'),	
							array('type'=>'string','name'=>'url','title'=>'幻灯片url'),	
						),
						'details'=>array(
							array('type'=>'image','name'=>'image','title'=>'幻灯片'),	
							array('type'=>'link','from'=>'action','name'=>'url','title'=>'幻灯片url'),
						)
					),
					array('name'=>'desc','title'=>'门店简介','type'=>'text'),
					array('name'=>'paixu','title'=>'排序','type'=>'string'),
					array('name'=>'status','title'=>'状态','type'=>'radio','options'=>'status'),
				)
			),
		)
	);
	$return['status']=array('0'=>'关闭','1'=>'开启');
	$return['htmls']=$htmls;
	
	exi($return);
}
if($_RQ['op']=='post'){
	$postdata=get_postdata();
	if(!$postdata['title']){
		exi('请填写门店名称','error');
	}
	if(!$postdata['lat_lng']){
		exi('请填写门店坐标','error');
	}
	model('jy_weishop/store')->create($postdata);
	exi('操作成功！','','list');
}
if($_RQ['op']=='del'){
	$del=trim($_RQ['del'],';');
	if($del){
		$del=explode(';',$del);
	}else{
		$del=array();
	}
	if($_RQ['id']){
		$del[]=$_RQ['id'];
	}
	foreach($del as $id){
		$id=intval($id);
		if($id){
			pdo_delete('jy_weishop_store',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}
	}
	exi('删除成功！');
}
if($_RQ['op']=='set'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要编辑的门店！','error');
	}
	$post=get_postdata();
	if(isset($post['status'])){
		pdo_update('jy_weishop_store',array('status'=>intval($post['status'])),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	}
	exi('操作成功！');
}
if($_RQ['op']=='upwechat'){
	$res=model('core/wechat_store')->getstorelist();
	if($res['errcode'] != 0){
		exi('错误'.$res['errcode'].'：'.model('core/wechat_store')->error_code($res['errcode']),'error');
	}
	$storelist=$res['business_list'];
	foreach($storelist as $item){
		$isadd=pdo_getcolumn('jy_weishop_store',array('id'=>$item['sid'],'uniacid'=>$_SESSION['uniacid']),'id');
		if(!$isadd){
			model('jy_weishop/store')->create_upwechat($item);
		}
	}
	$list=pdo_getall('jy_weishop_store',array('uniacid'=>$_SESSION['uniacid']));
	foreach($list as $item){
		$isadd=0;
		foreach($storelist as $sl){
			if($item['id']==$sl['sid']){
				$isadd=1;
			}
		}
		if(!$isadd){
			model('jy_weishop/store')->create_towechat($item);
		}
	}
	exi('操作成功！');
}
if($_RQ['op']=='addwifi'){
	$id=intval($_RQ['id']);
	$item['sid']=$id;
	$post=get_postdata();
	if($post){
		$res=model('core/wechat_store')->getwifishoplist();
		$wifishoplist=$res['records'];
		foreach($wifishoplist as $item){
			if($item['sid']==$post['sid']){
				$shop_id=$item['shop_id'];
			}
		}
		$params=array(
			'shop_id'=>$shop_id,
			'ssid'=>$post['ssid'],
			'password'=>$post['password'],
		);
		model('core/wechat_store')->addwifi($params);
		exi('设置成功！');
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'edit'=>array(
					array('name'=>'type','title'=>'路由器类型','type'=>'radio','options'=>'types','help'=>'同一门店只能用同类型路由器！'),
					array('name'=>'ssid','title'=>'WIFI账户','type'=>'string','help'=>'无线网络设备的ssid，限30个字符以内。 ssid支持中文，但可能因设备兼容性问题导致显示乱码，或无法连接等问题，相关风险自行承担 '),
					array('name'=>'reset','title'=>'重置secretkey?','type'=>'switch','show'=>array('type'=>1)),
					array('name'=>'password','title'=>'wifi密码','type'=>'string','show'=>array('type'=>0),'help'=>'无线网络设备的密码。 8-24个字符；不能包含中文字符；ssid和密码必须有一个以大写字母“WX”开头'),
		)
	);
	$return['types']=array('0'=>'密码型路由器','1'=>'portal型路由器');
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='wifi'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择要编辑的门店！','error');
	}
	$res=model('core/wechat_store')->getwifishoplist();
	$wifishoplist=$res['records'];
	foreach($wifishoplist as $item){
		if($item['sid']==$id){
			$shop_id=$item['shop_id'];
		}
	}
	if($shop_id){
		$shopdata=model('core/wechat_store')->getwifilist($shop_id);
		$list=$shopdata['ssid_password_list'];
		foreach($list as $sv){
			$sv['qrcode_url']=model('core/wechat_store')->getwificode($shop_id,$sv['ssid']);
		}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'list'=>array('tip'=>'同一门店只能用同一类型wifi设备！','delall'=>false,'data'=>'list','edit'=>true,'list'=>array(
			array('name'=>'ssid','title'=>'wifi账户','type'=>'string'),
			array('name'=>'password','title'=>'wifi密码','type'=>'string'),
			array('name'=>'qrcode_url','title'=>'二维码物料','type'=>'href'),
		)),
		'search_one'=>array('name'=>'ssid'),
	);
	$return['htmls']=$htmls;
	exi($return);
}