var App=new Vue({
	el:"#app",
	data:function(){
		return {
			list:[],
			isFirst:true,
			per_page:0,
			pageLoad:false,
			type:"",
			catList:[],
			brandList:[],
			yearList:[],
			priceList:[],
			cat_label:"类型",
			catid:0,
			catBoxShow:false,
			brand_label:"品牌",
			brandid:0,
			brandBoxShow:false,
			price_label:"价格",
			priceBoxShow:false,
			choicePrice:"",
			year_label:"车龄",
			year:0,
			yearBoxShow:false,
		}
	},
	created:function(){
		if(!this.getCache()){
			this.getPage();
		}
	},
	methods:{
		getCache:function(){
			var v=localStorage.getItem("car_product_index");
			if(v){
				var res=JSON.parse(v);
				this.list=res.list;
				this.isFirst=res.isFirst;
				this.per_page=res.per_page;
				this.pageLoad=res.pageLoad;
				this.type=res.type;
				this.catList=res.catList;
				this.brandList=res.brandList;
				this.yearList=res.yearList;
				this.priceList=res.priceList;
				this.cat_label=res.cat_label;
				this.catid=res.catid;
				this.catBoxShow=res.catBoxShow;
				this.brand_label=res.brand_label;
				this.brandid=res.brandid;
				this.brandBoxShow=res.brandBoxShow;
				this.price_label=res.price_label;
				this.priceBoxShow=res.priceBoxShow;
				this.choicePrice=res.choicePrice;
				this.year_label=res.year_label;
				this.year=res.year;
				this.yearBoxShow=res.yearBoxShow;
				var time=Date.parse(new Date())/1000;
				if(res.expire<time){
					return false;
				}
				return true;
			}else{
				return false;
			}
			
		},
		setCache:function(){
			var v=this.$data;
			v.expire= Date.parse(new Date())/1000+300; 
			localStorage.setItem("car_product_index",JSON.stringify(v));
		},
		setCat:function(catid,title){
			this.catid=catid;
			this.cat_label=title;
			this.per_page=0;
			this.isFirst=true;
			this.getList();
			this.hideAll();
		},
		setBrand:function(brandid,title){
			this.brandid=brandid;
			this.brand_label=title;
			this.per_page=0;
			this.isFirst=true;
			this.getList();
			this.hideAll();
		},
		setPrice:function(title){
			this.choicePrice=title; 
			this.price_label=title;
			this.per_page=0;
			this.isFirst=true;
			this.getList();
			this.hideAll();
		},
		setYear:function(year,title){
			this.year=year;
			this.year_label=title;
			this.per_page=0;
			this.isFirst=true;
			this.getList();
			this.hideAll();
		}, 
		goBlog:function(id){
			window.location="/module.php?m=car_product&a=show&productid="+id;
		},
		getPage:function(){
			var that=this;
			$.ajax({
				url:"/module.php?m=car_product&a=list&ajax=1",
				data:{
					type:that.type
				},
				dataType:"json",
				success:function(res){
					that.pageLoad=true;
					that.list=res.data.list;
					that.catList=res.data.catList;
					that.brandList=res.data.brandList;
					that.priceList=res.data.priceList;
					that.yearList=res.data.yearList;
					that.setCache(); 
				}
			})
		},
		getList:function(){
			var that=this;
			if(that.per_page==0 && !that.isFirst){
				return false;
			}
			$.ajax({
				url:"/module.php?m=car_product&a=list&ajax=1",
				data:{
					catid:that.catid,
					choicePrice:that.choicePrice,
					brandid:that.brandid,
					year:that.year
				},
				dataType:"json",
				success:function(res){
					that.pageLoad=true;
					that.list=res.data.list;
					that.setCache(); 
				}
			})
		},
		toggleCatClass:function(){			
			if(this.catBoxShow==true){
				this.hideAll();
			}else{
				this.hideAll();
				this.catBoxShow=true;
			}
			
		},
		hideAll:function(){
			this.catBoxShow=false;
			this.brandBoxShow=false;
			this.priceBoxShow=false;
			this.yearBoxShow=false;
		},
		toggleBrandClass:function(){
			if(this.brandBoxShow==true){
				this.hideAll();
			}else{
				this.hideAll();
				this.brandBoxShow=true;
			}
		},
		togglePriceClass:function(){
			if(this.priceBoxShow==true){
				this.hideAll();
			}else{
				this.hideAll();
				this.priceBoxShow=true;
			}
		},
		toggleYearClass:function(){
			if(this.yearBoxShow==true){
				this.hideAll();
			}else{
				this.hideAll();
				this.yearBoxShow=true;
			}
		}
	}
})