<?php

use App\Ebcms\Store\Model\Server;
use Ebcms\App;
use Ebcms\Router;

return App::getInstance()->execute(function (
    Server $server,
    Router $router
): array {
    $res = [];
    $badge = '';
    $data = $server->query('/find-upgrade');
    if ($data['status'] == 200) {
        $badge = count($data['data']) ?: '';
    }
    $res[] = [
        'title' => '应用市场',
        'url' => $router->buildUrl('/ebcms/store/index'),
        'priority' => 1,
        'badge' => $badge,
        'icon' => '<svg t="1609049867278" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="70095" width="20" height="20"><path d="M947.286523 1022.326114H75.610185A79.509604 79.509604 0 0 1 0.076061 939.468737L103.438546 83.69432a79.509604 79.509604 0 0 1 75.534123-83.69432h654.908051a79.509604 79.509604 0 0 1 75.534124 83.69432l113.615038 856.61136a80.974254 80.974254 0 0 1-77.417245 83.69432h1.673886z" fill="#2EA9C6" p-id="70096"></path><path d="M732.401358 468.897425a56.28443 56.28443 0 0 0 26.154475-48.124233 50.635063 50.635063 0 1 0-100.851656 0 56.493666 56.493666 0 0 0 23.43441 46.659583c-8.787904 97.922354-83.69432 174.502656-174.711892 174.502656s-165.923989-76.998774-174.502656-174.711892A56.702902 56.702902 0 0 0 355.77692 420.773192a52.936657 52.936657 0 0 0-50.425828-55.238251 52.936657 52.936657 0 0 0-50.425828 55.238251 56.075194 56.075194 0 0 0 26.154475 48.124233c9.624847 127.633837 106.919493 228.067021 225.765427 228.067021S722.567275 596.740499 732.401358 468.897425zM131.476143 193.543114h742.159379v59.632203H131.476143z" fill="#FFFFFF" p-id="70097"></path></svg>',
    ];
    return $res;
});
