package com.zscat.mallplus;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;

/**
 * <p>
 * 代码生成器演示
 * </p>
 */
public class MpGenerator {

    /**
     * <p>
     * MySQL 生成演示
     * </p>
     */
    public static void main(String[] args) {
        AutoGenerator mpg = new AutoGenerator();
        // 选择 freemarker 引擎，默认 Veloctiy
        //  mpg.setTemplateEngine(new FreemarkerTemplateEngine());

        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir("/Users/java/gen");
        //  gc.setOutputDir("F:\\home");
        gc.setFileOverride(true);
        gc.setActiveRecord(false);// 不需要ActiveRecord特性的请改为false
        gc.setEnableCache(false);// XML 二级缓存
        gc.setBaseResultMap(true);// XML ResultMap
        gc.setBaseColumnList(true);// XML columList
        // .setKotlin(true) 是否生成 kotlin 代码
        gc.setAuthor("zscat");

        // 自定义文件命名，注意 %s 会自动填充表实体属性！
        // gc.setMapperName("%sDao");
        // gc.setXmlName("%sDao");
        // gc.setServiceName("MP%sService");
        // gc.setServiceImplName("%sServiceDiy");
        // gc.setControllerName("%sAction");
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(DbType.MYSQL);
        dsc.setTypeConvert(new MySqlTypeConvert() {
            // 自定义数据库表字段类型转换【可选】
            public DbColumnType processTypeConvert(String fieldType) {
                System.out.println("转换类型：" + fieldType);
                // 注意！！processTypeConvert 存在默认类型转换，如果不是你要的效果请自定义返回、非如下直接返回。
                return super.processTypeConvert(gc, fieldType);
            }
        });
        dsc.setDriverName("com.mysql.cj.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("root@123");
        dsc.setUrl("jdbc:mysql://39.106.212.32:3306/mallplus1");
        mpg.setDataSource(dsc);

        // 自定义配置
        InjectionConfig cfg = new InjectionConfig() {
            @Override
            public void initMap() {
                // to do nothing
            }
        };

        //  mpg.setTemplate(new TemplateConfig().setXml(null));
        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);// 表名生成策略
        // strategy.setCapitalMode(true);// 全局大写命名 ORACLE 注意
        //   strategy.setTablePrefix(new String[] { "tlog_", "tsys_" });// 此处可以修改为您的表前缀
       /* strategy.setNaming(NamingStrategy.underline_to_camel);// 表名生成策略
         strategy.setInclude(new String[] { "sys_user_permission","sys_area","sys_member_area","sys_permission",
                 "sys_role","sys_role_permission","sys_school", "sys_user","sys_user_permission",
                 "sys_user_role","sys_web_log", "sys_admin_log"}); // 需要生成的表*/

        /*strategy.setInclude(new String[] { "cms_help","cms_help_category","cms_member_report","cms_prefrence_area",
                "cms_prefrence_area_product_relation","cms_subject","cms_subject_category", "cms_subject_comment",
                "cms_subject_product_relation",
                "cms_topic","cms_topic_category", "cms_topic_comment","cms_topic_member"});*/

      /*  strategy.setInclude(new String[] { "oms_cart_item","oms_company_address","oms_order","oms_order_item",
                "oms_order_operate_history","oms_order_return_apply","oms_order_setting", "oms_order_return_reason"}); // 需要生成的表
*/

    /*    strategy.setInclude(new String[] { "pms_album","pms_album_pic","pms_brand","pms_comment",
                "pms_comment_replay","pms_feight_template","pms_member_price", "pms_product",
                "pms_product_attribute","pms_product_consult","pms_product_full_reduction","pms_product_ladder",
                "pms_product_attribute_category","pms_product_attribute_value", "pms_product_category",
                "pms_product_category_attribute_relation","pms_product_operate_log","pms_product_vertify_record"
                ,"pms_sku_stock"}); */

        /*strategy.setInclude(new String[] { "sms_coupon","sms_coupon_history","sms_coupon_product_category_relation","sms_coupon_product_relation",
                "sms_flash_promotion","sms_flash_promotion_log","sms_flash_promotion_product_relation", "sms_flash_promotion_session",
                "sms_group","sms_group_member","sms_home_advertise",
                "sms_home_brand","sms_home_new_product", "sms_home_recommend_product",
                "sms_home_recommend_subject","sms_red_packet","sms_user_red_packet"
                }); */

//            strategy.setInclude(new String[] { "ums_collect","ums_member","ums_member_blance_log","ums_member_level",
//                    "ums_member_member_tag_relation","ums_member_product_category_relation",
//                    "ums_member_receive_address", "ums_member_rule_setting","ums_member_statistics_info","ums_member_tag",
//            "ums_member_task","ums_growth_change_history","ums_integration_change_history","ums_integration_consume_setting"}); // 需要生成的表
        strategy.setInclude(new String[]{"sms_group_record"});
        // strategy.setExclude(new String[]{"test"}); // 排除生成的表
        // 自定义实体父类
        // strategy.setSuperEntityClass("com.baomidou.demo.TestEntity");
        // 自定义实体，公共字段
        // strategy.setSuperEntityColumns(new String[] { "test_id", "age" });
        // 自定义 mapper 父类
        // strategy.setSuperMapperClass("com.baomidou.demo.TestMapper");
        // 自定义 service 父类
        // strategy.setSuperServiceClass("com.baomidou.demo.TestService");
        // 自定义 service 实现类父类
        // strategy.setSuperServiceImplClass("com.baomidou.demo.TestServiceImpl");
        // 自定义 controller 父类
        // strategy.setSuperControllerClass("com.baomidou.demo.TestController");
        // 【实体】是否生成字段常量（默认 false）
        // public static final String ID = "test_id";
        // strategy.setEntityColumnConstant(true);
        // 【实体】是否为构建者模型（默认 false）
        // public User setName(String name) {this.name = name; return this;}
        //  strategy.setEntityBuilderModel(true);
        mpg.setStrategy(strategy);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setParent("com.zscat.mallplus");
        pc.setModuleName("pms");
        mpg.setPackageInfo(pc);


        // 关闭默认 xml 生成，调整生成 至 根目录
        TemplateConfig tc = new TemplateConfig();
        tc.setXml(null);
        mpg.setTemplate(tc);

        // 自定义模板配置，可以 copy 源码 mybatis-plus/src/main/resources/templates 下面内容修改，
        // 放置自己项目的 src/main/resources/templates 目录下, 默认名称一下可以不配置，也可以自定义模板名称
        // TemplateConfig tc = new TemplateConfig();
        // tc.setController("...");
        // tc.setEntity("...");
        // tc.setMapper("...");
        // tc.setXml("...");
        // tc.setService("...");
        // tc.setServiceImpl("...");
        // 如上任何一个模块如果设置 空 OR Null 将不生成该模块。
        // mpg.setTemplate(tc);

        // 执行生成
        mpg.execute();

        // 打印注入设置【可无】
//        System.err.println(mpg.getCfg().getMap().get("abc"));
    }

}
