/*
 Navicat Premium Data Transfer

 Source Server         : 39.106.212.32
 Source Server Type    : MySQL
 Source Server Version : 50724
 Source Host           : 39.106.212.32:3306
 Source Schema         : mallplus2

 Target Server Type    : MySQL
 Target Server Version : 50724
 File Encoding         : 65001

 Date: 12/04/2020 10:45:27
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for QRTZ_BLOB_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_BLOB_TRIGGERS`;
CREATE TABLE `QRTZ_BLOB_TRIGGERS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `blob_data` blob,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_BLOB_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for QRTZ_CALENDARS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_CALENDARS`;
CREATE TABLE `QRTZ_CALENDARS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `calendar` blob NOT NULL,
  PRIMARY KEY (`sched_name`, `calendar_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for QRTZ_CRON_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_CRON_TRIGGERS`;
CREATE TABLE `QRTZ_CRON_TRIGGERS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `cron_expression` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `time_zone_id` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_CRON_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of QRTZ_CRON_TRIGGERS
-- ----------------------------
INSERT INTO `QRTZ_CRON_TRIGGERS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0 0/30 1-2 * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', '0 0 1 * * ?', 'Asia/Shanghai');
INSERT INTO `QRTZ_CRON_TRIGGERS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'DEFAULT', '0 0 2 * * ?', 'Asia/Shanghai');

-- ----------------------------
-- Table structure for QRTZ_FIRED_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_FIRED_TRIGGERS`;
CREATE TABLE `QRTZ_FIRED_TRIGGERS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `entry_id` varchar(95) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `fired_time` bigint(13) NOT NULL,
  `sched_time` bigint(13) NOT NULL,
  `priority` int(11) NOT NULL,
  `state` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `job_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `entry_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for QRTZ_JOB_DETAILS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_JOB_DETAILS`;
CREATE TABLE `QRTZ_JOB_DETAILS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `job_class_name` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_durable` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_update_data` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_data` blob,
  PRIMARY KEY (`sched_name`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of QRTZ_JOB_DETAILS
-- ----------------------------
INSERT INTO `QRTZ_JOB_DETAILS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 'com.ruoyi.project.monitor.job.util.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F5045525449455373720028636F6D2E72756F79692E70726F6A6563742E6D6F6E69746F722E6A6F622E646F6D61696E2E4A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720029636F6D2E72756F79692E6672616D65776F726B2E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707400007070740000707070740001307400103020302F333020312D32202A202A203F74000873646667686A6B6C74000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B020000787000000000000000037400073334353637383174000131740001307800);
INSERT INTO `QRTZ_JOB_DETAILS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', NULL, 'com.ruoyi.project.monitor.job.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F5045525449455373720028636F6D2E72756F79692E70726F6A6563742E6D6F6E69746F722E6A6F622E646F6D61696E2E4A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720029636F6D2E72756F79692E6672616D65776F726B2E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707400007372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000170D91A66987870740015E59586E688B7E695B0E68DAEE697A5E7BB9FE8AEA17070707400013174000B3020302031202A202A203F74001672795461736B2E73746F72654461795374617469637374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000004740015E59586E688B7E695B0E68DAEE697A5E7BB9FE8AEA174000131740001307800);
INSERT INTO `QRTZ_JOB_DETAILS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'DEFAULT', NULL, 'com.ruoyi.project.monitor.job.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F5045525449455373720028636F6D2E72756F79692E70726F6A6563742E6D6F6E69746F722E6A6F622E646F6D61696E2E4A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720029636F6D2E72756F79692E6672616D65776F726B2E7765622E646F6D61696E2E42617365456E7469747900000000000000010200074C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707400007372000E6A6176612E7574696C2E44617465686A81014B5974190300007870770800000170D91B0AA87870740023E59586E688B7E7BB9FE8AEA120E5878CE699A832E782B9203020302032202A202A203F7070707400013174000B3020302032202A202A203F74001372795461736B2E73746F72655374617469637374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000005740017E59586E688B7E7BB9FE8AEA120E5878CE699A832E782B974000131740001307800);

-- ----------------------------
-- Table structure for QRTZ_LOCKS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_LOCKS`;
CREATE TABLE `QRTZ_LOCKS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `lock_name` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `lock_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of QRTZ_LOCKS
-- ----------------------------
INSERT INTO `QRTZ_LOCKS` VALUES ('RuoyiScheduler', 'STATE_ACCESS');
INSERT INTO `QRTZ_LOCKS` VALUES ('RuoyiScheduler', 'TRIGGER_ACCESS');

-- ----------------------------
-- Table structure for QRTZ_PAUSED_TRIGGER_GRPS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_PAUSED_TRIGGER_GRPS`;
CREATE TABLE `QRTZ_PAUSED_TRIGGER_GRPS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for QRTZ_SCHEDULER_STATE
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SCHEDULER_STATE`;
CREATE TABLE `QRTZ_SCHEDULER_STATE`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `last_checkin_time` bigint(13) NOT NULL,
  `checkin_interval` bigint(13) NOT NULL,
  PRIMARY KEY (`sched_name`, `instance_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of QRTZ_SCHEDULER_STATE
-- ----------------------------
INSERT INTO `QRTZ_SCHEDULER_STATE` VALUES ('RuoyiScheduler', 'iZ2ze337xawcmv6lllj11oZ1584189692202', 1584681662477, 15000);
INSERT INTO `QRTZ_SCHEDULER_STATE` VALUES ('RuoyiScheduler', 'iZn5u67gp1cut2Z1578669399959', 1584681655208, 15000);

-- ----------------------------
-- Table structure for QRTZ_SIMPLE_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SIMPLE_TRIGGERS`;
CREATE TABLE `QRTZ_SIMPLE_TRIGGERS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `repeat_count` bigint(7) NOT NULL,
  `repeat_interval` bigint(12) NOT NULL,
  `times_triggered` bigint(10) NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_SIMPLE_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for QRTZ_SIMPROP_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_SIMPROP_TRIGGERS`;
CREATE TABLE `QRTZ_SIMPROP_TRIGGERS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `str_prop_1` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `str_prop_2` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `str_prop_3` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `int_prop_1` int(11) DEFAULT NULL,
  `int_prop_2` int(11) DEFAULT NULL,
  `long_prop_1` bigint(20) DEFAULT NULL,
  `long_prop_2` bigint(20) DEFAULT NULL,
  `dec_prop_1` decimal(13, 4) DEFAULT NULL,
  `dec_prop_2` decimal(13, 4) DEFAULT NULL,
  `bool_prop_1` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `bool_prop_2` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `QRTZ_SIMPROP_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `QRTZ_TRIGGERS` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for QRTZ_TRIGGERS
-- ----------------------------
DROP TABLE IF EXISTS `QRTZ_TRIGGERS`;
CREATE TABLE `QRTZ_TRIGGERS`  (
  `sched_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `next_fire_time` bigint(13) DEFAULT NULL,
  `prev_fire_time` bigint(13) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `trigger_state` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `trigger_type` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `start_time` bigint(13) NOT NULL,
  `end_time` bigint(13) DEFAULT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `misfire_instr` smallint(2) DEFAULT NULL,
  `job_data` blob,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  INDEX `sched_name`(`sched_name`, `job_name`, `job_group`) USING BTREE,
  CONSTRAINT `QRTZ_TRIGGERS_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `QRTZ_JOB_DETAILS` (`sched_name`, `job_name`, `job_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of QRTZ_TRIGGERS
-- ----------------------------
INSERT INTO `QRTZ_TRIGGERS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 1584723600000, -1, 5, 'WAITING', 'CRON', 1584678975000, 0, NULL, -1, '');
INSERT INTO `QRTZ_TRIGGERS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', 'TASK_CLASS_NAME4', 'DEFAULT', NULL, 1584723600000, -1, 5, 'WAITING', 'CRON', 1584678976000, 0, NULL, -1, '');
INSERT INTO `QRTZ_TRIGGERS` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME5', 'DEFAULT', 'TASK_CLASS_NAME5', 'DEFAULT', NULL, 1584727200000, -1, 5, 'WAITING', 'CRON', 1584678977000, 0, NULL, -1, '');

-- ----------------------------
-- Table structure for admin_day_statics
-- ----------------------------
DROP TABLE IF EXISTS `admin_day_statics`;
CREATE TABLE `admin_day_statics`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_count` int(8) DEFAULT NULL COMMENT '添加商品',
  `pay_order_count` int(8) DEFAULT NULL COMMENT '支付订单数',
  `article_count` int(8) DEFAULT NULL COMMENT '文章数',
  `pay_amount` decimal(10, 0) DEFAULT NULL COMMENT '支付金额',
  `member_count` int(8) DEFAULT NULL COMMENT '添加会员数',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `store_id` int(11) DEFAULT NULL COMMENT '商户',
  `not_pay_order_count` int(11) DEFAULT NULL COMMENT '没有支付订单数',
  `not_pay_amount` decimal(10, 0) DEFAULT NULL COMMENT '没有支付订单金额',
  `store_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '商户',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2299 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '商户日统计' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_day_statics
-- ----------------------------
INSERT INTO `admin_day_statics` VALUES (2267, 1, 6, 0, 2395, 0, '2020-03-20 01:00:03', 1, 6, 1134, '北京皮包专卖');
INSERT INTO `admin_day_statics` VALUES (2268, 0, 0, 0, 0, 0, '2020-03-20 01:00:03', 2, 0, 0, '北京豪车专卖');
INSERT INTO `admin_day_statics` VALUES (2269, 0, 0, 0, 0, 0, '2020-03-20 01:00:03', 3, 0, 0, '北京名衣专卖');
INSERT INTO `admin_day_statics` VALUES (2270, 0, 0, 0, 0, 0, '2020-03-20 01:00:03', 4, 0, 0, '北京房屋专卖');
INSERT INTO `admin_day_statics` VALUES (2271, 0, 0, 0, 0, 0, '2020-03-20 01:00:03', 5, 0, 0, '北京手机专卖');
INSERT INTO `admin_day_statics` VALUES (2272, 0, 0, 0, 0, 0, '2020-03-20 01:00:03', 6, 0, 0, '北京狗粮专卖');
INSERT INTO `admin_day_statics` VALUES (2273, 0, 0, 0, 0, 0, '2020-03-20 01:00:03', 7, 0, 0, '北京苹果专卖');
INSERT INTO `admin_day_statics` VALUES (2274, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 8, 0, 0, '北京耳机专卖');
INSERT INTO `admin_day_statics` VALUES (2275, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 526, 0, 0, '一家花店');
INSERT INTO `admin_day_statics` VALUES (2276, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 531, 0, 0, '一家炒货');
INSERT INTO `admin_day_statics` VALUES (2277, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1056, 0, 0, '啊啊啊啊');
INSERT INTO `admin_day_statics` VALUES (2278, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1057, 0, 0, NULL);
INSERT INTO `admin_day_statics` VALUES (2279, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1061, 0, 0, NULL);
INSERT INTO `admin_day_statics` VALUES (2280, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1062, 0, 0, NULL);
INSERT INTO `admin_day_statics` VALUES (2281, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1088, 0, 0, 'store100');
INSERT INTO `admin_day_statics` VALUES (2282, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1089, 0, 0, NULL);
INSERT INTO `admin_day_statics` VALUES (2283, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1096, 0, 0, '测试商户');
INSERT INTO `admin_day_statics` VALUES (2284, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1103, 0, 0, '小木');
INSERT INTO `admin_day_statics` VALUES (2285, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1187, 0, 0, '傅俊波');
INSERT INTO `admin_day_statics` VALUES (2286, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1189, 0, 0, '佳佳百货');
INSERT INTO `admin_day_statics` VALUES (2287, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1190, 0, 0, 'zoey');
INSERT INTO `admin_day_statics` VALUES (2288, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1191, 0, 0, 'aaa');
INSERT INTO `admin_day_statics` VALUES (2289, 0, 0, 0, 0, 0, '2020-03-20 01:00:04', 1192, 0, 0, '12');
INSERT INTO `admin_day_statics` VALUES (2290, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1193, 0, 0, '阿百川');
INSERT INTO `admin_day_statics` VALUES (2291, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1194, 0, 0, '河北省石家庄睿德艺术馆');
INSERT INTO `admin_day_statics` VALUES (2292, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1195, 0, 0, '王某某');
INSERT INTO `admin_day_statics` VALUES (2293, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1196, 0, 0, '注册登录绑定解绑');
INSERT INTO `admin_day_statics` VALUES (2294, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1197, 0, 0, '333');
INSERT INTO `admin_day_statics` VALUES (2295, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1198, 0, 0, '333');
INSERT INTO `admin_day_statics` VALUES (2296, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1199, 0, 0, 'hjfdjf');
INSERT INTO `admin_day_statics` VALUES (2297, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1200, 0, 0, 'hjfdjf');
INSERT INTO `admin_day_statics` VALUES (2298, 0, 0, 0, 0, 0, '2020-03-20 01:00:05', 1201, 0, 0, 'ali');

-- ----------------------------
-- Table structure for admin_gen_table
-- ----------------------------
DROP TABLE IF EXISTS `admin_gen_table`;
CREATE TABLE `admin_gen_table`  (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '表描述',
  `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '生成功能作者',
  `options` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 418 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '代码生成业务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_gen_table
-- ----------------------------
INSERT INTO `admin_gen_table` VALUES (195, 'admin_sys_role_menu', '角色和菜单关联表', 'AdminRoleMenu', 'crud', 'com.ruoyi.project.system', 'system', 'menu', '角色和菜单关联', 'mallplus', NULL, 'admin', '2019-09-19 17:17:58', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (196, 'admin_sys_user', '用户信息表', 'AdminUser', 'crud', 'com.ruoyi.project.system', 'system', 'user', '用户信息', 'mallplus', NULL, 'admin', '2019-09-19 17:17:58', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (197, 'admin_sys_user_online', '在线用户记录', 'AdminUserOnline', 'crud', 'com.ruoyi.project.system', 'system', 'online', '在线用户记录', 'mallplus', NULL, 'admin', '2019-09-19 17:17:58', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (198, 'admin_sys_user_post', '用户与岗位关联表', 'AdminUserPost', 'crud', 'com.ruoyi.project.system', 'system', 'post', '用户与岗位关联', 'mallplus', NULL, 'admin', '2019-09-19 17:17:58', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (199, 'admin_sys_user_role', '用户和角色关联表', 'AdminUserRole', 'crud', 'com.ruoyi.project.system', 'system', 'role', '用户和角色关联', 'mallplus', NULL, 'admin', '2019-09-19 17:17:58', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (200, 'admin_day_statics', '', 'AdminDayStatics', 'crud', 'com.ruoyi.project.system', 'system', 'statics', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:18:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (201, 'admin_gen_table', '代码生成业务表', 'AdminGenTable', 'crud', 'com.ruoyi.project.system', 'system', 'table', '代码生成业务', 'mallplus', NULL, 'admin', '2019-09-19 17:18:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (202, 'admin_gen_table_column', '代码生成业务表字段', 'AdminGenTableColumn', 'crud', 'com.ruoyi.project.system', 'system', 'column', '代码生成业务字段', 'mallplus', NULL, 'admin', '2019-09-19 17:18:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (203, 'admin_sys_config', '参数配置表', 'AdminConfig', 'crud', 'com.ruoyi.project.system', 'system', 'config', '参数配置', 'mallplus', NULL, 'admin', '2019-09-19 17:18:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (204, 'admin_sys_dept', '部门表', 'AdminDept', 'crud', 'com.ruoyi.project.system', 'system', 'dept', '部门', 'mallplus', NULL, 'admin', '2019-09-19 17:18:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (205, 'admin_sys_dict_data', '字典数据表', 'AdminDictData', 'crud', 'com.ruoyi.project.system', 'system', 'data', '字典数据', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (206, 'admin_sys_dict_type', '字典类型表', 'AdminDictType', 'crud', 'com.ruoyi.project.system', 'system', 'type', '字典类型', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (207, 'admin_sys_job', '定时任务调度表', 'AdminJob', 'crud', 'com.ruoyi.project.system', 'system', 'job', '定时任务调度', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (208, 'admin_sys_job_log', '定时任务调度日志表', 'AdminJobLog', 'crud', 'com.ruoyi.project.system', 'system', 'log', '定时任务调度日志', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (209, 'admin_sys_logininfor', '系统访问记录', 'AdminLogininfor', 'crud', 'com.ruoyi.project.system', 'system', 'logininfor', '系统访问记录', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (210, 'admin_sys_menu', '菜单权限表', 'AdminMenu', 'crud', 'com.ruoyi.project.system', 'system', 'menu', '菜单权限', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (211, 'admin_sys_notice', '通知公告表', 'AdminNotice', 'crud', 'com.ruoyi.project.system', 'system', 'notice', '通知公告', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (212, 'admin_sys_oper_log', '操作日志记录', 'AdminOperLog', 'crud', 'com.ruoyi.project.system', 'system', 'log', '操作日志记录', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (213, 'admin_sys_post', '岗位信息表', 'AdminPost', 'crud', 'com.ruoyi.project.system', 'system', 'post', '岗位信息', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (214, 'admin_sys_role', '角色信息表', 'AdminRole', 'crud', 'com.ruoyi.project.system', 'system', 'role', '角色信息', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (215, 'admin_sys_role_dept', '角色和部门关联表', 'AdminRoleDept', 'crud', 'com.ruoyi.project.system', 'system', 'dept', '角色和部门关联', 'mallplus', NULL, 'admin', '2019-09-19 17:18:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (216, 'bak_brand', '品牌商表', 'BakBrand', 'crud', 'com.ruoyi.project.system', 'system', 'brand', '品牌商', 'mallplus', NULL, 'admin', '2019-09-19 17:20:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (217, 'bak_category', '类目表', 'BakCategory', 'crud', 'com.ruoyi.project.system', 'system', 'category', '类目', 'mallplus', NULL, 'admin', '2019-09-19 17:20:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (218, 'bak_goods', '商品基本信息表', 'BakGoods', 'crud', 'com.ruoyi.project.system', 'system', 'goods', '商品基本信息', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (219, 'sms_home_recommend_product', '人气推荐商品表', 'SmsHomeRecommendProduct', 'crud', 'com.ruoyi.project.system', 'system', 'product', '人气推荐商品', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (220, 'sms_home_recommend_subject', '首页推荐专题表', 'SmsHomeRecommendSubject', 'crud', 'com.ruoyi.project.system', 'system', 'subject', '首页推荐专题', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (221, 'sms_red_packet', '红包', 'SmsRedPacket', 'crud', 'com.ruoyi.project.system', 'system', 'packet', '红包', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (222, 'sms_user_red_packet', '用户红包', 'SmsUserRedPacket', 'crud', 'com.ruoyi.project.system', 'system', 'packet', '用户红包', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (223, 'sys_admin_log', '', 'AdminLog', 'crud', 'com.ruoyi.project.system', 'system', 'log', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (224, 'sys_applet_set', '', 'AppletSet', 'crud', 'com.ruoyi.project.system', 'system', 'set', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (225, 'sys_area', '', 'Area', 'crud', 'com.ruoyi.project.system', 'system', 'area', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (226, 'sys_dict', '系统配置信息表', 'Dict', 'crud', 'com.ruoyi.project.system', 'system', 'dict', '系统配置信息', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (227, 'sys_member_area', '', 'MemberArea', 'crud', 'com.ruoyi.project.system', 'system', 'area', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (228, 'sys_message', '站内信', 'Message', 'crud', 'com.ruoyi.project.system', 'system', 'message', '站内信', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (229, 'sys_notice', '公告表', 'Notice', 'crud', 'com.ruoyi.project.system', 'system', 'notice', '公告', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (230, 'sys_permission', '后台用户权限表', 'Permission', 'crud', 'com.ruoyi.project.system', 'system', 'permission', '后台用户权限', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (231, 'sys_permission_category', '', 'PermissionCategory', 'crud', 'com.ruoyi.project.system', 'system', 'category', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (232, 'sys_role', '后台用户角色表', 'Role', 'crud', 'com.ruoyi.project.system', 'system', 'role', '后台用户角色', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (233, 'sys_role_permission', '后台用户角色和权限关系表', 'RolePermission', 'crud', 'com.ruoyi.project.system', 'system', 'permission', '后台用户角色和权限关系', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (234, 'sys_school', '', 'School', 'crud', 'com.ruoyi.project.system', 'system', 'school', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (235, 'sys_sms', '发短信记录', 'Sms', 'crud', 'com.ruoyi.project.system', 'system', 'sms', '发短信记录', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (237, 'sys_user', '后台用户表', 'User', 'crud', 'com.ruoyi.project.system', 'system', 'user', '后台用户', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (238, 'sys_user_permission', '后台用户和权限关系表(除角色中定义的权限以外的加减权限)', 'UserPermission', 'crud', 'com.ruoyi.project.system', 'system', 'permission', '后台用户和权限关系(除角色中定义的权限以外的加减权限)', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (239, 'sys_user_role', '后台用户和角色关系表', 'UserRole', 'crud', 'com.ruoyi.project.system', 'system', 'role', '后台用户和角色关系', 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (240, 'sys_web_log', '', 'WebLog', 'crud', 'com.ruoyi.project.system', 'system', 'log', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (241, 'tb_health_push_task', '', 'TbHealthPushTask', 'crud', 'com.ruoyi.project.system', 'system', 'task', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (242, 'tb_health_push_task_user', '', 'TbHealthPushTaskUser', 'crud', 'com.ruoyi.project.system', 'system', 'user', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (243, 'tb_panel', '内容分类', 'TbPanel', 'crud', 'com.ruoyi.project.system', 'system', 'panel', '内容分类', 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (244, 'tb_panel_content', '', 'TbPanelContent', 'crud', 'com.ruoyi.project.system', 'system', 'content', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (245, 'tb_user_from_id', '', 'TbUserFromId', 'crud', 'com.ruoyi.project.system', 'system', 'id', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (246, 'ums_collect', '', 'UmsCollect', 'crud', 'com.ruoyi.project.system', 'system', 'collect', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (247, 'ums_employ_info', '', 'UmsEmployInfo', 'crud', 'com.ruoyi.project.system', 'system', 'info', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (248, 'ums_growth_change_history', '成长值变化历史记录表', 'UmsGrowthChangeHistory', 'crud', 'com.ruoyi.project.member', 'member', 'growthChangeHistory', '成长值变化历史记录', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:43', '', '2020-03-04 09:36:25', '');
INSERT INTO `admin_gen_table` VALUES (249, 'ums_integration_change_history', '积分变化历史记录表', 'UmsIntegrationChangeHistory', 'crud', 'com.ruoyi.project.member', 'member', 'umsIntegrationChangeHistory', '积分变化历史记录', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:43', '', '2020-03-04 09:38:50', '');
INSERT INTO `admin_gen_table` VALUES (250, 'ums_integration_consume_setting', '积分消费设置', 'UmsIntegrationConsumeSetting', 'crud', 'com.ruoyi.project.system', 'system', 'setting', '积分消费设置', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:43', '', '2020-03-04 09:39:13', '');
INSERT INTO `admin_gen_table` VALUES (251, 'ums_member', '会员表', 'UmsMember', 'crud', 'com.ruoyi.project.system', 'system', 'member', '会员', 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (252, 'ums_member_blance_log', '余额记录', 'UmsMemberBlanceLog', 'crud', 'com.ruoyi.project.member', 'member', 'umsMemberBlanceLog', '余额记录', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:43', '', '2020-03-04 09:42:22', '余额记录');
INSERT INTO `admin_gen_table` VALUES (253, 'ums_member_level', '会员等级表', 'UmsMemberLevel', 'crud', 'com.ruoyi.project.member', 'member', 'umsMemberLevel', '会员等级', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:43', '', '2020-03-04 09:44:26', '');
INSERT INTO `admin_gen_table` VALUES (254, 'ums_member_login_log', '会员登录记录', 'UmsMemberLoginLog', 'crud', 'com.ruoyi.project.system', 'system', 'log', '会员登录记录', 'mallplus', NULL, 'admin', '2019-09-19 17:20:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (255, 'ums_member_member_tag_relation', '用户和标签关系表', 'UmsMemberMemberTagRelation', 'crud', 'com.ruoyi.project.system', 'system', 'relation', '用户和标签关系', 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (256, 'ums_member_product_category_relation', '会员与产品分类关系表（用户喜欢的分类）', 'UmsMemberProductCategoryRelation', 'crud', 'com.ruoyi.project.system', 'system', 'relation', '会员与产品分类关系（用户喜欢的分类）', 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (257, 'ums_member_receive_address', '会员收货地址表', 'UmsMemberReceiveAddress', 'crud', 'com.ruoyi.project.system', 'system', 'address', '会员收货地址', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:44', '', '2020-03-04 09:21:16', '');
INSERT INTO `admin_gen_table` VALUES (258, 'ums_member_rule_setting', '会员积分成长规则表', 'UmsMemberRuleSetting', 'crud', 'com.ruoyi.project.system', 'system', 'setting', '会员积分成长规则', 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (259, 'ums_member_statistics_info', '会员统计信息', 'UmsMemberStatisticsInfo', 'crud', 'com.ruoyi.project.system', 'system', 'info', '会员统计信息', 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (260, 'ums_member_tag', '用户标签表', 'UmsMemberTag', 'crud', 'com.ruoyi.project.system', 'system', 'tag', '用户标签', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2019-09-19 17:20:44', '', '2020-03-04 09:26:23', '');
INSERT INTO `admin_gen_table` VALUES (261, 'ums_member_task', '会员任务表', 'UmsMemberTask', 'crud', 'com.ruoyi.project.system', 'system', 'task', '会员任务', 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (262, 'ums_reward_log', '', 'UmsRewardLog', 'crud', 'com.ruoyi.project.system', 'system', 'log', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (263, 'ums_reward_logs', '', 'UmsRewardLogs', 'crud', 'com.ruoyi.project.system', 'system', 'logs', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (264, 'user_bankcards', '', 'UserBankcards', 'crud', 'com.ruoyi.project.system', 'system', 'bankcards', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (265, 'user_tocash', '', 'UserTocash', 'crud', 'com.ruoyi.project.system', 'system', 'tocash', NULL, 'mallplus', NULL, 'admin', '2019-09-19 17:20:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (266, 'spot_trans_pending', '现货当前挂单表', 'SpotTransPending', 'crud', 'com.ruoyi.project.system', 'system', 'pending', '现货当前挂单', 'mallplus', NULL, 'admin', '2019-09-25 18:59:48', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (267, 'oms_payments', '支付方式表', 'OmsPayments', 'crud', 'com.ruoyi.project.mall', 'mall', 'payments', '支付方式', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-01-03 11:04:22', '', '2020-01-03 11:14:19', '');
INSERT INTO `admin_gen_table` VALUES (268, 'sys_store', '店铺表', 'Store', 'crud', 'com.ruoyi.project.mall', 'mall', 'store', '店铺', 'mallplus', NULL, 'admin', '2020-01-13 15:55:39', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (270, 'oms_express_company', '物流公司表', 'OmsExpressCompany', 'crud', 'com.ruoyi.project.mall', 'mall', 'company', '物流公司', 'mallplus', NULL, 'admin', '2020-02-27 12:01:55', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (271, 'fenxiao_config', '分销设置', 'FenxiaoConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', '分销设置', 'mallplus', NULL, 'admin', '2020-03-02 19:26:26', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (272, 'fenxiao_records', '佣金记录', 'FenxiaoRecords', 'crud', 'com.ruoyi.project.mall', 'mall', 'records', '佣金记录', 'mallplus', NULL, 'admin', '2020-03-02 19:26:26', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (273, 'mallplus_keyword', '关键字表', 'MallplusKeyword', 'crud', 'com.ruoyi.project.mall', 'mall', 'keyword', '关键字', 'mallplus', NULL, 'admin', '2020-03-02 19:26:27', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (274, 'mallplus_search_history', '搜索历史表', 'MallplusSearchHistory', 'crud', 'com.ruoyi.project.mall', 'mall', 'history', '搜索历史', 'mallplus', NULL, 'admin', '2020-03-02 19:26:27', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (275, 'oms_cart_item', '购物车表', 'OmsCartItem', 'crud', 'com.ruoyi.project.mall', 'mall', 'item', '购物车', 'mallplus', NULL, 'admin', '2020-03-02 19:26:28', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (276, 'pms_brand', '品牌表', 'PmsBrand', 'crud', 'com.ruoyi.project.goods', 'goods', 'pmsBrand', '品牌', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:26:28', '', '2020-03-04 20:30:05', '');
INSERT INTO `admin_gen_table` VALUES (277, 'pms_favorite', '', 'PmsFavorite', 'crud', 'com.ruoyi.project.mall', 'mall', 'favorite', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:26:29', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (278, 'pms_feight_template', '运费模版', 'PmsFeightTemplate', 'crud', 'com.ruoyi.project.goods', 'goods', 'pmsFeightTemplate', '运费模版', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:26:29', '', '2020-03-04 20:33:10', '');
INSERT INTO `admin_gen_table` VALUES (279, 'pms_product', '商品信息', 'PmsProduct', 'crud', 'com.ruoyi.project.mall', 'mall', 'product', '商品信息', 'mallplus', NULL, 'admin', '2020-03-02 19:26:29', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (280, 'sms_coupon_history', '优惠券使用、领取历史表', 'SmsCouponHistory', 'crud', 'com.ruoyi.project.mall', 'mall', 'history', '优惠券使用、领取历史', 'mallplus', NULL, 'admin', '2020-03-02 19:26:31', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (281, 'building_community', '小区', 'BuildingCommunity', 'crud', 'com.ruoyi.project.mall', 'mall', 'community', '小区', 'mallplus', NULL, 'admin', '2020-03-02 19:33:27', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (282, 'building_floor', '楼层', 'BuildingFloor', 'crud', 'com.ruoyi.project.mall', 'mall', 'floor', '楼层', 'mallplus', NULL, 'admin', '2020-03-02 19:33:28', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (283, 'building_room', '房屋', 'BuildingRoom', 'crud', 'com.ruoyi.project.mall', 'mall', 'room', '房屋', 'mallplus', NULL, 'admin', '2020-03-02 19:33:28', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (284, 'cms_zhao_pin', '', 'CmsZhaoPin', 'crud', 'com.ruoyi.project.mall', 'mall', 'pin', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:33:29', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (285, 'oms_order', '订单表', 'OmsOrder', 'crud', 'com.ruoyi.project.mall', 'mall', 'order', '订单', 'mallplus', NULL, 'admin', '2020-03-02 19:33:29', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (286, 'sms_coupon_product_relation', '优惠券和产品的关系表', 'SmsCouponProductRelation', 'crud', 'com.ruoyi.project.mall', 'mall', 'relation', '优惠券和产品的关系', 'mallplus', NULL, 'admin', '2020-03-02 19:33:31', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (287, 'sms_detailed_commission', '分销佣金明细表', 'SmsDetailedCommission', 'crud', 'com.ruoyi.project.mall', 'mall', 'commission', '分销佣金明细', 'mallplus', NULL, 'admin', '2020-03-02 19:33:31', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (288, 'sms_diy_page', '页面配置', 'SmsDiyPage', 'crud', 'com.ruoyi.project.mall', 'mall', 'page', '页面配置', 'mallplus', NULL, 'admin', '2020-03-02 19:33:31', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (289, 'sms_draw', '一分钱抽奖', 'SmsDraw', 'crud', 'com.ruoyi.project.mall', 'mall', 'draw', '一分钱抽奖', 'mallplus', NULL, 'admin', '2020-03-02 19:33:32', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (290, 'sms_draw_user', '抽奖与用户关联表', 'SmsDrawUser', 'crud', 'com.ruoyi.project.mall', 'mall', 'user', '抽奖与用户关联', 'mallplus', NULL, 'admin', '2020-03-02 19:33:32', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (291, 'sms_experience', '预约表', 'SmsExperience', 'crud', 'com.ruoyi.project.mall', 'mall', 'experience', '预约', 'mallplus', NULL, 'admin', '2020-03-02 19:33:32', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (292, 'sms_flash_promotion', '限时购表', 'SmsFlashPromotion', 'crud', 'com.ruoyi.project.mall', 'mall', 'promotion', '限时购', 'mallplus', NULL, 'admin', '2020-03-02 19:33:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (293, 'sms_flash_promotion_log', '限时购通知记录', 'SmsFlashPromotionLog', 'crud', 'com.ruoyi.project.mall', 'mall', 'log', '限时购通知记录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (294, 'sms_flash_promotion_product_relation', '商品限时购与商品关系表', 'SmsFlashPromotionProductRelation', 'crud', 'com.ruoyi.project.mall', 'mall', 'relation', '商品限时购与商品关系', 'mallplus', NULL, 'admin', '2020-03-02 19:33:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (295, 'sms_flash_promotion_session', '限时购场次表', 'SmsFlashPromotionSession', 'crud', 'com.ruoyi.project.mall', 'mall', 'session', '限时购场次', 'mallplus', NULL, 'admin', '2020-03-02 19:33:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (296, 'sms_goods_diypage_map', '商品模块|商品自定义模版关联表', 'SmsGoodsDiypageMap', 'crud', 'com.ruoyi.project.mall', 'mall', 'map', '商品模块|商品自定义模版关联', 'mallplus', NULL, 'admin', '2020-03-02 19:33:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (297, 'sms_group_record', '', 'SmsGroupRecord', 'crud', 'com.ruoyi.project.mall', 'mall', 'record', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:33:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (298, 'sms_home_advertise', '首页轮播广告表', 'SmsHomeAdvertise', 'crud', 'com.ruoyi.project.mall', 'mall', 'advertise', '首页轮播广告', 'mallplus', NULL, 'admin', '2020-03-02 19:33:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (299, 'sms_home_brand', '首页推荐品牌表', 'SmsHomeBrand', 'crud', 'com.ruoyi.project.mall', 'mall', 'brand', '首页推荐品牌', 'mallplus', NULL, 'admin', '2020-03-02 19:33:34', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (300, 'sms_home_new_product', '新鲜好物表', 'SmsHomeNewProduct', 'crud', 'com.ruoyi.project.mall', 'mall', 'product', '新鲜好物', 'mallplus', NULL, 'admin', '2020-03-02 19:33:35', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (301, 'sms_paimai', '一分钱抽奖', 'SmsPaimai', 'crud', 'com.ruoyi.project.mall', 'mall', 'paimai', '一分钱抽奖', 'mallplus', NULL, 'admin', '2020-03-02 19:33:35', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (302, 'sms_paimai_log', '拍卖纪录', 'SmsPaimaiLog', 'crud', 'com.ruoyi.project.mall', 'mall', 'log', '拍卖纪录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:35', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (303, 'sms_sign_activity', '签到活动', 'SmsSignActivity', 'crud', 'com.ruoyi.project.mall', 'mall', 'activity', '签到活动', 'mallplus', NULL, 'admin', '2020-03-02 19:33:36', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (304, 'sms_sign_config', '签到配置表', 'SmsSignConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', '签到配置', 'mallplus', NULL, 'admin', '2020-03-02 19:33:36', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (305, 'sms_sign_record', '签到记录', 'SmsSignRecord', 'crud', 'com.ruoyi.project.mall', 'mall', 'record', '签到记录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:36', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (306, 'sys_alipay_config', '支付宝配置', 'AlipayConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', '支付宝配置', 'mallplus', NULL, 'admin', '2020-03-02 19:33:37', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (307, 'sys_dingding_config', '', 'DingdingConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:33:37', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (308, 'sys_email_config', '邮件配置', 'EmailConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', '邮件配置', 'mallplus', NULL, 'admin', '2020-03-02 19:33:37', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (309, 'sys_qiniu_config', '七牛配置表', 'QiniuConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', '七牛配置', 'mallplus', NULL, 'admin', '2020-03-02 19:33:38', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (310, 'sys_qiniu_content', '七牛上传纪录', 'QiniuContent', 'crud', 'com.ruoyi.project.mall', 'mall', 'content', '七牛上传纪录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:38', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (311, 'sys_storage', '本地存储', 'Storage', 'crud', 'com.ruoyi.project.mall', 'mall', 'storage', '本地存储', 'mallplus', NULL, 'admin', '2020-03-02 19:33:38', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (312, 'sys_test', '', 'Test', 'crud', 'com.ruoyi.project.mall', 'mall', 'test', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:33:39', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (313, 't_wx_account', '公众号账户表', 'TWxAccount', 'crud', 'com.ruoyi.project.mall', 'mall', 'account', '公众号账户', 'mallplus', NULL, 'admin', '2020-03-02 19:33:39', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (314, 't_wx_account_fans', '微信公众号粉丝表', 'TWxAccountFans', 'crud', 'com.ruoyi.project.mall', 'mall', 'fans', '微信公众号粉丝', 'mallplus', NULL, 'admin', '2020-03-02 19:33:39', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (315, 't_wx_account_fans_tag', '粉丝标签关联表', 'TWxAccountFansTag', 'crud', 'com.ruoyi.project.mall', 'mall', 'tag', '粉丝标签关联', 'mallplus', NULL, 'admin', '2020-03-02 19:33:40', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (316, 't_wx_fans_msg', '粉丝消息表 ', 'TWxFansMsg', 'crud', 'com.ruoyi.project.mall', 'mall', 'msg', '粉丝消息 ', 'mallplus', NULL, 'admin', '2020-03-02 19:33:40', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (317, 't_wx_fans_msg_res', '回复粉丝消息历史表 ', 'TWxFansMsgRes', 'crud', 'com.ruoyi.project.mall', 'mall', 'res', '回复粉丝消息历史 ', 'mallplus', NULL, 'admin', '2020-03-02 19:33:40', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (318, 't_wx_fans_tag', '粉丝标签表', 'TWxFansTag', 'crud', 'com.ruoyi.project.mall', 'mall', 'tag', '粉丝标签', 'mallplus', NULL, 'admin', '2020-03-02 19:33:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (319, 't_wx_media_upload', '微信素材上传表 ', 'TWxMediaUpload', 'crud', 'com.ruoyi.project.mall', 'mall', 'upload', '微信素材上传 ', 'mallplus', NULL, 'admin', '2020-03-02 19:33:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (320, 't_wx_menu', '微信菜单表', 'TWxMenu', 'crud', 'com.ruoyi.project.mall', 'mall', 'menu', '微信菜单', 'mallplus', NULL, 'admin', '2020-03-02 19:33:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (321, 't_wx_news_article_item', '图文消息文章列表表 ', 'TWxNewsArticleItem', 'crud', 'com.ruoyi.project.mall', 'mall', 'item', '图文消息文章列 ', 'mallplus', NULL, 'admin', '2020-03-02 19:33:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (322, 't_wx_news_template', '图文消息模板表', 'TWxNewsTemplate', 'crud', 'com.ruoyi.project.mall', 'mall', 'template', '图文消息模板', 'mallplus', NULL, 'admin', '2020-03-02 19:33:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (323, 't_wx_receive_text', '回复关键字表', 'TWxReceiveText', 'crud', 'com.ruoyi.project.mall', 'mall', 'text', '回复关键字', 'mallplus', NULL, 'admin', '2020-03-02 19:33:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (324, 't_wx_subscribe_text', '关注欢迎语表', 'TWxSubscribeText', 'crud', 'com.ruoyi.project.mall', 'mall', 'text', '关注欢迎语', 'mallplus', NULL, 'admin', '2020-03-02 19:33:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (325, 't_wx_text_template', '文本模板表', 'TWxTextTemplate', 'crud', 'com.ruoyi.project.mall', 'mall', 'template', '文本模板', 'mallplus', NULL, 'admin', '2020-03-02 19:33:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (326, 'toupiao_project', '投票项目', 'ToupiaoProject', 'crud', 'com.ruoyi.project.mall', 'mall', 'project', '投票项目', 'mallplus', NULL, 'admin', '2020-03-02 19:33:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (327, 'toupiao_record', '投票记录', 'ToupiaoRecord', 'crud', 'com.ruoyi.project.mall', 'mall', 'record', '投票记录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (328, 'ums_member_location', '', 'UmsMemberLocation', 'crud', 'com.ruoyi.project.mall', 'mall', 'location', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:33:45', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (329, 'ums_system_message', '系统消息表', 'UmsSystemMessage', 'crud', 'com.ruoyi.project.mall', 'mall', 'message', '系统消息', 'mallplus', NULL, 'admin', '2020-03-02 19:33:45', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (330, 'unimall_spu', '', 'UnimallSpu', 'crud', 'com.ruoyi.project.mall', 'mall', 'spu', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:33:45', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (331, 'cms_subject_category', '专题分类表', 'CmsSubjectCategory', 'crud', 'com.ruoyi.project.mall', 'mall', 'category', '专题分类', 'mallplus', NULL, 'admin', '2020-03-02 19:33:55', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (332, 'cms_subject_comment', '专题评论表', 'CmsSubjectComment', 'crud', 'com.ruoyi.project.mall', 'mall', 'comment', '专题评论', 'mallplus', NULL, 'admin', '2020-03-02 19:33:56', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (333, 'cms_subject_product_relation', '专题商品关系表', 'CmsSubjectProductRelation', 'crud', 'com.ruoyi.project.mall', 'mall', 'relation', '专题商品关系', 'mallplus', NULL, 'admin', '2020-03-02 19:33:56', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (334, 'fenxiao_checks', '分销审核记录', 'FenxiaoChecks', 'crud', 'com.ruoyi.project.mall', 'mall', 'checks', '分销审核记录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:56', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (335, 'fenxiao_user_relate', '用户关系表', 'FenxiaoUserRelate', 'crud', 'com.ruoyi.project.mall', 'mall', 'relate', '用户关系', 'mallplus', NULL, 'admin', '2020-03-02 19:33:56', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (336, 'invoice_record', '发票信息记录', 'InvoiceRecord', 'crud', 'com.ruoyi.project.mall', 'mall', 'record', '发票信息记录', 'mallplus', NULL, 'admin', '2020-03-02 19:33:57', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (337, 'jifen_coupon', '积分券', 'JifenCoupon', 'crud', 'com.ruoyi.project.mall', 'mall', 'coupon', '积分券', 'mallplus', NULL, 'admin', '2020-03-02 19:33:57', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (338, 'jifen_donate_rule', '积分赠送规则', 'JifenDonateRule', 'crud', 'com.ruoyi.project.mall', 'mall', 'rule', '积分赠送规则', 'mallplus', NULL, 'admin', '2020-03-02 19:33:57', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (339, 'jifen_sign_rule', '积分签到规则', 'JifenSignRule', 'crud', 'com.ruoyi.project.mall', 'mall', 'rule', '积分签到规则', 'mallplus', NULL, 'admin', '2020-03-02 19:33:57', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (340, 'oms_order_item', '订单中所包含的商品', 'OmsOrderItem', 'crud', 'com.ruoyi.project.mall', 'mall', 'item', '订单中所包含的商品', 'mallplus', NULL, 'admin', '2020-03-02 19:33:57', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (341, 'oms_order_operate_history', '订单操作历史记录', 'OmsOrderOperateHistory', 'crud', 'com.ruoyi.project.order', 'order', 'omsOrderOperateHistory', '订单操作历史记录', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:33:58', '', '2020-03-04 10:12:20', '');
INSERT INTO `admin_gen_table` VALUES (342, 'oms_order_return_apply', '订单退货申请', 'OmsOrderReturnApply', 'crud', 'com.ruoyi.project.order', 'order', 'omsOrderReturnApply', '订单退货申请', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:33:58', '', '2020-03-04 10:13:30', '');
INSERT INTO `admin_gen_table` VALUES (343, 'oms_order_return_reason', '退货原因表', 'OmsOrderReturnReason', 'crud', 'com.ruoyi.project.order', 'order', 'orderReturnReason', '退货原因', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:01', '', '2020-03-04 10:09:48', '');
INSERT INTO `admin_gen_table` VALUES (344, 'oms_order_setting', '订单设置表', 'OmsOrderSetting', 'crud', 'com.ruoyi.project.order', 'order', 'orderSetting', '订单设置', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:02', '', '2020-03-04 10:07:48', '');
INSERT INTO `admin_gen_table` VALUES (345, 'oms_ship', '配送方式表', 'OmsShip', 'crud', 'com.ruoyi.project.order', 'order', 'orderShip', '配送方式', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:02', '', '2020-03-04 10:08:20', '');
INSERT INTO `admin_gen_table` VALUES (346, 'picture', '', 'Picture', 'crud', 'com.ruoyi.project.mall', 'mall', 'picture', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:34:02', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (347, 'pms_album', '相册表', 'PmsAlbum', 'crud', 'com.ruoyi.project.mall', 'mall', 'album', '相册', 'mallplus', NULL, 'admin', '2020-03-02 19:34:03', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (348, 'pms_album_pic', '画册图片表', 'PmsAlbumPic', 'crud', 'com.ruoyi.project.mall', 'mall', 'pic', '画册图片', 'mallplus', NULL, 'admin', '2020-03-02 19:34:03', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (349, 'pms_comment', '商品评价表', 'PmsComment', 'crud', 'com.ruoyi.project.mall', 'mall', 'comment', '商品评价', 'mallplus', NULL, 'admin', '2020-03-02 19:34:03', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (350, 'pms_comment_replay', '产品评价回复表', 'PmsCommentReplay', 'crud', 'com.ruoyi.project.mall', 'mall', 'replay', '产品评价回复', 'mallplus', NULL, 'admin', '2020-03-02 19:34:03', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (351, 'pms_gifts', '活动商品', 'PmsGifts', 'crud', 'com.ruoyi.project.goods', 'goods', 'pmsGifts', '活动商品', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:04', '', '2020-03-04 20:25:13', '');
INSERT INTO `admin_gen_table` VALUES (352, 'pms_gifts_category', '活动商品分类表', 'PmsGiftsCategory', 'crud', 'com.ruoyi.project.goods', 'goods', 'pmsGiftsCategory', 'PmsGiftsCategory', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:04', '', '2020-03-04 20:26:20', '');
INSERT INTO `admin_gen_table` VALUES (353, 'pms_member_price', '商品会员价格表', 'PmsMemberPrice', 'crud', 'com.ruoyi.project.mall', 'mall', 'price', '商品会员价格', 'mallplus', NULL, 'admin', '2020-03-02 19:34:04', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (354, 'pms_product_attribute', '商品属性参数表', 'PmsProductAttribute', 'crud', 'com.ruoyi.project.goods', 'goods', 'pmsProductAttribute', '商品属性参数', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:04', '', '2020-03-04 20:27:49', '');
INSERT INTO `admin_gen_table` VALUES (355, 'pms_product_attribute_category', '产品属性分类表', 'PmsProductAttributeCategory', 'crud', 'com.ruoyi.project.goods', 'goods', 'pmsProductAttributeCategory', '产品属性分类', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:04', '', '2020-03-04 20:28:53', '');
INSERT INTO `admin_gen_table` VALUES (356, 'pms_product_attribute_value', '存储产品参数信息的表', 'PmsProductAttributeValue', 'crud', 'com.ruoyi.project.mall', 'mall', 'value', '存储产品参数信息的', 'mallplus', NULL, 'admin', '2020-03-02 19:34:05', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (357, 'pms_product_category', '产品分类', 'PmsProductCategory', 'tree', 'com.ruoyi.project.goods', 'goods', 'pmsProductCategory', '产品分类', 'mallplus', '{\"treeName\":\"name\",\"treeParentCode\":\"parent_id\",\"treeCode\":\"id\"}', 'admin', '2020-03-02 19:34:05', '', '2020-03-04 20:24:09', '');
INSERT INTO `admin_gen_table` VALUES (358, 'pms_product_category_attribute_relation', '产品的分类和属性的关系表，用于设置分类筛选条件（只支持一级分类）', 'PmsProductCategoryAttributeRelation', 'crud', 'com.ruoyi.project.mall', 'mall', 'relation', '产品的分类和属性的关系，用于设置分类筛选条件（只支持一级分类）', 'mallplus', NULL, 'admin', '2020-03-02 19:34:05', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (359, 'pms_product_consult', '产品咨询表', 'PmsProductConsult', 'crud', 'com.ruoyi.project.mall', 'mall', 'consult', '产品咨询', 'mallplus', NULL, 'admin', '2020-03-02 19:34:06', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (360, 'pms_product_full_reduction', '产品满减表(只针对同商品)', 'PmsProductFullReduction', 'crud', 'com.ruoyi.project.mall', 'mall', 'reduction', '产品满减(只针对同商品)', 'mallplus', NULL, 'admin', '2020-03-02 19:34:06', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (361, 'pms_product_ladder', '产品阶梯价格表(只针对同商品)', 'PmsProductLadder', 'crud', 'com.ruoyi.project.mall', 'mall', 'ladder', '产品阶梯价格(只针对同商品)', 'mallplus', NULL, 'admin', '2020-03-02 19:34:06', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (362, 'pms_product_operate_log', '', 'PmsProductOperateLog', 'crud', 'com.ruoyi.project.mall', 'mall', 'log', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:34:06', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (363, 'pms_product_vertify_record', '商品审核记录', 'PmsProductVertifyRecord', 'crud', 'com.ruoyi.project.mall', 'mall', 'record', '商品审核记录', 'mallplus', NULL, 'admin', '2020-03-02 19:34:07', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (364, 'pms_sku_stock', 'sku的库存', 'PmsSkuStock', 'crud', 'com.ruoyi.project.goods', 'goods', 'stock', 'sku的库存', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:07', '', '2020-03-04 19:11:54', '');
INSERT INTO `admin_gen_table` VALUES (365, 'pms_small_navicon_category', '小程序首页nav管理', 'PmsSmallNaviconCategory', 'crud', 'com.ruoyi.project.mall', 'mall', 'category', '小程序首页nav管理', 'mallplus', NULL, 'admin', '2020-03-02 19:34:08', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (366, 'sms_bargain_config', '砍价免单设置表', 'SmsBargainConfig', 'crud', 'com.ruoyi.project.mall', 'mall', 'config', '砍价免单设置', 'mallplus', NULL, 'admin', '2020-03-02 19:34:08', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (367, 'sms_bargain_member', '拼团记录', 'SmsBargainMember', 'crud', 'com.ruoyi.project.mall', 'mall', 'member', '拼团记录', 'mallplus', NULL, 'admin', '2020-03-02 19:34:08', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (368, 'sms_bargain_record', '砍价免单记录表', 'SmsBargainRecord', 'crud', 'com.ruoyi.project.mall', 'mall', 'record', '砍价免单记录', 'mallplus', NULL, 'admin', '2020-03-02 19:34:08', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (369, 'sms_basic_gifts', '积分赠礼营销', 'SmsBasicGifts', 'crud', 'com.ruoyi.project.mall', 'mall', 'gifts', '积分赠礼营销', 'mallplus', NULL, 'admin', '2020-03-02 19:34:09', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (370, 'sms_basic_marking', '满减 折扣 营销', 'SmsBasicMarking', 'crud', 'com.ruoyi.project.mall', 'mall', 'marking', '满减 折扣 营销', 'mallplus', NULL, 'admin', '2020-03-02 19:34:09', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (371, 'sms_configure', '商品配置表', 'SmsConfigure', 'crud', 'com.ruoyi.project.mall', 'mall', 'configure', '商品配置', 'mallplus', NULL, 'admin', '2020-03-02 19:34:10', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (372, 'sms_content', '短信模版内容', 'SmsContent', 'crud', 'com.ruoyi.project.mall', 'mall', 'content', '短信模版内容', 'mallplus', NULL, 'admin', '2020-03-02 19:34:10', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (373, 'sms_content_msg', '短信发送记录', 'SmsContentMsg', 'crud', 'com.ruoyi.project.mall', 'mall', 'msg', '短信发送记录', 'mallplus', NULL, 'admin', '2020-03-02 19:34:10', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (374, 'sms_coupon', '优惠卷表', 'SmsCoupon', 'crud', 'com.ruoyi.project.mall', 'mall', 'coupon', '优惠卷', 'mallplus', NULL, 'admin', '2020-03-02 19:34:11', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (375, 'sms_coupon_product_category_relation', '优惠券和产品分类关系表', 'SmsCouponProductCategoryRelation', 'crud', 'com.ruoyi.project.mall', 'mall', 'relation', '优惠券和产品分类关系', 'mallplus', NULL, 'admin', '2020-03-02 19:34:11', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (376, 'sms_diypage_template_category', '页面管理|自定义页面分类', 'SmsDiypageTemplateCategory', 'crud', 'com.ruoyi.project.mall', 'mall', 'category', '页面管理|自定义页面分类', 'mallplus', NULL, 'admin', '2020-03-02 19:34:11', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (377, 'sms_group', '拼团表', 'SmsGroup', 'crud', 'com.ruoyi.project.mall', 'mall', 'group', '拼团', 'mallplus', NULL, 'admin', '2020-03-02 19:34:11', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (378, 'sms_group_activity', '团购活动', 'SmsGroupActivity', 'crud', 'com.ruoyi.project.marking', 'marking', 'activity', '团购活动', 'mallplus', '{\"treeName\":\"\",\"treeParentCode\":\"\",\"treeCode\":\"\"}', 'admin', '2020-03-02 19:34:12', '', '2020-03-04 01:19:51', '');
INSERT INTO `admin_gen_table` VALUES (379, 'sms_group_member', '拼团记录', 'SmsGroupMember', 'crud', 'com.ruoyi.project.mall', 'mall', 'member', '拼团记录', 'mallplus', NULL, 'admin', '2020-03-02 19:34:12', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (380, 'sms_share', '分享列表', 'SmsShare', 'crud', 'com.ruoyi.project.mall', 'mall', 'share', '分享列', 'mallplus', NULL, 'admin', '2020-03-02 19:34:12', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (381, 'bill_aftersales', '退货单表', 'BillAftersales', 'crud', 'com.ruoyi.project.mall', 'mall', 'aftersales', '退货单', 'mallplus', NULL, 'admin', '2020-03-02 19:36:20', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (382, 'bill_aftersales_images', '商品图片关联表', 'BillAftersalesImages', 'crud', 'com.ruoyi.project.mall', 'mall', 'images', '商品图片关联', 'mallplus', NULL, 'admin', '2020-03-02 19:36:22', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (383, 'bill_aftersales_items', '售后单明细表', 'BillAftersalesItems', 'crud', 'com.ruoyi.project.mall', 'mall', 'items', '售后单明细', 'mallplus', NULL, 'admin', '2020-03-02 19:36:22', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (384, 'bill_delivery', '发货单表', 'BillDelivery', 'crud', 'com.ruoyi.project.mall', 'mall', 'delivery', '发货单', 'mallplus', NULL, 'admin', '2020-03-02 19:36:23', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (385, 'bill_delivery_items', '发货单详情表', 'BillDeliveryItems', 'crud', 'com.ruoyi.project.mall', 'mall', 'items', '发货单详情', 'mallplus', NULL, 'admin', '2020-03-02 19:36:24', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (386, 'bill_lading', '提货单表', 'BillLading', 'crud', 'com.ruoyi.project.mall', 'mall', 'lading', '提货单', 'mallplus', NULL, 'admin', '2020-03-02 19:36:24', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (387, 'bill_payments', '支付单表', 'BillPayments', 'crud', 'com.ruoyi.project.mall', 'mall', 'payments', '支付单', 'mallplus', NULL, 'admin', '2020-03-02 19:36:26', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (388, 'bill_payments_rel', '支付单明细表', 'BillPaymentsRel', 'crud', 'com.ruoyi.project.mall', 'mall', 'rel', '支付单明细', 'mallplus', NULL, 'admin', '2020-03-02 19:36:28', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (389, 'bill_refund', '退款单表', 'BillRefund', 'crud', 'com.ruoyi.project.mall', 'mall', 'refund', '退款单', 'mallplus', NULL, 'admin', '2020-03-02 19:36:28', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (390, 'bill_reship', '退货单表', 'BillReship', 'crud', 'com.ruoyi.project.mall', 'mall', 'reship', '退货单', 'mallplus', NULL, 'admin', '2020-03-02 19:36:30', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (391, 'bill_reship_items', '退货单明细表', 'BillReshipItems', 'crud', 'com.ruoyi.project.mall', 'mall', 'items', '退货单明细', 'mallplus', NULL, 'admin', '2020-03-02 19:36:31', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (392, 'build_adv', '首页轮播广告表', 'BuildAdv', 'crud', 'com.ruoyi.project.mall', 'mall', 'adv', '首页轮播广告', 'mallplus', NULL, 'admin', '2020-03-02 19:36:31', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (393, 'build_apply_room', '', 'BuildApplyRoom', 'crud', 'com.ruoyi.project.mall', 'mall', 'room', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:36:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (394, 'build_group', '小区拼团', 'BuildGroup', 'crud', 'com.ruoyi.project.mall', 'mall', 'group', '小区拼团', 'mallplus', NULL, 'admin', '2020-03-02 19:36:33', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (395, 'build_group_member', '小区拼团记录', 'BuildGroupMember', 'crud', 'com.ruoyi.project.mall', 'mall', 'member', '小区拼团记录', 'mallplus', NULL, 'admin', '2020-03-02 19:36:35', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (396, 'build_notice', '公告表', 'BuildNotice', 'crud', 'com.ruoyi.project.mall', 'mall', 'notice', '公告', 'mallplus', NULL, 'admin', '2020-03-02 19:36:38', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (397, 'build_repair', '小区报修', 'BuildRepair', 'crud', 'com.ruoyi.project.mall', 'mall', 'repair', '小区报修', 'mallplus', NULL, 'admin', '2020-03-02 19:36:38', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (398, 'build_type_price', '小区收费价格', 'BuildTypePrice', 'crud', 'com.ruoyi.project.mall', 'mall', 'price', '小区收费价格', 'mallplus', NULL, 'admin', '2020-03-02 19:36:39', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (399, 'build_wuye_company', '物业公司', 'BuildWuyeCompany', 'crud', 'com.ruoyi.project.mall', 'mall', 'company', '物业公司', 'mallplus', NULL, 'admin', '2020-03-02 19:36:39', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (400, 'build_wuye_price', '小区收费记录', 'BuildWuyePrice', 'crud', 'com.ruoyi.project.mall', 'mall', 'price', '小区收费记录', 'mallplus', NULL, 'admin', '2020-03-02 19:36:40', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (401, 'building_owner', '业主成员表', 'BuildingOwner', 'crud', 'com.ruoyi.project.mall', 'mall', 'owner', '业主成员', 'mallplus', NULL, 'admin', '2020-03-02 19:36:40', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (402, 'building_unit', '单元', 'BuildingUnit', 'crud', 'com.ruoyi.project.mall', 'mall', 'unit', '单元', 'mallplus', NULL, 'admin', '2020-03-02 19:36:40', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (403, 'building_user_community', '', 'BuildingUserCommunity', 'crud', 'com.ruoyi.project.mall', 'mall', 'community', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:36:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (404, 'cms_favorite', '', 'CmsFavorite', 'crud', 'com.ruoyi.project.mall', 'mall', 'favorite', NULL, 'mallplus', NULL, 'admin', '2020-03-02 19:36:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (405, 'cms_help', '帮助表', 'CmsHelp', 'crud', 'com.ruoyi.project.mall', 'mall', 'help', '帮助', 'mallplus', NULL, 'admin', '2020-03-02 19:36:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (406, 'cms_help_category', '帮助分类表', 'CmsHelpCategory', 'crud', 'com.ruoyi.project.mall', 'mall', 'category', '帮助分类', 'mallplus', NULL, 'admin', '2020-03-02 19:36:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (407, 'cms_member_report', '用户举报表', 'CmsMemberReport', 'crud', 'com.ruoyi.project.mall', 'mall', 'report', '用户举报', 'mallplus', NULL, 'admin', '2020-03-02 19:36:41', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (408, 'cms_parter', '合作伙伴', 'CmsParter', 'crud', 'com.ruoyi.project.mall', 'mall', 'parter', '合作伙伴', 'mallplus', NULL, 'admin', '2020-03-02 19:36:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (409, 'cms_prefrence_area', '优选专区', 'CmsPrefrenceArea', 'crud', 'com.ruoyi.project.mall', 'mall', 'area', '优选专区', 'mallplus', NULL, 'admin', '2020-03-02 19:36:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (410, 'cms_prefrence_area_product_relation', '优选专区和产品关系表', 'CmsPrefrenceAreaProductRelation', 'crud', 'com.ruoyi.project.mall', 'mall', 'relation', '优选专区和产品关系', 'mallplus', NULL, 'admin', '2020-03-02 19:36:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (411, 'cms_subject', '专题表', 'CmsSubject', 'crud', 'com.ruoyi.project.mall', 'mall', 'subject', '专题', 'mallplus', NULL, 'admin', '2020-03-02 19:36:42', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (412, 'cms_topic', '话题表', 'CmsTopic', 'crud', 'com.ruoyi.project.mall', 'mall', 'topic', '话题', 'mallplus', NULL, 'admin', '2020-03-02 19:36:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (413, 'cms_topic_category', '话题分类表', 'CmsTopicCategory', 'crud', 'com.ruoyi.project.mall', 'mall', 'category', '话题分类', 'mallplus', NULL, 'admin', '2020-03-02 19:36:43', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (415, 'cms_topic_member', '话题参与者', 'CmsTopicMember', 'crud', 'com.ruoyi.project.mall', 'mall', 'member', '话题参与者', 'mallplus', NULL, 'admin', '2020-03-02 19:36:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (416, 'oms_company_address', '公司收发货地址表', 'OmsCompanyAddress', 'crud', 'com.ruoyi.project.mall', 'mall', 'address', '公司收发货地址', 'mallplus', NULL, 'admin', '2020-03-02 19:36:44', '', NULL, NULL);
INSERT INTO `admin_gen_table` VALUES (417, 'oms_express_info', '物流信息表', 'OmsExpressInfo', 'crud', 'com.ruoyi.project.mall', 'mall', 'info', '物流信息', 'mallplus', NULL, 'admin', '2020-03-02 19:36:44', '', NULL, NULL);

-- ----------------------------
-- Table structure for admin_gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `admin_gen_table_column`;
CREATE TABLE `admin_gen_table_column`  (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '字典类型',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4757 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '代码生成业务表字段' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_gen_table_column
-- ----------------------------
INSERT INTO `admin_gen_table_column` VALUES (2335, '195', 'role_id', '角色ID', 'bigint(20)', 'Long', 'roleId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2336, '195', 'menu_id', '菜单ID', 'bigint(20)', 'Long', 'menuId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2337, '196', 'user_id', '用户ID', 'bigint(20)', 'Long', 'userId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2338, '196', 'dept_id', '部门ID', 'bigint(20)', 'Long', 'deptId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2339, '196', 'login_name', '登录账号', 'varchar(30)', 'String', 'loginName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2340, '196', 'user_name', '用户昵称', 'varchar(30)', 'String', 'userName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2341, '196', 'user_type', '用户类型（00系统用户）', 'varchar(2)', 'String', 'userType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2342, '196', 'email', '用户邮箱', 'varchar(50)', 'String', 'email', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2343, '196', 'phonenumber', '手机号码', 'varchar(11)', 'String', 'phonenumber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2344, '196', 'sex', '用户性别（0男 1女 2未知）', 'char(1)', 'String', 'sex', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 8, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2345, '196', 'avatar', '头像路径', 'varchar(100)', 'String', 'avatar', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2346, '196', 'password', '密码', 'varchar(50)', 'String', 'password', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2347, '196', 'salt', '盐加密', 'varchar(20)', 'String', 'salt', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2348, '196', 'status', '帐号状态（0正常 1停用）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 12, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2349, '196', 'del_flag', '删除标志（0代表存在 2代表删除）', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2350, '196', 'login_ip', '最后登陆IP', 'varchar(50)', 'String', 'loginIp', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2351, '196', 'login_date', '最后登陆时间', 'datetime', 'Date', 'loginDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 15, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2352, '196', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 16, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2353, '196', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 17, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2354, '196', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 18, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2355, '196', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 19, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2356, '196', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 20, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2357, '197', 'sessionId', '用户会话id', 'varchar(50)', 'String', 'sessionid', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2358, '197', 'login_name', '登录账号', 'varchar(50)', 'String', 'loginName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2359, '197', 'dept_name', '部门名称', 'varchar(50)', 'String', 'deptName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2360, '197', 'ipaddr', '登录IP地址', 'varchar(50)', 'String', 'ipaddr', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2361, '197', 'login_location', '登录地点', 'varchar(255)', 'String', 'loginLocation', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2362, '197', 'browser', '浏览器类型', 'varchar(50)', 'String', 'browser', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2363, '197', 'os', '操作系统', 'varchar(50)', 'String', 'os', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2364, '197', 'status', '在线状态on_line在线off_line离线', 'varchar(10)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2365, '197', 'start_timestamp', 'session创建时间', 'datetime', 'Date', 'startTimestamp', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2366, '197', 'last_access_time', 'session最后访问时间', 'datetime', 'Date', 'lastAccessTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2367, '197', 'expire_time', '超时时间，单位为分钟', 'int(5)', 'Integer', 'expireTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2368, '198', 'user_id', '用户ID', 'bigint(20)', 'Long', 'userId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2369, '198', 'post_id', '岗位ID', 'bigint(20)', 'Long', 'postId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2370, '199', 'user_id', '用户ID', 'bigint(20)', 'Long', 'userId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2371, '199', 'role_id', '角色ID', 'bigint(20)', 'Long', 'roleId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:17:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2372, '200', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2373, '200', 'goods_count', '添加商品', 'int(8)', 'Integer', 'goodsCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2374, '200', 'pay_order_count', '支付订单数', 'int(8)', 'Integer', 'payOrderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2375, '200', 'article_count', '文章数', 'int(8)', 'Integer', 'articleCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2376, '200', 'pay_amount', '支付金额', 'decimal(10,0)', 'Long', 'payAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2377, '200', 'member_count', '添加会员数', 'int(8)', 'Integer', 'memberCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2378, '200', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2379, '200', 'store_id', '商户', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2380, '200', 'not_pay_order_count', '没有支付订单数', 'int(11)', 'Long', 'notPayOrderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2381, '200', 'not_pay_amount', '没有支付订单金额', 'decimal(10,0)', 'Long', 'notPayAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2382, '200', 'store_name', '商户', 'varchar(255)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 11, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2383, '201', 'table_id', '编号', 'bigint(20)', 'Long', 'tableId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2384, '201', 'table_name', '表名称', 'varchar(200)', 'String', 'tableName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2385, '201', 'table_comment', '表描述', 'varchar(500)', 'String', 'tableComment', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2386, '201', 'class_name', '实体类名称', 'varchar(100)', 'String', 'className', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2387, '201', 'tpl_category', '使用的模板（crud单表操作 tree树表操作）', 'varchar(200)', 'String', 'tplCategory', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2388, '201', 'package_name', '生成包路径', 'varchar(100)', 'String', 'packageName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2389, '201', 'module_name', '生成模块名', 'varchar(30)', 'String', 'moduleName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2390, '201', 'business_name', '生成业务名', 'varchar(30)', 'String', 'businessName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2391, '201', 'function_name', '生成功能名', 'varchar(50)', 'String', 'functionName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 9, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2392, '201', 'function_author', '生成功能作者', 'varchar(50)', 'String', 'functionAuthor', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2393, '201', 'options', '其它生成选项', 'varchar(1000)', 'String', 'options', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2394, '201', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2395, '201', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2396, '201', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2397, '201', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2398, '201', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 16, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2399, '202', 'column_id', '编号', 'bigint(20)', 'Long', 'columnId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2400, '202', 'table_id', '归属表编号', 'varchar(64)', 'String', 'tableId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2401, '202', 'column_name', '列名称', 'varchar(200)', 'String', 'columnName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2402, '202', 'column_comment', '列描述', 'varchar(500)', 'String', 'columnComment', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2403, '202', 'column_type', '列类型', 'varchar(100)', 'String', 'columnType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2404, '202', 'java_type', 'JAVA类型', 'varchar(500)', 'String', 'javaType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2405, '202', 'java_field', 'JAVA字段名', 'varchar(200)', 'String', 'javaField', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2406, '202', 'is_pk', '是否主键（1是）', 'char(1)', 'String', 'isPk', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2407, '202', 'is_increment', '是否自增（1是）', 'char(1)', 'String', 'isIncrement', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2408, '202', 'is_required', '是否必填（1是）', 'char(1)', 'String', 'isRequired', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2409, '202', 'is_insert', '是否为插入字段（1是）', 'char(1)', 'String', 'isInsert', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2410, '202', 'is_edit', '是否编辑字段（1是）', 'char(1)', 'String', 'isEdit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2411, '202', 'is_list', '是否列表字段（1是）', 'char(1)', 'String', 'isList', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2412, '202', 'is_query', '是否查询字段（1是）', 'char(1)', 'String', 'isQuery', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2413, '202', 'query_type', '查询方式（等于、不等于、大于、小于、范围）', 'varchar(200)', 'String', 'queryType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 15, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2414, '202', 'html_type', '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）', 'varchar(200)', 'String', 'htmlType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 16, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2415, '202', 'dict_type', '字典类型', 'varchar(200)', 'String', 'dictType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 17, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2416, '202', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2417, '202', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 19, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2418, '202', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 20, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2419, '202', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 21, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2420, '202', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 22, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2421, '203', 'config_id', '参数主键', 'int(5)', 'Integer', 'configId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2422, '203', 'config_name', '参数名称', 'varchar(100)', 'String', 'configName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2423, '203', 'config_key', '参数键名', 'varchar(100)', 'String', 'configKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2424, '203', 'config_value', '参数键值', 'varchar(500)', 'String', 'configValue', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2425, '203', 'config_type', '系统内置（Y是 N否）', 'char(1)', 'String', 'configType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2426, '203', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2427, '203', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2428, '203', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2429, '203', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2430, '203', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 10, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2431, '204', 'dept_id', '部门id', 'bigint(20)', 'Long', 'deptId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2432, '204', 'parent_id', '父部门id', 'bigint(20)', 'Long', 'parentId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2433, '204', 'ancestors', '祖级列表', 'varchar(50)', 'String', 'ancestors', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2434, '204', 'dept_name', '部门名称', 'varchar(30)', 'String', 'deptName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2435, '204', 'order_num', '显示顺序', 'int(4)', 'Integer', 'orderNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2436, '204', 'leader', '负责人', 'varchar(20)', 'String', 'leader', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2437, '204', 'phone', '联系电话', 'varchar(11)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2438, '204', 'email', '邮箱', 'varchar(50)', 'String', 'email', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2439, '204', 'status', '部门状态（0正常 1停用）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2440, '204', 'del_flag', '删除标志（0代表存在 2代表删除）', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2441, '204', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2442, '204', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2443, '204', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2444, '204', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2019-09-19 17:18:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2445, '205', 'dict_code', '字典编码', 'bigint(20)', 'Long', 'dictCode', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2446, '205', 'dict_sort', '字典排序', 'int(4)', 'Integer', 'dictSort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2447, '205', 'dict_label', '字典标签', 'varchar(100)', 'String', 'dictLabel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2448, '205', 'dict_value', '字典键值', 'varchar(100)', 'String', 'dictValue', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2449, '205', 'dict_type', '字典类型', 'varchar(100)', 'String', 'dictType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2450, '205', 'css_class', '样式属性（其他样式扩展）', 'varchar(100)', 'String', 'cssClass', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2451, '205', 'list_class', '表格回显样式', 'varchar(100)', 'String', 'listClass', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2452, '205', 'is_default', '是否默认（Y是 N否）', 'char(1)', 'String', 'isDefault', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2453, '205', 'status', '状态（0正常 1停用）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2454, '205', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2455, '205', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2456, '205', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2457, '205', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2458, '205', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 14, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2459, '206', 'dict_id', '字典主键', 'bigint(20)', 'Long', 'dictId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2460, '206', 'dict_name', '字典名称', 'varchar(100)', 'String', 'dictName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2461, '206', 'dict_type', '字典类型', 'varchar(100)', 'String', 'dictType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2462, '206', 'status', '状态（0正常 1停用）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2463, '206', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2464, '206', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2465, '206', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2466, '206', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2467, '206', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2468, '207', 'job_id', '任务ID', 'bigint(20)', 'Long', 'jobId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2469, '207', 'job_name', '任务名称', 'varchar(64)', 'String', 'jobName', '1', '0', NULL, '1', NULL, NULL, NULL, 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2470, '207', 'job_group', '任务组名', 'varchar(64)', 'String', 'jobGroup', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2471, '207', 'invoke_target', '调用目标字符串', 'varchar(500)', 'String', 'invokeTarget', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2472, '207', 'cron_expression', 'cron执行表达式', 'varchar(255)', 'String', 'cronExpression', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2473, '207', 'misfire_policy', '计划执行错误策略（1立即执行 2执行一次 3放弃执行）', 'varchar(20)', 'String', 'misfirePolicy', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2474, '207', 'concurrent', '是否并发执行（0允许 1禁止）', 'char(1)', 'String', 'concurrent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2475, '207', 'status', '状态（0正常 1暂停）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2476, '207', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2477, '207', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2478, '207', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2479, '207', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2480, '207', 'remark', '备注信息', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 13, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2481, '208', 'job_log_id', '任务日志ID', 'bigint(20)', 'Long', 'jobLogId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2482, '208', 'job_name', '任务名称', 'varchar(64)', 'String', 'jobName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2483, '208', 'job_group', '任务组名', 'varchar(64)', 'String', 'jobGroup', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2484, '208', 'invoke_target', '调用目标字符串', 'varchar(500)', 'String', 'invokeTarget', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2485, '208', 'job_message', '日志信息', 'varchar(500)', 'String', 'jobMessage', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2486, '208', 'status', '执行状态（0正常 1失败）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2487, '208', 'exception_info', '异常信息', 'varchar(2000)', 'String', 'exceptionInfo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2488, '208', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2489, '209', 'info_id', '访问ID', 'bigint(20)', 'Long', 'infoId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2490, '209', 'login_name', '登录账号', 'varchar(50)', 'String', 'loginName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2491, '209', 'ipaddr', '登录IP地址', 'varchar(50)', 'String', 'ipaddr', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2492, '209', 'login_location', '登录地点', 'varchar(255)', 'String', 'loginLocation', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2493, '209', 'browser', '浏览器类型', 'varchar(50)', 'String', 'browser', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2494, '209', 'os', '操作系统', 'varchar(50)', 'String', 'os', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2495, '209', 'status', '登录状态（0成功 1失败）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2496, '209', 'msg', '提示消息', 'varchar(255)', 'String', 'msg', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2497, '209', 'login_time', '访问时间', 'datetime', 'Date', 'loginTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2498, '210', 'menu_id', '菜单ID', 'bigint(20)', 'Long', 'menuId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2499, '210', 'menu_name', '菜单名称', 'varchar(50)', 'String', 'menuName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2500, '210', 'parent_id', '父菜单ID', 'bigint(20)', 'Long', 'parentId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2501, '210', 'order_num', '显示顺序', 'int(4)', 'Integer', 'orderNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2502, '210', 'url', '请求地址', 'varchar(200)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2503, '210', 'target', '打开方式（menuItem页签 menuBlank新窗口）', 'varchar(20)', 'String', 'target', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2504, '210', 'menu_type', '菜单类型（M目录 C菜单 F按钮）', 'char(1)', 'String', 'menuType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2505, '210', 'visible', '菜单状态（0显示 1隐藏）', 'char(1)', 'String', 'visible', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2506, '210', 'perms', '权限标识', 'varchar(100)', 'String', 'perms', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2507, '210', 'icon', '菜单图标', 'varchar(100)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2508, '210', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2509, '210', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2510, '210', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2511, '210', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2512, '210', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 15, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2513, '211', 'notice_id', '公告ID', 'int(4)', 'Integer', 'noticeId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2514, '211', 'notice_title', '公告标题', 'varchar(50)', 'String', 'noticeTitle', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2515, '211', 'notice_type', '公告类型（1通知 2公告）', 'char(1)', 'String', 'noticeType', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2516, '211', 'notice_content', '公告内容', 'varchar(2000)', 'String', 'noticeContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2517, '211', 'status', '公告状态（0正常 1关闭）', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2518, '211', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2519, '211', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2520, '211', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2521, '211', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2522, '211', 'remark', '备注', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2523, '212', 'oper_id', '日志主键', 'bigint(20)', 'Long', 'operId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2524, '212', 'title', '模块标题', 'varchar(50)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2525, '212', 'business_type', '业务类型（0其它 1新增 2修改 3删除）', 'int(2)', 'Integer', 'businessType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2526, '212', 'method', '方法名称', 'varchar(100)', 'String', 'method', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2527, '212', 'request_method', '请求方式', 'varchar(10)', 'String', 'requestMethod', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2528, '212', 'operator_type', '操作类别（0其它 1后台用户 2手机端用户）', 'int(1)', 'Integer', 'operatorType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2529, '212', 'oper_name', '操作人员', 'varchar(50)', 'String', 'operName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2530, '212', 'dept_name', '部门名称', 'varchar(50)', 'String', 'deptName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2531, '212', 'oper_url', '请求URL', 'varchar(255)', 'String', 'operUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2532, '212', 'oper_ip', '主机地址', 'varchar(50)', 'String', 'operIp', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2533, '212', 'oper_location', '操作地点', 'varchar(255)', 'String', 'operLocation', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2534, '212', 'oper_param', '请求参数', 'varchar(2000)', 'String', 'operParam', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 12, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2535, '212', 'status', '操作状态（0正常 1异常）', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2536, '212', 'error_msg', '错误消息', 'varchar(2000)', 'String', 'errorMsg', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 14, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2537, '212', 'oper_time', '操作时间', 'datetime', 'Date', 'operTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 15, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2538, '213', 'post_id', '岗位ID', 'bigint(20)', 'Long', 'postId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2539, '213', 'post_code', '岗位编码', 'varchar(64)', 'String', 'postCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2540, '213', 'post_name', '岗位名称', 'varchar(50)', 'String', 'postName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2541, '213', 'post_sort', '显示顺序', 'int(4)', 'Integer', 'postSort', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2542, '213', 'status', '状态（0正常 1停用）', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2543, '213', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2544, '213', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2545, '213', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2546, '213', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2547, '213', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2548, '214', 'role_id', '角色ID', 'bigint(20)', 'Long', 'roleId', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2549, '214', 'role_name', '角色名称', 'varchar(30)', 'String', 'roleName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2550, '214', 'role_key', '角色权限字符串', 'varchar(100)', 'String', 'roleKey', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2551, '214', 'role_sort', '显示顺序', 'int(4)', 'Integer', 'roleSort', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2552, '214', 'data_scope', '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）', 'char(1)', 'String', 'dataScope', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2553, '214', 'status', '角色状态（0正常 1停用）', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2554, '214', 'del_flag', '删除标志（0代表存在 2代表删除）', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2555, '214', 'create_by', '创建者', 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2556, '214', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2557, '214', 'update_by', '更新者', 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2558, '214', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2559, '214', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 12, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2560, '215', 'role_id', '角色ID', 'bigint(20)', 'Long', 'roleId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2561, '215', 'dept_id', '部门ID', 'bigint(20)', 'Long', 'deptId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:18:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2562, '216', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2563, '216', 'name', '品牌商名称', 'varchar(255)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2564, '216', 'descs', '品牌商简介', 'varchar(255)', 'String', 'descs', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2565, '216', 'pic_url', '品牌商页的品牌商图片', 'varchar(255)', 'String', 'picUrl', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2566, '216', 'sort_order', NULL, 'tinyint(3)', 'Integer', 'sortOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2567, '216', 'floor_price', '品牌商的商品低价，仅用于页面展示', 'decimal(10,2)', 'Double', 'floorPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2568, '216', 'add_time', '创建时间', 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2569, '216', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2570, '216', 'deleted', '逻辑删除', 'tinyint(1)', 'Integer', 'deleted', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2571, '217', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2572, '217', 'name', '类目名称', 'varchar(63)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2573, '217', 'keywords', '类目关键字，以JSON数组格式', 'varchar(1023)', 'String', 'keywords', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2574, '217', 'descs', '类目广告语介绍', 'varchar(255)', 'String', 'descs', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2575, '217', 'pid', '父类目ID', 'int(11)', 'Long', 'pid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2576, '217', 'icon_url', '类目图标', 'varchar(255)', 'String', 'iconUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2577, '217', 'pic_url', '类目图片', 'varchar(255)', 'String', 'picUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2578, '217', 'level', NULL, 'varchar(255)', 'String', 'level', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2579, '217', 'sort_order', '排序', 'tinyint(3)', 'Integer', 'sortOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2580, '217', 'add_time', '创建时间', 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2581, '217', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2582, '217', 'deleted', '逻辑删除', 'tinyint(1)', 'Integer', 'deleted', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2583, '218', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2584, '218', 'goods_sn', '商品编号', 'varchar(63)', 'String', 'goodsSn', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2585, '218', 'name', '商品名称', 'varchar(127)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2586, '218', 'category_id', '商品所属类目ID', 'int(11)', 'Long', 'categoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2587, '218', 'brand_id', NULL, 'int(11)', 'Long', 'brandId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2588, '218', 'gallery', '商品宣传图片列表，采用JSON数组格式', 'varchar(1023)', 'String', 'gallery', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2589, '218', 'keywords', '商品关键字，采用逗号间隔', 'varchar(255)', 'String', 'keywords', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2590, '218', 'brief', '商品简介', 'varchar(255)', 'String', 'brief', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2591, '218', 'is_on_sale', '是否上架', 'tinyint(1)', 'Integer', 'isOnSale', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2592, '218', 'sort_order', NULL, 'smallint(4)', 'Integer', 'sortOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2593, '218', 'pic_url', '商品页面商品图片', 'varchar(255)', 'String', 'picUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2594, '218', 'share_url', '商品分享朋友圈图片', 'varchar(255)', 'String', 'shareUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2595, '218', 'is_new', '是否新品首发，如果设置则可以在新品首发页面展示', 'tinyint(1)', 'Integer', 'isNew', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2596, '218', 'is_hot', '是否人气推荐，如果设置则可以在人气推荐页面展示', 'tinyint(1)', 'Integer', 'isHot', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2597, '218', 'unit', '商品单位，例如件、盒', 'varchar(31)', 'String', 'unit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2598, '218', 'counter_price', '专柜价格', 'decimal(10,2)', 'Double', 'counterPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2599, '218', 'retail_price', '零售价格', 'decimal(10,2)', 'Double', 'retailPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2600, '218', 'detail', '商品详细介绍，是富文本格式', 'text', 'String', 'detail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2601, '218', 'add_time', '创建时间', 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 19, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2602, '218', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 20, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2603, '218', 'deleted', '逻辑删除', 'tinyint(1)', 'Integer', 'deleted', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2604, '219', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2605, '219', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2606, '219', 'product_name', NULL, 'varchar(64)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2607, '219', 'recommend_status', NULL, 'int(1)', 'Integer', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2608, '219', 'sort', NULL, 'int(1)', 'Integer', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2609, '219', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2610, '220', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2611, '220', 'subject_id', NULL, 'bigint(20)', 'Long', 'subjectId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2612, '220', 'subject_name', NULL, 'varchar(64)', 'String', 'subjectName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2613, '220', 'recommend_status', NULL, 'int(1)', 'Integer', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2614, '220', 'sort', NULL, 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2615, '220', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2616, '221', 'id', '红包编号', 'int(12)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2617, '221', 'user_id', '发红包的用户id', 'bigint(12)', 'Long', 'userId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2618, '221', 'amount', '红包金额', 'decimal(16,2)', 'Double', 'amount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2619, '221', 'send_date', '发红包日期', 'date', 'Date', 'sendDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2620, '221', 'total', '红包总数', 'int(12)', 'Long', 'total', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2621, '221', 'unit_amount', '单个红包的金额', 'decimal(12,0)', 'Long', 'unitAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2622, '221', 'stock', '红包剩余个数', 'int(12)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2623, '221', 'type', '红包类型', 'int(12)', 'Long', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2624, '221', 'note', '备注', 'varchar(256)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2625, '221', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2626, '222', 'id', '用户红包编号', 'int(12)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2627, '222', 'red_packet_id', '红包编号', 'int(12)', 'Long', 'redPacketId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2628, '222', 'admin_id', '发红包用户的编号', 'bigint(12)', 'Long', 'adminId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2629, '222', 'user_id', '抢红包用户的编号', 'bigint(12)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2630, '222', 'amount', '抢到的红包金额', 'decimal(16,2)', 'Double', 'amount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2631, '222', 'grab_time', '抢红包时间', 'date', 'Date', 'grabTime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2632, '222', 'note', '备注', 'varchar(256)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2633, '222', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2634, '223', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2635, '223', 'user_id', '用户编号', 'bigint(20)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2636, '223', 'user_name', '用户名', 'varchar(55)', 'String', 'userName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2637, '223', 'service_name', '模块名', 'varchar(100)', 'String', 'serviceName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2638, '223', 'method', '记录类名+方法名', 'varchar(255)', 'String', 'method', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2639, '223', 'operation_desc', '描述', 'varchar(255)', 'String', 'operationDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2640, '223', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2641, '223', 'ip', 'IP', 'varchar(100)', 'String', 'ip', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2642, '223', 'params', '参数', 'varchar(3000)', 'String', 'params', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2643, '223', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2644, '223', 'time_min', NULL, 'bigint(20)', 'Long', 'timeMin', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2645, '224', 'appid', NULL, 'varchar(255)', 'String', 'appid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2646, '224', 'appsecret', NULL, 'varchar(255)', 'String', 'appsecret', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2647, '224', 'mchid', NULL, 'varchar(255)', 'String', 'mchid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2648, '224', 'pay_sign_key', NULL, 'varchar(255)', 'String', 'paySignKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2649, '224', 'certname', NULL, 'varchar(255)', 'String', 'certname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2650, '224', 'notifyurl', NULL, 'varchar(255)', 'String', 'notifyurl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2651, '224', 'templateid1', '下单通知模版', 'varchar(255)', 'String', 'templateid1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2652, '224', 'templateid2', '支付成功模版', 'varchar(255)', 'String', 'templateid2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2653, '224', 'templateid3', NULL, 'varchar(255)', 'String', 'templateid3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2654, '224', 'templateid4', NULL, 'varchar(255)', 'String', 'templateid4', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2655, '224', 'templateid5', NULL, 'varchar(255)', 'String', 'templateid5', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2656, '224', 'templateid6', NULL, 'varchar(255)', 'String', 'templateid6', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2657, '224', 'store_id', NULL, 'bigint(20)', 'Long', 'storeId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2658, '225', 'id', NULL, 'bigint(20)', 'Long', 'id', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2659, '225', 'pid', NULL, 'bigint(20)', 'Long', 'pid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2660, '225', 'deep', '层级', 'int(11)', 'Long', 'deep', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2661, '225', 'name', '名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2662, '225', 'pinyin_prefix', '拼音前缀', 'varchar(255)', 'String', 'pinyinPrefix', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2663, '225', 'pinyin', '拼音', 'varchar(255)', 'String', 'pinyin', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2664, '225', 'ext_id', '备注名', 'varchar(255)', 'String', 'extId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2665, '225', 'ext_name', '备注名', 'varchar(255)', 'String', 'extName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2666, '225', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2667, '226', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2668, '226', 'keyname', '标签', 'varchar(50)', 'String', 'keyname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2669, '226', 'valuename', '值', 'varchar(2000)', 'String', 'valuename', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'textarea', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2670, '226', 'status', '状态   0：隐藏   1：显示', 'tinyint(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2671, '226', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2672, '226', 'type', '类型', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2673, '226', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2674, '227', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2675, '227', 'obj_id', NULL, 'bigint(20)', 'Long', 'objId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2676, '227', 'type', '1 会员区域 2 会员学校', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2677, '227', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2678, '228', 'id', NULL, 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2679, '228', 'user_id', '用户id', 'int(10)', 'Integer', 'userId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2680, '228', 'code', '消息编码', 'varchar(60)', 'String', 'code', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2681, '228', 'params', '参数', 'varchar(5000)', 'String', 'params', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2682, '228', 'content', '内容', 'text', 'String', 'content', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2683, '228', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2684, '228', 'utime', '查看时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2685, '228', 'status', '1未查看，2已查看', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2686, '228', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2687, '229', 'id', NULL, 'int(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2688, '229', 'title', '公告标题', 'varchar(200)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2689, '229', 'content', '公告内容', 'longtext', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2690, '229', 'type', '公告类型', 'tinyint(1) unsigned', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2691, '229', 'ctime', '创建时间 毫秒', 'bigint(12)', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2692, '229', 'sort', '排序 从小到大', 'tinyint(3) unsigned', 'Integer', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2693, '229', 'isdel', '软删除位  有时间代表已删除', 'bigint(12) unsigned', 'Long', 'isdel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2694, '229', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2695, '230', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2696, '230', 'pid', '父级权限id', 'bigint(20)', 'Long', 'pid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2697, '230', 'name', '名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2698, '230', 'value', '权限值', 'varchar(200)', 'String', 'value', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2699, '230', 'icon', '图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2700, '230', 'type', '权限类型：0->目录；1->菜单；2->按钮（接口绑定权限）', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2701, '230', 'uri', '前端资源路径', 'varchar(200)', 'String', 'uri', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2702, '230', 'status', '启用状态；0->禁用；1->启用', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2703, '230', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2704, '230', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2705, '231', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2706, '231', 'name', '类型名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2707, '231', 'icon', '类型图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2708, '231', 'type_count', '类型数量', 'int(11)', 'Long', 'typeCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2709, '231', 'show_status', '状态', 'int(2)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2710, '231', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2711, '231', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2712, '232', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2713, '232', 'name', '名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2714, '232', 'description', '描述', 'varchar(500)', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2715, '232', 'admin_count', '后台用户数量', 'int(11)', 'Long', 'adminCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2716, '232', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2717, '232', 'status', '启用状态：0->禁用；1->启用', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2718, '232', 'sort', NULL, 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2719, '232', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2720, '233', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2721, '233', 'role_id', NULL, 'bigint(20)', 'Long', 'roleId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2722, '233', 'permission_id', NULL, 'bigint(20)', 'Long', 'permissionId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2723, '233', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2724, '234', 'id', NULL, 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2725, '234', 'longitude', '精度', 'varchar(40)', 'String', 'longitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2726, '234', 'latitude', '纬度', 'varchar(40)', 'String', 'latitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2727, '234', 'name', '名称', 'varchar(40)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2728, '234', 'province', '省', 'varchar(20)', 'String', 'province', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2729, '234', 'city', '市', 'varchar(20)', 'String', 'city', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2730, '234', 'region', '区', 'varchar(20)', 'String', 'region', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2731, '234', 'address', '地址', 'varchar(255)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2732, '234', 'hot', '1热门', 'int(11)', 'Long', 'hot', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2733, '234', 'is211', '211', 'int(11)', 'Long', 'is211', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2734, '234', 'is985', '985', 'int(11)', 'Long', 'is985', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2735, '234', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2736, '234', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2737, '235', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2738, '235', 'phone', '手机号码', 'varchar(16)', 'String', 'phone', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2739, '235', 'signName', NULL, 'varchar(128)', 'String', 'signname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2740, '235', 'templateCode', NULL, 'varchar(128)', 'String', 'templatecode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2741, '235', 'params', '参数', 'varchar(500)', 'String', 'params', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2742, '235', 'bizId', '阿里云返回的', 'varchar(128)', 'String', 'bizid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2743, '235', 'code', '阿里云返回的code', 'varchar(64)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2744, '235', 'message', '阿里云返回的', 'varchar(128)', 'String', 'message', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2745, '235', 'day', '日期', 'date', 'Date', 'day', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2746, '235', 'createTime', NULL, 'datetime', 'Date', 'createtime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2747, '235', 'updateTime', NULL, 'datetime', 'Date', 'updatetime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2748, '235', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2792, '237', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2793, '237', 'username', NULL, 'varchar(64)', 'String', 'username', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2794, '237', 'password', NULL, 'varchar(64)', 'String', 'password', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2795, '237', 'icon', '头像', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2796, '237', 'email', '邮箱', 'varchar(100)', 'String', 'email', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2797, '237', 'nick_name', '昵称', 'varchar(200)', 'String', 'nickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2798, '237', 'note', '备注信息', 'varchar(500)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2799, '237', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2800, '237', 'login_time', '最后登录时间', 'datetime', 'Date', 'loginTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2801, '237', 'status', '帐号启用状态：0->禁用；1->启用', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2802, '237', 'supply_id', '供应商', 'int(20)', 'Long', 'supplyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2803, '237', 'store_id', '所属店铺', 'bigint(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2804, '238', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2805, '238', 'admin_id', NULL, 'bigint(20)', 'Long', 'adminId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2806, '238', 'permission_id', NULL, 'bigint(20)', 'Long', 'permissionId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2807, '238', 'type', NULL, 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2808, '238', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2809, '239', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2810, '239', 'admin_id', NULL, 'bigint(20)', 'Long', 'adminId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2811, '239', 'role_id', NULL, 'bigint(20)', 'Long', 'roleId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2812, '239', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2813, '240', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2814, '240', 'user_id', '用户编号', 'bigint(20)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2815, '240', 'user_name', '用户名', 'varchar(55)', 'String', 'userName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2816, '240', 'service_name', '模块名', 'varchar(100)', 'String', 'serviceName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2817, '240', 'method', '记录类名+方法名', 'varchar(255)', 'String', 'method', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2818, '240', 'operation_desc', '描述', 'varchar(955)', 'String', 'operationDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 6, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2819, '240', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2820, '240', 'ip', 'IP', 'varchar(100)', 'String', 'ip', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2821, '240', 'params', '参数', 'varchar(3000)', 'String', 'params', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 9, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2822, '240', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2823, '240', 'time_min', NULL, 'bigint(20)', 'Long', 'timeMin', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2824, '241', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2825, '241', 'template_id', '小程序模版ID', 'varchar(64)', 'String', 'templateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2826, '241', 'task_name', '模版名称', 'varchar(64)', 'String', 'taskName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2827, '241', 'task_topic', '活动主题', 'varchar(64)', 'String', 'taskTopic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2828, '241', 'task_caption', '活动说明', 'varchar(200)', 'String', 'taskCaption', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2829, '241', 'task_tips', '温馨提示', 'varchar(64)', 'String', 'taskTips', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2830, '241', 'task_type', '任务类型', 'varchar(64)', 'String', 'taskType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2831, '241', 'status', '任务是否已经发送 1 未发送[默认] 2 已发送', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2832, '241', 'goods_id', '商品ID', 'int(11)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2833, '241', 'goods_name', '商品标题', 'varchar(64)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 10, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2834, '241', 'goods_online_status', '商品前台状态 1 上架 0 下架', 'int(2)', 'Integer', 'goodsOnlineStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 11, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2835, '241', 'price', '商品金额（需要的海贝数）', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2836, '241', 'is_upload', NULL, 'int(1)', 'Integer', 'isUpload', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2837, '241', 'file_name', NULL, 'varchar(64)', 'String', 'fileName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 14, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2838, '241', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2839, '241', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', '1', '1', '1', NULL, NULL, 'EQ', 'datetime', '', 16, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2840, '241', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2841, '242', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2842, '242', 'task_id', '推送ID', 'int(11)', 'Long', 'taskId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2843, '242', 'user_id', '用户ID', 'int(11)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2844, '242', 'form_id', '小程序推送formId', 'varchar(50)', 'String', 'formId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2845, '242', 'status', '推送状态 1 已推送 2 未推送', 'int(2)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2846, '242', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2847, '242', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2848, '242', 'note', '备注', 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2849, '242', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2850, '243', 'id', '类目ID', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2851, '243', 'name', '板块名称', 'varchar(50)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2852, '243', 'type', '类型 0轮播图 1板块种类一 2板块种类二 3板块种类三 ', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2853, '243', 'sort_order', '排列序号', 'int(4)', 'Integer', 'sortOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2854, '243', 'position', '所属位置 0首页 1商品推荐 2我要捐赠', 'int(1)', 'Integer', 'position', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2855, '243', 'limit_num', '板块限制商品数量', 'int(4)', 'Integer', 'limitNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2856, '243', 'status', '状态', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2857, '243', 'remark', '备注', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2858, '243', 'created', '创建时间', 'datetime', 'Date', 'created', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2859, '243', 'updated', '更新时间', 'datetime', 'Date', 'updated', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2860, '243', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2861, '244', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2862, '244', 'panel_id', '所属板块id', 'int(11)', 'Long', 'panelId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2863, '244', 'type', '类型 0关联商品 1其他链接', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2864, '244', 'product_id', '关联商品id', 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2865, '244', 'sort_order', NULL, 'int(4)', 'Integer', 'sortOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2866, '244', 'full_url', '其他链接', 'varchar(500)', 'String', 'fullUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2867, '244', 'pic_url', NULL, 'varchar(500)', 'String', 'picUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2868, '244', 'pic_url2', '3d轮播图备用', 'varchar(500)', 'String', 'picUrl2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2869, '244', 'pic_url3', '3d轮播图备用', 'varchar(500)', 'String', 'picUrl3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2870, '244', 'created', NULL, 'datetime', 'Date', 'created', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2871, '244', 'updated', NULL, 'datetime', 'Date', 'updated', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 11, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2872, '244', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2873, '245', 'id', NULL, 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2874, '245', 'user_id', '用户id', 'bigint(11)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2875, '245', 'form_id', '小程序推送formId', 'varchar(100)', 'String', 'formId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2876, '245', 'source', '来源 source 1，步数兑换海贝按钮；2，首页邀请按钮；3，步数拦截弹窗邀请按钮；4，兑换商品按钮；\\n\\n5，海贝不够邀请按钮；6，引导关注蒙层按钮；7，健康体验领取按钮 8，首页弹窗“马上领取”按钮', 'smallint(2)', 'Integer', 'source', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2877, '245', 'status', '使用状态 1 未使用[默认] 2 已使用', 'smallint(2)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2878, '245', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2879, '245', 'update_time', '修改时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2880, '245', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2881, '246', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2882, '246', 'member_id', '会员编号', 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2883, '246', 'goods_id', '商品编号', 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2884, '246', 'goods_name', '商品', 'varchar(255)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2885, '246', 'goods_pic', '图片', 'varchar(255)', 'String', 'goodsPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2886, '246', 'goods_price', '价格', 'varchar(255)', 'String', 'goodsPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2887, '246', 'type', '1 商品 2 文章', 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2888, '246', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2889, '246', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2890, '247', 'id', NULL, 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2891, '247', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2892, '247', 'age', NULL, 'int(11)', 'Long', 'age', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2893, '247', 'gender', NULL, 'varchar(255)', 'String', 'gender', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2894, '247', 'hobby', NULL, 'varchar(255)', 'String', 'hobby', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2895, '247', 'peoplenote', NULL, 'varchar(255)', 'String', 'peoplenote', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2896, '247', 'phone', NULL, 'varchar(255)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2897, '247', 'address', NULL, 'varchar(255)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2898, '247', 'guide1', NULL, 'varchar(255)', 'String', 'guide1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2899, '247', 'guide', NULL, 'varchar(255)', 'String', 'guide', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2900, '247', 'suggestion', NULL, 'varchar(255)', 'String', 'suggestion', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2901, '247', 'guide2', NULL, 'varchar(255)', 'String', 'guide2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2902, '247', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2903, '247', 'store_id', NULL, 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2904, '248', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2905, '248', 'member_id', '会员编号', 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2906, '248', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2907, '248', 'change_type', '改变类别', 'int(1)', 'Integer', 'changeType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jifen_change_type', 4, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2908, '248', 'change_count', '数量', 'int(11)', 'Long', 'changeCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2909, '248', 'operate_man', '操作人员', 'varchar(100)', 'String', 'operateMan', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2910, '248', 'operate_note', '操作备注', 'varchar(200)', 'String', 'operateNote', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2911, '248', 'source_type', '积分来源', 'int(1)', 'Integer', 'sourceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jifen_source', 8, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2912, '248', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:36:26');
INSERT INTO `admin_gen_table_column` VALUES (2913, '249', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2914, '249', 'member_id', '会员编号', 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2915, '249', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, NULL, NULL, '1', '1', 'BETWEEN', 'datetime', '', 3, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2916, '249', 'change_type', '改变类型', 'int(1)', 'Integer', 'changeType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jifen_change_type', 4, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2917, '249', 'change_count', '数量', 'int(11)', 'Long', 'changeCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2918, '249', 'operate_man', '操作人员', 'varchar(100)', 'String', 'operateMan', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2919, '249', 'operate_note', '操作备注', 'varchar(200)', 'String', 'operateNote', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2920, '249', 'source_type', '积分来源', 'int(1)', 'Integer', 'sourceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jifen_source', 8, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2921, '249', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:38:50');
INSERT INTO `admin_gen_table_column` VALUES (2922, '250', 'id', 'null', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:39:13');
INSERT INTO `admin_gen_table_column` VALUES (2923, '250', 'deduction_per_amount', '每一元需要抵扣的积分数量', 'int(11)', 'Long', 'deductionPerAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:39:13');
INSERT INTO `admin_gen_table_column` VALUES (2924, '250', 'max_percent_per_order', '每笔订单最高抵用百分比', 'int(11)', 'Long', 'maxPercentPerOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:39:13');
INSERT INTO `admin_gen_table_column` VALUES (2925, '250', 'use_unit', '每次使用积分最小单位100', 'int(11)', 'Long', 'useUnit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:39:13');
INSERT INTO `admin_gen_table_column` VALUES (2926, '250', 'coupon_status', '是否可以和优惠券同用；0-&gt;不可以；1-&gt;可以', 'int(1)', 'Integer', 'couponStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:39:13');
INSERT INTO `admin_gen_table_column` VALUES (2927, '250', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:39:13');
INSERT INTO `admin_gen_table_column` VALUES (2928, '251', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2929, '251', 'member_level_id', NULL, 'bigint(20)', 'Long', 'memberLevelId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2930, '251', 'username', '用户名', 'varchar(64)', 'String', 'username', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2931, '251', 'password', '密码', 'varchar(64)', 'String', 'password', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2932, '251', 'nickname', '昵称', 'varchar(64)', 'String', 'nickname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2933, '251', 'phone', '手机号码', 'varchar(64)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2934, '251', 'status', '帐号启用状态:0->禁用；1->启用', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2935, '251', 'create_time', '注册时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2936, '251', 'icon', '头像', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 9, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2937, '251', 'gender', '性别：0->未知；1->男；2->女', 'int(1)', 'Integer', 'gender', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2938, '251', 'birthday', '生日', 'date', 'Date', 'birthday', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 11, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2939, '251', 'city', '所做城市', 'varchar(64)', 'String', 'city', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2940, '251', 'job', '职业', 'varchar(100)', 'String', 'job', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2941, '251', 'personalized_signature', '个性签名', 'varchar(200)', 'String', 'personalizedSignature', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2942, '251', 'source_type', '用户来源 1 小程序 2 公众号 3 页面', 'int(1)', 'Integer', 'sourceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 15, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2943, '251', 'integration', '积分', 'int(11)', 'Long', 'integration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2944, '251', 'growth', '成长值', 'int(11)', 'Long', 'growth', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2945, '251', 'luckey_count', '剩余抽奖次数', 'int(11)', 'Long', 'luckeyCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2946, '251', 'history_integration', '历史积分数量', 'int(11)', 'Long', 'historyIntegration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2947, '251', 'avatar', NULL, 'varchar(255)', 'String', 'avatar', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2948, '251', 'weixin_openid', NULL, 'varchar(50)', 'String', 'weixinOpenid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2949, '251', 'invitecode', NULL, 'bigint(20)', 'Long', 'invitecode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2950, '251', 'blance', '余额', 'decimal(10,0)', 'Long', 'blance', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 23, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2951, '251', 'school_id', NULL, 'bigint(20)', 'Long', 'schoolId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2952, '251', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2953, '251', 'area_id', NULL, 'bigint(20)', 'Long', 'areaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 26, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2954, '251', 'school_name', NULL, 'varchar(255)', 'String', 'schoolName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 27, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2955, '251', 'area_name', NULL, 'varchar(255)', 'String', 'areaName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 28, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2956, '251', 'buy_count', NULL, 'int(11)', 'Long', 'buyCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 29, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2957, '251', 'buy_money', NULL, 'decimal(10,0)', 'Long', 'buyMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 30, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2958, '251', 'member_level_name', NULL, 'varchar(255)', 'String', 'memberLevelName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 31, 'admin', '2019-09-19 17:20:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2959, '252', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2960, '252', 'member_id', '会员编号', 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, NULL, NULL, '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2961, '252', 'price', '价格', 'decimal(11,0)', 'Long', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2962, '252', 'type', '类别', 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'blance_type', 4, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2963, '252', 'note', '记录', 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2964, '252', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2965, '252', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:42:22');
INSERT INTO `admin_gen_table_column` VALUES (2966, '253', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:26');
INSERT INTO `admin_gen_table_column` VALUES (2967, '253', 'name', '名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2968, '253', 'growth_point', '送积分', 'int(11)', 'Long', 'growthPoint', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2969, '253', 'default_status', '是否为默认等级：0-&gt;不是；1-&gt;是', 'int(1)', 'Integer', 'defaultStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', 'sys_yes_no', 4, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2970, '253', 'free_freight_point', '免运费标准', 'decimal(10,2)', 'Double', 'freeFreightPoint', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2971, '253', 'comment_growth_point', '每次评价获取的成长值', 'int(11)', 'Long', 'commentGrowthPoint', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2972, '253', 'priviledge_free_freight', '是否有免邮特权', 'int(1)', 'Integer', 'priviledgeFreeFreight', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2973, '253', 'priviledge_sign_in', '是否有签到特权', 'int(1)', 'Integer', 'priviledgeSignIn', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2974, '253', 'priviledge_comment', '是否有评论获奖励特权', 'int(1)', 'Integer', 'priviledgeComment', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2975, '253', 'priviledge_promotion', '是否有专享活动特权', 'int(1)', 'Integer', 'priviledgePromotion', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2976, '253', 'priviledge_member_price', '是否有会员价格特权', 'int(1)', 'Integer', 'priviledgeMemberPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2977, '253', 'priviledge_birthday', '是否有生日特权', 'int(1)', 'Integer', 'priviledgeBirthday', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2978, '253', 'articlecount', '可发文章数', 'int(1)', 'Integer', 'articlecount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2979, '253', 'goodscount', '可发商品数', 'int(1)', 'Integer', 'goodscount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2980, '253', 'price', '成为会员的价格', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 15, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2981, '253', 'note', '记录', 'varchar(200)', 'String', 'note', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 16, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2982, '253', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 17, 'admin', '2019-09-19 17:20:43', NULL, '2020-03-04 09:44:27');
INSERT INTO `admin_gen_table_column` VALUES (2983, '254', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2984, '254', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2985, '254', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2986, '254', 'ip', NULL, 'varchar(64)', 'String', 'ip', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2987, '254', 'city', NULL, 'varchar(64)', 'String', 'city', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2988, '254', 'login_type', '登录类型：0->PC；1->android;2->ios;3->小程序', 'int(1)', 'Integer', 'loginType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2989, '254', 'province', NULL, 'varchar(64)', 'String', 'province', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2990, '254', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2991, '255', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2992, '255', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2993, '255', 'tag_id', NULL, 'bigint(20)', 'Long', 'tagId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2994, '255', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2995, '255', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2996, '256', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2997, '256', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2998, '256', 'product_category_id', NULL, 'bigint(20)', 'Long', 'productCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (2999, '256', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3000, '257', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:16');
INSERT INTO `admin_gen_table_column` VALUES (3001, '257', 'member_id', '会员编号', 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:16');
INSERT INTO `admin_gen_table_column` VALUES (3002, '257', 'name', '收货人名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3003, '257', 'phone_number', '手机', 'varchar(64)', 'String', 'phoneNumber', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3004, '257', 'default_status', '是否为默认', 'int(1)', 'Integer', 'defaultStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', 'sys_yes_no', 5, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3005, '257', 'post_code', '邮政编码', 'varchar(100)', 'String', 'postCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3006, '257', 'province', '省份/直辖市', 'varchar(100)', 'String', 'province', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3007, '257', 'city', '城市', 'varchar(100)', 'String', 'city', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3008, '257', 'region', '区', 'varchar(100)', 'String', 'region', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3009, '257', 'detail_address', '详细地址(街道)', 'varchar(128)', 'String', 'detailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3010, '257', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, '1', NULL, NULL, 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:21:17');
INSERT INTO `admin_gen_table_column` VALUES (3011, '258', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3012, '258', 'continue_sign_day', '连续签到天数', 'int(11)', 'Long', 'continueSignDay', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3013, '258', 'continue_sign_point', '连续签到赠送数量', 'int(11)', 'Long', 'continueSignPoint', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3014, '258', 'consume_per_point', '每消费多少元获取1个点', 'decimal(10,2)', 'Double', 'consumePerPoint', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3015, '258', 'low_order_amount', '最低获取点数的订单金额', 'decimal(10,2)', 'Double', 'lowOrderAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3016, '258', 'max_point_per_order', '每笔订单最高获取点数', 'int(11)', 'Long', 'maxPointPerOrder', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3017, '258', 'type', '类型：0->积分规则；1->成长值规则', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3018, '258', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3019, '259', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3020, '259', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3021, '259', 'consume_amount', '累计消费金额', 'decimal(10,2)', 'Double', 'consumeAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3022, '259', 'order_count', '订单数量', 'int(11)', 'Long', 'orderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3023, '259', 'coupon_count', '优惠券数量', 'int(11)', 'Long', 'couponCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3024, '259', 'comment_count', '评价数', 'int(11)', 'Long', 'commentCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3025, '259', 'return_order_count', '退货数量', 'int(11)', 'Long', 'returnOrderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3026, '259', 'login_count', '登录次数', 'int(11)', 'Long', 'loginCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3027, '259', 'attend_count', '关注数量', 'int(11)', 'Long', 'attendCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3028, '259', 'fans_count', '粉丝数量', 'int(11)', 'Long', 'fansCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3029, '259', 'collect_product_count', NULL, 'int(11)', 'Long', 'collectProductCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3030, '259', 'collect_subject_count', NULL, 'int(11)', 'Long', 'collectSubjectCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3031, '259', 'collect_topic_count', NULL, 'int(11)', 'Long', 'collectTopicCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3032, '259', 'collect_comment_count', NULL, 'int(11)', 'Long', 'collectCommentCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3033, '259', 'invite_friend_count', NULL, 'int(11)', 'Long', 'inviteFriendCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3034, '259', 'recent_order_time', '最后一次下订单时间', 'datetime', 'Date', 'recentOrderTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 16, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3035, '259', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3036, '260', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:26:23');
INSERT INTO `admin_gen_table_column` VALUES (3037, '260', 'name', '名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:26:23');
INSERT INTO `admin_gen_table_column` VALUES (3038, '260', 'type', '标签类别', 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'tag_type', 3, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:26:23');
INSERT INTO `admin_gen_table_column` VALUES (3039, '260', 'gen_type', '标签生成类别', 'int(10)', 'Integer', 'genType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'tag_gen_type', 4, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:26:23');
INSERT INTO `admin_gen_table_column` VALUES (3040, '260', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'datetime', '', 5, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:26:23');
INSERT INTO `admin_gen_table_column` VALUES (3041, '260', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', NULL, '2020-03-04 09:26:23');
INSERT INTO `admin_gen_table_column` VALUES (3042, '261', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3043, '261', 'name', NULL, 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3044, '261', 'growth', '赠送成长值', 'int(11)', 'Long', 'growth', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3045, '261', 'intergration', '赠送积分', 'int(11)', 'Long', 'intergration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3046, '261', 'type', '任务类型：0->新手任务；1->日常任务', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3047, '261', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3048, '262', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3049, '262', 'send_member_id', NULL, 'bigint(20)', 'Long', 'sendMemberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3050, '262', 'rec_member_id', NULL, 'bigint(20)', 'Long', 'recMemberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3051, '262', 'coin', NULL, 'int(11)', 'Long', 'coin', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3052, '262', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3053, '262', 'objid', NULL, 'bigint(20)', 'Long', 'objid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3054, '262', 'member_nick_name', '昵称', 'varchar(36)', 'String', 'memberNickName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3055, '262', 'member_icon', '图像', 'varchar(36)', 'String', 'memberIcon', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3056, '262', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3057, '263', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3058, '263', 'send_member_id', NULL, 'bigint(20)', 'Long', 'sendMemberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3059, '263', 'rec_member_id', NULL, 'bigint(20)', 'Long', 'recMemberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3060, '263', 'coin', NULL, 'varchar(255)', 'String', 'coin', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3061, '263', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3062, '264', 'id', 'ID号', 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3063, '264', 'user_id', '用户ID', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3064, '264', 'bank_name', '银行名称', 'varchar(60)', 'String', 'bankName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3065, '264', 'bank_code', '银行缩写', 'varchar(12)', 'String', 'bankCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3066, '264', 'bank_area_id', '账号地区ID', 'int(10) unsigned', 'Integer', 'bankAreaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3067, '264', 'account_bank', '开户行', 'varchar(255)', 'String', 'accountBank', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3068, '264', 'account_name', '账户名', 'varchar(60)', 'String', 'accountName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3069, '264', 'card_number', '卡号', 'varchar(30)', 'String', 'cardNumber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3070, '264', 'card_type', '银行卡类型: 1=储蓄卡 2=信用卡', 'tinyint(1)', 'Integer', 'cardType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 9, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3071, '264', 'is_default', '默认卡 1=默认 2=不默认', 'tinyint(1) unsigned', 'Integer', 'isDefault', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3072, '264', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3073, '264', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3074, '264', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3075, '265', 'id', 'ID号', 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3076, '265', 'user_id', '用户ID', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3077, '265', 'money', '提现金额', 'decimal(8,2) unsigned', 'Double', 'money', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3078, '265', 'bank_name', '银行名称', 'varchar(60)', 'String', 'bankName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3079, '265', 'bank_code', '银行缩写', 'varchar(12)', 'String', 'bankCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3080, '265', 'bank_area_id', '账号地区ID', 'int(10) unsigned', 'Integer', 'bankAreaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3081, '265', 'account_bank', '开户行', 'varchar(255)', 'String', 'accountBank', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3082, '265', 'account_name', '账户名', 'varchar(60)', 'String', 'accountName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3083, '265', 'card_number', '卡号', 'varchar(30)', 'String', 'cardNumber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3084, '265', 'withdrawals', '提现服务费', 'decimal(8,2) unsigned', 'Double', 'withdrawals', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3085, '265', 'type', '1默认，2提现成功，3提现失败', 'smallint(1) unsigned', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 11, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3086, '265', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3087, '265', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3088, '265', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-19 17:20:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3089, '266', 'spot_trans_id', NULL, 'bigint(200)', 'Long', 'spotTransId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3090, '266', 'exch_symbol_id', '交易对ID', 'varchar(32)', 'String', 'exchSymbolId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3091, '266', 'symbol', '交易对名称', 'varchar(50)', 'String', 'symbol', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3092, '266', 'side', '下单方向（1-买，2-卖）', 'tinyint(1)', 'Integer', 'side', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3093, '266', 'trans_type', '交易类型（1-限价交易，2-市价交易）', 'tinyint(1)', 'Integer', 'transType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3094, '266', 'source', '来源（1-手动，2-机器人，3-api)', 'tinyint(1)', 'Integer', 'source', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3095, '266', 'exch_code', '交易所CODE', 'varchar(50)', 'String', 'exchCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3096, '266', 'exch_acct_id', '交易账户ID', 'bigint(20)', 'Long', 'exchAcctId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3097, '266', 'account_bind_id', '账户绑定ID (用户直接绑定交易所账户APIkey)', 'bigint(20)', 'Long', 'accountBindId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3098, '266', 'user_id', '用户ID', 'bigint(20)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3099, '266', 'user_account_id', '用户账户ID', 'bigint(20)', 'Long', 'userAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3100, '266', 'order_id', '交易所订单ID', 'varchar(100)', 'String', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3101, '266', 'status', '状态（）', 'tinyint(2)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3102, '266', 'price', '下单金额', 'decimal(30,18)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3103, '266', 'amount', '下单数量', 'decimal(30,18)', 'Double', 'amount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3104, '266', 'left_amount', '未成交数量', 'decimal(30,18)', 'Double', 'leftAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3105, '266', 'filled_amount', '已成交量', 'decimal(30,18)', 'Double', 'filledAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3106, '266', 'price_avg', '成交均价', 'decimal(30,18)', 'Double', 'priceAvg', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3107, '266', 'filled_cash_amount', '已成交金额', 'decimal(30,18)', 'Double', 'filledCashAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3108, '266', 'market_cash_amount', '市价买入量', 'decimal(30,18)', 'Double', 'marketCashAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3109, '266', 'third_create_time', '交易所创建时间', 'datetime', 'Date', 'thirdCreateTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 21, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3110, '266', 'third_update_time', '交易所更新时间', 'datetime', 'Date', 'thirdUpdateTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 22, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3111, '266', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 23, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3112, '266', 'base_account_coin_id', '币账户币种ID', 'bigint(20)', 'Long', 'baseAccountCoinId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3113, '266', 'quote_account_coin_id', '钱账户币种ID', 'bigint(20)', 'Long', 'quoteAccountCoinId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3114, '266', 'syn_fee_status', '同步手续费 1未同步 2已同步', 'tinyint(1)', 'Integer', 'synFeeStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 26, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3115, '266', 'create_by', NULL, 'varchar(64)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 27, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3116, '266', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 28, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3117, '266', 'update_by', NULL, 'varchar(64)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 29, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3118, '266', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 30, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3119, '266', 'last_update_from_ip', NULL, 'varchar(200)', 'String', 'lastUpdateFromIp', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 31, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3120, '266', 'syn_platfomr_fee_status', NULL, 'tinyint(1)', 'Integer', 'synPlatfomrFeeStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 32, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3121, '266', 'account_deal_fee', '平台手续费', 'decimal(30,18)', 'Double', 'accountDealFee', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 33, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3122, '266', 'spot_deal_fee', '第三方手续费', 'decimal(30,18)', 'Double', 'spotDealFee', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 34, 'admin', '2019-09-25 18:59:48', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3123, '267', 'id', 'null', 'smallint(5) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-01-03 11:04:22', NULL, '2020-01-03 11:14:20');
INSERT INTO `admin_gen_table_column` VALUES (3124, '267', 'code', '支付类型编码', 'varchar(50)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-01-03 11:04:22', NULL, '2020-01-03 11:14:20');
INSERT INTO `admin_gen_table_column` VALUES (3125, '267', 'name', '支付类型名称', 'varchar(50)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-01-03 11:04:23', NULL, '2020-01-03 11:14:20');
INSERT INTO `admin_gen_table_column` VALUES (3126, '267', 'is_online', '是否线上支付 1=线上支付 2=线下支付', 'tinyint(1) unsigned', 'Integer', 'isOnline', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-01-03 11:04:23', NULL, '2020-01-03 11:14:20');
INSERT INTO `admin_gen_table_column` VALUES (3127, '267', 'params', '参数', 'text', 'String', 'params', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-01-03 11:04:23', NULL, '2020-01-03 11:14:21');
INSERT INTO `admin_gen_table_column` VALUES (3128, '267', 'sort', '排序', 'smallint(5) unsigned', 'Integer', 'sort', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-01-03 11:04:23', NULL, '2020-01-03 11:14:21');
INSERT INTO `admin_gen_table_column` VALUES (3129, '267', 'memo', '支付方式描述', 'varchar(200)', 'String', 'memo', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-01-03 11:04:23', NULL, '2020-01-03 11:14:21');
INSERT INTO `admin_gen_table_column` VALUES (3130, '267', 'status', '启用状态 1=启用 2=停用', 'smallint(1) unsigned', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2020-01-03 11:04:23', NULL, '2020-01-03 11:14:21');
INSERT INTO `admin_gen_table_column` VALUES (3131, '268', 'sms_quantity', '短信数量', 'bigint(20)', 'Long', 'smsQuantity', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 1, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3132, '268', 'register_type', '注册类型', 'smallint(6)', 'Integer', 'registerType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3133, '268', 'expire_time', '到期时间', 'datetime', 'Date', 'expireTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 3, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3134, '268', 'try_time', '尝试时间', 'datetime', 'Date', 'tryTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3135, '268', 'contact_mobile', '联系电话', 'char(11)', 'String', 'contactMobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3136, '268', 'address_province', '地区省', 'varchar(20)', 'String', 'addressProvince', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3137, '268', 'buy_plan_times', '所购物品计划时间', 'bigint(20)', 'Long', 'buyPlanTimes', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3138, '268', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3139, '268', 'is_checked', '是否选中', 'smallint(6)', 'Integer', 'isChecked', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3140, '268', 'is_deleted', '是否删除', 'smallint(6)', 'Integer', 'isDeleted', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3141, '268', 'service_phone', '服务电话', 'varchar(30)', 'String', 'servicePhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3142, '268', 'address_lat', '地址名', 'varchar(40)', 'String', 'addressLat', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3143, '268', 'contact_name', '联系人名', 'varchar(20)', 'String', 'contactName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 13, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3144, '268', 'delete_time', '删除时间', 'datetime', 'Date', 'deleteTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 14, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3145, '268', 'diy_profile', '自己配置文件', 'text', 'String', 'diyProfile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3146, '268', 'industry_two', '行业', 'bigint(20)', 'Long', 'industryTwo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3147, '268', 'is_star', NULL, 'smallint(6)', 'Integer', 'isStar', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3148, '268', 'is_try', '尝试', 'smallint(6)', 'Integer', 'isTry', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3149, '268', 'logo', '图标', 'varchar(255)', 'String', 'logo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3150, '268', 'address_detail', '地址细节', 'varchar(100)', 'String', 'addressDetail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3151, '268', 'plan_id', '计划id', 'bigint(20)', 'Long', 'planId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3152, '268', 'support_name', '支持，维持名称', 'varchar(200)', 'String', 'supportName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 22, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3153, '268', 'name', NULL, 'varchar(50)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 23, 'admin', '2020-01-13 15:55:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3154, '268', 'status', '1 通过 2 审核中 3 拒绝', 'smallint(6)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 24, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3155, '268', 'uid', NULL, 'smallint(6)', 'Integer', 'uid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3156, '268', 'type', '类型', 'int(30)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 26, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3157, '268', 'contact_qq', '联系QQ', 'varchar(11)', 'String', 'contactQq', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3158, '268', 'address_lng', NULL, 'varchar(40)', 'String', 'addressLng', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 28, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3159, '268', 'last_login_time', NULL, 'datetime', 'Date', 'lastLoginTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 29, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3160, '268', 'support_phone', '支持电话', 'varchar(30)', 'String', 'supportPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 30, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3161, '268', 'address_area', '地址区域', 'varchar(20)', 'String', 'addressArea', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 31, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3162, '268', 'contact_qrcode', NULL, 'varchar(255)', 'String', 'contactQrcode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 32, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3163, '268', 'description', '描述', 'varchar(255)', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 33, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3164, '268', 'industry_one', '行业1', 'bigint(20)', 'Long', 'industryOne', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 34, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3165, '268', 'address_city', '地址城市', 'varchar(20)', 'String', 'addressCity', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 35, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3166, '268', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 36, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3167, '268', 'collect', NULL, 'int(11)', 'Long', 'collect', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 37, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3168, '268', 'hit', NULL, 'int(11)', 'Long', 'hit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 38, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3169, '268', 'goods_count', NULL, 'int(11)', 'Long', 'goodsCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 39, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3170, '268', 'member_count', NULL, 'int(11)', 'Long', 'memberCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 40, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3171, '268', 'order_count', NULL, 'int(11)', 'Long', 'orderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 41, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3172, '268', 'pay_amount', NULL, 'decimal(10,0)', 'Long', 'payAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 42, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3173, '268', 'article_count', NULL, 'int(11)', 'Long', 'articleCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 43, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3174, '268', 'is_boutique', '精品店铺标识,0:否，1:是', 'smallint(6)', 'Integer', 'isBoutique', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 44, 'admin', '2020-01-13 15:55:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3187, '270', 'ID', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-02-27 12:01:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3188, '270', 'EXPRESS_CORP_ID', NULL, 'varchar(32)', 'String', 'expressCorpId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-02-27 12:01:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3189, '270', 'EXPRESS_CORP_NAME', '快递公司名称', 'varchar(64)', 'String', 'expressCorpName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-02-27 12:01:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3190, '270', 'STATUS', '0 可用 1 不可用', 'tinyint(4)', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-02-27 12:01:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3191, '270', 'LOGO_URL', '快递公司logo', 'varchar(32)', 'String', 'logoUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-02-27 12:01:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3192, '270', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-02-27 12:01:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3193, '271', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3194, '271', 'status', '状态', 'int(5)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 2, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3195, '271', 'type', '返佣类型', 'int(5)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3196, '271', 'fan_percent', '商品返佣比例', 'int(5)', 'Integer', 'fanPercent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3197, '271', 'fan_type', '到账类型', 'int(5)', 'Integer', 'fanType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3198, '271', 'withdraw_type', '提现方式', 'int(5)', 'Integer', 'withdrawType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3199, '271', 'one_percent', '一级返佣', 'int(5)', 'Integer', 'onePercent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3200, '271', 'two_percent', '二级返佣', 'int(5)', 'Integer', 'twoPercent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3201, '271', 'three_percent', '三级返佣', 'int(5)', 'Integer', 'threePercent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3202, '271', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3203, '271', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3204, '272', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3205, '272', 'order_id', NULL, 'bigint(11)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3206, '272', 'member_id', '被邀请的', 'bigint(11)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3207, '272', 'invite_id', '邀请人', 'bigint(11)', 'Long', 'inviteId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3208, '272', 'money', NULL, 'decimal(10,4)', 'Double', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3209, '272', 'level', NULL, 'varchar(255)', 'String', 'level', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3210, '272', 'status', NULL, 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3211, '272', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3212, '272', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3213, '272', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3214, '272', 'type', '1余额 2积分', 'int(2)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 11, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3215, '273', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3216, '273', 'keyword', '关键字', 'varchar(127)', 'String', 'keyword', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3217, '273', 'url', '关键字的跳转链接', 'varchar(255)', 'String', 'url', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3218, '273', 'is_hot', '是否是热门关键字', 'tinyint(1)', 'Integer', 'isHot', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3219, '273', 'is_default', '是否是默认关键字', 'tinyint(1)', 'Integer', 'isDefault', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3220, '273', 'sort_order', '排序', 'int(11)', 'Long', 'sortOrder', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3221, '273', 'add_time', '创建时间', 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3222, '273', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3223, '273', 'deleted', '逻辑删除', 'tinyint(1)', 'Integer', 'deleted', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3224, '274', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3225, '274', 'user_id', '用户表的用户ID', 'int(11)', 'Long', 'userId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3226, '274', 'keyword', '搜索关键字', 'varchar(63)', 'String', 'keyword', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3227, '274', 'from1', '搜索来源，如pc、wx、app', 'varchar(63)', 'String', 'from1', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3228, '274', 'add_time', '创建时间', 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3229, '274', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:26:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3230, '274', 'deleted', '逻辑删除', 'tinyint(1)', 'Integer', 'deleted', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3231, '275', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3232, '275', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3233, '275', 'product_sku_id', NULL, 'bigint(20)', 'Long', 'productSkuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3234, '275', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3235, '275', 'quantity', '购买数量', 'int(11)', 'Long', 'quantity', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3236, '275', 'price', '添加到购物车的价格', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3237, '275', 'sp1', '销售属性1', 'varchar(200)', 'String', 'sp1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3238, '275', 'sp2', '销售属性2', 'varchar(200)', 'String', 'sp2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3239, '275', 'sp3', '销售属性3', 'varchar(200)', 'String', 'sp3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3240, '275', 'product_pic', '商品主图', 'varchar(1000)', 'String', 'productPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 10, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3241, '275', 'product_name', '商品名称', 'varchar(500)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'textarea', '', 11, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3242, '275', 'product_sub_title', '商品副标题（卖点）', 'varchar(500)', 'String', 'productSubTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 12, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3243, '275', 'product_sku_code', '商品sku条码', 'varchar(200)', 'String', 'productSkuCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3244, '275', 'member_nickname', '会员昵称', 'varchar(500)', 'String', 'memberNickname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'textarea', '', 14, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3245, '275', 'create_date', '创建时间', 'datetime', 'Date', 'createDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 15, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3246, '275', 'modify_date', '修改时间', 'datetime', 'Date', 'modifyDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 16, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3247, '275', 'delete_status', '是否删除', 'int(1)', 'Integer', 'deleteStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 17, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3248, '275', 'product_category_id', '商品分类', 'bigint(20)', 'Long', 'productCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3249, '275', 'product_brand', NULL, 'varchar(200)', 'String', 'productBrand', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3250, '275', 'product_sn', NULL, 'varchar(200)', 'String', 'productSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3251, '275', 'product_attr', '商品销售属性:[{\"key\":\"颜色\",\"value\":\"颜色\"},{\"key\":\"容量\",\"value\":\"4G\"}]', 'varchar(500)', 'String', 'productAttr', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 21, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3252, '275', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3253, '275', 'checked', '1x选中 2 枚选中', 'int(11)', 'Long', 'checked', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 23, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3254, '275', 'store_name', NULL, 'varchar(255)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 24, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3255, '275', 'is_fenxiao', NULL, 'int(11)', 'Long', 'isFenxiao', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-03-02 19:26:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3256, '276', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3257, '276', 'name', '品牌名称', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3258, '276', 'first_letter', '首字母', 'varchar(8)', 'String', 'firstLetter', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3259, '276', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3260, '276', 'factory_status', '品牌制造商', 'int(1)', 'Integer', 'factoryStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 5, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3261, '276', 'show_status', '显示', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 6, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3262, '276', 'product_count', '产品数量', 'int(11)', 'Long', 'productCount', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3263, '276', 'product_comment_count', '产品评论数量', 'int(11)', 'Long', 'productCommentCount', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3264, '276', 'logo', '品牌logo', 'varchar(255)', 'String', 'logo', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3265, '276', 'big_pic', '专区大图', 'varchar(255)', 'String', 'bigPic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3266, '276', 'brand_story', '品牌故事', 'text', 'String', 'brandStory', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3267, '276', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:30:05');
INSERT INTO `admin_gen_table_column` VALUES (3268, '277', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3269, '277', 'add_time', '创建时间', 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 2, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3270, '277', 'type', '1 商品 2 文章 3 店铺', 'int(11)', 'Long', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3271, '277', 'obj_id', '收藏编号', 'bigint(20)', 'Long', 'objId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3272, '277', 'store_id', NULL, 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3273, '277', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3274, '277', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3275, '277', 'meno1', NULL, 'varchar(255)', 'String', 'meno1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3276, '277', 'meno2', NULL, 'varchar(255)', 'String', 'meno2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3277, '277', 'meno3', NULL, 'varchar(255)', 'String', 'meno3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3278, '278', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3279, '278', 'name', '名称', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3280, '278', 'charge_type', '计费类型', 'int(1)', 'Integer', 'chargeType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'feight_type', 3, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3281, '278', 'first_weight', '首重kg', 'decimal(10,2)', 'Double', 'firstWeight', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3282, '278', 'first_fee', '首费（元）', 'decimal(10,2)', 'Double', 'firstFee', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3283, '278', 'continue_weight', '后重量', 'decimal(10,2)', 'Double', 'continueWeight', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3284, '278', 'continme_fee', '后费用', 'decimal(10,2)', 'Double', 'continmeFee', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3285, '278', 'dest', '目的地（省、市）', 'varchar(255)', 'String', 'dest', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3286, '278', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3287, '278', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, NULL, NULL, '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:26:29', NULL, '2020-03-04 20:33:10');
INSERT INTO `admin_gen_table_column` VALUES (3288, '279', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3289, '279', 'brand_id', NULL, 'bigint(20)', 'Long', 'brandId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3290, '279', 'product_category_id', NULL, 'bigint(20)', 'Long', 'productCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3291, '279', 'feight_template_id', NULL, 'bigint(20)', 'Long', 'feightTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3292, '279', 'product_attribute_category_id', NULL, 'bigint(20)', 'Long', 'productAttributeCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3293, '279', 'name', NULL, 'varchar(200)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3294, '279', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3295, '279', 'product_sn', '货号', 'varchar(64)', 'String', 'productSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3296, '279', 'delete_status', '删除状态：0->未删除；1->已删除', 'int(1)', 'Integer', 'deleteStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3297, '279', 'publish_status', '上架状态：0->下架；1->上架', 'int(1)', 'Integer', 'publishStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 10, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3298, '279', 'new_status', '新品状态:0->不是新品；1->新品', 'int(1)', 'Integer', 'newStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 11, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3299, '279', 'recommand_status', '推荐状态；0->不推荐；1->推荐', 'int(1)', 'Integer', 'recommandStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 12, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3300, '279', 'verify_status', '审核状态：0->未审核；1->审核通过', 'int(1)', 'Integer', 'verifyStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3301, '279', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3302, '279', 'sale', '销量', 'int(11)', 'Long', 'sale', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3303, '279', 'price', NULL, 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3304, '279', 'promotion_price', '促销价格', 'decimal(10,2)', 'Double', 'promotionPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3305, '279', 'gift_growth', '赠送的成长值', 'int(11)', 'Long', 'giftGrowth', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3306, '279', 'gift_point', '赠送的积分', 'int(11)', 'Long', 'giftPoint', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3307, '279', 'use_point_limit', '限制使用的积分数', 'int(11)', 'Long', 'usePointLimit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3308, '279', 'sub_title', '副标题', 'varchar(255)', 'String', 'subTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3309, '279', 'description', '商品描述', 'text', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3310, '279', 'original_price', '市场价', 'decimal(10,2)', 'Double', 'originalPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 23, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3311, '279', 'stock', '库存', 'int(11)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3312, '279', 'low_stock', '库存预警值', 'int(11)', 'Long', 'lowStock', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3313, '279', 'unit', '单位', 'varchar(16)', 'String', 'unit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 26, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3314, '279', 'weight', '商品重量，默认为克', 'decimal(10,2)', 'Double', 'weight', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3315, '279', 'preview_status', '是否为预告商品：0->不是；1->是', 'int(1)', 'Integer', 'previewStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 28, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3316, '279', 'service_ids', '以逗号分割的产品服务：1->无忧退货；2->快速退款；3->免费包邮', 'varchar(64)', 'String', 'serviceIds', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 29, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3317, '279', 'keywords', NULL, 'varchar(255)', 'String', 'keywords', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 30, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3318, '279', 'note', NULL, 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 31, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3319, '279', 'album_pics', '画册图片，连产品图片限制为5张，以逗号分割', 'varchar(255)', 'String', 'albumPics', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 32, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3320, '279', 'detail_title', NULL, 'varchar(255)', 'String', 'detailTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 33, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3321, '279', 'detail_desc', NULL, 'text', 'String', 'detailDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 34, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3322, '279', 'detail_html', '产品详情网页内容', 'text', 'String', 'detailHtml', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 35, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3323, '279', 'detail_mobile_html', '移动端网页详情', 'text', 'String', 'detailMobileHtml', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 36, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3324, '279', 'promotion_start_time', '促销开始时间', 'datetime', 'Date', 'promotionStartTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 37, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3325, '279', 'promotion_end_time', '促销结束时间', 'datetime', 'Date', 'promotionEndTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 38, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3326, '279', 'promotion_per_limit', '活动限购数量', 'int(11)', 'Long', 'promotionPerLimit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 39, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3327, '279', 'promotion_type', '促销类型：0->没有促销使用原价;1->使用促销价；2->使用会员价；3->使用阶梯价格；4->使用满减价格；5->限时购', 'int(1)', 'Integer', 'promotionType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 40, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3328, '279', 'brand_name', '品牌名称', 'varchar(255)', 'String', 'brandName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 41, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3329, '279', 'product_category_name', '商品分类名称', 'varchar(255)', 'String', 'productCategoryName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 42, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3330, '279', 'supply_id', NULL, 'bigint(20)', 'Long', 'supplyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 43, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3331, '279', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 44, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3332, '279', 'school_id', NULL, 'bigint(20)', 'Long', 'schoolId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 45, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3333, '279', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 46, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3334, '279', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 47, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3335, '279', 'hit', NULL, 'int(11)', 'Long', 'hit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 48, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3336, '279', 'type', NULL, 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 49, 'admin', '2020-03-02 19:26:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3337, '279', 'area_id', NULL, 'bigint(20)', 'Long', 'areaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 50, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3338, '279', 'area_name', NULL, 'varchar(255)', 'String', 'areaName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 51, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3339, '279', 'school_name', NULL, 'varchar(255)', 'String', 'schoolName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 52, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3340, '279', 'transfee', '运费', 'decimal(10,0)', 'Long', 'transfee', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 53, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3341, '279', 'is_paimai', '1普通 2拍卖', 'int(11)', 'Long', 'isPaimai', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 54, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3342, '279', 'expire_time', '到期时间', 'datetime', 'Date', 'expireTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 55, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3343, '279', 'store_name', NULL, 'varchar(255)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 56, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3344, '279', 'is_fenxiao', NULL, 'int(11)', 'Long', 'isFenxiao', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 57, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3345, '280', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3346, '280', 'coupon_id', NULL, 'bigint(20)', 'Long', 'couponId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3347, '280', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3348, '280', 'coupon_code', NULL, 'varchar(64)', 'String', 'couponCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3349, '280', 'member_nickname', '领取人昵称', 'varchar(64)', 'String', 'memberNickname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3350, '280', 'get_type', '获取类型：0->后台赠送；1->主动获取', 'int(1)', 'Integer', 'getType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3351, '280', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3352, '280', 'use_status', '使用状态：0->未使用；1->已使用；2->已过期', 'int(1)', 'Integer', 'useStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3353, '280', 'use_time', '使用时间', 'datetime', 'Date', 'useTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3354, '280', 'order_id', '订单编号', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3355, '280', 'order_sn', '订单号码', 'varchar(100)', 'String', 'orderSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3356, '280', 'start_time', NULL, 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 12, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3357, '280', 'end_time', NULL, 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 13, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3358, '280', 'note', NULL, 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3359, '280', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3360, '280', 'amount', NULL, 'decimal(10,0)', 'Long', 'amount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3361, '280', 'min_point', NULL, 'decimal(10,0)', 'Long', 'minPoint', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:26:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3362, '281', 'id', '小区ID', 'bigint(30)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3363, '281', 'store_id', 'ID', 'bigint(30)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3364, '281', 'name', '小区名称', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3365, '281', 'counts', '小区栋数', 'varchar(100)', 'String', 'counts', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3366, '281', 'address', '小区地址', 'varchar(200)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3367, '281', 'city_code', '根据定位获取城市编码', 'varchar(12)', 'String', 'cityCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3368, '281', 'nearby_landmarks', '地标，如王府井北60米', 'varchar(200)', 'String', 'nearbyLandmarks', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3369, '281', 'latitude', '地区 纬度', 'varchar(20)', 'String', 'latitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3370, '281', 'longitude', '地区 经度', 'varchar(20)', 'String', 'longitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3371, '281', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3372, '281', 'status', '1申请 2审核失败 3 审核成功', 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 11, 'admin', '2020-03-02 19:33:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3373, '281', 'phone', '联系方式', 'varchar(16)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3374, '281', 'status_desc', '审核备注', 'varchar(255)', 'String', 'statusDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3375, '281', 'company_id', '物业公司', 'bigint(20)', 'Long', 'companyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3376, '281', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3377, '282', 'id', '楼ID', 'bigint(30)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3378, '282', 'floor_num', '楼编号', 'varchar(12)', 'String', 'floorNum', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3379, '282', 'name', '小区楼名称', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3380, '282', 'remark', '备注', 'varchar(200)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3381, '282', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3382, '282', 'layer_count', NULL, 'int(4)', 'Integer', 'layerCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3383, '282', 'lift', '1 有电梯', 'int(4)', 'Integer', 'lift', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3384, '282', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3385, '282', 'community_id', NULL, 'bigint(20)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3386, '282', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3387, '283', 'id', '房屋ID', 'bigint(30)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3388, '283', 'room_num', '房屋编号', 'varchar(12)', 'String', 'roomNum', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3389, '283', 'unit_id', '单元ID', 'varchar(30)', 'String', 'unitId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3390, '283', 'layer', '层数', 'int(11)', 'Long', 'layer', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3391, '283', 'section', '室', 'varchar(11)', 'String', 'section', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3392, '283', 'apartment', '户型', 'varchar(4)', 'String', 'apartment', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3393, '283', 'built_up_area', '建筑面积', 'decimal(6,2)', 'Double', 'builtUpArea', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3394, '283', 'unit_price', '每平米单价', 'decimal(12,2)', 'Double', 'unitPrice', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3395, '283', 'remark', '备注', 'varchar(200)', 'String', 'remark', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3396, '283', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3397, '283', 'status_cd', '数据状态，详细参考c_status表，S 保存，0, 在用 1失效', 'varchar(2)', 'String', 'statusCd', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3398, '283', 'state', '房屋状态，如房屋出售等，请查看state 表', 'varchar(8)', 'String', 'state', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3399, '283', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3400, '283', 'floor_id', NULL, 'bigint(20)', 'Long', 'floorId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3401, '283', 'community_id', NULL, 'bigint(20)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3402, '283', 'room_desc', NULL, 'varchar(255)', 'String', 'roomDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:33:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3403, '283', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3404, '283', 'pics', NULL, 'varchar(2550)', 'String', 'pics', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 18, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3405, '284', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3406, '284', 'name', '姓名', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3407, '284', 'age', '年龄', 'int(11)', 'Long', 'age', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3408, '284', 'sex', '性别', 'varchar(255)', 'String', 'sex', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3409, '284', 'address', '地址', 'varchar(255)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3410, '284', 'xueli', '学历', 'varchar(255)', 'String', 'xueli', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3411, '284', 'remark', '备注', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3412, '284', 'idcard', '身份证', 'varchar(255)', 'String', 'idcard', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3413, '284', 'idcardpic', '身份证照片', 'varchar(255)', 'String', 'idcardpic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3414, '284', 'xinshui', '期望薪水', 'varchar(255)', 'String', 'xinshui', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3415, '284', 'hobby', '爱好', 'varchar(255)', 'String', 'hobby', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3416, '284', 'area_id', '区域编号', 'bigint(20)', 'Long', 'areaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3417, '284', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3418, '284', 'phone', '电话', 'varchar(255)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3419, '284', 'zhiwei', '职位', 'varchar(255)', 'String', 'zhiwei', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3420, '284', 'status', NULL, 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 16, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3421, '285', 'id', '订单id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3422, '285', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3423, '285', 'coupon_id', NULL, 'bigint(20)', 'Long', 'couponId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3424, '285', 'order_sn', '订单编号', 'varchar(255)', 'String', 'orderSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3425, '285', 'create_time', '提交时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3426, '285', 'member_username', '用户帐号', 'varchar(512)', 'String', 'memberUsername', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'textarea', '', 6, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3427, '285', 'total_amount', '订单总金额', 'decimal(10,2)', 'Double', 'totalAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3428, '285', 'pay_amount', '应付金额（实际支付金额）', 'decimal(10,2)', 'Double', 'payAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3429, '285', 'freight_amount', '运费金额', 'decimal(10,2)', 'Double', 'freightAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3430, '285', 'promotion_amount', '促销优化金额（促销价、满减、阶梯价）', 'decimal(10,2)', 'Double', 'promotionAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3431, '285', 'integration_amount', '积分抵扣金额', 'decimal(10,2)', 'Double', 'integrationAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3432, '285', 'coupon_amount', '优惠券抵扣金额', 'decimal(10,2)', 'Double', 'couponAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3433, '285', 'discount_amount', '管理员后台调整订单使用的折扣金额', 'decimal(10,2)', 'Double', 'discountAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3434, '285', 'pay_type', '支付方式：0->未支付；1->支付宝；2->微信', 'int(1)', 'Integer', 'payType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 14, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3435, '285', 'source_type', '订单来源：0->PC订单；1->app订单', 'int(1)', 'Integer', 'sourceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 15, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3436, '285', 'status', '订单状态：0->待付款；1->待发货；2->已发货；3->已完成；4->已关闭；5->无效订单', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 16, 'admin', '2020-03-02 19:33:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3437, '285', 'order_type', '订单类型：0->正常订单；1->秒杀订单', 'int(1)', 'Integer', 'orderType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 17, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3438, '285', 'delivery_company', '物流公司(配送方式)', 'varchar(64)', 'String', 'deliveryCompany', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3439, '285', 'delivery_sn', '物流单号', 'varchar(64)', 'String', 'deliverySn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3440, '285', 'auto_confirm_day', '自动确认时间（天）', 'int(11)', 'Long', 'autoConfirmDay', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3441, '285', 'integration', '可以获得的积分', 'int(11)', 'Long', 'integration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3442, '285', 'growth', '可以活动的成长值', 'int(11)', 'Long', 'growth', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3443, '285', 'promotion_info', '活动信息', 'varchar(100)', 'String', 'promotionInfo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 23, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3444, '285', 'bill_type', '发票类型：0->不开发票；1->电子发票；2->纸质发票', 'int(1)', 'Integer', 'billType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 24, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3445, '285', 'bill_header', '发票抬头', 'varchar(200)', 'String', 'billHeader', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3446, '285', 'bill_content', '发票内容', 'varchar(200)', 'String', 'billContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 26, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3447, '285', 'bill_receiver_phone', '收票人电话', 'varchar(32)', 'String', 'billReceiverPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3448, '285', 'bill_receiver_email', '收票人邮箱', 'varchar(64)', 'String', 'billReceiverEmail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 28, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3449, '285', 'receiver_name', '收货人姓名', 'varchar(100)', 'String', 'receiverName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 29, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3450, '285', 'receiver_phone', '收货人电话', 'varchar(32)', 'String', 'receiverPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 30, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3451, '285', 'receiver_post_code', '收货人邮编', 'varchar(32)', 'String', 'receiverPostCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 31, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3452, '285', 'receiver_province', '省份/直辖市', 'varchar(32)', 'String', 'receiverProvince', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 32, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3453, '285', 'receiver_city', '城市', 'varchar(32)', 'String', 'receiverCity', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 33, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3454, '285', 'receiver_region', '区', 'varchar(32)', 'String', 'receiverRegion', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 34, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3455, '285', 'receiver_detail_address', '详细地址', 'varchar(200)', 'String', 'receiverDetailAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 35, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3456, '285', 'note', '订单备注', 'varchar(500)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 36, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3457, '285', 'confirm_status', '确认收货状态：0->未确认；1->已确认', 'int(1)', 'Integer', 'confirmStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 37, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3458, '285', 'delete_status', '删除状态：0->未删除；1->已删除', 'int(1)', 'Integer', 'deleteStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 38, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3459, '285', 'use_integration', '下单时使用的积分', 'int(11)', 'Long', 'useIntegration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 39, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3460, '285', 'payment_time', '支付时间', 'datetime', 'Date', 'paymentTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 40, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3461, '285', 'delivery_time', '发货时间', 'datetime', 'Date', 'deliveryTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 41, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3462, '285', 'receive_time', '确认收货时间', 'datetime', 'Date', 'receiveTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 42, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3463, '285', 'comment_time', '评价时间', 'datetime', 'Date', 'commentTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 43, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3464, '285', 'modify_time', '修改时间', 'datetime', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 44, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3465, '285', 'prepay_id', NULL, 'varchar(255)', 'String', 'prepayId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 45, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3466, '285', 'supply_id', NULL, 'bigint(20)', 'Long', 'supplyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 46, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3467, '285', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 47, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3468, '285', 'goods_name', NULL, 'varchar(255)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 48, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3469, '285', 'school_id', NULL, 'bigint(20)', 'Long', 'schoolId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 49, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3470, '285', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 50, 'admin', '2020-03-02 19:33:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3471, '285', 'receiver_id', NULL, 'bigint(20)', 'Long', 'receiverId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 51, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3472, '285', 'group_id', NULL, 'bigint(20)', 'Long', 'groupId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 52, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3473, '285', 'tax_type', '是否开发票 1=不发票 2=个人发票 3=公司发票', 'smallint(6)', 'Integer', 'taxType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 53, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3474, '285', 'tax_content', '发票内容', 'varchar(255)', 'String', 'taxContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 54, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3475, '285', 'tax_code', '税号', 'varchar(50)', 'String', 'taxCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 55, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3476, '285', 'tax_title', '发票抬头', 'varchar(50)', 'String', 'taxTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 56, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3477, '285', 'is_comment', '是否评论，1未评论，2已评论', 'tinyint(1) unsigned', 'Integer', 'isComment', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 57, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3478, '285', 'store_name', NULL, 'varchar(255)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 58, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3479, '285', 'pid', NULL, 'bigint(20)', 'Long', 'pid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 59, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3480, '286', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3481, '286', 'coupon_id', NULL, 'bigint(20)', 'Long', 'couponId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3482, '286', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3483, '286', 'product_name', '商品名称', 'varchar(500)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'textarea', '', 4, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3484, '286', 'product_sn', '商品编码', 'varchar(200)', 'String', 'productSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3485, '286', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3486, '287', 'id', 'id', 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3487, '287', 'userid', NULL, 'bigint(50)', 'Long', 'userid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3488, '287', 'sNo', '订单号', 'varchar(255)', 'String', 'sno', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3489, '287', 'money', '应发佣金', 'float(10,2)', 'Double', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3490, '287', 's_money', '实发佣金', 'float(10,2)', 'Double', 'sMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3491, '287', 'status', '1.未发放，2.已发放', 'int(2)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3492, '287', 'addtime', '添加时间', 'datetime', 'Date', 'addtime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3493, '287', 'type', '类型', 'int(2)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 8, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3494, '287', 'Referee', '上级', 'varchar(50)', 'String', 'referee', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3495, '287', 'recycle', '0 不回收  1.回收', 'int(2)', 'Integer', 'recycle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3496, '287', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3497, '288', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3498, '288', 'type', '页面类型 1全部页面 2商城首页 3会员中心页 4商城详情页 5自定义页面', 'int(4)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3499, '288', 'name', NULL, 'varchar(40)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3500, '288', 'datas', NULL, 'text', 'String', 'datas', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3501, '288', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3502, '288', 'update_time', NULL, 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3503, '288', 'diymenu', NULL, 'int(4)', 'Integer', 'diymenu', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3504, '288', 'title', NULL, 'varchar(40)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3505, '288', 'status', NULL, 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3506, '288', 'keyword', NULL, 'varchar(255)', 'String', 'keyword', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3507, '288', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3508, '289', 'id', 'id', 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3509, '289', 'name', '活动名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3510, '289', 'good_id', '该抽奖所参与商品ID', 'bigint(11)', 'Long', 'goodId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3511, '289', 'found_time', '创建时间', 'timestamp', 'Date', 'foundTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3512, '289', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3513, '289', 'end_time', '结束时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3514, '289', 'num', '每个团所需人数', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3515, '289', 'spelling_number', '可抽中奖次数（默认为1）', 'int(11)', 'Long', 'spellingNumber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3516, '289', 'collage_number', '最少开奖团数（默认为1）', 'int(11)', 'Long', 'collageNumber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3517, '289', 'state', '该团的状态（默认为0：未开始 ，1：进行中 ， 2：已结束）', 'int(11)', 'Long', 'state', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3518, '289', 'price', '抽奖金额', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3519, '289', 'cishu', '次数 ', 'int(11)', 'Long', 'cishu', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3520, '289', 'type', '备注', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 13, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3521, '289', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3522, '289', 'goods_name', NULL, 'varchar(255)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 15, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3523, '290', 'id', 'ID', 'bigint(11)', 'Long', 'id', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3524, '290', 'draw_id', '拼团ID', 'bigint(11)', 'Long', 'drawId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3525, '290', 'user_id', '用户ID', 'bigint(30)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3526, '290', 'time', '用户参团时间', 'datetime', 'Date', 'time', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3527, '290', 'role', '用户角色（默认 0：团长  userid:该用户分享进来的用户）', 'varchar(30)', 'String', 'role', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3528, '290', 'lottery_status', '抽奖状态（0.参团中 1.待抽奖 2.参团失败 3.抽奖失败 4.抽奖成功）', 'int(11)', 'Long', 'lotteryStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3529, '290', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3530, '291', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3531, '291', 'user_id', '用户id', 'bigint(15)', 'Long', 'userId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3532, '291', 'seller_id', '商家id', 'bigint(15)', 'Long', 'sellerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3533, '291', 'name', '姓名', 'varchar(20)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3534, '291', 'mobile', '手机', 'varchar(20)', 'String', 'mobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3535, '291', 'address', '地址', 'varchar(300)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3536, '291', 'num', '数量', 'int(11)', 'Long', 'num', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3537, '291', 'content', '内容', 'text', 'String', 'content', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3538, '291', 'add_date', '添加时间', 'timestamp', 'Date', 'addDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3539, '291', 'status', '类型 0:申请预约 1:已预约 2:取消预约 3:完成', 'tinyint(4)', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 10, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3540, '291', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3541, '292', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3542, '292', 'title', NULL, 'varchar(200)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3543, '292', 'start_date', '开始日期', 'date', 'Date', 'startDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 3, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3544, '292', 'end_date', '结束日期', 'date', 'Date', 'endDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3545, '292', 'status', '上下线状态', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3546, '292', 'create_time', '秒杀时间段名称', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3547, '292', 'isIndex', '是否是首页抢购 0为不是，1为是', 'int(1)', 'Integer', 'isindex', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3548, '292', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3549, '293', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3550, '293', 'member_id', NULL, 'int(11)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3551, '293', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3552, '293', 'member_phone', NULL, 'varchar(64)', 'String', 'memberPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3553, '293', 'product_name', NULL, 'varchar(100)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3554, '293', 'subscribe_time', '会员订阅时间', 'datetime', 'Date', 'subscribeTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3555, '293', 'send_time', NULL, 'datetime', 'Date', 'sendTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3556, '293', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3557, '294', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3558, '294', 'flash_promotion_id', NULL, 'bigint(20)', 'Long', 'flashPromotionId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3559, '294', 'flash_promotion_session_id', '编号', 'bigint(20)', 'Long', 'flashPromotionSessionId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3560, '294', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3561, '294', 'flash_promotion_price', '限时购价格', 'decimal(10,2)', 'Double', 'flashPromotionPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3562, '294', 'flash_promotion_count', '限时购数量', 'int(11)', 'Long', 'flashPromotionCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3563, '294', 'flash_promotion_limit', '每人限购数量', 'int(11)', 'Long', 'flashPromotionLimit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3564, '294', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3565, '294', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3566, '295', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3567, '295', 'name', '场次名称', 'varchar(200)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3568, '295', 'start_time', '每日开始时间', 'varchar(55)', 'String', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3569, '295', 'end_time', '每日结束时间', 'varchar(55)', 'String', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3570, '295', 'status', '启用状态：0->不启用；1->启用', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3571, '295', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3572, '295', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3573, '296', 'id', '编号', 'bigint(20)', 'Long', 'id', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3574, '296', 'goods_id', '商品ID', 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3575, '296', 'diypage_id', '模板编号', 'bigint(20)', 'Long', 'diypageId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3576, '296', 'data', '模板详情', 'longtext', 'String', 'data', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3577, '296', 'store_id', '商铺id', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3578, '297', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3579, '297', 'group_id', '拼团', 'bigint(20)', 'Long', 'groupId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3580, '297', 'status', '状态', 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3581, '297', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3582, '297', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3583, '298', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3584, '298', 'name', NULL, 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3585, '298', 'type', '轮播位置：0->PC首页轮播；1->app首页轮播', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3586, '298', 'pic', NULL, 'varchar(500)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3587, '298', 'start_time', NULL, 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3588, '298', 'end_time', NULL, 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3589, '298', 'status', '上下线状态：0->下线；1->上线', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3590, '298', 'click_count', '点击数', 'int(11)', 'Long', 'clickCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3591, '298', 'order_count', '下单数', 'int(11)', 'Long', 'orderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3592, '298', 'url', '链接地址', 'varchar(500)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 10, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3593, '298', 'note', '备注', 'varchar(500)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3594, '298', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3595, '298', 'store_id', '广告所属店铺', 'int(10)', 'Integer', 'storeId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3596, '299', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3597, '299', 'brand_id', NULL, 'bigint(20)', 'Long', 'brandId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3598, '299', 'brand_name', NULL, 'varchar(64)', 'String', 'brandName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3599, '299', 'recommend_status', NULL, 'int(1)', 'Integer', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3600, '299', 'sort', NULL, 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3601, '299', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3602, '300', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3603, '300', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3604, '300', 'product_name', NULL, 'varchar(128)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3605, '300', 'recommend_status', NULL, 'int(1)', 'Integer', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3606, '300', 'sort', NULL, 'int(1)', 'Integer', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3607, '300', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3608, '301', 'id', 'id', 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3609, '301', 'name', '活动名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3610, '301', 'good_id', '该抽奖所参与商品ID', 'bigint(11)', 'Long', 'goodId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3611, '301', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3612, '301', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3613, '301', 'end_time', '结束时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3614, '301', 'state', '该团的状态（默认为0：未开始 ，1：进行中 ， 2：已结束）', 'int(11)', 'Long', 'state', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3615, '301', 'price', '起拍价', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3616, '301', 'addprice', '加价的倍数', 'decimal(11,0)', 'Long', 'addprice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3617, '301', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3618, '301', 'goods_name', NULL, 'varchar(100)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 11, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3619, '301', 'status', NULL, 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 12, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3620, '301', 'proprice', '保证金', 'decimal(10,2)', 'Double', 'proprice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3621, '302', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3622, '302', 'member_id', NULL, 'bigint(11)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3623, '302', 'price', NULL, 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3624, '302', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3625, '302', 'note', NULL, 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3626, '302', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3627, '302', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3628, '302', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3629, '302', 'paimai_id', NULL, 'bigint(20)', 'Long', 'paimaiId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3630, '303', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3631, '303', 'image', '图片', 'char(30)', 'String', 'image', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3632, '303', 'starttime', '签到活动开始时间', 'char(20)', 'String', 'starttime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3633, '303', 'endtime', '签到活动结束时间', 'char(20)', 'String', 'endtime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3634, '303', 'detail', '签到活动详情', 'text', 'String', 'detail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3635, '303', 'add_time', '修改时间', 'timestamp', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3636, '303', 'status', '状态 0：未启用 1：启用 2：已结束', 'tinyint(4)', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3637, '303', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3638, '304', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3639, '304', 'plug_ins_id', '插件id', 'bigint(11)', 'Long', 'plugInsId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3640, '304', 'imgurl', '图片', 'varchar(200)', 'String', 'imgurl', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3641, '304', 'min_score', '领取的最少积分', 'int(11)', 'Long', 'minScore', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3642, '304', 'max_score', '领取的最大积分', 'int(11)', 'Long', 'maxScore', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3643, '304', 'continuity_three', '连续签到7天', 'int(11)', 'Long', 'continuityThree', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3644, '304', 'continuity_twenty', '连续签到20天', 'int(11)', 'Long', 'continuityTwenty', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3645, '304', 'continuity_thirty', '连续签到30天', 'int(11)', 'Long', 'continuityThirty', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3646, '304', 'activity_overdue', '活动过期删除时间', 'int(11)', 'Long', 'activityOverdue', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3647, '304', 'modify_date', '修改时间', 'timestamp', 'Date', 'modifyDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3648, '304', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3649, '305', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3650, '305', 'user_id', '用户ID', 'bigint(15)', 'Long', 'userId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3651, '305', 'sign_score', '签到积分', 'int(11)', 'Long', 'signScore', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3652, '305', 'record', '事件', 'char(20)', 'String', 'record', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3653, '305', 'sign_time', '签到时间', 'timestamp', 'Date', 'signTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3654, '305', 'type', '类型: 0:签到 1:消费 2:首次关注得积分 3:转积分给好友 4:好友转积分 5:系统扣除 6:系统充值 7:抽奖', 'int(4)', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:33:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3655, '305', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3656, '306', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3657, '306', 'app_id', '应用ID', 'varchar(255)', 'String', 'appId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3658, '306', 'charset', '编码', 'varchar(255)', 'String', 'charset', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3659, '306', 'format', '类型 固定格式json', 'varchar(255)', 'String', 'format', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3660, '306', 'gateway_url', '网关地址', 'varchar(255)', 'String', 'gatewayUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3661, '306', 'notify_url', '异步回调', 'varchar(255)', 'String', 'notifyUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3662, '306', 'private_key', '私钥', 'text', 'String', 'privateKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3663, '306', 'public_key', '公钥', 'text', 'String', 'publicKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3664, '306', 'return_url', '回调地址', 'varchar(255)', 'String', 'returnUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3665, '306', 'sign_type', '签名方式', 'varchar(255)', 'String', 'signType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 10, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3666, '306', 'sys_service_provider_id', '商户号', 'varchar(255)', 'String', 'sysServiceProviderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3667, '306', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3668, '307', 'id', NULL, 'int(11)', 'Long', 'id', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3669, '307', 'status', NULL, 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 2, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3670, '307', 'web_hook1', NULL, 'varchar(255)', 'String', 'webHook1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3671, '307', 'phones1', NULL, 'varchar(255)', 'String', 'phones1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3672, '307', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3673, '307', 'web_hook2', NULL, 'varchar(255)', 'String', 'webHook2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3674, '307', 'phones2', NULL, 'varchar(255)', 'String', 'phones2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3675, '308', 'id', 'ID', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3676, '308', 'from_user', '收件人', 'varchar(255)', 'String', 'fromUser', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3677, '308', 'host', '邮件服务器SMTP地址', 'varchar(255)', 'String', 'host', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3678, '308', 'pass', '密码', 'varchar(255)', 'String', 'pass', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3679, '308', 'port', '端口', 'varchar(255)', 'String', 'port', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3680, '308', 'user', '发件者用户名', 'varchar(255)', 'String', 'user', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3681, '308', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3682, '309', 'id', 'ID', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3683, '309', 'access_key', 'accessKey', 'text', 'String', 'accessKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3684, '309', 'bucket', 'Bucket 识别符', 'varchar(255)', 'String', 'bucket', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3685, '309', 'host', '外链域名', 'varchar(255)', 'String', 'host', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3686, '309', 'secret_key', 'secretKey', 'text', 'String', 'secretKey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3687, '309', 'type', '空间类型', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3688, '309', 'zone', '机房', 'varchar(255)', 'String', 'zone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3689, '309', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3690, '310', 'id', 'ID', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3691, '310', 'bucket', 'Bucket 识别符', 'varchar(255)', 'String', 'bucket', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3692, '310', 'name', '文件名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3693, '310', 'size', '文件大小', 'varchar(255)', 'String', 'size', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3694, '310', 'type', '文件类型：私有或公开', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3695, '310', 'update_time', '上传或同步的时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3696, '310', 'url', '文件url', 'varchar(255)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3697, '310', 'suffix', NULL, 'varchar(255)', 'String', 'suffix', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3698, '310', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3699, '311', 'id', 'id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3700, '311', 'real_name', '名称', 'varchar(255)', 'String', 'realName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3701, '311', 'name', '文件名', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3702, '311', 'suffix', '后缀', 'varchar(255)', 'String', 'suffix', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3703, '311', 'path', '路径', 'varchar(255)', 'String', 'path', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3704, '311', 'type', '类型', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3705, '311', 'size', '大小', 'varchar(100)', 'String', 'size', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3706, '311', 'operate', '操作人', 'varchar(255)', 'String', 'operate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3707, '311', 'create_time', '创建日期', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3708, '311', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3709, '312', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3710, '312', 'name', '名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3711, '312', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3712, '313', 'id', '主键', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3713, '313', 'name', '公众号名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3714, '313', 'account', '公众号账户', 'varchar(100)', 'String', 'account', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3715, '313', 'appid', '公众号appid', 'varchar(100)', 'String', 'appid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3716, '313', 'appsecret', '公众号密钥', 'varchar(100)', 'String', 'appsecret', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3717, '313', 'url', '公众号url', 'varchar(100)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3718, '313', 'token', '公众号token', 'varchar(100)', 'String', 'token', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3719, '313', 'aeskey', '加密密钥', 'varchar(300)', 'String', 'aeskey', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3720, '313', 'qr_url', '二维码图片URL', 'varchar(200)', 'String', 'qrUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3721, '313', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3722, '313', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3723, '314', 'id', '主键', 'int(50)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3724, '314', 'openid', '用户标识', 'varchar(100)', 'String', 'openid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3725, '314', 'subscribe_status', '订阅状态，0未关注，1已关注', 'char(1)', 'String', 'subscribeStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3726, '314', 'subscribe_time', '订阅时间', 'datetime', 'Date', 'subscribeTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3727, '314', 'nickname', '昵称', 'varbinary(2000)', NULL, 'nickname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', NULL, '', 5, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3728, '314', 'gender', '性别，1男，2女，0未知', 'varchar(10)', 'String', 'gender', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3729, '314', 'language', '语言', 'varchar(30)', 'String', 'language', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3730, '314', 'country', '国家', 'varchar(30)', 'String', 'country', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3731, '314', 'province', '省份', 'varchar(30)', 'String', 'province', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3732, '314', 'city', '城市', 'varchar(30)', 'String', 'city', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3733, '314', 'headimg_url', '头像地址', 'varchar(500)', 'String', 'headimgUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3734, '314', 'remark', '备注', 'varchar(500)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 12, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3735, '314', 'wx_account_id', '微信公众号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3736, '314', 'wx_account_appid', '微信公众号appid', 'varchar(100)', 'String', 'wxAccountAppid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3737, '314', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3738, '314', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 16, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3739, '315', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3740, '315', 'openid', '用户标识', 'varchar(100)', 'String', 'openid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3741, '315', 'tag_id', '标签ID', 'varchar(32)', 'String', 'tagId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3742, '315', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3743, '315', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3744, '315', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3745, '316', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3746, '316', 'openid', '用户标识', 'varchar(100)', 'String', 'openid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3747, '316', 'nickname', '昵称', 'varbinary(2000)', NULL, 'nickname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', NULL, '', 3, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3748, '316', 'headimg_url', '头像地址', 'varchar(500)', 'String', 'headimgUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3749, '316', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3750, '316', 'msg_type', '消息类型', 'varchar(32)', 'String', 'msgType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3751, '316', 'content', '内容', 'varchar(500)', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3752, '316', 'res_content', '最近一条回复内容', 'text', 'String', 'resContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3753, '316', 'is_res', '是否已回复', 'varchar(32)', 'String', 'isRes', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3754, '316', 'media_id', '微信素材ID', 'varchar(100)', 'String', 'mediaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3755, '316', 'pic_url', '微信图片URL', 'varchar(500)', 'String', 'picUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3756, '316', 'pic_path', '本地图片路径', 'varchar(500)', 'String', 'picPath', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 12, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3757, '316', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3758, '316', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3759, '317', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3760, '317', 'fans_msg_id', '粉丝消息ID', 'varchar(32)', 'String', 'fansMsgId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3761, '317', 'res_content', '回复内容', 'text', 'String', 'resContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3762, '317', 'user_id', '用户ID', 'varchar(32)', 'String', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3763, '317', 'user_name', '用户名', 'varchar(32)', 'String', 'userName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3764, '317', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3765, '317', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3766, '318', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3767, '318', 'name', '标签名称', 'varchar(32)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3768, '318', 'count', '粉丝数量', 'int(11)', 'Long', 'count', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3769, '318', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3770, '318', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3771, '318', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3772, '319', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3773, '319', 'type', '类型', 'varchar(32)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3774, '319', 'url', '图片URL', 'varchar(500)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3775, '319', 'media_id', '素材ID', 'varchar(32)', 'String', 'mediaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3776, '319', 'thumb_media_id', '缩略图素材ID', 'varchar(32)', 'String', 'thumbMediaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3777, '319', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3778, '319', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3779, '319', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-03-02 19:33:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3780, '320', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3781, '320', 'parent_id', '父ID', 'varchar(32)', 'String', 'parentId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3782, '320', 'menu_name', '菜单名称', 'varchar(32)', 'String', 'menuName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3783, '320', 'menu_type', '菜单类型 1文本消息；2图文消息；3网址链接；4小程序', 'varchar(32)', 'String', 'menuType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3784, '320', 'menu_level', '菜单等级', 'varchar(32)', 'String', 'menuLevel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3785, '320', 'tpl_id', '模板ID', 'varchar(32)', 'String', 'tplId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3786, '320', 'menu_url', '菜单URL', 'varchar(255)', 'String', 'menuUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3787, '320', 'menu_sort', '排序', 'varchar(32)', 'String', 'menuSort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3788, '320', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3789, '320', 'miniprogram_appid', '小程序appid', 'varchar(32)', 'String', 'miniprogramAppid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3790, '320', 'miniprogram_pagepath', '小程序页面路径', 'varchar(200)', 'String', 'miniprogramPagepath', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3791, '320', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3792, '320', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3793, '321', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3794, '321', 'title', '标题', 'varchar(32)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3795, '321', 'digest', '摘要', 'varchar(50)', 'String', 'digest', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3796, '321', 'author', '作者', 'varchar(32)', 'String', 'author', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3797, '321', 'show_cover_pic', '是否展示封面图片（0/1）', 'char(1)', 'String', 'showCoverPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3798, '321', 'thumb_media_id', '上传微信，封面图片标识', 'varchar(50)', 'String', 'thumbMediaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3799, '321', 'content', '内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3800, '321', 'content_source_url', '内容链接', 'varchar(50)', 'String', 'contentSourceUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3801, '321', 'order_no', '文章排序', 'int(11)', 'Long', 'orderNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3802, '321', 'pic_path', '图片路径', 'varchar(255)', 'String', 'picPath', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3803, '321', 'need_open_comment', '是否可以留言', 'varchar(32)', 'String', 'needOpenComment', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3804, '321', 'only_fans_can_comment', '是否仅粉丝可以留言', 'varchar(32)', 'String', 'onlyFansCanComment', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3805, '321', 'news_id', '图文ID', 'varchar(32)', 'String', 'newsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3806, '321', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3807, '321', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3808, '321', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 16, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3809, '322', 'id', '主键 主键ID', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3810, '322', 'tpl_name', '模板名称', 'varchar(32)', 'String', 'tplName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3811, '322', 'is_upload', '是否已上传微信', 'varchar(32)', 'String', 'isUpload', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3812, '322', 'media_id', NULL, 'varchar(50)', 'String', 'mediaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3813, '322', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3814, '322', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3815, '322', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3816, '323', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3817, '323', 'receive_text', '关键字', 'varchar(32)', 'String', 'receiveText', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3818, '323', 'msg_type', '消息类型 1文本消息；2图文消息；', 'varchar(32)', 'String', 'msgType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3819, '323', 'tpl_id', '模板ID', 'varchar(32)', 'String', 'tplId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3820, '323', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3821, '323', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3822, '323', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3823, '324', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3824, '324', 'msg_type', '消息类型 1文本消息；2图文消息；', 'varchar(32)', 'String', 'msgType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3825, '324', 'tpl_id', '模板ID', 'varchar(32)', 'String', 'tplId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3826, '324', 'wx_account_id', '微信账号ID', 'varchar(32)', 'String', 'wxAccountId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3827, '324', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3828, '324', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3829, '325', 'id', '主键', 'int(10)', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3830, '325', 'tpl_name', '模板名字', 'varchar(32)', 'String', 'tplName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3831, '325', 'content', '模板内容', 'varchar(255)', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3832, '325', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3833, '325', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3834, '326', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3835, '326', 'type', '投票类型', 'int(2)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3836, '326', 'status', '状态', 'int(2)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3837, '326', 'name', '标题', 'varchar(33)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3838, '326', 'remark', '备注', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3839, '326', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3840, '326', 'end_time', '过期时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3841, '326', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3842, '326', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3843, '327', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3844, '327', 'phone', '手机', 'varchar(255)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3845, '327', 'toupiao_id', '投票', 'bigint(20)', 'Long', 'toupiaoId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3846, '327', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3847, '327', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3848, '328', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3849, '328', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3850, '328', 'longitude', NULL, 'double(255,0)', 'Long', 'longitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3851, '328', 'latitude', NULL, 'double(255,0)', 'Long', 'latitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3852, '328', 'user_name', NULL, 'varchar(255)', 'String', 'userName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3853, '328', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3854, '328', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3855, '328', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3856, '329', 'id', 'ID', 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3857, '329', 'senderid', '发送人ID', 'bigint(30)', 'Long', 'senderid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3858, '329', 'recipientid', '接收人ID', 'bigint(30)', 'Long', 'recipientid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3859, '329', 'title', '标题', 'text', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3860, '329', 'content', '内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3861, '329', 'time', '时间', 'datetime', 'Date', 'time', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3862, '329', 'type', '1未读  2 已读', 'int(2)', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3863, '330', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3864, '330', 'original_price', NULL, 'int(11)', 'Long', 'originalPrice', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3865, '330', 'price', NULL, 'int(11)', 'Long', 'price', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3866, '330', 'vip_price', NULL, 'int(11)', 'Long', 'vipPrice', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3867, '330', 'title', NULL, 'varchar(255)', 'String', 'title', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3868, '330', 'sales', NULL, 'int(11)', 'Long', 'sales', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3869, '330', 'img', NULL, 'varchar(255)', 'String', 'img', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3870, '330', 'detail', NULL, 'text', 'String', 'detail', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3871, '330', 'description', NULL, 'varchar(255)', 'String', 'description', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3872, '330', 'category_id', NULL, 'bigint(20)', 'Long', 'categoryId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3873, '330', 'freight_template_id', NULL, 'bigint(20)', 'Long', 'freightTemplateId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:45', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3874, '330', 'unit', NULL, 'varchar(255)', 'String', 'unit', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:46', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3875, '330', 'status', NULL, 'int(11)', 'Long', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2020-03-02 19:33:46', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3876, '330', 'gmt_update', NULL, 'datetime', 'Date', 'gmtUpdate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 14, 'admin', '2020-03-02 19:33:46', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3877, '330', 'gmt_create', NULL, 'datetime', 'Date', 'gmtCreate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 15, 'admin', '2020-03-02 19:33:46', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3878, '331', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3879, '331', 'name', '标题', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3880, '331', 'icon', '分类图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:33:55', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3881, '331', 'subject_count', '专题数量', 'int(11)', 'Long', 'subjectCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3882, '331', 'show_status', '状态', 'int(2)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3883, '331', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3884, '331', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3885, '332', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3886, '332', 'subject_id', '所属专题', 'bigint(20)', 'Long', 'subjectId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3887, '332', 'member_nick_name', '用户名', 'varchar(255)', 'String', 'memberNickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3888, '332', 'member_icon', '用户图标', 'varchar(255)', 'String', 'memberIcon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3889, '332', 'content', '内容', 'varchar(1000)', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3890, '332', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3891, '332', 'show_status', '状态', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3892, '332', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3893, '333', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3894, '333', 'subject_id', NULL, 'bigint(20)', 'Long', 'subjectId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3895, '333', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3896, '333', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3897, '334', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3898, '334', 'member_id', '会员编号', 'int(11)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3899, '334', 'phone', '会员手机', 'varchar(255)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3900, '334', 'status', '审核状态', 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3901, '334', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3902, '334', 'update_time', '审核时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3903, '334', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3904, '335', 'id', '编号', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3905, '335', 'member_id', '邀请人', 'int(11)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3906, '335', 'invite_id', '被邀请人', 'int(11)', 'Long', 'inviteId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:56', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3907, '335', 'level', '邀请级别', 'int(255)', 'Long', 'level', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3908, '335', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3909, '335', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3910, '336', 'id', NULL, 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3911, '336', 'name', '发票抬头', 'varchar(80)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3912, '336', 'code', '发票税号', 'varchar(30)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3913, '336', 'frequency', '被使用次数', 'mediumint(6) unsigned', 'Integer', 'frequency', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3914, '337', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3915, '337', 'valid_day', '有效期(天)', 'int(5)', 'Integer', 'validDay', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3916, '337', 'min_integration', '最小积分', 'int(5)', 'Integer', 'minIntegration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3917, '337', 'max_integration', '最大积分', 'int(5)', 'Integer', 'maxIntegration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3918, '337', 'remark', '备注', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3919, '337', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3920, '337', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3921, '337', 'count', NULL, 'int(11)', 'Long', 'count', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3922, '338', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3923, '338', 'donate_type', '赠送类别', 'varchar(50)', 'String', 'donateType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3924, '338', 'donate_condtion', '赠送条件', 'decimal(40,0)', 'Long', 'donateCondtion', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3925, '338', 'donate_integration', '赠送积分', 'int(5)', 'Integer', 'donateIntegration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3926, '338', 'store_id', '店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3927, '339', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3928, '339', 'contineu_count', '连续签到', 'int(5)', 'Integer', 'contineuCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3929, '339', 'donate_integrtion', '赠送积分', 'int(5)', 'Integer', 'donateIntegrtion', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3930, '339', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3931, '340', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3932, '340', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3933, '340', 'order_sn', '订单编号', 'varchar(64)', 'String', 'orderSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3934, '340', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3935, '340', 'product_pic', NULL, 'varchar(500)', 'String', 'productPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3936, '340', 'product_name', NULL, 'varchar(200)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3937, '340', 'product_brand', NULL, 'varchar(200)', 'String', 'productBrand', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3938, '340', 'product_sn', NULL, 'varchar(64)', 'String', 'productSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3939, '340', 'product_price', '销售价格', 'decimal(10,2)', 'Double', 'productPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3940, '340', 'product_quantity', '购买数量', 'int(11)', 'Long', 'productQuantity', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3941, '340', 'product_sku_id', '商品sku编号', 'bigint(20)', 'Long', 'productSkuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3942, '340', 'product_sku_code', '商品sku条码', 'varchar(50)', 'String', 'productSkuCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3943, '340', 'product_category_id', '商品分类id', 'bigint(20)', 'Long', 'productCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:33:57', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3944, '340', 'sp1', '商品的销售属性', 'varchar(100)', 'String', 'sp1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3945, '340', 'sp2', NULL, 'varchar(100)', 'String', 'sp2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3946, '340', 'sp3', NULL, 'varchar(100)', 'String', 'sp3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3947, '340', 'promotion_name', '商品促销名称', 'varchar(200)', 'String', 'promotionName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 17, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3948, '340', 'promotion_amount', '商品促销分解金额', 'decimal(10,2)', 'Double', 'promotionAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3949, '340', 'coupon_amount', '优惠券优惠分解金额', 'decimal(10,2)', 'Double', 'couponAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3950, '340', 'integration_amount', '积分优惠分解金额', 'decimal(10,2)', 'Double', 'integrationAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3951, '340', 'real_amount', '该商品经过优惠后的分解金额', 'decimal(10,2)', 'Double', 'realAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3952, '340', 'gift_integration', NULL, 'int(11)', 'Long', 'giftIntegration', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3953, '340', 'gift_growth', NULL, 'int(11)', 'Long', 'giftGrowth', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 23, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3954, '340', 'product_attr', '商品销售属性:[{\"key\":\"颜色\",\"value\":\"颜色\"},{\"key\":\"容量\",\"value\":\"4G\"}]', 'varchar(500)', 'String', 'productAttr', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 24, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3955, '340', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3956, '340', 'status', NULL, 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 26, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3957, '340', 'type', NULL, 'int(4)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 27, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3958, '340', 'store_name', NULL, 'varchar(255)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 28, 'admin', '2020-03-02 19:33:58', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (3959, '341', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3960, '341', 'order_id', '订单编号', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3961, '341', 'operate_man', '操作人', 'varchar(100)', 'String', 'operateMan', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3962, '341', 'create_time', '操作时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3963, '341', 'order_status', '订单状态', 'int(1)', 'Integer', 'orderStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'order_status', 5, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3964, '341', 'note', '备注', 'varchar(500)', 'String', 'note', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 6, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3965, '341', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3966, '341', 'pre_status', '前状态', 'int(4)', 'Integer', 'preStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'order_status', 8, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3967, '341', 'order_item_id', '订单商品编号', 'int(11)', 'Long', 'orderItemId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:12:20');
INSERT INTO `admin_gen_table_column` VALUES (3968, '342', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3969, '342', 'order_id', '订单ID', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3970, '342', 'company_address_id', '收货地址表id', 'bigint(20)', 'Long', 'companyAddressId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3971, '342', 'product_id', '退货商品编号', 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3972, '342', 'order_sn', '订单编号', 'varchar(64)', 'String', 'orderSn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3973, '342', 'create_time', '申请时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3974, '342', 'member_username', '会员用户名', 'varchar(64)', 'String', 'memberUsername', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3975, '342', 'return_amount', '退款金额', 'decimal(10,2)', 'Double', 'returnAmount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3976, '342', 'return_name', '退货人姓名', 'varchar(100)', 'String', 'returnName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 9, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3977, '342', 'return_phone', '退货人电话', 'varchar(100)', 'String', 'returnPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3978, '342', 'status', '申请状态：0-&gt;待处理；1-&gt;退货中；2-&gt;已完成；3-&gt;已拒绝', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 11, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3979, '342', 'handle_time', '处理时间', 'datetime', 'Date', 'handleTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 12, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3980, '342', 'product_pic', '商品图片', 'varchar(500)', 'String', 'productPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 13, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3981, '342', 'product_name', '商品名称', 'varchar(200)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 14, 'admin', '2020-03-02 19:33:58', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3982, '342', 'product_brand', '商品品牌', 'varchar(200)', 'String', 'productBrand', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:30');
INSERT INTO `admin_gen_table_column` VALUES (3983, '342', 'product_attr', '商品销售属性：颜色：红色；尺码：xl;', 'varchar(500)', 'String', 'productAttr', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 16, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3984, '342', 'product_count', '退货数量', 'int(11)', 'Long', 'productCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3985, '342', 'product_price', '商品单价', 'decimal(10,2)', 'Double', 'productPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3986, '342', 'product_real_price', '商品实际支付单价', 'decimal(10,2)', 'Double', 'productRealPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3987, '342', 'reason', '原因', 'varchar(200)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3988, '342', 'description', '描述', 'varchar(500)', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 21, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3989, '342', 'proof_pics', '凭证图片，以逗号隔开', 'varchar(1000)', 'String', 'proofPics', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 22, 'admin', '2020-03-02 19:33:59', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3990, '342', 'handle_note', '处理备注', 'varchar(500)', 'String', 'handleNote', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 23, 'admin', '2020-03-02 19:34:00', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3991, '342', 'handle_man', '处理人员', 'varchar(100)', 'String', 'handleMan', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2020-03-02 19:34:00', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3992, '342', 'receive_man', '收货人', 'varchar(100)', 'String', 'receiveMan', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-03-02 19:34:00', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3993, '342', 'receive_time', '收货时间', 'datetime', 'Date', 'receiveTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 26, 'admin', '2020-03-02 19:34:00', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3994, '342', 'receive_note', '收货备注', 'varchar(500)', 'String', 'receiveNote', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 27, 'admin', '2020-03-02 19:34:00', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3995, '342', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 28, 'admin', '2020-03-02 19:34:00', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3996, '342', 'type', 'null', 'int(3)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 29, 'admin', '2020-03-02 19:34:01', NULL, '2020-03-04 10:13:31');
INSERT INTO `admin_gen_table_column` VALUES (3997, '343', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:01', NULL, '2020-03-04 10:09:48');
INSERT INTO `admin_gen_table_column` VALUES (3998, '343', 'name', '退货类型', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:01', NULL, '2020-03-04 10:09:48');
INSERT INTO `admin_gen_table_column` VALUES (3999, '343', 'sort', '排列', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:01', NULL, '2020-03-04 10:09:48');
INSERT INTO `admin_gen_table_column` VALUES (4000, '343', 'status', '状态', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 4, 'admin', '2020-03-02 19:34:01', NULL, '2020-03-04 10:09:48');
INSERT INTO `admin_gen_table_column` VALUES (4001, '343', 'create_time', '添加时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:09:48');
INSERT INTO `admin_gen_table_column` VALUES (4002, '343', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:09:48');
INSERT INTO `admin_gen_table_column` VALUES (4003, '344', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:48');
INSERT INTO `admin_gen_table_column` VALUES (4004, '344', 'flash_order_overtime', '秒杀订单超时关闭时间(分)', 'int(11)', 'Long', 'flashOrderOvertime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:49');
INSERT INTO `admin_gen_table_column` VALUES (4005, '344', 'normal_order_overtime', '正常订单超时时间(分)', 'int(11)', 'Long', 'normalOrderOvertime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:49');
INSERT INTO `admin_gen_table_column` VALUES (4006, '344', 'confirm_overtime', '发货后自动确认收货时间（天）', 'int(11)', 'Long', 'confirmOvertime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:49');
INSERT INTO `admin_gen_table_column` VALUES (4007, '344', 'finish_overtime', '自动完成交易时间，不能申请售后（天）', 'int(11)', 'Long', 'finishOvertime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:49');
INSERT INTO `admin_gen_table_column` VALUES (4008, '344', 'comment_overtime', '订单完成后自动好评时间（天）', 'int(11)', 'Long', 'commentOvertime', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:49');
INSERT INTO `admin_gen_table_column` VALUES (4009, '344', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:07:49');
INSERT INTO `admin_gen_table_column` VALUES (4010, '345', 'id', 'null', 'int(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:20');
INSERT INTO `admin_gen_table_column` VALUES (4011, '345', 'name', '配送方式名称', 'varchar(50)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:20');
INSERT INTO `admin_gen_table_column` VALUES (4012, '345', 'has_cod', '是否货到付款 1=不是货到付款 2=是货到付款', 'tinyint(1) unsigned', 'Integer', 'hasCod', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:20');
INSERT INTO `admin_gen_table_column` VALUES (4013, '345', 'firstunit', '首重', 'mediumint(8) unsigned', 'Integer', 'firstunit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:20');
INSERT INTO `admin_gen_table_column` VALUES (4014, '345', 'continueunit', '续重', 'mediumint(8) unsigned', 'Integer', 'continueunit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4015, '345', 'def_area_fee', '按地区设置配送费用是否启用默认配送费用 1=启用 2=不启用', 'tinyint(1) unsigned', 'Integer', 'defAreaFee', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4016, '345', 'type', '地区类型 1=全部地区 2=指定地区', 'tinyint(1) unsigned', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4017, '345', 'firstunit_price', '首重费用', 'decimal(10,2) unsigned', 'Double', 'firstunitPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4018, '345', 'continueunit_price', '续重费用', 'decimal(10,2) unsigned', 'Double', 'continueunitPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4019, '345', 'exp', '配送费用计算表达式', 'text', 'String', 'exp', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4020, '345', 'logi_name', '物流公司名称', 'varchar(50)', 'String', 'logiName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 11, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4021, '345', 'logi_code', '物流公司编码', 'varchar(50)', 'String', 'logiCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4022, '345', 'is_def', '是否默认 1=默认 2=不默认', 'tinyint(1) unsigned', 'Integer', 'isDef', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4023, '345', 'sort', '配送方式排序 越小越靠前', 'smallint(5) unsigned', 'Integer', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4024, '345', 'status', '状态 1=正常 2=停用', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 15, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4025, '345', 'free_postage', '是否包邮，1包邮，2不包邮', 'tinyint(1) unsigned', 'Integer', 'freePostage', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4026, '345', 'area_fee', '地区配送费用', 'text', 'String', 'areaFee', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4027, '345', 'goodsmoney', '商品总额满多少免运费', 'decimal(20,2)', 'Double', 'goodsmoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4028, '345', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:34:02', NULL, '2020-03-04 10:08:21');
INSERT INTO `admin_gen_table_column` VALUES (4029, '346', 'id', 'ID', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:02', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4030, '346', 'create_time', '上传日期', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 2, 'admin', '2020-03-02 19:34:02', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4031, '346', 'delete_url', '删除的URL', 'varchar(255)', 'String', 'deleteUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:02', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4032, '346', 'filename', '图片名称', 'varchar(255)', 'String', 'filename', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:34:02', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4033, '346', 'height', '图片高度', 'varchar(255)', 'String', 'height', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:02', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4034, '346', 'size', '图片大小', 'varchar(255)', 'String', 'size', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4035, '346', 'url', '图片地址', 'varchar(255)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4036, '346', 'username', '用户名称', 'varchar(255)', 'String', 'username', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4037, '346', 'width', '图片宽度', 'varchar(255)', 'String', 'width', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4038, '346', 'md5code', NULL, 'varchar(255)', 'String', 'md5code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4039, '347', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4040, '347', 'name', NULL, 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4041, '347', 'pic', NULL, 'varchar(200)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4042, '347', 'type', NULL, 'varchar(11)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4043, '347', 'sort', NULL, 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4044, '347', 'description', NULL, 'varchar(1000)', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 6, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4045, '347', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4046, '348', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4047, '348', 'album_id', NULL, 'bigint(20)', 'Long', 'albumId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4048, '348', 'pic', NULL, 'varchar(300)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4049, '348', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4050, '348', 'name', NULL, 'varchar(40)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4051, '348', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4052, '348', 'type', NULL, 'varchar(20)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4053, '348', 'user_id', NULL, 'bigint(20)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4054, '349', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4055, '349', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4056, '349', 'member_nick_name', NULL, 'varchar(255)', 'String', 'memberNickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4057, '349', 'product_name', NULL, 'varchar(255)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4058, '349', 'star', '评价星数：0->5', 'int(3)', 'Integer', 'star', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4059, '349', 'member_ip', '评价的ip', 'varchar(64)', 'String', 'memberIp', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4060, '349', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4061, '349', 'show_status', NULL, 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4062, '349', 'product_attribute', '购买时的商品属性', 'varchar(255)', 'String', 'productAttribute', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4063, '349', 'collect_couont', NULL, 'int(11)', 'Long', 'collectCouont', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4064, '349', 'read_count', NULL, 'int(11)', 'Long', 'readCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4065, '349', 'content', NULL, 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4066, '349', 'pics', '上传图片地址，以逗号隔开', 'varchar(1000)', 'String', 'pics', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 13, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4067, '349', 'member_icon', '评论用户头像', 'varchar(255)', 'String', 'memberIcon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4068, '349', 'replay_count', NULL, 'int(11)', 'Long', 'replayCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4069, '349', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4070, '350', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4071, '350', 'comment_id', NULL, 'bigint(20)', 'Long', 'commentId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4072, '350', 'member_nick_name', NULL, 'varchar(255)', 'String', 'memberNickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4073, '350', 'member_icon', NULL, 'varchar(255)', 'String', 'memberIcon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:03', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4074, '350', 'content', NULL, 'varchar(1000)', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4075, '350', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4076, '350', 'type', '评论人员类型；0->会员；1->管理员', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4077, '350', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4078, '351', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:13');
INSERT INTO `admin_gen_table_column` VALUES (4079, '351', 'category_id', '类别', 'bigint(20)', 'Long', 'categoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:13');
INSERT INTO `admin_gen_table_column` VALUES (4080, '351', 'icon', '图片', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:13');
INSERT INTO `admin_gen_table_column` VALUES (4081, '351', 'title', '标题', 'varchar(100)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:13');
INSERT INTO `admin_gen_table_column` VALUES (4082, '351', 'show_status', '状态', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:13');
INSERT INTO `admin_gen_table_column` VALUES (4083, '351', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:14');
INSERT INTO `admin_gen_table_column` VALUES (4084, '351', 'content', '内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:14');
INSERT INTO `admin_gen_table_column` VALUES (4085, '351', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:14');
INSERT INTO `admin_gen_table_column` VALUES (4086, '351', 'type', '1 赠品 2 活动商品', 'int(255)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 9, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:14');
INSERT INTO `admin_gen_table_column` VALUES (4087, '351', 'price', 'null', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:14');
INSERT INTO `admin_gen_table_column` VALUES (4088, '351', 'stock', 'null', 'int(11)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:25:14');
INSERT INTO `admin_gen_table_column` VALUES (4089, '352', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:26:20');
INSERT INTO `admin_gen_table_column` VALUES (4090, '352', 'name', '标题', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:26:21');
INSERT INTO `admin_gen_table_column` VALUES (4091, '352', 'icon', '分类图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:26:21');
INSERT INTO `admin_gen_table_column` VALUES (4092, '352', 'show_status', '状态', 'int(2)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 4, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:26:21');
INSERT INTO `admin_gen_table_column` VALUES (4093, '352', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:26:21');
INSERT INTO `admin_gen_table_column` VALUES (4094, '352', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:26:21');
INSERT INTO `admin_gen_table_column` VALUES (4095, '353', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4096, '353', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4097, '353', 'member_level_id', NULL, 'bigint(20)', 'Long', 'memberLevelId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4098, '353', 'member_price', '会员价格', 'decimal(10,2)', 'Double', 'memberPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4099, '353', 'member_level_name', NULL, 'varchar(100)', 'String', 'memberLevelName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4100, '353', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:04', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4101, '354', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4102, '354', 'product_attribute_category_id', '类别', 'bigint(20)', 'Long', 'productAttributeCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4103, '354', 'name', '名称', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4104, '354', 'select_type', '属性选择类型：0-&gt;唯一；1-&gt;单选；2-&gt;多选', 'int(1)', 'Integer', 'selectType', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4105, '354', 'input_type', '属性录入方式：0-&gt;手工录入；1-&gt;从列表中选取', 'int(1)', 'Integer', 'inputType', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'select', '', 5, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4106, '354', 'input_list', '可选值列表，以逗号隔开', 'varchar(255)', 'String', 'inputList', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4107, '354', 'sort', '排序字段：最高的可以单独上传图片', 'int(11)', 'Long', 'sort', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4108, '354', 'filter_type', '分类筛选样式：1-&gt;普通；1-&gt;颜色', 'int(1)', 'Integer', 'filterType', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'select', '', 8, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4109, '354', 'search_type', '检索类型；0-&gt;不需要进行检索；1-&gt;关键字检索；2-&gt;范围检索', 'int(1)', 'Integer', 'searchType', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'select', '', 9, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4110, '354', 'related_status', '相同属性产品是否关联；0-&gt;不关联；1-&gt;关联', 'int(1)', 'Integer', 'relatedStatus', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'radio', '', 10, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4111, '354', 'hand_add_status', '是否支持手动新增；0-&gt;不支持；1-&gt;支持', 'int(1)', 'Integer', 'handAddStatus', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'radio', '', 11, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4112, '354', 'type', '属性的类型；0-&gt;规格；1-&gt;参数', 'int(1)', 'Integer', 'type', '0', '0', NULL, NULL, NULL, NULL, NULL, 'EQ', 'select', '', 12, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4113, '354', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:27:49');
INSERT INTO `admin_gen_table_column` VALUES (4114, '355', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, '1', NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:28:53');
INSERT INTO `admin_gen_table_column` VALUES (4115, '355', 'name', '名称', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:04', NULL, '2020-03-04 20:28:53');
INSERT INTO `admin_gen_table_column` VALUES (4116, '355', 'attribute_count', '属性数量', 'int(11)', 'Long', 'attributeCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:28:53');
INSERT INTO `admin_gen_table_column` VALUES (4117, '355', 'param_count', '参数数量', 'int(11)', 'Long', 'paramCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:28:53');
INSERT INTO `admin_gen_table_column` VALUES (4118, '355', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:28:53');
INSERT INTO `admin_gen_table_column` VALUES (4119, '355', 'pic', '图片', 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:28:53');
INSERT INTO `admin_gen_table_column` VALUES (4120, '356', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4121, '356', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4122, '356', 'product_attribute_id', NULL, 'bigint(20)', 'Long', 'productAttributeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4123, '356', 'value', '手动添加规格或参数的值，参数单值，规格有多个时以逗号隔开', 'varchar(64)', 'String', 'value', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4124, '356', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4125, '356', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4126, '356', 'type', NULL, 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4127, '357', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4128, '357', 'parent_id', '上机分类', 'bigint(20)', 'Long', 'parentId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4129, '357', 'name', '名称', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4130, '357', 'level', '分类级别', 'int(1)', 'Integer', 'level', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4131, '357', 'product_count', 'null', 'int(11)', 'Long', 'productCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4132, '357', 'product_unit', 'null', 'varchar(64)', 'String', 'productUnit', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4133, '357', 'nav_status', '是否显示在导航栏：0-&gt;不显示；1-&gt;显示', 'int(1)', 'Integer', 'navStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 7, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4134, '357', 'show_status', '显示状态', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 8, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4135, '357', 'index_status', '是否是首页分类', 'int(1)', 'Integer', 'indexStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', 'sys_yes_no', 9, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4136, '357', 'sort', '排列', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4137, '357', 'icon', '图标', 'varchar(255)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4138, '357', 'keywords', 'null', 'varchar(255)', 'String', 'keywords', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4139, '357', 'description', '描述', 'text', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4140, '357', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:05', NULL, '2020-03-04 20:24:09');
INSERT INTO `admin_gen_table_column` VALUES (4141, '358', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4142, '358', 'product_category_id', NULL, 'bigint(20)', 'Long', 'productCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4143, '358', 'product_attribute_id', NULL, 'bigint(20)', 'Long', 'productAttributeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4144, '358', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:05', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4145, '359', 'id', '咨询编号', 'bigint(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4146, '359', 'goods_id', '商品编号', 'bigint(11) unsigned', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4147, '359', 'goods_name', '商品名称', 'varchar(100)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4148, '359', 'member_id', '咨询发布者会员编号(0：游客)', 'bigint(11)', 'Long', 'memberId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4149, '359', 'member_name', '会员名称', 'varchar(100)', 'String', 'memberName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4150, '359', 'store_id', '店铺编号', 'bigint(11) unsigned', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4151, '359', 'email', '咨询发布者邮箱', 'varchar(255)', 'String', 'email', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4152, '359', 'consult_content', '咨询内容', 'varchar(255)', 'String', 'consultContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4153, '359', 'consult_addtime', '咨询添加时间', 'datetime', 'Date', 'consultAddtime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4154, '359', 'consult_reply', '咨询回复内容', 'varchar(255)', 'String', 'consultReply', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4155, '359', 'consult_reply_time', '咨询回复时间', 'datetime', 'Date', 'consultReplyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 11, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4156, '359', 'isanonymous', '0表示不匿名 1表示匿名', 'tinyint(1)', 'Integer', 'isanonymous', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4157, '359', 'is_del', NULL, 'tinyint(1)', 'Integer', 'isDel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4158, '359', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4159, '359', 'attr', NULL, 'varchar(255)', 'String', 'attr', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4160, '359', 'stars', NULL, 'int(11)', 'Long', 'stars', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4161, '359', 'order_id', NULL, 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4162, '359', 'type', '1 商品 2 订单', 'int(4)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 18, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4163, '360', 'id', NULL, 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4164, '360', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4165, '360', 'full_price', NULL, 'decimal(10,2)', 'Double', 'fullPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4166, '360', 'reduce_price', NULL, 'decimal(10,2)', 'Double', 'reducePrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4167, '360', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4168, '361', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4169, '361', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4170, '361', 'count', '满足的商品数量', 'int(11)', 'Long', 'count', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4171, '361', 'discount', '折扣', 'decimal(10,2)', 'Double', 'discount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4172, '361', 'price', '折后价格', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4173, '361', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:06', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4174, '362', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4175, '362', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4176, '362', 'price_old', NULL, 'decimal(10,2)', 'Double', 'priceOld', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4177, '362', 'price_new', NULL, 'decimal(10,2)', 'Double', 'priceNew', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4178, '362', 'sale_price_old', NULL, 'decimal(10,2)', 'Double', 'salePriceOld', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4179, '362', 'sale_price_new', NULL, 'decimal(10,2)', 'Double', 'salePriceNew', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4180, '362', 'gift_point_old', '赠送的积分', 'int(11)', 'Long', 'giftPointOld', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4181, '362', 'gift_point_new', NULL, 'int(11)', 'Long', 'giftPointNew', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4182, '362', 'use_point_limit_old', NULL, 'int(11)', 'Long', 'usePointLimitOld', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4183, '362', 'use_point_limit_new', NULL, 'int(11)', 'Long', 'usePointLimitNew', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4184, '362', 'operate_man', '操作人', 'varchar(64)', 'String', 'operateMan', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4185, '362', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4186, '362', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4187, '363', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4188, '363', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4189, '363', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4190, '363', 'vertify_man', '审核人', 'varchar(64)', 'String', 'vertifyMan', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4191, '363', 'status', NULL, 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4192, '363', 'detail', '反馈详情', 'varchar(255)', 'String', 'detail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4193, '363', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:07', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4194, '364', 'id', 'null', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4195, '364', 'product_id', '商品', 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4196, '364', 'sku_code', 'sku编码', 'varchar(64)', 'String', 'skuCode', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4197, '364', 'price', '价格', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4198, '364', 'stock', '库存', 'int(11)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4199, '364', 'low_stock', '预警库存', 'int(11)', 'Long', 'lowStock', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4200, '364', 'sp1', '售属性1', 'varchar(64)', 'String', 'sp1', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4201, '364', 'sp2', '售属性2', 'varchar(64)', 'String', 'sp2', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4202, '364', 'sp3', '售属性3', 'varchar(64)', 'String', 'sp3', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4203, '364', 'pic', '展示图片', 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4204, '364', 'sale', '销量', 'int(11)', 'Long', 'sale', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:07', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4205, '364', 'promotion_price', '单品促销价格', 'decimal(10,2)', 'Double', 'promotionPrice', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:08', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4206, '364', 'lock_stock', '锁定库存', 'int(11)', 'Long', 'lockStock', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:08', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4207, '364', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:08', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4208, '364', 'product_name', '商品名称', 'varchar(255)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 15, 'admin', '2020-03-02 19:34:08', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4209, '364', 'sp4', 'null', 'varchar(255)', 'String', 'sp4', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:34:08', NULL, '2020-03-04 19:11:54');
INSERT INTO `admin_gen_table_column` VALUES (4210, '365', 'id', '小程序首页分类ID', 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4211, '365', 'title', '分类名称', 'varchar(200)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4212, '365', 'icon', '分类图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4213, '365', 'summary', '跳转页面', 'varchar(200)', 'String', 'summary', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4214, '365', 'content', '跳转类型', 'varchar(50)', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4215, '365', 'sort', '排序', 'int(10)', 'Integer', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4216, '365', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4217, '365', 'pc_url', NULL, 'varchar(255)', 'String', 'pcUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4218, '366', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4219, '366', 'parameter', '每次砍价的参数', 'varchar(11)', 'String', 'parameter', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4220, '366', 'invalid_time', '逾期失效时间', 'datetime', 'Date', 'invalidTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 3, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4221, '366', 'create_time', '修改时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4222, '366', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4223, '366', 'goods_id', '商品', 'int(11)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4224, '366', 'origin_price', '原价', 'decimal(10,2)', 'Double', 'originPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4225, '366', 'price', '成功价', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4226, '366', 'goods_name', NULL, 'varchar(255)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 9, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4227, '366', 'pepoles', NULL, 'int(3)', 'Integer', 'pepoles', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4228, '366', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4229, '367', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4230, '367', 'bargin_record_id', NULL, 'bigint(20)', 'Long', 'barginRecordId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4231, '367', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4232, '367', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4233, '367', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4234, '367', 'status', '状态', 'int(11)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4235, '367', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4236, '367', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4237, '367', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4238, '367', 'price', NULL, 'decimal(18,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4239, '367', 'bargin_id', NULL, 'bigint(20)', 'Long', 'barginId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4240, '368', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:08', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4241, '368', 'member_id', '用户ID', 'bigint(15)', 'Long', 'memberId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4242, '368', 'create_time', '添加时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4243, '368', 'name', '收货人', 'varchar(15)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4244, '368', 'status', '状态 0:砍价中 1:砍价成功 2:逾期失效 3:生成订单', 'tinyint(4)', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4245, '368', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4246, '368', 'bargin_id', NULL, 'bigint(20)', 'Long', 'barginId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4247, '368', 'shareimg', NULL, 'varchar(255)', 'String', 'shareimg', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4248, '368', 'spreadpic', NULL, 'varchar(255)', 'String', 'spreadpic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4249, '368', 'order_id', NULL, 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4250, '369', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4251, '369', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4252, '369', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4253, '369', 'status', '1 有效2 无效', 'int(255)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4254, '369', 'activi_user', '活动对象1全部用户2 会员级别', 'int(255)', 'Long', 'activiUser', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4255, '369', 'activi_goods', '活动商品', 'int(255)', 'Long', 'activiGoods', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4256, '369', 'big_type', '1 首购礼 2 满 购礼 3 单品礼赠', 'int(255)', 'Long', 'bigType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4257, '369', 'small_type', '首购礼 1第一单获取 2所有订单获取 ； 满购礼1选赠礼 获取规则 2满赠礼', 'int(255)', 'Long', 'smallType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 8, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4258, '369', 'rules', '规则', 'varchar(255)', 'String', 'rules', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4259, '369', 'goods_ids', '部分商品列表', 'varchar(555)', 'String', 'goodsIds', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 10, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4260, '369', 'user_level', '会员级别', 'varchar(555)', 'String', 'userLevel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4261, '369', 'start_time', NULL, 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 12, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4262, '369', 'end_time', NULL, 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 13, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4263, '369', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4264, '369', 'gift_ids', '赠品', 'varchar(4000)', 'String', 'giftIds', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 15, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4265, '369', 'note', NULL, 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4266, '370', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4267, '370', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4268, '370', 'status', '1 有效2 无效', 'int(255)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4269, '370', 'activi_user', '活动对象1全部用户2 会员级别', 'int(255)', 'Long', 'activiUser', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4270, '370', 'activi_goods', '活动商品', 'int(255)', 'Long', 'activiGoods', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4271, '370', 'big_type', '1 满减 2 折扣', 'int(255)', 'Long', 'bigType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4272, '370', 'small_type', '1消费金额 2 购买件数', 'int(255)', 'Long', 'smallType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4273, '370', 'rules', '规则', 'varchar(1000)', 'String', 'rules', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 8, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4274, '370', 'goods_ds', '部分商品列表', 'varchar(255)', 'String', 'goodsDs', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:09', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4275, '370', 'user_level', '会员级别', 'varchar(500)', 'String', 'userLevel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 10, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4276, '370', 'start_time', NULL, 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 11, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4277, '370', 'end_time', NULL, 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 12, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4278, '370', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 13, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4279, '370', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4280, '370', 'note', NULL, 'varchar(255)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4281, '371', 'id', '配置id', 'bigint(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4282, '371', 'name', '配置名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4283, '371', 'color', '颜色', 'char(15)', 'String', 'color', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4284, '371', 'size', '尺码', 'varchar(100)', 'String', 'size', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4285, '371', 'costprice', '成本价', 'decimal(12,2)', 'Double', 'costprice', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4286, '371', 'price', '出售价格', 'decimal(12,2)', 'Double', 'price', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4287, '371', 'yprice', '原价格', 'decimal(12,2)', 'Double', 'yprice', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4288, '371', 'img', '图片', 'varchar(255)', 'String', 'img', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4289, '371', 'pid', '商品id', 'int(11)', 'Long', 'pid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4290, '371', 'num', '库存', 'int(11)', 'Long', 'num', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4291, '371', 'unit', '单位', 'varchar(30)', 'String', 'unit', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4292, '371', 'bargain_price', '砍价开始价格', 'decimal(12,2)', 'Double', 'bargainPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4293, '371', 'status', '状态 0:未开启砍价 1:开启砍价 2 上架 3 缺货 4下架', 'tinyint(4)', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4294, '371', 'attribute', '属性', 'text', 'String', 'attribute', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4295, '371', 'recycle', '回收站 0.不回收 1.回收', 'tinyint(4)', 'Integer', 'recycle', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4296, '371', 'total_num', '总库存', 'int(11)', 'Long', 'totalNum', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4297, '371', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4298, '372', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4299, '372', 'name', '内容标题', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4300, '372', 'type', '消息类型', 'varchar(255)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4301, '372', 'meno', '标签说明', 'varchar(44)', 'String', 'meno', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4302, '372', 'code', '短信模版CODE', 'varchar(255)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4303, '372', 'remark', '内容模版', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4304, '372', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4305, '372', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4306, '373', 'id', NULL, 'int(11)', 'Long', 'id', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4307, '373', 'phone', NULL, 'varchar(25)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4308, '373', 'status', NULL, 'int(3)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4309, '373', 'content', NULL, 'varchar(255)', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4310, '373', 'result', NULL, 'varchar(255)', 'String', 'result', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4311, '373', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4312, '373', 'content_id', NULL, 'int(11)', 'Long', 'contentId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:10', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4313, '373', 'type', NULL, 'int(5)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 8, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4314, '373', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4315, '374', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4316, '374', 'type', '优惠卷类型；0->全场赠券；1->会员赠券；2->购物赠券；3->注册赠券', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4317, '374', 'name', NULL, 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4318, '374', 'platform', '使用平台：0->全部；1->移动；2->PC', 'int(1)', 'Integer', 'platform', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4319, '374', 'count', '数量', 'int(11)', 'Long', 'count', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4320, '374', 'amount', '金额', 'decimal(10,2)', 'Double', 'amount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4321, '374', 'per_limit', '每人限领张数', 'int(11)', 'Long', 'perLimit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4322, '374', 'min_point', '使用门槛；0表示无门槛', 'decimal(10,2)', 'Double', 'minPoint', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4323, '374', 'start_time', NULL, 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4324, '374', 'end_time', NULL, 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4325, '374', 'use_type', '使用类型：0->全场通用；1->指定分类；2->指定商品', 'int(1)', 'Integer', 'useType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 11, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4326, '374', 'note', '备注', 'varchar(200)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4327, '374', 'publish_count', '发行数量', 'int(11)', 'Long', 'publishCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4328, '374', 'use_count', '已使用数量', 'int(11)', 'Long', 'useCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4329, '374', 'receive_count', '领取数量', 'int(11)', 'Long', 'receiveCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4330, '374', 'enable_time', '可以领取的日期', 'datetime', 'Date', 'enableTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 16, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4331, '374', 'code', '优惠码', 'varchar(64)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4332, '374', 'member_level', '可领取的会员类型：0->无限时', 'int(1)', 'Integer', 'memberLevel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4333, '374', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4334, '375', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4335, '375', 'coupon_id', NULL, 'bigint(20)', 'Long', 'couponId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4336, '375', 'product_category_id', NULL, 'bigint(20)', 'Long', 'productCategoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4337, '375', 'product_category_name', '产品分类名称', 'varchar(200)', 'String', 'productCategoryName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4338, '375', 'parent_category_name', '父分类名称', 'varchar(200)', 'String', 'parentCategoryName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4339, '375', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4340, '376', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4341, '376', 'name', '分类名', 'varchar(25)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4342, '376', 'store_id', '多商户id', 'int(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4343, '377', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4344, '377', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4345, '377', 'goods_name', '商品', 'varchar(255)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4346, '377', 'origin_price', '商品价格', 'decimal(10,0)', 'Long', 'originPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4347, '377', 'group_price', '拼团价格', 'decimal(10,0)', 'Long', 'groupPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4348, '377', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:34:11', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4349, '377', 'end_time', '结束时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4350, '377', 'hours', '拼团小时', 'int(11)', 'Long', 'hours', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4351, '377', 'peoples', '成团人数', 'int(11)', 'Long', 'peoples', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4352, '377', 'status', '状态', 'int(11)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 10, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4353, '377', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4354, '377', 'max_people', '拼团总人数', 'int(11)', 'Long', 'maxPeople', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4355, '377', 'limit_goods', '团购次数', 'int(11)', 'Long', 'limitGoods', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4356, '377', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4357, '377', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4358, '378', 'id', 'null', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:51');
INSERT INTO `admin_gen_table_column` VALUES (4359, '378', 'name', '活动名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:51');
INSERT INTO `admin_gen_table_column` VALUES (4360, '378', 'price', '活动价格', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4361, '378', 'transfee', '运费', 'decimal(10,0)', 'Long', 'transfee', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4362, '378', 'status', '活动状态 1 开启 2 关闭', 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4363, '378', 'feestatus', '1 买家承担 2 卖家承担', 'int(4)', 'Integer', 'feestatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4364, '378', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4365, '378', 'store_id', 'null', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4366, '378', 'goods_ids', 'null', 'varchar(255)', 'String', 'goodsIds', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4367, '378', 'pic', 'null', 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4368, '378', 'originprice', 'null', 'decimal(10,2)', 'Double', 'originprice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:12', NULL, '2020-03-04 01:19:52');
INSERT INTO `admin_gen_table_column` VALUES (4369, '379', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4370, '379', 'group_record_id', NULL, 'bigint(20)', 'Long', 'groupRecordId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4371, '379', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4372, '379', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4373, '379', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4374, '379', 'status', '状态', 'int(11)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4375, '379', 'order_id', NULL, 'varchar(11)', 'String', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4376, '379', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4377, '379', 'exipre_time', NULL, 'bigint(20)', 'Long', 'exipreTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4378, '379', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4379, '379', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4380, '380', 'id', 'id', 'bigint(11) unsigned', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4381, '380', 'user_id', '用户id', 'char(15)', 'String', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4382, '380', 'wx_id', '微信id', 'varchar(50)', 'String', 'wxId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4383, '380', 'wx_name', '微信昵称', 'varchar(150)', 'String', 'wxName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4384, '380', 'sex', '性别 0:未知 1:男 2:女', 'int(11)', 'Long', 'sex', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4385, '380', 'type', '类别 0：新闻 1：文章', 'tinyint(4)', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:34:12', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4386, '380', 'Article_id', '新闻id', 'bigint(11)', 'Long', 'articleId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:34:13', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4387, '380', 'share_add', '分享时间', 'timestamp', 'Date', 'shareAdd', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-03-02 19:34:13', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4388, '380', 'coupon', '礼券', 'decimal(12,2)', 'Double', 'coupon', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:34:13', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4389, '380', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:34:13', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4390, '381', 'aftersales_id', '售后单id', 'varchar(20)', 'String', 'aftersalesId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4391, '381', 'order_id', '订单ID 关联order.id', 'varchar(20)', 'String', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4392, '381', 'user_id', '用户ID 关联user.id', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4393, '381', 'type', '售后类型，1=只退款，2退款退货', 'tinyint(1) unsigned', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4394, '381', 'refund', '退款金额', 'decimal(10,2) unsigned', 'Double', 'refund', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4395, '381', 'status', '状态 1=未审核 2=审核通过 3=审核拒绝', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4396, '381', 'reason', '退款原因', 'varchar(255)', 'String', 'reason', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4397, '381', 'mark', '卖家备注，如果审核失败了，会显示到前端', 'varchar(255)', 'String', 'mark', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4398, '381', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:20', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4399, '381', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:21', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4400, '381', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:21', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4401, '382', 'aftersales_id', '售后单id', 'varchar(20)', 'String', 'aftersalesId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:22', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4402, '382', 'image_id', '图片ID', 'char(32)', 'String', 'imageId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:22', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4403, '383', 'id', NULL, 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:22', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4404, '383', 'aftersales_id', '售后单id', 'varchar(20)', 'String', 'aftersalesId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:22', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4405, '383', 'order_items_id', '订单明细ID 关联order_items.id', 'int(10) unsigned', 'Integer', 'orderItemsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4406, '383', 'goods_id', '商品ID 关联goods.id', 'int(10) unsigned', 'Integer', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4407, '383', 'product_id', '货品ID 关联products.id', 'int(10) unsigned', 'Integer', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4408, '383', 'sn', '货品编码', 'varchar(30)', 'String', 'sn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4409, '383', 'bn', '商品编码', 'varchar(30)', 'String', 'bn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4410, '383', 'name', '商品名称', 'varchar(200)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4411, '383', 'image_url', '图片', 'varchar(100)', 'String', 'imageUrl', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4412, '383', 'nums', '数量', 'smallint(5) unsigned', 'Integer', 'nums', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4413, '383', 'addon', '货品明细序列号存储', 'text', 'String', 'addon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4414, '383', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4415, '383', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4416, '384', 'delivery_id', NULL, 'varchar(20)', 'String', 'deliveryId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4417, '384', 'order_id', '订单ID 关联order.id', 'varchar(20)', 'String', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4418, '384', 'user_id', '用户id 关联user.id', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4419, '384', 'logi_code', '物流公司编码', 'varchar(50)', 'String', 'logiCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4420, '384', 'logi_no', '物流单号', 'varchar(50)', 'String', 'logiNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4421, '384', 'logi_information', '快递物流信息', 'longtext', 'String', 'logiInformation', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4422, '384', 'logi_status', '0快递信息可能更新  1快递信息不更新了', 'tinyint(3) unsigned', 'Integer', 'logiStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4423, '384', 'ship_area_id', '收货地区ID', 'int(10) unsigned', 'Integer', 'shipAreaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4424, '384', 'ship_address', '收货详细地址', 'varchar(200)', 'String', 'shipAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4425, '384', 'ship_name', '收货人姓名', 'varchar(50)', 'String', 'shipName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 10, 'admin', '2020-03-02 19:36:23', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4426, '384', 'ship_mobile', '收货电话', 'char(15)', 'String', 'shipMobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4427, '384', 'confirm_time', '确认s收货时间', 'bigint(12) unsigned', 'Long', 'confirmTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4428, '384', 'status', '状态 1=准备发货 2=已发货 3=已确认 4=其他', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4429, '384', 'memo', '备注', 'varchar(255)', 'String', 'memo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4430, '384', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4431, '384', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4432, '384', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4433, '385', 'id', NULL, 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4434, '385', 'delivery_id', '发货单号 关联bill_delivery.id', 'varchar(20)', 'String', 'deliveryId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4435, '385', 'order_items_id', '订单明细ID 关联order_items.id', 'int(10) unsigned', 'Integer', 'orderItemsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4436, '385', 'nums', '发货数量', 'smallint(5) unsigned', 'Integer', 'nums', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4437, '385', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:24', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4438, '386', 'id', '提货单号', 'varchar(20)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:25', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4439, '386', 'order_id', '订单号', 'varchar(20)', 'String', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:25', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4440, '386', 'store_id', '提货门店ID', 'int(10) unsigned', 'Integer', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:25', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4441, '386', 'name', '提货人姓名', 'varchar(30)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-03-02 19:36:25', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4442, '386', 'mobile', '提货手机号', 'varchar(15)', 'String', 'mobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:25', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4443, '386', 'clerk_id', '处理店员ID', 'int(10) unsigned', 'Integer', 'clerkId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:25', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4444, '386', 'ptime', '提货时间', 'bigint(12) unsigned', 'Long', 'ptime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4445, '386', 'status', '提货状态1=未提货 2=已提货', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4446, '386', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4447, '386', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4448, '386', 'isdel', '删除时间', 'bigint(12) unsigned', 'Long', 'isdel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4449, '387', 'payment_id', '支付单号', 'varchar(20)', 'String', 'paymentId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4450, '387', 'money', '支付金额', 'decimal(10,2)', 'Double', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4451, '387', 'user_id', '用户ID 关联user.id', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4452, '387', 'type', '资源类型1=订单,2充值单', 'smallint(1) unsigned', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:36:26', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4453, '387', 'status', '支付状态 1=未支付 2=支付成功 3=其他', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4454, '387', 'payment_code', '支付类型编码 关联payments.code', 'varchar(50)', 'String', 'paymentCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4455, '387', 'ip', '支付单生成IP', 'varchar(50)', 'String', 'ip', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4456, '387', 'params', '支付的时候需要的参数，存的是json格式的一维数组', 'varchar(200)', 'String', 'params', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4457, '387', 'payed_msg', '支付回调后的状态描述', 'varchar(255)', 'String', 'payedMsg', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4458, '387', 'trade_no', '第三方平台交易流水号', 'varchar(50)', 'String', 'tradeNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4459, '387', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:27', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4460, '387', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4461, '387', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4462, '388', 'payment_id', '支付单编号', 'varchar(20)', 'String', 'paymentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4463, '388', 'source_id', '资源编号', 'varchar(20)', 'String', 'sourceId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4464, '388', 'money', '金额', 'decimal(8,2) unsigned', 'Double', 'money', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4465, '389', 'refund_id', NULL, 'varchar(20)', 'String', 'refundId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4466, '389', 'aftersales_id', '售后单id', 'varchar(20)', 'String', 'aftersalesId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4467, '389', 'money', '退款金额', 'decimal(10,2) unsigned', 'Double', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4468, '389', 'user_id', '用户ID 关联user.id', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4469, '389', 'source_id', '资源id，根据type不同而关联不同的表', 'varchar(20)', 'String', 'sourceId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:28', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4470, '389', 'type', '资源类型1=订单,2充值单', 'smallint(1) unsigned', 'Integer', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 6, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4471, '389', 'payment_code', '退款支付类型编码 默认原路返回 关联支付单表支付编码', 'varchar(50)', 'String', 'paymentCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4472, '389', 'trade_no', '第三方平台交易流水号', 'varchar(50)', 'String', 'tradeNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4473, '389', 'status', '状态 1=未退款 2=已退款 3=退款失败，可以再次退款，4退款拒绝', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4474, '389', 'memo', '退款失败原因', 'varchar(100)', 'String', 'memo', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4475, '389', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4476, '389', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4477, '389', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:29', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4478, '390', 'reship_id', NULL, 'varchar(20)', 'String', 'reshipId', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4479, '390', 'order_id', '订单ID 关联order.id', 'varchar(20)', 'String', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4480, '390', 'aftersales_id', '售后单id', 'varchar(20)', 'String', 'aftersalesId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4481, '390', 'user_id', '用户ID 关联user.id', 'int(10) unsigned', 'Integer', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4482, '390', 'logi_code', '物流公司编码', 'varchar(50)', 'String', 'logiCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4483, '390', 'logi_no', '物流单号', 'varchar(50)', 'String', 'logiNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4484, '390', 'status', '状态 1=审核通过待发货 2=已发退货 3=已收退货', 'tinyint(1) unsigned', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4485, '390', 'memo', '备注', 'varchar(255)', 'String', 'memo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:30', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4486, '390', 'ctime', '创建时间', 'bigint(12) unsigned', 'Long', 'ctime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4487, '390', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4488, '390', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4489, '391', 'id', NULL, 'int(10) unsigned', 'Integer', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4490, '391', 'reship_id', '退款单单id', 'varchar(20)', 'String', 'reshipId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4491, '391', 'order_items_id', '订单明细ID 关联order_items.id', 'int(10) unsigned', 'Integer', 'orderItemsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4492, '391', 'goods_id', '商品ID 关联goods.id', 'int(10) unsigned', 'Integer', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4493, '391', 'product_id', '货品ID 关联products.id', 'int(10) unsigned', 'Integer', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4494, '391', 'sn', '货品编码', 'varchar(30)', 'String', 'sn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4495, '391', 'bn', '商品编码', 'varchar(30)', 'String', 'bn', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4496, '391', 'name', '商品名称', 'varchar(200)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4497, '391', 'image_url', '图片', 'varchar(100)', 'String', 'imageUrl', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4498, '391', 'nums', '数量', 'smallint(5) unsigned', 'Integer', 'nums', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4499, '391', 'addon', '货品明细序列号存储', 'text', 'String', 'addon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4500, '391', 'utime', '更新时间', 'bigint(12) unsigned', 'Long', 'utime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4501, '391', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4502, '392', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4503, '392', 'name', NULL, 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:31', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4504, '392', 'type', '轮播位置：0->PC首页轮播；1->app首页轮播', 'int(1)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:36:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4505, '392', 'pic', NULL, 'varchar(500)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-03-02 19:36:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4506, '392', 'start_time', NULL, 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:36:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4507, '392', 'end_time', NULL, 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:36:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4508, '392', 'status', '上下线状态：0->下线；1->上线', 'int(1)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:36:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4509, '392', 'url', '链接地址', 'varchar(100)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:32', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4510, '392', 'note', '备注', 'varchar(500)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 9, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4511, '392', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4512, '392', 'community_id', '所属店铺', 'int(11)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4513, '392', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4514, '393', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4515, '393', 'apply_id', '申请人', 'bigint(20)', 'Long', 'applyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4516, '393', 'room_id', '申请房间', 'bigint(20)', 'Long', 'roomId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4517, '393', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4518, '394', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:33', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4519, '394', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4520, '394', 'goods_name', '商品', 'varchar(255)', 'String', 'goodsName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4521, '394', 'origin_price', '商品价格', 'decimal(10,0)', 'Long', 'originPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4522, '394', 'group_price', '拼团价格', 'decimal(10,0)', 'Long', 'groupPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4523, '394', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4524, '394', 'end_time', '结束时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4525, '394', 'peoples', '成团人数', 'int(11)', 'Long', 'peoples', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:34', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4526, '394', 'status', '状态', 'int(11)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2020-03-02 19:36:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4527, '394', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-03-02 19:36:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4528, '394', 'max_people', '拼团总人数', 'int(11)', 'Long', 'maxPeople', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4529, '394', 'community_id', '所属店铺', 'bigint(11)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4530, '394', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4531, '395', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:35', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4532, '395', 'group_id', NULL, 'bigint(20)', 'Long', 'groupId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4533, '395', 'member_id', NULL, 'varchar(20)', 'String', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4534, '395', 'create_time', NULL, 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:36:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4535, '395', 'apply_id', '发起人', 'bigint(20)', 'Long', 'applyId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:36', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4536, '395', 'name', NULL, 'varchar(2550)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'textarea', '', 6, 'admin', '2020-03-02 19:36:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4537, '395', 'goods_id', NULL, 'bigint(20)', 'Long', 'goodsId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4538, '395', 'status', '状态', 'int(11)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 8, 'admin', '2020-03-02 19:36:37', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4539, '395', 'order_id', NULL, 'varchar(11)', 'String', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4540, '395', 'exipre_time', NULL, 'bigint(20)', 'Long', 'exipreTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4541, '396', 'id', NULL, 'bigint(11) unsigned', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4542, '396', 'title', '公告标题', 'varchar(200)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4543, '396', 'content', '公告内容', 'longtext', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4544, '396', 'type', '公告类型', 'tinyint(1) unsigned', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4545, '396', 'create_time', '创建时间 毫秒', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4546, '396', 'sort', '排序 从小到大', 'tinyint(3) unsigned', 'Integer', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4547, '396', 'isdel', '软删除位  有时间代表已删除', 'bigint(12) unsigned', 'Long', 'isdel', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4548, '396', 'community_id', '所属店铺', 'int(11)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4549, '396', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4550, '397', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:38', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4551, '397', 'room_id', '房屋编号', 'bigint(20)', 'Long', 'roomId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4552, '397', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4553, '397', 'solve_time', '解决时间', 'datetime', 'Date', 'solveTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4554, '397', 'resons', '报修原因', 'varchar(255)', 'String', 'resons', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4555, '397', 'phone', '报修者电话', 'varchar(22)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4556, '397', 'solve_resons', '解决记录', 'varchar(255)', 'String', 'solveResons', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4557, '397', 'room_desc', '房屋具体位置', 'varchar(255)', 'String', 'roomDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4558, '397', 'price', '价格', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4559, '397', 'status', '1 申请 2 处理中 3 已处理', 'int(4)', 'Integer', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 10, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4560, '397', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4561, '398', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4562, '398', 'name', '名称', 'varchar(20)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4563, '398', 'price', '单价', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4564, '398', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4565, '398', 'community_id', '社区编号', 'bigint(20)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4566, '398', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4567, '398', 'remark', '备注', 'varchar(255)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4568, '399', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4569, '399', 'name', '名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4570, '399', 'status', '1申请 2 审核失败 3 审核成功', 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:36:39', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4571, '399', 'pic', '照片', 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4572, '399', 'address', '位置', 'varchar(255)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4573, '399', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4574, '399', 'status_desc', '审核内容', 'varchar(255)', 'String', 'statusDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4575, '399', 'phone', NULL, 'varchar(20)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4576, '399', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4577, '400', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4578, '400', 'room_id', '房屋', 'bigint(20)', 'Long', 'roomId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4579, '400', 'price_name', '收费名称', 'varchar(255)', 'String', 'priceName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4580, '400', 'price', '单价', 'decimal(10,2)', 'Double', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4581, '400', 'amount', '用量', 'decimal(10,0)', 'Long', 'amount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4582, '400', 'moneys', '总额', 'decimal(10,0)', 'Long', 'moneys', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4583, '400', 'create_date', '创建时间', 'datetime', 'Date', 'createDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4584, '400', 'community_id', '社区编号', 'bigint(20)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4585, '400', 'room_desc', NULL, 'varchar(255)', 'String', 'roomDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4586, '400', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4587, '400', 'price_id', NULL, 'bigint(20)', 'Long', 'priceId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4588, '401', 'id', '业主成员ID', 'bigint(30)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4589, '401', 'owner_id', '业主ID', 'bigint(30)', 'Long', 'ownerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4590, '401', 'name', '业主名称', 'varchar(12)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4591, '401', 'sex', '性别', 'varchar(11)', 'String', 'sex', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4592, '401', 'age', '年龄', 'int(11)', 'Long', 'age', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4593, '401', 'phone', '联系人手机号', 'varchar(11)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4594, '401', 'remark', '备注', 'varchar(200)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4595, '401', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4596, '401', 'status', '数据状态，详细参考c_status表，0, 在用 1失效', 'varchar(2)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4597, '401', 'type', '1 业主本人 2 家庭成员', 'int(4)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 10, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4598, '401', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4599, '401', 'room_id', NULL, 'bigint(20)', 'Long', 'roomId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4600, '401', 'status_desc', NULL, 'varchar(255)', 'String', 'statusDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4601, '401', 'username', NULL, 'varchar(255)', 'String', 'username', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 14, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4602, '401', 'password', NULL, 'varchar(255)', 'String', 'password', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4603, '401', 'openid', NULL, 'varchar(40)', 'String', 'openid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4604, '401', 'room_desc', NULL, 'varchar(255)', 'String', 'roomDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4605, '402', 'id', '单元ID', 'bigint(30)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4606, '402', 'unit_num', '单元编号', 'varchar(12)', 'String', 'unitNum', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:40', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4607, '402', 'floor_id', '楼ID', 'varchar(30)', 'String', 'floorId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4608, '402', 'remark', '备注', 'varchar(200)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4609, '402', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4610, '402', 'store_id', NULL, 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4611, '403', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4612, '403', 'user_id', NULL, 'bigint(20)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4613, '403', 'community_id', NULL, 'bigint(20)', 'Long', 'communityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4614, '403', 'type', '1 用户 2 物业', 'int(4)', 'Integer', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4615, '404', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4616, '404', 'add_time', NULL, 'datetime', 'Date', 'addTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 2, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4617, '404', 'type', '1 商品 2 文章 3 店铺', 'int(11)', 'Long', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4618, '404', 'obj_id', NULL, 'bigint(20)', 'Long', 'objId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4619, '404', 'store_id', NULL, 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4620, '404', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4621, '404', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4622, '404', 'meno1', NULL, 'varchar(255)', 'String', 'meno1', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4623, '404', 'meno2', NULL, 'varchar(255)', 'String', 'meno2', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4624, '404', 'meno3', NULL, 'varchar(255)', 'String', 'meno3', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4625, '405', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4626, '405', 'category_id', '类别', 'bigint(20)', 'Long', 'categoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4627, '405', 'icon', '图片', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4628, '405', 'title', '标题', 'varchar(100)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4629, '405', 'show_status', '状态', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4630, '405', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4631, '405', 'read_count', '点击量', 'int(1)', 'Integer', 'readCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4632, '405', 'content', '内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4633, '405', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4634, '406', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4635, '406', 'name', '标题', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4636, '406', 'icon', '分类图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4637, '406', 'help_count', '专题数量', 'int(11)', 'Long', 'helpCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4638, '406', 'show_status', '状态', 'int(2)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4639, '406', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4640, '406', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4641, '407', 'id', NULL, 'bigint(20)', 'Long', 'id', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:41', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4642, '407', 'report_type', '举报类型：0->商品评价；1->话题内容；2->用户评论', 'int(1)', 'Integer', 'reportType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4643, '407', 'report_member_name', '举报人', 'varchar(100)', 'String', 'reportMemberName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4644, '407', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4645, '407', 'report_object', '举报对象', 'varchar(100)', 'String', 'reportObject', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4646, '407', 'report_status', '举报状态：0->未处理；1->已处理', 'int(1)', 'Integer', 'reportStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4647, '407', 'handle_status', '处理结果：0->无效；1->有效；2->恶意', 'int(1)', 'Integer', 'handleStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4648, '407', 'note', '内容', 'varchar(200)', 'String', 'note', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4649, '407', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4650, '408', 'id', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4651, '408', 'companyname', NULL, 'varchar(255)', 'String', 'companyname', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4652, '408', 'name', NULL, 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4653, '408', 'idcard', NULL, 'varchar(255)', 'String', 'idcard', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4654, '408', 'phone', NULL, 'varchar(255)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4655, '408', 'info', NULL, 'varchar(255)', 'String', 'info', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4656, '408', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4657, '409', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4658, '409', 'name', '标题', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4659, '409', 'sub_title', '子标题', 'varchar(255)', 'String', 'subTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4660, '409', 'pic', '展示图片', 'varbinary(500)', NULL, 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', NULL, '', 4, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4661, '409', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4662, '409', 'show_status', '状态', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4663, '409', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4664, '410', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4665, '410', 'prefrence_area_id', NULL, 'bigint(20)', 'Long', 'prefrenceAreaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4666, '410', 'product_id', NULL, 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4667, '410', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4668, '411', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4669, '411', 'category_id', '分类', 'bigint(20)', 'Long', 'categoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4670, '411', 'title', '标题', 'varchar(100)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4671, '411', 'pic', '专题主图', 'varchar(500)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4672, '411', 'product_count', '关联产品数量', 'int(11)', 'Long', 'productCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4673, '411', 'recommend_status', '推荐', 'int(1)', 'Integer', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 6, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4674, '411', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4675, '411', 'collect_count', '收藏量', 'int(11)', 'Long', 'collectCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4676, '411', 'read_count', '点击量', 'int(11)', 'Long', 'readCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4677, '411', 'comment_count', '评论量', 'int(11)', 'Long', 'commentCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4678, '411', 'album_pics', '画册图片用逗号分割', 'text', 'String', 'albumPics', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:42', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4679, '411', 'description', '描述', 'varchar(1000)', 'String', 'description', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 12, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4680, '411', 'show_status', '显示状态：0->不显示；1->显示', 'int(1)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 13, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4681, '411', 'content', '内容', 'longtext', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4682, '411', 'forward_count', '转发数', 'int(11)', 'Long', 'forwardCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4683, '411', 'category_name', '专题分类名称', 'varchar(200)', 'String', 'categoryName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 16, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4684, '411', 'area_id', NULL, 'bigint(20)', 'Long', 'areaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4685, '411', 'school_id', NULL, 'bigint(20)', 'Long', 'schoolId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4686, '411', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4687, '411', 'reward', '打赏', 'int(11)', 'Long', 'reward', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4688, '411', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4689, '411', 'area_name', NULL, 'varchar(255)', 'String', 'areaName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 22, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4690, '411', 'school_name', NULL, 'varchar(255)', 'String', 'schoolName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 23, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4691, '411', 'member_name', NULL, 'varchar(255)', 'String', 'memberName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 24, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4692, '411', 'video_src', NULL, 'varchar(255)', 'String', 'videoSrc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4693, '411', 'type', NULL, 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 26, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4694, '412', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4695, '412', 'category_id', '所属分类', 'bigint(20)', 'Long', 'categoryId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4696, '412', 'name', '标题', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4697, '412', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4698, '412', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4699, '412', 'end_time', '结束时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4700, '412', 'attend_count', '参与人数', 'int(11)', 'Long', 'attendCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4701, '412', 'attention_count', '关注人数', 'int(11)', 'Long', 'attentionCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4702, '412', 'read_count', '点击人数', 'int(11)', 'Long', 'readCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4703, '412', 'award_name', '奖品名称', 'varchar(100)', 'String', 'awardName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 10, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4704, '412', 'attend_type', '参与方式', 'varchar(100)', 'String', 'attendType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 11, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4705, '412', 'content', '话题内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4706, '412', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4707, '412', 'pic', NULL, 'varchar(255)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4708, '412', 'area_name', NULL, 'varchar(255)', 'String', 'areaName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 15, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4709, '412', 'school_name', NULL, 'varchar(255)', 'String', 'schoolName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 16, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4710, '412', 'member_name', NULL, 'varchar(255)', 'String', 'memberName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 17, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4711, '412', 'area_id', NULL, 'bigint(20)', 'Long', 'areaId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4712, '412', 'school_id', NULL, 'bigint(20)', 'Long', 'schoolId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4713, '412', 'member_id', NULL, 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 20, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4714, '412', 'address', NULL, 'varchar(255)', 'String', 'address', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4715, '412', 'atids', NULL, 'varchar(255)', 'String', 'atids', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4716, '413', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4717, '413', 'name', '标题', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:43', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4718, '413', 'icon', '分类图标', 'varchar(500)', 'String', 'icon', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4719, '413', 'subject_count', '专题数量', 'int(11)', 'Long', 'subjectCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4720, '413', 'show_status', '状态', 'int(2)', 'Integer', 'showStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4721, '413', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4722, '413', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4731, '415', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4732, '415', 'member_id', '会员编号', 'bigint(20)', 'Long', 'memberId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4733, '415', 'username', '会员', 'varchar(255)', 'String', 'username', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4734, '415', 'status', '状态', 'varchar(255)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4735, '415', 'topic_id', '活动编号', 'bigint(20)', 'Long', 'topicId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4736, '415', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4737, '415', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4738, '416', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4739, '416', 'address_name', '地址名称', 'varchar(200)', 'String', 'addressName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4740, '416', 'send_status', '默认发货地址：0->否；1->是', 'int(1)', 'Integer', 'sendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 3, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4741, '416', 'receive_status', '是否默认收货地址：0->否；1->是', 'int(1)', 'Integer', 'receiveStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 4, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4742, '416', 'name', '收发货人姓名', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4743, '416', 'phone', '收货人电话', 'varchar(64)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4744, '416', 'province', '省/直辖市', 'varchar(64)', 'String', 'province', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4745, '416', 'city', '市', 'varchar(64)', 'String', 'city', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4746, '416', 'region', '区', 'varchar(64)', 'String', 'region', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4747, '416', 'detail_address', '详细地址', 'varchar(200)', 'String', 'detailAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4748, '416', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4749, '417', 'ID', NULL, 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4750, '417', 'ORDER_ID', NULL, 'int(10) unsigned', 'Integer', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4751, '417', 'EXPRESS_CORP_ID', '物流公司编码', 'varchar(32)', 'String', 'expressCorpId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4752, '417', 'EXPRESS_NO', '运单号', 'varchar(32)', 'String', 'expressNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4753, '417', 'EXPRESS_STATUS', '运单状态0.初始化 1.已发货 2 已签收', 'tinyint(4)', 'Integer', 'expressStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4754, '417', 'EXPRESS_DETAIL', '物流详情', 'mediumtext', 'String', 'expressDetail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4755, '417', 'UPDATE_TIME', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-03-02 19:36:44', '', NULL);
INSERT INTO `admin_gen_table_column` VALUES (4756, '417', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-03-02 19:36:44', '', NULL);

-- ----------------------------
-- Table structure for admin_sys_config
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_config`;
CREATE TABLE `admin_sys_config`  (
  `config_id` int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '参数配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_sys_config
-- ----------------------------
INSERT INTO `admin_sys_config` VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'N', 'admin', '2018-03-16 11:33:00', 'admin', '2019-09-19 10:29:11', '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `admin_sys_config` VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '初始化密码 123456');
INSERT INTO `admin_sys_config` VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2018-03-16 11:33:00', 'admin', '2020-01-16 09:22:31', '深色主题theme-dark，浅色主题theme-light');

-- ----------------------------
-- Table structure for admin_sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_dept`;
CREATE TABLE `admin_sys_dept`  (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(20) DEFAULT 0 COMMENT '父部门id',
  `ancestors` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '部门名称',
  `order_num` int(4) DEFAULT 0 COMMENT '显示顺序',
  `leader` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '邮箱',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 203 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '部门表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_sys_dept
-- ----------------------------
INSERT INTO `admin_sys_dept` VALUES (100, 0, '0', '若依科技', 0, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2018-03-16 11:33:00', 'admin', '2020-02-19 10:17:46');
INSERT INTO `admin_sys_dept` VALUES (101, 100, '0,100', '深圳总公司', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2018-03-16 11:33:00', 'admin', '2020-02-19 10:17:18');
INSERT INTO `admin_sys_dept` VALUES (102, 100, '0,100', '长沙分公司', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00');
INSERT INTO `admin_sys_dept` VALUES (103, 101, '0,100,101', '研发部门', 1, '若依', '15888888888', 'ry@qq.com', '1', '0', 'admin', '2018-03-16 11:33:00', 'admin', '2020-02-07 19:19:51');
INSERT INTO `admin_sys_dept` VALUES (104, 101, '0,100,101', '市场部门', 2, '若依', '15888888888', 'ry@qq.com', '1', '2', 'admin', '2018-03-16 11:33:00', 'admin', '2020-03-04 09:31:47');
INSERT INTO `admin_sys_dept` VALUES (105, 101, '0,100,101', '测试部门', 3, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00');
INSERT INTO `admin_sys_dept` VALUES (106, 101, '0,100,101', '财务部门', 4, '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00');
INSERT INTO `admin_sys_dept` VALUES (107, 101, '0,100,101', '运维部门', 5, '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00');
INSERT INTO `admin_sys_dept` VALUES (108, 102, '0,100,102', '市场部门', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00');
INSERT INTO `admin_sys_dept` VALUES (109, 102, '0,100,102', '财务部门', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00');
INSERT INTO `admin_sys_dept` VALUES (200, 100, '0,100', '山东分公司', 3, '张三', '18888888888', '18888888888@qq.com', '0', '0', 'admin', '2019-09-30 09:23:55', 'admin', '2020-02-19 10:17:46');
INSERT INTO `admin_sys_dept` VALUES (201, 200, '0,100,200', '技术部', 1, '李四', '18888888888', '18888888888@qq.com', '0', '0', 'admin', '2019-09-30 09:25:22', 'admin', '2020-02-19 10:17:46');
INSERT INTO `admin_sys_dept` VALUES (202, 105, '0,100,101,105', '测试部门', 0, '1', '13628672210', '11@qq.com', '0', '2', 'admin', '2020-02-07 19:21:18', '', NULL);

-- ----------------------------
-- Table structure for admin_sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_dict_data`;
CREATE TABLE `admin_sys_dict_data`  (
  `dict_code` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(4) DEFAULT 0 COMMENT '字典排序',
  `dict_label` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 56 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '字典数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_sys_dict_data
-- ----------------------------
INSERT INTO `admin_sys_dict_data` VALUES (1, 1, '男', '0', 'admin_sys_user_sex', '', '', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '性别男');
INSERT INTO `admin_sys_dict_data` VALUES (2, 2, '女', '1', 'admin_sys_user_sex', '', '', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '性别女');
INSERT INTO `admin_sys_dict_data` VALUES (3, 3, '未知', '2', 'admin_sys_user_sex', '', '', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '性别未知');
INSERT INTO `admin_sys_dict_data` VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '显示菜单');
INSERT INTO `admin_sys_dict_data` VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '隐藏菜单');
INSERT INTO `admin_sys_dict_data` VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '正常状态');
INSERT INTO `admin_sys_dict_data` VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '停用状态');
INSERT INTO `admin_sys_dict_data` VALUES (8, 1, '正常', '0', 'admin_sys_job_status', '', 'primary', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '正常状态');
INSERT INTO `admin_sys_dict_data` VALUES (9, 2, '暂停', '1', 'admin_sys_job_status', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '停用状态');
INSERT INTO `admin_sys_dict_data` VALUES (10, 1, '默认', 'DEFAULT', 'admin_sys_job_group', '', '', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '默认分组');
INSERT INTO `admin_sys_dict_data` VALUES (11, 2, '系统', 'SYSTEM', 'admin_sys_job_group', '', '', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '系统分组');
INSERT INTO `admin_sys_dict_data` VALUES (12, 1, '是', '1', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'admin', '2020-03-05 13:33:46', '系统默认是');
INSERT INTO `admin_sys_dict_data` VALUES (13, 2, '否', '0', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'admin', '2020-03-05 13:33:52', '系统默认否');
INSERT INTO `admin_sys_dict_data` VALUES (14, 1, '通知', '1', 'admin_sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '通知');
INSERT INTO `admin_sys_dict_data` VALUES (15, 2, '公告', '2', 'admin_sys_notice_type', '', 'success', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '公告');
INSERT INTO `admin_sys_dict_data` VALUES (16, 1, '正常', '0', 'admin_sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '正常状态');
INSERT INTO `admin_sys_dict_data` VALUES (17, 2, '关闭', '1', 'admin_sys_notice_status', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '关闭状态');
INSERT INTO `admin_sys_dict_data` VALUES (18, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '新增操作');
INSERT INTO `admin_sys_dict_data` VALUES (19, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '修改操作');
INSERT INTO `admin_sys_dict_data` VALUES (20, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '删除操作');
INSERT INTO `admin_sys_dict_data` VALUES (21, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '授权操作');
INSERT INTO `admin_sys_dict_data` VALUES (22, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '导出操作');
INSERT INTO `admin_sys_dict_data` VALUES (23, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '导入操作');
INSERT INTO `admin_sys_dict_data` VALUES (24, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '强退操作');
INSERT INTO `admin_sys_dict_data` VALUES (25, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '生成操作');
INSERT INTO `admin_sys_dict_data` VALUES (26, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '清空操作');
INSERT INTO `admin_sys_dict_data` VALUES (27, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '正常状态');
INSERT INTO `admin_sys_dict_data` VALUES (28, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '停用状态');
INSERT INTO `admin_sys_dict_data` VALUES (29, 0, 'PC轮播广告', '0', 'advertise_location', NULL, NULL, 'Y', '0', 'admin', '2020-01-13 21:10:43', '', NULL, 'PC轮播广告');
INSERT INTO `admin_sys_dict_data` VALUES (30, 1, 'APP轮播广告', '1', 'advertise_location', NULL, NULL, 'Y', '0', 'admin', '2020-01-13 21:11:03', '', NULL, 'APP轮播广告');
INSERT INTO `admin_sys_dict_data` VALUES (31, 2, '小程序轮播广告', '2', 'advertise_location', NULL, NULL, 'Y', '0', 'admin', '2020-01-13 21:11:19', '', NULL, '小程序轮播广告');
INSERT INTO `admin_sys_dict_data` VALUES (32, 0, '上线', '1', 'advertise_on_off', '', '', 'Y', '0', 'admin', '2020-01-13 21:30:28', 'admin', '2020-01-13 21:31:03', '上线');
INSERT INTO `admin_sys_dict_data` VALUES (33, 1, '下线', '0', 'advertise_on_off', NULL, NULL, 'Y', '0', 'admin', '2020-01-13 21:30:49', '', NULL, '下线');
INSERT INTO `admin_sys_dict_data` VALUES (34, 1, '通过', '1', 'store_approve_status', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:18:36', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (35, 2, '审核中', '2', 'store_approve_status', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:18:49', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (36, 3, '拒绝', '3', 'store_approve_status', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:18:59', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (37, 1, '批发型商户', '1', 'store_register_type', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:30:25', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (38, 2, '零售型商户', '2', 'store_register_type', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:30:43', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (39, 1, '国有企业', '1', 'store_type', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:31:22', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (40, 2, '股份制企业', '2', 'store_type', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:31:35', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (41, 3, '有限责任企业', '3', 'store_type', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:31:47', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (42, 4, '个人独资企业', '4', 'store_type', NULL, 'default', 'Y', '0', 'admin', '2020-02-14 17:32:02', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (43, 1, '会员标签', '1', 'tag_type', NULL, 'default', 'Y', '0', 'admin', '2020-03-04 09:23:30', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (44, 2, '商品标签', '2', 'tag_type', NULL, 'success', 'Y', '0', 'admin', '2020-03-04 09:23:45', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (45, 3, '内容标签', '3', 'tag_type', NULL, 'info', 'Y', '0', 'admin', '2020-03-04 09:24:08', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (46, 1, '自动标签', '1', 'tag_gen_type', NULL, 'default', 'Y', '0', 'admin', '2020-03-04 09:24:59', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (47, 2, '手动标签', '2', 'tag_gen_type', NULL, 'info', 'Y', '0', 'admin', '2020-03-04 09:25:13', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (48, 1, '积分添加', '1', 'jifen_change_type', NULL, 'primary', 'Y', '0', 'admin', '2020-03-04 09:35:20', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (49, 2, '积分减少', '2', 'jifen_change_type', NULL, 'info', 'Y', '0', 'admin', '2020-03-04 09:35:32', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (50, 1, '登录', '1', 'jifen_source', NULL, 'primary', 'Y', '0', 'admin', '2020-03-04 09:35:52', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (51, 2, '签到', '2', 'jifen_source', NULL, 'success', 'Y', '0', 'admin', '2020-03-04 09:36:06', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (52, 1, '按件', '1', 'feight_type', NULL, 'default', 'Y', '0', 'ry', '2020-03-04 20:32:03', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (53, 2, '按重量', '2', 'feight_type', NULL, 'primary', 'Y', '0', 'ry', '2020-03-04 20:32:41', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (54, 1, '赠品', '1', 'gift_type', NULL, 'default', '1', '0', 'admin', '2020-03-15 09:57:33', '', NULL, NULL);
INSERT INTO `admin_sys_dict_data` VALUES (55, 2, '积分商品', '2', 'gift_type', NULL, 'primary', '1', '0', 'admin', '2020-03-15 09:57:48', '', NULL, NULL);

-- ----------------------------
-- Table structure for admin_sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_dict_type`;
CREATE TABLE `admin_sys_dict_type`  (
  `dict_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '字典类型',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`) USING BTREE,
  UNIQUE INDEX `dict_type`(`dict_type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 24 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_sys_dict_type
-- ----------------------------
INSERT INTO `admin_sys_dict_type` VALUES (1, '用户性别', 'admin_sys_user_sex', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '用户性别列表');
INSERT INTO `admin_sys_dict_type` VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '菜单状态列表');
INSERT INTO `admin_sys_dict_type` VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '系统开关列表');
INSERT INTO `admin_sys_dict_type` VALUES (4, '任务状态', 'admin_sys_job_status', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '任务状态列表');
INSERT INTO `admin_sys_dict_type` VALUES (5, '任务分组', 'admin_sys_job_group', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '任务分组列表');
INSERT INTO `admin_sys_dict_type` VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '系统是否列表');
INSERT INTO `admin_sys_dict_type` VALUES (7, '通知类型', 'admin_sys_notice_type', '0', 'admin', '2018-03-16 11:33:00', 'admin', '2020-01-16 09:22:12', '通知类型列表');
INSERT INTO `admin_sys_dict_type` VALUES (8, '通知状态', 'admin_sys_notice_status', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '通知状态列表');
INSERT INTO `admin_sys_dict_type` VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '操作类型列表');
INSERT INTO `admin_sys_dict_type` VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2018-03-16 11:33:00', 'ry', '2018-03-16 11:33:00', '登录状态列表');
INSERT INTO `admin_sys_dict_type` VALUES (11, '轮播位置', 'advertise_location', '0', 'admin', '2020-01-13 21:09:22', '', NULL, '轮播位置');
INSERT INTO `admin_sys_dict_type` VALUES (12, '上/下线', 'advertise_on_off', '0', 'admin', '2020-01-13 21:29:50', '', NULL, '广告上下线');
INSERT INTO `admin_sys_dict_type` VALUES (13, '商户审核状态', 'store_approve_status', '0', 'admin', '2020-02-14 17:18:13', '', NULL, '商户审核状态');
INSERT INTO `admin_sys_dict_type` VALUES (14, '商户注册类型', 'store_register_type', '0', 'admin', '2020-02-14 17:30:05', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (15, '商户类型', 'store_type', '0', 'admin', '2020-02-14 17:31:05', '', NULL, '商户类型');
INSERT INTO `admin_sys_dict_type` VALUES (16, '标签类别', 'tag_type', '0', 'admin', '2020-03-04 09:22:58', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (17, '标签生成类别', 'tag_gen_type', '0', 'admin', '2020-03-04 09:24:31', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (18, '积分变化类别', 'jifen_change_type', '0', 'admin', '2020-03-04 09:34:34', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (19, '积分来源', 'jifen_source', '0', 'admin', '2020-03-04 09:34:52', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (20, '余额类别', 'blance_type', '0', 'admin', '2020-03-04 09:40:38', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (21, '订单状态', 'order_status', '0', 'admin', '2020-03-04 10:11:31', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (22, '运费模板类别', 'feight_type', '0', 'ry', '2020-03-04 20:31:42', '', NULL, NULL);
INSERT INTO `admin_sys_dict_type` VALUES (23, '活动商品类型', 'gift_type', '0', 'admin', '2020-03-15 09:56:18', '', NULL, NULL);

-- ----------------------------
-- Table structure for admin_sys_job
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_job`;
CREATE TABLE `admin_sys_job`  (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '定时任务调度表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_sys_job
-- ----------------------------
INSERT INTO `admin_sys_job` VALUES (3, '3456781', 'DEFAULT', 'sdfghjkl', '0 0/30 1-2 * * ?', '1', '0', '0', '', NULL, '', '2020-03-19 17:32:27', '');
INSERT INTO `admin_sys_job` VALUES (4, '商户数据日统计', 'DEFAULT', 'ryTask.storeDayStatics', '0 0 1 * * ?', '1', '1', '0', '', '2020-03-14 20:52:31', '', '2020-03-14 20:56:13', '商户数据日统计');
INSERT INTO `admin_sys_job` VALUES (5, '商户统计 凌晨2点', 'DEFAULT', 'ryTask.storeStatics', '0 0 2 * * ?', '1', '1', '0', '', '2020-03-14 20:53:13', '', '2020-03-14 20:56:11', '商户统计 凌晨2点 0 0 2 * * ?');

-- ----------------------------
-- Table structure for admin_sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_job_log`;
CREATE TABLE `admin_sys_job_log`  (
  `job_log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '日志信息',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '异常信息',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 711 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '定时任务调度日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for admin_sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `admin_sys_logininfor`;
CREATE TABLE `admin_sys_logininfor`  (
  `info_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `login_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '登录账号',
  `ipaddr` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '操作系统',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '' COMMENT '提示消息',
  `login_time` datetime(0) DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`info_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2939 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '系统访问记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of admin_sys_logininfor
-- ----------------------------
INSERT INTO `admin_sys_logininfor` VALUES (100, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-17 12:32:50');
INSERT INTO `admin_sys_logininfor` VALUES (101, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 12:33:43');
INSERT INTO `admin_sys_logininfor` VALUES (102, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 12:35:37');
INSERT INTO `admin_sys_logininfor` VALUES (103, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 15:17:12');
INSERT INTO `admin_sys_logininfor` VALUES (104, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 15:23:17');
INSERT INTO `admin_sys_logininfor` VALUES (105, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 15:43:14');
INSERT INTO `admin_sys_logininfor` VALUES (106, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 16:31:29');
INSERT INTO `admin_sys_logininfor` VALUES (107, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 16:34:27');
INSERT INTO `admin_sys_logininfor` VALUES (108, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 16:36:35');
INSERT INTO `admin_sys_logininfor` VALUES (109, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 16:41:23');
INSERT INTO `admin_sys_logininfor` VALUES (110, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:06:21');
INSERT INTO `admin_sys_logininfor` VALUES (111, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:08:22');
INSERT INTO `admin_sys_logininfor` VALUES (112, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:22:31');
INSERT INTO `admin_sys_logininfor` VALUES (113, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-17 17:27:41');
INSERT INTO `admin_sys_logininfor` VALUES (114, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:27:45');
INSERT INTO `admin_sys_logininfor` VALUES (115, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:28:50');
INSERT INTO `admin_sys_logininfor` VALUES (116, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:30:52');
INSERT INTO `admin_sys_logininfor` VALUES (117, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:51:04');
INSERT INTO `admin_sys_logininfor` VALUES (118, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '退出成功', '2019-09-17 17:59:02');
INSERT INTO `admin_sys_logininfor` VALUES (119, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 17:59:05');
INSERT INTO `admin_sys_logininfor` VALUES (120, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '退出成功', '2019-09-17 17:59:09');
INSERT INTO `admin_sys_logininfor` VALUES (121, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:13:48');
INSERT INTO `admin_sys_logininfor` VALUES (122, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:16:28');
INSERT INTO `admin_sys_logininfor` VALUES (123, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:18:52');
INSERT INTO `admin_sys_logininfor` VALUES (124, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '退出成功', '2019-09-17 18:19:01');
INSERT INTO `admin_sys_logininfor` VALUES (125, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:27:31');
INSERT INTO `admin_sys_logininfor` VALUES (126, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-17 18:33:28');
INSERT INTO `admin_sys_logininfor` VALUES (127, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:33:32');
INSERT INTO `admin_sys_logininfor` VALUES (128, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-17 18:39:13');
INSERT INTO `admin_sys_logininfor` VALUES (129, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:39:15');
INSERT INTO `admin_sys_logininfor` VALUES (130, 'admin', '124.126.144.69', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 18:51:45');
INSERT INTO `admin_sys_logininfor` VALUES (131, 'admin', '163.125.182.194', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 18:52:45');
INSERT INTO `admin_sys_logininfor` VALUES (132, 'admin', '124.64.18.159', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-17 18:52:46');
INSERT INTO `admin_sys_logininfor` VALUES (133, 'admin', '14.17.22.37', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-17 18:52:51');
INSERT INTO `admin_sys_logininfor` VALUES (134, 'admin', '223.93.42.147', '浙江 金华', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 18:53:13');
INSERT INTO `admin_sys_logininfor` VALUES (135, 'admin', '113.109.112.110', '广东 广州', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-17 18:54:23');
INSERT INTO `admin_sys_logininfor` VALUES (136, 'admin', '223.11.187.212', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-17 18:54:45');
INSERT INTO `admin_sys_logininfor` VALUES (137, 'admin', '223.104.29.142', '宁夏 银川', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 18:59:06');
INSERT INTO `admin_sys_logininfor` VALUES (138, 'admin', '36.110.86.162', '北京 北京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 19:09:41');
INSERT INTO `admin_sys_logininfor` VALUES (139, 'admin', '117.136.116.103', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 19:11:05');
INSERT INTO `admin_sys_logininfor` VALUES (140, 'admin', '112.97.57.36', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-17 19:14:09');
INSERT INTO `admin_sys_logininfor` VALUES (141, 'admin', '183.14.30.163', '广东 深圳', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-17 19:18:39');
INSERT INTO `admin_sys_logininfor` VALUES (142, 'admin', '183.14.30.163', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-17 19:18:42');
INSERT INTO `admin_sys_logininfor` VALUES (143, 'admin', '119.39.21.50', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-17 19:36:46');
INSERT INTO `admin_sys_logininfor` VALUES (144, 'admin', '124.64.17.250', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-17 19:36:49');
INSERT INTO `admin_sys_logininfor` VALUES (145, 'admin', '119.39.21.50', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-17 19:36:52');
INSERT INTO `admin_sys_logininfor` VALUES (146, 'admin', '180.91.109.165', '四川 成都', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2019-09-17 19:40:14');
INSERT INTO `admin_sys_logininfor` VALUES (147, 'admin', '223.104.63.182', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 19:41:34');
INSERT INTO `admin_sys_logininfor` VALUES (148, 'admin', '124.126.144.69', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 19:44:35');
INSERT INTO `admin_sys_logininfor` VALUES (149, 'admin', '61.158.152.231', '河南 郑州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-17 19:56:12');
INSERT INTO `admin_sys_logininfor` VALUES (150, 'admin', '223.11.187.212', '山西 太原', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-17 19:57:23');
INSERT INTO `admin_sys_logininfor` VALUES (151, 'admin', '223.11.187.212', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-17 19:57:27');
INSERT INTO `admin_sys_logininfor` VALUES (152, 'admin', '120.36.255.230', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-17 20:00:51');
INSERT INTO `admin_sys_logininfor` VALUES (153, 'admin', '223.11.187.212', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-17 20:01:06');
INSERT INTO `admin_sys_logininfor` VALUES (154, 'admin', '123.165.55.125', '黑龙江 哈尔滨', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-17 20:06:59');
INSERT INTO `admin_sys_logininfor` VALUES (155, 'admin', '123.165.55.125', '黑龙江 哈尔滨', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 20:07:29');
INSERT INTO `admin_sys_logininfor` VALUES (156, 'admin', '27.17.193.155', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-17 20:45:57');
INSERT INTO `admin_sys_logininfor` VALUES (157, 'admin', '117.136.119.46', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-17 21:16:45');
INSERT INTO `admin_sys_logininfor` VALUES (158, 'admin', '103.27.26.134', 'XX XX', 'Safari', 'Mac OS X', '1', '验证码错误', '2019-09-17 22:00:43');
INSERT INTO `admin_sys_logininfor` VALUES (159, 'admin', '103.27.26.134', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-17 22:01:09');
INSERT INTO `admin_sys_logininfor` VALUES (160, 'admin', '103.27.26.134', 'XX XX', 'Safari', 'Mac OS X', '0', '退出成功', '2019-09-17 22:06:25');
INSERT INTO `admin_sys_logininfor` VALUES (161, 'admin', '113.77.26.52', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-17 22:19:33');
INSERT INTO `admin_sys_logininfor` VALUES (162, 'admin', '113.77.26.52', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-17 22:21:13');
INSERT INTO `admin_sys_logininfor` VALUES (163, 'admin', '113.246.204.37', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-17 22:29:46');
INSERT INTO `admin_sys_logininfor` VALUES (164, 'admin', '183.45.76.21', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-17 22:34:28');
INSERT INTO `admin_sys_logininfor` VALUES (165, 'admin', '183.45.76.21', '广东 珠海', 'Chrome', 'Windows 7', '0', '退出成功', '2019-09-17 22:35:26');
INSERT INTO `admin_sys_logininfor` VALUES (166, 'admin', '183.45.76.21', '广东 珠海', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-17 22:35:29');
INSERT INTO `admin_sys_logininfor` VALUES (167, 'admin', '121.35.188.28', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-17 23:06:54');
INSERT INTO `admin_sys_logininfor` VALUES (168, 'admin', '120.244.143.79', '北京 北京', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-18 00:00:17');
INSERT INTO `admin_sys_logininfor` VALUES (169, 'admin', '120.244.143.79', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 00:00:18');
INSERT INTO `admin_sys_logininfor` VALUES (170, 'admin', '119.123.157.91', '广东 深圳', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 00:04:35');
INSERT INTO `admin_sys_logininfor` VALUES (171, 'admin', '113.72.9.152', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 00:27:03');
INSERT INTO `admin_sys_logininfor` VALUES (172, 'admin', '118.247.120.57', '北京 北京', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-18 06:19:38');
INSERT INTO `admin_sys_logininfor` VALUES (173, 'admin', '114.84.117.84', '上海 上海', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-18 06:52:04');
INSERT INTO `admin_sys_logininfor` VALUES (174, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 07:58:51');
INSERT INTO `admin_sys_logininfor` VALUES (175, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 07:59:04');
INSERT INTO `admin_sys_logininfor` VALUES (176, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 07:59:11');
INSERT INTO `admin_sys_logininfor` VALUES (177, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 07:59:21');
INSERT INTO `admin_sys_logininfor` VALUES (178, 'admin', '101.247.232.93', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-18 08:06:26');
INSERT INTO `admin_sys_logininfor` VALUES (179, 'admin', '101.247.216.159', '广东 东莞', 'Chrome 39', 'Windows 7', '1', '验证码错误', '2019-09-18 08:13:48');
INSERT INTO `admin_sys_logininfor` VALUES (180, 'admin', '101.247.216.159', '广东 东莞', 'Chrome 39', 'Windows 7', '0', '登录成功', '2019-09-18 08:13:56');
INSERT INTO `admin_sys_logininfor` VALUES (181, 'admin', '119.84.120.187', '重庆 重庆', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-18 08:58:11');
INSERT INTO `admin_sys_logininfor` VALUES (182, 'admin', '113.87.160.53', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-18 09:26:36');
INSERT INTO `admin_sys_logininfor` VALUES (183, 'admin', '113.111.8.155', '广东 广州', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 09:42:22');
INSERT INTO `admin_sys_logininfor` VALUES (184, 'admin', '113.111.8.155', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 09:42:26');
INSERT INTO `admin_sys_logininfor` VALUES (185, 'admin', '221.3.150.173', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 09:43:44');
INSERT INTO `admin_sys_logininfor` VALUES (186, 'admin', '221.3.150.173', '云南 昆明', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 09:43:45');
INSERT INTO `admin_sys_logininfor` VALUES (187, 'admin', '58.56.19.142', '山东 济南', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2019-09-18 10:08:43');
INSERT INTO `admin_sys_logininfor` VALUES (188, 'admin', '117.136.62.56', '四川 成都', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2019-09-18 11:00:18');
INSERT INTO `admin_sys_logininfor` VALUES (189, 'admin', '59.108.36.225', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 11:09:20');
INSERT INTO `admin_sys_logininfor` VALUES (190, 'admin', '124.126.144.114', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 11:55:04');
INSERT INTO `admin_sys_logininfor` VALUES (191, 'admin', '116.30.220.65', '广东 深圳', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 14:14:36');
INSERT INTO `admin_sys_logininfor` VALUES (192, 'admin', '60.216.104.169', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:19:08');
INSERT INTO `admin_sys_logininfor` VALUES (193, 'admin', '123.8.9.186', '河南 安阳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:19:46');
INSERT INTO `admin_sys_logininfor` VALUES (194, 'admin', '123.8.9.186', '河南 安阳', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-18 14:20:39');
INSERT INTO `admin_sys_logininfor` VALUES (195, 'admin', '113.88.156.244', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-18 14:21:38');
INSERT INTO `admin_sys_logininfor` VALUES (196, 'admin', '171.212.112.76', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:22:22');
INSERT INTO `admin_sys_logininfor` VALUES (197, 'admin', '1.119.165.90', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:22:39');
INSERT INTO `admin_sys_logininfor` VALUES (198, 'admin', '117.136.104.4', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-18 14:23:05');
INSERT INTO `admin_sys_logininfor` VALUES (199, 'admin', '124.193.70.146', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:23:26');
INSERT INTO `admin_sys_logininfor` VALUES (200, 'admin', '101.204.76.228', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:24:25');
INSERT INTO `admin_sys_logininfor` VALUES (201, 'admin', '61.172.240.228', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:25:04');
INSERT INTO `admin_sys_logininfor` VALUES (202, 'admin', '121.60.32.103', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-18 14:27:38');
INSERT INTO `admin_sys_logininfor` VALUES (203, 'admin', '121.60.32.103', '湖北 武汉', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-18 14:27:56');
INSERT INTO `admin_sys_logininfor` VALUES (204, 'admin', '121.60.32.103', '湖北 武汉', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-18 14:28:06');
INSERT INTO `admin_sys_logininfor` VALUES (205, 'admin', '125.82.18.97', 'XX XX', 'Internet Explorer 11', 'Windows 7', '0', '登录成功', '2019-09-18 14:30:09');
INSERT INTO `admin_sys_logininfor` VALUES (206, 'admin', '139.214.251.213', '吉林 长春', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-18 14:31:15');
INSERT INTO `admin_sys_logininfor` VALUES (207, 'admin', '61.149.183.118', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:41:48');
INSERT INTO `admin_sys_logininfor` VALUES (208, 'admin', '124.126.144.114', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 14:46:51');
INSERT INTO `admin_sys_logininfor` VALUES (209, 'admin', '113.90.245.243', '广东 深圳', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-18 14:49:26');
INSERT INTO `admin_sys_logininfor` VALUES (210, 'admin', '113.90.245.243', '广东 深圳', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-18 14:49:30');
INSERT INTO `admin_sys_logininfor` VALUES (211, 'admin', '223.104.96.127', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:49:47');
INSERT INTO `admin_sys_logininfor` VALUES (212, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 14:56:58');
INSERT INTO `admin_sys_logininfor` VALUES (213, 'admin', '61.183.69.182', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 14:59:15');
INSERT INTO `admin_sys_logininfor` VALUES (214, 'admin', '112.91.150.34', 'XX XX', 'Safari', 'Mac OS X', '1', '验证码错误', '2019-09-18 15:00:46');
INSERT INTO `admin_sys_logininfor` VALUES (215, 'admin', '112.91.150.34', '广东 珠海', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-18 15:00:55');
INSERT INTO `admin_sys_logininfor` VALUES (216, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 15:02:20');
INSERT INTO `admin_sys_logininfor` VALUES (217, 'admin', '112.91.150.34', 'XX XX', 'Safari', 'Mac OS X', '0', '退出成功', '2019-09-18 15:02:32');
INSERT INTO `admin_sys_logininfor` VALUES (218, 'admin', '116.233.78.122', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 15:12:43');
INSERT INTO `admin_sys_logininfor` VALUES (219, 'admin', '113.88.85.96', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 15:13:21');
INSERT INTO `admin_sys_logininfor` VALUES (220, 'admin', '113.88.85.96', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:13:33');
INSERT INTO `admin_sys_logininfor` VALUES (221, 'admin', '122.227.62.194', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:15:12');
INSERT INTO `admin_sys_logininfor` VALUES (222, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 15:18:05');
INSERT INTO `admin_sys_logininfor` VALUES (223, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 15:20:42');
INSERT INTO `admin_sys_logininfor` VALUES (224, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 15:26:36');
INSERT INTO `admin_sys_logininfor` VALUES (225, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-18 15:33:10');
INSERT INTO `admin_sys_logininfor` VALUES (226, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 15:33:14');
INSERT INTO `admin_sys_logininfor` VALUES (227, 'admin', '110.185.170.134', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-18 15:36:09');
INSERT INTO `admin_sys_logininfor` VALUES (228, 'admin', '221.4.61.189', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:36:49');
INSERT INTO `admin_sys_logininfor` VALUES (229, 'admin', '59.175.72.211', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:37:29');
INSERT INTO `admin_sys_logininfor` VALUES (230, 'admin', '117.25.47.83', '福建 福州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:38:08');
INSERT INTO `admin_sys_logininfor` VALUES (231, 'admin', '115.201.0.82', '浙江 台州', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-18 15:39:09');
INSERT INTO `admin_sys_logininfor` VALUES (232, 'admin', '124.205.245.114', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 15:41:51');
INSERT INTO `admin_sys_logininfor` VALUES (233, 'admin', '124.205.245.114', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:41:57');
INSERT INTO `admin_sys_logininfor` VALUES (234, 'admin', '119.145.137.36', '广东 佛山', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:43:12');
INSERT INTO `admin_sys_logininfor` VALUES (235, 'admin', '106.17.31.218', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-18 15:51:15');
INSERT INTO `admin_sys_logininfor` VALUES (236, 'admin', '115.192.185.95', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 15:54:24');
INSERT INTO `admin_sys_logininfor` VALUES (237, 'admin', '180.91.109.165', '四川 成都', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2019-09-18 15:54:25');
INSERT INTO `admin_sys_logininfor` VALUES (238, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 16:03:21');
INSERT INTO `admin_sys_logininfor` VALUES (239, 'admin', '59.175.72.211', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-18 16:21:56');
INSERT INTO `admin_sys_logininfor` VALUES (240, 'admin', '1.80.145.15', '陕西 西安', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-18 16:40:01');
INSERT INTO `admin_sys_logininfor` VALUES (241, 'admin', '61.185.224.115', '陕西 西安', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-18 16:41:52');
INSERT INTO `admin_sys_logininfor` VALUES (242, 'admin', '182.50.115.228', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-18 16:53:15');
INSERT INTO `admin_sys_logininfor` VALUES (243, 'admin', '182.50.115.228', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 16:53:27');
INSERT INTO `admin_sys_logininfor` VALUES (244, 'admin', '58.248.166.62', '广东 广州', 'Safari 7', 'Mac OS X', '1', '验证码错误', '2019-09-18 16:55:26');
INSERT INTO `admin_sys_logininfor` VALUES (245, 'admin', '58.248.166.62', 'XX XX', 'Safari 7', 'Mac OS X', '0', '登录成功', '2019-09-18 16:55:39');
INSERT INTO `admin_sys_logininfor` VALUES (246, 'admin', '218.2.115.179', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 17:25:17');
INSERT INTO `admin_sys_logininfor` VALUES (247, 'admin', '124.239.216.58', 'XX XX', 'Internet Explorer 11', 'Windows 10', '1', '验证码错误', '2019-09-18 17:44:24');
INSERT INTO `admin_sys_logininfor` VALUES (248, 'admin', '124.239.216.58', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2019-09-18 17:44:31');
INSERT INTO `admin_sys_logininfor` VALUES (249, 'admin', '124.239.216.58', '河北 石家庄', 'Internet Explorer 11', 'Windows 10', '0', '退出成功', '2019-09-18 17:47:56');
INSERT INTO `admin_sys_logininfor` VALUES (250, 'admin', '182.97.127.123', '江西 南昌', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-18 18:25:18');
INSERT INTO `admin_sys_logininfor` VALUES (251, 'admin', '122.70.151.23', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2019-09-18 19:09:06');
INSERT INTO `admin_sys_logininfor` VALUES (252, 'admin', '122.70.151.23', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '退出成功', '2019-09-18 19:09:26');
INSERT INTO `admin_sys_logininfor` VALUES (253, 'admin', '111.20.174.86', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-18 19:25:06');
INSERT INTO `admin_sys_logininfor` VALUES (254, 'admin', '118.247.120.57', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 20:12:34');
INSERT INTO `admin_sys_logininfor` VALUES (255, 'admin', '218.76.65.99', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-18 20:20:02');
INSERT INTO `admin_sys_logininfor` VALUES (256, 'admin', '218.76.65.99', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 20:20:09');
INSERT INTO `admin_sys_logininfor` VALUES (257, 'admin', '116.77.75.255', 'XX XX', 'Chrome', 'Linux', '1', '验证码错误', '2019-09-18 21:48:50');
INSERT INTO `admin_sys_logininfor` VALUES (258, 'admin', '116.77.75.255', '广东 深圳', 'Chrome', 'Linux', '0', '登录成功', '2019-09-18 21:48:54');
INSERT INTO `admin_sys_logininfor` VALUES (259, 'admin', '103.25.28.29', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 21:52:59');
INSERT INTO `admin_sys_logininfor` VALUES (260, 'admin', '118.247.120.57', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 22:00:59');
INSERT INTO `admin_sys_logininfor` VALUES (261, 'admin', '223.81.144.254', '山东 青岛', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 22:25:06');
INSERT INTO `admin_sys_logininfor` VALUES (262, 'admin', '59.61.28.164', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-18 22:33:02');
INSERT INTO `admin_sys_logininfor` VALUES (263, 'admin', '120.244.62.233', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-18 23:49:26');
INSERT INTO `admin_sys_logininfor` VALUES (264, 'admin', '223.96.228.58', '山东 菏泽', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-19 07:43:14');
INSERT INTO `admin_sys_logininfor` VALUES (265, 'admin', '60.190.187.182', '浙江 绍兴', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 08:08:12');
INSERT INTO `admin_sys_logininfor` VALUES (266, 'admin', '61.140.26.213', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 08:56:59');
INSERT INTO `admin_sys_logininfor` VALUES (267, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 09:34:12');
INSERT INTO `admin_sys_logininfor` VALUES (268, 'admin', '221.12.168.178', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 09:38:34');
INSERT INTO `admin_sys_logininfor` VALUES (269, 'admin', '183.15.91.67', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 09:39:50');
INSERT INTO `admin_sys_logininfor` VALUES (270, 'admin', '183.15.91.67', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 09:39:55');
INSERT INTO `admin_sys_logininfor` VALUES (271, 'admin', '58.60.188.61', '广东 深圳', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 09:41:33');
INSERT INTO `admin_sys_logininfor` VALUES (272, 'admin', '124.126.144.114', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 09:49:25');
INSERT INTO `admin_sys_logininfor` VALUES (273, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 09:53:12');
INSERT INTO `admin_sys_logininfor` VALUES (274, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 09:53:14');
INSERT INTO `admin_sys_logininfor` VALUES (275, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 09:56:04');
INSERT INTO `admin_sys_logininfor` VALUES (276, 'admin', '183.192.62.31', '上海 上海', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-19 09:58:34');
INSERT INTO `admin_sys_logininfor` VALUES (277, 'admin', '115.236.53.58', '浙江 杭州', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-19 10:04:12');
INSERT INTO `admin_sys_logininfor` VALUES (278, 'admin', '115.236.53.58', '浙江 杭州', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 10:04:16');
INSERT INTO `admin_sys_logininfor` VALUES (279, 'admin', '1.94.197.119', '北京 北京', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 10:07:34');
INSERT INTO `admin_sys_logininfor` VALUES (280, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 10:11:28');
INSERT INTO `admin_sys_logininfor` VALUES (281, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-19 10:15:15');
INSERT INTO `admin_sys_logininfor` VALUES (282, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-19 10:26:25');
INSERT INTO `admin_sys_logininfor` VALUES (283, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 10:26:39');
INSERT INTO `admin_sys_logininfor` VALUES (284, 'admin', '61.185.224.115', '陕西 西安', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 10:28:03');
INSERT INTO `admin_sys_logininfor` VALUES (285, 'admin', '114.102.177.140', '安徽 合肥', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 10:30:19');
INSERT INTO `admin_sys_logininfor` VALUES (286, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 10:31:26');
INSERT INTO `admin_sys_logininfor` VALUES (287, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-19 10:34:50');
INSERT INTO `admin_sys_logininfor` VALUES (288, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 10:49:41');
INSERT INTO `admin_sys_logininfor` VALUES (289, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-19 10:52:59');
INSERT INTO `admin_sys_logininfor` VALUES (290, 'admin', '113.92.74.152', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 10:53:38');
INSERT INTO `admin_sys_logininfor` VALUES (291, 'admin', '113.92.74.152', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 10:53:46');
INSERT INTO `admin_sys_logininfor` VALUES (292, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 10:58:26');
INSERT INTO `admin_sys_logininfor` VALUES (293, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 10:59:00');
INSERT INTO `admin_sys_logininfor` VALUES (294, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-19 10:59:51');
INSERT INTO `admin_sys_logininfor` VALUES (295, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 11:00:03');
INSERT INTO `admin_sys_logininfor` VALUES (296, 'admin', '111.85.174.74', '贵州 贵阳', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 11:20:00');
INSERT INTO `admin_sys_logininfor` VALUES (297, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 11:20:19');
INSERT INTO `admin_sys_logininfor` VALUES (298, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 11:20:23');
INSERT INTO `admin_sys_logininfor` VALUES (299, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 11:26:18');
INSERT INTO `admin_sys_logininfor` VALUES (300, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 11:26:29');
INSERT INTO `admin_sys_logininfor` VALUES (301, 'admin', '218.65.120.157', '江西 南昌', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 11:50:46');
INSERT INTO `admin_sys_logininfor` VALUES (302, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 11:50:50');
INSERT INTO `admin_sys_logininfor` VALUES (303, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:16:12');
INSERT INTO `admin_sys_logininfor` VALUES (304, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:16:36');
INSERT INTO `admin_sys_logininfor` VALUES (305, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:16:54');
INSERT INTO `admin_sys_logininfor` VALUES (306, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 12:19:00');
INSERT INTO `admin_sys_logininfor` VALUES (307, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:20:44');
INSERT INTO `admin_sys_logininfor` VALUES (308, 'admin', '27.18.244.111', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 12:21:02');
INSERT INTO `admin_sys_logininfor` VALUES (309, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:25:27');
INSERT INTO `admin_sys_logininfor` VALUES (310, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:30:20');
INSERT INTO `admin_sys_logininfor` VALUES (311, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:33:16');
INSERT INTO `admin_sys_logininfor` VALUES (312, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:40:28');
INSERT INTO `admin_sys_logininfor` VALUES (313, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 12:52:20');
INSERT INTO `admin_sys_logininfor` VALUES (314, 'admin', '218.242.36.198', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 13:32:38');
INSERT INTO `admin_sys_logininfor` VALUES (315, 'admin', '202.104.28.51', '广东 佛山', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 13:45:36');
INSERT INTO `admin_sys_logininfor` VALUES (316, 'admin', '125.77.82.196', '福建 福州', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-19 13:48:19');
INSERT INTO `admin_sys_logininfor` VALUES (317, 'admin', '125.77.82.196', '福建 福州', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 13:48:21');
INSERT INTO `admin_sys_logininfor` VALUES (318, 'admin', '36.22.185.242', '浙江 嘉兴', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 13:57:37');
INSERT INTO `admin_sys_logininfor` VALUES (319, 'admin', '36.22.185.242', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 13:57:43');
INSERT INTO `admin_sys_logininfor` VALUES (320, 'admin', '180.156.159.63', '上海 上海', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 14:03:44');
INSERT INTO `admin_sys_logininfor` VALUES (321, 'admin', '180.156.159.63', '上海 上海', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 14:03:46');
INSERT INTO `admin_sys_logininfor` VALUES (322, 'admin', '180.156.159.63', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 14:03:50');
INSERT INTO `admin_sys_logininfor` VALUES (323, 'admin', '124.126.144.114', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 14:11:06');
INSERT INTO `admin_sys_logininfor` VALUES (324, 'admin', '116.2.180.121', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 14:16:33');
INSERT INTO `admin_sys_logininfor` VALUES (325, 'admin', '114.102.177.140', '安徽 合肥', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 14:29:05');
INSERT INTO `admin_sys_logininfor` VALUES (326, 'admin', '222.91.186.210', '陕西 西安', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 14:35:05');
INSERT INTO `admin_sys_logininfor` VALUES (327, 'admin', '222.91.186.210', '陕西 西安', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 14:35:12');
INSERT INTO `admin_sys_logininfor` VALUES (328, 'admin', '183.129.166.254', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 15:04:22');
INSERT INTO `admin_sys_logininfor` VALUES (329, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 15:13:09');
INSERT INTO `admin_sys_logininfor` VALUES (330, 'admin', '121.13.236.18', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 15:18:03');
INSERT INTO `admin_sys_logininfor` VALUES (331, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 15:19:26');
INSERT INTO `admin_sys_logininfor` VALUES (332, 'admin', '202.170.218.66', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 15:25:43');
INSERT INTO `admin_sys_logininfor` VALUES (333, 'admin', '113.104.249.81', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 15:31:44');
INSERT INTO `admin_sys_logininfor` VALUES (334, 'admin', '113.104.249.81', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 15:32:09');
INSERT INTO `admin_sys_logininfor` VALUES (335, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 15:40:47');
INSERT INTO `admin_sys_logininfor` VALUES (336, 'admin', '163.125.137.224', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 15:52:41');
INSERT INTO `admin_sys_logininfor` VALUES (337, 'admin', '163.125.137.224', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 15:52:46');
INSERT INTO `admin_sys_logininfor` VALUES (338, 'admin', '219.159.155.32', '广西 南宁', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 15:53:08');
INSERT INTO `admin_sys_logininfor` VALUES (339, 'admin', '61.185.224.115', '陕西 西安', 'Chrome', 'Windows 7', '0', '退出成功', '2019-09-19 15:53:46');
INSERT INTO `admin_sys_logininfor` VALUES (340, 'admin', '114.102.178.0', '安徽 合肥', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 16:00:08');
INSERT INTO `admin_sys_logininfor` VALUES (341, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 16:16:24');
INSERT INTO `admin_sys_logininfor` VALUES (342, 'admin', '123.138.75.146', '陕西 西安', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 16:22:56');
INSERT INTO `admin_sys_logininfor` VALUES (343, 'admin', '111.19.47.137', '陕西 西安', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 16:32:08');
INSERT INTO `admin_sys_logininfor` VALUES (344, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 16:32:40');
INSERT INTO `admin_sys_logininfor` VALUES (345, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 16:35:10');
INSERT INTO `admin_sys_logininfor` VALUES (346, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 16:39:48');
INSERT INTO `admin_sys_logininfor` VALUES (347, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 16:46:42');
INSERT INTO `admin_sys_logininfor` VALUES (348, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 16:47:40');
INSERT INTO `admin_sys_logininfor` VALUES (349, 'admin', '223.72.95.121', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 16:56:35');
INSERT INTO `admin_sys_logininfor` VALUES (350, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 17:02:21');
INSERT INTO `admin_sys_logininfor` VALUES (351, 'admin', '218.65.120.157', '江西 南昌', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 17:20:42');
INSERT INTO `admin_sys_logininfor` VALUES (352, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-19 17:20:56');
INSERT INTO `admin_sys_logininfor` VALUES (353, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 17:21:22');
INSERT INTO `admin_sys_logininfor` VALUES (354, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 17:21:25');
INSERT INTO `admin_sys_logininfor` VALUES (355, 'admin', '58.19.1.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 17:30:50');
INSERT INTO `admin_sys_logininfor` VALUES (356, 'admin', '58.19.1.42', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 17:30:54');
INSERT INTO `admin_sys_logininfor` VALUES (357, 'admin', '113.128.118.92', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 17:31:13');
INSERT INTO `admin_sys_logininfor` VALUES (358, 'admin', '113.89.98.33', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 17:52:29');
INSERT INTO `admin_sys_logininfor` VALUES (359, 'admin', '117.175.169.234', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 18:01:11');
INSERT INTO `admin_sys_logininfor` VALUES (360, 'admin', '121.239.108.53', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 18:02:43');
INSERT INTO `admin_sys_logininfor` VALUES (361, 'admin', '121.239.108.53', '江苏 苏州', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-19 18:02:53');
INSERT INTO `admin_sys_logininfor` VALUES (362, 'admin', '218.87.96.131', '江西 新余', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2019-09-19 18:05:02');
INSERT INTO `admin_sys_logininfor` VALUES (363, 'admin', '218.87.96.131', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-19 18:05:12');
INSERT INTO `admin_sys_logininfor` VALUES (364, 'admin', '124.161.162.23', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-19 18:30:26');
INSERT INTO `admin_sys_logininfor` VALUES (365, 'admin', '113.104.180.34', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-19 18:54:35');
INSERT INTO `admin_sys_logininfor` VALUES (366, 'admin', '221.234.218.46', '湖北 武汉', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-19 19:38:20');
INSERT INTO `admin_sys_logininfor` VALUES (367, 'admin', '120.244.146.191', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 20:24:33');
INSERT INTO `admin_sys_logininfor` VALUES (368, 'admin', '27.17.193.155', '湖北 武汉', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 20:47:45');
INSERT INTO `admin_sys_logininfor` VALUES (369, 'admin', '218.81.214.90', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-19 21:44:10');
INSERT INTO `admin_sys_logininfor` VALUES (370, 'admin', '222.90.141.46', '陕西 西安', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-19 21:50:14');
INSERT INTO `admin_sys_logininfor` VALUES (371, 'admin', '219.142.145.99', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-19 22:05:07');
INSERT INTO `admin_sys_logininfor` VALUES (372, 'admin', '219.142.145.99', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-19 22:07:13');
INSERT INTO `admin_sys_logininfor` VALUES (373, 'admin', '103.27.26.134', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-20 07:12:02');
INSERT INTO `admin_sys_logininfor` VALUES (374, 'admin', '49.69.202.60', '江苏 盐城', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 08:31:15');
INSERT INTO `admin_sys_logininfor` VALUES (375, 'admin', '113.240.219.190', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-20 08:37:34');
INSERT INTO `admin_sys_logininfor` VALUES (376, 'admin', '113.240.219.190', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 08:37:51');
INSERT INTO `admin_sys_logininfor` VALUES (377, 'admin', '114.87.129.103', '上海 上海', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-20 09:07:08');
INSERT INTO `admin_sys_logininfor` VALUES (378, 'admin', '115.192.185.95', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 09:19:51');
INSERT INTO `admin_sys_logininfor` VALUES (379, 'admin', '222.91.149.119', '陕西 西安', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-20 09:24:43');
INSERT INTO `admin_sys_logininfor` VALUES (380, 'admin', '119.182.77.121', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 09:25:14');
INSERT INTO `admin_sys_logininfor` VALUES (381, 'admin', '210.12.43.34', '北京 北京', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-20 09:29:37');
INSERT INTO `admin_sys_logininfor` VALUES (382, 'admin', '210.12.43.34', '北京 北京', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-20 09:29:42');
INSERT INTO `admin_sys_logininfor` VALUES (383, 'admin', '202.101.209.91', '江西 南昌', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 09:57:49');
INSERT INTO `admin_sys_logininfor` VALUES (384, 'admin', '180.169.247.74', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 11:42:41');
INSERT INTO `admin_sys_logininfor` VALUES (385, 'admin', '180.169.247.74', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-20 11:42:50');
INSERT INTO `admin_sys_logininfor` VALUES (386, 'admin', '124.126.144.114', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-20 12:02:36');
INSERT INTO `admin_sys_logininfor` VALUES (387, 'admin', '110.185.219.81', '四川 成都', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-20 13:39:13');
INSERT INTO `admin_sys_logininfor` VALUES (388, 'admin', '14.147.105.40', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 14:09:48');
INSERT INTO `admin_sys_logininfor` VALUES (389, 'admin', '110.185.219.81', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-20 14:15:19');
INSERT INTO `admin_sys_logininfor` VALUES (390, 'admin', '119.182.77.121', '山东 济宁', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-20 15:31:48');
INSERT INTO `admin_sys_logininfor` VALUES (391, 'admin', '119.182.77.121', '山东 济宁', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 15:31:52');
INSERT INTO `admin_sys_logininfor` VALUES (392, 'admin', '124.65.190.54', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 15:55:22');
INSERT INTO `admin_sys_logininfor` VALUES (393, 'admin', '120.224.45.82', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-20 18:31:55');
INSERT INTO `admin_sys_logininfor` VALUES (394, 'admin', '218.77.104.13', '湖南 长沙', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-20 21:45:55');
INSERT INTO `admin_sys_logininfor` VALUES (395, 'admin', '106.36.219.44', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-20 22:31:32');
INSERT INTO `admin_sys_logininfor` VALUES (396, 'admin', '163.125.122.103', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 09:46:30');
INSERT INTO `admin_sys_logininfor` VALUES (397, 'admin', '163.125.122.103', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 10:27:18');
INSERT INTO `admin_sys_logininfor` VALUES (398, 'admin', '125.119.232.45', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-21 10:33:53');
INSERT INTO `admin_sys_logininfor` VALUES (399, 'admin', '125.119.232.45', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 10:34:11');
INSERT INTO `admin_sys_logininfor` VALUES (400, 'admin', '14.157.89.99', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-21 11:49:48');
INSERT INTO `admin_sys_logininfor` VALUES (401, 'admin', '14.157.89.99', '广东 佛山', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 11:50:22');
INSERT INTO `admin_sys_logininfor` VALUES (402, 'admin', '124.200.141.66', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-21 12:16:07');
INSERT INTO `admin_sys_logininfor` VALUES (403, 'admin', '124.200.141.66', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-21 12:16:07');
INSERT INTO `admin_sys_logininfor` VALUES (404, 'admin', '124.200.141.66', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 12:16:33');
INSERT INTO `admin_sys_logininfor` VALUES (405, 'admin', '124.200.141.66', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-21 12:17:26');
INSERT INTO `admin_sys_logininfor` VALUES (406, 'admin', '124.200.141.66', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 12:23:25');
INSERT INTO `admin_sys_logininfor` VALUES (407, 'admin', '106.47.153.50', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2019-09-21 12:42:57');
INSERT INTO `admin_sys_logininfor` VALUES (408, 'admin', '106.47.153.50', 'XX XX', 'Internet Explorer 11', 'Windows 10', '1', '验证码错误', '2019-09-21 12:42:59');
INSERT INTO `admin_sys_logininfor` VALUES (409, 'admin', '49.65.70.166', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 13:41:59');
INSERT INTO `admin_sys_logininfor` VALUES (410, 'admin', '14.131.254.109', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-21 13:57:52');
INSERT INTO `admin_sys_logininfor` VALUES (411, 'admin', '117.136.61.47', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-21 14:34:05');
INSERT INTO `admin_sys_logininfor` VALUES (412, 'admin', '112.10.96.212', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-21 14:38:30');
INSERT INTO `admin_sys_logininfor` VALUES (413, 'admin', '112.10.96.212', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '退出成功', '2019-09-21 14:39:46');
INSERT INTO `admin_sys_logininfor` VALUES (414, 'admin', '112.10.96.212', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-21 14:40:17');
INSERT INTO `admin_sys_logininfor` VALUES (415, 'admin', '59.46.190.130', '辽宁 大连', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-21 19:01:02');
INSERT INTO `admin_sys_logininfor` VALUES (416, 'admin', '112.96.194.252', '广东 佛山', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2019-09-22 09:35:58');
INSERT INTO `admin_sys_logininfor` VALUES (417, 'admin', '112.96.194.252', '广东 佛山', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-22 09:36:01');
INSERT INTO `admin_sys_logininfor` VALUES (418, 'admin', '58.42.241.116', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-22 11:21:43');
INSERT INTO `admin_sys_logininfor` VALUES (419, 'admin', '211.162.27.81', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-22 13:20:16');
INSERT INTO `admin_sys_logininfor` VALUES (420, 'admin', '220.180.239.123', '安徽 合肥', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-22 14:00:00');
INSERT INTO `admin_sys_logininfor` VALUES (421, 'admin', '218.81.214.90', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-22 16:57:30');
INSERT INTO `admin_sys_logininfor` VALUES (422, 'admin', '58.42.241.116', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-22 18:47:55');
INSERT INTO `admin_sys_logininfor` VALUES (423, 'admin', '58.42.241.116', '贵州 贵阳', 'Chrome', 'Mac OS X', '0', '退出成功', '2019-09-22 18:50:29');
INSERT INTO `admin_sys_logininfor` VALUES (424, 'admin', '171.11.3.158', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-22 18:54:02');
INSERT INTO `admin_sys_logininfor` VALUES (425, 'admin', '171.11.3.158', '河南 郑州', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-22 18:54:14');
INSERT INTO `admin_sys_logininfor` VALUES (426, 'admin', '117.20.117.9', '金边 XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-22 21:29:41');
INSERT INTO `admin_sys_logininfor` VALUES (427, 'admin', '113.102.250.188', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-22 22:07:24');
INSERT INTO `admin_sys_logininfor` VALUES (428, 'admin', '113.102.250.188', '广东 东莞', 'Chrome', 'Windows 7', '0', '退出成功', '2019-09-22 22:11:49');
INSERT INTO `admin_sys_logininfor` VALUES (429, 'admin', '114.243.132.93', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 00:50:47');
INSERT INTO `admin_sys_logininfor` VALUES (430, 'admin', '59.174.211.142', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 08:49:07');
INSERT INTO `admin_sys_logininfor` VALUES (431, 'admin', '222.87.180.173', '贵州 黔西南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 09:04:32');
INSERT INTO `admin_sys_logininfor` VALUES (432, 'admin', '182.245.207.191', '云南 昆明', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2019-09-23 09:10:43');
INSERT INTO `admin_sys_logininfor` VALUES (433, 'admin', '222.87.180.173', '贵州 黔西南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 09:11:07');
INSERT INTO `admin_sys_logininfor` VALUES (434, 'admin', '222.209.33.33', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 09:25:16');
INSERT INTO `admin_sys_logininfor` VALUES (435, 'admin', '219.145.72.161', '陕西 西安', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 10:13:36');
INSERT INTO `admin_sys_logininfor` VALUES (436, 'admin', '110.87.111.150', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 11:41:13');
INSERT INTO `admin_sys_logininfor` VALUES (437, 'admin', '222.87.165.75', '贵州 黔西南', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-23 14:43:39');
INSERT INTO `admin_sys_logininfor` VALUES (438, 'admin', '222.87.165.75', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 14:43:49');
INSERT INTO `admin_sys_logininfor` VALUES (439, 'admin', '120.37.46.33', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 15:11:18');
INSERT INTO `admin_sys_logininfor` VALUES (440, 'admin', '101.230.10.249', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-23 15:34:37');
INSERT INTO `admin_sys_logininfor` VALUES (441, 'admin', '101.230.10.249', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-23 15:34:41');
INSERT INTO `admin_sys_logininfor` VALUES (442, 'admin', '101.230.10.249', '上海 上海', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-23 15:34:46');
INSERT INTO `admin_sys_logininfor` VALUES (443, 'admin', '112.45.96.231', 'XX XX', 'Firefox', 'Windows 10', '1', '密码输入错误1次', '2019-09-23 15:41:23');
INSERT INTO `admin_sys_logininfor` VALUES (444, 'admin', '112.45.96.231', '四川 成都', 'Firefox', 'Windows 10', '1', '验证码错误', '2019-09-23 15:41:38');
INSERT INTO `admin_sys_logininfor` VALUES (445, 'admin', '175.30.31.142', '吉林 长春', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-23 16:10:52');
INSERT INTO `admin_sys_logininfor` VALUES (446, 'admin', '175.30.31.142', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-23 16:11:00');
INSERT INTO `admin_sys_logininfor` VALUES (447, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 16:29:43');
INSERT INTO `admin_sys_logininfor` VALUES (448, 'admin', '119.4.169.183', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 19:04:19');
INSERT INTO `admin_sys_logininfor` VALUES (449, 'admin', '112.10.69.241', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 20:43:57');
INSERT INTO `admin_sys_logininfor` VALUES (450, 'admin', '180.169.247.74', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 21:04:53');
INSERT INTO `admin_sys_logininfor` VALUES (451, 'admin', '223.88.36.175', '河南 郑州', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-23 21:50:46');
INSERT INTO `admin_sys_logininfor` VALUES (452, 'admin', '58.34.74.139', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-23 21:55:14');
INSERT INTO `admin_sys_logininfor` VALUES (453, 'admin', '183.192.62.31', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-23 22:09:23');
INSERT INTO `admin_sys_logininfor` VALUES (454, 'admin', '183.192.62.31', '上海 上海', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2019-09-23 22:09:27');
INSERT INTO `admin_sys_logininfor` VALUES (455, 'admin', '112.1.52.203', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-23 23:19:37');
INSERT INTO `admin_sys_logininfor` VALUES (456, 'admin', '101.88.200.57', '上海 上海', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-23 23:32:31');
INSERT INTO `admin_sys_logininfor` VALUES (457, 'admin', '183.5.90.101', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 00:10:28');
INSERT INTO `admin_sys_logininfor` VALUES (458, 'admin', '117.89.77.220', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 08:53:14');
INSERT INTO `admin_sys_logininfor` VALUES (459, 'admin', '118.247.120.57', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 08:58:47');
INSERT INTO `admin_sys_logininfor` VALUES (460, 'admin', '117.136.70.35', '四川 成都', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-24 11:33:21');
INSERT INTO `admin_sys_logininfor` VALUES (461, 'admin', '113.102.167.164', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 11:56:33');
INSERT INTO `admin_sys_logininfor` VALUES (462, 'admin', '222.90.31.96', '陕西 西安', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 11:56:54');
INSERT INTO `admin_sys_logininfor` VALUES (463, 'admin', '183.134.205.58', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 13:03:24');
INSERT INTO `admin_sys_logininfor` VALUES (464, 'admin', '219.157.250.54', 'XX XX', 'Chrome', 'Windows 8', '1', '验证码错误', '2019-09-24 15:16:34');
INSERT INTO `admin_sys_logininfor` VALUES (465, 'admin', '219.157.250.54', '河南 郑州', 'Chrome', 'Windows 8', '0', '登录成功', '2019-09-24 15:16:34');
INSERT INTO `admin_sys_logininfor` VALUES (466, 'admin', '171.221.151.230', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 16:10:11');
INSERT INTO `admin_sys_logininfor` VALUES (467, 'admin', '180.167.176.138', 'XX XX', 'Microsoft Edge', 'Windows 10', '1', '验证码错误', '2019-09-24 16:47:13');
INSERT INTO `admin_sys_logininfor` VALUES (468, 'admin', '180.167.176.138', 'XX XX', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2019-09-24 16:47:19');
INSERT INTO `admin_sys_logininfor` VALUES (469, 'admin', '125.45.157.37', '河南 信阳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 16:53:42');
INSERT INTO `admin_sys_logininfor` VALUES (470, 'admin', '113.109.40.38', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-24 20:18:00');
INSERT INTO `admin_sys_logininfor` VALUES (471, 'admin', '113.109.40.38', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 20:18:06');
INSERT INTO `admin_sys_logininfor` VALUES (472, 'admin', '111.165.123.6', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-24 20:28:14');
INSERT INTO `admin_sys_logininfor` VALUES (473, 'admin', '113.129.231.236', '山东 青岛', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2019-09-24 20:29:28');
INSERT INTO `admin_sys_logininfor` VALUES (474, 'admin', '117.136.95.172', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-24 20:58:06');
INSERT INTO `admin_sys_logininfor` VALUES (475, 'admin', '223.73.84.72', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 21:33:06');
INSERT INTO `admin_sys_logininfor` VALUES (476, 'admin', '223.73.84.72', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-24 21:33:08');
INSERT INTO `admin_sys_logininfor` VALUES (477, 'admin', '223.73.84.72', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-24 21:33:29');
INSERT INTO `admin_sys_logininfor` VALUES (478, 'admin', '113.103.211.9', '广东 湛江', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-24 21:48:01');
INSERT INTO `admin_sys_logininfor` VALUES (479, 'admin', '112.224.19.39', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-24 22:00:21');
INSERT INTO `admin_sys_logininfor` VALUES (480, 'admin', '121.32.35.253', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-25 17:13:03');
INSERT INTO `admin_sys_logininfor` VALUES (481, 'admin', '116.24.8.16', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-25 17:28:28');
INSERT INTO `admin_sys_logininfor` VALUES (482, 'admin', '59.41.23.50', '广东 广州', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2019-09-25 17:31:33');
INSERT INTO `admin_sys_logininfor` VALUES (483, 'admin', '61.185.224.115', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-25 17:43:07');
INSERT INTO `admin_sys_logininfor` VALUES (484, 'admin', '61.185.224.115', '陕西 西安', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-25 17:43:13');
INSERT INTO `admin_sys_logininfor` VALUES (485, 'admin', '115.205.25.155', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-25 18:52:44');
INSERT INTO `admin_sys_logininfor` VALUES (486, 'admin', '115.205.25.155', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-25 18:52:51');
INSERT INTO `admin_sys_logininfor` VALUES (487, 'admin', '49.80.218.145', '江苏 无锡', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-25 20:26:57');
INSERT INTO `admin_sys_logininfor` VALUES (488, 'admin', '113.104.189.135', 'XX XX', 'Firefox', 'Windows 10', '1', '验证码错误', '2019-09-25 21:03:24');
INSERT INTO `admin_sys_logininfor` VALUES (489, 'admin', '113.104.189.135', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-25 21:04:05');
INSERT INTO `admin_sys_logininfor` VALUES (490, 'admin', '175.188.245.59', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-25 21:29:29');
INSERT INTO `admin_sys_logininfor` VALUES (491, 'admin', '175.188.245.59', '江苏 南京', 'Safari', 'Mac OS X', '1', '验证码错误', '2019-09-25 21:29:36');
INSERT INTO `admin_sys_logininfor` VALUES (492, 'admin', '111.201.39.247', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-25 22:35:24');
INSERT INTO `admin_sys_logininfor` VALUES (493, 'admin', '60.220.48.148', '山西 长治', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 08:50:49');
INSERT INTO `admin_sys_logininfor` VALUES (494, 'admin', '171.8.6.187', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 09:19:19');
INSERT INTO `admin_sys_logininfor` VALUES (495, 'admin', '1.80.144.6', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-26 09:56:09');
INSERT INTO `admin_sys_logininfor` VALUES (496, 'admin', '99.247.124.111', '安大略 XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-26 10:02:48');
INSERT INTO `admin_sys_logininfor` VALUES (497, 'admin', '99.247.124.111', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 10:03:22');
INSERT INTO `admin_sys_logininfor` VALUES (498, 'admin', '123.180.74.51', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-26 10:13:24');
INSERT INTO `admin_sys_logininfor` VALUES (499, 'admin', '120.229.30.140', '广东 深圳', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-26 10:22:27');
INSERT INTO `admin_sys_logininfor` VALUES (500, 'admin', '120.229.30.140', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-26 10:22:38');
INSERT INTO `admin_sys_logininfor` VALUES (501, 'admin', '163.179.127.70', '广东 珠海', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-26 11:38:57');
INSERT INTO `admin_sys_logininfor` VALUES (502, 'admin', '163.179.127.70', '广东 珠海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 11:39:21');
INSERT INTO `admin_sys_logininfor` VALUES (503, 'admin', '119.162.231.111', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 11:41:36');
INSERT INTO `admin_sys_logininfor` VALUES (504, 'admin', '101.80.228.236', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 12:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (505, 'admin', '218.17.192.250', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-26 12:38:06');
INSERT INTO `admin_sys_logininfor` VALUES (506, 'admin', '218.17.192.250', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-26 12:38:13');
INSERT INTO `admin_sys_logininfor` VALUES (507, 'admin', '116.22.132.18', 'XX XX', 'Firefox', 'Windows 7', '0', '登录成功', '2019-09-27 09:40:17');
INSERT INTO `admin_sys_logininfor` VALUES (508, 'admin', '14.204.113.79', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 09:41:20');
INSERT INTO `admin_sys_logininfor` VALUES (509, 'admin', '1.80.1.252', '陕西 西安', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-27 09:42:53');
INSERT INTO `admin_sys_logininfor` VALUES (510, 'admin', '14.146.93.125', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 10:17:59');
INSERT INTO `admin_sys_logininfor` VALUES (511, 'admin', '1.80.1.252', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-09-27 10:26:43');
INSERT INTO `admin_sys_logininfor` VALUES (512, 'admin', '45.77.12.12', '东京都 东京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 10:36:36');
INSERT INTO `admin_sys_logininfor` VALUES (513, 'admin', '45.77.12.12', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-27 10:37:21');
INSERT INTO `admin_sys_logininfor` VALUES (514, 'admin', '14.204.113.79', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 10:41:51');
INSERT INTO `admin_sys_logininfor` VALUES (515, 'admin', '221.239.171.11', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-27 10:46:28');
INSERT INTO `admin_sys_logininfor` VALUES (516, 'admin', '14.204.113.79', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-27 10:53:46');
INSERT INTO `admin_sys_logininfor` VALUES (517, 'admin', '111.200.53.170', '北京 北京', 'Safari', 'Mac OS X', '1', '验证码错误', '2019-09-27 11:27:03');
INSERT INTO `admin_sys_logininfor` VALUES (518, 'admin', '111.200.53.170', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-27 11:27:10');
INSERT INTO `admin_sys_logininfor` VALUES (519, 'admin', '139.226.50.212', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 11:59:36');
INSERT INTO `admin_sys_logininfor` VALUES (520, 'admin', '117.136.40.189', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-27 12:20:33');
INSERT INTO `admin_sys_logininfor` VALUES (521, 'admin', '58.211.183.162', '江苏 苏州', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-27 13:49:23');
INSERT INTO `admin_sys_logininfor` VALUES (522, 'admin', '124.64.18.161', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-09-27 14:27:08');
INSERT INTO `admin_sys_logininfor` VALUES (523, 'admin', '58.35.199.112', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 14:47:39');
INSERT INTO `admin_sys_logininfor` VALUES (524, 'admin', '58.211.183.162', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-27 14:48:12');
INSERT INTO `admin_sys_logininfor` VALUES (525, 'admin', '119.98.219.65', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2019-09-27 15:04:01');
INSERT INTO `admin_sys_logininfor` VALUES (526, 'admin', '119.98.219.65', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-27 15:04:15');
INSERT INTO `admin_sys_logininfor` VALUES (527, 'admin', '119.98.219.65', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误2次', '2019-09-27 15:04:20');
INSERT INTO `admin_sys_logininfor` VALUES (528, 'admin', '119.98.219.65', '湖北 武汉', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-09-27 15:04:42');
INSERT INTO `admin_sys_logininfor` VALUES (529, 'admin', '1.119.132.157', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-27 15:18:18');
INSERT INTO `admin_sys_logininfor` VALUES (530, 'admin', '112.115.70.56', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 15:26:39');
INSERT INTO `admin_sys_logininfor` VALUES (531, 'admin', '115.239.175.222', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-27 15:27:02');
INSERT INTO `admin_sys_logininfor` VALUES (532, 'admin', '115.183.12.234', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-27 15:30:26');
INSERT INTO `admin_sys_logininfor` VALUES (533, 'admin', '221.181.101.37', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 15:40:17');
INSERT INTO `admin_sys_logininfor` VALUES (534, 'admin', '219.156.30.227', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 16:19:17');
INSERT INTO `admin_sys_logininfor` VALUES (535, 'admin', '222.209.85.166', '四川 成都', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-27 16:20:52');
INSERT INTO `admin_sys_logininfor` VALUES (536, 'admin', '1.192.169.39', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-27 16:53:43');
INSERT INTO `admin_sys_logininfor` VALUES (537, 'admin', '117.144.129.130', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-27 17:12:04');
INSERT INTO `admin_sys_logininfor` VALUES (538, 'admin', '111.26.165.240', '吉林 长春', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-28 09:33:48');
INSERT INTO `admin_sys_logininfor` VALUES (539, 'admin', '222.87.162.158', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 09:51:37');
INSERT INTO `admin_sys_logininfor` VALUES (540, 'admin', '222.87.162.158', '贵州 黔西南', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-28 09:51:42');
INSERT INTO `admin_sys_logininfor` VALUES (541, 'admin', '112.21.33.241', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-28 09:57:58');
INSERT INTO `admin_sys_logininfor` VALUES (542, 'admin', '1.204.201.73', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 11:01:48');
INSERT INTO `admin_sys_logininfor` VALUES (543, 'admin', '1.204.201.73', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 11:07:06');
INSERT INTO `admin_sys_logininfor` VALUES (544, 'admin', '223.80.111.214', '山东 青岛', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-28 11:16:28');
INSERT INTO `admin_sys_logininfor` VALUES (545, 'admin', '223.80.111.214', '山东 青岛', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-28 11:16:49');
INSERT INTO `admin_sys_logininfor` VALUES (546, 'admin', '113.89.4.185', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 11:48:41');
INSERT INTO `admin_sys_logininfor` VALUES (547, 'admin', '117.136.35.79', '江苏 南京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-28 12:21:38');
INSERT INTO `admin_sys_logininfor` VALUES (548, 'admin', '218.90.140.70', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-28 12:30:17');
INSERT INTO `admin_sys_logininfor` VALUES (549, 'admin', '113.89.4.185', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 13:36:27');
INSERT INTO `admin_sys_logininfor` VALUES (550, 'admin', '113.89.4.185', '广东 深圳', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-28 13:51:51');
INSERT INTO `admin_sys_logininfor` VALUES (551, 'chen', '113.89.4.185', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 13:52:19');
INSERT INTO `admin_sys_logininfor` VALUES (552, 'chen', '113.89.4.185', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-28 13:52:43');
INSERT INTO `admin_sys_logininfor` VALUES (553, 'admin', '113.89.4.185', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 13:52:46');
INSERT INTO `admin_sys_logininfor` VALUES (554, 'chen', '113.89.4.185', '广东 深圳', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2019-09-28 13:53:33');
INSERT INTO `admin_sys_logininfor` VALUES (555, 'admin', '113.89.4.185', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-28 13:53:36');
INSERT INTO `admin_sys_logininfor` VALUES (556, 'chen', '113.89.4.185', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 13:53:57');
INSERT INTO `admin_sys_logininfor` VALUES (557, 'admin', '113.99.19.26', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-28 14:25:48');
INSERT INTO `admin_sys_logininfor` VALUES (558, 'admin', '61.140.182.81', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 14:40:07');
INSERT INTO `admin_sys_logininfor` VALUES (559, 'admin', '183.15.180.145', '广东 深圳', 'Internet Explorer 10', 'Windows 7', '1', '验证码错误', '2019-09-28 16:34:26');
INSERT INTO `admin_sys_logininfor` VALUES (560, 'admin', '183.15.180.145', 'XX XX', 'Internet Explorer 10', 'Windows 7', '0', '登录成功', '2019-09-28 16:34:33');
INSERT INTO `admin_sys_logininfor` VALUES (561, 'admin', '113.89.4.185', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-28 16:50:31');
INSERT INTO `admin_sys_logininfor` VALUES (562, 'admin', '125.35.68.26', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 21:33:40');
INSERT INTO `admin_sys_logininfor` VALUES (563, 'admin', '125.35.68.26', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-28 21:34:35');
INSERT INTO `admin_sys_logininfor` VALUES (564, 'admin', '27.38.37.47', 'XX XX', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2019-09-28 22:28:45');
INSERT INTO `admin_sys_logininfor` VALUES (565, 'admin', '122.97.174.26', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-28 22:40:03');
INSERT INTO `admin_sys_logininfor` VALUES (566, 'admin', '106.112.71.41', '河北 邢台', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-28 23:20:18');
INSERT INTO `admin_sys_logininfor` VALUES (567, 'admin', '115.216.53.235', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-28 23:50:16');
INSERT INTO `admin_sys_logininfor` VALUES (568, 'admin', '14.103.171.232', '广东 深圳', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-29 00:03:47');
INSERT INTO `admin_sys_logininfor` VALUES (569, 'admin', '117.175.132.46', '四川 成都', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-29 07:16:08');
INSERT INTO `admin_sys_logininfor` VALUES (570, 'admin', '123.181.238.35', '河北 秦皇岛', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 08:35:35');
INSERT INTO `admin_sys_logininfor` VALUES (571, 'admin', '119.36.214.180', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-29 08:58:44');
INSERT INTO `admin_sys_logininfor` VALUES (572, 'admin', '119.36.214.180', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-29 08:59:20');
INSERT INTO `admin_sys_logininfor` VALUES (573, 'admin', '119.36.214.180', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 08:59:22');
INSERT INTO `admin_sys_logininfor` VALUES (574, 'admin', '116.236.72.102', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 09:03:49');
INSERT INTO `admin_sys_logininfor` VALUES (575, 'admin', '119.36.214.180', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 09:10:11');
INSERT INTO `admin_sys_logininfor` VALUES (576, 'admin', '183.163.151.115', '安徽 马鞍山', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 09:28:26');
INSERT INTO `admin_sys_logininfor` VALUES (577, 'admin', '114.93.26.56', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 09:53:22');
INSERT INTO `admin_sys_logininfor` VALUES (578, 'admin', '27.38.37.96', '广东 深圳', 'Microsoft Edge', 'Windows 10', '1', '验证码错误', '2019-09-29 10:12:18');
INSERT INTO `admin_sys_logininfor` VALUES (579, 'admin', '27.38.37.96', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2019-09-29 10:12:21');
INSERT INTO `admin_sys_logininfor` VALUES (580, 'admin', '218.104.139.210', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 11:01:16');
INSERT INTO `admin_sys_logininfor` VALUES (581, 'admin', '218.104.139.210', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 11:02:05');
INSERT INTO `admin_sys_logininfor` VALUES (582, 'admin', '218.104.139.210', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 11:04:24');
INSERT INTO `admin_sys_logininfor` VALUES (583, 'admin', '218.104.139.210', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-29 11:11:32');
INSERT INTO `admin_sys_logininfor` VALUES (584, 'admin', '222.209.83.85', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 11:31:42');
INSERT INTO `admin_sys_logininfor` VALUES (585, 'admin', '101.93.220.114', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 11:34:23');
INSERT INTO `admin_sys_logininfor` VALUES (586, 'admin', '216.83.54.13', '香港 XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-29 11:45:53');
INSERT INTO `admin_sys_logininfor` VALUES (587, 'admin', '61.183.234.146', '湖北 武汉', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-29 13:54:01');
INSERT INTO `admin_sys_logininfor` VALUES (588, 'admin', '111.201.250.0', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 14:04:33');
INSERT INTO `admin_sys_logininfor` VALUES (589, 'admin', '117.136.87.6', '陕西 渭南', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-29 14:14:14');
INSERT INTO `admin_sys_logininfor` VALUES (590, 'admin', '171.113.138.218', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 14:15:59');
INSERT INTO `admin_sys_logininfor` VALUES (591, 'admin', '60.220.48.148', '山西 长治', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 14:55:57');
INSERT INTO `admin_sys_logininfor` VALUES (592, 'admin', '183.129.105.77', 'XX XX', 'Opera', 'Windows 7', '1', '验证码错误', '2019-09-29 15:29:08');
INSERT INTO `admin_sys_logininfor` VALUES (593, 'admin', '183.129.105.77', '浙江 杭州', 'Opera', 'Windows 7', '0', '登录成功', '2019-09-29 15:29:09');
INSERT INTO `admin_sys_logininfor` VALUES (594, 'admin', '113.139.106.243', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-29 15:29:52');
INSERT INTO `admin_sys_logininfor` VALUES (595, 'admin', '222.87.162.158', '贵州 黔西南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 16:15:13');
INSERT INTO `admin_sys_logininfor` VALUES (596, 'admin', '220.163.9.243', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 16:32:20');
INSERT INTO `admin_sys_logininfor` VALUES (597, 'admin', '222.129.184.33', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-29 16:43:20');
INSERT INTO `admin_sys_logininfor` VALUES (598, 'admin', '58.240.254.162', '江苏 南京', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-29 16:58:04');
INSERT INTO `admin_sys_logininfor` VALUES (599, 'admin', '60.220.48.148', '山西 长治', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 17:27:21');
INSERT INTO `admin_sys_logininfor` VALUES (600, 'admin', '117.136.64.64', '四川 成都', 'Chrome Mobile', 'Android 6.x', '0', '登录成功', '2019-09-29 20:29:36');
INSERT INTO `admin_sys_logininfor` VALUES (601, 'admin', '114.102.123.122', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 21:18:19');
INSERT INTO `admin_sys_logininfor` VALUES (602, 'admin', '218.26.54.236', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 21:24:13');
INSERT INTO `admin_sys_logininfor` VALUES (603, 'admin', '114.102.123.122', '安徽 马鞍山', 'Chrome', 'Windows 10', '0', '退出成功', '2019-09-29 21:29:20');
INSERT INTO `admin_sys_logininfor` VALUES (604, 'admin', '61.28.24.23', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 21:55:39');
INSERT INTO `admin_sys_logininfor` VALUES (605, 'admin', '119.128.221.232', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 22:08:10');
INSERT INTO `admin_sys_logininfor` VALUES (606, 'admin', '49.72.196.41', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-29 22:55:46');
INSERT INTO `admin_sys_logininfor` VALUES (607, 'admin', '119.129.129.243', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 00:06:05');
INSERT INTO `admin_sys_logininfor` VALUES (608, 'admin', '58.242.137.148', '安徽 马鞍山', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 07:37:55');
INSERT INTO `admin_sys_logininfor` VALUES (609, 'admin', '60.220.48.148', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 08:06:37');
INSERT INTO `admin_sys_logininfor` VALUES (610, 'admin', '106.83.197.187', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 08:33:17');
INSERT INTO `admin_sys_logininfor` VALUES (611, 'admin', '112.252.144.76', '山东 菏泽', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-30 08:52:22');
INSERT INTO `admin_sys_logininfor` VALUES (612, 'admin', '163.125.235.27', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 09:11:54');
INSERT INTO `admin_sys_logininfor` VALUES (613, 'admin', '222.175.142.131', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 09:19:28');
INSERT INTO `admin_sys_logininfor` VALUES (614, 'admin', '60.220.124.152', '山西 长治', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 09:34:45');
INSERT INTO `admin_sys_logininfor` VALUES (615, 'admin', '119.129.116.154', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 09:45:21');
INSERT INTO `admin_sys_logininfor` VALUES (616, 'admin', '115.205.64.229', '浙江 杭州', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-30 09:53:57');
INSERT INTO `admin_sys_logininfor` VALUES (617, 'admin', '115.205.64.229', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 09:54:29');
INSERT INTO `admin_sys_logininfor` VALUES (618, 'admin', '112.252.144.76', '山东 菏泽', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-30 09:56:19');
INSERT INTO `admin_sys_logininfor` VALUES (619, 'admin', '119.129.116.154', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-30 10:46:33');
INSERT INTO `admin_sys_logininfor` VALUES (620, 'admin', '119.129.116.154', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 10:46:44');
INSERT INTO `admin_sys_logininfor` VALUES (621, 'admin', '112.252.144.76', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-30 10:56:39');
INSERT INTO `admin_sys_logininfor` VALUES (622, 'admin', '124.64.16.116', '北京 北京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-30 11:04:48');
INSERT INTO `admin_sys_logininfor` VALUES (623, 'admin', '202.99.51.54', '北京 北京', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-30 11:59:01');
INSERT INTO `admin_sys_logininfor` VALUES (624, 'admin', '222.88.246.170', '河南 南阳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 13:18:36');
INSERT INTO `admin_sys_logininfor` VALUES (625, 'admin', '175.17.185.207', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 14:00:14');
INSERT INTO `admin_sys_logininfor` VALUES (626, 'admin', '222.88.246.170', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 14:11:58');
INSERT INTO `admin_sys_logininfor` VALUES (627, 'admin', '101.207.128.16', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-30 14:12:12');
INSERT INTO `admin_sys_logininfor` VALUES (628, 'admin', '101.207.128.16', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 14:12:18');
INSERT INTO `admin_sys_logininfor` VALUES (629, 'admin', '113.247.253.35', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 14:41:47');
INSERT INTO `admin_sys_logininfor` VALUES (630, 'admin', '120.6.227.254', '河北 秦皇岛', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-09-30 14:46:14');
INSERT INTO `admin_sys_logininfor` VALUES (631, 'admin', '120.6.227.254', '河北 秦皇岛', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 14:46:17');
INSERT INTO `admin_sys_logininfor` VALUES (632, 'admin', '140.206.194.104', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 16:57:31');
INSERT INTO `admin_sys_logininfor` VALUES (633, 'admin', '123.112.239.33', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-30 17:16:35');
INSERT INTO `admin_sys_logininfor` VALUES (634, 'admin', '120.6.227.254', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 17:27:36');
INSERT INTO `admin_sys_logininfor` VALUES (635, 'admin', '122.224.210.202', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 17:59:30');
INSERT INTO `admin_sys_logininfor` VALUES (636, 'admin', '123.117.33.166', '北京 北京', 'Safari', 'Mac OS X', '0', '登录成功', '2019-09-30 18:36:04');
INSERT INTO `admin_sys_logininfor` VALUES (637, 'admin', '220.249.162.110', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-09-30 19:05:43');
INSERT INTO `admin_sys_logininfor` VALUES (638, 'admin', '218.5.255.108', '福建 三明', 'Chrome', 'Windows 7', '0', '登录成功', '2019-09-30 19:07:25');
INSERT INTO `admin_sys_logininfor` VALUES (639, 'admin', '222.240.21.27', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-09-30 19:18:41');
INSERT INTO `admin_sys_logininfor` VALUES (640, 'admin', '117.28.113.111', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2019-09-30 20:26:10');
INSERT INTO `admin_sys_logininfor` VALUES (641, 'admin', '103.27.26.128', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 20:50:13');
INSERT INTO `admin_sys_logininfor` VALUES (642, 'admin', '117.23.81.77', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-09-30 21:53:52');
INSERT INTO `admin_sys_logininfor` VALUES (643, 'admin', '101.87.232.149', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-01 07:54:40');
INSERT INTO `admin_sys_logininfor` VALUES (644, 'admin', '101.87.232.149', '上海 上海', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-10-01 07:54:42');
INSERT INTO `admin_sys_logininfor` VALUES (645, 'admin', '220.195.67.43', '内蒙古 XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-01 10:20:14');
INSERT INTO `admin_sys_logininfor` VALUES (646, 'admin', '103.194.149.85', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-10-01 10:22:42');
INSERT INTO `admin_sys_logininfor` VALUES (647, 'admin', '171.36.1.232', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-02 18:42:47');
INSERT INTO `admin_sys_logininfor` VALUES (648, 'admin', '113.91.43.135', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-02 18:42:52');
INSERT INTO `admin_sys_logininfor` VALUES (649, 'admin', '183.27.118.76', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-02 18:54:08');
INSERT INTO `admin_sys_logininfor` VALUES (650, 'admin', '123.163.215.86', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-02 19:07:29');
INSERT INTO `admin_sys_logininfor` VALUES (651, 'admin', '223.104.21.251', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-02 19:07:47');
INSERT INTO `admin_sys_logininfor` VALUES (652, 'admin', '123.163.215.86', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-02 19:21:09');
INSERT INTO `admin_sys_logininfor` VALUES (653, 'admin', '211.97.128.115', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-02 19:31:18');
INSERT INTO `admin_sys_logininfor` VALUES (654, 'admin', '183.92.250.74', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-02 20:34:29');
INSERT INTO `admin_sys_logininfor` VALUES (655, 'admin', '114.93.26.56', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-02 20:37:08');
INSERT INTO `admin_sys_logininfor` VALUES (656, 'admin', '14.131.77.83', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-02 20:46:20');
INSERT INTO `admin_sys_logininfor` VALUES (657, 'admin', '117.136.88.30', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-02 21:32:11');
INSERT INTO `admin_sys_logininfor` VALUES (658, 'admin', '117.136.23.186', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-02 21:42:55');
INSERT INTO `admin_sys_logininfor` VALUES (659, 'admin', '27.211.12.108', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-03 00:47:00');
INSERT INTO `admin_sys_logininfor` VALUES (660, 'admin', '27.211.12.108', '山东 济南', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-03 00:47:51');
INSERT INTO `admin_sys_logininfor` VALUES (661, 'admin', '27.211.12.108', '山东 济南', 'Firefox Mobile (iOS)', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-03 00:51:19');
INSERT INTO `admin_sys_logininfor` VALUES (662, 'admin', '27.211.12.108', 'XX XX', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-03 00:52:23');
INSERT INTO `admin_sys_logininfor` VALUES (663, 'admin', '218.18.163.231', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 01:28:03');
INSERT INTO `admin_sys_logininfor` VALUES (664, 'admin', '117.136.118.4', '安徽 阜阳', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 05:02:11');
INSERT INTO `admin_sys_logininfor` VALUES (665, 'admin', '223.104.21.242', '湖南 长沙', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-03 07:19:14');
INSERT INTO `admin_sys_logininfor` VALUES (666, 'admin', '153.118.115.104', '山东 济南', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-03 07:31:48');
INSERT INTO `admin_sys_logininfor` VALUES (667, 'admin', '112.237.6.124', '山东 烟台', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-10-03 09:04:07');
INSERT INTO `admin_sys_logininfor` VALUES (668, 'admin', '58.44.47.105', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 10:05:18');
INSERT INTO `admin_sys_logininfor` VALUES (669, 'admin', '218.74.11.204', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 11:40:31');
INSERT INTO `admin_sys_logininfor` VALUES (670, 'admin', '220.115.30.41', '天津 天津', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-10-03 11:41:21');
INSERT INTO `admin_sys_logininfor` VALUES (671, 'admin', '220.115.30.41', '天津 天津', 'Chrome', 'Windows 7', '0', '登录成功', '2019-10-03 11:41:33');
INSERT INTO `admin_sys_logininfor` VALUES (672, 'admin', '112.12.141.185', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-10-03 11:48:18');
INSERT INTO `admin_sys_logininfor` VALUES (673, 'admin', '123.233.214.10', '山东 济南', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-03 13:11:58');
INSERT INTO `admin_sys_logininfor` VALUES (674, 'admin', '118.114.14.188', '四川 成都', 'Chrome', 'Windows 8', '0', '登录成功', '2019-10-03 14:43:05');
INSERT INTO `admin_sys_logininfor` VALUES (675, 'admin', '114.87.228.20', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-03 16:00:42');
INSERT INTO `admin_sys_logininfor` VALUES (676, 'admin', '114.93.26.56', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2019-10-03 16:22:00');
INSERT INTO `admin_sys_logininfor` VALUES (677, 'admin', '1.91.124.18', '北京 北京', 'Chrome', 'Windows 8', '0', '登录成功', '2019-10-03 16:25:54');
INSERT INTO `admin_sys_logininfor` VALUES (678, 'admin', '114.93.26.56', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 16:27:05');
INSERT INTO `admin_sys_logininfor` VALUES (679, 'admin', '114.93.26.56', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 16:50:31');
INSERT INTO `admin_sys_logininfor` VALUES (680, 'admin', '120.85.77.198', '广东 广州', 'Chrome Mobile', 'Android 6.x', '0', '登录成功', '2019-10-03 17:13:07');
INSERT INTO `admin_sys_logininfor` VALUES (681, 'admin', '120.85.77.198', '广东 广州', 'Chrome Mobile', 'Android 6.x', '1', '验证码错误', '2019-10-03 17:13:17');
INSERT INTO `admin_sys_logininfor` VALUES (682, 'admin', '58.35.182.74', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-10-03 17:30:43');
INSERT INTO `admin_sys_logininfor` VALUES (683, 'admin', '180.130.2.15', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-03 18:43:58');
INSERT INTO `admin_sys_logininfor` VALUES (684, 'admin', '60.24.181.154', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 18:57:55');
INSERT INTO `admin_sys_logininfor` VALUES (685, 'admin', '114.93.26.56', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-03 19:03:13');
INSERT INTO `admin_sys_logininfor` VALUES (686, 'admin', '223.74.103.7', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-10-03 22:44:11');
INSERT INTO `admin_sys_logininfor` VALUES (687, 'admin', '220.202.152.39', '湖南 长沙', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2019-10-04 07:03:28');
INSERT INTO `admin_sys_logininfor` VALUES (688, 'admin', '220.202.152.39', '湖南 长沙', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-04 07:03:52');
INSERT INTO `admin_sys_logininfor` VALUES (689, 'admin', '14.120.81.73', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2019-10-04 08:03:57');
INSERT INTO `admin_sys_logininfor` VALUES (690, 'admin', '113.74.214.245', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-04 13:28:16');
INSERT INTO `admin_sys_logininfor` VALUES (691, 'admin', '113.247.228.202', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-04 14:47:33');
INSERT INTO `admin_sys_logininfor` VALUES (692, 'admin', '223.74.103.7', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-10-04 21:06:14');
INSERT INTO `admin_sys_logininfor` VALUES (693, 'admin', '117.89.16.57', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 04:11:44');
INSERT INTO `admin_sys_logininfor` VALUES (694, 'admin', '112.28.175.151', '安徽 合肥', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-05 06:24:45');
INSERT INTO `admin_sys_logininfor` VALUES (695, 'admin', '112.28.175.151', '安徽 合肥', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-05 06:25:40');
INSERT INTO `admin_sys_logininfor` VALUES (696, 'admin', '111.34.149.14', '山东 济宁', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-05 08:13:30');
INSERT INTO `admin_sys_logininfor` VALUES (697, 'admin', '117.188.11.219', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 09:20:53');
INSERT INTO `admin_sys_logininfor` VALUES (698, 'admin', '113.104.251.219', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 10:31:40');
INSERT INTO `admin_sys_logininfor` VALUES (699, 'admin', '113.104.251.219', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 11:19:52');
INSERT INTO `admin_sys_logininfor` VALUES (700, 'admin', '112.96.170.86', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-05 11:35:28');
INSERT INTO `admin_sys_logininfor` VALUES (701, 'admin', '112.96.170.86', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2019-10-05 11:38:00');
INSERT INTO `admin_sys_logininfor` VALUES (702, 'admin', '112.96.170.86', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-05 11:38:10');
INSERT INTO `admin_sys_logininfor` VALUES (703, 'admin', '219.142.146.30', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 16:12:14');
INSERT INTO `admin_sys_logininfor` VALUES (704, 'admin', '119.85.100.249', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-10-05 17:18:38');
INSERT INTO `admin_sys_logininfor` VALUES (705, 'admin', '111.74.36.171', 'XX XX', 'Firefox', 'Ubuntu', '1', '验证码错误', '2019-10-05 18:59:51');
INSERT INTO `admin_sys_logininfor` VALUES (706, 'admin', '111.74.36.171', 'XX XX', 'Firefox', 'Ubuntu', '0', '登录成功', '2019-10-05 18:59:56');
INSERT INTO `admin_sys_logininfor` VALUES (707, 'admin', '111.74.36.171', 'XX XX', 'Firefox', 'Ubuntu', '1', '验证码错误', '2019-10-05 19:01:09');
INSERT INTO `admin_sys_logininfor` VALUES (708, 'admin', '111.74.36.171', 'XX XX', 'Firefox', 'Ubuntu', '0', '登录成功', '2019-10-05 19:17:13');
INSERT INTO `admin_sys_logininfor` VALUES (709, 'admin', '223.96.227.236', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 19:23:04');
INSERT INTO `admin_sys_logininfor` VALUES (710, 'admin', '120.235.123.83', 'XX XX', 'Firefox', 'Windows 10', '0', '登录成功', '2019-10-05 20:37:46');
INSERT INTO `admin_sys_logininfor` VALUES (711, 'admin', '117.136.104.66', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-05 20:40:50');
INSERT INTO `admin_sys_logininfor` VALUES (712, 'admin', '117.136.104.66', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2019-10-05 20:56:43');
INSERT INTO `admin_sys_logininfor` VALUES (713, 'admin', '117.136.104.66', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '退出成功', '2019-10-05 20:56:48');
INSERT INTO `admin_sys_logininfor` VALUES (714, 'admin', '183.209.234.94', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 21:11:59');
INSERT INTO `admin_sys_logininfor` VALUES (715, 'admin', '111.0.169.49', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-05 22:57:07');
INSERT INTO `admin_sys_logininfor` VALUES (716, 'admin', '110.87.47.246', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-10-06 11:52:30');
INSERT INTO `admin_sys_logininfor` VALUES (717, 'admin', '110.87.47.246', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-06 11:52:36');
INSERT INTO `admin_sys_logininfor` VALUES (718, 'admin', '114.96.175.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-06 14:36:57');
INSERT INTO `admin_sys_logininfor` VALUES (719, 'admin', '218.70.169.6', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2019-10-06 14:51:35');
INSERT INTO `admin_sys_logininfor` VALUES (720, 'admin', '218.70.169.6', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2019-10-06 14:52:14');
INSERT INTO `admin_sys_logininfor` VALUES (721, 'admin', '223.104.6.122', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2019-10-06 15:36:19');
INSERT INTO `admin_sys_logininfor` VALUES (722, 'admin', '223.104.6.122', '福建 厦门', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2019-10-06 15:36:24');
INSERT INTO `admin_sys_logininfor` VALUES (723, 'admin', '118.114.12.85', 'XX XX', 'Chrome', 'Windows 8', '1', '验证码错误', '2019-10-06 20:23:02');
INSERT INTO `admin_sys_logininfor` VALUES (724, 'admin', '118.114.12.85', 'XX XX', 'Chrome', 'Windows 8', '0', '登录成功', '2019-10-06 20:39:11');
INSERT INTO `admin_sys_logininfor` VALUES (725, 'admin', '123.122.151.43', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-06 21:27:26');
INSERT INTO `admin_sys_logininfor` VALUES (726, 'admin', '123.122.151.43', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-06 23:35:52');
INSERT INTO `admin_sys_logininfor` VALUES (727, 'admin', '221.237.179.149', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-07 08:33:48');
INSERT INTO `admin_sys_logininfor` VALUES (728, 'admin', '113.120.50.167', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2019-10-07 09:13:23');
INSERT INTO `admin_sys_logininfor` VALUES (729, 'admin', '61.178.60.205', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2019-10-07 11:40:42');
INSERT INTO `admin_sys_logininfor` VALUES (730, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-10-14 17:30:28');
INSERT INTO `admin_sys_logininfor` VALUES (731, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2019-10-25 10:56:32');
INSERT INTO `admin_sys_logininfor` VALUES (732, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-03 10:43:25');
INSERT INTO `admin_sys_logininfor` VALUES (733, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-03 10:51:00');
INSERT INTO `admin_sys_logininfor` VALUES (734, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-03 16:16:37');
INSERT INTO `admin_sys_logininfor` VALUES (735, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-04 21:36:33');
INSERT INTO `admin_sys_logininfor` VALUES (736, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-10 14:43:29');
INSERT INTO `admin_sys_logininfor` VALUES (737, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-10 14:43:38');
INSERT INTO `admin_sys_logininfor` VALUES (738, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-10 14:43:43');
INSERT INTO `admin_sys_logininfor` VALUES (739, 'admin', '123.14.86.169', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-10 15:21:06');
INSERT INTO `admin_sys_logininfor` VALUES (740, 'admin', '123.14.86.169', '河南 郑州', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-10 15:30:57');
INSERT INTO `admin_sys_logininfor` VALUES (741, 'admin', '123.14.86.169', '河南 郑州', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-01-10 18:34:20');
INSERT INTO `admin_sys_logininfor` VALUES (742, 'admin', '123.14.86.169', '河南 郑州', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-01-10 18:34:25');
INSERT INTO `admin_sys_logininfor` VALUES (743, 'admin', '123.14.86.169', '河南 郑州', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-10 18:34:30');
INSERT INTO `admin_sys_logininfor` VALUES (744, 'admin', '115.60.122.32', '河南 郑州', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-01-10 23:04:24');
INSERT INTO `admin_sys_logininfor` VALUES (745, 'admin', '115.60.122.32', '河南 郑州', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-10 23:04:32');
INSERT INTO `admin_sys_logininfor` VALUES (746, 'admin', '115.60.122.32', '河南 郑州', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-10 23:17:10');
INSERT INTO `admin_sys_logininfor` VALUES (747, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 15:06:49');
INSERT INTO `admin_sys_logininfor` VALUES (748, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '退出成功', '2020-01-13 15:18:45');
INSERT INTO `admin_sys_logininfor` VALUES (749, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 15:18:55');
INSERT INTO `admin_sys_logininfor` VALUES (750, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 15:20:50');
INSERT INTO `admin_sys_logininfor` VALUES (751, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '退出成功', '2020-01-13 15:37:10');
INSERT INTO `admin_sys_logininfor` VALUES (752, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 15:37:15');
INSERT INTO `admin_sys_logininfor` VALUES (753, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 15:39:36');
INSERT INTO `admin_sys_logininfor` VALUES (754, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 16:23:23');
INSERT INTO `admin_sys_logininfor` VALUES (755, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 16:24:11');
INSERT INTO `admin_sys_logininfor` VALUES (756, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 16:26:18');
INSERT INTO `admin_sys_logininfor` VALUES (757, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 16:44:18');
INSERT INTO `admin_sys_logininfor` VALUES (758, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 17:00:02');
INSERT INTO `admin_sys_logininfor` VALUES (759, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '退出成功', '2020-01-13 17:11:00');
INSERT INTO `admin_sys_logininfor` VALUES (760, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 17:11:05');
INSERT INTO `admin_sys_logininfor` VALUES (761, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '退出成功', '2020-01-13 18:15:03');
INSERT INTO `admin_sys_logininfor` VALUES (762, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 18:15:09');
INSERT INTO `admin_sys_logininfor` VALUES (763, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-13 20:33:49');
INSERT INTO `admin_sys_logininfor` VALUES (764, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-14 16:17:59');
INSERT INTO `admin_sys_logininfor` VALUES (765, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-14 16:18:42');
INSERT INTO `admin_sys_logininfor` VALUES (766, 'admin', '124.126.145.15', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-14 19:25:13');
INSERT INTO `admin_sys_logininfor` VALUES (767, 'admin', '139.207.123.19', '四川 成都', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-14 20:01:48');
INSERT INTO `admin_sys_logininfor` VALUES (768, 'admin', '117.151.174.142', '湖北 荆州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-14 20:07:24');
INSERT INTO `admin_sys_logininfor` VALUES (769, 'admin', '101.232.219.59', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-14 21:26:18');
INSERT INTO `admin_sys_logininfor` VALUES (770, 'admin', '101.231.70.246', '上海 上海', 'Firefox 7', 'Mac OS X', '0', '登录成功', '2020-01-14 22:53:11');
INSERT INTO `admin_sys_logininfor` VALUES (771, 'admin', '36.23.113.99', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-15 09:33:15');
INSERT INTO `admin_sys_logininfor` VALUES (772, 'admin', '223.11.195.222', '山西 太原', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-15 10:00:31');
INSERT INTO `admin_sys_logininfor` VALUES (773, 'admin', '223.11.195.222', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 10:00:33');
INSERT INTO `admin_sys_logininfor` VALUES (774, 'admin', '218.107.213.89', '福建 厦门', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-15 10:19:15');
INSERT INTO `admin_sys_logininfor` VALUES (775, 'admin', '218.107.213.89', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 10:19:19');
INSERT INTO `admin_sys_logininfor` VALUES (776, 'admin', '59.57.154.125', '福建 厦门', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-01-15 10:54:13');
INSERT INTO `admin_sys_logininfor` VALUES (777, 'admin', '59.57.154.125', '福建 厦门', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-15 10:54:19');
INSERT INTO `admin_sys_logininfor` VALUES (778, 'admin', '223.11.195.222', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 11:19:23');
INSERT INTO `admin_sys_logininfor` VALUES (779, 'admin', '59.61.164.170', '福建 福州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 11:47:05');
INSERT INTO `admin_sys_logininfor` VALUES (780, 'admin', '113.57.170.50', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 13:15:03');
INSERT INTO `admin_sys_logininfor` VALUES (781, 'admin', '58.246.9.146', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 13:25:47');
INSERT INTO `admin_sys_logininfor` VALUES (782, 'admin', '111.42.155.48', '黑龙江 哈尔滨', 'Safari', 'Mac OS X', '0', '登录成功', '2020-01-15 13:27:03');
INSERT INTO `admin_sys_logininfor` VALUES (783, 'admin', '183.47.50.43', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 13:27:15');
INSERT INTO `admin_sys_logininfor` VALUES (784, 'admin', '211.150.88.182', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-01-15 13:27:48');
INSERT INTO `admin_sys_logininfor` VALUES (785, 'admin', '211.150.88.182', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-01-15 13:27:55');
INSERT INTO `admin_sys_logininfor` VALUES (786, 'admin', '211.150.88.182', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-15 13:28:02');
INSERT INTO `admin_sys_logininfor` VALUES (787, 'admin', '124.77.240.37', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 13:28:55');
INSERT INTO `admin_sys_logininfor` VALUES (788, 'admin', '58.243.254.173', '安徽 合肥', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-01-15 13:30:29');
INSERT INTO `admin_sys_logininfor` VALUES (789, 'admin', '58.243.254.173', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-15 13:30:36');
INSERT INTO `admin_sys_logininfor` VALUES (790, 'admin', '113.81.197.173', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-15 13:37:53');
INSERT INTO `admin_sys_logininfor` VALUES (791, 'admin', '113.81.197.173', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 13:38:05');
INSERT INTO `admin_sys_logininfor` VALUES (792, 'admin', '60.190.230.35', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 13:39:13');
INSERT INTO `admin_sys_logininfor` VALUES (793, 'admin', '117.186.242.42', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 13:43:13');
INSERT INTO `admin_sys_logininfor` VALUES (794, 'admin', '175.6.6.138', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 13:49:42');
INSERT INTO `admin_sys_logininfor` VALUES (795, 'admin', '36.27.94.58', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 13:58:55');
INSERT INTO `admin_sys_logininfor` VALUES (796, 'admin', '115.183.5.161', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 14:00:59');
INSERT INTO `admin_sys_logininfor` VALUES (797, 'admin', '124.126.145.15', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 14:13:16');
INSERT INTO `admin_sys_logininfor` VALUES (798, 'admin', '153.99.122.34', '江苏 连云港', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-01-15 14:15:34');
INSERT INTO `admin_sys_logininfor` VALUES (799, 'admin', '153.99.122.34', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 14:15:39');
INSERT INTO `admin_sys_logininfor` VALUES (800, 'admin', '124.127.118.165', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 14:26:15');
INSERT INTO `admin_sys_logininfor` VALUES (801, 'admin', '36.17.91.24', '浙江 杭州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-15 14:31:33');
INSERT INTO `admin_sys_logininfor` VALUES (802, 'admin', '220.184.207.133', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 14:34:58');
INSERT INTO `admin_sys_logininfor` VALUES (803, 'admin', '115.205.240.52', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 14:41:41');
INSERT INTO `admin_sys_logininfor` VALUES (804, 'admin', '115.205.240.52', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-15 14:47:18');
INSERT INTO `admin_sys_logininfor` VALUES (805, 'admin', '115.205.240.52', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 14:47:36');
INSERT INTO `admin_sys_logininfor` VALUES (806, 'admin', '124.126.145.15', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 14:59:57');
INSERT INTO `admin_sys_logininfor` VALUES (807, 'admin', '183.194.26.206', '上海 上海', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-15 15:14:43');
INSERT INTO `admin_sys_logininfor` VALUES (808, 'admin', '183.194.26.206', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 15:14:49');
INSERT INTO `admin_sys_logininfor` VALUES (809, 'admin', '223.11.195.222', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 15:16:00');
INSERT INTO `admin_sys_logininfor` VALUES (810, 'admin', '58.246.68.6', '上海 上海', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-15 15:30:38');
INSERT INTO `admin_sys_logininfor` VALUES (811, 'admin', '115.205.240.52', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 15:33:58');
INSERT INTO `admin_sys_logininfor` VALUES (812, 'admin', '49.64.167.230', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 15:41:09');
INSERT INTO `admin_sys_logininfor` VALUES (813, 'admin', '124.127.118.165', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 15:48:34');
INSERT INTO `admin_sys_logininfor` VALUES (814, 'admin', '115.196.177.162', '浙江 杭州', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-01-15 17:13:30');
INSERT INTO `admin_sys_logininfor` VALUES (815, 'admin', '115.196.177.162', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-15 17:13:34');
INSERT INTO `admin_sys_logininfor` VALUES (816, 'admin', '27.17.225.134', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-15 17:40:36');
INSERT INTO `admin_sys_logininfor` VALUES (817, 'admin', '27.17.225.134', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 17:40:44');
INSERT INTO `admin_sys_logininfor` VALUES (818, 'admin', '115.199.57.236', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 19:20:11');
INSERT INTO `admin_sys_logininfor` VALUES (819, 'admin', '115.199.57.236', '浙江 杭州', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-15 19:20:26');
INSERT INTO `admin_sys_logininfor` VALUES (820, 'admin', '115.199.57.236', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 19:20:45');
INSERT INTO `admin_sys_logininfor` VALUES (821, 'admin', '113.57.247.87', '湖北 武汉', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-15 19:55:29');
INSERT INTO `admin_sys_logininfor` VALUES (822, 'admin', '117.152.85.231', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-15 21:18:43');
INSERT INTO `admin_sys_logininfor` VALUES (823, 'admin', '218.68.107.66', '天津 天津', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-15 22:06:26');
INSERT INTO `admin_sys_logininfor` VALUES (824, 'admin', '117.136.79.186', '广东 XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-01-16 07:24:38');
INSERT INTO `admin_sys_logininfor` VALUES (825, 'admin', '117.136.79.186', '广东 XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-16 07:24:45');
INSERT INTO `admin_sys_logininfor` VALUES (826, 'admin', '117.136.79.186', '广东 XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-16 07:25:26');
INSERT INTO `admin_sys_logininfor` VALUES (827, 'admin', '112.224.131.155', '山东 济南', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-16 08:00:11');
INSERT INTO `admin_sys_logininfor` VALUES (828, 'admin', '223.11.195.222', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 10:00:20');
INSERT INTO `admin_sys_logininfor` VALUES (829, 'admin', '218.107.213.89', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 10:41:48');
INSERT INTO `admin_sys_logininfor` VALUES (830, 'admin', '27.219.194.238', '山东 青岛', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 11:00:13');
INSERT INTO `admin_sys_logininfor` VALUES (831, 'admin', '183.14.132.2', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 11:09:49');
INSERT INTO `admin_sys_logininfor` VALUES (832, 'admin', '223.11.195.222', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 11:24:45');
INSERT INTO `admin_sys_logininfor` VALUES (833, 'admin', '117.89.70.68', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 13:26:40');
INSERT INTO `admin_sys_logininfor` VALUES (834, 'admin', '117.89.70.68', '江苏 南京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-16 13:27:53');
INSERT INTO `admin_sys_logininfor` VALUES (835, 'admin', '39.144.18.235', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-16 13:40:24');
INSERT INTO `admin_sys_logininfor` VALUES (836, 'admin', '223.11.188.139', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 14:05:04');
INSERT INTO `admin_sys_logininfor` VALUES (837, 'admin', '114.97.233.66', '安徽 合肥', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 14:25:41');
INSERT INTO `admin_sys_logininfor` VALUES (838, 'admin', '1.203.87.248', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 14:27:19');
INSERT INTO `admin_sys_logininfor` VALUES (839, 'admin', '39.155.214.66', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 14:58:09');
INSERT INTO `admin_sys_logininfor` VALUES (840, 'admin', '223.11.188.139', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 15:00:19');
INSERT INTO `admin_sys_logininfor` VALUES (841, 'admin', '39.155.214.66', '北京 北京', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-16 15:12:42');
INSERT INTO `admin_sys_logininfor` VALUES (842, 'admin', '113.108.59.90', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 15:21:27');
INSERT INTO `admin_sys_logininfor` VALUES (843, 'admin', '124.205.141.242', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 15:47:22');
INSERT INTO `admin_sys_logininfor` VALUES (844, 'admin', '113.139.243.170', '陕西 西安', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 15:51:37');
INSERT INTO `admin_sys_logininfor` VALUES (845, 'admin', '118.85.207.20', '上海 上海', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-16 17:09:02');
INSERT INTO `admin_sys_logininfor` VALUES (846, 'admin', '183.228.27.211', '重庆 重庆', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-16 18:23:42');
INSERT INTO `admin_sys_logininfor` VALUES (847, 'admin', '43.250.200.12', '湖南 长沙', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-16 18:45:47');
INSERT INTO `admin_sys_logininfor` VALUES (848, 'admin', '111.205.43.245', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-16 19:32:53');
INSERT INTO `admin_sys_logininfor` VALUES (850, 'admin', '115.206.136.60', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-16 22:10:45');
INSERT INTO `admin_sys_logininfor` VALUES (851, 'admin', '115.206.136.60', '浙江 杭州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-16 22:17:53');
INSERT INTO `admin_sys_logininfor` VALUES (852, 'admin', '112.10.69.169', '浙江 杭州', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-16 22:21:10');
INSERT INTO `admin_sys_logininfor` VALUES (853, 'admin', '112.17.240.29', '浙江 杭州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-16 22:38:10');
INSERT INTO `admin_sys_logininfor` VALUES (854, 'admin', '113.87.128.103', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-17 08:34:31');
INSERT INTO `admin_sys_logininfor` VALUES (855, 'admin', '115.238.59.162', '浙江 杭州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-17 09:15:45');
INSERT INTO `admin_sys_logininfor` VALUES (856, 'admin', '115.236.44.178', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 09:18:04');
INSERT INTO `admin_sys_logininfor` VALUES (857, 'admin', '115.236.44.178', '浙江 杭州', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-17 09:32:02');
INSERT INTO `admin_sys_logininfor` VALUES (858, 'admin', '60.176.104.81', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 09:39:07');
INSERT INTO `admin_sys_logininfor` VALUES (859, 'admin', '39.130.3.213', '云南 红河', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-01-17 09:44:56');
INSERT INTO `admin_sys_logininfor` VALUES (860, 'admin', '218.17.189.38', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 10:09:22');
INSERT INTO `admin_sys_logininfor` VALUES (861, 'admin', '180.173.80.85', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 11:04:42');
INSERT INTO `admin_sys_logininfor` VALUES (862, 'admin', '180.173.80.85', 'XX XX', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-01-17 11:05:45');
INSERT INTO `admin_sys_logininfor` VALUES (863, 'admin', '119.57.105.74', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 11:19:11');
INSERT INTO `admin_sys_logininfor` VALUES (864, 'admin', '123.103.9.8', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 11:22:13');
INSERT INTO `admin_sys_logininfor` VALUES (865, 'admin', '111.196.128.195', '北京 北京', 'Firefox 7', 'Mac OS X', '0', '登录成功', '2020-01-17 11:32:11');
INSERT INTO `admin_sys_logininfor` VALUES (866, 'admin', '121.69.56.214', '北京 北京', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-01-17 11:42:44');
INSERT INTO `admin_sys_logininfor` VALUES (867, 'admin', '120.36.202.106', '福建 厦门', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-01-17 11:46:43');
INSERT INTO `admin_sys_logininfor` VALUES (868, 'admin', '110.249.184.250', '河北 石家庄', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-01-17 15:25:07');
INSERT INTO `admin_sys_logininfor` VALUES (869, 'admin', '110.249.184.250', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-17 15:25:24');
INSERT INTO `admin_sys_logininfor` VALUES (870, 'admin', '14.153.49.79', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-17 15:35:39');
INSERT INTO `admin_sys_logininfor` VALUES (871, 'admin', '175.11.28.247', '湖南 长沙', 'Chrome 49', 'Windows 10', '0', '登录成功', '2020-01-17 17:44:33');
INSERT INTO `admin_sys_logininfor` VALUES (872, 'admin', '117.62.138.245', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-17 19:45:02');
INSERT INTO `admin_sys_logininfor` VALUES (873, 'admin', '117.62.138.245', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-17 19:47:43');
INSERT INTO `admin_sys_logininfor` VALUES (874, 'admin', '117.62.138.245', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-17 19:47:47');
INSERT INTO `admin_sys_logininfor` VALUES (875, 'admin', '218.68.107.66', '天津 天津', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-17 22:51:53');
INSERT INTO `admin_sys_logininfor` VALUES (876, 'admin', '61.156.120.174', '山东 青岛', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-01-17 23:35:18');
INSERT INTO `admin_sys_logininfor` VALUES (877, 'admin', '61.156.120.174', '山东 青岛', 'Internet Explorer 11', 'Windows 10', '0', '退出成功', '2020-01-17 23:35:24');
INSERT INTO `admin_sys_logininfor` VALUES (878, 'admin', '61.156.120.174', '山东 青岛', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-01-17 23:35:34');
INSERT INTO `admin_sys_logininfor` VALUES (879, 'admin', '27.10.58.125', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-18 00:16:46');
INSERT INTO `admin_sys_logininfor` VALUES (880, 'admin', '59.48.16.174', '山西 大同', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-18 08:56:45');
INSERT INTO `admin_sys_logininfor` VALUES (881, 'admin', '112.42.7.66', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-18 09:56:21');
INSERT INTO `admin_sys_logininfor` VALUES (882, 'admin', '183.200.10.121', '山西 太原', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-01-18 17:11:19');
INSERT INTO `admin_sys_logininfor` VALUES (883, 'admin', '183.200.10.121', '山西 太原', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-18 17:11:24');
INSERT INTO `admin_sys_logininfor` VALUES (884, 'admin', '218.68.105.10', '天津 天津', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-18 23:13:39');
INSERT INTO `admin_sys_logininfor` VALUES (885, 'admin', '219.133.100.103', 'XX XX', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-01-18 23:38:03');
INSERT INTO `admin_sys_logininfor` VALUES (886, 'admin', '218.13.14.205', '广东 佛山', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-19 09:55:28');
INSERT INTO `admin_sys_logininfor` VALUES (887, 'admin', '218.13.14.204', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-19 09:57:43');
INSERT INTO `admin_sys_logininfor` VALUES (888, 'admin', '117.64.248.171', '安徽 合肥', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-19 10:15:18');
INSERT INTO `admin_sys_logininfor` VALUES (889, 'admin', '121.34.31.115', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-19 10:28:06');
INSERT INTO `admin_sys_logininfor` VALUES (890, 'admin', '117.64.248.171', '安徽 合肥', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-19 10:32:31');
INSERT INTO `admin_sys_logininfor` VALUES (891, 'admin', '113.111.200.186', '广东 广州', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-01-19 14:08:34');
INSERT INTO `admin_sys_logininfor` VALUES (892, 'admin', '117.139.13.74', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-19 14:27:24');
INSERT INTO `admin_sys_logininfor` VALUES (893, 'admin', '183.185.185.0', '山西 太原', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-19 15:05:08');
INSERT INTO `admin_sys_logininfor` VALUES (894, 'admin', '223.152.38.149', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-19 15:14:35');
INSERT INTO `admin_sys_logininfor` VALUES (895, 'admin', '211.142.12.157', '山西 太原', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-19 15:40:35');
INSERT INTO `admin_sys_logininfor` VALUES (896, 'admin', '140.240.45.66', '海南 海口', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-19 16:24:05');
INSERT INTO `admin_sys_logininfor` VALUES (897, 'admin', '115.236.71.68', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-20 09:47:20');
INSERT INTO `admin_sys_logininfor` VALUES (898, 'admin', '115.236.71.68', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-20 10:33:35');
INSERT INTO `admin_sys_logininfor` VALUES (899, 'admin', '117.64.248.171', '安徽 合肥', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-20 10:45:54');
INSERT INTO `admin_sys_logininfor` VALUES (900, 'admin', '117.136.59.40', '吉林 长春', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-20 11:33:33');
INSERT INTO `admin_sys_logininfor` VALUES (901, 'admin', '115.183.5.170', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-20 14:58:17');
INSERT INTO `admin_sys_logininfor` VALUES (902, 'admin', '113.45.41.180', '北京 北京', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-20 15:27:47');
INSERT INTO `admin_sys_logininfor` VALUES (903, 'admin', '222.137.46.188', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-20 15:35:10');
INSERT INTO `admin_sys_logininfor` VALUES (904, 'admin', '222.137.46.188', '河南 郑州', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-20 15:43:56');
INSERT INTO `admin_sys_logininfor` VALUES (905, 'admin', '114.87.168.79', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-20 20:23:04');
INSERT INTO `admin_sys_logininfor` VALUES (906, 'admin', '122.224.228.133', '浙江 杭州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-21 10:26:22');
INSERT INTO `admin_sys_logininfor` VALUES (907, 'admin', '103.27.25.177', '广东 广州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-21 11:13:16');
INSERT INTO `admin_sys_logininfor` VALUES (908, 'admin', '103.27.25.177', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-21 11:13:19');
INSERT INTO `admin_sys_logininfor` VALUES (909, 'admin', '222.244.145.26', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-21 13:36:50');
INSERT INTO `admin_sys_logininfor` VALUES (910, 'admin', '222.244.145.26', '湖南 长沙', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-21 13:43:05');
INSERT INTO `admin_sys_logininfor` VALUES (911, 'admin', '222.244.145.26', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-21 14:20:01');
INSERT INTO `admin_sys_logininfor` VALUES (912, 'admin', '117.35.117.234', '陕西 西安', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-21 18:17:26');
INSERT INTO `admin_sys_logininfor` VALUES (913, 'admin', '222.77.40.134', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-21 18:28:43');
INSERT INTO `admin_sys_logininfor` VALUES (914, 'admin', '223.73.56.5', '广东 广州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-21 23:05:49');
INSERT INTO `admin_sys_logininfor` VALUES (915, 'admin', '103.27.26.165', '广东 广州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-21 23:10:14');
INSERT INTO `admin_sys_logininfor` VALUES (916, 'admin', '110.87.81.237', '福建 厦门', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-01-22 10:56:05');
INSERT INTO `admin_sys_logininfor` VALUES (917, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-01-22 14:40:27');
INSERT INTO `admin_sys_logininfor` VALUES (918, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-22 14:40:31');
INSERT INTO `admin_sys_logininfor` VALUES (919, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-01-22 14:40:36');
INSERT INTO `admin_sys_logininfor` VALUES (920, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-01-22 14:40:44');
INSERT INTO `admin_sys_logininfor` VALUES (921, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-01-22 14:43:03');
INSERT INTO `admin_sys_logininfor` VALUES (922, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-22 14:43:42');
INSERT INTO `admin_sys_logininfor` VALUES (923, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-01-22 14:43:52');
INSERT INTO `admin_sys_logininfor` VALUES (924, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-22 14:44:52');
INSERT INTO `admin_sys_logininfor` VALUES (925, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-01-22 14:44:57');
INSERT INTO `admin_sys_logininfor` VALUES (926, 'admin', '113.68.17.64', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-22 16:56:30');
INSERT INTO `admin_sys_logininfor` VALUES (927, 'admin', '182.106.120.153', '江西 抚州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-22 19:53:11');
INSERT INTO `admin_sys_logininfor` VALUES (928, 'admin', '222.77.40.134', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-23 17:58:23');
INSERT INTO `admin_sys_logininfor` VALUES (929, 'admin', '222.77.40.134', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-23 18:47:36');
INSERT INTO `admin_sys_logininfor` VALUES (930, 'admin', '14.149.229.169', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-23 23:13:44');
INSERT INTO `admin_sys_logininfor` VALUES (931, 'admin', '14.149.229.169', '广东 茂名', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-23 23:13:49');
INSERT INTO `admin_sys_logininfor` VALUES (932, 'admin', '120.230.131.92', '广东 广州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-26 13:08:59');
INSERT INTO `admin_sys_logininfor` VALUES (933, 'admin', '223.20.195.8', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-26 20:41:39');
INSERT INTO `admin_sys_logininfor` VALUES (934, 'admin', '119.44.61.135', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-26 20:41:44');
INSERT INTO `admin_sys_logininfor` VALUES (935, 'admin', '223.20.195.8', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-01-26 20:47:33');
INSERT INTO `admin_sys_logininfor` VALUES (936, 'admin', '120.43.166.0', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-26 22:14:07');
INSERT INTO `admin_sys_logininfor` VALUES (937, 'admin', '61.140.242.7', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-27 20:39:27');
INSERT INTO `admin_sys_logininfor` VALUES (938, 'admin', '61.140.242.7', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-27 21:41:58');
INSERT INTO `admin_sys_logininfor` VALUES (939, 'admin', '106.61.94.113', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-27 21:49:45');
INSERT INTO `admin_sys_logininfor` VALUES (940, 'admin', '120.244.115.115', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-28 08:52:17');
INSERT INTO `admin_sys_logininfor` VALUES (941, 'admin', '183.253.75.1', '福建 莆田', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-28 08:54:25');
INSERT INTO `admin_sys_logininfor` VALUES (942, 'admin', '112.9.106.188', '山东 青岛', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-28 09:49:37');
INSERT INTO `admin_sys_logininfor` VALUES (943, 'admin', '103.3.139.193', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-28 09:53:57');
INSERT INTO `admin_sys_logininfor` VALUES (944, 'admin', '223.88.152.210', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-28 10:14:31');
INSERT INTO `admin_sys_logininfor` VALUES (945, 'admin', '120.37.46.253', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-28 10:19:11');
INSERT INTO `admin_sys_logininfor` VALUES (946, 'admin', '223.11.131.217', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-28 10:32:43');
INSERT INTO `admin_sys_logininfor` VALUES (947, 'admin', '114.96.12.217', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-28 11:58:46');
INSERT INTO `admin_sys_logininfor` VALUES (948, 'admin', '61.140.242.7', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-01-28 12:56:54');
INSERT INTO `admin_sys_logininfor` VALUES (949, 'admin', '61.140.242.7', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-28 12:56:59');
INSERT INTO `admin_sys_logininfor` VALUES (950, 'admin', '183.253.75.1', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-28 14:26:18');
INSERT INTO `admin_sys_logininfor` VALUES (951, 'admin', '112.10.197.98', '浙江 杭州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-28 15:11:07');
INSERT INTO `admin_sys_logininfor` VALUES (952, 'admin', '222.247.153.245', '湖南 长沙', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-28 17:51:51');
INSERT INTO `admin_sys_logininfor` VALUES (953, 'admin', '112.67.221.1', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-28 21:18:01');
INSERT INTO `admin_sys_logininfor` VALUES (954, 'admin', '111.196.246.139', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-28 22:43:24');
INSERT INTO `admin_sys_logininfor` VALUES (955, 'admin', '120.228.22.187', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-29 09:11:02');
INSERT INTO `admin_sys_logininfor` VALUES (956, 'admin', '112.45.99.168', '四川 成都', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-01-29 10:16:48');
INSERT INTO `admin_sys_logininfor` VALUES (957, 'admin', '163.125.166.186', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-29 10:45:52');
INSERT INTO `admin_sys_logininfor` VALUES (958, 'admin', '223.150.146.148', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-29 16:46:44');
INSERT INTO `admin_sys_logininfor` VALUES (959, 'admin', '218.68.107.215', '天津 天津', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-29 16:59:26');
INSERT INTO `admin_sys_logininfor` VALUES (960, 'admin', '120.88.130.167', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-30 14:53:50');
INSERT INTO `admin_sys_logininfor` VALUES (961, 'admin', '49.81.175.27', '江苏 徐州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-30 15:19:57');
INSERT INTO `admin_sys_logininfor` VALUES (962, 'admin', '117.155.49.203', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-01-30 15:51:26');
INSERT INTO `admin_sys_logininfor` VALUES (963, 'admin', '49.64.167.230', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-30 18:43:44');
INSERT INTO `admin_sys_logininfor` VALUES (964, 'admin', '115.60.55.253', '河南 郑州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-01-30 19:00:15');
INSERT INTO `admin_sys_logininfor` VALUES (965, 'admin', '123.12.221.194', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-30 19:01:11');
INSERT INTO `admin_sys_logininfor` VALUES (966, 'admin', '117.136.93.252', '山东 济南', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-01-31 12:04:26');
INSERT INTO `admin_sys_logininfor` VALUES (967, 'admin', '121.228.227.131', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-31 12:28:34');
INSERT INTO `admin_sys_logininfor` VALUES (968, 'admin', '117.153.20.139', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-31 14:03:26');
INSERT INTO `admin_sys_logininfor` VALUES (969, 'admin', '106.17.184.89', '湖南 常德', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-01-31 16:06:35');
INSERT INTO `admin_sys_logininfor` VALUES (970, 'admin', '120.43.166.0', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-01-31 17:25:36');
INSERT INTO `admin_sys_logininfor` VALUES (971, 'admin', '120.43.166.0', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-01 02:43:51');
INSERT INTO `admin_sys_logininfor` VALUES (972, 'admin', '120.43.166.0', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 02:43:56');
INSERT INTO `admin_sys_logininfor` VALUES (973, 'admin', '120.43.166.0', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 07:04:05');
INSERT INTO `admin_sys_logininfor` VALUES (974, 'admin', '120.88.130.167', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 10:52:39');
INSERT INTO `admin_sys_logininfor` VALUES (975, 'admin', '223.104.131.168', 'XX XX', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-02-01 11:21:42');
INSERT INTO `admin_sys_logininfor` VALUES (976, 'admin', '223.104.131.168', '湖南 长沙', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-01 11:21:48');
INSERT INTO `admin_sys_logininfor` VALUES (977, 'admin', '27.38.37.42', '广东 深圳', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-01 11:28:34');
INSERT INTO `admin_sys_logininfor` VALUES (978, 'admin', '223.89.144.30', '河南 驻马店', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-01 12:00:00');
INSERT INTO `admin_sys_logininfor` VALUES (979, 'admin', '223.89.144.30', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-01 12:00:05');
INSERT INTO `admin_sys_logininfor` VALUES (980, 'admin', '218.108.128.196', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 13:49:33');
INSERT INTO `admin_sys_logininfor` VALUES (981, 'admin', '103.228.209.169', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-01 16:44:50');
INSERT INTO `admin_sys_logininfor` VALUES (982, 'admin', '103.228.209.169', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-01 19:45:49');
INSERT INTO `admin_sys_logininfor` VALUES (983, 'admin', '114.254.91.253', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-01 20:28:26');
INSERT INTO `admin_sys_logininfor` VALUES (984, 'admin', '121.228.227.131', '江苏 苏州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-01 20:35:05');
INSERT INTO `admin_sys_logininfor` VALUES (985, 'admin', '121.228.227.131', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 20:35:09');
INSERT INTO `admin_sys_logininfor` VALUES (986, 'admin', '112.49.189.156', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 21:04:51');
INSERT INTO `admin_sys_logininfor` VALUES (987, 'admin', '121.228.227.131', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-01 23:23:59');
INSERT INTO `admin_sys_logininfor` VALUES (988, 'admin', '121.228.227.131', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-01 23:24:02');
INSERT INTO `admin_sys_logininfor` VALUES (989, 'admin', '121.228.227.131', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-01 23:24:11');
INSERT INTO `admin_sys_logininfor` VALUES (990, 'admin', '121.228.227.131', '江苏 苏州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-01 23:35:15');
INSERT INTO `admin_sys_logininfor` VALUES (991, 'admin', '121.228.227.131', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-01 23:35:19');
INSERT INTO `admin_sys_logininfor` VALUES (992, 'admin', '112.44.78.213', '四川 成都', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-02 08:55:05');
INSERT INTO `admin_sys_logininfor` VALUES (993, 'admin', '223.74.120.81', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-02 13:42:42');
INSERT INTO `admin_sys_logininfor` VALUES (994, 'admin', '220.174.85.118', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-02 16:14:13');
INSERT INTO `admin_sys_logininfor` VALUES (995, 'admin', '222.244.210.189', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-02 16:37:52');
INSERT INTO `admin_sys_logininfor` VALUES (996, 'admin', '218.68.102.233', '天津 天津', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-02 19:21:06');
INSERT INTO `admin_sys_logininfor` VALUES (997, 'admin', '223.104.147.241', '江苏 宿迁', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-02 21:07:17');
INSERT INTO `admin_sys_logininfor` VALUES (998, 'admin', '221.194.223.238', '河北 邢台', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-03 00:11:30');
INSERT INTO `admin_sys_logininfor` VALUES (999, 'admin', '222.125.53.83', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-03 10:32:30');
INSERT INTO `admin_sys_logininfor` VALUES (1000, 'admin', '119.137.54.174', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-03 10:34:37');
INSERT INTO `admin_sys_logininfor` VALUES (1001, 'admin', '171.113.155.132', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-03 10:53:38');
INSERT INTO `admin_sys_logininfor` VALUES (1002, 'admin', '183.220.62.128', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-03 13:15:49');
INSERT INTO `admin_sys_logininfor` VALUES (1003, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-03 18:19:00');
INSERT INTO `admin_sys_logininfor` VALUES (1004, 'admin', '113.92.154.162', '广东 深圳', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-02-03 18:42:10');
INSERT INTO `admin_sys_logininfor` VALUES (1005, 'admin', '113.92.154.162', '广东 深圳', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-03 18:42:13');
INSERT INTO `admin_sys_logininfor` VALUES (1006, 'admin', '125.210.245.53', '福建 福州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-03 19:10:00');
INSERT INTO `admin_sys_logininfor` VALUES (1007, 'admin', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-03 20:01:34');
INSERT INTO `admin_sys_logininfor` VALUES (1008, 'admin', '127.0.0.1', '内网IP', 'Apple WebKit', 'Mac OS X (iPad)', '1', '验证码错误', '2020-02-03 20:16:13');
INSERT INTO `admin_sys_logininfor` VALUES (1009, 'admin', '127.0.0.1', '内网IP', 'Apple WebKit', 'Mac OS X (iPad)', '0', '登录成功', '2020-02-03 20:16:19');
INSERT INTO `admin_sys_logininfor` VALUES (1010, 'admin', '49.72.90.162', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-03 23:28:02');
INSERT INTO `admin_sys_logininfor` VALUES (1011, 'admin', '36.161.72.62', '安徽 池州', 'Chrome Mobile', 'Android 6.x', '0', '登录成功', '2020-02-04 00:05:50');
INSERT INTO `admin_sys_logininfor` VALUES (1012, 'admin', '119.162.204.103', '山东 济南', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-04 11:39:55');
INSERT INTO `admin_sys_logininfor` VALUES (1013, 'admin', '119.162.204.103', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-04 11:42:04');
INSERT INTO `admin_sys_logininfor` VALUES (1014, 'admin', '117.172.92.97', '四川 南充', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-04 15:21:31');
INSERT INTO `admin_sys_logininfor` VALUES (1015, 'admin', '171.113.155.132', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-04 15:54:42');
INSERT INTO `admin_sys_logininfor` VALUES (1016, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-04 16:11:06');
INSERT INTO `admin_sys_logininfor` VALUES (1017, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-04 16:51:40');
INSERT INTO `admin_sys_logininfor` VALUES (1018, 'admin', '60.222.187.198', '山西 运城', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-04 17:58:30');
INSERT INTO `admin_sys_logininfor` VALUES (1019, 'admin', '125.210.245.53', '福建 福州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-04 19:26:50');
INSERT INTO `admin_sys_logininfor` VALUES (1020, 'admin', '125.210.245.53', '福建 福州', 'Chrome', 'Windows 7', '0', '退出成功', '2020-02-04 19:28:25');
INSERT INTO `admin_sys_logininfor` VALUES (1021, 'admin', '222.186.171.104', '江苏 镇江', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-04 20:18:10');
INSERT INTO `admin_sys_logininfor` VALUES (1022, 'admin', '222.186.171.104', '江苏 镇江', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-04 20:19:11');
INSERT INTO `admin_sys_logininfor` VALUES (1023, 'admin', '222.186.171.104', '江苏 镇江', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-04 20:19:17');
INSERT INTO `admin_sys_logininfor` VALUES (1024, 'admin', '110.83.160.148', '福建 宁德', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-04 22:50:51');
INSERT INTO `admin_sys_logininfor` VALUES (1025, 'admin', '110.83.160.148', '福建 宁德', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-04 22:50:57');
INSERT INTO `admin_sys_logininfor` VALUES (1026, 'admin', '222.77.92.99', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-04 22:52:45');
INSERT INTO `admin_sys_logininfor` VALUES (1027, 'admin', '39.79.73.38', '山东 东营', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-04 23:00:34');
INSERT INTO `admin_sys_logininfor` VALUES (1028, 'admin', '39.79.73.38', '山东 东营', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-05 00:24:56');
INSERT INTO `admin_sys_logininfor` VALUES (1029, 'admin', '39.79.73.38', '山东 东营', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 00:25:02');
INSERT INTO `admin_sys_logininfor` VALUES (1030, 'admin', '39.79.73.38', '山东 东营', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-05 00:34:44');
INSERT INTO `admin_sys_logininfor` VALUES (1031, 'admin', '49.78.108.231', '江苏 南京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-05 10:48:41');
INSERT INTO `admin_sys_logininfor` VALUES (1032, 'admin', '39.66.98.124', '山东 滨州', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-05 11:05:43');
INSERT INTO `admin_sys_logininfor` VALUES (1033, 'admin', '39.66.98.124', '山东 滨州', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-05 11:05:47');
INSERT INTO `admin_sys_logininfor` VALUES (1034, 'admin', '120.200.23.188', '辽宁 沈阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 11:41:32');
INSERT INTO `admin_sys_logininfor` VALUES (1035, 'admin', '223.104.111.123', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 12:01:25');
INSERT INTO `admin_sys_logininfor` VALUES (1036, 'admin', '124.193.98.2', '北京 北京', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 12:03:20');
INSERT INTO `admin_sys_logininfor` VALUES (1037, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 12:21:43');
INSERT INTO `admin_sys_logininfor` VALUES (1038, 'admin', '113.246.51.36', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-05 12:23:16');
INSERT INTO `admin_sys_logininfor` VALUES (1039, 'admin', '113.246.51.36', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-05 12:23:23');
INSERT INTO `admin_sys_logininfor` VALUES (1040, 'admin', '113.246.51.36', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 12:23:31');
INSERT INTO `admin_sys_logininfor` VALUES (1041, 'admin', '39.79.73.38', '山东 东营', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 13:51:57');
INSERT INTO `admin_sys_logininfor` VALUES (1042, 'admin', '116.238.208.54', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 13:57:02');
INSERT INTO `admin_sys_logininfor` VALUES (1043, 'admin', '211.161.244.84', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-05 13:59:53');
INSERT INTO `admin_sys_logininfor` VALUES (1044, 'admin', '115.148.244.61', '江西 南昌', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 14:30:26');
INSERT INTO `admin_sys_logininfor` VALUES (1045, 'admin', '42.92.140.111', '甘肃 兰州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 14:34:14');
INSERT INTO `admin_sys_logininfor` VALUES (1046, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-05 16:10:49');
INSERT INTO `admin_sys_logininfor` VALUES (1047, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 16:10:54');
INSERT INTO `admin_sys_logininfor` VALUES (1048, 'admin', '113.65.235.16', '广东 广州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 18:21:30');
INSERT INTO `admin_sys_logininfor` VALUES (1049, 'admin', '117.140.125.125', '广西 河池', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 19:56:04');
INSERT INTO `admin_sys_logininfor` VALUES (1050, 'admin', '121.32.168.200', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 20:19:59');
INSERT INTO `admin_sys_logininfor` VALUES (1051, 'admin', '112.38.167.5', '山东 莱芜', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-05 20:51:52');
INSERT INTO `admin_sys_logininfor` VALUES (1052, 'admin', '112.38.167.5', '山东 莱芜', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-05 20:51:57');
INSERT INTO `admin_sys_logininfor` VALUES (1053, 'admin', '112.38.167.5', '山东 莱芜', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 20:52:03');
INSERT INTO `admin_sys_logininfor` VALUES (1054, 'admin', '121.32.168.200', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 20:57:06');
INSERT INTO `admin_sys_logininfor` VALUES (1055, 'admin', '112.38.167.5', '山东 莱芜', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 21:03:44');
INSERT INTO `admin_sys_logininfor` VALUES (1056, 'admin', '39.79.73.38', '山东 东营', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 21:06:20');
INSERT INTO `admin_sys_logininfor` VALUES (1057, 'admin', '112.38.167.5', '山东 莱芜', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 21:10:51');
INSERT INTO `admin_sys_logininfor` VALUES (1058, 'admin', '112.38.167.5', '山东 莱芜', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-05 21:23:37');
INSERT INTO `admin_sys_logininfor` VALUES (1059, 'admin', '39.79.73.38', '山东 东营', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-05 21:25:45');
INSERT INTO `admin_sys_logininfor` VALUES (1060, 'admin', '223.73.201.252', '广东 广州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-05 21:31:00');
INSERT INTO `admin_sys_logininfor` VALUES (1061, 'admin', '121.32.168.200', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 21:54:56');
INSERT INTO `admin_sys_logininfor` VALUES (1062, 'admin', '223.72.89.215', '北京 北京', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-05 23:01:32');
INSERT INTO `admin_sys_logininfor` VALUES (1063, 'admin', '121.32.168.200', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-05 23:10:41');
INSERT INTO `admin_sys_logininfor` VALUES (1064, 'admin', '113.57.244.171', '湖北 武汉', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-06 02:27:02');
INSERT INTO `admin_sys_logininfor` VALUES (1065, 'admin', '113.57.244.171', '湖北 武汉', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-06 02:27:13');
INSERT INTO `admin_sys_logininfor` VALUES (1066, 'admin', '183.200.42.96', '山西 临汾', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-06 02:48:32');
INSERT INTO `admin_sys_logininfor` VALUES (1067, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-06 11:36:07');
INSERT INTO `admin_sys_logininfor` VALUES (1068, 'admin', '183.17.125.95', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 11:36:13');
INSERT INTO `admin_sys_logininfor` VALUES (1069, 'admin', '121.32.169.167', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 12:14:46');
INSERT INTO `admin_sys_logininfor` VALUES (1070, 'admin', '121.32.169.167', '广东 广州', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-06 12:14:57');
INSERT INTO `admin_sys_logininfor` VALUES (1071, 'admin', '121.32.169.167', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 12:17:07');
INSERT INTO `admin_sys_logininfor` VALUES (1072, 'admin', '113.246.92.38', '湖南 长沙', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-06 13:38:26');
INSERT INTO `admin_sys_logininfor` VALUES (1073, 'admin', '218.79.116.125', '上海 上海', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-06 13:46:58');
INSERT INTO `admin_sys_logininfor` VALUES (1074, 'admin', '218.79.116.125', '上海 上海', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-06 13:47:04');
INSERT INTO `admin_sys_logininfor` VALUES (1075, 'admin', '117.37.63.30', '陕西 咸阳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-06 14:51:38');
INSERT INTO `admin_sys_logininfor` VALUES (1076, 'admin', '117.37.63.30', '陕西 咸阳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-06 14:51:59');
INSERT INTO `admin_sys_logininfor` VALUES (1077, 'admin', '117.37.63.30', '陕西 咸阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 14:52:08');
INSERT INTO `admin_sys_logininfor` VALUES (1078, 'admin', '101.38.206.38', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 15:00:24');
INSERT INTO `admin_sys_logininfor` VALUES (1079, 'admin', '183.17.127.174', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 15:29:47');
INSERT INTO `admin_sys_logininfor` VALUES (1080, 'admin', '113.78.252.6', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 16:19:49');
INSERT INTO `admin_sys_logininfor` VALUES (1081, 'admin', '112.20.96.71', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 16:22:11');
INSERT INTO `admin_sys_logininfor` VALUES (1082, 'admin', '112.94.74.96', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 16:28:52');
INSERT INTO `admin_sys_logininfor` VALUES (1083, 'admin', '123.114.124.43', '北京 北京', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-06 16:31:41');
INSERT INTO `admin_sys_logininfor` VALUES (1084, 'admin', '123.114.124.43', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-06 16:31:49');
INSERT INTO `admin_sys_logininfor` VALUES (1085, 'admin', '27.44.5.252', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-06 16:33:11');
INSERT INTO `admin_sys_logininfor` VALUES (1086, 'admin', '39.177.146.230', '江西 赣州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-06 17:17:35');
INSERT INTO `admin_sys_logininfor` VALUES (1087, 'admin', '27.27.184.88', '湖北 襄阳', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-06 17:39:49');
INSERT INTO `admin_sys_logininfor` VALUES (1088, 'admin', '112.94.74.96', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-06 18:50:24');
INSERT INTO `admin_sys_logininfor` VALUES (1089, 'admin', '36.189.230.153', '新疆 克拉玛依', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-06 19:53:03');
INSERT INTO `admin_sys_logininfor` VALUES (1090, 'admin', '36.189.230.153', '新疆 克拉玛依', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-06 19:53:08');
INSERT INTO `admin_sys_logininfor` VALUES (1091, 'admin', '36.189.230.153', '新疆 克拉玛依', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-06 19:53:15');
INSERT INTO `admin_sys_logininfor` VALUES (1092, 'admin', '27.155.26.7', '福建 漳州', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-06 21:44:15');
INSERT INTO `admin_sys_logininfor` VALUES (1093, 'admin', '27.155.26.7', '福建 漳州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-06 21:44:18');
INSERT INTO `admin_sys_logininfor` VALUES (1094, 'admin', '183.197.46.192', '河北 石家庄', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-06 21:45:27');
INSERT INTO `admin_sys_logininfor` VALUES (1095, 'admin', '112.44.164.104', '四川 德阳', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-06 23:28:23');
INSERT INTO `admin_sys_logininfor` VALUES (1096, 'admin', '220.202.233.196', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-07 01:37:08');
INSERT INTO `admin_sys_logininfor` VALUES (1097, 'admin', '220.202.233.196', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 01:37:15');
INSERT INTO `admin_sys_logininfor` VALUES (1098, 'admin', '220.202.233.196', '湖南 长沙', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-07 01:51:35');
INSERT INTO `admin_sys_logininfor` VALUES (1099, 'admin', '220.202.233.196', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 01:54:41');
INSERT INTO `admin_sys_logininfor` VALUES (1100, 'admin', '220.202.233.196', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 02:47:39');
INSERT INTO `admin_sys_logininfor` VALUES (1101, 'admin', '223.90.34.124', '河南 焦作', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-07 05:43:49');
INSERT INTO `admin_sys_logininfor` VALUES (1102, 'admin', '106.114.236.61', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 10:17:26');
INSERT INTO `admin_sys_logininfor` VALUES (1103, 'admin', '183.209.61.27', '江苏 南京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-07 12:53:32');
INSERT INTO `admin_sys_logininfor` VALUES (1104, 'admin', '117.143.49.113', '上海 上海', 'Safari', 'Mac OS X', '0', '登录成功', '2020-02-07 16:55:26');
INSERT INTO `admin_sys_logininfor` VALUES (1105, 'admin', '223.88.44.90', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 17:56:55');
INSERT INTO `admin_sys_logininfor` VALUES (1106, 'admin', '117.37.98.195', '陕西 咸阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 18:00:47');
INSERT INTO `admin_sys_logininfor` VALUES (1107, 'admin', '220.114.110.226', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 18:06:24');
INSERT INTO `admin_sys_logininfor` VALUES (1108, 'admin', '222.212.28.234', '四川 成都', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-07 18:11:26');
INSERT INTO `admin_sys_logininfor` VALUES (1109, 'admin', '49.94.36.165', '江苏 南京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-07 18:43:43');
INSERT INTO `admin_sys_logininfor` VALUES (1110, 'admin', '120.229.40.228', '广东 深圳', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-07 18:52:58');
INSERT INTO `admin_sys_logininfor` VALUES (1111, 'admin', '180.110.106.6', '江苏 南京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-07 18:53:30');
INSERT INTO `admin_sys_logininfor` VALUES (1112, 'admin', '115.48.89.128', '河南 漯河', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-07 19:17:38');
INSERT INTO `admin_sys_logininfor` VALUES (1113, 'admin', '115.48.89.128', '河南 漯河', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-07 19:17:43');
INSERT INTO `admin_sys_logininfor` VALUES (1114, 'admin', '115.48.89.128', '河南 漯河', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 19:17:50');
INSERT INTO `admin_sys_logininfor` VALUES (1115, 'admin', '120.208.21.244', '山西 运城', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-07 19:56:35');
INSERT INTO `admin_sys_logininfor` VALUES (1116, 'admin', '120.208.21.244', '山西 运城', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-07 20:14:24');
INSERT INTO `admin_sys_logininfor` VALUES (1117, 'admin', '42.49.96.157', '湖南 湘潭', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-07 21:30:28');
INSERT INTO `admin_sys_logininfor` VALUES (1118, 'admin', '120.242.230.77', '安徽 安庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 21:50:34');
INSERT INTO `admin_sys_logininfor` VALUES (1119, 'admin', '175.1.8.133', '湖南 湘潭', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 21:51:27');
INSERT INTO `admin_sys_logininfor` VALUES (1120, 'admin', '183.195.67.111', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 22:28:10');
INSERT INTO `admin_sys_logininfor` VALUES (1121, 'admin', '183.195.67.111', '上海 上海', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-07 22:44:56');
INSERT INTO `admin_sys_logininfor` VALUES (1122, 'admin', '183.195.67.111', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 22:45:07');
INSERT INTO `admin_sys_logininfor` VALUES (1123, 'admin', '111.201.228.17', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 22:59:12');
INSERT INTO `admin_sys_logininfor` VALUES (1124, 'admin', '183.195.67.111', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-07 23:26:25');
INSERT INTO `admin_sys_logininfor` VALUES (1125, 'admin', '183.95.250.48', '湖北 武汉', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-07 23:52:22');
INSERT INTO `admin_sys_logininfor` VALUES (1126, 'admin', '112.94.188.18', '广东 广州', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-08 00:33:57');
INSERT INTO `admin_sys_logininfor` VALUES (1127, 'admin', '121.206.87.178', '福建 龙岩', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-08 00:35:26');
INSERT INTO `admin_sys_logininfor` VALUES (1128, 'admin', '223.89.228.155', '河南 商丘', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-08 00:37:44');
INSERT INTO `admin_sys_logininfor` VALUES (1129, 'admin', '223.104.56.93', '甘肃 兰州', 'Mobile Safari', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-08 01:00:21');
INSERT INTO `admin_sys_logininfor` VALUES (1130, 'admin', '223.104.56.93', '甘肃 兰州', 'Mobile Safari', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-08 01:00:22');
INSERT INTO `admin_sys_logininfor` VALUES (1131, 'admin', '223.104.56.93', '甘肃 兰州', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-08 01:00:27');
INSERT INTO `admin_sys_logininfor` VALUES (1132, 'admin', '117.136.86.240', '陕西 西安', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-08 01:09:04');
INSERT INTO `admin_sys_logininfor` VALUES (1133, 'admin', '59.51.224.69', '贵州 铜仁', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-08 03:37:23');
INSERT INTO `admin_sys_logininfor` VALUES (1134, 'admin', '106.45.9.69', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-08 05:43:06');
INSERT INTO `admin_sys_logininfor` VALUES (1135, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-08 08:50:30');
INSERT INTO `admin_sys_logininfor` VALUES (1136, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 08:51:31');
INSERT INTO `admin_sys_logininfor` VALUES (1137, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-08 08:52:05');
INSERT INTO `admin_sys_logininfor` VALUES (1138, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 08:52:10');
INSERT INTO `admin_sys_logininfor` VALUES (1139, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-08 08:53:47');
INSERT INTO `admin_sys_logininfor` VALUES (1140, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 08:54:06');
INSERT INTO `admin_sys_logininfor` VALUES (1141, 'admin', '117.136.74.145', '湖北 武汉', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-08 08:54:10');
INSERT INTO `admin_sys_logininfor` VALUES (1142, 'admin', '113.81.229.26', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-08 09:32:01');
INSERT INTO `admin_sys_logininfor` VALUES (1143, 'admin', '113.81.229.26', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-08 09:32:12');
INSERT INTO `admin_sys_logininfor` VALUES (1144, 'admin', '113.81.229.26', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-08 09:32:18');
INSERT INTO `admin_sys_logininfor` VALUES (1145, 'admin', '113.81.229.26', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-08 09:32:27');
INSERT INTO `admin_sys_logininfor` VALUES (1146, 'admin', '223.104.37.187', '安徽 XX', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-02-08 10:28:16');
INSERT INTO `admin_sys_logininfor` VALUES (1147, 'admin', '223.104.37.187', '安徽 XX', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-02-08 10:28:20');
INSERT INTO `admin_sys_logininfor` VALUES (1148, 'admin', '223.104.37.187', '安徽 XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-08 10:28:30');
INSERT INTO `admin_sys_logininfor` VALUES (1149, 'admin', '116.25.41.48', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-08 10:44:43');
INSERT INTO `admin_sys_logininfor` VALUES (1150, 'admin', '59.109.116.246', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 10:55:25');
INSERT INTO `admin_sys_logininfor` VALUES (1151, 'admin', '112.67.204.35', '海南 海口', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 11:29:25');
INSERT INTO `admin_sys_logininfor` VALUES (1152, 'admin', '39.149.149.113', '河南 许昌', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 11:54:09');
INSERT INTO `admin_sys_logininfor` VALUES (1153, 'admin', '36.34.4.90', '安徽 合肥', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 13:28:49');
INSERT INTO `admin_sys_logininfor` VALUES (1154, 'admin', '112.10.110.100', '浙江 杭州', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-08 13:50:56');
INSERT INTO `admin_sys_logininfor` VALUES (1155, 'admin', '223.12.216.242', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 15:54:12');
INSERT INTO `admin_sys_logininfor` VALUES (1156, 'admin', '119.39.18.221', '湖南 长沙', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-08 16:13:38');
INSERT INTO `admin_sys_logininfor` VALUES (1157, 'admin', '223.12.216.242', '山西 太原', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 16:53:14');
INSERT INTO `admin_sys_logininfor` VALUES (1158, 'admin', '36.157.19.6', '湖南 郴州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 18:19:10');
INSERT INTO `admin_sys_logininfor` VALUES (1159, 'admin', '122.238.64.121', '浙江 嘉兴', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-08 19:02:41');
INSERT INTO `admin_sys_logininfor` VALUES (1160, 'admin', '43.227.139.144', '湖北 武汉', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-08 19:10:05');
INSERT INTO `admin_sys_logininfor` VALUES (1161, 'admin', '43.227.139.144', '湖北 武汉', 'Chrome 39', 'Windows 7', '0', '登录成功', '2020-02-08 19:10:57');
INSERT INTO `admin_sys_logininfor` VALUES (1162, 'admin', '43.227.139.144', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 19:11:33');
INSERT INTO `admin_sys_logininfor` VALUES (1163, 'admin', '101.93.114.193', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-08 19:51:01');
INSERT INTO `admin_sys_logininfor` VALUES (1164, 'admin', '112.32.128.206', '安徽 XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-08 19:55:05');
INSERT INTO `admin_sys_logininfor` VALUES (1165, 'admin', '112.32.128.206', '安徽 XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-08 19:55:13');
INSERT INTO `admin_sys_logininfor` VALUES (1166, 'admin', '183.92.65.90', '湖北 十堰', 'Chrome Mobile', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-08 20:50:51');
INSERT INTO `admin_sys_logininfor` VALUES (1167, 'admin', '183.92.65.90', '湖北 十堰', 'Chrome Mobile', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-08 20:51:29');
INSERT INTO `admin_sys_logininfor` VALUES (1168, 'admin', '183.92.65.90', '湖北 十堰', 'Chrome Mobile', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-08 20:51:35');
INSERT INTO `admin_sys_logininfor` VALUES (1169, 'admin', '39.149.61.250', '河南 新乡', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-08 22:52:48');
INSERT INTO `admin_sys_logininfor` VALUES (1170, 'admin', '183.212.186.247', '江苏 南京', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-09 00:22:58');
INSERT INTO `admin_sys_logininfor` VALUES (1171, 'admin', '117.150.237.119', '湖北 荆门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 10:50:55');
INSERT INTO `admin_sys_logininfor` VALUES (1172, 'admin', '223.88.59.181', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 11:22:06');
INSERT INTO `admin_sys_logininfor` VALUES (1173, 'admin', '61.140.255.200', '广东 广州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-09 11:58:40');
INSERT INTO `admin_sys_logininfor` VALUES (1174, 'admin', '117.153.27.40', '湖北 襄阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 14:09:18');
INSERT INTO `admin_sys_logininfor` VALUES (1175, 'admin', '175.188.252.208', '江苏 南京', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-09 15:46:50');
INSERT INTO `admin_sys_logininfor` VALUES (1176, 'admin', '222.247.6.136', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 17:40:22');
INSERT INTO `admin_sys_logininfor` VALUES (1177, 'admin', '222.247.6.136', '湖南 长沙', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-09 17:41:41');
INSERT INTO `admin_sys_logininfor` VALUES (1178, 'admin', '117.136.88.64', '湖南 长沙', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-09 18:01:54');
INSERT INTO `admin_sys_logininfor` VALUES (1179, 'admin', '117.136.88.64', '湖南 长沙', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-09 18:02:00');
INSERT INTO `admin_sys_logininfor` VALUES (1180, 'admin', '36.157.23.125', '湖南 郴州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 20:07:33');
INSERT INTO `admin_sys_logininfor` VALUES (1181, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-09 22:40:38');
INSERT INTO `admin_sys_logininfor` VALUES (1182, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 22:40:48');
INSERT INTO `admin_sys_logininfor` VALUES (1183, 'admin', '117.188.17.3', '贵州 贵阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-09 22:49:22');
INSERT INTO `admin_sys_logininfor` VALUES (1184, 'admin', '117.69.166.116', '安徽 黄山', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-10 00:55:54');
INSERT INTO `admin_sys_logininfor` VALUES (1185, 'admin', '119.166.171.211', '山东 青岛', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-10 09:26:49');
INSERT INTO `admin_sys_logininfor` VALUES (1186, 'admin', '112.48.12.216', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-10 10:11:44');
INSERT INTO `admin_sys_logininfor` VALUES (1187, 'admin', '43.243.12.102', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-10 11:47:48');
INSERT INTO `admin_sys_logininfor` VALUES (1188, 'admin', '43.243.12.102', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-10 12:30:24');
INSERT INTO `admin_sys_logininfor` VALUES (1189, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-10 14:47:56');
INSERT INTO `admin_sys_logininfor` VALUES (1190, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-10 14:48:07');
INSERT INTO `admin_sys_logininfor` VALUES (1191, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-10 14:48:15');
INSERT INTO `admin_sys_logininfor` VALUES (1192, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-10 14:48:26');
INSERT INTO `admin_sys_logininfor` VALUES (1193, 'admin', '122.241.134.155', '浙江 丽水', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-10 15:24:10');
INSERT INTO `admin_sys_logininfor` VALUES (1194, 'admin', '1.89.211.232', '北京 北京', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-10 15:28:47');
INSERT INTO `admin_sys_logininfor` VALUES (1195, 'admin', '223.192.194.220', '广东 广州', 'Chrome 39', 'Windows 7', '0', '登录成功', '2020-02-10 15:38:42');
INSERT INTO `admin_sys_logininfor` VALUES (1196, 'admin', '171.41.72.175', '湖北 黄冈', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-10 15:40:01');
INSERT INTO `admin_sys_logininfor` VALUES (1197, 'admin', '112.11.44.104', '浙江 嘉兴', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-10 16:54:52');
INSERT INTO `admin_sys_logininfor` VALUES (1198, 'admin', '36.104.196.174', '吉林 长春', 'Firefox 7', 'Mac OS X', '1', '验证码错误', '2020-02-10 16:56:45');
INSERT INTO `admin_sys_logininfor` VALUES (1199, 'admin', '36.104.196.174', '吉林 长春', 'Firefox 7', 'Mac OS X', '0', '登录成功', '2020-02-10 16:57:03');
INSERT INTO `admin_sys_logininfor` VALUES (1200, 'admin', '1.61.70.230', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-10 16:59:17');
INSERT INTO `admin_sys_logininfor` VALUES (1201, 'admin', '222.209.7.131', '四川 成都', 'Firefox 7', 'Linux', '0', '登录成功', '2020-02-10 17:19:53');
INSERT INTO `admin_sys_logininfor` VALUES (1202, 'admin', '43.243.12.102', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-10 17:27:14');
INSERT INTO `admin_sys_logininfor` VALUES (1203, 'admin', '175.11.29.247', '湖南 长沙', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-10 17:45:25');
INSERT INTO `admin_sys_logininfor` VALUES (1204, 'admin', '222.209.7.131', '四川 成都', 'Firefox 7', 'Linux', '0', '退出成功', '2020-02-10 17:47:23');
INSERT INTO `admin_sys_logininfor` VALUES (1205, 'admin', '222.209.7.131', '四川 成都', 'Firefox 7', 'Linux', '0', '登录成功', '2020-02-10 17:47:41');
INSERT INTO `admin_sys_logininfor` VALUES (1206, 'admin', '222.209.7.131', '四川 成都', 'Firefox 7', 'Linux', '0', '登录成功', '2020-02-10 17:51:39');
INSERT INTO `admin_sys_logininfor` VALUES (1207, 'admin', '110.183.120.125', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-10 19:03:30');
INSERT INTO `admin_sys_logininfor` VALUES (1208, 'admin', '222.244.203.13', '湖南 长沙', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-10 19:22:21');
INSERT INTO `admin_sys_logininfor` VALUES (1209, 'admin', '222.244.203.13', '湖南 长沙', 'Microsoft Edge', 'Windows 10', '0', '退出成功', '2020-02-10 19:23:58');
INSERT INTO `admin_sys_logininfor` VALUES (1210, 'admin', '61.148.245.91', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-10 19:26:37');
INSERT INTO `admin_sys_logininfor` VALUES (1211, 'admin', '222.244.203.13', '湖南 长沙', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-10 19:31:37');
INSERT INTO `admin_sys_logininfor` VALUES (1212, 'admin', '222.244.203.13', '湖南 长沙', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-10 20:17:34');
INSERT INTO `admin_sys_logininfor` VALUES (1213, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-10 20:24:45');
INSERT INTO `admin_sys_logininfor` VALUES (1214, 'admin', '113.201.137.239', '陕西 西安', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-10 20:46:50');
INSERT INTO `admin_sys_logininfor` VALUES (1215, 'admin', '113.201.137.239', '陕西 西安', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-10 20:46:58');
INSERT INTO `admin_sys_logininfor` VALUES (1216, 'admin', '117.39.204.219', '陕西 西安', 'Chrome 39', 'Windows 7', '0', '登录成功', '2020-02-10 22:52:26');
INSERT INTO `admin_sys_logininfor` VALUES (1217, 'admin', '113.134.136.84', '陕西 渭南', 'Chrome 49', 'Windows 7', '0', '登录成功', '2020-02-10 23:30:38');
INSERT INTO `admin_sys_logininfor` VALUES (1218, 'admin', '123.158.16.243', '浙江 台州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 08:56:15');
INSERT INTO `admin_sys_logininfor` VALUES (1219, 'admin', '113.246.189.142', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 09:50:32');
INSERT INTO `admin_sys_logininfor` VALUES (1220, 'admin', '183.191.11.29', '山西 太原', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-11 10:48:50');
INSERT INTO `admin_sys_logininfor` VALUES (1221, 'admin', '183.191.11.29', '山西 太原', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-11 10:49:01');
INSERT INTO `admin_sys_logininfor` VALUES (1222, 'admin', '183.191.11.29', '山西 太原', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-11 10:49:08');
INSERT INTO `admin_sys_logininfor` VALUES (1223, 'admin', '223.68.210.130', '江苏 宿迁', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 10:52:02');
INSERT INTO `admin_sys_logininfor` VALUES (1224, 'admin', '180.109.178.182', '江苏 南京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-11 11:23:58');
INSERT INTO `admin_sys_logininfor` VALUES (1225, 'admin', '180.142.222.202', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-11 11:27:14');
INSERT INTO `admin_sys_logininfor` VALUES (1226, 'admin', '14.123.253.114', '广东 珠海', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-11 11:34:16');
INSERT INTO `admin_sys_logininfor` VALUES (1227, 'admin', '183.191.11.29', '山西 太原', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-11 11:51:27');
INSERT INTO `admin_sys_logininfor` VALUES (1228, 'admin', '180.111.40.255', '江苏 南京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-11 11:53:00');
INSERT INTO `admin_sys_logininfor` VALUES (1229, 'admin', '113.222.178.19', '湖南 株洲', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 12:30:27');
INSERT INTO `admin_sys_logininfor` VALUES (1230, 'admin', '111.50.69.13', '宁夏 银川', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-11 12:36:57');
INSERT INTO `admin_sys_logininfor` VALUES (1231, 'admin', '113.66.33.75', '广东 广州', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-11 13:41:49');
INSERT INTO `admin_sys_logininfor` VALUES (1232, 'admin', '123.118.75.169', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 13:42:32');
INSERT INTO `admin_sys_logininfor` VALUES (1233, 'admin', '101.16.4.254', '河北 邢台', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-11 14:04:41');
INSERT INTO `admin_sys_logininfor` VALUES (1234, 'admin', '117.155.229.30', '湖北 黄石', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-11 14:06:25');
INSERT INTO `admin_sys_logininfor` VALUES (1235, 'admin', '171.41.72.175', '湖北 黄冈', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-11 16:40:44');
INSERT INTO `admin_sys_logininfor` VALUES (1236, 'admin', '171.41.72.175', '湖北 黄冈', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-11 16:40:45');
INSERT INTO `admin_sys_logininfor` VALUES (1237, 'admin', '171.41.72.175', '湖北 黄冈', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-11 16:40:53');
INSERT INTO `admin_sys_logininfor` VALUES (1238, 'admin', '171.41.72.175', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 16:40:59');
INSERT INTO `admin_sys_logininfor` VALUES (1239, 'admin', '223.74.68.164', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 17:11:27');
INSERT INTO `admin_sys_logininfor` VALUES (1240, 'admin', '110.152.44.57', '新疆 乌鲁木齐', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-11 17:13:23');
INSERT INTO `admin_sys_logininfor` VALUES (1241, 'admin', '218.26.55.116', '山西 太原', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-11 17:36:42');
INSERT INTO `admin_sys_logininfor` VALUES (1242, 'admin', '223.74.68.164', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 18:53:42');
INSERT INTO `admin_sys_logininfor` VALUES (1243, 'admin', '111.60.235.188', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-11 19:08:20');
INSERT INTO `admin_sys_logininfor` VALUES (1244, 'admin', '111.60.235.188', '湖北 荆州', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-11 19:08:26');
INSERT INTO `admin_sys_logininfor` VALUES (1245, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-11 19:22:29');
INSERT INTO `admin_sys_logininfor` VALUES (1246, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误2次', '2020-02-11 19:22:51');
INSERT INTO `admin_sys_logininfor` VALUES (1247, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-11 19:23:30');
INSERT INTO `admin_sys_logininfor` VALUES (1248, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-11 19:23:38');
INSERT INTO `admin_sys_logininfor` VALUES (1249, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-11 19:25:06');
INSERT INTO `admin_sys_logininfor` VALUES (1250, 'admin', '183.54.41.147', '广东 深圳', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误2次', '2020-02-11 19:25:30');
INSERT INTO `admin_sys_logininfor` VALUES (1251, 'admin', '183.54.41.147', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 19:28:14');
INSERT INTO `admin_sys_logininfor` VALUES (1252, 'admin', '183.54.41.147', '广东 深圳', 'Microsoft Edge', 'Windows 10', '1', '验证码错误', '2020-02-11 19:41:48');
INSERT INTO `admin_sys_logininfor` VALUES (1253, 'admin', '183.54.41.147', '广东 深圳', 'Microsoft Edge', 'Windows 10', '1', '验证码错误', '2020-02-11 19:41:56');
INSERT INTO `admin_sys_logininfor` VALUES (1254, 'admin', '183.54.41.147', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-11 19:42:05');
INSERT INTO `admin_sys_logininfor` VALUES (1255, 'admin', '183.54.41.147', '广东 深圳', 'Microsoft Edge', 'Windows 10', '1', '密码输入错误1次', '2020-02-11 19:58:05');
INSERT INTO `admin_sys_logininfor` VALUES (1256, 'admin', '183.54.41.147', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-11 19:58:15');
INSERT INTO `admin_sys_logininfor` VALUES (1257, 'admin', '183.54.41.147', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-11 20:00:20');
INSERT INTO `admin_sys_logininfor` VALUES (1258, 'admin', '223.74.68.164', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 20:29:10');
INSERT INTO `admin_sys_logininfor` VALUES (1259, 'admin', '117.88.233.246', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 22:48:46');
INSERT INTO `admin_sys_logininfor` VALUES (1260, 'admin', '117.88.233.246', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-11 22:49:33');
INSERT INTO `admin_sys_logininfor` VALUES (1261, 'admin', '117.135.126.8', '上海 上海', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-11 23:13:04');
INSERT INTO `admin_sys_logininfor` VALUES (1262, 'admin', '117.135.126.8', '上海 上海', 'Chrome', 'Ubuntu', '0', '登录成功', '2020-02-11 23:13:54');
INSERT INTO `admin_sys_logininfor` VALUES (1263, 'admin', '125.210.251.44', '福建 福州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-12 00:40:09');
INSERT INTO `admin_sys_logininfor` VALUES (1264, 'admin', '113.118.225.66', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 03:09:38');
INSERT INTO `admin_sys_logininfor` VALUES (1265, 'admin', '114.234.155.137', '江苏 徐州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-12 04:43:59');
INSERT INTO `admin_sys_logininfor` VALUES (1266, 'admin', '113.118.225.66', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-12 05:59:45');
INSERT INTO `admin_sys_logininfor` VALUES (1267, 'admin', '113.118.225.66', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-12 05:59:51');
INSERT INTO `admin_sys_logininfor` VALUES (1268, 'admin', '113.118.225.66', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 05:59:57');
INSERT INTO `admin_sys_logininfor` VALUES (1269, 'admin', '112.20.41.216', '江苏 扬州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-12 10:29:25');
INSERT INTO `admin_sys_logininfor` VALUES (1270, 'admin', '117.100.125.78', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 12:26:37');
INSERT INTO `admin_sys_logininfor` VALUES (1271, 'admin', '117.136.47.198', '河北 廊坊', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 13:09:51');
INSERT INTO `admin_sys_logininfor` VALUES (1272, 'admin', '121.62.239.122', '湖北 黄冈', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-02-12 13:20:39');
INSERT INTO `admin_sys_logininfor` VALUES (1273, 'admin', '121.62.239.122', '湖北 黄冈', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-12 13:20:43');
INSERT INTO `admin_sys_logininfor` VALUES (1274, 'admin', '125.82.12.130', 'XX XX', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-12 13:53:05');
INSERT INTO `admin_sys_logininfor` VALUES (1275, 'admin', '183.151.111.183', '浙江 丽水', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 14:24:49');
INSERT INTO `admin_sys_logininfor` VALUES (1276, 'admin', '183.54.41.145', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-12 14:29:15');
INSERT INTO `admin_sys_logininfor` VALUES (1277, 'admin', '183.54.41.145', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-12 15:02:52');
INSERT INTO `admin_sys_logininfor` VALUES (1278, 'admin', '121.228.227.131', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 15:03:06');
INSERT INTO `admin_sys_logininfor` VALUES (1279, 'admin', '223.91.2.48', '河南 周口', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-12 15:56:18');
INSERT INTO `admin_sys_logininfor` VALUES (1280, 'admin', '202.105.68.122', '广东 广州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-12 15:56:29');
INSERT INTO `admin_sys_logininfor` VALUES (1281, 'admin', '223.91.2.48', '河南 周口', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 16:05:43');
INSERT INTO `admin_sys_logininfor` VALUES (1282, 'admin', '183.221.109.131', '四川 成都', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-12 16:17:12');
INSERT INTO `admin_sys_logininfor` VALUES (1283, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-12 16:23:51');
INSERT INTO `admin_sys_logininfor` VALUES (1284, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-12 16:24:23');
INSERT INTO `admin_sys_logininfor` VALUES (1285, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 16:24:28');
INSERT INTO `admin_sys_logininfor` VALUES (1286, 'admin', '117.100.125.78', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-12 16:26:33');
INSERT INTO `admin_sys_logininfor` VALUES (1287, 'admin', '117.188.44.136', '贵州 遵义', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-02-12 16:34:31');
INSERT INTO `admin_sys_logininfor` VALUES (1288, 'admin', '117.188.44.136', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '退出成功', '2020-02-12 16:48:26');
INSERT INTO `admin_sys_logininfor` VALUES (1289, 'admin', '223.104.56.19', '甘肃 兰州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-12 17:32:19');
INSERT INTO `admin_sys_logininfor` VALUES (1290, 'admin', '223.91.2.48', '河南 周口', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 19:38:41');
INSERT INTO `admin_sys_logininfor` VALUES (1291, 'admin', '113.128.103.202', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 21:01:34');
INSERT INTO `admin_sys_logininfor` VALUES (1292, 'admin', '120.230.104.188', '广东 广州', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-12 21:22:24');
INSERT INTO `admin_sys_logininfor` VALUES (1293, 'admin', '116.22.209.14', '广东 广州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-12 21:23:18');
INSERT INTO `admin_sys_logininfor` VALUES (1294, 'admin', '219.232.77.15', '广西 南宁', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-12 21:32:45');
INSERT INTO `admin_sys_logininfor` VALUES (1295, 'admin', '117.136.47.198', '河北 廊坊', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 21:39:07');
INSERT INTO `admin_sys_logininfor` VALUES (1296, 'admin', '117.136.47.198', '河北 廊坊', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-12 21:40:40');
INSERT INTO `admin_sys_logininfor` VALUES (1297, 'admin', '14.103.2.167', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 22:14:12');
INSERT INTO `admin_sys_logininfor` VALUES (1298, 'admin', '112.20.97.136', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 22:23:38');
INSERT INTO `admin_sys_logininfor` VALUES (1299, 'admin', '117.170.233.110', '江西 宜春', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-12 22:26:41');
INSERT INTO `admin_sys_logininfor` VALUES (1300, 'admin', '112.20.97.136', '江苏 苏州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-12 23:02:21');
INSERT INTO `admin_sys_logininfor` VALUES (1301, 'admin', '112.20.97.136', '江苏 苏州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-12 23:02:27');
INSERT INTO `admin_sys_logininfor` VALUES (1302, 'admin', '114.216.69.132', '江苏 苏州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-12 23:20:38');
INSERT INTO `admin_sys_logininfor` VALUES (1303, 'admin', '223.72.98.126', 'XX XX', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-13 00:20:47');
INSERT INTO `admin_sys_logininfor` VALUES (1304, 'admin', '223.72.98.126', '北京 北京', 'Microsoft Edge', 'Windows 10', '0', '退出成功', '2020-02-13 00:25:38');
INSERT INTO `admin_sys_logininfor` VALUES (1305, 'admin', '223.72.98.126', '北京 北京', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-13 00:25:45');
INSERT INTO `admin_sys_logininfor` VALUES (1306, 'admin', '223.72.98.126', '北京 北京', 'Microsoft Edge', 'Windows 10', '0', '退出成功', '2020-02-13 00:26:30');
INSERT INTO `admin_sys_logininfor` VALUES (1307, 'admin', '203.208.61.203', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-13 02:04:44');
INSERT INTO `admin_sys_logininfor` VALUES (1308, 'admin', '203.208.61.203', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-13 02:04:50');
INSERT INTO `admin_sys_logininfor` VALUES (1309, 'admin', '113.118.225.66', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 05:28:39');
INSERT INTO `admin_sys_logininfor` VALUES (1310, 'admin', '125.81.180.25', '重庆 重庆', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-13 09:36:53');
INSERT INTO `admin_sys_logininfor` VALUES (1311, 'admin', '125.81.180.25', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 09:36:59');
INSERT INTO `admin_sys_logininfor` VALUES (1312, 'admin', '124.236.150.195', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 09:37:28');
INSERT INTO `admin_sys_logininfor` VALUES (1313, 'admin', '124.236.150.195', '河北 石家庄', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-13 09:42:20');
INSERT INTO `admin_sys_logininfor` VALUES (1314, 'admin', '124.236.150.195', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 09:42:27');
INSERT INTO `admin_sys_logininfor` VALUES (1315, 'admin', '117.136.109.205', '江西 XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-13 10:05:38');
INSERT INTO `admin_sys_logininfor` VALUES (1316, 'admin', '117.136.109.205', '江西 XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 10:05:44');
INSERT INTO `admin_sys_logininfor` VALUES (1317, 'admin', '183.151.111.183', '浙江 丽水', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 10:12:02');
INSERT INTO `admin_sys_logininfor` VALUES (1318, 'admin', '116.5.10.64', '广东 佛山', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-13 10:12:10');
INSERT INTO `admin_sys_logininfor` VALUES (1319, 'admin', '116.5.10.64', '广东 佛山', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-13 10:13:14');
INSERT INTO `admin_sys_logininfor` VALUES (1320, 'admin', '119.123.32.84', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 10:14:11');
INSERT INTO `admin_sys_logininfor` VALUES (1321, 'admin', '171.41.72.175', '湖北 黄冈', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-13 10:16:44');
INSERT INTO `admin_sys_logininfor` VALUES (1322, 'admin', '171.41.72.175', '湖北 黄冈', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 10:16:51');
INSERT INTO `admin_sys_logininfor` VALUES (1323, 'admin', '219.232.77.15', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-13 10:42:34');
INSERT INTO `admin_sys_logininfor` VALUES (1324, 'admin', '183.151.111.183', '浙江 丽水', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 10:46:01');
INSERT INTO `admin_sys_logininfor` VALUES (1325, 'admin', '123.116.57.97', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 12:46:54');
INSERT INTO `admin_sys_logininfor` VALUES (1326, 'admin', '43.227.139.40', '湖北 武汉', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-13 13:06:23');
INSERT INTO `admin_sys_logininfor` VALUES (1327, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 15:29:05');
INSERT INTO `admin_sys_logininfor` VALUES (1328, 'admin', '114.216.69.132', '江苏 苏州', 'Chrome', 'Windows 7', '0', '退出成功', '2020-02-13 15:36:46');
INSERT INTO `admin_sys_logininfor` VALUES (1329, 'admin', '114.216.69.132', '江苏 苏州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-13 15:36:58');
INSERT INTO `admin_sys_logininfor` VALUES (1330, 'admin', '113.16.35.108', '广西 玉林', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 15:38:58');
INSERT INTO `admin_sys_logininfor` VALUES (1331, 'admin', '114.216.69.132', '江苏 苏州', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-13 15:45:08');
INSERT INTO `admin_sys_logininfor` VALUES (1332, 'admin', '114.216.69.132', '江苏 苏州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-13 15:45:12');
INSERT INTO `admin_sys_logininfor` VALUES (1333, 'admin', '117.136.66.220', '江苏 连云港', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-13 17:57:11');
INSERT INTO `admin_sys_logininfor` VALUES (1334, 'admin', '183.206.75.69', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 18:02:01');
INSERT INTO `admin_sys_logininfor` VALUES (1335, 'admin', '171.12.242.191', '河南 驻马店', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-13 19:46:26');
INSERT INTO `admin_sys_logininfor` VALUES (1336, 'admin', '112.49.237.61', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 20:19:56');
INSERT INTO `admin_sys_logininfor` VALUES (1337, 'admin', '113.81.227.113', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-02-13 20:51:57');
INSERT INTO `admin_sys_logininfor` VALUES (1338, 'admin', '125.82.8.22', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-13 21:49:57');
INSERT INTO `admin_sys_logininfor` VALUES (1339, 'admin', '139.189.220.10', '海南 海口', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-13 22:15:00');
INSERT INTO `admin_sys_logininfor` VALUES (1340, 'admin', '106.80.152.146', '重庆 重庆', 'Firefox 7', 'Windows 7', '1', '验证码错误', '2020-02-13 22:48:51');
INSERT INTO `admin_sys_logininfor` VALUES (1341, 'admin', '106.80.152.146', '重庆 重庆', 'Firefox 7', 'Windows 7', '0', '登录成功', '2020-02-13 22:48:55');
INSERT INTO `admin_sys_logininfor` VALUES (1342, 'admin', '120.227.46.230', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-13 23:09:57');
INSERT INTO `admin_sys_logininfor` VALUES (1343, 'admin', '61.159.197.127', '云南 昆明', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-14 09:03:03');
INSERT INTO `admin_sys_logininfor` VALUES (1344, 'admin', '61.159.197.127', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 09:04:44');
INSERT INTO `admin_sys_logininfor` VALUES (1345, 'admin', '171.83.7.238', '湖北 武汉', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-14 09:39:13');
INSERT INTO `admin_sys_logininfor` VALUES (1346, 'admin', '119.86.46.193', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 10:05:23');
INSERT INTO `admin_sys_logininfor` VALUES (1347, 'admin', '124.236.150.195', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 11:13:44');
INSERT INTO `admin_sys_logininfor` VALUES (1348, 'admin', '118.212.211.188', '江西 南昌', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-14 12:17:56');
INSERT INTO `admin_sys_logininfor` VALUES (1349, 'admin', '117.175.128.5', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 14:27:42');
INSERT INTO `admin_sys_logininfor` VALUES (1350, 'admin', '103.27.26.200', '广东 广州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 14:46:51');
INSERT INTO `admin_sys_logininfor` VALUES (1351, 'admin', '114.216.69.132', '江苏 苏州', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-14 15:16:08');
INSERT INTO `admin_sys_logininfor` VALUES (1352, 'admin', '114.216.69.132', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-14 15:16:27');
INSERT INTO `admin_sys_logininfor` VALUES (1353, 'admin', '42.236.206.148', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 15:25:56');
INSERT INTO `admin_sys_logininfor` VALUES (1354, 'admin', '180.111.40.255', '江苏 南京', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-14 16:14:34');
INSERT INTO `admin_sys_logininfor` VALUES (1355, 'admin', '180.111.40.255', '江苏 南京', 'Chrome 8', 'Mac OS X', '0', '退出成功', '2020-02-14 16:15:20');
INSERT INTO `admin_sys_logininfor` VALUES (1356, 'admin', '61.159.197.127', '云南 昆明', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 16:21:34');
INSERT INTO `admin_sys_logininfor` VALUES (1357, 'admin', '101.245.247.136', '上海 上海', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-14 16:30:58');
INSERT INTO `admin_sys_logininfor` VALUES (1358, 'admin', '117.31.106.213', '福建 漳州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-14 17:26:49');
INSERT INTO `admin_sys_logininfor` VALUES (1359, 'admin', '27.156.27.178', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-14 17:40:35');
INSERT INTO `admin_sys_logininfor` VALUES (1360, 'admin', '117.175.128.5', '四川 成都', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-14 18:07:03');
INSERT INTO `admin_sys_logininfor` VALUES (1361, 'admin', '117.175.128.5', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 18:07:08');
INSERT INTO `admin_sys_logininfor` VALUES (1362, 'admin', '116.3.200.75', '辽宁 大连', 'Firefox 7', 'Windows 7', '1', '验证码错误', '2020-02-14 20:37:19');
INSERT INTO `admin_sys_logininfor` VALUES (1363, 'admin', '116.3.200.75', 'XX XX', 'Firefox 7', 'Windows 7', '1', '验证码错误', '2020-02-14 20:37:25');
INSERT INTO `admin_sys_logininfor` VALUES (1364, 'admin', '116.3.200.75', '辽宁 大连', 'Firefox 7', 'Windows 7', '1', '验证码错误', '2020-02-14 20:37:28');
INSERT INTO `admin_sys_logininfor` VALUES (1365, 'admin', '116.3.200.75', 'XX XX', 'Firefox 7', 'Windows 7', '0', '登录成功', '2020-02-14 20:37:43');
INSERT INTO `admin_sys_logininfor` VALUES (1366, 'admin', '117.155.193.215', '湖北 随州', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-14 23:31:32');
INSERT INTO `admin_sys_logininfor` VALUES (1367, 'admin', '60.210.228.94', '山东 潍坊', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-14 23:32:12');
INSERT INTO `admin_sys_logininfor` VALUES (1368, 'admin', '117.169.75.64', '江西 南昌', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-02-15 01:53:38');
INSERT INTO `admin_sys_logininfor` VALUES (1369, 'admin', '117.169.75.64', '江西 南昌', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-15 01:53:43');
INSERT INTO `admin_sys_logininfor` VALUES (1370, 'admin', '117.169.75.64', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-15 01:54:06');
INSERT INTO `admin_sys_logininfor` VALUES (1371, 'admin', '223.91.2.190', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 09:44:54');
INSERT INTO `admin_sys_logininfor` VALUES (1372, 'admin', '175.5.199.162', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 12:37:33');
INSERT INTO `admin_sys_logininfor` VALUES (1373, 'admin', '120.227.251.28', '湖南 XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-15 13:33:16');
INSERT INTO `admin_sys_logininfor` VALUES (1374, 'admin', '175.11.85.230', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-15 14:57:05');
INSERT INTO `admin_sys_logininfor` VALUES (1375, 'admin', '175.11.85.230', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 14:57:10');
INSERT INTO `admin_sys_logininfor` VALUES (1376, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:28:49');
INSERT INTO `admin_sys_logininfor` VALUES (1377, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:29:21');
INSERT INTO `admin_sys_logininfor` VALUES (1378, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:29:22');
INSERT INTO `admin_sys_logininfor` VALUES (1379, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:29:23');
INSERT INTO `admin_sys_logininfor` VALUES (1380, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:31:17');
INSERT INTO `admin_sys_logininfor` VALUES (1381, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:31:17');
INSERT INTO `admin_sys_logininfor` VALUES (1382, 'admin', '120.208.19.109', '山西 运城', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-15 15:31:18');
INSERT INTO `admin_sys_logininfor` VALUES (1383, 'admin', '124.236.150.195', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 16:09:39');
INSERT INTO `admin_sys_logininfor` VALUES (1384, 'admin', '175.11.85.230', '湖南 长沙', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-15 16:36:44');
INSERT INTO `admin_sys_logininfor` VALUES (1385, '18677088205', '175.11.85.230', '湖南 长沙', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-15 16:36:55');
INSERT INTO `admin_sys_logininfor` VALUES (1386, '18677088205', '175.11.85.230', '湖南 长沙', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-15 16:36:58');
INSERT INTO `admin_sys_logininfor` VALUES (1387, 'admin', '175.11.85.230', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-15 16:37:09');
INSERT INTO `admin_sys_logininfor` VALUES (1388, 'admin', '117.136.0.195', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 16:38:20');
INSERT INTO `admin_sys_logininfor` VALUES (1389, 'admin', '175.11.85.230', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 16:38:34');
INSERT INTO `admin_sys_logininfor` VALUES (1390, 'admin', '110.184.55.105', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 18:56:52');
INSERT INTO `admin_sys_logininfor` VALUES (1391, 'admin', '116.9.196.246', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-15 19:00:48');
INSERT INTO `admin_sys_logininfor` VALUES (1392, 'admin', '140.243.238.152', '福建 福州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 19:01:20');
INSERT INTO `admin_sys_logininfor` VALUES (1393, 'admin', '119.139.33.59', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 19:15:07');
INSERT INTO `admin_sys_logininfor` VALUES (1394, 'admin', '119.139.33.59', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-15 19:17:53');
INSERT INTO `admin_sys_logininfor` VALUES (1395, 'admin', '119.139.33.59', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-15 19:17:57');
INSERT INTO `admin_sys_logininfor` VALUES (1396, 'admin', '119.139.33.59', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 19:18:00');
INSERT INTO `admin_sys_logininfor` VALUES (1397, 'admin', '112.20.85.170', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 19:43:31');
INSERT INTO `admin_sys_logininfor` VALUES (1398, 'admin', '183.226.197.230', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 19:57:07');
INSERT INTO `admin_sys_logininfor` VALUES (1399, 'admin', '113.12.35.69', '广西 梧州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-15 20:00:25');
INSERT INTO `admin_sys_logininfor` VALUES (1400, 'admin', '113.12.35.69', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-15 20:00:33');
INSERT INTO `admin_sys_logininfor` VALUES (1401, 'admin', '113.12.35.69', '广西 梧州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-15 20:03:35');
INSERT INTO `admin_sys_logininfor` VALUES (1402, 'admin', '113.12.35.69', '广西 梧州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-15 20:03:38');
INSERT INTO `admin_sys_logininfor` VALUES (1403, 'admin', '113.12.35.69', '广西 梧州', 'Chrome 8', 'Windows 10', '0', '退出成功', '2020-02-15 20:07:40');
INSERT INTO `admin_sys_logininfor` VALUES (1404, 'admin', '112.32.1.116', '安徽 合肥', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-15 20:23:24');
INSERT INTO `admin_sys_logininfor` VALUES (1405, 'admin', '112.32.1.116', '安徽 合肥', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-15 20:23:42');
INSERT INTO `admin_sys_logininfor` VALUES (1406, 'admin', '112.32.1.116', '安徽 合肥', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-15 20:23:49');
INSERT INTO `admin_sys_logininfor` VALUES (1407, 'admin', '117.136.125.31', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-15 20:34:52');
INSERT INTO `admin_sys_logininfor` VALUES (1408, 'admin', '117.136.125.31', '江西 赣州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-15 20:34:59');
INSERT INTO `admin_sys_logininfor` VALUES (1409, 'admin', '183.226.197.230', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 20:57:35');
INSERT INTO `admin_sys_logininfor` VALUES (1410, 'admin', '36.108.197.245', '新疆 昌吉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 21:00:57');
INSERT INTO `admin_sys_logininfor` VALUES (1411, 'admin', '119.86.45.150', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 21:12:14');
INSERT INTO `admin_sys_logininfor` VALUES (1412, 'admin', '120.242.118.166', '安徽 芜湖', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-15 21:16:19');
INSERT INTO `admin_sys_logininfor` VALUES (1413, 'admin', '120.194.118.227', '河南 许昌', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-15 21:34:23');
INSERT INTO `admin_sys_logininfor` VALUES (1414, 'admin', '171.210.217.137', '四川 成都', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-15 21:44:52');
INSERT INTO `admin_sys_logininfor` VALUES (1415, 'admin', '171.210.217.137', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-15 21:44:59');
INSERT INTO `admin_sys_logininfor` VALUES (1416, 'admin', '112.44.136.148', '四川 德阳', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-15 21:56:06');
INSERT INTO `admin_sys_logininfor` VALUES (1417, 'admin', '125.106.5.247', '浙江 衢州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-15 22:56:56');
INSERT INTO `admin_sys_logininfor` VALUES (1418, 'admin', '114.222.220.199', '江苏 南京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-15 23:15:47');
INSERT INTO `admin_sys_logininfor` VALUES (1419, 'admin', '117.136.105.144', '河南 安阳', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-15 23:27:41');
INSERT INTO `admin_sys_logininfor` VALUES (1420, 'admin', '120.229.11.255', '广东 深圳', 'Chrome', 'Mac OS X', '1', '密码输入错误1次', '2020-02-16 00:21:27');
INSERT INTO `admin_sys_logininfor` VALUES (1421, 'admin', '120.229.11.255', '广东 深圳', 'Chrome', 'Mac OS X', '1', '密码输入错误2次', '2020-02-16 00:22:25');
INSERT INTO `admin_sys_logininfor` VALUES (1422, 'admin', '120.229.11.255', '广东 深圳', 'Chrome', 'Mac OS X', '1', '密码输入错误3次', '2020-02-16 00:22:32');
INSERT INTO `admin_sys_logininfor` VALUES (1423, 'admin', '120.229.11.255', '广东 深圳', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-02-16 00:22:33');
INSERT INTO `admin_sys_logininfor` VALUES (1424, 'admin', '112.224.23.98', '山东 济南', 'Chrome 49', 'Windows 7', '1', '验证码错误', '2020-02-16 00:51:47');
INSERT INTO `admin_sys_logininfor` VALUES (1425, 'admin', '112.224.23.98', '山东 济南', 'Chrome 49', 'Windows 7', '0', '登录成功', '2020-02-16 00:51:53');
INSERT INTO `admin_sys_logininfor` VALUES (1426, 'admin', '120.194.118.227', '河南 许昌', 'Safari', 'Mac OS X', '0', '登录成功', '2020-02-16 05:47:21');
INSERT INTO `admin_sys_logininfor` VALUES (1427, 'admin', '113.118.69.175', '广东 深圳', 'Internet Explorer 10', 'Windows 7', '1', '验证码错误', '2020-02-16 08:22:06');
INSERT INTO `admin_sys_logininfor` VALUES (1428, 'admin', '113.118.69.175', 'XX XX', 'Internet Explorer 10', 'Windows 7', '0', '登录成功', '2020-02-16 08:22:11');
INSERT INTO `admin_sys_logininfor` VALUES (1429, 'admin', '113.200.132.125', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-16 09:00:48');
INSERT INTO `admin_sys_logininfor` VALUES (1430, 'admin', '222.130.128.182', '北京 北京', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-16 09:57:32');
INSERT INTO `admin_sys_logininfor` VALUES (1431, 'admin', '223.88.88.174', '河南 郑州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-16 10:08:22');
INSERT INTO `admin_sys_logininfor` VALUES (1432, 'admin', '223.88.88.174', '河南 郑州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-16 10:08:27');
INSERT INTO `admin_sys_logininfor` VALUES (1433, 'admin', '111.32.67.114', '天津 天津', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-16 10:09:29');
INSERT INTO `admin_sys_logininfor` VALUES (1434, 'admin', '27.17.234.46', '湖北 武汉', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-16 10:49:24');
INSERT INTO `admin_sys_logininfor` VALUES (1435, 'admin', '27.17.234.46', '湖北 武汉', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-16 10:49:34');
INSERT INTO `admin_sys_logininfor` VALUES (1436, 'admin', '125.46.129.214', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-16 10:52:26');
INSERT INTO `admin_sys_logininfor` VALUES (1437, 'admin', '125.46.129.214', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-16 12:45:39');
INSERT INTO `admin_sys_logininfor` VALUES (1438, 'admin', '120.229.31.97', '广东 深圳', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-16 15:23:01');
INSERT INTO `admin_sys_logininfor` VALUES (1439, 'admin', '223.167.142.254', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-16 17:09:11');
INSERT INTO `admin_sys_logininfor` VALUES (1440, 'admin', '119.103.234.85', '湖北 武汉', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-16 18:12:47');
INSERT INTO `admin_sys_logininfor` VALUES (1441, 'admin', '119.103.234.85', '湖北 武汉', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-16 18:12:57');
INSERT INTO `admin_sys_logininfor` VALUES (1442, 'admin', '27.199.68.165', '山东 济宁', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-16 18:20:12');
INSERT INTO `admin_sys_logininfor` VALUES (1443, 'admin', '27.199.68.165', '山东 济宁', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-16 18:20:16');
INSERT INTO `admin_sys_logininfor` VALUES (1444, 'admin', '117.155.192.206', '湖北 随州', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-16 18:52:59');
INSERT INTO `admin_sys_logininfor` VALUES (1445, 'admin', '120.229.44.182', '广东 深圳', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-16 20:20:31');
INSERT INTO `admin_sys_logininfor` VALUES (1446, 'admin', '117.136.0.227', '北京 北京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-16 21:53:55');
INSERT INTO `admin_sys_logininfor` VALUES (1447, 'admin', '123.117.73.183', '北京 北京', 'Chrome 49', 'Windows 10', '0', '登录成功', '2020-02-16 22:02:06');
INSERT INTO `admin_sys_logininfor` VALUES (1448, 'admin', '120.194.118.227', '河南 许昌', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-16 22:28:06');
INSERT INTO `admin_sys_logininfor` VALUES (1449, 'admin', '117.151.179.251', '湖北 荆州', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-16 23:41:47');
INSERT INTO `admin_sys_logininfor` VALUES (1450, 'admin', '1.193.26.125', '河南 郑州', 'Chrome Mobile', 'Android 6.x', '0', '登录成功', '2020-02-17 02:23:20');
INSERT INTO `admin_sys_logininfor` VALUES (1451, 'admin', '211.161.245.199', '上海 上海', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-17 09:19:42');
INSERT INTO `admin_sys_logininfor` VALUES (1452, 'admin', '106.114.108.177', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 09:31:06');
INSERT INTO `admin_sys_logininfor` VALUES (1453, 'admin', '113.227.51.9', '辽宁 大连', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 10:37:05');
INSERT INTO `admin_sys_logininfor` VALUES (1454, 'admin', '114.84.32.191', '上海 上海', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-17 10:55:37');
INSERT INTO `admin_sys_logininfor` VALUES (1455, 'admin', '114.84.32.191', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-17 10:55:42');
INSERT INTO `admin_sys_logininfor` VALUES (1456, 'admin', '121.230.11.13', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 10:58:40');
INSERT INTO `admin_sys_logininfor` VALUES (1457, 'admin', '106.114.108.177', '河北 石家庄', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-17 11:14:03');
INSERT INTO `admin_sys_logininfor` VALUES (1458, 'admin', '106.114.108.177', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 11:14:08');
INSERT INTO `admin_sys_logininfor` VALUES (1459, 'admin', '223.104.63.17', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-02-17 12:11:47');
INSERT INTO `admin_sys_logininfor` VALUES (1460, 'admin', '223.104.63.17', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-17 12:11:50');
INSERT INTO `admin_sys_logininfor` VALUES (1461, 'admin', '183.15.176.4', '广东 深圳', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-17 12:12:29');
INSERT INTO `admin_sys_logininfor` VALUES (1462, 'admin', '101.206.166.214', '四川 成都', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-17 12:34:41');
INSERT INTO `admin_sys_logininfor` VALUES (1463, 'admin', '113.116.63.55', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 13:50:02');
INSERT INTO `admin_sys_logininfor` VALUES (1464, 'admin', '113.116.63.55', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 13:54:15');
INSERT INTO `admin_sys_logininfor` VALUES (1465, 'admin', '125.78.99.172', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 14:06:44');
INSERT INTO `admin_sys_logininfor` VALUES (1466, 'admin', '171.43.4.57', '湖北 黄冈', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-17 14:44:10');
INSERT INTO `admin_sys_logininfor` VALUES (1467, 'admin', '171.43.4.57', '湖北 黄冈', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 14:44:18');
INSERT INTO `admin_sys_logininfor` VALUES (1468, 'admin', '27.18.182.224', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 14:49:53');
INSERT INTO `admin_sys_logininfor` VALUES (1469, 'admin', '36.4.140.93', '安徽 铜陵', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 15:20:02');
INSERT INTO `admin_sys_logininfor` VALUES (1470, 'admin', '183.93.123.231', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 15:37:18');
INSERT INTO `admin_sys_logininfor` VALUES (1471, 'admin', '223.104.147.35', '江苏 南京', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-17 15:37:54');
INSERT INTO `admin_sys_logininfor` VALUES (1472, 'admin', '183.92.64.18', '湖北 十堰', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-17 15:38:15');
INSERT INTO `admin_sys_logininfor` VALUES (1473, 'admin', '119.57.105.74', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 15:48:29');
INSERT INTO `admin_sys_logininfor` VALUES (1474, 'admin', '117.150.125.152', '湖北 十堰', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-17 15:49:37');
INSERT INTO `admin_sys_logininfor` VALUES (1475, 'admin', '117.150.125.152', 'XX XX', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-17 15:49:49');
INSERT INTO `admin_sys_logininfor` VALUES (1476, 'admin', '117.150.125.152', '湖北 十堰', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-17 15:50:06');
INSERT INTO `admin_sys_logininfor` VALUES (1477, 'admin', '117.150.125.152', '湖北 十堰', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-17 15:50:13');
INSERT INTO `admin_sys_logininfor` VALUES (1478, 'admin', '182.150.140.207', '四川 成都', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-17 16:47:29');
INSERT INTO `admin_sys_logininfor` VALUES (1479, 'admin', '117.150.100.141', '湖北 十堰', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 16:59:38');
INSERT INTO `admin_sys_logininfor` VALUES (1480, 'admin', '171.43.151.94', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-17 19:26:38');
INSERT INTO `admin_sys_logininfor` VALUES (1481, 'admin', '111.44.171.94', '青海 西宁', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-17 19:34:56');
INSERT INTO `admin_sys_logininfor` VALUES (1482, 'admin', '42.236.202.75', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 20:29:39');
INSERT INTO `admin_sys_logininfor` VALUES (1483, 'admin', '42.92.159.0', '甘肃 兰州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-17 22:19:11');
INSERT INTO `admin_sys_logininfor` VALUES (1484, 'admin', '117.150.100.141', '湖北 十堰', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-17 22:58:59');
INSERT INTO `admin_sys_logininfor` VALUES (1485, 'admin', '36.6.195.250', '安徽 黄山', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-18 09:31:34');
INSERT INTO `admin_sys_logininfor` VALUES (1486, 'admin', '36.6.195.250', '安徽 黄山', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 10:13:34');
INSERT INTO `admin_sys_logininfor` VALUES (1487, 'admin', '183.63.135.214', '广东 广州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-18 11:08:23');
INSERT INTO `admin_sys_logininfor` VALUES (1488, 'admin', '117.136.53.148', '湖北 XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-18 12:04:36');
INSERT INTO `admin_sys_logininfor` VALUES (1489, 'admin', '117.150.100.141', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 13:35:38');
INSERT INTO `admin_sys_logininfor` VALUES (1490, 'admin', '118.78.135.184', '山西 运城', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-18 13:45:53');
INSERT INTO `admin_sys_logininfor` VALUES (1491, 'admin', '218.66.48.229', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 14:15:25');
INSERT INTO `admin_sys_logininfor` VALUES (1492, 'admin', '112.36.43.26', '山东 菏泽', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-18 15:24:22');
INSERT INTO `admin_sys_logininfor` VALUES (1493, 'admin', '110.88.33.227', '福建 福州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 16:04:24');
INSERT INTO `admin_sys_logininfor` VALUES (1494, 'admin', '223.145.3.77', '湖南 岳阳', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-18 16:16:21');
INSERT INTO `admin_sys_logininfor` VALUES (1495, 'admin', '223.145.3.77', '湖南 岳阳', 'Chrome 8', 'Windows 10', '0', '退出成功', '2020-02-18 16:17:03');
INSERT INTO `admin_sys_logininfor` VALUES (1496, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 16:39:19');
INSERT INTO `admin_sys_logininfor` VALUES (1497, 'admin', '223.152.186.65', '湖南 郴州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-18 16:59:27');
INSERT INTO `admin_sys_logininfor` VALUES (1498, 'admin', '223.73.56.6', '广东 广州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-18 17:06:03');
INSERT INTO `admin_sys_logininfor` VALUES (1499, 'admin', '113.248.150.176', '重庆 重庆', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 17:15:19');
INSERT INTO `admin_sys_logininfor` VALUES (1500, 'admin', '111.18.44.31', '陕西 西安', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-18 18:03:42');
INSERT INTO `admin_sys_logininfor` VALUES (1501, 'admin', '120.243.110.123', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 18:44:43');
INSERT INTO `admin_sys_logininfor` VALUES (1502, 'admin', '182.106.239.186', '江西 赣州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 19:42:06');
INSERT INTO `admin_sys_logininfor` VALUES (1503, 'admin', '106.114.39.53', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 19:52:42');
INSERT INTO `admin_sys_logininfor` VALUES (1504, 'admin', '106.114.108.161', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 19:55:01');
INSERT INTO `admin_sys_logininfor` VALUES (1505, 'admin', '115.44.82.239', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-18 19:56:47');
INSERT INTO `admin_sys_logininfor` VALUES (1506, 'admin', '106.113.185.164', '河北 石家庄', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-18 20:00:14');
INSERT INTO `admin_sys_logininfor` VALUES (1507, 'admin', '113.67.11.174', '广东 广州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-19 01:00:11');
INSERT INTO `admin_sys_logininfor` VALUES (1508, 'admin', '61.149.153.165', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-19 09:00:42');
INSERT INTO `admin_sys_logininfor` VALUES (1509, 'admin', '14.28.3.16', '广东 肇庆', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-19 10:11:43');
INSERT INTO `admin_sys_logininfor` VALUES (1510, 'admin', '14.28.3.16', '广东 肇庆', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-19 10:11:51');
INSERT INTO `admin_sys_logininfor` VALUES (1511, 'admin', '14.28.3.16', '广东 肇庆', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-19 10:12:02');
INSERT INTO `admin_sys_logininfor` VALUES (1512, 'admin', '121.204.121.162', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 10:58:33');
INSERT INTO `admin_sys_logininfor` VALUES (1513, 'admin', '111.19.48.208', '陕西 咸阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 11:44:03');
INSERT INTO `admin_sys_logininfor` VALUES (1514, 'admin', '111.36.172.215', '山东 济南', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-19 11:48:03');
INSERT INTO `admin_sys_logininfor` VALUES (1515, 'admin', '119.119.42.43', '辽宁 沈阳', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-19 13:20:52');
INSERT INTO `admin_sys_logininfor` VALUES (1516, 'admin', '111.19.49.16', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 13:26:39');
INSERT INTO `admin_sys_logininfor` VALUES (1517, 'admin', '111.19.49.16', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-19 13:44:09');
INSERT INTO `admin_sys_logininfor` VALUES (1518, 'admin', '111.19.49.16', '陕西 咸阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 13:44:14');
INSERT INTO `admin_sys_logininfor` VALUES (1519, 'admin', '125.86.173.209', '重庆 重庆', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-19 13:47:03');
INSERT INTO `admin_sys_logininfor` VALUES (1520, 'admin', '36.157.192.66', '湖南 长沙', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-19 13:58:29');
INSERT INTO `admin_sys_logininfor` VALUES (1521, 'admin', '182.106.239.186', '江西 赣州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 15:57:05');
INSERT INTO `admin_sys_logininfor` VALUES (1522, 'admin', '223.167.141.230', '上海 上海', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-19 15:57:37');
INSERT INTO `admin_sys_logininfor` VALUES (1523, 'admin', '223.167.141.230', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-19 15:57:40');
INSERT INTO `admin_sys_logininfor` VALUES (1524, 'admin', '117.136.94.100', '山东 济南', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-19 16:14:29');
INSERT INTO `admin_sys_logininfor` VALUES (1525, 'admin', '115.60.82.228', '河南 郑州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-19 17:02:35');
INSERT INTO `admin_sys_logininfor` VALUES (1526, 'admin', '114.93.247.137', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-19 17:21:38');
INSERT INTO `admin_sys_logininfor` VALUES (1527, 'admin', '223.167.141.230', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-19 17:32:48');
INSERT INTO `admin_sys_logininfor` VALUES (1528, 'admin', '117.136.38.136', '北京 北京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-19 17:48:28');
INSERT INTO `admin_sys_logininfor` VALUES (1529, 'admin', '182.106.239.186', '江西 赣州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 18:08:20');
INSERT INTO `admin_sys_logininfor` VALUES (1530, 'admin', '49.4.160.20', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-19 18:40:57');
INSERT INTO `admin_sys_logininfor` VALUES (1531, 'admin', '14.28.3.16', '广东 肇庆', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-19 19:04:33');
INSERT INTO `admin_sys_logininfor` VALUES (1532, 'admin', '223.167.141.230', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-19 21:16:30');
INSERT INTO `admin_sys_logininfor` VALUES (1533, 'admin', '101.93.167.16', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-19 22:00:19');
INSERT INTO `admin_sys_logininfor` VALUES (1534, 'admin', '222.77.40.50', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 23:07:03');
INSERT INTO `admin_sys_logininfor` VALUES (1535, 'admin', '27.38.56.18', 'XX XX', 'Chrome Mobile', 'Android 6.x', '0', '登录成功', '2020-02-19 23:18:21');
INSERT INTO `admin_sys_logininfor` VALUES (1536, 'admin', '27.38.56.37', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-19 23:21:12');
INSERT INTO `admin_sys_logininfor` VALUES (1537, 'admin', '27.17.142.123', '湖北 武汉', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-20 02:21:23');
INSERT INTO `admin_sys_logininfor` VALUES (1538, 'admin', '223.167.141.230', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-20 09:25:33');
INSERT INTO `admin_sys_logininfor` VALUES (1540, 'admin', '113.246.155.218', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-20 10:47:27');
INSERT INTO `admin_sys_logininfor` VALUES (1541, 'admin', '183.95.32.222', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-20 11:27:48');
INSERT INTO `admin_sys_logininfor` VALUES (1542, 'admin', '59.41.21.96', '广东 广州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-20 15:34:33');
INSERT INTO `admin_sys_logininfor` VALUES (1543, 'admin', '117.27.171.238', '福建 漳州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-20 16:06:10');
INSERT INTO `admin_sys_logininfor` VALUES (1544, 'admin', '59.41.21.96', '广东 广州', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-20 17:06:14');
INSERT INTO `admin_sys_logininfor` VALUES (1545, 'admin', '117.28.234.34', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-20 17:25:55');
INSERT INTO `admin_sys_logininfor` VALUES (1546, 'admin', '223.72.76.155', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-20 17:41:25');
INSERT INTO `admin_sys_logininfor` VALUES (1547, 'admin', '175.172.42.6', '辽宁 沈阳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-20 17:43:39');
INSERT INTO `admin_sys_logininfor` VALUES (1548, 'admin', '175.172.42.6', '辽宁 沈阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-20 17:43:44');
INSERT INTO `admin_sys_logininfor` VALUES (1549, 'admin', '14.152.102.147', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-20 22:17:36');
INSERT INTO `admin_sys_logininfor` VALUES (1550, 'admin', '120.229.43.75', '广东 深圳', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-21 00:51:18');
INSERT INTO `admin_sys_logininfor` VALUES (1551, 'admin', '113.110.254.125', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-21 02:09:14');
INSERT INTO `admin_sys_logininfor` VALUES (1552, 'admin', '113.110.254.125', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '0', '退出成功', '2020-02-21 02:13:28');
INSERT INTO `admin_sys_logininfor` VALUES (1553, 'admin', '180.111.0.196', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 09:18:34');
INSERT INTO `admin_sys_logininfor` VALUES (1554, 'admin', '114.242.249.180', '北京 北京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-21 09:48:07');
INSERT INTO `admin_sys_logininfor` VALUES (1555, 'admin', '114.222.168.2', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 10:00:26');
INSERT INTO `admin_sys_logininfor` VALUES (1556, 'admin', '58.37.60.91', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 10:05:40');
INSERT INTO `admin_sys_logininfor` VALUES (1557, 'admin', '111.224.122.55', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 10:58:51');
INSERT INTO `admin_sys_logininfor` VALUES (1558, 'admin', '111.77.4.240', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-21 11:28:26');
INSERT INTO `admin_sys_logininfor` VALUES (1559, 'admin', '111.19.48.181', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 11:33:03');
INSERT INTO `admin_sys_logininfor` VALUES (1560, 'admin', '120.36.214.97', '福建 厦门', 'Safari', 'Mac OS X', '0', '登录成功', '2020-02-21 13:49:34');
INSERT INTO `admin_sys_logininfor` VALUES (1561, 'admin', '43.250.201.29', '湖南 长沙', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-21 14:38:50');
INSERT INTO `admin_sys_logininfor` VALUES (1562, 'admin', '123.196.129.73', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-02-21 14:39:48');
INSERT INTO `admin_sys_logininfor` VALUES (1563, 'admin', '123.196.129.73', '河北 石家庄', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-21 14:40:00');
INSERT INTO `admin_sys_logininfor` VALUES (1564, 'admin', '14.152.102.147', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-21 15:10:33');
INSERT INTO `admin_sys_logininfor` VALUES (1565, 'admin', '36.189.230.179', '新疆 克拉玛依', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 15:34:19');
INSERT INTO `admin_sys_logininfor` VALUES (1566, 'admin', '39.128.238.9', '云南 丽江', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-21 16:01:48');
INSERT INTO `admin_sys_logininfor` VALUES (1567, 'admin', '59.108.72.117', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-21 16:08:27');
INSERT INTO `admin_sys_logininfor` VALUES (1568, 'admin', '112.224.67.247', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-21 16:26:19');
INSERT INTO `admin_sys_logininfor` VALUES (1569, 'admin', '111.224.122.55', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 16:42:57');
INSERT INTO `admin_sys_logininfor` VALUES (1570, 'admin', '111.224.122.55', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-21 16:43:22');
INSERT INTO `admin_sys_logininfor` VALUES (1571, 'rule', '111.224.122.55', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-21 16:43:30');
INSERT INTO `admin_sys_logininfor` VALUES (1572, 'admin', '111.224.122.55', '河北 石家庄', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-21 16:43:36');
INSERT INTO `admin_sys_logininfor` VALUES (1573, 'admin', '111.224.122.55', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 16:43:41');
INSERT INTO `admin_sys_logininfor` VALUES (1574, 'admin', '111.224.122.55', '河北 石家庄', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-21 16:48:35');
INSERT INTO `admin_sys_logininfor` VALUES (1575, 'admin', '111.224.122.55', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 16:48:40');
INSERT INTO `admin_sys_logininfor` VALUES (1576, 'admin', '36.27.61.106', '浙江 杭州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-21 16:57:32');
INSERT INTO `admin_sys_logininfor` VALUES (1577, 'admin', '36.27.61.106', '浙江 杭州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-21 16:57:37');
INSERT INTO `admin_sys_logininfor` VALUES (1578, 'admin', '183.206.161.84', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 17:20:56');
INSERT INTO `admin_sys_logininfor` VALUES (1579, 'admin', '14.23.116.66', '广东 广州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-21 17:53:49');
INSERT INTO `admin_sys_logininfor` VALUES (1580, 'admin', '220.200.25.232', '福建 福州', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-21 18:41:31');
INSERT INTO `admin_sys_logininfor` VALUES (1581, 'admin', '59.108.72.117', '北京 北京', 'Chrome', 'Mac OS X', '0', '退出成功', '2020-02-21 18:43:15');
INSERT INTO `admin_sys_logininfor` VALUES (1582, 'admin', '59.108.72.117', '北京 北京', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-21 18:43:19');
INSERT INTO `admin_sys_logininfor` VALUES (1583, 'admin', '106.113.1.184', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 21:23:01');
INSERT INTO `admin_sys_logininfor` VALUES (1584, 'admin', '221.218.239.132', '北京 北京', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-21 21:28:39');
INSERT INTO `admin_sys_logininfor` VALUES (1585, 'admin', '221.218.239.132', '北京 北京', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-21 21:28:43');
INSERT INTO `admin_sys_logininfor` VALUES (1586, 'admin', '113.128.64.162', '山东 济南', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-21 21:53:48');
INSERT INTO `admin_sys_logininfor` VALUES (1587, 'admin', '113.128.64.162', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-21 21:53:59');
INSERT INTO `admin_sys_logininfor` VALUES (1588, 'admin', '113.128.64.162', '山东 济南', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-21 21:54:43');
INSERT INTO `admin_sys_logininfor` VALUES (1589, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-21 22:30:51');
INSERT INTO `admin_sys_logininfor` VALUES (1590, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 22:30:57');
INSERT INTO `admin_sys_logininfor` VALUES (1591, 'admin', '106.17.224.196', '湖南 长沙', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-21 22:50:54');
INSERT INTO `admin_sys_logininfor` VALUES (1592, 'admin', '106.113.1.184', '河北 石家庄', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-21 22:56:51');
INSERT INTO `admin_sys_logininfor` VALUES (1593, 'admin', '123.196.129.73', '河北 石家庄', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-22 09:20:40');
INSERT INTO `admin_sys_logininfor` VALUES (1594, 'admin', '106.117.82.144', '河北 石家庄', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-22 09:21:49');
INSERT INTO `admin_sys_logininfor` VALUES (1595, 'admin', '123.161.181.59', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 12:32:39');
INSERT INTO `admin_sys_logininfor` VALUES (1596, 'admin', '112.234.101.3', '山东 临沂', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-22 13:12:48');
INSERT INTO `admin_sys_logininfor` VALUES (1597, 'admin', '115.44.82.239', '广东 深圳', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-22 13:30:23');
INSERT INTO `admin_sys_logininfor` VALUES (1598, 'admin', '113.128.64.162', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-22 14:12:10');
INSERT INTO `admin_sys_logininfor` VALUES (1599, 'admin', '113.106.3.136', '广东 中山', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-22 14:40:31');
INSERT INTO `admin_sys_logininfor` VALUES (1600, 'admin', '61.165.41.213', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-22 14:43:24');
INSERT INTO `admin_sys_logininfor` VALUES (1601, 'admin', '120.235.43.28', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 14:53:39');
INSERT INTO `admin_sys_logininfor` VALUES (1602, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 14:57:27');
INSERT INTO `admin_sys_logininfor` VALUES (1603, 'admin', '112.26.58.89', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-02-22 15:27:15');
INSERT INTO `admin_sys_logininfor` VALUES (1604, 'admin', '112.26.58.89', '安徽 芜湖', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-22 15:27:18');
INSERT INTO `admin_sys_logininfor` VALUES (1605, 'admin', '182.135.112.169', '四川 内江', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 15:53:14');
INSERT INTO `admin_sys_logininfor` VALUES (1606, 'admin', '113.73.138.19', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-22 15:59:49');
INSERT INTO `admin_sys_logininfor` VALUES (1607, 'admin', '113.73.138.19', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 15:59:54');
INSERT INTO `admin_sys_logininfor` VALUES (1608, 'admin', '120.235.43.28', '广东 东莞', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-22 16:15:38');
INSERT INTO `admin_sys_logininfor` VALUES (1609, 'admin', '120.235.43.28', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 16:15:59');
INSERT INTO `admin_sys_logininfor` VALUES (1610, 'admin', '111.199.189.91', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-22 16:40:53');
INSERT INTO `admin_sys_logininfor` VALUES (1611, 'admin', '120.239.180.9', '广东 中山', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-22 16:44:46');
INSERT INTO `admin_sys_logininfor` VALUES (1612, 'admin', '113.73.138.19', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-22 17:05:20');
INSERT INTO `admin_sys_logininfor` VALUES (1613, 'admin', '113.73.138.19', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-22 17:05:25');
INSERT INTO `admin_sys_logininfor` VALUES (1614, 'admin', '113.73.138.19', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-22 17:05:32');
INSERT INTO `admin_sys_logininfor` VALUES (1615, 'admin', '113.73.138.19', '广东 中山', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-22 17:13:06');
INSERT INTO `admin_sys_logininfor` VALUES (1616, 'admin', '120.239.180.9', '广东 中山', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-22 17:44:53');
INSERT INTO `admin_sys_logininfor` VALUES (1617, 'admin', '120.235.54.172', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-22 20:00:00');
INSERT INTO `admin_sys_logininfor` VALUES (1618, 'admin', '120.235.54.172', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 20:00:43');
INSERT INTO `admin_sys_logininfor` VALUES (1619, 'admin', '101.87.207.59', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-22 21:27:59');
INSERT INTO `admin_sys_logininfor` VALUES (1620, 'admin', '39.128.250.129', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-02-23 00:28:18');
INSERT INTO `admin_sys_logininfor` VALUES (1621, 'admin', '61.54.208.38', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-23 02:00:41');
INSERT INTO `admin_sys_logininfor` VALUES (1622, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-23 09:05:35');
INSERT INTO `admin_sys_logininfor` VALUES (1623, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 09:05:43');
INSERT INTO `admin_sys_logininfor` VALUES (1624, 'admin', '120.235.43.28', '广东 东莞', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-23 09:05:47');
INSERT INTO `admin_sys_logininfor` VALUES (1625, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-23 09:05:54');
INSERT INTO `admin_sys_logininfor` VALUES (1626, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-23 09:06:04');
INSERT INTO `admin_sys_logininfor` VALUES (1627, 'admin', '120.235.43.28', '广东 东莞', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 09:06:10');
INSERT INTO `admin_sys_logininfor` VALUES (1628, 'admin', '117.136.36.177', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-23 09:27:52');
INSERT INTO `admin_sys_logininfor` VALUES (1629, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 09:37:00');
INSERT INTO `admin_sys_logininfor` VALUES (1630, 'admin', '223.104.3.204', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-23 09:51:06');
INSERT INTO `admin_sys_logininfor` VALUES (1631, 'admin', '120.235.43.28', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 10:52:22');
INSERT INTO `admin_sys_logininfor` VALUES (1632, 'admin', '120.244.152.75', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 11:16:13');
INSERT INTO `admin_sys_logininfor` VALUES (1633, 'admin', '183.39.169.73', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-23 11:54:40');
INSERT INTO `admin_sys_logininfor` VALUES (1634, 'admin', '183.39.169.73', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-23 11:54:55');
INSERT INTO `admin_sys_logininfor` VALUES (1635, 'admin', '113.128.82.83', '山东 济南', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-23 12:00:44');
INSERT INTO `admin_sys_logininfor` VALUES (1636, 'admin', '183.39.169.73', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-23 12:01:06');
INSERT INTO `admin_sys_logininfor` VALUES (1637, 'admin', '117.186.190.226', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 12:17:40');
INSERT INTO `admin_sys_logininfor` VALUES (1638, 'admin', '223.20.47.155', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-23 12:25:01');
INSERT INTO `admin_sys_logininfor` VALUES (1639, 'admin', '42.91.167.14', '甘肃 兰州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 12:48:03');
INSERT INTO `admin_sys_logininfor` VALUES (1640, 'admin', '117.136.124.238', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-23 13:15:56');
INSERT INTO `admin_sys_logininfor` VALUES (1641, 'admin', '14.123.252.52', '广东 珠海', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-23 13:52:14');
INSERT INTO `admin_sys_logininfor` VALUES (1642, 'admin', '223.167.94.215', '上海 上海', 'Internet Explorer 11', 'Windows 10', '1', '验证码错误', '2020-02-23 14:29:48');
INSERT INTO `admin_sys_logininfor` VALUES (1643, 'admin', '223.167.94.215', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-02-23 14:29:53');
INSERT INTO `admin_sys_logininfor` VALUES (1644, 'admin', '223.101.70.240', '辽宁 沈阳', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-23 14:37:14');
INSERT INTO `admin_sys_logininfor` VALUES (1645, 'admin', '223.167.94.215', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 14:40:46');
INSERT INTO `admin_sys_logininfor` VALUES (1646, 'admin', '103.27.25.79', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-23 16:01:27');
INSERT INTO `admin_sys_logininfor` VALUES (1647, 'admin', '103.27.25.79', 'XX XX', 'Chrome 8', 'Windows 7', '0', '退出成功', '2020-02-23 16:04:47');
INSERT INTO `admin_sys_logininfor` VALUES (1648, 'admin', '103.27.25.79', '广东 广州', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-23 16:04:50');
INSERT INTO `admin_sys_logininfor` VALUES (1649, 'admin', '103.27.25.79', '广东 广州', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-23 16:04:51');
INSERT INTO `admin_sys_logininfor` VALUES (1650, 'admin', '103.27.25.79', '广东 广州', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-23 16:04:52');
INSERT INTO `admin_sys_logininfor` VALUES (1651, 'admin', '103.27.25.79', '广东 广州', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-23 16:04:54');
INSERT INTO `admin_sys_logininfor` VALUES (1652, 'admin', '223.64.133.228', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-23 16:27:26');
INSERT INTO `admin_sys_logininfor` VALUES (1653, 'admin', '113.5.164.116', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-23 16:28:03');
INSERT INTO `admin_sys_logininfor` VALUES (1654, 'admin', '113.5.164.116', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-23 16:28:08');
INSERT INTO `admin_sys_logininfor` VALUES (1655, 'admin', '112.39.106.73', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-23 17:19:48');
INSERT INTO `admin_sys_logininfor` VALUES (1656, 'admin', '112.39.106.73', '辽宁 沈阳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-23 17:19:55');
INSERT INTO `admin_sys_logininfor` VALUES (1657, 'admin', '112.39.106.73', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 17:34:21');
INSERT INTO `admin_sys_logininfor` VALUES (1658, 'admin', '113.5.164.116', 'XX XX', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-23 18:43:07');
INSERT INTO `admin_sys_logininfor` VALUES (1659, 'admin', '101.72.49.233', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-23 21:29:51');
INSERT INTO `admin_sys_logininfor` VALUES (1660, 'admin', '120.230.203.178', '广东 韶关', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-23 22:58:04');
INSERT INTO `admin_sys_logininfor` VALUES (1661, 'admin', '220.200.25.232', '福建 福州', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-23 23:48:06');
INSERT INTO `admin_sys_logininfor` VALUES (1662, 'admin', '1.180.12.197', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 00:14:15');
INSERT INTO `admin_sys_logininfor` VALUES (1663, 'admin', '1.180.12.197', '内蒙古 呼和浩特', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-24 00:19:44');
INSERT INTO `admin_sys_logininfor` VALUES (1664, 'admin1', '1.180.12.197', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-24 00:19:52');
INSERT INTO `admin_sys_logininfor` VALUES (1665, 'admin', '1.180.12.197', '内蒙古 呼和浩特', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-24 00:21:35');
INSERT INTO `admin_sys_logininfor` VALUES (1666, 'admin', '1.180.12.197', '内蒙古 呼和浩特', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 00:21:46');
INSERT INTO `admin_sys_logininfor` VALUES (1667, 'admin', '1.180.12.197', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-24 00:22:24');
INSERT INTO `admin_sys_logininfor` VALUES (1668, 'test', '1.180.12.197', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-24 00:22:34');
INSERT INTO `admin_sys_logininfor` VALUES (1669, 'test', '1.180.12.197', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-24 00:22:40');
INSERT INTO `admin_sys_logininfor` VALUES (1670, 'admin', '1.203.100.66', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-24 00:34:56');
INSERT INTO `admin_sys_logininfor` VALUES (1671, 'admin', '36.157.24.44', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 00:35:00');
INSERT INTO `admin_sys_logininfor` VALUES (1672, 'admin', '1.180.12.197', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 00:45:17');
INSERT INTO `admin_sys_logininfor` VALUES (1673, 'admin', '111.32.89.230', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-24 07:28:06');
INSERT INTO `admin_sys_logininfor` VALUES (1674, 'admin', '113.91.208.77', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-24 09:30:45');
INSERT INTO `admin_sys_logininfor` VALUES (1675, 'admin', '113.91.208.77', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-24 09:30:52');
INSERT INTO `admin_sys_logininfor` VALUES (1676, 'admin', '222.244.145.26', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 09:41:40');
INSERT INTO `admin_sys_logininfor` VALUES (1677, 'admin', '113.91.208.77', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-24 10:08:12');
INSERT INTO `admin_sys_logininfor` VALUES (1678, 'admin', '123.116.117.191', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-24 10:09:30');
INSERT INTO `admin_sys_logininfor` VALUES (1679, 'admin', '43.243.12.116', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 10:19:12');
INSERT INTO `admin_sys_logininfor` VALUES (1680, 'admin', '221.231.195.49', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-24 10:37:40');
INSERT INTO `admin_sys_logininfor` VALUES (1681, 'admin', '116.236.162.26', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 10:58:55');
INSERT INTO `admin_sys_logininfor` VALUES (1682, 'admin', '116.236.162.26', '上海 上海', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-24 11:04:49');
INSERT INTO `admin_sys_logininfor` VALUES (1683, 'admin', '117.173.87.175', '四川 成都', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-24 11:19:24');
INSERT INTO `admin_sys_logininfor` VALUES (1684, 'admin', '140.207.23.56', '上海 上海', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-24 12:07:35');
INSERT INTO `admin_sys_logininfor` VALUES (1685, 'admin', '117.107.215.158', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 13:18:28');
INSERT INTO `admin_sys_logininfor` VALUES (1686, 'admin', '220.250.12.238', '福建 福州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 14:07:33');
INSERT INTO `admin_sys_logininfor` VALUES (1687, 'admin', '110.87.78.156', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 14:12:44');
INSERT INTO `admin_sys_logininfor` VALUES (1688, 'admin', '113.88.80.63', 'XX XX', 'Internet Explorer 11', 'Windows 10', '1', '验证码错误', '2020-02-24 14:12:47');
INSERT INTO `admin_sys_logininfor` VALUES (1689, 'admin', '113.88.80.63', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-02-24 14:13:00');
INSERT INTO `admin_sys_logininfor` VALUES (1690, 'admin', '110.87.78.156', '福建 厦门', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-24 14:24:52');
INSERT INTO `admin_sys_logininfor` VALUES (1691, 'nacos', '110.87.78.156', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-24 14:24:58');
INSERT INTO `admin_sys_logininfor` VALUES (1692, 'admin', '110.87.78.156', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 14:27:00');
INSERT INTO `admin_sys_logininfor` VALUES (1693, 'admin', '125.77.104.55', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 14:29:14');
INSERT INTO `admin_sys_logininfor` VALUES (1694, 'admin', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 14:33:31');
INSERT INTO `admin_sys_logininfor` VALUES (1695, 'admin', '61.148.190.222', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 14:37:35');
INSERT INTO `admin_sys_logininfor` VALUES (1696, 'admin', '120.36.224.27', '福建 厦门', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-24 14:50:53');
INSERT INTO `admin_sys_logininfor` VALUES (1697, 'admin', '120.36.224.27', '福建 厦门', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 14:50:59');
INSERT INTO `admin_sys_logininfor` VALUES (1698, 'admin', '120.36.224.27', '福建 厦门', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 14:54:19');
INSERT INTO `admin_sys_logininfor` VALUES (1699, 'admin', '119.137.54.49', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 15:12:45');
INSERT INTO `admin_sys_logininfor` VALUES (1700, 'admin', '113.5.164.116', 'XX XX', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-24 15:13:51');
INSERT INTO `admin_sys_logininfor` VALUES (1701, 'admin', '223.97.9.88', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 15:14:51');
INSERT INTO `admin_sys_logininfor` VALUES (1702, 'admin', '218.13.14.225', '广东 佛山', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 15:18:18');
INSERT INTO `admin_sys_logininfor` VALUES (1703, 'admin', '223.104.45.213', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-24 15:21:08');
INSERT INTO `admin_sys_logininfor` VALUES (1704, 'admin', '220.184.252.246', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 15:31:37');
INSERT INTO `admin_sys_logininfor` VALUES (1705, 'admin', '119.137.54.49', '广东 深圳', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-24 15:51:56');
INSERT INTO `admin_sys_logininfor` VALUES (1706, 'admin', '119.137.54.49', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 15:53:48');
INSERT INTO `admin_sys_logininfor` VALUES (1707, 'admin', '222.77.94.195', '福建 泉州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 16:06:29');
INSERT INTO `admin_sys_logininfor` VALUES (1708, 'admin', '113.91.208.77', '广东 深圳', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-24 16:08:47');
INSERT INTO `admin_sys_logininfor` VALUES (1709, 'admin', '183.238.59.97', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 16:15:14');
INSERT INTO `admin_sys_logininfor` VALUES (1710, 'admin', '218.4.170.236', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 16:27:26');
INSERT INTO `admin_sys_logininfor` VALUES (1711, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-24 16:59:09');
INSERT INTO `admin_sys_logininfor` VALUES (1712, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-24 17:41:04');
INSERT INTO `admin_sys_logininfor` VALUES (1713, 'admin', '223.97.9.88', '山东 潍坊', 'Chrome', 'Windows 7', '0', '退出成功', '2020-02-24 17:49:18');
INSERT INTO `admin_sys_logininfor` VALUES (1714, 'admin', '223.97.9.88', '山东 潍坊', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 17:49:27');
INSERT INTO `admin_sys_logininfor` VALUES (1715, 'admin', '223.97.9.88', '山东 潍坊', 'Chrome', 'Windows 7', '0', '退出成功', '2020-02-24 17:50:53');
INSERT INTO `admin_sys_logininfor` VALUES (1716, 'admin', '223.97.9.88', '山东 潍坊', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-24 17:50:56');
INSERT INTO `admin_sys_logininfor` VALUES (1717, 'admin', '223.97.9.88', '山东 潍坊', 'Chrome', 'Windows 7', '1', '用户不存在/密码错误', '2020-02-24 17:51:03');
INSERT INTO `admin_sys_logininfor` VALUES (1718, 'admin', '223.97.9.88', 'XX XX', 'Chrome', 'Windows 7', '1', '用户不存在/密码错误', '2020-02-24 17:51:16');
INSERT INTO `admin_sys_logininfor` VALUES (1719, 'admin', '223.97.9.88', '山东 潍坊', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 17:53:22');
INSERT INTO `admin_sys_logininfor` VALUES (1720, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-24 18:38:38');
INSERT INTO `admin_sys_logininfor` VALUES (1721, 'admin', '183.208.53.152', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 18:54:19');
INSERT INTO `admin_sys_logininfor` VALUES (1722, 'admin', '182.200.184.16', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 19:18:08');
INSERT INTO `admin_sys_logininfor` VALUES (1723, 'admin', '27.224.129.41', '甘肃 兰州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 20:03:10');
INSERT INTO `admin_sys_logininfor` VALUES (1724, 'admin', '115.44.82.239', '广东 深圳', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-24 21:23:20');
INSERT INTO `admin_sys_logininfor` VALUES (1725, 'admin', '218.81.84.49', '上海 上海', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-24 21:39:13');
INSERT INTO `admin_sys_logininfor` VALUES (1726, 'admin', '218.81.84.49', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 21:39:17');
INSERT INTO `admin_sys_logininfor` VALUES (1727, 'admin', '218.81.84.49', '上海 上海', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 21:41:40');
INSERT INTO `admin_sys_logininfor` VALUES (1728, 'admin', '36.33.247.65', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-02-24 21:43:42');
INSERT INTO `admin_sys_logininfor` VALUES (1729, 'admin', '36.33.247.65', 'XX XX', 'Chrome', 'Mac OS X', '1', '验证码错误', '2020-02-24 21:43:44');
INSERT INTO `admin_sys_logininfor` VALUES (1730, 'admin', '36.33.247.65', '安徽 合肥', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-24 21:43:48');
INSERT INTO `admin_sys_logininfor` VALUES (1731, 'admin', '116.2.24.140', '辽宁 沈阳', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-24 21:44:08');
INSERT INTO `admin_sys_logininfor` VALUES (1732, 'admin', '218.92.137.234', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-24 21:46:16');
INSERT INTO `admin_sys_logininfor` VALUES (1733, 'admin', '218.92.137.234', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-24 21:46:18');
INSERT INTO `admin_sys_logininfor` VALUES (1734, 'admin', '218.92.137.234', '江苏 盐城', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-24 21:46:25');
INSERT INTO `admin_sys_logininfor` VALUES (1735, 'admin', '218.92.137.234', '江苏 盐城', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-24 21:46:29');
INSERT INTO `admin_sys_logininfor` VALUES (1736, 'admin', '218.92.137.234', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-24 21:46:30');
INSERT INTO `admin_sys_logininfor` VALUES (1737, 'admin', '116.2.24.140', '辽宁 沈阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 21:48:51');
INSERT INTO `admin_sys_logininfor` VALUES (1738, 'admin', '222.212.118.223', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-24 21:54:14');
INSERT INTO `admin_sys_logininfor` VALUES (1739, 'admin', '113.247.54.64', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-24 22:09:38');
INSERT INTO `admin_sys_logininfor` VALUES (1740, 'admin', '220.200.25.232', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-25 03:29:39');
INSERT INTO `admin_sys_logininfor` VALUES (1741, 'admin', '223.104.131.166', '湖南 长沙', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-25 08:16:54');
INSERT INTO `admin_sys_logininfor` VALUES (1742, 'admin', '117.176.201.71', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-25 09:07:38');
INSERT INTO `admin_sys_logininfor` VALUES (1743, 'admin', '117.152.153.211', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 09:39:45');
INSERT INTO `admin_sys_logininfor` VALUES (1744, 'admin', '117.152.153.211', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 09:39:58');
INSERT INTO `admin_sys_logininfor` VALUES (1745, 'admin', '117.152.153.211', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-25 09:44:59');
INSERT INTO `admin_sys_logininfor` VALUES (1746, 'admin', '106.114.157.234', '河北 石家庄', 'Firefox', 'Windows 10', '0', '登录成功', '2020-02-25 09:53:28');
INSERT INTO `admin_sys_logininfor` VALUES (1747, 'admin', '183.208.53.152', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 09:59:25');
INSERT INTO `admin_sys_logininfor` VALUES (1748, 'admin', '117.152.153.211', '湖北 武汉', 'Chrome Mobile', 'Android 1.x', '1', '密码输入错误1次', '2020-02-25 10:04:13');
INSERT INTO `admin_sys_logininfor` VALUES (1749, 'admin', '183.245.104.177', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 10:05:01');
INSERT INTO `admin_sys_logininfor` VALUES (1750, 'admin', '183.245.104.177', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 10:05:03');
INSERT INTO `admin_sys_logininfor` VALUES (1751, 'admin', '183.245.104.177', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 10:05:06');
INSERT INTO `admin_sys_logininfor` VALUES (1752, 'admin', '183.245.104.177', '浙江 温州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 10:05:09');
INSERT INTO `admin_sys_logininfor` VALUES (1753, 'admin', '183.245.104.177', '浙江 温州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 10:05:12');
INSERT INTO `admin_sys_logininfor` VALUES (1754, 'admin', '117.152.153.211', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 10:08:21');
INSERT INTO `admin_sys_logininfor` VALUES (1755, 'admin', '183.245.104.177', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 10:48:56');
INSERT INTO `admin_sys_logininfor` VALUES (1756, 'admin', '49.77.207.8', '江苏 南京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 11:39:39');
INSERT INTO `admin_sys_logininfor` VALUES (1757, 'admin', '183.2.217.93', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-25 11:43:30');
INSERT INTO `admin_sys_logininfor` VALUES (1758, 'admin', '27.224.129.41', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 11:45:49');
INSERT INTO `admin_sys_logininfor` VALUES (1759, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 12:00:50');
INSERT INTO `admin_sys_logininfor` VALUES (1760, 'admin', '112.53.97.213', '河南 郑州', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-25 12:43:44');
INSERT INTO `admin_sys_logininfor` VALUES (1761, 'admin', '183.245.104.177', '浙江 温州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 12:56:02');
INSERT INTO `admin_sys_logininfor` VALUES (1762, 'admin', '42.236.202.14', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 13:12:36');
INSERT INTO `admin_sys_logininfor` VALUES (1763, 'admin', '42.236.202.14', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 13:20:36');
INSERT INTO `admin_sys_logininfor` VALUES (1764, 'admin', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-25 13:21:35');
INSERT INTO `admin_sys_logininfor` VALUES (1765, 'admin', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-25 13:21:46');
INSERT INTO `admin_sys_logininfor` VALUES (1766, 'admin', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-02-25 13:22:30');
INSERT INTO `admin_sys_logininfor` VALUES (1767, 'admin', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 13:22:36');
INSERT INTO `admin_sys_logininfor` VALUES (1768, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '对不起，您的账号已被删除', '2020-02-25 13:23:03');
INSERT INTO `admin_sys_logininfor` VALUES (1769, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 13:23:23');
INSERT INTO `admin_sys_logininfor` VALUES (1770, 'ry', '42.236.202.14', '河南 郑州', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 13:24:00');
INSERT INTO `admin_sys_logininfor` VALUES (1771, 'ry', '42.236.202.14', '河南 郑州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 13:24:42');
INSERT INTO `admin_sys_logininfor` VALUES (1772, 'ry', '42.236.202.14', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 13:24:49');
INSERT INTO `admin_sys_logininfor` VALUES (1773, 'admin', '221.215.106.202', '山东 青岛', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 13:48:18');
INSERT INTO `admin_sys_logininfor` VALUES (1774, 'admin', '221.215.106.202', '山东 青岛', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 13:48:30');
INSERT INTO `admin_sys_logininfor` VALUES (1775, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-25 13:56:39');
INSERT INTO `admin_sys_logininfor` VALUES (1776, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-25 13:56:45');
INSERT INTO `admin_sys_logininfor` VALUES (1777, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-02-25 14:00:43');
INSERT INTO `admin_sys_logininfor` VALUES (1778, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:00:48');
INSERT INTO `admin_sys_logininfor` VALUES (1779, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 14:11:25');
INSERT INTO `admin_sys_logininfor` VALUES (1780, 'admin', '110.81.62.199', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 14:11:48');
INSERT INTO `admin_sys_logininfor` VALUES (1781, 'admin', '119.131.179.117', 'XX XX', 'Chrome 8', 'Linux', '1', '验证码错误', '2020-02-25 14:26:46');
INSERT INTO `admin_sys_logininfor` VALUES (1782, 'admin', '119.131.179.117', 'XX XX', 'Chrome 8', 'Linux', '1', '密码输入错误1次', '2020-02-25 14:26:55');
INSERT INTO `admin_sys_logininfor` VALUES (1783, 'admin', '110.81.62.199', '福建 泉州', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 14:31:21');
INSERT INTO `admin_sys_logininfor` VALUES (1784, 'rx', '110.81.62.199', '福建 泉州', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-25 14:32:08');
INSERT INTO `admin_sys_logininfor` VALUES (1785, 'rx', '110.81.62.199', '福建 泉州', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-25 14:32:13');
INSERT INTO `admin_sys_logininfor` VALUES (1786, 'admin', '117.176.130.45', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 14:46:06');
INSERT INTO `admin_sys_logininfor` VALUES (1787, 'admin', '117.176.130.45', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 14:46:21');
INSERT INTO `admin_sys_logininfor` VALUES (1788, 'admin', '117.176.130.45', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-25 14:46:45');
INSERT INTO `admin_sys_logininfor` VALUES (1789, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '0', '退出成功', '2020-02-25 14:47:09');
INSERT INTO `admin_sys_logininfor` VALUES (1790, 'admin', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-25 14:48:12');
INSERT INTO `admin_sys_logininfor` VALUES (1791, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 14:50:57');
INSERT INTO `admin_sys_logininfor` VALUES (1792, 'admin', '171.223.38.188', '四川 成都', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次', '2020-02-25 14:50:58');
INSERT INTO `admin_sys_logininfor` VALUES (1793, 'admin', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:51:04');
INSERT INTO `admin_sys_logininfor` VALUES (1794, 'admin', '171.223.38.188', '四川 成都', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:51:08');
INSERT INTO `admin_sys_logininfor` VALUES (1795, 'admin', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:52:10');
INSERT INTO `admin_sys_logininfor` VALUES (1796, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:52:58');
INSERT INTO `admin_sys_logininfor` VALUES (1797, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:53:13');
INSERT INTO `admin_sys_logininfor` VALUES (1798, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:53:16');
INSERT INTO `admin_sys_logininfor` VALUES (1799, 'ry', '110.81.62.199', '福建 泉州', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 14:53:48');
INSERT INTO `admin_sys_logininfor` VALUES (1800, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:55:47');
INSERT INTO `admin_sys_logininfor` VALUES (1801, 'admin', '171.223.38.188', '四川 成都', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:56:03');
INSERT INTO `admin_sys_logininfor` VALUES (1802, 'admin', '112.49.171.203', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 14:58:18');
INSERT INTO `admin_sys_logininfor` VALUES (1803, 'admin', '171.223.38.188', '四川 成都', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:00:00');
INSERT INTO `admin_sys_logininfor` VALUES (1804, 'admin', '171.116.235.224', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:00:20');
INSERT INTO `admin_sys_logininfor` VALUES (1805, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:01:05');
INSERT INTO `admin_sys_logininfor` VALUES (1806, 'ry', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 15:02:18');
INSERT INTO `admin_sys_logininfor` VALUES (1807, 'admin', '119.131.179.117', '广东 广州', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:02:20');
INSERT INTO `admin_sys_logininfor` VALUES (1808, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-25 15:03:54');
INSERT INTO `admin_sys_logininfor` VALUES (1809, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 15:04:03');
INSERT INTO `admin_sys_logininfor` VALUES (1810, 'ry', '117.176.130.45', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 15:04:38');
INSERT INTO `admin_sys_logininfor` VALUES (1811, 'ry', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 15:05:16');
INSERT INTO `admin_sys_logininfor` VALUES (1812, 'ry', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-25 15:05:43');
INSERT INTO `admin_sys_logininfor` VALUES (1813, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 15:05:55');
INSERT INTO `admin_sys_logininfor` VALUES (1814, 'ry', '117.176.130.45', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-25 15:06:01');
INSERT INTO `admin_sys_logininfor` VALUES (1815, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-25 15:06:02');
INSERT INTO `admin_sys_logininfor` VALUES (1816, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-02-25 15:06:04');
INSERT INTO `admin_sys_logininfor` VALUES (1817, 'ry', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:06:17');
INSERT INTO `admin_sys_logininfor` VALUES (1818, 'RY', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-25 15:06:20');
INSERT INTO `admin_sys_logininfor` VALUES (1819, 'admin', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:06:52');
INSERT INTO `admin_sys_logininfor` VALUES (1820, 'admin', '171.92.136.161', '四川 达州', 'Chrome Mobile', 'Android 1.x', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:07:18');
INSERT INTO `admin_sys_logininfor` VALUES (1821, 'ry', '171.92.136.161', 'XX XX', 'Chrome Mobile', 'Android 1.x', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:07:38');
INSERT INTO `admin_sys_logininfor` VALUES (1822, 'admin', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:09:45');
INSERT INTO `admin_sys_logininfor` VALUES (1823, 'admin', '171.223.38.188', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:13:50');
INSERT INTO `admin_sys_logininfor` VALUES (1824, 'admin', '171.223.38.188', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 15:14:08');
INSERT INTO `admin_sys_logininfor` VALUES (1825, 'admin', '113.88.82.142', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-25 15:14:34');
INSERT INTO `admin_sys_logininfor` VALUES (1826, 'admin', '113.88.82.142', 'XX XX', 'Firefox 7', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:14:38');
INSERT INTO `admin_sys_logininfor` VALUES (1827, 'admin', '119.137.54.69', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:16:11');
INSERT INTO `admin_sys_logininfor` VALUES (1828, 'admin', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:19:26');
INSERT INTO `admin_sys_logininfor` VALUES (1829, 'ry', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 15:19:41');
INSERT INTO `admin_sys_logininfor` VALUES (1830, 'ry', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 15:24:47');
INSERT INTO `admin_sys_logininfor` VALUES (1831, 'admin', '27.22.11.184', '湖北 襄阳', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 15:27:53');
INSERT INTO `admin_sys_logininfor` VALUES (1832, 'admin', '113.91.208.77', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 15:50:55');
INSERT INTO `admin_sys_logininfor` VALUES (1833, 'admin', '113.91.208.77', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 15:50:58');
INSERT INTO `admin_sys_logininfor` VALUES (1834, 'admin', '113.91.208.77', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 15:51:35');
INSERT INTO `admin_sys_logininfor` VALUES (1835, 'admin', '113.91.208.77', '广东 深圳', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 15:51:43');
INSERT INTO `admin_sys_logininfor` VALUES (1836, 'admin', '114.98.53.14', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-25 16:02:06');
INSERT INTO `admin_sys_logininfor` VALUES (1837, 'ry', '223.104.45.109', '福建 泉州', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-25 16:44:47');
INSERT INTO `admin_sys_logininfor` VALUES (1838, 'ry', '223.104.45.109', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 16:45:16');
INSERT INTO `admin_sys_logininfor` VALUES (1839, 'admin', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误1次', '2020-02-25 16:46:54');
INSERT INTO `admin_sys_logininfor` VALUES (1840, 'admin', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误2次', '2020-02-25 16:47:04');
INSERT INTO `admin_sys_logininfor` VALUES (1841, 'admin', '125.71.167.248', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-25 17:29:35');
INSERT INTO `admin_sys_logininfor` VALUES (1842, 'admin', '125.71.167.248', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误2次', '2020-02-25 17:29:40');
INSERT INTO `admin_sys_logininfor` VALUES (1843, 'admin', '124.193.71.114', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-02-25 17:31:17');
INSERT INTO `admin_sys_logininfor` VALUES (1844, 'admin', '124.193.71.114', '北京 北京', 'Chrome 8', 'Mac OS X', '1', '密码输入错误3次', '2020-02-25 17:31:23');
INSERT INTO `admin_sys_logininfor` VALUES (1845, 'admin', '124.193.71.114', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '密码输入错误4次', '2020-02-25 17:31:53');
INSERT INTO `admin_sys_logininfor` VALUES (1846, 'admin', '124.193.71.114', '北京 北京', 'Chrome 8', 'Mac OS X', '1', '密码输入错误5次', '2020-02-25 17:32:03');
INSERT INTO `admin_sys_logininfor` VALUES (1847, 'admin', '110.87.82.110', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 17:36:11');
INSERT INTO `admin_sys_logininfor` VALUES (1848, 'admin', '110.87.82.110', '福建 厦门', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-25 17:36:15');
INSERT INTO `admin_sys_logininfor` VALUES (1849, 'admin', '110.87.82.110', '福建 厦门', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 17:36:37');
INSERT INTO `admin_sys_logininfor` VALUES (1850, 'admin', '110.87.82.110', '福建 厦门', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-25 17:39:13');
INSERT INTO `admin_sys_logininfor` VALUES (1851, 'admin', '220.200.25.232', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-25 18:02:24');
INSERT INTO `admin_sys_logininfor` VALUES (1852, 'admin', '220.200.25.232', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误1次', '2020-02-25 18:02:31');
INSERT INTO `admin_sys_logininfor` VALUES (1853, 'admin', '220.200.25.232', '福建 福州', 'Chrome 8', 'Windows 7', '1', '密码输入错误2次', '2020-02-25 18:02:38');
INSERT INTO `admin_sys_logininfor` VALUES (1854, 'admin', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误1次', '2020-02-25 18:12:52');
INSERT INTO `admin_sys_logininfor` VALUES (1855, 'admin', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误2次', '2020-02-25 18:13:04');
INSERT INTO `admin_sys_logininfor` VALUES (1856, 'admin', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '1', '验证码错误', '2020-02-25 18:13:05');
INSERT INTO `admin_sys_logininfor` VALUES (1857, 'admin', '39.130.119.136', 'XX XX', 'Firefox 7', 'Windows 8', '1', '密码输入错误3次', '2020-02-25 18:16:01');
INSERT INTO `admin_sys_logininfor` VALUES (1858, 'admin', '39.130.119.136', '云南 昆明', 'Firefox 7', 'Windows 8', '1', '密码输入错误4次', '2020-02-25 18:16:07');
INSERT INTO `admin_sys_logininfor` VALUES (1859, 'admin', '39.130.119.136', 'XX XX', 'Firefox 7', 'Windows 8', '1', '密码输入错误5次', '2020-02-25 18:16:53');
INSERT INTO `admin_sys_logininfor` VALUES (1860, 'admin', '112.80.40.99', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误1次', '2020-02-25 18:27:46');
INSERT INTO `admin_sys_logininfor` VALUES (1861, 'admin', '112.80.40.99', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误2次', '2020-02-25 18:28:26');
INSERT INTO `admin_sys_logininfor` VALUES (1862, 'admin', '113.240.160.107', '湖南 长沙', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 19:44:58');
INSERT INTO `admin_sys_logininfor` VALUES (1863, 'admin', '113.240.160.107', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 19:45:07');
INSERT INTO `admin_sys_logininfor` VALUES (1864, 'ry', '117.176.130.45', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 20:38:39');
INSERT INTO `admin_sys_logininfor` VALUES (1865, 'admin', '59.56.0.219', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-25 20:54:20');
INSERT INTO `admin_sys_logininfor` VALUES (1866, 'admin', '59.56.0.219', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误2次', '2020-02-25 20:54:26');
INSERT INTO `admin_sys_logininfor` VALUES (1867, 'admin', '222.76.1.170', '福建 福州', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-25 21:30:32');
INSERT INTO `admin_sys_logininfor` VALUES (1868, 'admin', '222.76.1.170', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-25 21:32:20');
INSERT INTO `admin_sys_logininfor` VALUES (1869, 'ry', '222.76.1.170', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-25 21:53:49');
INSERT INTO `admin_sys_logininfor` VALUES (1870, 'admin', '39.130.119.136', '云南 昆明', 'Firefox 7', 'Windows 8', '1', '验证码错误', '2020-02-25 21:57:44');
INSERT INTO `admin_sys_logininfor` VALUES (1871, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Mac OS X', '1', '密码输入错误1次', '2020-02-25 22:48:40');
INSERT INTO `admin_sys_logininfor` VALUES (1872, 'admin', '116.233.69.125', '上海 上海', 'Chrome 8', 'Mac OS X', '1', '密码输入错误1次', '2020-02-25 23:03:33');
INSERT INTO `admin_sys_logininfor` VALUES (1873, 'admin', '42.88.99.19', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 00:02:43');
INSERT INTO `admin_sys_logininfor` VALUES (1874, 'admin', '42.88.99.19', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误2次', '2020-02-26 00:03:04');
INSERT INTO `admin_sys_logininfor` VALUES (1875, 'admin', '223.20.197.53', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 01:05:07');
INSERT INTO `admin_sys_logininfor` VALUES (1876, 'admin', '223.20.197.53', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-26 01:05:50');
INSERT INTO `admin_sys_logininfor` VALUES (1877, 'yn', '223.20.197.53', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-26 01:06:08');
INSERT INTO `admin_sys_logininfor` VALUES (1878, 'yn', '223.20.197.53', '北京 北京', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-26 01:06:17');
INSERT INTO `admin_sys_logininfor` VALUES (1879, 'admin', '223.20.197.53', '北京 北京', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 01:06:44');
INSERT INTO `admin_sys_logininfor` VALUES (1880, 'admin', '223.20.197.53', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-26 01:06:58');
INSERT INTO `admin_sys_logininfor` VALUES (1881, 'admin', '218.85.84.215', '福建 厦门', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 02:44:22');
INSERT INTO `admin_sys_logininfor` VALUES (1882, 'admin', '218.85.84.215', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误2次', '2020-02-26 02:44:35');
INSERT INTO `admin_sys_logininfor` VALUES (1883, 'admin', '218.85.84.215', '福建 厦门', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误3次', '2020-02-26 02:44:42');
INSERT INTO `admin_sys_logininfor` VALUES (1884, 'admin', '124.160.214.197', '浙江 杭州', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 04:25:06');
INSERT INTO `admin_sys_logininfor` VALUES (1885, 'admin', '101.131.185.58', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-26 05:11:53');
INSERT INTO `admin_sys_logininfor` VALUES (1886, 'admin', '101.131.185.58', '辽宁 大连', 'Chrome', 'Windows 7', '1', '密码输入错误2次', '2020-02-26 05:12:12');
INSERT INTO `admin_sys_logininfor` VALUES (1887, 'admin', '101.131.185.58', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误3次', '2020-02-26 05:17:16');
INSERT INTO `admin_sys_logininfor` VALUES (1888, 'admin', '101.131.185.58', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误4次', '2020-02-26 05:17:25');
INSERT INTO `admin_sys_logininfor` VALUES (1889, 'admin', '101.131.185.58', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误5次', '2020-02-26 05:17:44');
INSERT INTO `admin_sys_logininfor` VALUES (1890, 'admin', '101.131.185.58', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 05:17:53');
INSERT INTO `admin_sys_logininfor` VALUES (1891, 'admin', '101.131.185.58', '辽宁 大连', 'Chrome', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 05:20:19');
INSERT INTO `admin_sys_logininfor` VALUES (1892, 'admin', '118.112.57.53', '四川 成都', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 07:02:23');
INSERT INTO `admin_sys_logininfor` VALUES (1893, 'admin', '118.112.57.53', '四川 成都', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 07:02:28');
INSERT INTO `admin_sys_logininfor` VALUES (1894, 'admin', '120.41.113.19', '福建 厦门', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-26 09:02:37');
INSERT INTO `admin_sys_logininfor` VALUES (1895, 'admin', '120.41.113.19', '福建 厦门', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误2次', '2020-02-26 09:02:43');
INSERT INTO `admin_sys_logininfor` VALUES (1896, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误1次', '2020-02-26 09:24:01');
INSERT INTO `admin_sys_logininfor` VALUES (1897, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误2次', '2020-02-26 09:24:06');
INSERT INTO `admin_sys_logininfor` VALUES (1898, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误3次', '2020-02-26 09:24:10');
INSERT INTO `admin_sys_logininfor` VALUES (1899, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误4次', '2020-02-26 09:24:24');
INSERT INTO `admin_sys_logininfor` VALUES (1900, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次', '2020-02-26 09:24:41');
INSERT INTO `admin_sys_logininfor` VALUES (1901, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-26 09:33:44');
INSERT INTO `admin_sys_logininfor` VALUES (1902, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 09:33:53');
INSERT INTO `admin_sys_logininfor` VALUES (1903, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-26 09:33:56');
INSERT INTO `admin_sys_logininfor` VALUES (1904, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-02-26 09:33:56');
INSERT INTO `admin_sys_logininfor` VALUES (1905, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 09:41:37');
INSERT INTO `admin_sys_logininfor` VALUES (1906, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 09:41:46');
INSERT INTO `admin_sys_logininfor` VALUES (1907, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 09:50:44');
INSERT INTO `admin_sys_logininfor` VALUES (1908, 'admin', '1.81.225.15', '陕西 汉中', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-26 09:57:57');
INSERT INTO `admin_sys_logininfor` VALUES (1909, 'admin', '1.81.225.15', '陕西 汉中', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 09:58:08');
INSERT INTO `admin_sys_logininfor` VALUES (1910, 'admin', '1.81.225.15', '陕西 汉中', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 09:58:17');
INSERT INTO `admin_sys_logininfor` VALUES (1911, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 10:02:17');
INSERT INTO `admin_sys_logininfor` VALUES (1912, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 10:02:33');
INSERT INTO `admin_sys_logininfor` VALUES (1913, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 10:03:34');
INSERT INTO `admin_sys_logininfor` VALUES (1914, 'admin', '223.15.204.14', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-26 10:39:46');
INSERT INTO `admin_sys_logininfor` VALUES (1915, 'admin', '61.158.152.175', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误2次', '2020-02-26 10:39:49');
INSERT INTO `admin_sys_logininfor` VALUES (1916, 'admin', '223.15.204.14', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误3次', '2020-02-26 10:39:52');
INSERT INTO `admin_sys_logininfor` VALUES (1917, 'admin', '223.15.204.14', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误4次', '2020-02-26 10:40:16');
INSERT INTO `admin_sys_logininfor` VALUES (1918, 'admin', '123.165.54.156', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 11:03:37');
INSERT INTO `admin_sys_logininfor` VALUES (1919, 'admin', '113.64.230.138', '广东 河源', 'Chrome 8', 'Windows 7', '1', '密码输入错误2次', '2020-02-26 11:07:03');
INSERT INTO `admin_sys_logininfor` VALUES (1920, 'admin', '14.23.34.74', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-26 11:15:24');
INSERT INTO `admin_sys_logininfor` VALUES (1921, 'admin', '14.23.34.74', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误3次', '2020-02-26 11:15:31');
INSERT INTO `admin_sys_logininfor` VALUES (1922, 'admin', '14.23.34.74', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-26 11:15:35');
INSERT INTO `admin_sys_logininfor` VALUES (1923, 'admin', '182.61.184.242', 'XX XX', 'Chrome', 'Mac OS X', '1', '密码输入错误4次', '2020-02-26 11:16:39');
INSERT INTO `admin_sys_logininfor` VALUES (1924, 'admin', '182.61.184.242', 'XX XX', 'Chrome', 'Mac OS X', '1', '密码输入错误5次', '2020-02-26 11:16:57');
INSERT INTO `admin_sys_logininfor` VALUES (1925, 'admin', '121.32.98.48', '广东 广州', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 11:17:09');
INSERT INTO `admin_sys_logininfor` VALUES (1926, 'admin', '121.32.98.48', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 11:17:18');
INSERT INTO `admin_sys_logininfor` VALUES (1927, 'admin', '39.166.247.228', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '密码输入错误1次', '2020-02-26 14:46:55');
INSERT INTO `admin_sys_logininfor` VALUES (1928, 'admin', '39.166.247.228', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '密码输入错误2次', '2020-02-26 14:47:07');
INSERT INTO `admin_sys_logininfor` VALUES (1929, 'admin', '39.166.247.228', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '密码输入错误3次', '2020-02-26 14:48:01');
INSERT INTO `admin_sys_logininfor` VALUES (1930, 'admin', '39.166.247.228', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '密码输入错误4次', '2020-02-26 14:48:10');
INSERT INTO `admin_sys_logininfor` VALUES (1931, 'admin', '112.96.168.225', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误5次', '2020-02-26 14:58:09');
INSERT INTO `admin_sys_logininfor` VALUES (1932, 'admin', '111.121.79.217', 'XX XX', 'Firefox', 'Windows 10', '1', '验证码错误', '2020-02-26 15:09:17');
INSERT INTO `admin_sys_logininfor` VALUES (1933, 'admin', '111.121.79.217', '贵州 贵阳', 'Firefox', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 15:09:24');
INSERT INTO `admin_sys_logininfor` VALUES (1934, 'admin', '111.121.79.217', 'XX XX', 'Firefox', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 15:09:32');
INSERT INTO `admin_sys_logininfor` VALUES (1935, 'admin', '111.121.79.217', 'XX XX', 'Firefox', 'Windows 10', '1', '密码输入错误3次', '2020-02-26 15:09:40');
INSERT INTO `admin_sys_logininfor` VALUES (1936, 'admin', '59.61.95.142', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 15:30:57');
INSERT INTO `admin_sys_logininfor` VALUES (1937, 'admin', '59.61.95.142', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 15:31:03');
INSERT INTO `admin_sys_logininfor` VALUES (1938, 'admin', '59.61.95.142', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-26 15:31:43');
INSERT INTO `admin_sys_logininfor` VALUES (1939, 'admin', '59.61.95.142', '福建 厦门', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-26 15:31:54');
INSERT INTO `admin_sys_logininfor` VALUES (1940, 'admin', '113.66.208.75', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 16:11:39');
INSERT INTO `admin_sys_logininfor` VALUES (1941, 'admin', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-26 16:21:54');
INSERT INTO `admin_sys_logininfor` VALUES (1942, 'admin', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '密码输入错误1次', '2020-02-26 16:21:58');
INSERT INTO `admin_sys_logininfor` VALUES (1943, 'admin', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '密码输入错误2次', '2020-02-26 16:22:01');
INSERT INTO `admin_sys_logininfor` VALUES (1944, 'admin', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '密码输入错误3次', '2020-02-26 16:22:12');
INSERT INTO `admin_sys_logininfor` VALUES (1945, 'admin', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '密码输入错误4次', '2020-02-26 16:22:31');
INSERT INTO `admin_sys_logininfor` VALUES (1946, 'admin', '113.5.165.14', 'XX XX', 'Chrome', 'Windows 8.1', '1', '密码输入错误5次', '2020-02-26 16:22:42');
INSERT INTO `admin_sys_logininfor` VALUES (1947, 'admin', '117.71.99.67', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:27:32');
INSERT INTO `admin_sys_logininfor` VALUES (1948, 'admin', '117.71.99.67', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-26 16:27:57');
INSERT INTO `admin_sys_logininfor` VALUES (1949, 'admin', '117.71.99.67', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:28:03');
INSERT INTO `admin_sys_logininfor` VALUES (1950, 'admin', '113.88.80.120', 'XX XX', 'Firefox 7', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:28:45');
INSERT INTO `admin_sys_logininfor` VALUES (1951, 'admin', '113.88.80.120', 'XX XX', 'Firefox 7', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:29:20');
INSERT INTO `admin_sys_logininfor` VALUES (1952, 'admin', '117.71.99.67', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:30:02');
INSERT INTO `admin_sys_logininfor` VALUES (1953, 'admin', '113.88.80.120', '广东 深圳', 'Firefox 7', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:30:39');
INSERT INTO `admin_sys_logininfor` VALUES (1954, 'admin', '115.195.144.40', '浙江 杭州', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-26 16:48:41');
INSERT INTO `admin_sys_logininfor` VALUES (1955, 'admin', '122.96.43.133', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 16:52:49');
INSERT INTO `admin_sys_logininfor` VALUES (1956, 'admin', '122.96.43.133', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-26 16:53:34');
INSERT INTO `admin_sys_logininfor` VALUES (1957, 'admin', '106.114.19.86', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-26 16:55:32');
INSERT INTO `admin_sys_logininfor` VALUES (1958, 'admin', '106.114.19.86', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-26 16:55:49');
INSERT INTO `admin_sys_logininfor` VALUES (1959, 'admin', '106.114.19.86', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次', '2020-02-26 16:56:06');
INSERT INTO `admin_sys_logininfor` VALUES (1960, 'admin', '122.96.43.133', '江苏 南京', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 16:58:20');
INSERT INTO `admin_sys_logininfor` VALUES (1961, 'admin', '113.69.10.122', 'XX XX', 'Chrome', 'Ubuntu', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:04:13');
INSERT INTO `admin_sys_logininfor` VALUES (1962, 'admin', '113.69.10.122', 'XX XX', 'Chrome', 'Ubuntu', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:06:39');
INSERT INTO `admin_sys_logininfor` VALUES (1963, 'admin', '113.69.10.122', 'XX XX', 'Chrome', 'Ubuntu', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:06:50');
INSERT INTO `admin_sys_logininfor` VALUES (1964, 'admin', '113.5.165.14', 'XX XX', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-26 17:07:28');
INSERT INTO `admin_sys_logininfor` VALUES (1965, 'admin', '113.5.165.14', 'XX XX', 'Chrome', 'Windows 8.1', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:07:39');
INSERT INTO `admin_sys_logininfor` VALUES (1966, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:08:00');
INSERT INTO `admin_sys_logininfor` VALUES (1967, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:09:17');
INSERT INTO `admin_sys_logininfor` VALUES (1968, 'admin', '113.69.10.122', '广东 佛山', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (1969, 'admin', '113.5.165.14', 'XX XX', 'Chrome', 'Windows 8.1', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:10:17');
INSERT INTO `admin_sys_logininfor` VALUES (1970, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:11:40');
INSERT INTO `admin_sys_logininfor` VALUES (1971, 'admin', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:17:33');
INSERT INTO `admin_sys_logininfor` VALUES (1972, 'admin', '122.96.43.133', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 17:21:08');
INSERT INTO `admin_sys_logininfor` VALUES (1973, 'admin', '180.162.204.65', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 17:59:39');
INSERT INTO `admin_sys_logininfor` VALUES (1974, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '验证码错误', '2020-02-26 18:05:09');
INSERT INTO `admin_sys_logininfor` VALUES (1975, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '密码输入错误2次', '2020-02-26 18:05:16');
INSERT INTO `admin_sys_logininfor` VALUES (1976, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '密码输入错误3次', '2020-02-26 18:05:21');
INSERT INTO `admin_sys_logininfor` VALUES (1977, 'ry', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-26 18:09:37');
INSERT INTO `admin_sys_logininfor` VALUES (1978, 'ry', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '1', '密码输入错误1次', '2020-02-26 18:09:41');
INSERT INTO `admin_sys_logininfor` VALUES (1979, 'ry', '113.5.165.14', 'XX XX', 'Chrome', 'Windows 8.1', '1', '密码输入错误2次', '2020-02-26 18:09:56');
INSERT INTO `admin_sys_logininfor` VALUES (1980, 'ry', '113.5.165.14', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-02-26 18:10:10');
INSERT INTO `admin_sys_logininfor` VALUES (1981, 'admin', '60.255.32.25', '四川 成都', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 18:37:38');
INSERT INTO `admin_sys_logininfor` VALUES (1982, 'admin', '60.255.32.25', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误2次', '2020-02-26 18:37:45');
INSERT INTO `admin_sys_logininfor` VALUES (1983, 'admin', '117.135.126.8', 'XX XX', 'Chrome 8', 'Ubuntu', '1', '密码输入错误3次', '2020-02-26 18:39:56');
INSERT INTO `admin_sys_logininfor` VALUES (1984, 'admin1', '117.135.126.8', '上海 上海', 'Chrome 8', 'Ubuntu', '1', '用户不存在/密码错误', '2020-02-26 18:40:09');
INSERT INTO `admin_sys_logininfor` VALUES (1985, 'admin', '113.69.10.122', '广东 佛山', 'Chrome', 'Ubuntu', '1', '密码输入错误4次', '2020-02-26 18:43:41');
INSERT INTO `admin_sys_logininfor` VALUES (1986, 'admin', '183.226.251.110', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 19:08:26');
INSERT INTO `admin_sys_logininfor` VALUES (1987, 'admin', '183.226.251.110', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 19:08:45');
INSERT INTO `admin_sys_logininfor` VALUES (1988, 'admin', '183.226.251.110', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误3次', '2020-02-26 19:08:58');
INSERT INTO `admin_sys_logininfor` VALUES (1989, 'admin', '183.226.251.110', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误4次', '2020-02-26 19:09:58');
INSERT INTO `admin_sys_logininfor` VALUES (1990, 'admin', '183.226.251.110', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次', '2020-02-26 19:10:01');
INSERT INTO `admin_sys_logininfor` VALUES (1991, 'admin', '183.226.251.110', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-26 19:10:05');
INSERT INTO `admin_sys_logininfor` VALUES (1992, 'admin', '59.61.95.142', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-26 19:47:06');
INSERT INTO `admin_sys_logininfor` VALUES (1993, 'admin', '59.61.95.142', '福建 厦门', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 19:47:11');
INSERT INTO `admin_sys_logininfor` VALUES (1994, 'admin', '223.98.13.237', '山东 济南', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 20:09:31');
INSERT INTO `admin_sys_logininfor` VALUES (1995, 'admin', '223.98.13.237', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 20:10:32');
INSERT INTO `admin_sys_logininfor` VALUES (1996, 'admin', '110.18.154.196', '内蒙古 呼和浩特', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 20:32:00');
INSERT INTO `admin_sys_logininfor` VALUES (1997, 'admin', '110.18.154.196', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 20:32:07');
INSERT INTO `admin_sys_logininfor` VALUES (1998, 'admin', '106.113.1.184', '河北 石家庄', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-26 21:48:36');
INSERT INTO `admin_sys_logininfor` VALUES (1999, 'admin', '106.113.1.184', '河北 石家庄', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-26 21:48:40');
INSERT INTO `admin_sys_logininfor` VALUES (2000, 'admin', '106.113.1.184', '河北 石家庄', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-26 21:48:50');
INSERT INTO `admin_sys_logininfor` VALUES (2001, 'admin', '120.231.98.211', '广东 中山', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-26 22:18:45');
INSERT INTO `admin_sys_logininfor` VALUES (2002, 'admin', '120.231.98.211', '广东 中山', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-26 22:18:47');
INSERT INTO `admin_sys_logininfor` VALUES (2003, 'admin', '120.231.98.211', '广东 中山', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-26 22:18:48');
INSERT INTO `admin_sys_logininfor` VALUES (2004, 'admin', '120.231.98.211', '广东 中山', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-26 22:18:49');
INSERT INTO `admin_sys_logininfor` VALUES (2005, 'admin', '110.81.62.35', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-26 22:37:21');
INSERT INTO `admin_sys_logininfor` VALUES (2006, 'admin', '182.117.59.195', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-26 23:23:33');
INSERT INTO `admin_sys_logininfor` VALUES (2007, 'admin', '139.227.10.86', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-26 23:24:10');
INSERT INTO `admin_sys_logininfor` VALUES (2008, 'admin', '1.180.15.184', 'XX XX', 'Chrome', 'Windows 8.1', '1', '密码输入错误2次', '2020-02-26 23:25:08');
INSERT INTO `admin_sys_logininfor` VALUES (2009, 'admin', '1.180.15.184', 'XX XX', 'Chrome', 'Windows 8.1', '1', '验证码错误', '2020-02-26 23:25:42');
INSERT INTO `admin_sys_logininfor` VALUES (2010, 'admin', '1.180.15.184', '内蒙古 呼和浩特', 'Chrome', 'Windows 8.1', '1', '密码输入错误3次', '2020-02-26 23:25:46');
INSERT INTO `admin_sys_logininfor` VALUES (2011, 'admin', '223.104.3.207', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-27 00:12:26');
INSERT INTO `admin_sys_logininfor` VALUES (2012, 'admin', '223.104.3.207', '北京 北京', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误2次', '2020-02-27 00:12:35');
INSERT INTO `admin_sys_logininfor` VALUES (2013, 'admin', '117.136.26.3', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-27 00:45:13');
INSERT INTO `admin_sys_logininfor` VALUES (2014, 'admin', '61.158.148.17', '河南 郑州', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 08:13:12');
INSERT INTO `admin_sys_logininfor` VALUES (2015, 'admin', '61.158.148.17', '河南 郑州', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 08:13:24');
INSERT INTO `admin_sys_logininfor` VALUES (2016, 'admin', '61.158.148.17', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-27 08:14:38');
INSERT INTO `admin_sys_logininfor` VALUES (2017, 'admin', '27.27.215.246', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-27 08:25:01');
INSERT INTO `admin_sys_logininfor` VALUES (2018, 'admin', '27.27.215.246', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误1次', '2020-02-27 08:25:14');
INSERT INTO `admin_sys_logininfor` VALUES (2019, 'admin', '27.27.215.246', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-27 08:25:35');
INSERT INTO `admin_sys_logininfor` VALUES (2020, 'admin', '27.27.215.246', '湖北 襄阳', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误2次', '2020-02-27 08:25:42');
INSERT INTO `admin_sys_logininfor` VALUES (2021, 'admin', '27.27.215.246', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误3次', '2020-02-27 08:25:57');
INSERT INTO `admin_sys_logininfor` VALUES (2022, 'admin', '27.27.215.246', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '密码输入错误4次', '2020-02-27 08:26:03');
INSERT INTO `admin_sys_logininfor` VALUES (2023, 'admin', '115.238.93.234', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 08:57:23');
INSERT INTO `admin_sys_logininfor` VALUES (2024, 'admin', '115.238.93.234', '浙江 杭州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-27 08:57:43');
INSERT INTO `admin_sys_logininfor` VALUES (2025, 'admin', '115.238.93.234', '浙江 杭州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-27 08:58:01');
INSERT INTO `admin_sys_logininfor` VALUES (2026, 'admin', '115.238.93.234', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 08:58:06');
INSERT INTO `admin_sys_logininfor` VALUES (2027, 'admin', '115.238.93.234', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-27 08:58:27');
INSERT INTO `admin_sys_logininfor` VALUES (2028, 'admin', '115.238.93.234', '浙江 杭州', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-27 08:58:48');
INSERT INTO `admin_sys_logininfor` VALUES (2029, 'admin', '115.238.93.234', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误3次', '2020-02-27 08:58:54');
INSERT INTO `admin_sys_logininfor` VALUES (2030, 'admin', '115.238.93.234', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误4次', '2020-02-27 08:59:15');
INSERT INTO `admin_sys_logininfor` VALUES (2031, 'admin', '219.137.167.137', '广东 广州', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-27 09:48:41');
INSERT INTO `admin_sys_logininfor` VALUES (2032, 'admin', '117.136.124.125', 'XX XX', 'Chrome', 'Mac OS X', '1', '密码输入错误1次', '2020-02-27 10:01:55');
INSERT INTO `admin_sys_logininfor` VALUES (2033, 'admin', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '1', '密码输入错误2次', '2020-02-27 10:04:43');
INSERT INTO `admin_sys_logininfor` VALUES (2034, 'ry', '117.136.124.125', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-27 10:05:19');
INSERT INTO `admin_sys_logininfor` VALUES (2035, 'ry', '182.46.143.202', '山东 聊城', 'Safari', 'Mac OS X', '0', '登录成功', '2020-02-27 10:11:57');
INSERT INTO `admin_sys_logininfor` VALUES (2036, 'admin', '183.251.91.18', '福建 厦门', 'Chrome', 'Mac OS X', '1', '密码输入错误1次', '2020-02-27 10:25:21');
INSERT INTO `admin_sys_logininfor` VALUES (2037, 'admin', '183.251.91.18', 'XX XX', 'Chrome', 'Mac OS X', '1', '密码输入错误2次', '2020-02-27 10:25:26');
INSERT INTO `admin_sys_logininfor` VALUES (2038, 'admin', '1.199.78.238', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误1次', '2020-02-27 10:37:21');
INSERT INTO `admin_sys_logininfor` VALUES (2039, 'admin', '1.199.78.238', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误2次', '2020-02-27 10:37:25');
INSERT INTO `admin_sys_logininfor` VALUES (2040, 'admin', '1.199.78.238', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误3次', '2020-02-27 10:37:33');
INSERT INTO `admin_sys_logininfor` VALUES (2041, 'ry', '182.46.143.202', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-02-27 10:55:58');
INSERT INTO `admin_sys_logininfor` VALUES (2042, 'admin', '115.236.33.12', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 11:12:58');
INSERT INTO `admin_sys_logininfor` VALUES (2043, 'admin', '115.236.33.12', '浙江 杭州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-27 11:13:02');
INSERT INTO `admin_sys_logininfor` VALUES (2044, 'admin', '115.236.33.12', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 11:13:08');
INSERT INTO `admin_sys_logininfor` VALUES (2045, 'admin', '115.236.33.12', '浙江 杭州', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-27 11:18:30');
INSERT INTO `admin_sys_logininfor` VALUES (2046, 'admin', '115.236.33.12', '浙江 杭州', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-27 11:19:08');
INSERT INTO `admin_sys_logininfor` VALUES (2047, 'admin', '115.236.33.12', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-02-27 11:19:22');
INSERT INTO `admin_sys_logininfor` VALUES (2048, 'mall', '115.236.33.12', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-27 11:19:37');
INSERT INTO `admin_sys_logininfor` VALUES (2049, 'admin', '1.199.78.238', '河南 郑州', 'Chrome', 'Windows 7', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-27 11:25:39');
INSERT INTO `admin_sys_logininfor` VALUES (2050, 'ry', '1.199.78.238', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-27 11:27:26');
INSERT INTO `admin_sys_logininfor` VALUES (2051, 'admin', '112.96.25.1', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '密码输入错误1次', '2020-02-27 12:14:27');
INSERT INTO `admin_sys_logininfor` VALUES (2052, 'admin', '117.135.126.8', 'XX XX', 'Chrome 8', 'Ubuntu', '1', '密码输入错误1次', '2020-02-27 12:59:33');
INSERT INTO `admin_sys_logininfor` VALUES (2053, 'admin', '117.135.126.8', 'XX XX', 'Chrome 8', 'Ubuntu', '1', '密码输入错误2次', '2020-02-27 12:59:55');
INSERT INTO `admin_sys_logininfor` VALUES (2054, 'admin', '117.135.126.8', '上海 上海', 'Chrome 8', 'Ubuntu', '1', '密码输入错误3次', '2020-02-27 13:02:27');
INSERT INTO `admin_sys_logininfor` VALUES (2055, 'admin', '113.69.136.144', '广东 佛山', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-27 13:08:15');
INSERT INTO `admin_sys_logininfor` VALUES (2056, 'admin', '113.69.136.144', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-27 13:08:33');
INSERT INTO `admin_sys_logininfor` VALUES (2057, 'admin', '113.69.136.144', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-02-27 13:12:19');
INSERT INTO `admin_sys_logininfor` VALUES (2058, 'ry', '113.45.109.158', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 13:19:16');
INSERT INTO `admin_sys_logininfor` VALUES (2059, 'ry', '113.69.136.144', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 13:20:11');
INSERT INTO `admin_sys_logininfor` VALUES (2060, 'admin', '180.157.15.207', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-02-27 13:24:15');
INSERT INTO `admin_sys_logininfor` VALUES (2061, 'admin', '180.157.15.207', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 13:24:22');
INSERT INTO `admin_sys_logininfor` VALUES (2062, 'admin', '180.157.15.207', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 13:24:45');
INSERT INTO `admin_sys_logininfor` VALUES (2063, 'ry', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-27 13:26:52');
INSERT INTO `admin_sys_logininfor` VALUES (2064, 'admin', '220.178.80.202', '安徽 合肥', 'Firefox 7', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 14:15:03');
INSERT INTO `admin_sys_logininfor` VALUES (2065, 'admin', '220.178.80.202', 'XX XX', 'Firefox 7', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 14:15:08');
INSERT INTO `admin_sys_logininfor` VALUES (2066, 'admin', '182.45.206.103', 'XX XX', 'Chrome', 'Windows 7', '1', '密码输入错误3次', '2020-02-27 14:23:25');
INSERT INTO `admin_sys_logininfor` VALUES (2067, 'admin', '182.45.206.103', '山东 临沂', 'Chrome', 'Windows 7', '1', '密码输入错误4次', '2020-02-27 14:23:31');
INSERT INTO `admin_sys_logininfor` VALUES (2068, 'admin', '27.18.34.188', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 14:38:10');
INSERT INTO `admin_sys_logininfor` VALUES (2069, 'admin', '27.18.34.188', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 14:38:21');
INSERT INTO `admin_sys_logininfor` VALUES (2070, 'admin', '27.18.34.188', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-27 14:38:35');
INSERT INTO `admin_sys_logininfor` VALUES (2071, 'admin', '27.18.34.188', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-27 14:38:42');
INSERT INTO `admin_sys_logininfor` VALUES (2072, 'admin', '27.18.34.188', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-02-27 14:38:46');
INSERT INTO `admin_sys_logininfor` VALUES (2073, 'admin', '27.18.34.188', '湖北 武汉', 'Chrome', 'Windows 10', '1', '密码输入错误4次', '2020-02-27 14:38:55');
INSERT INTO `admin_sys_logininfor` VALUES (2074, 'admin', '14.157.172.32', '广东 佛山', 'Chrome', 'Windows 10', '1', '密码输入错误5次', '2020-02-27 14:45:02');
INSERT INTO `admin_sys_logininfor` VALUES (2075, 'admin', '27.192.113.57', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-27 14:50:40');
INSERT INTO `admin_sys_logininfor` VALUES (2076, 'admin', '27.192.113.57', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-27 14:50:47');
INSERT INTO `admin_sys_logininfor` VALUES (2077, 'admin', '27.192.113.57', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-27 14:51:36');
INSERT INTO `admin_sys_logininfor` VALUES (2078, 'admin', '27.192.113.57', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-27 14:52:53');
INSERT INTO `admin_sys_logininfor` VALUES (2079, 'admin', '27.192.113.57', '山东 潍坊', 'Chrome', 'Windows 10', '1', '密码输入错误5次，帐户锁定10分钟', '2020-02-27 14:54:54');
INSERT INTO `admin_sys_logininfor` VALUES (2080, 'admin', '27.18.34.188', '湖北 武汉', 'Internet Explorer 11', 'Windows 10', '1', '验证码错误', '2020-02-27 15:17:55');
INSERT INTO `admin_sys_logininfor` VALUES (2081, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误1次', '2020-02-27 15:32:51');
INSERT INTO `admin_sys_logininfor` VALUES (2082, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误2次', '2020-02-27 15:32:57');
INSERT INTO `admin_sys_logininfor` VALUES (2083, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误1次', '2020-02-27 15:47:41');
INSERT INTO `admin_sys_logininfor` VALUES (2084, 'admin', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '1', '密码输入错误2次', '2020-02-27 15:47:51');
INSERT INTO `admin_sys_logininfor` VALUES (2085, 'admin', '111.18.98.147', '陕西 咸阳', 'Chrome 8', 'Windows 7', '1', '密码输入错误3次', '2020-02-27 15:48:05');
INSERT INTO `admin_sys_logininfor` VALUES (2086, 'ry', '111.18.98.147', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-27 15:56:56');
INSERT INTO `admin_sys_logininfor` VALUES (2087, 'admin', '39.78.181.250', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-02-27 16:01:19');
INSERT INTO `admin_sys_logininfor` VALUES (2088, 'admin', '39.78.181.250', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-02-27 16:02:12');
INSERT INTO `admin_sys_logininfor` VALUES (2089, 'admin', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-27 16:07:33');
INSERT INTO `admin_sys_logininfor` VALUES (2090, 'admin', '113.45.109.158', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 16:07:38');
INSERT INTO `admin_sys_logininfor` VALUES (2091, 'ry', '39.78.181.250', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 16:12:39');
INSERT INTO `admin_sys_logininfor` VALUES (2092, 'admin', '223.104.64.238', '广东 广州', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-02-27 16:28:46');
INSERT INTO `admin_sys_logininfor` VALUES (2093, 'admin', '223.104.64.238', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-02-27 16:28:53');
INSERT INTO `admin_sys_logininfor` VALUES (2094, 'ry', '39.78.181.250', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-27 16:46:26');
INSERT INTO `admin_sys_logininfor` VALUES (2095, 'admin', '175.11.85.230', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 17:01:40');
INSERT INTO `admin_sys_logininfor` VALUES (2096, 'admin', '114.222.210.178', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 17:08:21');
INSERT INTO `admin_sys_logininfor` VALUES (2097, 'admin', '115.58.224.42', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 17:09:19');
INSERT INTO `admin_sys_logininfor` VALUES (2098, 'admin', '115.58.224.42', '河南 平顶山', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-27 17:23:18');
INSERT INTO `admin_sys_logininfor` VALUES (2099, 'admin', '115.58.224.42', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 17:23:27');
INSERT INTO `admin_sys_logininfor` VALUES (2100, 'admin', '115.58.224.42', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-27 17:23:33');
INSERT INTO `admin_sys_logininfor` VALUES (2101, 'admin', '223.91.228.192', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 17:42:09');
INSERT INTO `admin_sys_logininfor` VALUES (2102, 'admin', '115.58.224.42', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 18:03:43');
INSERT INTO `admin_sys_logininfor` VALUES (2103, 'admin', '115.58.224.42', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-27 19:01:50');
INSERT INTO `admin_sys_logininfor` VALUES (2104, 'admin', '115.58.224.42', '河南 平顶山', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 19:01:54');
INSERT INTO `admin_sys_logininfor` VALUES (2105, 'admin', '36.148.67.102', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 19:50:23');
INSERT INTO `admin_sys_logininfor` VALUES (2106, 'admin', '43.227.139.70', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-27 20:31:59');
INSERT INTO `admin_sys_logininfor` VALUES (2107, 'admin', '113.91.55.150', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-02-27 20:37:13');
INSERT INTO `admin_sys_logininfor` VALUES (2108, 'admin', '113.91.55.150', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-27 20:37:19');
INSERT INTO `admin_sys_logininfor` VALUES (2109, 'admin', '121.228.159.44', '江苏 苏州', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-28 00:38:42');
INSERT INTO `admin_sys_logininfor` VALUES (2110, 'admin', '220.200.25.232', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-02-28 03:58:05');
INSERT INTO `admin_sys_logininfor` VALUES (2111, 'admin', '117.136.79.41', '广东 广州', 'Firefox 7', 'Mac OS X', '0', '登录成功', '2020-02-28 05:26:02');
INSERT INTO `admin_sys_logininfor` VALUES (2112, 'admin', '183.251.91.18', '福建 厦门', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-28 09:58:33');
INSERT INTO `admin_sys_logininfor` VALUES (2113, 'admin', '117.71.99.67', '安徽 宣城', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-28 10:24:23');
INSERT INTO `admin_sys_logininfor` VALUES (2114, 'admin', '171.217.92.76', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-28 10:59:18');
INSERT INTO `admin_sys_logininfor` VALUES (2115, 'admin', '14.120.101.64', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-28 12:00:47');
INSERT INTO `admin_sys_logininfor` VALUES (2116, 'admin', '14.120.101.64', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-28 12:00:51');
INSERT INTO `admin_sys_logininfor` VALUES (2117, 'admin', '115.58.224.42', '河南 平顶山', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-28 12:37:16');
INSERT INTO `admin_sys_logininfor` VALUES (2118, 'admin', '124.205.155.132', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-28 13:52:50');
INSERT INTO `admin_sys_logininfor` VALUES (2119, 'admin', '113.77.193.174', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-02-28 14:34:31');
INSERT INTO `admin_sys_logininfor` VALUES (2120, 'admin', '113.77.193.174', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-28 14:34:50');
INSERT INTO `admin_sys_logininfor` VALUES (2121, 'admin', '124.205.155.132', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-28 14:50:25');
INSERT INTO `admin_sys_logininfor` VALUES (2122, 'admin', '121.228.159.44', '江苏 苏州', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-28 15:37:20');
INSERT INTO `admin_sys_logininfor` VALUES (2123, 'admin', '121.228.159.44', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-28 15:39:14');
INSERT INTO `admin_sys_logininfor` VALUES (2124, 'admin', '14.152.102.147', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-28 19:12:17');
INSERT INTO `admin_sys_logininfor` VALUES (2125, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-28 19:34:21');
INSERT INTO `admin_sys_logininfor` VALUES (2126, 'admin', '27.193.247.253', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-28 20:21:08');
INSERT INTO `admin_sys_logininfor` VALUES (2127, 'admin', '27.193.247.253', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-28 20:21:08');
INSERT INTO `admin_sys_logininfor` VALUES (2128, 'admin', '58.243.250.219', '安徽 合肥', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-02-28 21:23:46');
INSERT INTO `admin_sys_logininfor` VALUES (2129, 'admin', '120.228.77.49', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-28 21:33:59');
INSERT INTO `admin_sys_logininfor` VALUES (2130, 'admin', '183.93.153.84', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-28 22:08:53');
INSERT INTO `admin_sys_logininfor` VALUES (2131, 'admin', '218.81.47.78', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-28 22:21:12');
INSERT INTO `admin_sys_logininfor` VALUES (2132, 'admin', '111.167.156.54', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-28 22:41:33');
INSERT INTO `admin_sys_logininfor` VALUES (2133, 'admin', '112.10.252.136', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-28 22:45:49');
INSERT INTO `admin_sys_logininfor` VALUES (2134, 'admin', '1.80.193.73', '陕西 西安', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-29 00:56:39');
INSERT INTO `admin_sys_logininfor` VALUES (2135, 'admin', '223.72.99.129', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-29 01:04:57');
INSERT INTO `admin_sys_logininfor` VALUES (2136, 'admin', '39.187.88.213', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-29 01:09:34');
INSERT INTO `admin_sys_logininfor` VALUES (2137, 'admin', '110.16.0.153', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-29 09:12:04');
INSERT INTO `admin_sys_logininfor` VALUES (2138, 'admin', '14.152.102.147', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-29 11:44:27');
INSERT INTO `admin_sys_logininfor` VALUES (2139, 'admin', '14.152.102.147', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-29 13:50:42');
INSERT INTO `admin_sys_logininfor` VALUES (2140, 'admin', '223.104.57.52', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-02-29 14:08:22');
INSERT INTO `admin_sys_logininfor` VALUES (2141, 'admin', '111.167.156.54', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-29 14:27:29');
INSERT INTO `admin_sys_logininfor` VALUES (2142, 'admin', '14.152.102.147', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-29 14:56:37');
INSERT INTO `admin_sys_logininfor` VALUES (2143, 'admin', '175.10.87.28', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-29 16:10:12');
INSERT INTO `admin_sys_logininfor` VALUES (2144, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-29 16:23:25');
INSERT INTO `admin_sys_logininfor` VALUES (2145, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '0', '退出成功', '2020-02-29 16:23:49');
INSERT INTO `admin_sys_logininfor` VALUES (2146, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-29 16:42:34');
INSERT INTO `admin_sys_logininfor` VALUES (2147, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-29 16:42:37');
INSERT INTO `admin_sys_logininfor` VALUES (2148, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-29 16:42:43');
INSERT INTO `admin_sys_logininfor` VALUES (2149, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-29 16:42:50');
INSERT INTO `admin_sys_logininfor` VALUES (2150, 'admin', '27.17.203.125', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-29 16:43:01');
INSERT INTO `admin_sys_logininfor` VALUES (2151, 'admin', '111.167.156.54', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-29 17:03:59');
INSERT INTO `admin_sys_logininfor` VALUES (2152, 'admin', '183.197.158.85', '河北 廊坊', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-02-29 17:19:37');
INSERT INTO `admin_sys_logininfor` VALUES (2153, 'admin', '101.72.49.233', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-29 17:41:32');
INSERT INTO `admin_sys_logininfor` VALUES (2154, 'admin', '222.240.95.210', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-02-29 18:22:49');
INSERT INTO `admin_sys_logininfor` VALUES (2155, 'admin', '222.240.95.210', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-29 18:22:53');
INSERT INTO `admin_sys_logininfor` VALUES (2156, 'yt', '113.75.161.58', 'XX XX', 'Chrome', 'Windows 10', '1', '用户不存在/密码错误', '2020-02-29 18:31:46');
INSERT INTO `admin_sys_logininfor` VALUES (2157, 'ry', '113.75.161.58', '广东 韶关', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-29 18:32:27');
INSERT INTO `admin_sys_logininfor` VALUES (2158, 'admin', '113.75.161.58', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-02-29 18:33:56');
INSERT INTO `admin_sys_logininfor` VALUES (2159, 'admin', '113.75.161.58', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-02-29 18:34:01');
INSERT INTO `admin_sys_logininfor` VALUES (2160, 'admin', '101.72.49.233', '河北 廊坊', 'Chrome', 'Windows 10', '0', '退出成功', '2020-02-29 18:42:45');
INSERT INTO `admin_sys_logininfor` VALUES (2161, 'admin', '101.72.49.233', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-02-29 18:54:20');
INSERT INTO `admin_sys_logininfor` VALUES (2162, 'admin', '111.167.156.54', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-02-29 19:13:53');
INSERT INTO `admin_sys_logininfor` VALUES (2163, 'admin', '223.97.9.88', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-29 20:35:36');
INSERT INTO `admin_sys_logininfor` VALUES (2164, 'admin', '120.239.64.46', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-02-29 22:05:37');
INSERT INTO `admin_sys_logininfor` VALUES (2165, 'admin', '1.86.240.47', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-02-29 22:22:34');
INSERT INTO `admin_sys_logininfor` VALUES (2166, 'admin', '125.210.247.63', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-01 12:47:31');
INSERT INTO `admin_sys_logininfor` VALUES (2167, 'admin', '125.210.247.63', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-01 12:48:54');
INSERT INTO `admin_sys_logininfor` VALUES (2168, 'admin', '211.161.245.45', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-01 13:57:22');
INSERT INTO `admin_sys_logininfor` VALUES (2169, 'admin', '211.161.245.45', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-01 13:57:26');
INSERT INTO `admin_sys_logininfor` VALUES (2170, 'admin', '211.161.245.45', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-01 13:57:31');
INSERT INTO `admin_sys_logininfor` VALUES (2171, 'admin', '211.161.245.45', '上海 上海', 'Chrome 8', 'Windows 10', '0', '退出成功', '2020-03-01 13:59:03');
INSERT INTO `admin_sys_logininfor` VALUES (2172, 'admin', '223.104.3.32', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-01 14:17:32');
INSERT INTO `admin_sys_logininfor` VALUES (2173, 'admin', '223.104.145.21', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 14:36:41');
INSERT INTO `admin_sys_logininfor` VALUES (2174, 'admin', '223.104.145.21', '江苏 无锡', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-01 14:36:49');
INSERT INTO `admin_sys_logininfor` VALUES (2175, 'admin', '111.163.243.71', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-03-01 14:41:09');
INSERT INTO `admin_sys_logininfor` VALUES (2176, 'admin', '111.163.243.71', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-01 14:41:22');
INSERT INTO `admin_sys_logininfor` VALUES (2177, 'admin', '125.62.5.193', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-01 14:51:53');
INSERT INTO `admin_sys_logininfor` VALUES (2178, 'admin', '111.167.156.54', '天津 天津', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-01 16:43:24');
INSERT INTO `admin_sys_logininfor` VALUES (2179, 'admin', '111.167.156.54', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-01 17:05:38');
INSERT INTO `admin_sys_logininfor` VALUES (2180, 'admin', '101.249.48.226', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-01 17:16:01');
INSERT INTO `admin_sys_logininfor` VALUES (2181, 'admin', '223.90.106.75', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-01 18:16:35');
INSERT INTO `admin_sys_logininfor` VALUES (2182, 'admin', '223.90.106.75', 'XX XX', 'Safari', 'Mac OS X', '1', '验证码错误', '2020-03-01 18:16:38');
INSERT INTO `admin_sys_logininfor` VALUES (2183, 'admin', '110.153.250.45', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-01 19:57:19');
INSERT INTO `admin_sys_logininfor` VALUES (2184, 'admin', '117.136.40.16', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:32:49');
INSERT INTO `admin_sys_logininfor` VALUES (2185, 'admin', '117.136.40.16', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:11');
INSERT INTO `admin_sys_logininfor` VALUES (2186, 'admin', '117.136.40.16', '广东 XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:18');
INSERT INTO `admin_sys_logininfor` VALUES (2187, 'admin', '117.136.40.16', '广东 XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:20');
INSERT INTO `admin_sys_logininfor` VALUES (2188, 'admin', '117.136.40.16', '广东 XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:21');
INSERT INTO `admin_sys_logininfor` VALUES (2189, 'admin', '117.136.40.16', '广东 XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:22');
INSERT INTO `admin_sys_logininfor` VALUES (2190, 'admin', '117.136.40.16', '广东 XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:23');
INSERT INTO `admin_sys_logininfor` VALUES (2191, 'admin', '117.136.40.16', '广东 XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:24');
INSERT INTO `admin_sys_logininfor` VALUES (2192, 'admin', '117.136.40.16', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-01 20:33:44');
INSERT INTO `admin_sys_logininfor` VALUES (2193, 'admin', '36.157.3.215', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-01 22:31:48');
INSERT INTO `admin_sys_logininfor` VALUES (2194, 'admin', '121.32.170.175', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-02 07:55:59');
INSERT INTO `admin_sys_logininfor` VALUES (2195, 'admin', '183.250.190.147', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-02 08:53:22');
INSERT INTO `admin_sys_logininfor` VALUES (2196, 'admin', '113.81.227.4', '广东 深圳', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-02 10:20:31');
INSERT INTO `admin_sys_logininfor` VALUES (2197, 'admin', '14.152.102.147', '广东 东莞', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-02 10:23:50');
INSERT INTO `admin_sys_logininfor` VALUES (2198, 'admin', '39.169.176.177', '江西 宜春', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-02 11:02:28');
INSERT INTO `admin_sys_logininfor` VALUES (2199, 'admin', '43.227.136.8', '湖北 武汉', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-02 11:22:08');
INSERT INTO `admin_sys_logininfor` VALUES (2200, 'admin', '111.167.156.54', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-02 12:33:43');
INSERT INTO `admin_sys_logininfor` VALUES (2201, 'admin', '121.28.95.157', 'XX XX', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-03-02 14:03:51');
INSERT INTO `admin_sys_logininfor` VALUES (2202, 'admin', '121.28.95.157', 'XX XX', 'Chrome', 'Windows 8.1', '0', '退出成功', '2020-03-02 14:08:44');
INSERT INTO `admin_sys_logininfor` VALUES (2203, 'admin', '114.242.248.122', '北京 北京', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-02 14:53:20');
INSERT INTO `admin_sys_logininfor` VALUES (2204, 'admin', '183.17.125.49', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-02 15:51:23');
INSERT INTO `admin_sys_logininfor` VALUES (2205, 'admin', '39.130.59.169', '云南 昆明', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-02 18:04:58');
INSERT INTO `admin_sys_logininfor` VALUES (2206, 'admin', '39.130.59.169', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-02 18:48:21');
INSERT INTO `admin_sys_logininfor` VALUES (2207, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-02 19:24:42');
INSERT INTO `admin_sys_logininfor` VALUES (2208, 'admin', '112.48.37.214', '福建 厦门', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-03-02 20:25:00');
INSERT INTO `admin_sys_logininfor` VALUES (2209, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-02 21:18:36');
INSERT INTO `admin_sys_logininfor` VALUES (2210, 'admin', '125.210.247.2', '福建 福州', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-02 21:54:37');
INSERT INTO `admin_sys_logininfor` VALUES (2211, 'admin', '125.210.247.2', 'XX XX', 'Chrome 8', 'Windows 7', '0', '退出成功', '2020-03-02 21:54:55');
INSERT INTO `admin_sys_logininfor` VALUES (2212, 'admin', '39.166.104.123', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-03 00:26:22');
INSERT INTO `admin_sys_logininfor` VALUES (2213, 'admin', '117.151.109.75', '湖北 武汉', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 01:23:01');
INSERT INTO `admin_sys_logininfor` VALUES (2214, 'admin', '117.151.109.75', '湖北 武汉', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-03-03 01:25:54');
INSERT INTO `admin_sys_logininfor` VALUES (2215, 'admin', '117.151.109.75', '湖北 武汉', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-03-03 01:25:59');
INSERT INTO `admin_sys_logininfor` VALUES (2216, 'admin', '117.151.109.75', '湖北 武汉', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 01:26:05');
INSERT INTO `admin_sys_logininfor` VALUES (2217, 'admin', '124.64.17.177', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 03:54:13');
INSERT INTO `admin_sys_logininfor` VALUES (2218, 'admin', '124.64.17.177', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-03 04:09:15');
INSERT INTO `admin_sys_logininfor` VALUES (2219, 'admin', '223.82.0.171', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-03 08:53:52');
INSERT INTO `admin_sys_logininfor` VALUES (2220, 'admin', '223.82.0.171', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-03 08:53:55');
INSERT INTO `admin_sys_logininfor` VALUES (2221, 'admin', '223.82.0.171', '江西 赣州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 08:54:58');
INSERT INTO `admin_sys_logininfor` VALUES (2222, 'admin', '58.213.127.2', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-03 09:26:22');
INSERT INTO `admin_sys_logininfor` VALUES (2223, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 11:49:44');
INSERT INTO `admin_sys_logininfor` VALUES (2224, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-03 11:52:04');
INSERT INTO `admin_sys_logininfor` VALUES (2225, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 11:52:11');
INSERT INTO `admin_sys_logininfor` VALUES (2226, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-03 11:54:52');
INSERT INTO `admin_sys_logininfor` VALUES (2227, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 11:54:56');
INSERT INTO `admin_sys_logininfor` VALUES (2228, 'admin', '222.68.134.217', '上海 上海', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 12:03:31');
INSERT INTO `admin_sys_logininfor` VALUES (2229, 'admin', '117.135.239.32', '贵州 遵义', 'Internet Explorer 11', 'Windows 10', '1', '验证码错误', '2020-03-03 12:46:01');
INSERT INTO `admin_sys_logininfor` VALUES (2230, 'admin', '117.135.239.32', '贵州 遵义', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-03-03 12:46:09');
INSERT INTO `admin_sys_logininfor` VALUES (2231, 'admin', '111.167.156.54', '天津 天津', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-03 13:58:53');
INSERT INTO `admin_sys_logininfor` VALUES (2232, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 14:01:43');
INSERT INTO `admin_sys_logininfor` VALUES (2233, 'admin', '1.86.245.115', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 14:09:19');
INSERT INTO `admin_sys_logininfor` VALUES (2234, 'admin', '117.64.158.128', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-03-03 14:17:39');
INSERT INTO `admin_sys_logininfor` VALUES (2235, 'admin', '125.122.209.193', '浙江 杭州', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-03 14:33:09');
INSERT INTO `admin_sys_logininfor` VALUES (2236, 'admin', '117.135.239.32', '贵州 遵义', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-03-03 14:38:30');
INSERT INTO `admin_sys_logininfor` VALUES (2237, 'admin', '218.22.24.22', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-03 14:45:13');
INSERT INTO `admin_sys_logininfor` VALUES (2238, 'admin', '218.22.24.22', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 14:46:06');
INSERT INTO `admin_sys_logininfor` VALUES (2239, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 14:46:11');
INSERT INTO `admin_sys_logininfor` VALUES (2240, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-03 14:57:22');
INSERT INTO `admin_sys_logininfor` VALUES (2241, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 14:57:28');
INSERT INTO `admin_sys_logininfor` VALUES (2242, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 15:06:01');
INSERT INTO `admin_sys_logininfor` VALUES (2243, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 15:13:49');
INSERT INTO `admin_sys_logininfor` VALUES (2244, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 15:17:05');
INSERT INTO `admin_sys_logininfor` VALUES (2245, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 15:18:53');
INSERT INTO `admin_sys_logininfor` VALUES (2246, 'admin', '122.96.43.125', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-03 15:21:35');
INSERT INTO `admin_sys_logininfor` VALUES (2247, 'admin', '153.37.196.114', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 15:22:58');
INSERT INTO `admin_sys_logininfor` VALUES (2248, 'admin', '112.96.176.50', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-03 15:33:04');
INSERT INTO `admin_sys_logininfor` VALUES (2249, 'admin', '112.96.176.50', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-03 15:33:09');
INSERT INTO `admin_sys_logininfor` VALUES (2250, 'admin', '223.88.83.33', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 15:59:13');
INSERT INTO `admin_sys_logininfor` VALUES (2251, 'admin', '61.49.113.26', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-03 16:16:49');
INSERT INTO `admin_sys_logininfor` VALUES (2252, 'admin', '112.96.176.50', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-03 16:17:11');
INSERT INTO `admin_sys_logininfor` VALUES (2253, 'admin', '125.122.209.193', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-03 16:24:29');
INSERT INTO `admin_sys_logininfor` VALUES (2254, 'admin', '223.88.83.33', '河南 郑州', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-03 16:57:16');
INSERT INTO `admin_sys_logininfor` VALUES (2255, 'admin', '223.88.83.33', '河南 郑州', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-03 16:57:21');
INSERT INTO `admin_sys_logininfor` VALUES (2256, 'admin', '223.88.83.33', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 17:10:20');
INSERT INTO `admin_sys_logininfor` VALUES (2257, 'admin', '60.189.100.54', '浙江 台州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 17:13:56');
INSERT INTO `admin_sys_logininfor` VALUES (2258, 'admin', '119.123.76.184', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 17:42:50');
INSERT INTO `admin_sys_logininfor` VALUES (2259, 'admin', '183.236.72.244', 'XX XX', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-03-03 17:44:33');
INSERT INTO `admin_sys_logininfor` VALUES (2260, 'admin', '219.133.100.93', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-03-03 17:47:41');
INSERT INTO `admin_sys_logininfor` VALUES (2261, 'admin', '219.133.100.93', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-03 17:47:47');
INSERT INTO `admin_sys_logininfor` VALUES (2262, 'admin', '211.95.59.229', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-03 18:26:30');
INSERT INTO `admin_sys_logininfor` VALUES (2263, 'admin', '113.45.90.22', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 18:39:06');
INSERT INTO `admin_sys_logininfor` VALUES (2264, 'admin', '113.45.90.22', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-03 18:39:30');
INSERT INTO `admin_sys_logininfor` VALUES (2265, 'admin', '113.45.90.22', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 18:39:33');
INSERT INTO `admin_sys_logininfor` VALUES (2266, 'admin', '113.45.90.22', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-03 18:40:58');
INSERT INTO `admin_sys_logininfor` VALUES (2267, 'admin', '113.45.90.22', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 18:41:03');
INSERT INTO `admin_sys_logininfor` VALUES (2268, 'admin', '219.133.100.93', 'XX XX', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-03-03 19:03:37');
INSERT INTO `admin_sys_logininfor` VALUES (2269, 'admin', '219.133.100.93', '广东 深圳', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-03 19:03:41');
INSERT INTO `admin_sys_logininfor` VALUES (2270, 'admin', '124.235.163.22', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 19:44:19');
INSERT INTO `admin_sys_logininfor` VALUES (2271, 'admin', '124.235.163.22', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-03 19:44:20');
INSERT INTO `admin_sys_logininfor` VALUES (2272, 'admin', '119.179.87.175', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-03 21:47:40');
INSERT INTO `admin_sys_logininfor` VALUES (2273, 'admin', '119.179.87.175', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-03 21:47:48');
INSERT INTO `admin_sys_logininfor` VALUES (2274, 'admin', '117.136.8.153', '上海 上海', 'Chrome Mobile', 'Android 5.x', '1', '验证码错误', '2020-03-03 22:21:29');
INSERT INTO `admin_sys_logininfor` VALUES (2275, 'admin', '117.136.8.153', 'XX XX', 'Chrome Mobile', 'Android 5.x', '1', '验证码错误', '2020-03-03 22:21:55');
INSERT INTO `admin_sys_logininfor` VALUES (2276, 'admin', '117.136.8.153', 'XX XX', 'Chrome Mobile', 'Android 5.x', '0', '登录成功', '2020-03-03 22:22:02');
INSERT INTO `admin_sys_logininfor` VALUES (2277, 'admin', '116.233.208.243', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-03 23:03:32');
INSERT INTO `admin_sys_logininfor` VALUES (2278, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 00:55:29');
INSERT INTO `admin_sys_logininfor` VALUES (2279, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 01:13:25');
INSERT INTO `admin_sys_logininfor` VALUES (2280, 'admin', '111.36.196.227', '山东 临沂', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-04 05:19:59');
INSERT INTO `admin_sys_logininfor` VALUES (2281, 'admin', '111.36.196.227', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-04 05:20:05');
INSERT INTO `admin_sys_logininfor` VALUES (2282, 'admin', '223.20.201.51', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 05:57:23');
INSERT INTO `admin_sys_logininfor` VALUES (2283, 'admin', '112.5.168.249', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 08:24:01');
INSERT INTO `admin_sys_logininfor` VALUES (2284, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 09:18:24');
INSERT INTO `admin_sys_logininfor` VALUES (2285, 'admin', '117.41.0.38', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-04 09:22:47');
INSERT INTO `admin_sys_logininfor` VALUES (2286, 'admin', '59.55.142.208', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-04 09:25:47');
INSERT INTO `admin_sys_logininfor` VALUES (2287, 'admin', '183.213.121.244', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 09:37:11');
INSERT INTO `admin_sys_logininfor` VALUES (2288, 'admin', '112.96.164.30', '广东 广州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 09:43:53');
INSERT INTO `admin_sys_logininfor` VALUES (2289, 'admin', '219.137.140.166', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-04 10:03:45');
INSERT INTO `admin_sys_logininfor` VALUES (2290, 'admin', '219.137.140.166', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 10:03:54');
INSERT INTO `admin_sys_logininfor` VALUES (2291, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 10:05:51');
INSERT INTO `admin_sys_logininfor` VALUES (2292, 'admin', '113.117.13.123', '广东 揭阳', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-04 10:19:02');
INSERT INTO `admin_sys_logininfor` VALUES (2293, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 10:24:44');
INSERT INTO `admin_sys_logininfor` VALUES (2294, 'admin', '219.133.101.183', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-04 10:32:44');
INSERT INTO `admin_sys_logininfor` VALUES (2295, 'admin', '220.160.86.227', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-04 10:42:51');
INSERT INTO `admin_sys_logininfor` VALUES (2296, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-04 10:56:39');
INSERT INTO `admin_sys_logininfor` VALUES (2297, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 10:56:48');
INSERT INTO `admin_sys_logininfor` VALUES (2298, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 11:29:48');
INSERT INTO `admin_sys_logininfor` VALUES (2299, 'admin', '113.69.136.215', '广东 佛山', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 11:33:38');
INSERT INTO `admin_sys_logininfor` VALUES (2300, 'admin', '223.88.83.33', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-04 13:19:21');
INSERT INTO `admin_sys_logininfor` VALUES (2301, 'admin', '222.212.7.161', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 13:53:31');
INSERT INTO `admin_sys_logininfor` VALUES (2302, 'admin', '117.150.183.43', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-04 14:09:07');
INSERT INTO `admin_sys_logininfor` VALUES (2303, 'admin', '117.150.183.43', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 14:09:11');
INSERT INTO `admin_sys_logininfor` VALUES (2304, 'admin', '223.88.83.33', '河南 郑州', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-04 15:12:17');
INSERT INTO `admin_sys_logininfor` VALUES (2305, 'admin', '222.183.238.240', 'XX XX', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-04 16:38:19');
INSERT INTO `admin_sys_logininfor` VALUES (2306, 'admin', '115.192.144.218', 'XX XX', 'Microsoft Edge', 'Windows 10', '1', '验证码错误', '2020-03-04 16:39:23');
INSERT INTO `admin_sys_logininfor` VALUES (2307, 'admin', '115.192.144.218', 'XX XX', 'Microsoft Edge', 'Windows 10', '1', '验证码错误', '2020-03-04 16:39:25');
INSERT INTO `admin_sys_logininfor` VALUES (2308, 'admin', '115.192.144.218', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 16:39:45');
INSERT INTO `admin_sys_logininfor` VALUES (2309, 'admin', '60.213.243.106', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-04 16:42:18');
INSERT INTO `admin_sys_logininfor` VALUES (2310, 'admin', '120.236.247.199', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 16:43:33');
INSERT INTO `admin_sys_logininfor` VALUES (2311, 'admin', '60.213.243.106', '山东 聊城', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 17:01:51');
INSERT INTO `admin_sys_logininfor` VALUES (2312, 'admin', '115.197.39.216', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 17:04:03');
INSERT INTO `admin_sys_logininfor` VALUES (2313, 'admin', '113.118.224.181', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-04 17:21:57');
INSERT INTO `admin_sys_logininfor` VALUES (2314, 'admin', '119.137.55.193', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 17:26:03');
INSERT INTO `admin_sys_logininfor` VALUES (2315, 'admin', '218.88.91.3', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 17:46:17');
INSERT INTO `admin_sys_logininfor` VALUES (2316, 'admin', '183.37.152.172', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 17:46:42');
INSERT INTO `admin_sys_logininfor` VALUES (2317, 'admin', '125.40.66.149', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 18:19:51');
INSERT INTO `admin_sys_logininfor` VALUES (2318, 'admin', '42.236.202.141', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 18:21:04');
INSERT INTO `admin_sys_logininfor` VALUES (2319, 'admin', '183.37.152.172', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 18:37:27');
INSERT INTO `admin_sys_logininfor` VALUES (2320, 'admin', '183.37.152.172', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-04 18:37:29');
INSERT INTO `admin_sys_logininfor` VALUES (2321, 'admin', '42.236.202.141', '河南 郑州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-04 18:46:53');
INSERT INTO `admin_sys_logininfor` VALUES (2322, 'admin', '42.236.202.141', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 18:47:00');
INSERT INTO `admin_sys_logininfor` VALUES (2323, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 19:08:07');
INSERT INTO `admin_sys_logininfor` VALUES (2324, 'admin', '113.2.117.105', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-03-04 19:56:05');
INSERT INTO `admin_sys_logininfor` VALUES (2325, 'admin', '113.2.117.105', '黑龙江 绥化', 'Chrome', 'Windows 8.1', '0', '登录成功', '2020-03-04 19:57:21');
INSERT INTO `admin_sys_logininfor` VALUES (2326, 'admin', '123.233.109.234', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-04 20:19:25');
INSERT INTO `admin_sys_logininfor` VALUES (2327, 'admin', '123.233.109.234', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-04 20:19:28');
INSERT INTO `admin_sys_logininfor` VALUES (2328, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 20:20:33');
INSERT INTO `admin_sys_logininfor` VALUES (2329, 'admin', '119.126.104.168', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-03-04 20:36:48');
INSERT INTO `admin_sys_logininfor` VALUES (2330, 'admin', '119.126.104.168', 'XX XX', 'Chrome', 'Mac OS X', '0', '退出成功', '2020-03-04 20:39:03');
INSERT INTO `admin_sys_logininfor` VALUES (2331, 'admin', '27.155.199.163', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-04 22:18:45');
INSERT INTO `admin_sys_logininfor` VALUES (2332, 'admin', '222.212.40.113', '四川 成都', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-03-04 23:37:32');
INSERT INTO `admin_sys_logininfor` VALUES (2333, 'admin', '115.171.84.238', '北京 北京', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-05 00:03:35');
INSERT INTO `admin_sys_logininfor` VALUES (2334, 'admin', '120.244.114.231', '北京 北京', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-05 09:10:31');
INSERT INTO `admin_sys_logininfor` VALUES (2335, 'admin', '117.30.38.102', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 09:11:30');
INSERT INTO `admin_sys_logininfor` VALUES (2336, 'admin', '113.64.112.27', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-05 09:32:50');
INSERT INTO `admin_sys_logininfor` VALUES (2337, 'admin', '222.182.199.188', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-05 09:37:33');
INSERT INTO `admin_sys_logininfor` VALUES (2338, 'admin', '222.182.199.188', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-05 09:37:36');
INSERT INTO `admin_sys_logininfor` VALUES (2339, 'admin', '222.182.199.188', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 09:38:51');
INSERT INTO `admin_sys_logininfor` VALUES (2340, 'admin', '210.22.80.142', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-05 10:03:22');
INSERT INTO `admin_sys_logininfor` VALUES (2341, 'admin', '223.104.247.5', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-05 11:15:14');
INSERT INTO `admin_sys_logininfor` VALUES (2342, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 12:44:44');
INSERT INTO `admin_sys_logininfor` VALUES (2343, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-05 12:51:06');
INSERT INTO `admin_sys_logininfor` VALUES (2344, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-05 12:51:11');
INSERT INTO `admin_sys_logininfor` VALUES (2345, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 12:51:15');
INSERT INTO `admin_sys_logininfor` VALUES (2346, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 13:08:35');
INSERT INTO `admin_sys_logininfor` VALUES (2347, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 13:11:10');
INSERT INTO `admin_sys_logininfor` VALUES (2348, 'admin', '42.236.202.141', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 13:50:36');
INSERT INTO `admin_sys_logininfor` VALUES (2349, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 13:50:46');
INSERT INTO `admin_sys_logininfor` VALUES (2350, 'admin', '122.236.107.119', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-05 14:06:35');
INSERT INTO `admin_sys_logininfor` VALUES (2351, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:08:43');
INSERT INTO `admin_sys_logininfor` VALUES (2352, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:15:25');
INSERT INTO `admin_sys_logininfor` VALUES (2353, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:26:40');
INSERT INTO `admin_sys_logininfor` VALUES (2354, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:32:08');
INSERT INTO `admin_sys_logininfor` VALUES (2355, 'admin', '117.22.29.161', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:34:35');
INSERT INTO `admin_sys_logininfor` VALUES (2356, 'admin', '113.45.90.22', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:38:39');
INSERT INTO `admin_sys_logininfor` VALUES (2357, 'ry', '113.45.90.22', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:42:38');
INSERT INTO `admin_sys_logininfor` VALUES (2358, 'ry', '42.236.202.141', '河南 郑州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 14:43:49');
INSERT INTO `admin_sys_logininfor` VALUES (2359, 'ry', '125.119.253.200', '浙江 杭州', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-05 15:17:45');
INSERT INTO `admin_sys_logininfor` VALUES (2360, 'ry', '123.118.134.145', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 15:24:16');
INSERT INTO `admin_sys_logininfor` VALUES (2361, 'admin', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 15:26:11');
INSERT INTO `admin_sys_logininfor` VALUES (2362, 'ry', '117.152.89.255', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-05 16:10:30');
INSERT INTO `admin_sys_logininfor` VALUES (2363, 'ry', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-05 16:14:30');
INSERT INTO `admin_sys_logininfor` VALUES (2364, 'ry', '113.116.50.188', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 16:24:46');
INSERT INTO `admin_sys_logininfor` VALUES (2365, 'ry', '125.120.47.219', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-05 16:26:38');
INSERT INTO `admin_sys_logininfor` VALUES (2366, 'ry', '125.120.47.219', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-05 16:26:49');
INSERT INTO `admin_sys_logininfor` VALUES (2367, 'ry', '113.64.112.27', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-05 16:33:50');
INSERT INTO `admin_sys_logininfor` VALUES (2368, 'ry', '36.25.106.151', '浙江 金华', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 16:35:53');
INSERT INTO `admin_sys_logininfor` VALUES (2369, 'ry', '106.47.29.55', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-05 16:41:53');
INSERT INTO `admin_sys_logininfor` VALUES (2370, 'ry', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-05 16:56:27');
INSERT INTO `admin_sys_logininfor` VALUES (2371, 'ry', '122.236.107.119', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-05 17:08:09');
INSERT INTO `admin_sys_logininfor` VALUES (2372, 'ry', '27.17.121.81', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-03-05 17:44:20');
INSERT INTO `admin_sys_logininfor` VALUES (2373, 'ry', '58.216.203.34', '江苏 常州', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-05 18:05:41');
INSERT INTO `admin_sys_logininfor` VALUES (2374, 'ry', '120.230.124.192', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-05 20:16:50');
INSERT INTO `admin_sys_logininfor` VALUES (2375, 'ry', '120.230.124.192', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 20:16:58');
INSERT INTO `admin_sys_logininfor` VALUES (2376, 'ry', '120.32.40.99', '福建 福州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-05 20:41:07');
INSERT INTO `admin_sys_logininfor` VALUES (2377, 'ry', '120.230.124.192', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 20:51:13');
INSERT INTO `admin_sys_logininfor` VALUES (2378, 'ry', '183.226.250.35', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 21:25:55');
INSERT INTO `admin_sys_logininfor` VALUES (2379, 'ry', '183.226.250.35', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-05 21:29:57');
INSERT INTO `admin_sys_logininfor` VALUES (2380, 'ry', '183.192.99.228', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-05 21:43:22');
INSERT INTO `admin_sys_logininfor` VALUES (2381, 'ry', '183.192.99.228', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '退出成功', '2020-03-05 21:45:58');
INSERT INTO `admin_sys_logininfor` VALUES (2382, 'ry', '124.235.163.22', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-05 21:50:06');
INSERT INTO `admin_sys_logininfor` VALUES (2383, 'ry', '124.235.163.22', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-05 21:50:11');
INSERT INTO `admin_sys_logininfor` VALUES (2384, 'ry', '124.235.163.22', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-05 21:53:36');
INSERT INTO `admin_sys_logininfor` VALUES (2385, 'admin', '124.235.163.22', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-05 21:54:04');
INSERT INTO `admin_sys_logininfor` VALUES (2386, 'ry', '60.9.111.39', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-05 23:14:15');
INSERT INTO `admin_sys_logininfor` VALUES (2387, 'ry', '182.200.209.15', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-06 00:38:43');
INSERT INTO `admin_sys_logininfor` VALUES (2388, 'ry', '58.18.66.180', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-06 00:43:23');
INSERT INTO `admin_sys_logininfor` VALUES (2389, 'ry', '182.200.209.15', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-06 00:50:15');
INSERT INTO `admin_sys_logininfor` VALUES (2390, 'ry', '182.200.209.15', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-06 00:50:23');
INSERT INTO `admin_sys_logininfor` VALUES (2391, 'ry', '182.200.209.15', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-06 00:50:28');
INSERT INTO `admin_sys_logininfor` VALUES (2392, 'ry', '42.236.202.141', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 03:17:50');
INSERT INTO `admin_sys_logininfor` VALUES (2393, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 08:23:51');
INSERT INTO `admin_sys_logininfor` VALUES (2394, 'ry', '117.136.19.213', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-06 08:50:31');
INSERT INTO `admin_sys_logininfor` VALUES (2395, 'ry', '223.104.247.6', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-06 09:12:31');
INSERT INTO `admin_sys_logininfor` VALUES (2396, 'ry', '219.137.142.106', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-06 09:26:24');
INSERT INTO `admin_sys_logininfor` VALUES (2397, 'ry', '219.137.142.106', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 09:26:31');
INSERT INTO `admin_sys_logininfor` VALUES (2398, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-06 09:44:49');
INSERT INTO `admin_sys_logininfor` VALUES (2399, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 09:45:21');
INSERT INTO `admin_sys_logininfor` VALUES (2400, 'ry', '219.137.142.106', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-03-06 09:49:42');
INSERT INTO `admin_sys_logininfor` VALUES (2401, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 09:52:54');
INSERT INTO `admin_sys_logininfor` VALUES (2402, 'ry', '223.104.96.53', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-06 10:07:05');
INSERT INTO `admin_sys_logininfor` VALUES (2403, 'ry', '223.104.96.53', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 10:07:12');
INSERT INTO `admin_sys_logininfor` VALUES (2404, 'ry', '219.137.142.106', 'XX XX', 'Firefox 7', 'Mac OS X', '1', '验证码错误', '2020-03-06 10:26:53');
INSERT INTO `admin_sys_logininfor` VALUES (2405, 'ry', '219.137.142.106', 'XX XX', 'Firefox 7', 'Mac OS X', '1', '验证码错误', '2020-03-06 10:26:58');
INSERT INTO `admin_sys_logininfor` VALUES (2406, 'ry', '219.137.142.106', 'XX XX', 'Firefox 7', 'Mac OS X', '0', '登录成功', '2020-03-06 10:27:05');
INSERT INTO `admin_sys_logininfor` VALUES (2407, 'ry', '219.137.142.106', 'XX XX', 'Firefox 7', 'Mac OS X', '0', '登录成功', '2020-03-06 10:27:24');
INSERT INTO `admin_sys_logininfor` VALUES (2408, 'ry', '219.137.140.52', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-06 10:30:03');
INSERT INTO `admin_sys_logininfor` VALUES (2409, 'ry', '171.41.69.74', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 11:26:26');
INSERT INTO `admin_sys_logininfor` VALUES (2410, 'ry', '14.223.183.184', 'XX XX', 'Chrome', 'Mac OS X', '0', '登录成功', '2020-03-06 12:02:13');
INSERT INTO `admin_sys_logininfor` VALUES (2411, 'ry', '14.223.183.184', 'XX XX', 'Chrome', 'Mac OS X', '0', '退出成功', '2020-03-06 12:03:35');
INSERT INTO `admin_sys_logininfor` VALUES (2412, 'ry', '223.104.247.5', 'XX XX', 'Chrome Mobile', 'Android 1.x', '1', '验证码错误', '2020-03-06 12:53:13');
INSERT INTO `admin_sys_logininfor` VALUES (2413, 'ry', '223.104.247.5', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-06 12:53:22');
INSERT INTO `admin_sys_logininfor` VALUES (2414, 'ry', '175.189.50.232', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-06 13:03:21');
INSERT INTO `admin_sys_logininfor` VALUES (2415, 'ry', '183.248.80.234', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-06 13:04:41');
INSERT INTO `admin_sys_logininfor` VALUES (2416, 'ry', '183.248.80.234', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-06 13:04:51');
INSERT INTO `admin_sys_logininfor` VALUES (2417, 'ry', '211.97.131.190', '福建 厦门', 'Unknown', 'Android', '0', '登录成功', '2020-03-06 14:53:08');
INSERT INTO `admin_sys_logininfor` VALUES (2418, 'ry', '113.16.60.41', '广西 南宁', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 15:04:59');
INSERT INTO `admin_sys_logininfor` VALUES (2419, 'ry', '125.71.89.4', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 15:09:22');
INSERT INTO `admin_sys_logininfor` VALUES (2420, 'ry', '120.230.103.2', '广东 广州', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-06 21:22:24');
INSERT INTO `admin_sys_logininfor` VALUES (2421, 'ry', '112.254.115.172', '山东 青岛', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-06 22:14:55');
INSERT INTO `admin_sys_logininfor` VALUES (2422, 'ry', '111.37.130.125', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-06 22:28:20');
INSERT INTO `admin_sys_logininfor` VALUES (2423, 'ry', '223.104.213.91', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-06 22:48:42');
INSERT INTO `admin_sys_logininfor` VALUES (2424, 'ry', '113.139.193.141', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-06 23:28:27');
INSERT INTO `admin_sys_logininfor` VALUES (2425, 'ry', '183.200.51.172', 'XX XX', 'Chrome Mobile', 'Android 6.x', '1', '验证码错误', '2020-03-07 02:58:50');
INSERT INTO `admin_sys_logininfor` VALUES (2426, 'ry', '183.200.51.172', 'XX XX', 'Chrome Mobile', 'Android 6.x', '0', '登录成功', '2020-03-07 02:58:55');
INSERT INTO `admin_sys_logininfor` VALUES (2427, 'ry', '222.72.80.69', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-07 03:46:25');
INSERT INTO `admin_sys_logininfor` VALUES (2428, 'ry', '222.72.80.69', '上海 上海', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-07 04:24:29');
INSERT INTO `admin_sys_logininfor` VALUES (2429, 'ry', '222.72.80.69', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-07 04:24:36');
INSERT INTO `admin_sys_logininfor` VALUES (2430, 'ry', '223.88.213.79', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-07 05:40:03');
INSERT INTO `admin_sys_logininfor` VALUES (2431, 'ry', '111.41.170.104', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-07 09:32:19');
INSERT INTO `admin_sys_logininfor` VALUES (2432, 'ry', '111.41.170.104', 'XX XX', 'Chrome 8', 'Windows 10', '0', '退出成功', '2020-03-07 09:33:45');
INSERT INTO `admin_sys_logininfor` VALUES (2433, 'ry', '39.187.125.54', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-07 10:15:56');
INSERT INTO `admin_sys_logininfor` VALUES (2434, 'ry', '39.187.125.54', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-07 10:16:00');
INSERT INTO `admin_sys_logininfor` VALUES (2435, 'ry', '111.41.170.104', '黑龙江 哈尔滨', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-07 10:52:06');
INSERT INTO `admin_sys_logininfor` VALUES (2436, 'ry', '182.119.88.44', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-07 12:01:53');
INSERT INTO `admin_sys_logininfor` VALUES (2437, 'ry', '116.24.96.72', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-07 13:00:32');
INSERT INTO `admin_sys_logininfor` VALUES (2438, 'ry', '116.24.96.72', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-07 13:00:40');
INSERT INTO `admin_sys_logininfor` VALUES (2439, 'ry', '116.24.96.72', '广东 深圳', 'Microsoft Edge', 'Windows 10', '0', '登录成功', '2020-03-07 13:01:40');
INSERT INTO `admin_sys_logininfor` VALUES (2440, 'ry', '182.119.88.44', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-07 13:57:55');
INSERT INTO `admin_sys_logininfor` VALUES (2441, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-07 14:22:52');
INSERT INTO `admin_sys_logininfor` VALUES (2442, 'ry', '113.45.90.22', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-07 15:49:35');
INSERT INTO `admin_sys_logininfor` VALUES (2443, 'ry', '139.212.244.251', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '1', '验证码错误', '2020-03-07 16:18:11');
INSERT INTO `admin_sys_logininfor` VALUES (2444, 'ry', '139.212.244.251', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-07 16:18:19');
INSERT INTO `admin_sys_logininfor` VALUES (2445, 'ry', '223.88.213.79', '河南 安阳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-07 16:58:55');
INSERT INTO `admin_sys_logininfor` VALUES (2446, 'ry', '117.136.30.151', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-07 17:25:22');
INSERT INTO `admin_sys_logininfor` VALUES (2447, 'ry', '101.105.186.3', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-07 17:26:53');
INSERT INTO `admin_sys_logininfor` VALUES (2448, 'ry', '120.229.40.194', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-07 17:53:50');
INSERT INTO `admin_sys_logininfor` VALUES (2449, 'ry', '123.245.58.149', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-07 18:07:28');
INSERT INTO `admin_sys_logininfor` VALUES (2450, 'ry', '123.245.58.149', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-07 18:07:33');
INSERT INTO `admin_sys_logininfor` VALUES (2451, 'admin', '124.79.184.110', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-07 19:14:45');
INSERT INTO `admin_sys_logininfor` VALUES (2452, 'ry', '111.41.170.104', '黑龙江 哈尔滨', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-07 19:40:53');
INSERT INTO `admin_sys_logininfor` VALUES (2453, 'ry', '157.0.165.68', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-07 23:07:06');
INSERT INTO `admin_sys_logininfor` VALUES (2454, 'ry', '222.125.37.80', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-07 23:34:07');
INSERT INTO `admin_sys_logininfor` VALUES (2455, 'ry', '117.140.134.143', '广西 南宁', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-07 23:35:54');
INSERT INTO `admin_sys_logininfor` VALUES (2456, 'ry', '117.140.134.143', 'XX XX', 'Safari', 'Mac OS X', '0', '退出成功', '2020-03-07 23:39:31');
INSERT INTO `admin_sys_logininfor` VALUES (2457, 'ry', '111.201.63.124', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 11:35:58');
INSERT INTO `admin_sys_logininfor` VALUES (2458, 'ry', '111.41.170.104', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 11:38:55');
INSERT INTO `admin_sys_logininfor` VALUES (2459, 'ry', '111.41.170.104', 'XX XX', 'Chrome 8', 'Windows 10', '0', '退出成功', '2020-03-08 11:39:34');
INSERT INTO `admin_sys_logininfor` VALUES (2460, 'ry', '111.198.225.3', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 11:42:14');
INSERT INTO `admin_sys_logininfor` VALUES (2461, 'ry', '58.18.66.180', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 14:19:03');
INSERT INTO `admin_sys_logininfor` VALUES (2462, 'ry', '222.128.183.159', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 18:17:50');
INSERT INTO `admin_sys_logininfor` VALUES (2463, 'ry', '182.119.88.44', '河南 郑州', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-08 18:44:51');
INSERT INTO `admin_sys_logininfor` VALUES (2464, 'ry', '223.104.213.76', '上海 上海', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-08 19:29:37');
INSERT INTO `admin_sys_logininfor` VALUES (2465, 'ry', '223.104.213.76', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-08 19:29:43');
INSERT INTO `admin_sys_logininfor` VALUES (2466, 'ry', '218.204.252.143', '广东 汕头', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 19:36:38');
INSERT INTO `admin_sys_logininfor` VALUES (2467, 'ry', '117.152.197.87', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 19:50:34');
INSERT INTO `admin_sys_logininfor` VALUES (2468, 'ry', '1.83.74.113', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 19:56:47');
INSERT INTO `admin_sys_logininfor` VALUES (2469, 'ry', '123.185.88.23', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 20:11:09');
INSERT INTO `admin_sys_logininfor` VALUES (2470, 'ry', '1.83.74.113', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-08 20:11:14');
INSERT INTO `admin_sys_logininfor` VALUES (2471, 'ry', '222.125.37.80', '广东 深圳', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 20:12:59');
INSERT INTO `admin_sys_logininfor` VALUES (2472, 'ry', '120.244.118.70', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 20:15:58');
INSERT INTO `admin_sys_logininfor` VALUES (2473, 'ry', '39.78.16.9', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-08 20:23:38');
INSERT INTO `admin_sys_logininfor` VALUES (2474, 'ry', '219.143.129.62', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 20:25:13');
INSERT INTO `admin_sys_logininfor` VALUES (2475, 'ry', '219.143.129.62', '北京 北京', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-08 20:26:12');
INSERT INTO `admin_sys_logininfor` VALUES (2476, 'ry', '117.152.197.87', '湖北 武汉', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 20:28:07');
INSERT INTO `admin_sys_logininfor` VALUES (2477, 'ry', '219.143.129.62', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 20:28:10');
INSERT INTO `admin_sys_logininfor` VALUES (2478, 'ry', '117.152.197.87', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 20:31:57');
INSERT INTO `admin_sys_logininfor` VALUES (2479, 'ry', '14.24.165.180', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 20:41:21');
INSERT INTO `admin_sys_logininfor` VALUES (2480, 'ry', '222.125.37.80', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-08 20:44:06');
INSERT INTO `admin_sys_logininfor` VALUES (2481, 'ry', '223.68.108.152', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 20:59:20');
INSERT INTO `admin_sys_logininfor` VALUES (2482, 'ry', '111.201.63.124', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-08 21:04:25');
INSERT INTO `admin_sys_logininfor` VALUES (2483, 'ry', '112.9.4.83', 'XX XX', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-03-08 21:28:40');
INSERT INTO `admin_sys_logininfor` VALUES (2484, 'ry', '112.9.4.83', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-08 21:28:45');
INSERT INTO `admin_sys_logininfor` VALUES (2485, 'ry', '113.45.90.22', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-08 21:47:21');
INSERT INTO `admin_sys_logininfor` VALUES (2486, 'ry', '112.96.71.145', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-08 22:34:24');
INSERT INTO `admin_sys_logininfor` VALUES (2487, 'ry', '111.196.244.138', '北京 北京', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-09 07:46:19');
INSERT INTO `admin_sys_logininfor` VALUES (2488, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-03-09 08:48:05');
INSERT INTO `admin_sys_logininfor` VALUES (2489, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-03-09 08:48:22');
INSERT INTO `admin_sys_logininfor` VALUES (2490, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-03-09 09:01:41');
INSERT INTO `admin_sys_logininfor` VALUES (2491, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误2次', '2020-03-09 09:02:49');
INSERT INTO `admin_sys_logininfor` VALUES (2492, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误3次', '2020-03-09 09:03:13');
INSERT INTO `admin_sys_logininfor` VALUES (2493, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误4次', '2020-03-09 09:03:25');
INSERT INTO `admin_sys_logininfor` VALUES (2494, 'ry', '183.224.17.205', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-09 09:18:53');
INSERT INTO `admin_sys_logininfor` VALUES (2495, 'admin', '119.145.136.61', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-03-09 09:22:15');
INSERT INTO `admin_sys_logininfor` VALUES (2496, 'ry', '125.210.247.161', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-09 10:28:06');
INSERT INTO `admin_sys_logininfor` VALUES (2497, 'ry', '223.20.201.51', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 10:32:03');
INSERT INTO `admin_sys_logininfor` VALUES (2498, 'admin', '112.96.173.35', 'XX XX', 'Chrome 8', 'Windows 10', '1', '密码输入错误1次', '2020-03-09 10:42:18');
INSERT INTO `admin_sys_logininfor` VALUES (2499, 'admin', '112.96.173.35', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-09 10:42:19');
INSERT INTO `admin_sys_logininfor` VALUES (2500, 'ry', '222.247.53.164', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-09 11:31:56');
INSERT INTO `admin_sys_logininfor` VALUES (2501, 'ry', '222.247.53.164', '湖南 长沙', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 11:31:59');
INSERT INTO `admin_sys_logininfor` VALUES (2502, 'ry', '183.27.97.150', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 12:48:10');
INSERT INTO `admin_sys_logininfor` VALUES (2503, 'ry', '49.74.219.26', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 13:20:07');
INSERT INTO `admin_sys_logininfor` VALUES (2504, 'ry', '183.17.231.59', '广东 深圳', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-09 15:01:51');
INSERT INTO `admin_sys_logininfor` VALUES (2505, 'ry', '183.17.231.59', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 15:33:48');
INSERT INTO `admin_sys_logininfor` VALUES (2506, 'ry', '123.245.58.88', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-09 16:05:05');
INSERT INTO `admin_sys_logininfor` VALUES (2507, 'ry', '175.10.144.120', '湖南 长沙', 'Firefox 7', 'Windows 7', '1', '验证码错误', '2020-03-09 16:31:38');
INSERT INTO `admin_sys_logininfor` VALUES (2508, 'ry', '175.10.144.120', '湖南 长沙', 'Firefox 7', 'Windows 7', '0', '登录成功', '2020-03-09 16:31:43');
INSERT INTO `admin_sys_logininfor` VALUES (2509, 'ry', '120.244.114.231', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-09 19:29:01');
INSERT INTO `admin_sys_logininfor` VALUES (2510, 'ry', '223.74.131.43', '广东 惠州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 19:48:31');
INSERT INTO `admin_sys_logininfor` VALUES (2511, 'ry', '123.161.181.222', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 20:00:09');
INSERT INTO `admin_sys_logininfor` VALUES (2512, 'ry', '123.161.181.222', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-09 20:03:19');
INSERT INTO `admin_sys_logininfor` VALUES (2513, 'admin', '123.161.181.222', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 20:03:21');
INSERT INTO `admin_sys_logininfor` VALUES (2514, 'ry', '111.197.247.71', '北京 北京', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-09 20:23:52');
INSERT INTO `admin_sys_logininfor` VALUES (2515, 'ry', '111.201.63.124', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-09 20:23:52');
INSERT INTO `admin_sys_logininfor` VALUES (2516, 'ry', '117.136.5.225', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-09 20:25:45');
INSERT INTO `admin_sys_logininfor` VALUES (2517, 'ry', '120.244.114.231', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-09 20:35:33');
INSERT INTO `admin_sys_logininfor` VALUES (2518, 'ry', '111.201.63.124', '北京 北京', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-09 21:05:52');
INSERT INTO `admin_sys_logininfor` VALUES (2519, 'ry', '120.244.114.231', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-09 21:07:19');
INSERT INTO `admin_sys_logininfor` VALUES (2520, 'ry', '120.244.58.186', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-09 21:17:14');
INSERT INTO `admin_sys_logininfor` VALUES (2521, 'ry', '120.41.153.163', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 21:26:38');
INSERT INTO `admin_sys_logininfor` VALUES (2522, 'ry', '27.152.138.32', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-09 21:55:18');
INSERT INTO `admin_sys_logininfor` VALUES (2523, 'ry', '123.185.89.191', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-09 22:40:14');
INSERT INTO `admin_sys_logininfor` VALUES (2524, 'ry', '120.244.58.186', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-09 22:50:14');
INSERT INTO `admin_sys_logininfor` VALUES (2525, 'ry', '112.41.2.198', '辽宁 沈阳', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-10 00:32:21');
INSERT INTO `admin_sys_logininfor` VALUES (2526, 'ry', '123.161.181.222', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 02:45:48');
INSERT INTO `admin_sys_logininfor` VALUES (2527, 'ry', '27.38.37.93', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-10 09:35:41');
INSERT INTO `admin_sys_logininfor` VALUES (2528, 'ry', '27.38.37.93', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 09:35:49');
INSERT INTO `admin_sys_logininfor` VALUES (2529, 'ry', '119.4.167.228', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 09:50:38');
INSERT INTO `admin_sys_logininfor` VALUES (2530, 'ry', '223.20.201.51', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 09:51:18');
INSERT INTO `admin_sys_logininfor` VALUES (2531, 'ry', '119.48.49.190', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-10 09:54:38');
INSERT INTO `admin_sys_logininfor` VALUES (2532, 'ry', '182.245.74.200', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-03-10 10:51:00');
INSERT INTO `admin_sys_logininfor` VALUES (2533, 'ry', '182.245.74.200', 'XX XX', 'Chrome 8', 'Windows 7', '1', '验证码错误', '2020-03-10 10:51:05');
INSERT INTO `admin_sys_logininfor` VALUES (2534, 'ry', '182.245.74.200', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-10 10:51:17');
INSERT INTO `admin_sys_logininfor` VALUES (2535, 'ry', '125.119.14.165', '浙江 杭州', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-10 11:07:19');
INSERT INTO `admin_sys_logininfor` VALUES (2536, 'ry', '125.119.14.165', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 11:07:26');
INSERT INTO `admin_sys_logininfor` VALUES (2537, 'ry', '153.0.155.8', '海南 海口', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 11:21:09');
INSERT INTO `admin_sys_logininfor` VALUES (2538, 'ry', '153.0.155.8', '海南 海口', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-10 11:26:33');
INSERT INTO `admin_sys_logininfor` VALUES (2539, 'ry', '115.34.0.6', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-10 11:28:09');
INSERT INTO `admin_sys_logininfor` VALUES (2540, 'ry', '115.34.0.6', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-10 11:28:18');
INSERT INTO `admin_sys_logininfor` VALUES (2541, 'ry', '112.232.35.92', '山东 济南', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-10 11:31:01');
INSERT INTO `admin_sys_logininfor` VALUES (2542, 'ry', '112.232.35.92', '山东 济南', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 11:31:08');
INSERT INTO `admin_sys_logininfor` VALUES (2543, 'ry', '183.92.251.23', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-10 11:39:04');
INSERT INTO `admin_sys_logininfor` VALUES (2544, 'ry', '220.114.48.55', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-10 11:41:24');
INSERT INTO `admin_sys_logininfor` VALUES (2545, 'ry', '220.114.48.55', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-10 11:41:28');
INSERT INTO `admin_sys_logininfor` VALUES (2546, 'ry', '117.136.81.171', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-10 11:41:50');
INSERT INTO `admin_sys_logininfor` VALUES (2547, 'ry', '122.191.238.79', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-10 11:42:17');
INSERT INTO `admin_sys_logininfor` VALUES (2548, 'ry', '220.114.48.55', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-10 11:46:24');
INSERT INTO `admin_sys_logininfor` VALUES (2549, 'ry', '117.30.98.133', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-10 11:49:17');
INSERT INTO `admin_sys_logininfor` VALUES (2550, 'ry', '42.243.58.23', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 13:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (2551, 'ry', '36.46.163.187', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 14:09:55');
INSERT INTO `admin_sys_logininfor` VALUES (2552, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-10 14:15:05');
INSERT INTO `admin_sys_logininfor` VALUES (2553, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 14:15:08');
INSERT INTO `admin_sys_logininfor` VALUES (2554, 'ry', '153.0.155.8', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-10 14:46:59');
INSERT INTO `admin_sys_logininfor` VALUES (2555, 'ry', '36.112.59.178', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 15:53:20');
INSERT INTO `admin_sys_logininfor` VALUES (2556, 'ry', '118.112.73.62', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-10 16:03:37');
INSERT INTO `admin_sys_logininfor` VALUES (2557, 'ry', '118.112.73.146', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-10 16:04:46');
INSERT INTO `admin_sys_logininfor` VALUES (2558, 'ry', '113.65.31.111', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 16:12:19');
INSERT INTO `admin_sys_logininfor` VALUES (2559, 'ry', '171.217.16.175', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-10 16:56:40');
INSERT INTO `admin_sys_logininfor` VALUES (2560, 'ry', '171.217.16.175', '四川 成都', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 16:56:46');
INSERT INTO `admin_sys_logininfor` VALUES (2561, 'ry', '113.44.120.182', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-10 17:14:24');
INSERT INTO `admin_sys_logininfor` VALUES (2562, 'ry', '113.65.31.111', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-10 17:17:23');
INSERT INTO `admin_sys_logininfor` VALUES (2563, 'ry', '153.0.155.8', '海南 海口', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-10 17:27:19');
INSERT INTO `admin_sys_logininfor` VALUES (2564, 'ry', '120.41.187.108', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-10 22:28:28');
INSERT INTO `admin_sys_logininfor` VALUES (2565, 'ry', '49.211.18.141', '湖北 武汉', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-10 23:45:33');
INSERT INTO `admin_sys_logininfor` VALUES (2566, 'ry', '118.207.107.127', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-11 01:09:16');
INSERT INTO `admin_sys_logininfor` VALUES (2567, 'ry', '111.37.130.45', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-11 01:34:35');
INSERT INTO `admin_sys_logininfor` VALUES (2568, 'ry', '110.90.99.49', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-11 08:49:31');
INSERT INTO `admin_sys_logininfor` VALUES (2569, 'ry', '14.152.102.147', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 09:09:34');
INSERT INTO `admin_sys_logininfor` VALUES (2570, 'ry', '61.170.199.180', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-11 09:25:21');
INSERT INTO `admin_sys_logininfor` VALUES (2571, 'ry', '183.230.165.104', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 09:28:14');
INSERT INTO `admin_sys_logininfor` VALUES (2572, 'ry', '183.63.135.214', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 09:37:12');
INSERT INTO `admin_sys_logininfor` VALUES (2573, 'ry', '115.204.152.132', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-11 09:50:53');
INSERT INTO `admin_sys_logininfor` VALUES (2574, 'ry', '115.204.152.132', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-11 09:50:59');
INSERT INTO `admin_sys_logininfor` VALUES (2575, 'ry', '115.204.152.132', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-11 09:53:56');
INSERT INTO `admin_sys_logininfor` VALUES (2576, 'ry', '183.63.135.214', '广东 广州', 'Chrome', 'Windows 7', '0', '退出成功', '2020-03-11 09:57:47');
INSERT INTO `admin_sys_logininfor` VALUES (2577, 'ry', '221.182.217.149', '海南 海口', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-11 09:57:59');
INSERT INTO `admin_sys_logininfor` VALUES (2578, 'ry', '221.182.217.149', '海南 海口', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-11 09:58:02');
INSERT INTO `admin_sys_logininfor` VALUES (2579, 'ry', '115.204.152.132', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-11 10:30:44');
INSERT INTO `admin_sys_logininfor` VALUES (2580, 'ry', '115.204.152.132', '浙江 杭州', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-11 10:30:52');
INSERT INTO `admin_sys_logininfor` VALUES (2581, 'ry', '14.152.102.147', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 13:32:22');
INSERT INTO `admin_sys_logininfor` VALUES (2582, 'ry', '121.228.159.44', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-11 13:48:39');
INSERT INTO `admin_sys_logininfor` VALUES (2583, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-11 16:13:00');
INSERT INTO `admin_sys_logininfor` VALUES (2584, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-11 16:16:47');
INSERT INTO `admin_sys_logininfor` VALUES (2585, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-11 16:16:57');
INSERT INTO `admin_sys_logininfor` VALUES (2586, 'ry', '125.71.75.125', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 16:48:14');
INSERT INTO `admin_sys_logininfor` VALUES (2587, 'ry', '125.210.247.161', 'XX XX', 'Chrome 8', 'Windows 7', '0', '登录成功', '2020-03-11 17:38:27');
INSERT INTO `admin_sys_logininfor` VALUES (2588, 'ry', '112.224.1.221', 'XX XX', 'Chrome Mobile', 'Android Mobile', '1', '验证码错误', '2020-03-11 18:19:05');
INSERT INTO `admin_sys_logininfor` VALUES (2589, 'ry', '112.224.1.221', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-11 18:19:10');
INSERT INTO `admin_sys_logininfor` VALUES (2590, 'ry', '180.106.154.231', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-11 19:24:45');
INSERT INTO `admin_sys_logininfor` VALUES (2591, 'ry', '112.86.211.79', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-11 19:26:57');
INSERT INTO `admin_sys_logininfor` VALUES (2592, 'ry', '14.152.102.147', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 19:38:21');
INSERT INTO `admin_sys_logininfor` VALUES (2593, 'ry', '180.106.154.231', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-11 19:41:51');
INSERT INTO `admin_sys_logininfor` VALUES (2594, 'ry', '123.133.69.185', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-11 20:27:43');
INSERT INTO `admin_sys_logininfor` VALUES (2595, 'ry', '101.245.212.8', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-11 20:31:20');
INSERT INTO `admin_sys_logininfor` VALUES (2596, 'ry', '223.80.68.71', '山东 青岛', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-11 22:10:51');
INSERT INTO `admin_sys_logininfor` VALUES (2597, 'ry', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-03-12 00:08:03');
INSERT INTO `admin_sys_logininfor` VALUES (2598, 'ry', '127.0.0.1', '内网IP', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-12 00:08:11');
INSERT INTO `admin_sys_logininfor` VALUES (2599, 'ry', '223.20.201.51', '北京 北京', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 01:10:52');
INSERT INTO `admin_sys_logininfor` VALUES (2600, 'ry', '180.130.2.65', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-12 04:08:22');
INSERT INTO `admin_sys_logininfor` VALUES (2601, 'ry', '61.144.21.178', '广东 广州', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-12 08:50:38');
INSERT INTO `admin_sys_logininfor` VALUES (2602, 'ry', '113.235.119.252', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 10:59:18');
INSERT INTO `admin_sys_logininfor` VALUES (2603, 'ry', '183.15.178.64', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 11:02:13');
INSERT INTO `admin_sys_logininfor` VALUES (2604, 'ry', '218.19.216.195', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-12 11:03:51');
INSERT INTO `admin_sys_logininfor` VALUES (2605, 'ry', '39.128.25.188', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 12:04:40');
INSERT INTO `admin_sys_logininfor` VALUES (2606, 'ry', '113.248.158.237', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-12 13:07:34');
INSERT INTO `admin_sys_logininfor` VALUES (2607, 'ry', '183.14.28.127', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 14:04:07');
INSERT INTO `admin_sys_logininfor` VALUES (2608, 'ry', '183.14.28.127', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-12 14:04:30');
INSERT INTO `admin_sys_logininfor` VALUES (2609, 'admin', '183.14.28.127', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-03-12 14:04:43');
INSERT INTO `admin_sys_logininfor` VALUES (2610, 'ry', '183.14.28.127', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-12 14:09:14');
INSERT INTO `admin_sys_logininfor` VALUES (2611, 'ry', '114.221.198.187', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-12 14:21:18');
INSERT INTO `admin_sys_logininfor` VALUES (2612, 'ry', '202.111.6.40', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-03-12 15:04:22');
INSERT INTO `admin_sys_logininfor` VALUES (2613, 'ry', '202.111.6.40', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-12 15:04:28');
INSERT INTO `admin_sys_logininfor` VALUES (2614, 'ry', '175.166.164.248', '辽宁 大连', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-12 15:08:53');
INSERT INTO `admin_sys_logininfor` VALUES (2615, 'ry', '110.83.17.183', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 17:32:08');
INSERT INTO `admin_sys_logininfor` VALUES (2616, 'ry', '171.88.21.224', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-12 17:48:15');
INSERT INTO `admin_sys_logininfor` VALUES (2617, 'ry', '222.211.232.75', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-12 18:59:54');
INSERT INTO `admin_sys_logininfor` VALUES (2618, 'ry', '101.24.163.89', 'XX XX', 'Chrome 8', 'Mac OS X', '1', '验证码错误', '2020-03-12 20:11:03');
INSERT INTO `admin_sys_logininfor` VALUES (2619, 'ry', '101.24.163.89', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-12 20:11:06');
INSERT INTO `admin_sys_logininfor` VALUES (2620, 'ry', '101.24.163.89', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-12 21:50:03');
INSERT INTO `admin_sys_logininfor` VALUES (2621, 'ry', '59.57.174.175', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 22:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (2622, 'ry', '223.150.44.30', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-12 22:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (2623, 'ry', '223.150.44.30', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-12 22:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (2624, 'ry', '59.57.174.175', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 22:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (2625, 'ry', '59.57.174.175', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 22:09:53');
INSERT INTO `admin_sys_logininfor` VALUES (2626, 'ry', '171.15.61.40', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 22:34:44');
INSERT INTO `admin_sys_logininfor` VALUES (2627, 'ry', '175.153.161.207', 'XX XX', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-12 23:03:24');
INSERT INTO `admin_sys_logininfor` VALUES (2628, 'ry', '59.57.174.175', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 23:22:26');
INSERT INTO `admin_sys_logininfor` VALUES (2629, 'ry', '114.254.220.169', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-12 23:56:07');
INSERT INTO `admin_sys_logininfor` VALUES (2630, 'ry', '112.96.70.170', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-13 01:54:33');
INSERT INTO `admin_sys_logininfor` VALUES (2631, 'ry', '112.65.48.240', '上海 上海', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-13 06:27:12');
INSERT INTO `admin_sys_logininfor` VALUES (2632, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 08:18:47');
INSERT INTO `admin_sys_logininfor` VALUES (2633, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-13 09:15:19');
INSERT INTO `admin_sys_logininfor` VALUES (2634, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 09:15:24');
INSERT INTO `admin_sys_logininfor` VALUES (2635, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 09:22:27');
INSERT INTO `admin_sys_logininfor` VALUES (2636, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-13 09:22:33');
INSERT INTO `admin_sys_logininfor` VALUES (2637, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-13 09:22:33');
INSERT INTO `admin_sys_logininfor` VALUES (2638, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 09:22:37');
INSERT INTO `admin_sys_logininfor` VALUES (2639, 'ry', '175.11.84.59', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-13 09:57:48');
INSERT INTO `admin_sys_logininfor` VALUES (2640, 'ry', '175.11.84.59', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 09:57:52');
INSERT INTO `admin_sys_logininfor` VALUES (2641, 'ry', '27.18.183.119', 'XX XX', 'Internet Explorer 11', 'Windows 10', '0', '登录成功', '2020-03-13 10:27:25');
INSERT INTO `admin_sys_logininfor` VALUES (2642, 'ry', '101.24.163.89', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-13 10:36:52');
INSERT INTO `admin_sys_logininfor` VALUES (2643, 'ry', '175.11.84.78', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-13 12:12:46');
INSERT INTO `admin_sys_logininfor` VALUES (2644, 'ry', '123.117.233.44', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-13 13:36:21');
INSERT INTO `admin_sys_logininfor` VALUES (2645, 'ry', '117.30.38.102', 'XX XX', 'Chrome 39', 'Windows 7', '0', '登录成功', '2020-03-13 13:57:11');
INSERT INTO `admin_sys_logininfor` VALUES (2646, 'ry', '111.181.214.128', '湖北 恩施', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-13 14:26:11');
INSERT INTO `admin_sys_logininfor` VALUES (2647, 'ry', '111.181.214.128', '湖北 恩施', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 14:26:14');
INSERT INTO `admin_sys_logininfor` VALUES (2648, 'ry', '127.0.0.1', '内网IP', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 15:09:12');
INSERT INTO `admin_sys_logininfor` VALUES (2649, 'ry', '223.104.190.34', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-13 15:22:14');
INSERT INTO `admin_sys_logininfor` VALUES (2650, 'ry', '223.104.190.34', 'XX XX', 'Chrome', 'Windows 7', '0', '退出成功', '2020-03-13 15:24:01');
INSERT INTO `admin_sys_logininfor` VALUES (2651, 'ry', '117.28.231.35', 'XX XX', 'Firefox 7', 'Windows 10', '1', '验证码错误', '2020-03-13 15:51:50');
INSERT INTO `admin_sys_logininfor` VALUES (2652, 'ry', '117.28.231.35', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-13 15:51:57');
INSERT INTO `admin_sys_logininfor` VALUES (2653, 'ry', '222.218.99.113', 'XX XX', 'Firefox 7', 'Windows 10', '0', '登录成功', '2020-03-13 16:52:31');
INSERT INTO `admin_sys_logininfor` VALUES (2654, 'ry', '218.17.101.142', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 17:23:43');
INSERT INTO `admin_sys_logininfor` VALUES (2655, 'ry', '218.17.101.142', '广东 深圳', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-13 17:23:46');
INSERT INTO `admin_sys_logininfor` VALUES (2656, 'ry', '111.207.166.93', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-13 17:59:04');
INSERT INTO `admin_sys_logininfor` VALUES (2657, 'ry', '111.207.166.93', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 17:59:25');
INSERT INTO `admin_sys_logininfor` VALUES (2658, 'ry', '120.36.168.73', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-13 18:05:17');
INSERT INTO `admin_sys_logininfor` VALUES (2659, 'ry', '112.116.115.17', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-13 18:43:55');
INSERT INTO `admin_sys_logininfor` VALUES (2660, 'ry', '117.190.16.2', '新疆 乌鲁木齐', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-13 19:27:19');
INSERT INTO `admin_sys_logininfor` VALUES (2661, 'ry', '220.171.134.2', 'XX XX', 'Firefox 7', 'Windows 7', '0', '登录成功', '2020-03-13 19:53:00');
INSERT INTO `admin_sys_logininfor` VALUES (2662, 'ry', '116.233.183.66', 'XX XX', 'Chrome Mobile', 'Android 1.x', '0', '登录成功', '2020-03-13 21:02:22');
INSERT INTO `admin_sys_logininfor` VALUES (2663, 'ry', '117.153.24.35', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-13 21:54:54');
INSERT INTO `admin_sys_logininfor` VALUES (2664, 'ry', '112.5.168.92', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-13 22:04:36');
INSERT INTO `admin_sys_logininfor` VALUES (2665, 'ry', '42.229.79.120', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-13 22:15:01');
INSERT INTO `admin_sys_logininfor` VALUES (2666, 'ry', '119.165.25.137', 'XX XX', 'Safari', 'Mac OS X', '0', '登录成功', '2020-03-13 23:05:50');
INSERT INTO `admin_sys_logininfor` VALUES (2667, 'ry', '119.165.25.137', 'XX XX', 'Safari', 'Mac OS X', '0', '退出成功', '2020-03-13 23:07:50');
INSERT INTO `admin_sys_logininfor` VALUES (2668, 'ry', '112.116.115.17', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-14 08:03:10');
INSERT INTO `admin_sys_logininfor` VALUES (2669, 'ry', '117.173.130.193', 'XX XX', 'Chrome 8', 'Windows 10', '1', '验证码错误', '2020-03-14 09:37:55');
INSERT INTO `admin_sys_logininfor` VALUES (2670, 'ry', '117.173.130.193', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-14 09:38:01');
INSERT INTO `admin_sys_logininfor` VALUES (2671, 'ry', '171.43.27.130', '湖北 黄冈', 'Chrome Mobile', 'Android Mobile', '0', '登录成功', '2020-03-14 09:40:46');
INSERT INTO `admin_sys_logininfor` VALUES (2672, 'ry', '117.173.130.193', 'XX XX', 'Chrome 8', 'Windows 10', '0', '登录成功', '2020-03-14 10:16:27');
INSERT INTO `admin_sys_logininfor` VALUES (2673, 'ry', '125.71.77.157', 'XX XX', 'Apple WebKit', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-14 10:33:56');
INSERT INTO `admin_sys_logininfor` VALUES (2674, 'ry', '222.248.235.91', 'XX XX', 'Chrome 8', 'Mac OS X', '0', '登录成功', '2020-03-14 11:16:09');
INSERT INTO `admin_sys_logininfor` VALUES (2675, 'ry', '120.235.43.169', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-14 13:19:02');
INSERT INTO `admin_sys_logininfor` VALUES (2676, 'ry', '125.71.89.4', '四川 成都', 'Chrome', 'Windows 7', '1', '验证码错误', '2020-03-14 13:28:05');
INSERT INTO `admin_sys_logininfor` VALUES (2677, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 7', '0', '登录成功', '2020-03-14 13:28:12');
INSERT INTO `admin_sys_logininfor` VALUES (2678, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-14 13:32:26');
INSERT INTO `admin_sys_logininfor` VALUES (2679, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-14 13:33:07');
INSERT INTO `admin_sys_logininfor` VALUES (2680, 'admin', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误1次', '2020-03-14 13:33:18');
INSERT INTO `admin_sys_logininfor` VALUES (2681, 'admin', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误2次', '2020-03-14 13:33:24');
INSERT INTO `admin_sys_logininfor` VALUES (2682, 'admin', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-14 13:33:54');
INSERT INTO `admin_sys_logininfor` VALUES (2683, 'admin', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '密码输入错误3次', '2020-03-14 13:34:01');
INSERT INTO `admin_sys_logininfor` VALUES (2684, 'ry', '125.71.89.4', 'XX XX', 'Mobile Safari', 'Mac OS X (iPhone)', '0', '登录成功', '2020-03-14 13:37:37');
INSERT INTO `admin_sys_logininfor` VALUES (2685, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '退出成功', '2020-03-14 13:37:54');
INSERT INTO `admin_sys_logininfor` VALUES (2686, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '1', '验证码错误', '2020-03-14 13:38:00');
INSERT INTO `admin_sys_logininfor` VALUES (2687, 'ry', '125.71.89.4', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-14 13:39:25');
INSERT INTO `admin_sys_logininfor` VALUES (2688, 'ry', '111.199.187.159', 'XX XX', 'Chrome', 'Windows 10', '0', '登录成功', '2020-03-14 13:44:00');
INSERT INTO `admin_sys_logininfor` VALUES (2689, 'ry', '120.235.43.169', '广东 东莞', 'Chrome', 'Windows 10',