﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using EKETEAM.Data;
using EKETEAM.FrameWork;

namespace eFrameWork.Application
{
    public partial class Custom : System.Web.UI.Page
    {
        public string UserArea = "Application";
        public eModel model;
        public bool Ajax = false;
        public string AppItem = eParameters.Request("AppItem");
        public eUser user;
        protected void Page_Load(object sender, EventArgs e)
        {
            //System.Web.UI.HtmlControls.HtmlInputHidden

            user = new eUser(UserArea);
            user.Check();

            eModelInfo customModel = new eModelInfo(user);
            model = customModel.Model;
            string path = model.ModelInfo["AspxFile"].ToString();
            //eBase.Writeln(path);
            eBase.ExecutePage(path, LitBody);
        }
        protected void Page_PreInit(object sender, EventArgs e)
        {
            if (Request.QueryString["ajax"] != null) Ajax = Convert.ToBoolean(Request.QueryString["ajax"]);
            //eBase.Writeln(Ajax.ToString());
            if (!Ajax)
            {
                MasterPageFile = "Main.Master";
            }
            else
            {
                MasterPageFile = "MainNone.Master";
            }
        }
        protected void Page_PreRender(object sender, EventArgs e)
        {
            Literal lit = (Literal)Master.FindControl("LitTitle");
            if (lit != null) lit.Text = eConfig.ApplicationTitle(user["SiteID"].ToString());// model.ModelInfo["mc"].ToString() + " - " + 

            lit = (Literal)Master.FindControl("LitJavascript");
            if (lit != null && model.Javasctipt.Length > 0) lit.Text = model.Javasctipt;

            lit = (Literal)Master.FindControl("LitStyle");
            if (lit != null && model.cssText.Length > 0) lit.Text = model.cssText;

        }
    }
}