﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using EKETEAM.Data;
using EKETEAM.FrameWork;
using EKETEAM.UserControl;
using System.Text;

namespace eFrameWork.Application
{
    public partial class Check_Plans : System.Web.UI.Page
    {
        public string UserArea = "Application";
        public string ModelID = eParameters.Request("modelid");
        public string AppItem = eParameters.Request("AppItem");
        public eModel model;
        public eList elist;
        public eForm eform;
        public eAction Action; 
        public eUser user;


        string sql = "";

        public string code = eParameters.QueryString("code");
        protected void Page_Load(object sender, EventArgs e)
        {
            user = new eUser(eBase.getUserArea(UserArea));
            eModelInfo customModel = new eModelInfo(user);
            model = customModel.Model;
            ModelID = model.ModelID;

            Action = new eAction();
            Action.ModelID = ModelID; 
            Action.Actioning += new eActionHandler(Action_Actioning);
            Action.Listen();

            string act = eParameters.QueryString("act");
        }
        protected void Action_Actioning(string Actioning)
        {
            eform = new eForm("CheckPlans", user);
            eform.ModelID = ModelID.Replace("-", "_");
            switch (Actioning)
            {
                case "":
                    List();
                    break;
                default:
                    eform.AddControl(eFormControlGroup);
                    eform.onChange += new eFormTableEventHandler(eform_onChange);
                    eform.Handle();
                    break;
            }
        }
        public void eform_onChange(object sender, eFormTableEventArgs e)
        {
            if (e.eventType == eFormTableEventType.Inserting)
            {
                if (user["SiteID"].Length > 0) eform.Fields.Add("SiteID", user["SiteID"]);
                if (user["Code"].Length > 0) eform.Fields.Add("Code", user["Code"]);
            }
            if (e.eventType == eFormTableEventType.Inserted && 1==3)
            {
                string baseName = eOleDB.getValue("select baseName from CheckPlans where CheckPlanID='" + e.ID +  "'");

                //计划采集
                string TableName = "Check_plan_" + baseName;
                string sql = "Create table [" + TableName + "] (";
                sql += "[ID] [int] IDENTITY (1, 1) NOT NULL,";
                sql += "[CheckPlanID] uniqueidentifier NULL,";
                sql += "[Code] nvarchar(50) NULL,";
                sql += "[orgCode] nvarchar(50) NULL,";
                sql += "[SFZH] nvarchar(50) NULL,";
                sql += "[XM] nvarchar(50) NULL,";
                sql += "[CJFS] nvarchar(50) NULL default '点位采集',";//采集方式
                sql += "[result] [int] NULL default 0,"; //默认为0未采集 ,1为已采集
                sql += "[CJSJ] nvarchar(50) NULL,"; //采集时间
                sql += "[Reason] nvarchar(50) NULL,";//未采集原因
                sql += "[addTime] [datetime] NULL default getdate(),";
                sql += "[addUser] nvarchar(36) NULL,";
                sql += "PRIMARY KEY(ID)";
                sql += ") ON [PRIMARY]";
                eOleDB.Execute(sql);
                sql = "CREATE INDEX index_" + TableName + "_sfzh ON [" + TableName + "] ([SFZH])";
                eOleDB.Execute(sql);



                //计划外
                TableName = "Check_other_" + baseName;
                sql = "Create table [" + TableName + "] (";
                sql += "[ID] [int] IDENTITY (1, 1) NOT NULL,";
                sql += "[CheckPlanID] uniqueidentifier NULL,";
                sql += "[Code] nvarchar(50) NULL,";
                sql += "[orgCode] nvarchar(50) NULL,";
                sql += "[SFZH] nvarchar(50) NULL,";
                sql += "[XM] nvarchar(50) NULL,";
                sql += "[CJSJ] nvarchar(50) NULL,"; //采集时间
                sql += "[CJFS] nvarchar(50) NULL,";//采集方式
                sql += "[addTime] [datetime] NULL default getdate(),";
                sql += "[addUser] nvarchar(36) NULL,";
                sql += "PRIMARY KEY(ID)";
                sql += ") ON [PRIMARY]";
                eOleDB.Execute(sql);
                sql = "CREATE INDEX index_" + TableName + "_sfzh ON [" + TableName + "] ([SFZH])";
                eOleDB.Execute(sql);


                //返回结果
                TableName = "Check_result_" + baseName;
                sql = "Create table [" + TableName + "] (";
                sql += "[ID] [int] IDENTITY (1, 1) NOT NULL,";
                sql += "[CheckPlanID] uniqueidentifier NULL,";
                sql += "[SFZH] nvarchar(50) NULL,";
                sql += "[XM] nvarchar(50) NULL,";
                sql += "[addTime] [datetime] NULL default getdate(),";
                sql += "[addUser] nvarchar(36) NULL,";
                sql += "PRIMARY KEY(ID)";
                sql += ") ON [PRIMARY]";
                eOleDB.Execute(sql);
                sql = "CREATE INDEX index_" + TableName + "_sfzh ON [" + TableName + "] ([SFZH])";
                eOleDB.Execute(sql);



                //更新结果
                TableName = "Check_update_" + baseName;
                sql = "Create table [" + TableName + "] (";
                sql += "[ID] [int] IDENTITY (1, 1) NOT NULL,";
                sql += "[CheckPlanID] uniqueidentifier NULL,";
                sql += "[SFZH] nvarchar(50) NULL,";
                sql += "[XM] nvarchar(50) NULL,";
                sql += "[CJSJ] nvarchar(50) NULL,"; //采集时间
                sql += "[CJFS] nvarchar(50) NULL,";//采集方式
                sql += "[addTime] [datetime] NULL default getdate(),";
                sql += "[addUser] nvarchar(36) NULL,";
                sql += "PRIMARY KEY(ID)";
                sql += ") ON [PRIMARY]";
                eOleDB.Execute(sql);
                sql = "CREATE INDEX index_" + TableName + "_sfzh ON [" + TableName + "] ([SFZH])";
                eOleDB.Execute(sql);

            }
        }
        private void List()
        {
            elist = new eList("CheckPlans");
            elist.Where.Add("delTag=0");
            elist.OrderBy.Add("addTime desc");
            eDataTable.ItemDataBound += new RepeaterItemEventHandler(eDataTable_ItemDataBound);
            elist.Bind(eDataTable, ePageControl1);
            if (ePageControl1.RecordsCount == 0) LitNoResords.Text = "<div style=\"padding:15px;text-align:center\">暂无数据!</div>";
        }
        protected void eDataTable_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                string baseName = DataBinder.Eval(e.Item.DataItem, "BaseName").ToString();
                Control ctrl = e.Item.Controls[0];
                Literal lit = (Literal)ctrl.FindControl("litPlanCount");
                if (lit != null)
                {
                    lit.Text = eOleDB.getValue("select count(*) from Check_plan where CheckPlanID='" + DataBinder.Eval(e.Item.DataItem, "CheckPlanID").ToString() + "'");
                }
                lit = (Literal)ctrl.FindControl("litResultCount");
                if (lit != null)
                {
                    lit.Text = eOleDB.getValue("select count(*) from Check_result where CheckPlanID='" + DataBinder.Eval(e.Item.DataItem, "CheckPlanID").ToString() + "'");
                }
                
            }
        }
    }
}