﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using EKETEAM.Data;
using EKETEAM.FrameWork;

namespace eFrameWork.Customs.Base
{
    public partial class CheckUp : System.Web.UI.Page
    {
        public string UserArea = "Application";
        public string AppItem = eParameters.QueryString("AppItem");
        public string modelid = eParameters.QueryString("modelid");
        public string id = eParameters.QueryString("id");
        eUser user;
        eModel model;
        public DataRow cur = null;
        DataRow next = null;
        DataRow last = null;
        DataRow priv = null;
        public string options = "";
        public int backCount = 0;
        int height = 150;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["UserArea"] != null) UserArea = Request.QueryString["UserArea"].ToString();

            user = new eUser(UserArea);
            if (AppItem.Length > 0)
            {
                DataRow[] appRows = eBase.a_eke_sysApplicationItems.Select("ApplicationItemID='" + AppItem + "'");
                if (appRows.Length == 0)
                {
                    eJson json = new eJson();
                    json.Convert = true;
                    json.Add("success", "0");
                    json.Add("message", "当前编码为空!");
                    Response.Write(json.ToString());
                    Response.End();
                }
                modelid = appRows[0]["ModelID"].ToString();
                model = new eModel(AppItem, modelid, user);
            }
            else
            {
                model = new eModel(modelid, user);
            }
            #region 当前审批编码
            string CheckupCode = eOleDB.getValue("select CheckupCode from " + model.eForm.TableName + " Where " + model.eForm.primaryKey + "='" + model.eForm.ID + "'");
            if (CheckupCode.Length == 0)
            {
                eJson json = new eJson();
                json.Convert = true;
                json.Add("success", "0");
                json.Add("message", "当前编码为空!");
                Response.Write(json.ToString());
                Response.End();
            }
            #endregion
            #region 当前审批编码在流程中是否存在
            DataRow[] Rows = model.CheckUpItems.Select("Code='" + CheckupCode + "'");
            if (Rows.Length == 0)
            {
                eJson json = new eJson();
                json.Convert = true;
                json.Add("success", "0");
                json.Add("message", "当前编码(" + CheckupCode + ")在审批流程中不存在!");
                Response.Write(json.ToString());
                Response.End();
            }
            cur = Rows[0];
            //eBase.PrintDataRow(cur);
            #endregion            
            #region 判断流程是否结束
            if (Convert.ToInt32(cur["PXNumber"]) >= model.CheckUpItems.Rows.Count)
            {
                eJson json = new eJson();
                json.Add("success", "0");
                json.Add("message", "该审批流程已经结束!");
                Response.Write(json.ToString());
                Response.End();
            }
            #endregion

            //eBase.PrintDataRow(model.Power);
           // eBase.Writeln(CheckupCode + "::" + model.CheckUpItems.Rows.Count.ToString());
            //eBase.PrintDataRow(cur);
            //eBase.End();

            #region 权限
            if (!model.Power.Table.Columns.Contains(cur["CheckCode"].ToString()))
            {
                eJson json = new eJson();
                json.Convert = true;
                json.Add("success", "0");
                json.Add("message", "没有权限!");
                Response.Write(json.ToString());
                Response.End();
            }
            if (!Convert.ToBoolean(model.Power[cur["CheckCode"].ToString()]))
            {
                eJson json = new eJson();
                json.Convert = true;
                json.Add("success", "0");
                json.Add("message", "没有权限!");
                Response.Write(json.ToString());
                Response.End();
            }
            #endregion
            #region 作废
            if (Request.QueryString["act"] != null)
            {
                string state = eParameters.QueryString("f1");
                if (state == "3")
                {
                    string idea = "无";
                    if (eParameters.QueryString("f2").Length > 0) idea = eParameters.QueryString("f2");
                    #region 审批记录
                    eTable etb = new eTable("a_eke_sysCheckupRecords", user);
                    if (user["siteid"].Length > 0) etb.Fields.Add("SiteID", user["siteid"]);
                    etb.Fields.Add("UserID", user.ID);
                    if (modelid.Length > 0) etb.Fields.Add("modelid", modelid);
                    etb.Fields.Add("Checkuptype", model.ModelInfo["code"].ToString());
                    etb.Fields.Add("CheckupContentId", id);
                    etb.Fields.Add("CheckupCode", cur["CheckCode"].ToString());
                    etb.Fields.Add("CheckupText", cur["CheckMC"].ToString());
                    etb.Fields.Add("CheckupIdea", idea);
                    etb.Fields.Add("CheckupState", state);
                    etb.Add();
                    #endregion
                    #region 被审批信息
                    etb = new eTable(model.ModelInfo["code"].ToString(),user);
                    etb.Fields.Add("CheckupCode", "Stop");
                    etb.Fields.Add("CheckupText", "作废");
                    etb.Where.Add(model.eForm.primaryKey + "='" + id + "'");
                    etb.Update();
                    #endregion
                    eJson json = new eJson();
                    json.Add("success", "1");
                    json.Add("message", "作废成功!");
                    Response.Write(json.ToString());
                    Response.End();
                }
            }
            #endregion
            #region 取得下级及顶级审批编码
            next = model.CheckUpItems.Rows[Convert.ToInt32(cur["PXNumber"]) ];
            last = model.CheckUpItems.Rows[model.CheckUpItems.Rows.Count - 1];
            if (Convert.ToInt32(cur["PXNumber"]) > 1)
            {
                priv = model.CheckUpItems.Rows[Convert.ToInt32(cur["PXNumber"]) - 2];
            }            
            #endregion
            #region 返回流程
            if (cur["BackProcess"].ToString().Length > 0)
            {
                options = "<option value=\"\" selected>请选择</option>\r\n";
                eJson json = new eJson(cur["BackProcess"].ToString());
                backCount = json.Collection.Count;
                foreach (eJson _json in json.Collection)
                {
                    options += "<option value=\"" + _json.GetValue("value") + "\">" + _json.GetValue("text") + "</option>\r\n";
                }
            }
            #endregion
            #region 审批
            if (Request.QueryString["act"] != null && Request.QueryString["act"].ToString().ToLower() == "checkup")
            {
                #region 审批记录
                string idea = "无";
                string state = "1";
                if (eParameters.QueryString("f1").Length > 0) state = eParameters.QueryString("f1");
                if (eParameters.QueryString("f2").Length > 0) idea = eParameters.QueryString("f2");

                eTable etb = new eTable("a_eke_sysCheckupRecords", user);
                if (user["siteid"].Length > 0) etb.Fields.Add("SiteID", user["siteid"]);
                etb.Fields.Add("UserID", user.ID);
                if (modelid.Length > 0) etb.Fields.Add("modelid", modelid);
                etb.Fields.Add("Checkuptype",model.ModelInfo["code"].ToString());
                etb.Fields.Add("CheckupContentId", id);
                etb.Fields.Add("CheckupCode", cur["CheckCode"].ToString());
                etb.Fields.Add("CheckupText", cur["CheckMC"].ToString());
                etb.Fields.Add("CheckupIdea", idea);
                etb.Fields.Add("CheckupState", state);
                etb.Add();
                #endregion
                #region 被审批信息
                etb = new eTable(model.ModelInfo["code"].ToString(),user);
                if (state == "1") //通过
                {
                    etb.Fields.Add("CheckupCode", next["Code"].ToString());
                    etb.Fields.Add("CheckupText", next["MC"].ToString());
                }
                else //退回
                {
                    string backPress = eParameters.QueryString("f3");
                    if (backPress.Length > 0) //选择退回
                    {
                        etb.Fields.Add("CheckupCode", backPress);
                        Rows = model.CheckUpItems.Select("Code='" + backPress + "'");
                        if (Rows.Length > 0)
                        {
                            etb.Fields.Add("CheckupText", Rows[0]["MC"].ToString());
                        }
                    }
                    else //退回上一层级
                    {
                        if (priv != null)
                        {
                            etb.Fields.Add("CheckupCode", priv["Code"].ToString());
                            etb.Fields.Add("CheckupText", priv["MC"].ToString());
                        }
                    }
                }               
                etb.Where.Add(model.eForm.primaryKey + "='" + id + "'");
                etb.Update();
                #endregion
                eJson json = new eJson();
                json.Add("success", "1");
                json.Add("message", "审核成功!");
                Response.Write(json.ToString());
                Response.End();
            }
            #endregion
        }
        protected override void Render(HtmlTextWriter writer)
        {
            StringWriter stringWriter = new StringWriter();
            HtmlTextWriter htmlWriter = new HtmlTextWriter(stringWriter);
            base.Render(htmlWriter);
            htmlWriter.Close();
            htmlWriter.Dispose();
            string content = stringWriter.ToString();
            stringWriter.Close();
            stringWriter.Dispose();
            #region 窗口高度计算
            if (cur["showState"].ToString() == "True") height += 30 + 30;
            if (cur["showIdea"].ToString() == "True") height += 100;
            #endregion

            eJson json = new eJson();
            json.Add("success", "1");
            json.Add("message", "加载成功");
            //json.Add("title", cur["Text"].ToString());
            json.Add("title", cur["CheckMC"].ToString());
            //eBase.Write(content);

            json.Add("height", height.ToString());
            json.Add("html", eBase.encode(content));
            Response.Clear();
            Response.Write(json.ToString());
            Response.End();
        }
    }
}