﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using EKETEAM.FrameWork;
using EKETEAM.Data;

namespace eFrameWork.Manage
{
    public partial class Config : System.Web.UI.Page
    {
        public string valuejson = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            eUser user = new eUser("Manage");
            user.Check();
            if (eParameters.QueryString("act") == "setvalue")
            {
                eTable tb = new eTable("a_eke_sysConfigs");
                tb.Fields.Add("value",eParameters.Form("value"));
                tb.Where.Add("name='setup'");
                tb.Update();
                eBase.clearDataCache();
                eBase.Setup = null;
                eRegisterInfo.Loaded = false;
               

                eJson json = new eJson();
                json.Add("success", "1");
                json.Add("message", "修改成功!");
                Response.Write(json.ToString());
                Response.End();
            }
            read();
        }
        protected void read()
        {
            valuejson = eOleDB.getValue("select value from a_eke_sysConfigs where name='setup'");
            eJson jvalue = valuejson.Length > 3 && valuejson.StartsWith("{") ? new eJson(valuejson) : new eJson();




            StringBuilder sb = new StringBuilder();
            sb.Append("{\r\n");
            sb.Append("manageName:{fieldname:\"开发平台名称\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",systemName:{fieldname:\"运行平台名称\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",UploadPath:{fieldname:\"上传路径\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",fileExt:{fieldname:\"允许文件类型\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",Debug:{fieldname:\"调试模式\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",showHelp:{fieldname:\"显示帮助\",controltype:\"radio\",defaultvalue:\"True\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            //sb.Append(",DataCache:{fieldname:\"数据缓存\",controltype:\"radio\",defaultvalue:\"True\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",PageCache:{fieldname:\"页面缓存\",controltype:\"radio\",defaultvalue:\"True\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",DataLog:{fieldname:\"数据日志\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",saveSource:{fieldname:\"保存源文件\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",staticURL:{fieldname:\"静态化URL\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",fileLibrary:{fieldname:\"文件库\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",ErrorLog:{fieldname:\"错误日志\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"打开\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            sb.Append(",ExcludeFolders:{fieldname:\"排除目录\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",AccessorysURL:{fieldname:\"附件服务器地址\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",toKenSecret:{fieldname:\"toKen密钥\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");
            sb.Append(",passType:{fieldname:\"加密方式\",controltype:\"select\",defaultvalue:\"md516\",options:[{text:\"md5(32位)\",value:\"md532\"},{text:\"md5(16位)\",value:\"md516\"},{text:\"sha256\",value:\"sha256\"}]}\r\n");
            sb.Append(",htmlEditor:{fieldname:\"HTML编辑器\",controltype:\"select\",defaultvalue:\"kindeditor\",options:[{text:\"KindEditor\",value:\"kindeditor\"},{text:\"uEditor\",value:\"ueditor\"}]}\r\n");
            sb.Append(",RegData:{fieldname:\"授权码\",controltype:\"textarea\",style:\"width:500px;\",defaultvalue:\"\"}\r\n");

            

            sb.Append(",addTimeTag:{fieldname:\"添加时间字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"addTime\"}\r\n");
            sb.Append(",addUserTag:{fieldname:\"添加用户字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"addUser\"}\r\n");
            sb.Append(",editTimeTag:{fieldname:\"编辑时间字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"editTime\"}\r\n");
            sb.Append(",editUserTag:{fieldname:\"编辑用户字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"editUser\"}\r\n");
            sb.Append(",deleteTimeTag:{fieldname:\"删除时间字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"delTime\"}\r\n");
            sb.Append(",deleteUserTag:{fieldname:\"删除用户字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"delUser\"}\r\n");
            sb.Append(",deleteTag:{fieldname:\"删除标记字段\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"delTag\"}\r\n");
            

            sb.Append(",SystemGrey:{fieldname:\"全局变灰\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"开启\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");
            //sb.Append(",SystemDisable:{fieldname:\"系统禁用\",controltype:\"radio\",defaultvalue:\"False\",options:[{text:\"开启\",value:\"True\"},{text:\"关闭\",value:\"False\"}]}\r\n");

            sb.Append(",Version:{fieldname:\"资源版本号\",controltype:\"text\",style:\"width:500px;\",defaultvalue:\"1.0.0\"}\r\n");
            sb.Append("}\r\n");
            
            //eBase.Writeln(sb.ToString().Replace("\r\n","<br>"));            
            eJson fields = new eJson(sb.ToString());

            StringBuilder strb = new StringBuilder();
            strb.Append("<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"eDataView\">\r\n");
            strb.Append("<colgroup>\r\n");
            strb.Append("<col width=\"120\" />\r\n");
            strb.Append("<col />\r\n");
            strb.Append("</colgroup>\r\n");
            foreach (string key in fields.GetKeys())
            {
                eJson field = fields.GetModel(key);
                string value = jvalue.IsValue(key) ? jvalue.GetValue(key) : field.GetValue("defaultvalue");
                value = System.Web.HttpUtility.HtmlEncode(value);
                strb.Append("<tr>\r\n");
                strb.Append("<td class=\"title\">" + field.GetValue("fieldname") + "：</td>\r\n");
                strb.Append("<td class=\"content\"><span class=\"eform\">");
                eJson opts;
                switch (field.GetValue("controltype"))
                {
                    case "text":
                        strb.Append("<input type=\"text\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\" class=\"text\" style=\"" + field.GetValue("style") + "\" autocomplete=\"off\" />");
                        break;
                    case "radio":
                         if (field.IsCollection("options"))
                         {

                             opts = field.GetCollection("options");
                             int i=1;
                             foreach (eJson m in opts.GetCollection())
                             {
                                 strb.Append("<input type=\"radio\" name=\"" + key + "\" id=\"" + key + "_" + i.ToString() + "\" value=\"" + m.GetValue("value") + "\"" + ( m.GetValue("value").ToLower()==value.ToLower() ? " checked=\"true\"" : "") + "><label for=\"" + key + "_" + i.ToString() + "\">" + m.GetValue("text") + "</label>");
                                 i++;
                             }                             
                         }
                        break;
                    case "select":
                        strb.Append("<select name=\"" + key + "\" id=\"" + key + "\">");
                        //strb.Append("<option value="">请选择</option>");
                        opts = field.GetCollection("options");
                        foreach (eJson m in opts.GetCollection())
                        {
                            strb.Append("<option value=\"" + m.GetValue("value") + "\"" + (m.GetValue("value").ToLower() == value.ToLower() ? " selected=\"true\"" : "") + ">" + m.GetValue("text") + "</option>");
                        }
                        strb.Append("</select>\r\n");                        
                        break;
                    case "textarea":
                        strb.Append("<textarea type=\"text\" name=\"" + key + "\" id=\"" + key + "\" style=\"" + field.GetValue("style") + "\">" + value + "</textarea>");
                        break;
                }
                strb.Append("</span></td>\r\n");
                strb.Append("</tr>\r\n");
            }
            strb.Append("</table>\r\n");
            LitBody.Text = strb.ToString();
           // eBase.PrintDataTable(fields.toRows());
            //eBase.Writeln(fields.toRows().toJSON());
        }
        protected void Page_PreRender(object sender, EventArgs e)
        {
            Literal lit = (Literal)Master.FindControl("LitTitle");
            if (lit != null)
            {
                lit.Text = "系统配置 - " + eConfig.manageName();
            }
        }
    }
}