﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using EKETEAM.FrameWork;
using EKETEAM.Data;
using LitJson;

namespace eFrameWork.Manage
{
    public partial class ModelItems_List : System.Web.UI.Page
    {
        public string modelid = eParameters.QueryString("modelid");
        private DataRow _modelinfo;
        public DataRow ModelInfo
        {
            get
            {
                if (_modelinfo == null)
                {
                    //DataTable dt = eOleDB.getDataTable("select * from a_eke_sysModels where ModelID='" + modelid + "'");
                    DataTable dt = eOleDB.getDataTable("select b.Type as bType, a.* from a_eke_sysModels a left join a_eke_sysModels b on a.ParentID=b.ModelID where a.ModelID='" + modelid + "'");
                    if (dt.Rows.Count > 0) _modelinfo = dt.Rows[0];
                }
                return _modelinfo;
            }
        }
        private JsonData _propertys;
        public JsonData Propertys
        {
            get
            {
                if (_propertys == null)
                {
                    _propertys = JsonMapper.ToObject("{}");
                    if (ModelInfo.Table.Columns.Contains("Propertys") && ModelInfo["Propertys"].ToString().Length > 2 && ModelInfo["Propertys"].ToString().StartsWith("{"))
                    {
                        _propertys = JsonMapper.ToObject(ModelInfo["Propertys"].ToString());
                    }
                }
                return _propertys;
            }
        }
        public string getJsonText(string jsonstr, string name)
        {
            StringBuilder sb = new StringBuilder();
            if (jsonstr.Length > 0 && jsonstr.StartsWith("["))
            {

                JsonData data = JsonMapper.ToObject(jsonstr);
                foreach (JsonData jd in data)
                {
                    //eBase.Writeln(jd.getValue("value"));
                    sb.Append("<span style=\"display:inline-block;margin-right:6px;border:1px solid #ccc;padding:3px 12px 3px 12px;\">" + HttpUtility.HtmlDecode(jd.getValue(name)) + "</span>");
                }
                /*
                eJson json = new eJson(jsonstr);
                foreach (eJson m in json.GetCollection())
                {
                    sb.Append("<span style=\"display:inline-block;margin-right:6px;border:1px solid #ccc;padding:3px 12px 3px 12px;\">" + HttpUtility.HtmlDecode(m.GetValue(name)) + "</span>");
                }
                */
            }
            return sb.ToString();
        }
        protected void Page_Load(object sender, EventArgs e)
        {

            if (ModelInfo == null)
            {
                Response.Write("模块不存在!");
                Response.End();
            }

            if (eConfig.showHelp())
            {
                Response.Write("<div class=\"tips\" style=\"margin-bottom:6px;\">");
                Response.Write("<b>列表</b><br>");
                Response.Write("设置列表相关参数；显示列是否显示、显示顺序、显示宽度、高度、点击排序、自定义显示等相关参数。");
                Response.Write("</div> ");
            }
            if (ModelInfo["bType"].ToString() == "1" && ModelInfo["JoinMore"].ToString() == "True")
            {
                //Response.Write("外键：");
                //Response.Write("<input type=\"text\" value=\"" + ModelInfo["Foreignkey"].ToString() + "\" oldvalue=\"" + ModelInfo["Foreignkey"].ToString() + "\"  class=\"edit\" style=\"width:90px;\" onBlur=\"setModel(this,'foreignkey');\" />");

                Response.Write("窗口宽度：");
                Response.Write("<input type=\"text\" value=\"" + ModelInfo["width"].ToString() + "\" oldvalue=\"" + ModelInfo["width"].ToString() + "\"  class=\"edit\" style=\"width:90px;\" onBlur=\"setModel(this,'width');\" />");
                if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(84);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
                Response.Write("&nbsp;窗口高度：");
                Response.Write("<input type=\"text\" value=\"" + ModelInfo["height"].ToString() + "\" oldvalue=\"" + ModelInfo["height"].ToString() + "\"  class=\"edit\" style=\"width:90px;\" onBlur=\"setModel(this,'height');\" />");
                if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(85);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
                Response.Write("&nbsp;最少行数：");
                Response.Write("<input type=\"text\" value=\"" + ModelInfo["minCount"].ToString() + "\" oldvalue=\"" + ModelInfo["minCount"].ToString() + "\"  class=\"edit\" style=\"width:90px;\" onBlur=\"setModel(this,'mincount');\" />");
                if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(86);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
                Response.Write("&nbsp;最多行数：");
                Response.Write("<input type=\"text\" value=\"" + ModelInfo["maxCount"].ToString() + "\" oldvalue=\"" + ModelInfo["maxCount"].ToString() + "\"  class=\"edit\" style=\"width:90px;\" onBlur=\"setModel(this,'maxcount');\" />");
                if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(87);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
                Response.Write("<br>");
            }

            Response.Write("<input type=\"checkbox\" name=\"customheight\" id=\"customheight\" onclick=\"setModel(this,'customheight');\"" + (ModelInfo["customheight"].ToString() == "True" ? " checked" : "") + " /><label for=\"customheight\">拖动行高</label>");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(88);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");

            //Response.Write("<input type=\"checkbox\" name=\"customwidth\" id=\"customwidth\" onclick=\"setModel(this,'customwidth');\"" + (ModelInfo["customwidth"].ToString() == "True" ? " checked" : "") + " /><label for=\"customwidth\">拖动列宽</label>");
            Response.Write("<input type=\"checkbox\" name=\"customshow\" id=\"customshow\" onclick=\"setModel(this,'customshow');\"" + (ModelInfo["customshow"].ToString() == "True" ? " checked" : "") + " /><label for=\"customshow\">列显示隐藏菜单</label>"); //
            //Response.Write("<input type=\"checkbox\" name=\"custommove\" id=\"custommove\" onclick=\"setModel(this,'custommove');\"" + (ModelInfo["custommove"].ToString() == "True" ? " checked" : "") + " /><label for=\"custommove\">拖动行位置</label>");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(89);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");

            Response.Write("&nbsp;默认分页大小：<input type=\"text\" value=\"" + ModelInfo["PageSize"].ToString() + "\" oldvalue=\"" + ModelInfo["PageSize"].ToString() + "\"  class=\"edit\" style=\"width:40px;\" onBlur=\"setModel(this,'pagesize');\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(90);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("&nbsp;默认分页大小(M)：<input type=\"text\" value=\"" + ModelInfo["mPageSize"].ToString() + "\" oldvalue=\"" + ModelInfo["mPageSize"].ToString() + "\"  class=\"edit\" style=\"width:40px;\" onBlur=\"setModel(this,'mpagesize');\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(91);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("&nbsp;默认行高：<input type=\"text\" value=\"" + ModelInfo["LineHeight"].ToString() + "\" oldvalue=\"" + ModelInfo["LineHeight"].ToString() + "\"  class=\"edit\" style=\"width:40px;\" onBlur=\"setModel(this,'lineheight');\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(92);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("&nbsp;默认行高(M)：<input type=\"text\" value=\"" + ModelInfo["mLineHeight"].ToString() + "\" oldvalue=\"" + ModelInfo["mLineHeight"].ToString() + "\"  class=\"edit\" style=\"width:40px;\" onBlur=\"setModel(this,'mlineheight');\" />");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(93);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");

            //if (ModelInfo.Table.Columns.Contains("mListMode"))
            if(1==1)
            {
                
                Response.Write("&nbsp;列表样式(M)：");
                Response.Write("<select onchange=\"setModelPropertys(this,'mListMode');\">");//移动端-列表样式
                Response.Write("<option value=\"table\"" + (Propertys.getValue("mListMode").ToLower() == "table" ? " selected=\"true\"" : "") + ">表格</option>");
                Response.Write("<option value=\"panel\"" + (Propertys.getValue("mListMode").ToLower() == "panel" ? " selected=\"true\"" : "") + ">面板</option>");
                Response.Write("</select>");

                Response.Write("&nbsp;默认(M)：");
                Response.Write("<select onchange=\"setModelPropertys(this,'mListOpen');\">");//移动端-默认打开
                Response.Write("<option value=\"true\"" + (Propertys.getValue("mListOpen") == "true" ? " selected=\"true\"" : "") + ">打开</option>");
                Response.Write("<option value=\"false\"" + (Propertys.getValue("mListOpen") == "false" ? " selected=\"true\"" : "") + ">关闭</option>");
                Response.Write("</select>");
            }

            
            Response.Write("&nbsp;<input type=\"button\" name=\"Submit\" value=\"清除用户定义\" onclick=\"clearCustoms();\" />");

            if (ModelInfo["type"].ToString() == "5")
            {
                Response.Write("<input type=\"checkbox\" name=\"pagesum\" id=\"pagesum\" onclick=\"setModel(this,'pagesum');\"" + (ModelInfo["pagesum"].ToString() == "True" ? " checked" : "") + " /><label for=\"pagesum\">本页合计</label>");
                Response.Write("<select onchange=\"setModel(this,'sumtype');\">");//合计类型
                Response.Write("<option value=\"1\"" + (ModelInfo["SumType"].ToString() == "1" ? " selected=\"true\"" : "") + ">始终计算</option>");
                Response.Write("<option value=\"2\"" + (ModelInfo["SumType"].ToString() == "2" ? " selected=\"true\"" : "") + ">作为条件</option>");
                Response.Write("</select>");
            }


            Response.Write("<br>补充自定义列：");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(94);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("<br>\r\n");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"3\"  onBlur=\"setModel(this,'listfields');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["ListFields"].ToString()) + "\">" + System.Web.HttpUtility.HtmlEncode(ModelInfo["ListFields"].ToString()) + "</textarea>");
            Response.Write("<br>\r\n");


            Response.Write("联合表：");
            Response.Write("<br>\r\n");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"3\"  onBlur=\"setModel(this,'jointable');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["JoinTable"].ToString()) + "\">" + System.Web.HttpUtility.HtmlEncode(ModelInfo["JoinTable"].ToString()) + "</textarea>");
            Response.Write("<br>\r\n");

            //string value = eOleDB.getValue("select CondValue from a_eke_sysConditions where ModelID='" + modelid + "' and  RoleID is null and UserID is null and delTag=0");           
            //Response.Write("模块条件：<br>");
            //Response.Write("<input type=\"text\" value=\"" + System.Web.HttpUtility.HtmlEncode(value) + "\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(value) + "\"  class=\"edit\" style=\"width:90%;\" onBlur=\"setModel(this,'modelcondition');\" /><br>");



            //Response.Write("完整自定义列表查询：<br>");
            //Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"4\"  onBlur=\"setModel(this,'listsql');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["ListSQL"].ToString()) + "\">" + System.Web.HttpUtility.HtmlEncode(ModelInfo["ListSQL"].ToString()) + "</textarea><br>\r\n");

            Response.Write("基础条件：");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(95);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("<br>\r\n");
            Response.Write("<input type=\"text\" value=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["defaultcondition"].ToString()) + "\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["defaultcondition"].ToString()) + "\"  class=\"edit\" style=\"width:90%;\" onBlur=\"setModel(this,'defaultcondition');\" />");
            Response.Write("<br>\r\n");
            Response.Write("默认排序：");
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(96);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("<br>\r\n");
            Response.Write("<input type=\"text\" value=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["defaultorderby"].ToString()) + "\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["defaultorderby"].ToString()) + "\"  class=\"edit\" style=\"width:90%;\" onBlur=\"setModel(this,'defaultorderby');\" />");
            Response.Write("<br>\r\n");
            Response.Write("<div>");
            Response.Write("&nbsp;操作权限：<br>");
            Response.Write("<textarea reload=\"true\" id=\"actionpower\" jsonformat=\"[{&quot;text&quot;:&quot;动作编码&quot;,&quot;value&quot;:&quot;action&quot;},{&quot;text&quot;:&quot;字段编码&quot;,&quot;value&quot;:&quot;field&quot;},{&quot;text&quot;:&quot;值&quot;,&quot;value&quot;:&quot;value&quot;}]\" name=\"textarea\" style=\"width:90%;display:none;\" rows=\"2\"  onBlur=\"setModel(this,'actionpower');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(ModelInfo["actionPower"].ToString()) + "\">" + System.Web.HttpUtility.HtmlEncode(ModelInfo["actionPower"].ToString()) + "</textarea>");
            Response.Write("<img src=\"images/jsonedit.jpg\" style=\"cursor:pointer;margin-right:5px;\" align=\"absmiddle\" onclick=\"Json_Edit('actionpower');\">");
            Response.Write(getJsonText(ModelInfo["actionPower"].ToString(), "action"));
            if (eConfig.showHelp()) Response.Write(" <img src=\"images/help.gif\" align=\"absmiddle\" border=\"0\" onclick=\"showHelp(165);\" title=\"查看帮助\" alt=\"查看帮助\" style=\"cursor:pointer;margin-bottom:4px;\">");
            Response.Write("</div>");
           // eBase.Writeln(ModelInfo["actionPower"].ToString());


            eList datalist = new eList("a_eke_sysModelItems");
            datalist.Where.Add("ModelID='" + modelid + "' and delTag=0");
            datalist.OrderBy.Add("showlist desc,listorder,px");
            datalist.Bind(Rep);




            System.IO.StringWriter sw = new System.IO.StringWriter();
            HtmlTextWriter htw = new HtmlTextWriter(sw);
            Rep.RenderControl(htw);
            Rep.Visible = false;//不输出，要在获取后设，不然取不到内容。
            Response.Write(sw.ToString());
            sw.Close();


            Response.Write("<dl class=\"ePanel\" style=\"margin-top:10px;\">\r\n");
            Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>自定义样式</h1></dt>\r\n");
            Response.Write("<dd style=\"display:none;\">");
            Response.Write("<strong>PC端：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"4\"  onBlur=\"setModelPropertys(this,'CssText');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("CssText")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("CssText")) + "</textarea><br />");
            Response.Write("<strong>移动端：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"4\"  onBlur=\"setModelPropertys(this,'mCssText');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mCssText")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mCssText")) + "</textarea><br />");
            Response.Write("</dd>\r\n");
            Response.Write("</dl>\r\n");

            Response.Write("<strong>自定义列表：</strong><br />");
            Response.Write("<dl class=\"ePanel\" style=\"margin-top:10px;\">\r\n");
            Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>PC端</h1></dt>\r\n");
            Response.Write("<dd style=\"display:none;\">");
            Response.Write("<strong>开始标签：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"2\"  onBlur=\"setModelPropertys(this,'HeaderTemplate');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("HeaderTemplate")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("HeaderTemplate")) + "</textarea><br />");
            Response.Write("<strong>循环标签：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"4\"  onBlur=\"setModelPropertys(this,'ItemTemplate');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("ItemTemplate")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("ItemTemplate")) + "</textarea><br />");
            Response.Write("<strong>结束标签：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"2\"  onBlur=\"setModelPropertys(this,'FooterTemplate');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("FooterTemplate")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("FooterTemplate")) + "</textarea><br />");
            Response.Write("</dd>\r\n");
            Response.Write("</dl>\r\n");

            Response.Write("<dl class=\"ePanel\" style=\"margin-top:10px;\">\r\n");
            Response.Write("<dt><h1 onclick=\"showPanel(this);\"><a href=\"javascript:;\" class=\"cur\" onfocus=\"this.blur();\"></a>移动端</h1></dt>\r\n");
            Response.Write("<dd style=\"display:none;\">");
            Response.Write("<strong>开始标签：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"2\"  onBlur=\"setModelPropertys(this,'mHeaderTemplate');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mHeaderTemplate")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mHeaderTemplate")) + "</textarea><br />");
            Response.Write("<strong>循环标签：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"4\"  onBlur=\"setModelPropertys(this,'mItemTemplate');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mItemTemplate")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mItemTemplate")) + "</textarea><br />");
            Response.Write("<strong>结束标签：</strong><br />");
            Response.Write("<textarea name=\"textarea\" style=\"width:90%;\" rows=\"2\"  onBlur=\"setModelPropertys(this,'mFooterTemplate');\" oldvalue=\"" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mFooterTemplate")) + "\">" + System.Web.HttpUtility.HtmlEncode(Propertys.getValue("mFooterTemplate")) + "</textarea><br />");
            Response.Write("</dd>\r\n");
            Response.Write("</dl>\r\n");



            Response.End();
        }

        public string getPropertys(object item,string name)
        {

            DataRowView row = (DataRowView)item;
            if (row.DataView.Table.Columns.Contains("Propertys"))
            {
                if (row["Propertys"].ToString().Length > 0 && row["Propertys"].ToString().StartsWith("{"))
                {
                    JsonData jd = JsonMapper.ToObject(row["Propertys"].ToString());
                    if (jd.Contains(name))
                    {
                        return jd.getValue(name);
                    }
                }
            }
            return "";
        }
    }
}