﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using EKETEAM.Data;
using EKETEAM.FrameWork;

namespace eFrameWork.Manage
{
    public partial class SiteItems : System.Web.UI.Page
    {
        public string AppItem = "";
        public string siteid = "";
        public string act = "";
        private string parentModelID = "";
        string sql = "";
        /// <summary>
        /// 主库
        /// </summary>
        private eDataBase _database;
        private eDataBase DataBase
        {
            get
            {
                if (_database == null) _database = eOleDB.DataBase; 
                return _database;
            }
        }
        private DataTable _applications;
        public DataTable Applications
        {
            get
            {
                if (_applications == null)
                {
                    sql = "select a.ApplicationID,a.MC,b.SiteItemID,b.appName,b.domain from a_eke_sysApplications a";
                    sql += " left join a_eke_sysSiteItems b on a.ApplicationID=b.ApplicationID and b.SiteID='" + siteid + "'";
                    sql += " where a.delTag=0";
                    sql += " order by a.px,a.addTime";
                    _applications = DataBase.getDataTable(sql);
                    //_applications = DataBase.getDataTable("select a.ApplicationID,a.MC from a_eke_sysApplications a where a.delTag=0 order by a.px,a.addTime");
                }
                return _applications;
            }
        }
        private DataTable _applicationitems;
        public DataTable ApplitionItems
        {
            get
            {
                if (_applicationitems == null)
                {
                    sql = "select a.ApplicationItemID,a.ApplicationID,a.ModelID,a.ParentID,a.MC,b.Power,a.PX,a.addTime";
                    sql += " from a_eke_sysApplicationItems a";
                    sql += " left join a_eke_sysModels b on a.ModelID=b.ModelID";
                    sql += " where a.delTag=0";
                    _applicationitems = DataBase.getDataTable(sql);
                }
                return _applicationitems;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            siteid = eParameters.Request("id");

            act = eParameters.Request("act").ToLower();
            AppItem = eParameters.Request("AppItem");

            if (AppItem.Length > 0)
            {
                DataRow[] appRows = eBase.a_eke_sysApplicationItems.Select("ApplicationItemID='" + AppItem + "'");
                if (appRows.Length == 0) return;
                parentModelID = appRows[0]["ModelID"].ToString();
            }
            switch (act)
            {
                case "del":
                    sql = "update a_eke_sysSiteItems set delTag=1 where SiteID='" + siteid + "'";
                   // eOleDB.Execute(sql);
                    break;
                case "save":
                    save();
                    break;
                default:
                    LitBody.Text = getApps();
                    break;
            }

        }
        private void save()
        {
            eJson json = null;
            string jsonstr = eParameters.Form("eformdata_" + parentModelID);
            if (jsonstr.Length > 0)
            {

                json = new eJson(jsonstr);
                json.Convert = true;
                json = json.GetCollection("eformdata_" + parentModelID).GetCollection()[0];
            }          
            foreach (DataRow dr in Applications.Rows)
            {
                string name = "model_" + dr["ApplicationID"].ToString().Replace("-", "");
                string value = json == null ? eParameters.Form(name) : json.GetValue(name);
                if (value.Length > 0) //有权限
                {
                    string appname = "";                   
                    name = "appname_" + dr["ApplicationID"].ToString().Replace("-", "");
                    appname = json == null ? eParameters.Form(name) : json.GetValue(name);
                    appname = appname.Replace("'", "''");

                    string domain = "";
                    name = "domain_" + dr["ApplicationID"].ToString().Replace("-", "");
                    domain = json == null ? eParameters.Form(name) : json.GetValue(name);
                    domain = domain.Replace("'", "''");

                    sql = "if exists (select * from a_eke_sysSiteItems where ApplicationID='" + dr["ApplicationID"].ToString() + "' and SiteID='" + siteid + "')";
                    sql += " update a_eke_sysSiteItems set delTag=0,AppName='" + appname + "',domain='" + domain + "' where ApplicationID='" + dr["ApplicationID"].ToString() + "' and SiteID='" + siteid + "'";
                    sql += " else ";
                    sql += "insert into a_eke_sysSiteItems (ApplicationID,SiteID,AppName,domain) ";
                    sql += " values ('" + dr["ApplicationID"].ToString() + "','" + siteid + "','" + appname + "','" + domain + "')";

                    DataBase.Execute(sql);
                }
                else
                {
                    sql = "delete from a_eke_sysSiteItems where ApplicationID='" + dr["ApplicationID"].ToString() + "' and SiteID='" + siteid + "'";
                    DataBase.Execute(sql);
                }
            }

            eBase.clearDataCache("a_eke_sysSiteItems");
        }


        private string getApps()
        {
            StringBuilder sb = new StringBuilder();
            foreach (DataRow dr in Applications.Rows)
            {
                DataRow[] rows = ApplitionItems.Select("ApplicationID='" + dr["ApplicationID"].ToString() + "' and ParentID is null", "px,addTime");
                if (rows.Length == 0) continue;

                sb.Append("<div class=\"powerModel\">");
                sb.Append("<span class=\"modelname\">");
                sb.Append("<input type=\"checkbox\" name=\"model_" + dr["ApplicationID"].ToString().Replace("-", "") + "\" id=\"model_" + dr["ApplicationID"].ToString().Replace("-", "") + "\" value=\"true\"" + (dr["SiteItemID"].ToString().Length>0  ? " checked" : "") + (act == "view" ? " disabled" : "") + " />");
                sb.Append("<label for=\"model_" + dr["ApplicationID"].ToString().Replace("-", "") + "\">" + dr["mc"].ToString() + "</label>");
                sb.Append("</span>");

                sb.Append("<span class=\"cond\">");
                sb.Append("应用名称：<input type=\"text\" class=\"text\" name=\"appname_" + dr["ApplicationID"].ToString().Replace("-", "") + "\" value=\"" + (dr["appName"].ToString().Length > 0 ? dr["appName"].ToString() : dr["MC"].ToString()) + "\" />");
                sb.Append("</span>");


                sb.Append("<span class=\"cond\">");
                sb.Append("绑定域名：<input type=\"text\" class=\"text\" name=\"domain_" + dr["ApplicationID"].ToString().Replace("-", "") + "\" value=\"" + dr["domain"].ToString() + "\" />");
                sb.Append("</span>");

                sb.Append("</div>");


            }
            return sb.ToString();
        }
    }
}