﻿# Bootstrap Blazor Component

<a href="README.md">English</a> | <span>中文</span>

---

## 项目介绍
Blazor 是一个使用 .NET 生成交互式客户端 Web UI 的框架：

- 使用 C# 代替 JavaScript 来创建丰富的交互式 UI。
- 共享使用 .NET 编写的服务器端和客户端应用逻辑。
- 将 UI 呈现为 HTML 和 CSS，以支持众多浏览器，其中包括移动浏览器。

使用 .NET 进行客户端 Web 开发可提供以下优势：

- 使用 C# 代替 JavaScript 来编写代码。
- 利用现有的 .NET 库生态系统。
- 在服务器和客户端之间共享应用逻辑。
- 受益于 .NET 的性能、可靠性和安全性。
- 始终高效支持 Windows、Linux 和 macOS 上的 Visual Studio。
- 以一组稳定、功能丰富且易用的通用语言、框架和工具为基础来进行生成。

本项目是利用 Bootstrap 样式进行封装的 UI 组件库

## 组件

Blazor应用基于组件。 Blazor 中的组件是指 UI 元素，例如页面、对话框或数据输入窗体。

组件是内置到 .NET 程序集的 .NET 类，用来：
- 定义灵活的 UI 呈现逻辑。
- 处理用户事件。
- 可以嵌套和重用。
- 可以作为 Razor 类库或 NuGet 包共享和分发。

### 内置组件 

内置组件 [传送门](http://blazor.sdgxgz.com/alerts)

## 分支说明  

- master 稳定分支
- dev 开发功能分支
- publish 与演示网站同步
- 其他 均为临时分支

## 演示地址  
[![website](https://img.shields.io/badge/linux-http://blazor.sdgxgz.com-success.svg?logo=buzzfeed&logoColor=green)](http://blazor.sdgxgz.com)

## 项目截图

![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Toggle.png "Toggle.png")
![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Toast.png "Toast.png")
![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Upload.png "Upload.png")
![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Upload2.png "Upload2.png")
![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Bar.png "Bar.png")
![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Pie.png "Pei.png")
![登录可查看](https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Doughnut.png "Doughnut.png")

## 开源协议
[![Gitee license](https://img.shields.io/github/license/argozhang/bootstrapblazor.svg?logo=git&logoColor=red)](https://gitee.com/LongbowEnterprise/BootstrapBlazor/blob/master/LICENSE)

## 特别鸣谢

### 上海智通建设发展股份有限公司

特别鸣谢胡总对本项目的鼎力赞助 **10000** 元

<img src="https://gitee.com/LongbowEnterprise/Pictures/raw/master/BootstrapBlazor/Donate@x2.png" width="552px;" />

## 参与贡献

1. Fork 本项目
2. 新建 Feat_xxx 分支
3. 提交代码
4. 新建 Pull Request

## 捐助

如果这个项目对您有所帮助，请扫下方二维码打赏一杯咖啡。    

<img src="https://gitee.com/LongbowEnterprise/Pictures/raw/master/WeChat/BarCode@2x.png" width="382px;" />
