﻿using System;
using System.Data;
using System.Data.OleDb;

namespace ScanIP
{
    public class DbHelper
    {
        private string conStr = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + System.IO.Path.Combine(Environment.CurrentDirectory, "scanip");
        #region GetDataTable获取数据表
        /// <summary>
        /// 获取数据表
        /// </summary>
        /// <param name="sql">查询语句</param>
        /// <param name="parameters">参数数组</param>
        /// <returns>结果表</returns>
        public DataTable GetDataTable(string sql, params OleDbParameter[] parameters)
        {
            //创建命令对象（查询语句，连接通道的属性）
            using (OleDbConnection conn = new OleDbConnection(conStr))
            {
                conn.Open();
                using (OleDbCommand cmd = conn.CreateCommand())
                {
                    cmd.CommandText = sql;
                    if (parameters != null && parameters.Length > 0)
                    {
                        cmd.Parameters.AddRange(parameters); //为命令对象添加参数数组
                    }
                    OleDbDataAdapter da = new OleDbDataAdapter(cmd);
                    DataTable dt = new DataTable();
                    try
                    {
                        da.Fill(dt);
                    }
                    catch (Exception ex)
                    {
                        throw ex;
                    }
                    return dt;
                }
            }
        }
        #endregion
        #region SqlNonQuery非查询语句
        /// <summary>
        /// 非查询语句
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="parameters"></param>
        /// <returns>返回受影响的行数</returns>
        public int SqlNonQuery(string sql, params OleDbParameter[] parameters)
        {
            using (OleDbConnection conn = new OleDbConnection(conStr))
            {
                conn.Open();
                using (OleDbCommand cmd = new OleDbCommand(sql, conn))
                {
                    if (parameters != null && parameters.Length > 0)
                    {
                        cmd.Parameters.AddRange(parameters);
                    }
                    int rows = cmd.ExecuteNonQuery();
                    cmd.Parameters.Clear();
                    return rows;
                }
            }
        }
        #endregion
    }
}
