﻿using System;
using System.Collections.Generic;
using System.Management;
using System.Windows.Forms;
using System.Linq;
using System.Diagnostics;

namespace ChangeIP
{
    public partial class Form1 : Form
    {
        Soubu.Helper.IniHelper networkIni;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            string iniPath = System.Windows.Forms.Application.StartupPath + "\\ip.ini";
            this.networkIni = new Soubu.Helper.IniHelper(iniPath);
            GetNetworkCard();
            GetConfig();
            GetNetWorkState();
        }
        #region GetNetworkCard获得网卡列表
        /// <summary>
        /// 获得网卡列表
        /// </summary>
        private void GetNetworkCard()
        {
            #region Win32_NetworkAdapter属性说明
            //AdapterType  --适配器的类型
            //AdapterTypeID  --适配器的类型ID
            //AutoSense  --如果为True，网络适配器能自动判断连接或网络媒体的速度
            //Availability  --可用性和设备的状态
            //Caption  --设备的简短描述
            //ConfigManagerErrorCode  --Windows配置管理器错误代码
            //ConfigManagerUserConfig  --如果为True，该设备使用用户定义的配置
            //CreationClassName  --第一个具体类的名称出现在创建实例所使用的继承链
            //Description  --描述
            //DeviceID  --系统中的其他设备的网络适配器的唯一标识符
            //ErrorCleared  --如果为True，在上一个错误代码报告现已清除
            //ErrorDescription  --错误的描述信息
            //GUID  --全局唯一标识符进行连接
            //Index  --存储在系统注册表中网络适配器的索引号
            //InstallDate  --日期和时间对象安装
            //Installed  --如果为True，网络适配器安装在系统中
            //InterfaceIndex  --索引值唯一标识本地网络接口
            //LastErrorCode  --报告的逻辑设备上一个错误代码
            //MACAddress  --MAC地址
            //Manufacturer  --制造商的名称
            //MaxNumberControlled  --通过这个网络适配器支持直接寻址的端口的最大数量
            //MaxSpeed  --最大速度，以每秒位数，为网络适配器
            //Name  --适配器的名称
            //NetConnectionID  --网络连接的名称出现在网络连接控制面板程序
            //NetConnectionStatus  --网络适配器连接至网络的状态
            //NetEnabled  --指明适配器是否已启用。如果为True，适配器已启用。您可以启用或通过启用和禁用方法禁用网卡。
            //NetworkAddresses  --适配器的IP地址
            //PermanentAddress  --网络地址硬编码到一个适配器。这种硬编码地址，可以通过固件升级或软件配置进行更改
            //PhysicalAdapter  --指明适配器是否是物理或逻辑适配器。如果为True，适配器是物理
            //PNPDeviceID  --即插即用逻辑设备的播放设备标识符
            //PowerManagementCapabilities  --逻辑设备的特定功率相关的能力阵列
            //PowerManagementSupported  --如果为True，该设备可以是电源管理（可放进入暂停模式，等等）
            //ProductName  --网络适配器的产品名称
            //ServiceName  --网络适配器的服务名
            //Speed  --估计当前带宽比特每秒
            //Status  --对象的当前状态
            //StatusInfo  --对象的当前状态详细信息
            //SystemCreationClassName  --该作用域计算机的创建类别名称属性的值
            //SystemName  --系统名称
            //TimeOfLastReset  --最后复位日期和时间的网络适配器 
            #endregion
            string manage = "SELECT * From Win32_NetworkAdapter";
            ManagementObjectSearcher searcher = new ManagementObjectSearcher(manage);
            ManagementObjectCollection collection = searcher.Get();
            //List<string> netWorkList = new List<string>();
            string[] keys, values;
            this.networkIni.GetAllKeyValues("networkCard", out keys, out values);
            foreach (ManagementObject obj in collection) //遍历系统内的网卡
            {
                string name = obj["Name"].ToString();
                if (!keys.Contains(name))
                {
                    this.networkIni.WriteIni("networkCard", name, string.Empty);
                }
            }
            string defaultNetwork = this.networkIni.ReadIni("defaultData", "networkcard"); //默认选中的网卡名称
            Dictionary<string, string> dic = new Dictionary<string, string>();
            for (int i = 0; i < keys.Length; i++) //遍历配置文件中的网卡名称，加载到下拉列表
            {
                if (values[i].ToLower() == "disabled")
                {
                    continue;
                }
                dic.Add(keys[i], string.IsNullOrWhiteSpace(values[i]) ? keys[i] : values[i]);
            }
            cboNetworkCard.DataSource = new BindingSource(dic, null);
            int j = 0;
            foreach (KeyValuePair<string, string> item in dic)
            {
                if (item.Key == defaultNetwork)
                {
                    cboNetworkCard.SelectedIndex = j; //默认选中
                    break;
                }
                j++;
            }
            cboNetworkCard.DisplayMember = "value";
            cboNetworkCard.ValueMember = "key";
        }
        #endregion
        #region GetConfig获得网卡配置
        /// <summary>
        /// 获得网卡配置
        /// </summary>
        protected void GetConfig()
        {
            List<string> list = new List<string>(); //系统配置节点，不加载到单位列表
            list.Add("defaultdata");
            list.Add("networkcard");
            string[] arrDept;
            this.networkIni.GetAllSectionNames(out arrDept);
            string[] arrResult = arrDept.Where(a => !list.Contains(a.ToLower())).ToArray();
            this.cboDept.Items.AddRange(arrResult);
            int i = Array.IndexOf(arrResult, this.networkIni.ReadIni("defaultData", "dept"));
            cboDept.SelectedIndex = i < 0 ? 0 : i; //默认选中
        }
        #endregion
        #region 获得得指定的网卡 GetNetwork
        /// <summary>
        /// 获得得指定的网卡
        /// </summary>
        /// <param name="networkname">网卡名字</param>
        /// <returns></returns>
        public ManagementObject GetNetwork()
        {
            string networkName = GetNetworkName();
            string netState = "SELECT * From Win32_NetworkAdapter";

            ManagementObjectSearcher searcher = new ManagementObjectSearcher(netState);
            ManagementObjectCollection collection = searcher.Get();

            foreach (ManagementObject manage in collection)
            {
                if (manage["Name"].ToString() == networkName)
                {
                    return manage;
                }
            }
            return null;
        }
        #endregion
        #region GetNetworkName获得选中的网卡名
        /// <summary>
        /// 获得选中的网卡名
        /// </summary>
        /// <returns></returns>
        private string GetNetworkName()
        {
            return ((KeyValuePair<string, string>)this.cboNetworkCard.SelectedItem).Key;
        }
        /// <summary>
        /// 获得选中的网卡别名
        /// </summary>
        /// <returns></returns>
        private string GetNetworkName2()
        {
            return ((KeyValuePair<string, string>)this.cboNetworkCard.SelectedItem).Value;
        }
        #endregion
        #region GetNetWorkState网卡状态
        /// <summary>
        /// 网卡状态
        /// </summary>
        /// <returns></returns>
        public bool GetNetWorkState()
        {
            ManagementObject network = GetNetwork();
            //if (network == null)
            //{
            //    MessageBox.Show("找不到该网卡名称");
            //    return false;
            //}
            bool state = Convert.ToBoolean(network["NetEnabled"]);
            if (state)
            {
                this.btnStatus.Text = "禁用";
            }
            else
            {
                this.btnStatus.Text = "启用";
            }
            return state;
        }
        #endregion
        #region NetworkEnable启用网卡
        /// <summary>
        /// 启用网卡
        /// </summary>
        /// <param name="network">网卡名</param>
        /// <param name="bMsg">是否弹出提示对话框</param>
        /// <returns></returns>
        public bool NetworkEnable(ManagementObject network, bool bMsg)
        {
            try
            {
                network.InvokeMethod("Enable", null);
                if (bMsg) MessageBox.Show(GetNetworkName2() + "启用成功");
                GetNetWorkState();
                return true;
            }
            catch
            {
                MessageBox.Show(GetNetworkName2() + "启用失败");
                return false;
            }

        }
        #endregion
        #region NetworkDisable 禁用网卡
        /// <summary>
        /// 禁用网卡
        /// </summary>5
        /// <param name="netWorkName">网卡名</param>
        /// <returns></returns>
        public bool NetworkDisable(ManagementObject network)
        {
            try
            {
                network.InvokeMethod("Disable", null);
                MessageBox.Show(GetNetworkName2() + "禁用成功");
                GetNetWorkState();
                return true;
            }
            catch
            {
                MessageBox.Show(GetNetworkName2() + "禁用失败");
                return false;
            }
        }
        #endregion
        #region NetworkIp 设置指定网卡的IP
        /// <summary>
        /// 设置指定网卡的IP
        /// </summary>
        /// <returns></returns>
        private void NetworkIp()
        {
            if (!GetNetWorkState()) NetworkEnable(GetNetwork(), false); //如果网卡处于禁用状态，先启用
            string macAddress = GetNetwork()["MACAddress"].ToString(); //启用成功后，需要重新获取网卡信息
            ManagementBaseObject inPar = null;
            ManagementBaseObject outPar = null;
            ManagementClass mc = new ManagementClass("Win32_NetworkAdapterConfiguration");
            ManagementObjectCollection moc = mc.GetInstances();
            foreach (ManagementObject mo in moc)
            {
                //if (!(bool)mo["IPEnabled"])
                if (mo["MacAddress"] == null) continue;
                if (mo["MacAddress"].ToString() != macAddress)
                    continue;

                if (this.tbo_ip.Text == "auto")
                {
                    mo.InvokeMethod("EnableDHCP", null); //设置自动获取 IP
                    mo.InvokeMethod("ReleaseDHCPLease", null); // 释放 IP
                    mo.InvokeMethod("RenewDHCPLease", null); // 重新取得 IP
                    mo.InvokeMethod("SetDNSServerSearchOrder", null);
                }
                else
                {
                    //设置ip地址和子网掩码 
                    inPar = mo.GetMethodParameters("EnableStatic");
                    if (string.IsNullOrWhiteSpace(this.tbo_ip.Text) || string.IsNullOrWhiteSpace(this.tbo_mask.Text))
                    {
                        MessageBox.Show("IP和子掩网码不能为空");
                        return;
                    }
                    else
                    {
                        inPar["IPAddress"] = new string[] { this.tbo_ip.Text };
                        inPar["SubnetMask"] = new string[] { this.tbo_mask.Text };
                        outPar = mo.InvokeMethod("EnableStatic", inPar, null);
                    }

                    if (!string.IsNullOrWhiteSpace(this.tboGateway.Text) && !this.cboGateway.Checked)
                    {
                        //设置网关地址 
                        inPar = mo.GetMethodParameters("SetGateways");
                        inPar["DefaultIPGateway"] = new string[] { this.tboGateway.Text };
                        outPar = mo.InvokeMethod("SetGateways", inPar, null);
                    }
                }
                if (!string.IsNullOrWhiteSpace(this.tboDns1.Text))
                {
                    //设置DNS 
                    inPar = mo.GetMethodParameters("SetDNSServerSearchOrder");
                    inPar["DNSServerSearchOrder"] = new string[] { this.tboDns1.Text, this.tboDns2.Text };
                    outPar = mo.InvokeMethod("SetDNSServerSearchOrder", inPar, null);
                }
            }
            GetNetWorkState();
            //MessageBox.Show("网卡设置完成！");
        }
        #endregion
        #region RouteAdd 把网关添加到路由表中
        /// <summary>
        /// 把网关添加到路由表中
        /// </summary>
        private void RouteAdd()
        {
            string gateway = this.tboGateway.Text;
            if (string.IsNullOrWhiteSpace(gateway)) return;
            string[] arrGateway = gateway.Split('.');
            Process p = new Process();
            //设置要启动的应用程序
            p.StartInfo.FileName = "cmd.exe";
            //是否使用操作系统shell启动
            p.StartInfo.UseShellExecute = false;
            // 接受来自调用程序的输入信息
            p.StartInfo.RedirectStandardInput = true;
            //输出信息
            p.StartInfo.RedirectStandardOutput = true;
            // 输出错误
            p.StartInfo.RedirectStandardError = true;
            //不显示程序窗口
            p.StartInfo.CreateNoWindow = true;
            //启动程序
            p.Start();
            string roure = "route add " + arrGateway[0] + ".0.0.0 mask 255.0.0.0 " + gateway;
            p.StandardInput.WriteLine(roure);
            p.StandardInput.WriteLine("exit");
            p.StandardInput.AutoFlush = true;

            //string strOuput = p.StandardOutput.ReadToEnd(); //获得输出信息
            //MessageBox.Show(strOuput);
            //等待程序执行完退出进程
            p.WaitForExit();
            p.Close();
        }
        #endregion
        #region button1_Click 设置IP
        /// <summary>
        /// 设置IP
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            NetworkIp();
            if (this.cboGateway.Checked) RouteAdd();
            MessageBox.Show("设置完成");
        }
        #endregion

        #region cboDept的下拉列表改变事件
        /// <summary>
        /// cboDept的下拉列表改变事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            networkIni.WriteIni("defaultData", "dept", this.cboDept.Text);
            this.tbo_ip.Text = this.networkIni.ReadIni(this.cboDept.Text, "ip");
            this.tbo_mask.Text = this.networkIni.ReadIni(this.cboDept.Text, "mask");
            this.tboGateway.Text = this.networkIni.ReadIni(this.cboDept.Text, "gateway");
            this.tboDns1.Text = this.networkIni.ReadIni(this.cboDept.Text, "dns1");
            this.tboDns2.Text = this.networkIni.ReadIni(this.cboDept.Text, "dns2");
            this.cboGateway.Checked = this.networkIni.ReadIni(this.cboDept.Text, "route").ToUpper() == "TRUE";
            //GetNetWorkState(this.cboNetworkCard.SelectedValue.ToString());
        }
        #endregion
        #region cboNetworkCard_SelectedIndexChanged 网卡下拉列表的change事件
        /// <summary>
        /// 网卡下拉列表的change事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cboNetworkCard_SelectedIndexChanged(object sender, EventArgs e)
        {
            networkIni.WriteIni("defaultData", "networkcard", GetNetworkName());
            GetNetWorkState();
        } 
        #endregion
        #region btnStatus_Click启用或禁用网卡
        /// <summary>
        /// 启用或禁用网卡
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnStatus_Click(object sender, EventArgs e)
        {
            if (GetNetWorkState())
            {
                NetworkDisable(GetNetwork());
            }
            else
            {
                NetworkEnable(GetNetwork(), true);
            }
        } 
        #endregion

        /// <summary>
        /// 创建或修改单位及ip信息
        /// </summary>
        private void AlterIni()
        {
            string dept = this.cboDept.Text.Replace(" ", string.Empty).Replace("　", string.Empty);
            this.networkIni.WriteIni(dept, "ip", this.tbo_ip.Text.Replace(" ", string.Empty).Replace("　", string.Empty));
            this.networkIni.WriteIni(dept, "mask", this.tbo_mask.Text.Replace(" ", string.Empty).Replace("　", string.Empty));
            this.networkIni.WriteIni(dept, "gateway", this.tboGateway.Text.Replace(" ", string.Empty).Replace("　", string.Empty));
            this.networkIni.WriteIni(dept, "route", this.cboGateway.Checked.ToString());
            this.networkIni.WriteIni(dept, "dns1", this.tboDns1.Text.Replace(" ", string.Empty).Replace("　", string.Empty));
            this.networkIni.WriteIni(dept, "dns2", this.tboDns2.Text.Replace(" ", string.Empty).Replace("　", string.Empty));
        }
        #region cboDept_Leave单位失去焦点时
        /// <summary>
        /// 单位失去焦点时
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cboDept_Leave(object sender, EventArgs e)
        {
            AlterIni();
        } 
        #endregion
        #region tbo_ip_Leave IP失去焦点时
        /// <summary>
        /// IP失去焦点时
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tbo_ip_Leave(object sender, EventArgs e)
        {
            AlterIni();
        } 
        #endregion
        #region tbo_mask_Leave子网掩码失去焦点时
        /// <summary>
        /// 子网掩码失去焦点时
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tbo_mask_Leave(object sender, EventArgs e)
        {
            AlterIni();
        } 
        #endregion
        #region tboGateway_Leave　网关失去焦点时
        /// <summary>
        /// 网关失去焦点时
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tboGateway_Leave(object sender, EventArgs e)
        {
            AlterIni();
        } 
        #endregion
        #region tboDns1_Leave dns1失去焦点时
        /// <summary>
        /// dns1失去焦点时
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tboDns1_Leave(object sender, EventArgs e)
        {
            AlterIni();
        } 
        #endregion
        #region tboDns2_Leave dns2失去焦点时
        /// <summary>
        /// dns2失去焦点时
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tboDns2_Leave(object sender, EventArgs e)
        {
            AlterIni();
        } 
        #endregion
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cboGateway_CheckedChanged(object sender, EventArgs e)
        {
            AlterIni();
        }
        /// <summary>
        /// 删除配置信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (this.cboDept.Text == "自动获取")
            {
                MessageBox.Show("自动获取为本软件自带配置，不允许删除");
                return;
            }
            this.networkIni.DeleteIni(this.cboDept.Text);
            MessageBox.Show(this.cboDept.Text + "配置已删除");
            this.cboDept.Items.Clear();
            GetConfig();
        }
    }
}
