﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace 多数据库一键修改
{
    public partial class Form1 : Form
    {
        List<string> list = new List<string>();
        public Form1()
        {
            InitializeComponent();
        }
        #region GetConfig获取ini配置，把参数显示到界面
        /// <summary>
        /// 获取ini配置
        /// </summary>
        private void GetConfig()
        {
            Soubu.Helper.IniHelper ini = new Soubu.Helper.IniHelper(System.Windows.Forms.Application.StartupPath + "/ini/config.ini");
            string[] sections;
            ini.GetAllSectionNames(out sections);
            
            foreach (string item in sections)
            {
                string conStr = ini.ReadIni(item, "configString");
                string sql_select = ini.ReadIni(item, "sql_select");
                string sql_update = ini.ReadIni(item, "sql_update");
                if (sql_select.Contains("*"))
                {
                    this.btnSearch.Enabled = false;
                    this.btnUpdate.Enabled = false;
                    MessageBox.Show("Select语句字段名不允许能用*替代，请修改sql语句后重启程序");
                    return;
                }
                Regex reg = new Regex(@"(@).*?(#)");
                MatchCollection matches = reg.Matches(sql_select);
                foreach (object item1 in matches)
                {
                    if (!list.Contains(item1.ToString()))
                    {
                        list.Add(item1.ToString());
                    }
                }
                matches = reg.Matches(sql_update);
                foreach (object item1 in matches)
                {
                    if (!list.Contains(item1.ToString()))
                    {
                        list.Add(item1.ToString());
                    }
                }
                int top = 30;
                foreach (string item1 in list)
                {
                    Label lbl = new Label();
                    lbl.Text = item1;
                    lbl.Top = top;
                    lbl.TextAlign = ContentAlignment.MiddleRight;
                    this.Controls.Add(lbl);
                    TextBox tbo = new TextBox();
                    tbo.Name = item1;
                    tbo.Text = string.Empty;
                    tbo.Left = lbl.Width + 10;
                    tbo.Top = top;
                    tbo.Width = 222;
                    this.Controls.Add(tbo);
                    top += 30;
                }
            }
        } 
        #endregion

        private void Form1_Load(object sender, EventArgs e)
        {
            this.webBrowser.IsWebBrowserContextMenuEnabled = false; //禁止右键
            GetConfig();
        }

        #region btnSearch_Click搜索
        private void btnSearch_Click(object sender, EventArgs e)
        {
            this.dgv.Visible = true;
            this.webBrowser.Visible = false;
            Soubu.Helper.IniHelper ini = new Soubu.Helper.IniHelper(System.Windows.Forms.Application.StartupPath + "/ini/config.ini");
            string[] sections;
            ini.GetAllSectionNames(out sections);
            Dictionary<string, string> dic = new Dictionary<string, string>();
            foreach (Control item in this.Controls)
            {
                if (item is TextBox)
                {
                    TextBox tbo = ((TextBox)item);
                    if (!dic.ContainsKey(tbo.Name)) dic.Add(tbo.Name, tbo.Text);
                }
            }
            DataTable dataTable = new DataTable();
            foreach (string item in sections)
            {
                string conStr = ini.ReadIni(item, "configString").Replace("＝", "=");
                string providerName = ini.ReadIni(item, "providerName");
                string sql_select = ini.ReadIni(item, "sql_select").Replace("＝", "=");
                if (string.IsNullOrWhiteSpace(sql_select)) continue;

                Regex reg = new Regex(@"(@).*?(#)");
                MatchCollection matches = reg.Matches(sql_select);
                bool flag = false;
                foreach (object item1 in matches)
                {
                    string val = dic[item1.ToString()];
                    if (string.IsNullOrWhiteSpace(val))
                    {
                        MessageBox.Show(item1 + "为空，搜索失败sql：" + sql_select);
                        flag = true;
                    }
                    sql_select = sql_select.Replace(item1.ToString(), val);
                }
                if (flag) continue;
                Soubu.DbHelper.DbHelper db = new Soubu.DbHelper.DbHelper(Guid.NewGuid().ToString("N"), conStr, providerName);
                DataTable dt = db.QueryDataTable(sql_select);
                dataTable.Merge(dt);
            }
            dgv.DataSource = dataTable;
        } 
        #endregion

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            this.dgv.Visible = true;
            this.webBrowser.Visible = false;
            Soubu.Helper.IniHelper ini = new Soubu.Helper.IniHelper(System.Windows.Forms.Application.StartupPath + "/ini/config.ini");
            string[] sections;
            ini.GetAllSectionNames(out sections);
            Dictionary<string, string> dic = new Dictionary<string, string>();
            foreach (Control item in this.Controls)
            {
                if (item is TextBox)
                {
                    TextBox tbo = ((TextBox)item);
                    if (!dic.ContainsKey(tbo.Name)) dic.Add(tbo.Name, tbo.Text);
                }
            }

            int i = 0;
            foreach (string item in sections)
            {
                string conStr = ini.ReadIni(item, "configString").Replace("＝", "=");
                string providerName = ini.ReadIni(item, "providerName");
                string sql_update = ini.ReadIni(item, "sql_update").Replace("＝", "=");
                if (string.IsNullOrWhiteSpace(sql_update)) continue;
                if (!sql_update.ToLower().Contains("where"))
                {
                    MessageBox.Show("update语句必须有where，where只能小写");
                    return;
                }
                Regex reg = new Regex(@"(@).*?(#)");
                MatchCollection matches = reg.Matches(sql_update.Replace("where", "|").Split('|')[1]);
                foreach (object item1 in matches)
                { //检查where条件是否有值
                    string val = dic[item1.ToString()];
                    if (string.IsNullOrWhiteSpace(val))
                    {
                        MessageBox.Show(item1 + "为空，update失败，sql：" + sql_update);
                        return;
                    }
                }

                matches = reg.Matches(sql_update);
                foreach (object item1 in matches)
                {
                    string val = dic[item1.ToString()];
                    sql_update = sql_update.Replace(item1.ToString(), val);
                }
                Soubu.DbHelper.DbHelper db = new Soubu.DbHelper.DbHelper(Guid.NewGuid().ToString("N"), conStr, providerName);
                i += db.QueryNon(sql_update);
            }
            if (i > 0)
            {
                MessageBox.Show("共修改" + i + "条记录");
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.webBrowser.Visible = true;
            this.dgv.Visible = false;
        }

    }
}
