﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="baidumap.aspx.cs" Inherits="YCHR.Web.newhr.baidumap" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>企业电子地图-<%=config.sitename %></title>
<link rel="stylesheet" type="text/css" href="<%=config.templatetheme%>/css/member.css" />
<style type="text/css">
<!--
.emap {
	padding:10px 20px;
	line-height:33px;
	padding-right:77px;
}
#container {
	margin:18px auto;
	width:630px;
	height:400px;
	border:1px solid #ccc;
	padding:1px;
}
-->
</style>
<script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.js"></script>
<script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.validate.min.js"></script>
<script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.form.js"></script>
<script type="text/javascript" src="http://api.map.baidu.com/api?v=1.3"></script>
<script type="text/javascript">
    var markerArr = [];
    $(document).ready(function () {
        //创建地图
        createMap();
        //设置函数事件
        setMapEvent();
        //添加控件
        addMapControl();
        //搜索定位
        searchLocation();
        //resetMap
        resetMap();

        $('#hidComAddress').val($('#address').val());
        $('#hidMapX').val($('#mapX').val());
        $('#hidMapY').val($('#mapY').val());
    });
    //创建地图函数：
    function createMap() {
        var map = new BMap.Map("container");            //在百度地图容器中创建一个地图
        window.map = map;                                      //将map变量存储在全局
        var showMarker = <%=showMarker %>;                  //是否已经有标注点

        var showMapY = <%=showMapY %>;
        var showMapX = <%=showMapX %>;
        var showMapMsg = '|';
        var showMapZoom = 18;
        var showIsShow = 1;

        if (showMarker) {
            var showPoint = new BMap.Point(showMapY, showMapX);         //当前标注点为中心坐标
            map.centerAndZoom(showPoint, showMapZoom);

            //给隐藏域赋值
            $('#mapX').val(showMapX);
            $('#mapY').val(showMapY);
            $('#mapMsg').val(showMapMsg);
            $('#mapZoom').val(showMapZoom);
            //勾选前台显示
            if (showIsShow == 1) {
                $('#ckMapIsShow').attr("checked", "checked");
            }
            else {
                $('#ckMapIsShow').attr("checked", "");
            }
            $('#mapIsShow').val(showIsShow);

            markerArr.push({ point: showMapY + "|" + showMapX, isOpen: 0, icon: { w: 21, h: 21, l: 0, t: 0, x: 6, lb: 5} });
            addMarker();
        } else {
            var point = new BMap.Point(120.20000,30.26667);            // 创建中心点坐标
            map.centerAndZoom(point, 12);                            //设定地图的中心点和坐标并将地图显示在地图容器中 
        }


        //鼠标左单击
        map.addEventListener("click", function (e) {
            
            if (markerArr.length == 0) {
                $('#mapX').val(e.point.lat);
                $('#mapY').val(e.point.lng);
                //公司名和地址
                var companyName = $('#companyname').val(); 
                var companyAddress = $('#address').val();
                $('#mapMsg').val(companyName + "|" + companyAddress);
                $('#mapZoom').val(map.getZoom());
                var mapY = $('#mapY').val()
                var mapX = $('#mapX').val();

                markerArr.push({ point: mapY + "|" + mapX, isOpen: 0, icon: { w: 21, h: 21, l: 0, t: 0, x: 6, lb: 5} });
                addMarker();
            } else {
                alert("已添加了标注，右键取消后可重设标注！！");
                
                return;
            }
        });

        //地图缩放级别结束时
        map.addEventListener("zoomend", function () {
            $('#mapZoom').val(map.getZoom());
        });

    }
    //地图事件设置函数：
    function setMapEvent() {
        map.enableDragging();           //启用地图拖拽事件，默认启用(可不写)
        map.enableScrollWheelZoom();    //启用地图滚轮放大缩小
        map.enableDoubleClickZoom();    //启用鼠标双击放大，默认启用(可不写)
        map.enableKeyboard();           //启用键盘上下左右键移动地图
    }
    //地图控件添加函数：
    function addMapControl() {
        //向地图中添加缩放控件
        var ctrl_nav = new BMap.NavigationControl({ anchor: BMAP_ANCHOR_TOP_RIGHT, offset: new BMap.Size(10, 10) });
        map.addControl(ctrl_nav);
        //向地图中添加缩略图控件
        var ctrl_ove = new BMap.OverviewMapControl({ anchor: BMAP_ANCHOR_BOTTOM_RIGHT, isOpen: 0 });
        map.addControl(ctrl_ove);
    }

    //创建marker
    function addMarker() {
        for (var i = 0; i < markerArr.length; i++) {
            var json = markerArr[i];
            var p0 = json.point.split("|")[0];
            var p1 = json.point.split("|")[1];
            var point = new BMap.Point(p0, p1);
            var iconImg = createIcon(json.icon);
            var marker = new BMap.Marker(point, { icon: iconImg });
            window.marker = marker;                         //全局
            map.addOverlay(marker);
            marker.enableDragging(true);                    //可拖拽

            //标注拖拽后经纬度
            marker.addEventListener("dragend", function (e) {
                $('#mapX').val(e.point.lat);
                $('#mapY').val(e.point.lng);
            });
        }
        //右键菜单
        rightMenu();
    }

    //创建一个Icon
    function createIcon(json) {
        var icon = new BMap.Icon("<%=config.templatetheme%>/Images/member/baidu_icon.png", new BMap.Size(json.w, json.h), { imageOffset: new BMap.Size(-json.l, -json.t), infoWindowAnchor: new BMap.Size(json.lb + 5, 1), anchor: new BMap.Size(json.x, json.h) })
        return icon;
    }

    //搜索定位
    function searchLocation() {
        //根据地址查找定位
        $('#btnCreateMap').click(function () {
            //清空覆盖物
            map.clearOverlays();
            //每次解析置为空
            markerArr = [];
            //地址
            var address = $('#address').val();
            // 创建地址解析器实例
            var myGeo = new BMap.Geocoder();
            // 将地址解析结果显示在地图上,并调整地图视野
             myGeo.getPoint(address, function (point) {
                if (point) {
                    map.centerAndZoom(point, 18);
                    if (markerArr.length == 0) {
                        $('#mapX').val(point.lat);
                        $('#mapY').val(point.lng);
                        //公司名和地址
                        var companyName = $('#companyname').val();
                        var companyAddress = $('#address').val();
                        $('#mapMsg').val(companyName + "|" + companyAddress);
                        $('#mapZoom').val(map.getZoom());

                        markerArr.push({ point: point.lng + "|" + point.lat, isOpen: 0, icon: { w: 21, h: 21, l: 0, t: 0, x: 6, lb: 5} });
                        addMarker();
                    }
                } else {
                    alert("地址解析失败(可能是您的地址百度还不知道),请填写正确的地址或鼠标拉动选择您的位置！");
                    return;
                }
            }, "");
        });
    }

    //右键菜单
    function rightMenu() {
        var menu = new BMap.ContextMenu();
        var txtMenuItem = [
                    {
                        text: '删除地图标注信息',
                        width: 100,
                        callback: function () {
                           
                            if (markerArr.length != 0) {
                               
                                    //清空覆盖物
                                    map.clearOverlays();
                                    //清空标注数组
                                    markerArr = [];
                                    //移除右键菜单
                                    map.removeContextMenu(menu);
                                    //清空地图信息
                                    $('#mapX').val("");
                                    $('#mapY').val("");
                                    $('#mapZoom').val("");
                                    $('#mapMsg').val("");
                              
                            } else {
                                alert("您还没有添加标注!");

                                return;
                            }
                        }
                    }];


        for (var i = 0; i < txtMenuItem.length; i++) {
            menu.addItem(new BMap.MenuItem(txtMenuItem[i].text, txtMenuItem[i].callback, 100));
        }
        if (markerArr.length != 0) {
            map.addContextMenu(menu);
        }
    }

    //是否展示于前台
    function isShow() {
        if ($('#ckMapIsShow').attr("checked") == true) {
            $('#mapIsShow').val(1);
        } else {
            $('#mapIsShow').val(0);
        }
    }

    //重置
    function resetMap() {
        $('#btnResetMap').click(function () {
            if (markerArr.length == 0) {
                $.confirm('您确定要将地图恢复到初始状态吗？', '操作提示', function () {
                    //清空覆盖物
                    map.clearOverlays();
                    //清空标注数组
                    markerArr = [];
                    //清空地图信息
                    $('#mapX').val("");
                    $('#mapY').val("");
                    $('#mapZoom').val("");
                    $('#mapMsg').val("");

                    var point = new BMap.Point(120.20000,30.26667);            // 创建中心点坐标
                    map.centerAndZoom(point, 12);                            //设定地图的中心点和坐标并将地图显示在地图容器中 

                });
            }
            else if (markerArr.length > 0) {
                $.confirm('您确定要删除已标注的地图信息并将地图恢复到初始状态吗？', '操作提示', function () {
                    //清空覆盖物
                    map.clearOverlays();
                    //清空标注数组
                    markerArr = [];
                    //清空地图信息
                    $('#mapX').val("");
                    $('#mapY').val("");
                    $('#mapZoom').val("");
                    $('#mapMsg').val("");

                    var point = new BMap.Point(116.4035,39.915,8);            // 创建中心点坐标
                    map.centerAndZoom(point, 12);                            //设定地图的中心点和坐标并将地图显示在地图容器中 

                });
            }
        });
    }
    </script>
<script type="text/javascript">

        $(document).ready(function () {
            $("#form1").validate({
                success: function (label) {
                    label.text(" ").addClass("success")
                },
                rules: {
                    companyname: { required: true },

                    address: { required: true }

                },
                messages: { companyname: { required: "请填写公司名称"
                },
                    address: { required: "请填写公司地址" }

                }, errorElement: "span", 
                errorPlacement: function (error, element) {
                    if (element.is(":radio")) error.appendTo(element.parent().next().next());
                    else if (element.is(":checkbox")) error.appendTo(element.next());
                    else error.appendTo(element.parent())
                }
            })
        });
        // 电话号码验证
        $.validator.addMethod("phone", function (value, element) {
            var tel = /^(0[0-9]{2,3}\-)?([2-9][0-9]{6,7})+(\-[0-9]{1,4})?$/;
            return this.optional(element) || (tel.test(value));
        }, "电话号码格式错误");
        // 工作年限验证 
        $.validator.addMethod("isSituationSelect", function (value, element) {
            var Situation = value;
            return this.optional(element) || (Situation != "");
        }, "请选择工作年限");
        $.validator.addMethod("isnatureSelect", function (value, element) {
            var natureSelect = value;

            return this.optional(element) || (natureSelect != "");
        }, "请填选择公司性质");

    </script>
</head>
<body>
<!-- #include file="include/head.html" -->
<form id="form1" runat="server">
  <!--nav-->
  <div class="navbox">
    <div class="navtab">
      <ul>
        <li><a href="index.aspx">招聘中心</a></li>
        <li class="now"><a href="companyinfomodify.aspx">我的资料</a></li>
        <li><a href="account.aspx">我的账户</a></li>
        <li><a href="server_buy.aspx">增值服务</a></li>
        <li><a href="/resume" target="_blank">最新人才库</a></li>
        <li class="search"><a href="resumesearch.aspx">简历搜索</a></li>
        <li class="add"><a href="addjobs.aspx">发布职位</a></li>
      </ul>
    </div>
  </div>
  <div class="clear"> </div>
  <!--content-->
  <div class="box">
    <!--menu-->
    <div class="mb_menu">
      <dl>
        <dt class="m1"><a href="javascript:void(0);">我的资料</a></dt>
        <dd> <a href="companyinfomodify.aspx">基本资料</a></dd>
        <dd> <a href="CompanyLicence.aspx">营业执照</a></dd>
        <dd> <a href="Companylogo.aspx">企业标志</a></dd>
        <dd> <a href="Companyphoto.aspx">企业相册</a></dd>
        <dd> <a href="linkman.aspx">联系人管理</a></dd>
        <dd> <a href="baidumap.aspx" class="now">电子地图</a></dd>
        <dd> <a href="passwordmod.aspx">密码修改</a></dd>
      </dl>
      <div class="ad200"> <img src="<%=config.templatetheme%>/images/member/ad2.gif" width="198" height="70" alt="ad2" /></div>
    </div>
    <!--right-->
    <div class="navmbs"> 您的位置： <a href="/">网站首页</a> > <a href="/hr">招聘中心</a> > 电子地图 </div>
    <div class="mbbox_r">
      <div class="tagT">
        <ul>
          <li><a href="companyinfomodify.aspx">基本资料</a></li>
          <li><a href="CompanyLicence.aspx">营业执照</a></li>
          <li><a href="Companylogo.aspx">企业标志</a></li>
          <li><a href="Companyphoto.aspx">企业相册</a></li>
          <li><a href="linkman.aspx">联系人</a></li>
          <li class="cu"><a href="baidumap.aspx">电子地图</a></li>
        </ul>
        <div class="tagTxt">
          <div class="left"> 资料完善度：</div>
          <div style="margin-top: 16px;" class="bar"> <span style="width: <%=getcomplete() %>%;"></span> </div>
          <%=getcomplete() %>%</div>
      </div>
      <div class="clear"> </div>
      <h3> <strong>企业电子地图</strong></h3>
      <div class="emap">
        <p> ◇ 填写完信息点击“搜索”自动查找企业所在地图的区域，然后点击所在的位置显示绿色按钮即标注成功，然后点击保存就生成您的企业地图了，为了求职者能通过地图找到您的招聘信息，请仔细填写</p>
        <p style="padding-top: 12px;"> <i class="left">公司名称: </i>
          <input id="companyname" name="companyname" class="input250" onmouseout="this.className='input250'"
                        onmouseover="this.className='input251'" maxlength="50" type="text" value="" runat="server" />
        </p>
        <p style="padding-top: 12px;"> <i class="left">联系电话: </i>
          <input id="tel" class="input250" maxlength="25" onmouseout="this.className='input250'"
                        onmouseover="this.className='input251'" name="tel" tabindex="4" type="text" value=""
                        runat="server" />
        </p>
        <p style="padding-top: 12px;"> <i class="left">公司地址:</i>
          <input type="text" style="float: left;" runat="server" value="" maxlength="50" onmouseout="this.className='input250'"
                        onmouseover="this.className='input251'" class="input250" name="address" id="address">
          <input type="button" value="搜 索" onclick="void(0)" id="btnCreateMap" style="float: left;
                        margin: 0 10px; width: 70px; height: 35px; padding: 0" class="select_add1">
          <asp:Button ID="btnsave" runat="server" CssClass="btn_blue" Text="保存标注" OnClick="btnsave_Click" />
        </p>
      </div>
      <div class="h5px"> </div>
      <div id="container"> </div>
      <asp:HiddenField ID="mapX" runat="server" />
      <asp:HiddenField ID="mapY" runat="server" />
      <asp:HiddenField ID="mapMsg" runat="server" />
      <asp:HiddenField ID="mapZoom" runat="server" />
      <asp:HiddenField ID="mapIsShow" runat="server" />
      <asp:HiddenField ID="hidComAddress" runat="server" />
      <asp:HiddenField ID="hidMapX" runat="server" />
      <asp:HiddenField ID="hidMapY" runat="server" />
      <br>
      <!--content-->
    </div>
    <div class="clear"> </div>
  </div>
</form>
<!-- #include file="include/foot.html" -->
</body>
</html>
